/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.UIManager;
import pcgen.core.Constants;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.PToolBar;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.filter.FilterList;
import pcgen.gui.filter.FilterNameDialog;
import pcgen.gui.filter.Filterable;
import pcgen.gui.filter.GBLPanel;
import pcgen.gui.filter.NamedFilter;
import pcgen.gui.filter.PObjectFilter;
import pcgen.gui.filter.SortedListModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.util.PropertyFactory;

final class FilterSelectDialog
extends JDialog
implements ActionListener {
    static final long serialVersionUID = -7786319324648194024L;
    private static final PObjectFilter displayOnlyFilter = new PObjectFilter(){

        public String getCategory() {
            return PropertyFactory.getString("in_demo");
        }

        public String getDescription(PlayerCharacter aPC) {
            return this.getName(aPC);
        }

        public String getName(PlayerCharacter aPC) {
            return PropertyFactory.getString("in_actTabNot");
        }

        public String toString() {
            return this.getName(Globals.getCurrentPC());
        }

        public boolean accept(PlayerCharacter aPC, PObject pObject) {
            return false;
        }
    };
    private FilterList availableList;
    private FilterList selectedList;
    private final FilterNameDialog filterNameDialog = new FilterNameDialog();
    private Filterable filterable;
    private JButton addButton;
    private JButton applyButton;
    private JButton cancelButton;
    private JButton removeButton;
    private JButton saveButton;
    private JCheckBox negateBox;
    private JRadioButton matchAllRadio;
    private JRadioButton matchAnyRadio;
    private SortedListModel availableModel;
    private SortedListModel selectedModel;
    private int maxSelected;

    FilterSelectDialog() {
        super((Frame)Globals.getRootFrame(), PropertyFactory.getString("in_filOpt"));
        this.init();
    }

    public void setFilters(List availableFilters, List selectedFilters) {
        Iterator it;
        this.availableModel.clear();
        this.selectedModel.clear();
        if (availableFilters != null) {
            it = availableFilters.iterator();
            while (it.hasNext()) {
                this.availableModel.addElement(it.next());
            }
        }
        if (selectedFilters != null) {
            it = selectedFilters.iterator();
            while (it.hasNext()) {
                this.selectedModel.addElement(it.next());
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src.equals(this.addButton)) {
            int[] indices = this.availableList.getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                this.selectedModel.addElement(this.availableModel.get(indices[i] - i));
                this.availableModel.removeElementAt(indices[i] - i);
            }
            if (this.selectedModel.size() == this.maxSelected) {
                this.addButton.setEnabled(false);
            }
        } else if (src.equals(this.removeButton)) {
            int[] indices = this.selectedList.getSelectedIndices();
            for (int i = 0; i < indices.length; ++i) {
                this.availableModel.addElement(this.selectedModel.get(indices[i] - i));
                this.selectedModel.removeElementAt(indices[i] - i);
            }
            if (this.selectedModel.size() < this.maxSelected) {
                this.addButton.setEnabled(true);
            }
        } else if (src.equals(this.applyButton)) {
            if (this.filterable != null) {
                this.storeFilters(this.filterable.getAvailableFilters(), this.filterable.getSelectedFilters());
                if (this.selectedModel.size() > 0) {
                    PToolBar.getCurrentInstance().setFilterActive();
                } else {
                    PToolBar.getCurrentInstance().setFilterInactive();
                }
                int mode = 0;
                if (this.matchAnyRadio.isSelected()) {
                    mode += 2;
                }
                if (this.negateBox.isSelected()) {
                    ++mode;
                }
                this.filterable.setFilterMode(mode);
                this.filterable.refreshFiltering();
                this.filterable = null;
            }
            this.setVisible(false);
        } else if (src.equals(this.cancelButton)) {
            this.filterable = null;
            this.setVisible(false);
        } else if (src.equals(this.saveButton)) {
            PObjectFilter filter;
            String operand;
            String string = operand = this.matchAllRadio.isSelected() ? "AND" : "OR";
            if (this.selectedModel.size() < 1) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_filterErP1") + Constants.s_LINE_SEP + PropertyFactory.getString("in_filterErP2"), PropertyFactory.getString("in_filterErWarn"), MessageType.ERROR);
                return;
            }
            if (this.selectedModel.size() == 1) {
                filter = (PObjectFilter)this.selectedModel.get(0);
            } else {
                filter = FilterFactory.createCompoundFilter((PObjectFilter)this.selectedModel.get(0), (PObjectFilter)this.selectedModel.get(1), operand);
                for (int i = 2; i < this.selectedModel.size(); ++i) {
                    filter = FilterFactory.createCompoundFilter(filter, (PObjectFilter)this.selectedModel.get(i), operand);
                }
            }
            if (this.negateBox.isSelected()) {
                filter = FilterFactory.createInverseFilter(filter);
            }
            this.filterNameDialog.setIllegalNames(this.createIllegalNamesList());
            this.filterNameDialog.setVisible(true);
            if ((this.filterNameDialog.getName() + this.filterNameDialog.getDescription()).length() > 0) {
                filter = FilterFactory.createNamedFilter(filter, this.filterNameDialog.getName(), this.filterNameDialog.getDescription());
            }
            this.clearSelectedFilters();
            this.selectedModel.addElement(filter);
        }
    }

    public void clearSelectedFilters() {
        for (int i = 0; i < this.selectedModel.size(); ++i) {
            this.availableModel.addElement(this.selectedModel.get(i));
        }
        this.selectedModel.clear();
    }

    public void setVisible(boolean b) {
        if (b) {
            this.settings(PCGen_Frame1.getCurrentFilterable());
        }
        super.setVisible(b);
    }

    private void setMode(int mode) {
        switch (mode) {
            case 0: {
                this.activateSingleSingleMode();
                break;
            }
            case 1: {
                this.activateSingleMultiMode();
                break;
            }
            case 2: {
                this.activateMultiMultiMode();
                break;
            }
            default: {
                this.activateDisplayOnlyMode();
            }
        }
    }

    private void _init() {
        GBLPanel leftPanel = new GBLPanel();
        GBLPanel middlePanel = new GBLPanel();
        GBLPanel rightPanel = new GBLPanel();
        ListMouseHandler lml = new ListMouseHandler();
        leftPanel.gbc.anchor = 18;
        leftPanel.gbc.weighty = 0.0;
        leftPanel.add(new JLabel(PropertyFactory.getString("in_availFils")), 0, 0, 1, 1);
        this.availableModel = new SortedListModel();
        this.availableList = new FilterList((ListModel)this.availableModel);
        this.availableList.setSelectionMode(0);
        this.availableList.addMouseListener(lml);
        JScrollPane availableScroll = new JScrollPane(this.availableList);
        availableScroll.setMinimumSize(new Dimension(200, 295));
        JPanel leftListPanel = new JPanel(new GridLayout(1, 1));
        leftListPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        leftListPanel.add(availableScroll);
        leftPanel.gbc.weightx = 10.0;
        leftPanel.gbc.weighty = 10.0;
        leftPanel.gbc.fill = 1;
        leftPanel.gbc.anchor = 10;
        leftPanel.add(leftListPanel, 1, 0, 1, 1);
        middlePanel.gbc.weightx = 0.0;
        middlePanel.gbc.weighty = 0.0;
        middlePanel.gbc.anchor = 18;
        middlePanel.add(new JLabel("   "), 0, 0, 1, 1);
        this.addButton = new JButton(IconUtilitities.getImageIcon("Forward16.gif"));
        this.addButton.addActionListener(this);
        this.removeButton = new JButton(IconUtilitities.getImageIcon("Back16.gif"));
        this.removeButton.addActionListener(this);
        JPanel addButtonPanel = new JPanel(new GridLayout(1, 1));
        addButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 3, 0));
        addButtonPanel.add(this.addButton);
        JPanel removeButtonPanel = new JPanel(new GridLayout(1, 1));
        removeButtonPanel.setBorder(BorderFactory.createEmptyBorder(3, 0, 0, 0));
        removeButtonPanel.add(this.removeButton);
        JPanel middleButtonPanel = new JPanel(new GridLayout(2, 1));
        middleButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 0, 5));
        middleButtonPanel.add(addButtonPanel);
        middleButtonPanel.add(removeButtonPanel);
        middlePanel.gbc.weighty = 10.0;
        middlePanel.gbc.anchor = 11;
        middlePanel.add(middleButtonPanel, 1, 0, 1, 1);
        rightPanel.gbc.weighty = 0.0;
        rightPanel.gbc.anchor = 18;
        rightPanel.add(new JLabel(PropertyFactory.getString("in_selectedFilter")), 0, 0, 1, 1);
        this.selectedModel = new SortedListModel();
        this.selectedList = new FilterList((ListModel)this.selectedModel);
        this.selectedList.setSelectionMode(0);
        this.selectedList.addMouseListener(lml);
        JScrollPane selectedScroll = new JScrollPane(this.selectedList);
        selectedScroll.setMinimumSize(new Dimension(200, 130));
        selectedScroll.setPreferredSize(new Dimension(200, 130));
        this.saveButton = new JButton(PropertyFactory.getString("in_save"));
        this.saveButton.addActionListener(this);
        JPanel saveButtonPanel = new JPanel(new GridLayout(1, 1));
        saveButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        saveButtonPanel.add(this.saveButton);
        this.matchAllRadio = new JRadioButton(PropertyFactory.getString("in_matchAll"));
        this.matchAllRadio.setEnabled(true);
        this.matchAnyRadio = new JRadioButton(PropertyFactory.getString("in_matchAny"));
        this.matchAnyRadio.setEnabled(false);
        this.negateBox = new JCheckBox(PropertyFactory.getString("in_negRev"));
        this.negateBox.setSelected(false);
        this.negateBox.setEnabled(false);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.matchAllRadio);
        bg.add(this.matchAnyRadio);
        this.matchAllRadio.setSelected(true);
        JPanel optionPanel = new JPanel(new GridLayout(3, 1));
        optionPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createCompoundBorder(BorderFactory.createCompoundBorder(BorderFactory.createLoweredBevelBorder(), BorderFactory.createRaisedBevelBorder()), BorderFactory.createEmptyBorder(0, 5, 2, 5)), PropertyFactory.getString("in_options"), 1, 2, UIManager.getFont("Label.font")));
        optionPanel.add(this.matchAllRadio);
        optionPanel.add(this.matchAnyRadio);
        optionPanel.add(this.negateBox);
        optionPanel.setPreferredSize(new Dimension(200, 130));
        optionPanel.setMinimumSize(new Dimension(200, 130));
        GBLPanel rightListPanel = new GBLPanel();
        rightListPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        rightListPanel.gbc.weightx = 0.0;
        rightListPanel.gbc.weighty = 10.0;
        rightListPanel.gbc.fill = 3;
        rightListPanel.add(selectedScroll, 0, 0, 1, 1);
        rightListPanel.gbc.weighty = 0.0;
        rightListPanel.gbc.fill = 2;
        rightListPanel.add(saveButtonPanel, 1, 0, 1, 1);
        rightListPanel.gbc.fill = 0;
        rightListPanel.add(optionPanel, 2, 0, 1, 1);
        rightPanel.gbc.weightx = 0.0;
        rightPanel.gbc.weighty = 10.0;
        rightPanel.gbc.anchor = 11;
        rightPanel.gbc.fill = 3;
        rightPanel.add(rightListPanel, 1, 0, 1, 1);
        this.applyButton = new JButton(PropertyFactory.getString("in_apply"));
        this.applyButton.addActionListener(this);
        this.cancelButton = new JButton(PropertyFactory.getString("in_cancel"));
        this.cancelButton.addActionListener(this);
        JPanel applyButtonPanel = new JPanel(new GridLayout(1, 1));
        applyButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 5));
        applyButtonPanel.add(this.applyButton);
        JPanel cancelButtonPanel = new JPanel(new GridLayout(1, 1));
        cancelButtonPanel.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 2));
        cancelButtonPanel.add(this.cancelButton);
        JPanel rightButtonPanel = new JPanel(new GridLayout(1, 2));
        rightButtonPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 0, 0));
        rightButtonPanel.add(applyButtonPanel);
        rightButtonPanel.add(cancelButtonPanel);
        rightPanel.gbc.weighty = 0.0;
        rightPanel.gbc.anchor = 11;
        rightPanel.gbc.fill = 2;
        rightPanel.add(rightButtonPanel, 2, 0, 1, 1);
        GBLPanel mainPanel = new GBLPanel();
        mainPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        mainPanel.gbc.fill = 1;
        mainPanel.gbc.anchor = 11;
        mainPanel.gbc.weighty = 10.0;
        mainPanel.gbc.weightx = 10.0;
        mainPanel.add(leftPanel, 0, 0, 1, 1);
        mainPanel.gbc.weightx = 0.0;
        mainPanel.add(middlePanel, 0, 1, 1, 1);
        mainPanel.add(rightPanel, 0, 2, 1, 1);
        JPanel contentPanel = new JPanel(new BorderLayout());
        contentPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPanel.add((Component)mainPanel, "Center");
        this.setContentPane(contentPanel);
    }

    private void activateDisplayOnlyMode() {
        this.availableModel.clear();
        this.selectedModel.clear();
        this.availableModel.addElement(displayOnlyFilter);
        this.selectedModel.addElement(displayOnlyFilter);
        this.availableList.setEnabled(false);
        this.selectedList.setEnabled(false);
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.applyButton.setEnabled(false);
        this.matchAllRadio.setSelected(true);
        this.matchAllRadio.setEnabled(false);
        this.matchAnyRadio.setEnabled(false);
        this.negateBox.setSelected(false);
        this.negateBox.setEnabled(false);
    }

    private void activateMultiMultiMode() {
        this.availableList.setSelectionMode(2);
        this.selectedList.setSelectionMode(2);
        this.maxSelected = Integer.MAX_VALUE;
    }

    private void activateSingleMultiMode() {
        this.availableList.setSelectionMode(0);
        this.selectedList.setSelectionMode(2);
        this.maxSelected = Integer.MAX_VALUE;
    }

    private void activateSingleSingleMode() {
        this.availableList.setSelectionMode(0);
        this.selectedList.setSelectionMode(0);
        this.maxSelected = 1;
    }

    private List createIllegalNamesList() {
        PObjectFilter filter;
        int i;
        ArrayList<String> illegalNames = new ArrayList<String>();
        for (i = 0; i < this.availableModel.size(); ++i) {
            filter = (PObjectFilter)this.availableModel.get(i);
            if (!(filter instanceof NamedFilter)) continue;
            illegalNames.add(filter.getName(Globals.getCurrentPC()));
        }
        for (i = 0; i < this.selectedModel.size(); ++i) {
            filter = (PObjectFilter)this.selectedModel.get(i);
            if (!(filter instanceof NamedFilter)) continue;
            illegalNames.add(filter.getName(Globals.getCurrentPC()));
        }
        Iterator it = this.filterable.getRemovedFilters().iterator();
        while (it.hasNext()) {
            filter = (PObjectFilter)it.next();
            if (!(filter instanceof NamedFilter)) continue;
            illegalNames.add(filter.getName(Globals.getCurrentPC()));
        }
        return illegalNames;
    }

    private void init() {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation(screenSize.width / 4, screenSize.height / 4);
        this.setDefaultCloseOperation(0);
        this.setModal(false);
        this._init();
        this.pack();
        this.setResizable(true);
        this.setMode(1);
    }

    private void settings(Filterable f) {
        if (f == null) {
            this.activateDisplayOnlyMode();
        } else {
            this.filterable = f;
            this.setMode(f.getSelectionMode());
            if (f.getSelectionMode() < 0) {
                return;
            }
            this.availableList.setEnabled(true);
            this.selectedList.setEnabled(true);
            this.setFilters(f.getAvailableFilters(), f.getSelectedFilters());
            this.addButton.setEnabled(this.selectedModel.size() < this.maxSelected);
            this.removeButton.setEnabled(true);
            this.applyButton.setEnabled(true);
            this.matchAllRadio.setEnabled(true);
            if (f.isMatchAnyEnabled()) {
                this.matchAnyRadio.setEnabled(true);
                if (f.getFilterMode() < 2) {
                    this.matchAllRadio.setSelected(true);
                } else {
                    this.matchAnyRadio.setSelected(true);
                }
            } else {
                this.matchAllRadio.setSelected(true);
                this.matchAnyRadio.setEnabled(false);
            }
            if (f.isNegateEnabled()) {
                this.negateBox.setEnabled(true);
                this.negateBox.setSelected(f.getFilterMode() % 2 == 1);
            } else {
                this.negateBox.setSelected(false);
                this.negateBox.setEnabled(false);
            }
        }
    }

    private void storeFilters(List availableFilters, List selectedFilters) {
        Enumeration filters;
        if (availableFilters != null) {
            availableFilters.clear();
            filters = this.availableModel.elements();
            while (filters.hasMoreElements()) {
                availableFilters.add(filters.nextElement());
            }
        }
        if (selectedFilters != null) {
            selectedFilters.clear();
            filters = this.selectedModel.elements();
            while (filters.hasMoreElements()) {
                selectedFilters.add(filters.nextElement());
            }
        }
    }

    private class ListMouseHandler
    extends MouseAdapter {
        private ListMouseHandler() {
        }

        public void mouseClicked(MouseEvent e) {
            Object src = e.getSource();
            if (e.getClickCount() == 2) {
                if (src.equals(FilterSelectDialog.this.availableList) && FilterSelectDialog.this.selectedModel.size() < FilterSelectDialog.this.maxSelected) {
                    int index = FilterSelectDialog.this.availableList.getSelectedIndex();
                    if (index > -1) {
                        FilterSelectDialog.this.selectedModel.addElement(FilterSelectDialog.this.availableModel.get(index));
                        FilterSelectDialog.this.availableModel.removeElementAt(index);
                    }
                    if (FilterSelectDialog.this.selectedModel.size() == FilterSelectDialog.this.maxSelected) {
                        FilterSelectDialog.this.addButton.setEnabled(false);
                    }
                } else if (src.equals(FilterSelectDialog.this.selectedList)) {
                    int index = FilterSelectDialog.this.selectedList.getSelectedIndex();
                    if (index > -1) {
                        FilterSelectDialog.this.availableModel.addElement(FilterSelectDialog.this.selectedModel.get(index));
                        FilterSelectDialog.this.selectedModel.removeElementAt(index);
                    }
                    if (FilterSelectDialog.this.selectedModel.size() < FilterSelectDialog.this.maxSelected) {
                        FilterSelectDialog.this.addButton.setEnabled(true);
                    }
                }
            }
        }
    }
}

