/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.gui.filter.CustomFilter;
import pcgen.gui.filter.PObjectFilter;
import pcgen.util.PropertyFactory;

final class NamedFilter
extends AbstractPObjectFilter
implements CustomFilter {
    private PObjectFilter filter;

    NamedFilter(PObjectFilter filter, String name, String description) {
        this.filter = filter;
        this.setCategory(PropertyFactory.getString("in_custom"));
        this.setName(name);
        this.setDescription(description);
    }

    public void setDescription(String d) {
        if (d.length() > 0) {
            super.setDescription(NamedFilter.normalizeNamed(d));
        } else {
            super.setDescription(this.filter != null ? this.filter.getName(Globals.getCurrentPC()) : "");
        }
    }

    public boolean accept(PlayerCharacter aPC, PObject pObject) {
        return this.filter.accept(aPC, pObject);
    }

    public String toString() {
        return this.filter.toString() + "|" + this.getName(Globals.getCurrentPC()) + "|" + this.getDescription(Globals.getCurrentPC());
    }

    void setName(String n) {
        if (n.length() > 0) {
            super.setName(n);
        } else {
            super.setName(this.filter != null ? this.filter.getName(Globals.getCurrentPC()) : "");
        }
    }

    private static String normalizeNamed(String s) {
        StringBuffer work = new StringBuffer();
        StringTokenizer tokens = new StringTokenizer(s);
        while (tokens.hasMoreTokens()) {
            work.append(tokens.nextToken()).append(" ");
        }
        return work.toString().trim();
    }
}

