/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.core.Deity;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.gui.filter.AlignmentFilter;
import pcgen.util.PropertyFactory;

final class PCAlignmentFilter
extends AlignmentFilter {
    PCAlignmentFilter() {
        this("default");
    }

    PCAlignmentFilter(String mode) {
        super(PropertyFactory.getString("in_alignLabel"), PropertyFactory.getString("in_pc"));
        this.mode = mode;
    }

    public String getCategory() {
        if ("default".equals(this.mode)) {
            return super.getCategory();
        }
        return super.getCategory() + " (" + this.mode + ")";
    }

    public String getName(PlayerCharacter aPC) {
        if (aPC != null) {
            return super.getName(aPC) + " (" + SettingsHandler.getGame().getLongAlignmentAtIndex(aPC.getAlignment()) + ")";
        }
        return super.getName(aPC);
    }

    public boolean accept(PlayerCharacter aPC, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        int alignment = aPC.getAlignment();
        if (pObject instanceof Deity) {
            String deityAlign = ((Deity)pObject).getAlignment();
            return deityAlign.equals(SettingsHandler.getGame().getShortAlignmentAtIndex(alignment)) || deityAlign.equals(SettingsHandler.getGame().getLongAlignmentAtIndex(alignment));
        }
        if (pObject instanceof PCClass) {
            return this.passesAlignmentPrereqs(pObject, alignment);
        }
        if (pObject instanceof PCTemplate) {
            return this.passesAlignmentPrereqs(pObject, alignment);
        }
        if (pObject instanceof Race) {
            return this.passesAlignmentPrereqs(pObject, alignment);
        }
        return true;
    }
}

