/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.core.Equipment;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SystemCollections;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class PCSizeFilter
extends AbstractPObjectFilter {
    PCSizeFilter() {
        super(PropertyFactory.getString("in_size"), PropertyFactory.getString("PC"));
    }

    public String getName(PlayerCharacter aPC) {
        if (aPC != null) {
            return super.getName(aPC) + " (" + SystemCollections.getSizeAdjustmentAtIndex(aPC.sizeInt()).getName() + ")";
        }
        return super.getName(aPC);
    }

    public boolean accept(PlayerCharacter aPC, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Equipment) {
            return ((Equipment)pObject).getSize().toUpperCase().equals(SystemCollections.getSizeAdjustmentAtIndex(aPC.sizeInt()).getAbbreviation());
        }
        return true;
    }
}

