/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.util.Iterator;
import java.util.StringTokenizer;
import pcgen.core.Deity;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class PantheonFilter
extends AbstractPObjectFilter {
    public static final String ALL = PropertyFactory.getString("in_allPanth");
    public static final int HIGH = 0;
    public static final int LOW = 1;
    private String pantheon;
    private int detailLevel;

    PantheonFilter(String pantheon, int argDetailLevel) {
        this.detailLevel = argDetailLevel;
        this.pantheon = this.detailLevel == 1 ? PantheonFilter.normalizePantheon(pantheon) : pantheon;
        this.pantheon = this.pantheon.equalsIgnoreCase(ALL) ? ALL : pantheon;
        this.setCategory(PropertyFactory.getString("in_pantheon") + (this.detailLevel == 1 ? " (" + PropertyFactory.getString("in_general") + ")" : " (" + PropertyFactory.getString("in_specific") + ")"));
        this.setName(this.pantheon);
        this.setDescription(this.pantheon.equalsIgnoreCase(ALL) ? PropertyFactory.getString("in_acceptPantAll") : PropertyFactory.getString("in_acceptPantOne") + pantheon + " " + PropertyFactory.getString("in_acceptPantTwo"));
    }

    public boolean accept(PlayerCharacter aPC, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Deity) {
            Deity aDeity = (Deity)pObject;
            if (this.pantheon.equals(ALL) && aDeity.getPantheonList().size() == 0) {
                return true;
            }
            Iterator it = aDeity.getPantheonList().iterator();
            while (it.hasNext()) {
                String tmp = (String)it.next();
                if (this.detailLevel == 1) {
                    tmp = PantheonFilter.normalizePantheon(tmp);
                }
                if (!this.pantheon.startsWith(tmp)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private static String normalizePantheon(String s) {
        String work = s;
        if (work.indexOf("(") > 0) {
            work = new StringTokenizer(work, "()").nextToken().trim();
        }
        return work;
    }
}

