/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.prereq.PrereqHandler;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class QualifyFilter
extends AbstractPObjectFilter {
    private static final String in_filterAccQual = PropertyFactory.getString("in_filterAccQual");
    private static final String in_filterAccQual2 = PropertyFactory.getString("in_filterAccQual2");

    QualifyFilter() {
        super(PropertyFactory.getString("in_miscel"), "Qualify");
    }

    public String getDescription(PlayerCharacter aPC) {
        return in_filterAccQual + ' ' + aPC.getName() + ' ' + in_filterAccQual2;
    }

    public boolean accept(PlayerCharacter aPC, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Deity) {
            return aPC.canSelectDeity((Deity)pObject);
        }
        if (pObject instanceof Domain) {
            return ((Domain)pObject).qualifiesForDomain(aPC);
        }
        if (pObject instanceof Equipment) {
            Equipment equip = (Equipment)pObject;
            boolean accept = PrereqHandler.passesAll(equip.getPreReqList(), aPC, equip);
            if (accept && (equip.isShield() || equip.isWeapon() || equip.isArmor())) {
                return aPC.isProficientWith(equip);
            }
            return accept;
        }
        if (pObject instanceof PCClass) {
            return ((PCClass)pObject).isQualified(aPC);
        }
        if (pObject instanceof PCTemplate) {
            return ((PCTemplate)pObject).isQualified(aPC);
        }
        return PrereqHandler.passesAll(pObject.getPreReqList(), aPC, pObject);
    }
}

