/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.util.StringTokenizer;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.spell.Spell;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class RangeFilter
extends AbstractPObjectFilter {
    private String range;

    RangeFilter(String range) {
        this.range = range;
        this.range = RangeFilter.normalizeCategory(this.range);
        this.range = RangeFilter.normalizeRange(this.range);
        this.setCategory(PropertyFactory.getString("in_range"));
        this.setName(this.range);
    }

    public boolean accept(PlayerCharacter aPC, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Spell) {
            return RangeFilter.normalizeRange(((Spell)pObject).getRange()).indexOf(this.range) > -1;
        }
        return true;
    }

    private static String normalizeCategory(String s) {
        String work = s.trim().toUpperCase();
        if (work.startsWith("CLOSE")) {
            return "Close";
        }
        if (work.startsWith("MEDIUM")) {
            return "Medium";
        }
        if (work.startsWith("LONG")) {
            return "Long";
        }
        if (work.startsWith("PERSONAL")) {
            return "Personal";
        }
        if (work.startsWith("TOUCH")) {
            return "Touch";
        }
        return s;
    }

    private static String normalizeRange(String s) {
        StringTokenizer tokens;
        StringBuffer buffer;
        String work = s.trim();
        if ("SEE TEXT".equals(work.toUpperCase())) {
            return "See text";
        }
        int ftIndex = work.indexOf("ft");
        int abbIndex = work.indexOf("'");
        while (ftIndex + abbIndex > -2) {
            if (abbIndex > -1) {
                work = work.substring(0, abbIndex) + " feet" + work.substring(abbIndex + 1);
            }
            if (ftIndex > -1) {
                int length = 2;
                if (work.indexOf("ft.") == ftIndex) {
                    length = 3;
                }
                work = work.substring(0, ftIndex) + " feet" + work.substring(ftIndex + length);
            }
            ftIndex = work.indexOf("ft");
            abbIndex = work.indexOf("'");
        }
        int plusIndex = work.indexOf("+");
        String del = "";
        if (plusIndex > -1) {
            buffer = new StringBuffer();
            tokens = new StringTokenizer(work, "+");
            while (tokens.hasMoreTokens()) {
                buffer.append(del).append(tokens.nextToken());
                del = " + ";
            }
            work = buffer.toString();
        }
        int slashIndex = work.indexOf("/");
        del = "";
        if (slashIndex > -1) {
            buffer = new StringBuffer();
            tokens = new StringTokenizer(work, "/");
            while (tokens.hasMoreTokens()) {
                buffer.append(del).append(tokens.nextToken());
                del = " / ";
            }
            work = buffer.toString();
        }
        int lvlIndex = work.indexOf("lvl");
        while (lvlIndex > -1) {
            work = work.substring(0, lvlIndex) + "level" + work.substring(lvlIndex + 3);
            lvlIndex = work.indexOf("lvl");
        }
        int touchIndex = work.indexOf("touch");
        if (touchIndex > -1) {
            buffer = new StringBuffer();
            tokens = new StringTokenizer(work, " ", true);
            while (tokens.hasMoreTokens()) {
                String tokenNew = tokens.nextToken();
                if ("touch".equals(tokenNew)) {
                    tokenNew = "Touch";
                }
                buffer.append(tokenNew);
            }
            work = buffer.toString();
        }
        if (work.length() > 0) {
            buffer = new StringBuffer();
            tokens = new StringTokenizer(work);
            while (tokens.hasMoreTokens()) {
                buffer.append(tokens.nextToken()).append(" ");
            }
            work = buffer.toString().trim();
        }
        return work;
    }
}

