/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Skill;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class RankFilter
extends AbstractPObjectFilter {
    private double min;

    RankFilter(double min) {
        super(PropertyFactory.getString("in_skills"), PropertyFactory.getString("in_rank") + " > " + min);
        this.min = min;
    }

    public boolean accept(PlayerCharacter aPC, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Skill) {
            Skill aSkill = (Skill)pObject;
            if (aPC.getSkillKeyed(aSkill.getKeyName()) != null) {
                aSkill = aPC.getSkillKeyed(aSkill.getKeyName());
            }
            return aSkill.getTotalRank(aPC).doubleValue() > this.min;
        }
        return true;
    }
}

