/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.core.Equipment;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SystemCollections;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class SizeFilter
extends AbstractPObjectFilter {
    private int size;

    SizeFilter(int size) {
        super(PropertyFactory.getString("in_size"), SystemCollections.getSizeAdjustmentAtIndex(size).getName());
        this.size = size;
    }

    public boolean accept(PlayerCharacter aPC, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Equipment) {
            String aEquipSize = ((Equipment)pObject).getSize();
            return aEquipSize.equals(SystemCollections.getSizeAdjustmentAtIndex(this.size).getAbbreviation()) || aEquipSize.equals(SystemCollections.getSizeAdjustmentAtIndex(this.size).getName());
        }
        if (pObject instanceof Race) {
            String aRaceSize = ((Race)pObject).getSize();
            return aRaceSize.equals(SystemCollections.getSizeAdjustmentAtIndex(this.size).getAbbreviation()) || aRaceSize.equals(SystemCollections.getSizeAdjustmentAtIndex(this.size).getName());
        }
        return true;
    }
}

