/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import java.util.StringTokenizer;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class SourceFilter
extends AbstractPObjectFilter {
    public static final int HIGH = 0;
    public static final int LOW = 1;
    private String source;
    private int detailLevel;

    SourceFilter(String src, int argDetailLevel) {
        this.detailLevel = argDetailLevel;
        this.source = this.detailLevel == 1 ? SourceFilter.normalizeSource(src) : src;
        int cInt = this.source.indexOf(":");
        int pInt = this.source.indexOf("|");
        if (this.source.startsWith("SOURCE") && cInt > -1 && pInt > cInt) {
            this.source = this.source.substring(cInt + 1, pInt);
        }
        this.setCategory(PropertyFactory.getString("in_sourceLabel"));
        this.setName(this.source);
        this.setDescription(PropertyFactory.getString("in_filterAccObj") + " " + this.getName(Globals.getCurrentPC()) + ".");
    }

    public boolean accept(PlayerCharacter aPC, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (this.detailLevel == 1) {
            return SourceFilter.normalizeSource(pObject.getSourceInForm(0)).equals(this.source);
        }
        return pObject.getSourceInForm(0).equals(this.source);
    }

    private static String normalizeSource(String s) {
        String work = s;
        if (work.indexOf(",") > -1) {
            work = new StringTokenizer(s, ",").nextToken();
        }
        return work.trim();
    }
}

