/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.spell.Spell;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class SpellResistanceFilter
extends AbstractPObjectFilter {
    private String sr;

    SpellResistanceFilter(String sr) {
        this.sr = SpellResistanceFilter.normalizeSpellResistance(sr);
        this.setCategory(PropertyFactory.getString("in_spellRes"));
        this.setName(this.sr);
    }

    public boolean accept(PlayerCharacter aPC, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Spell) {
            return ((Spell)pObject).getSpellResistance().indexOf(this.sr) > -1;
        }
        return true;
    }

    private static String normalizeSpellResistance(String s) {
        String work = s.trim().toUpperCase();
        if (work.startsWith("YES")) {
            return "Yes";
        }
        if (work.startsWith("NO")) {
            return "No";
        }
        return s;
    }
}

