/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.spell.Spell;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class SubschoolFilter
extends AbstractPObjectFilter {
    private String school;

    SubschoolFilter(String school) {
        this.school = SubschoolFilter.normalizeSubschool(school);
        this.setCategory(PropertyFactory.getString("in_subschool"));
        this.setName(this.school);
    }

    public boolean accept(PlayerCharacter aPC, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Spell) {
            return SubschoolFilter.normalizeSubschool(((Spell)pObject).getSubschool()).equals(this.school);
        }
        return true;
    }

    private static String normalizeSubschool(String s) {
        String work = s.trim().toUpperCase();
        if ("NO".equals(work) || "NONE".equals(work)) {
            return "None";
        }
        return s.trim();
    }
}

