/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.filter;

import pcgen.core.Equipment;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.util.PropertyFactory;

final class TypeFilter
extends AbstractPObjectFilter {
    private String type;

    TypeFilter(String argType) {
        this(argType, true);
    }

    TypeFilter(String argType, boolean capitalize) {
        super(PropertyFactory.getString("in_type"), capitalize ? argType.substring(0, 1).toUpperCase() + argType.substring(1).toLowerCase() : argType);
        this.type = argType.toUpperCase();
    }

    public boolean accept(PlayerCharacter aPC, PObject pObject) {
        if (pObject == null) {
            return false;
        }
        if (pObject instanceof Equipment) {
            return pObject.isType(this.type);
        }
        if (pObject instanceof PCClass) {
            return pObject.isType(this.type);
        }
        if (pObject instanceof Race) {
            return pObject.getType().toUpperCase().equals(this.type);
        }
        return true;
    }
}

