/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.panes;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import pcgen.gui.panes.Utilities;
import pcgen.util.PropertyFactory;

public final class FlippingSplitPane
extends JSplitPane {
    static final long serialVersionUID = -6343545558990369582L;
    private static final ImageIcon CENTER_ICON = Utilities.getImageIcon("resources/MediaStop16.gif");
    private static final ImageIcon FLIP_ICON = Utilities.getImageIcon("resources/Refresh16.gif");
    private static final ImageIcon RESET_ICON = Utilities.getImageIcon("resources/Redo16.gif");
    private static final ImageIcon LOCK_ICON = Utilities.getImageIcon("resources/Bookmarks16.gif");
    private boolean locked = false;
    private boolean wasContinuousLayout = false;

    public FlippingSplitPane() {
        this.setupExtensions();
    }

    public FlippingSplitPane(int newOrientation) {
        super(newOrientation);
        this.setupExtensions();
    }

    public FlippingSplitPane(int newOrientation, boolean newContinuousLayout) {
        super(newOrientation, newContinuousLayout);
        this.setupExtensions();
    }

    public FlippingSplitPane(int newOrientation, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newLeftComponent, newRightComponent);
        this.setupExtensions();
    }

    public FlippingSplitPane(int newOrientation, boolean newContinuousLayout, Component newLeftComponent, Component newRightComponent) {
        super(newOrientation, newContinuousLayout, newLeftComponent, newRightComponent);
        this.setupExtensions();
    }

    public void setContinuousLayout(boolean newContinuousLayout) {
        if (newContinuousLayout == this.isContinuousLayout()) {
            return;
        }
        super.setContinuousLayout(newContinuousLayout);
        FlippingSplitPane.maybeSetContinuousLayoutComponent(this.getLeftComponent(), newContinuousLayout);
        FlippingSplitPane.maybeSetContinuousLayoutComponent(this.getRightComponent(), newContinuousLayout);
    }

    public void setDividerLocation(int location) {
        if (this.isLocked()) {
            super.setDividerLocation(this.getLastDividerLocation());
        } else {
            super.setDividerLocation(location);
        }
    }

    public void setOneTouchExpandable(boolean newOneTouchExpandable) {
        if (newOneTouchExpandable == this.isOneTouchExpandable()) {
            return;
        }
        super.setOneTouchExpandable(newOneTouchExpandable);
        FlippingSplitPane.maybeSetOneTouchExpandableComponent(this.getLeftComponent(), newOneTouchExpandable);
        FlippingSplitPane.maybeSetOneTouchExpandableComponent(this.getRightComponent(), newOneTouchExpandable);
    }

    public void setOrientation(int newOrientation) {
        if (newOrientation == this.getOrientation()) {
            return;
        }
        super.setOrientation(newOrientation);
        int subOrientation = FlippingSplitPane.invertOrientation(newOrientation);
        FlippingSplitPane.maybeSetOrientationComponent(this.getLeftComponent(), subOrientation);
        FlippingSplitPane.maybeSetOrientationComponent(this.getRightComponent(), subOrientation);
    }

    public void resetToPreferredSizes() {
        this.fixedResetToPreferredSizes();
        FlippingSplitPane.maybeResetToPreferredSizesComponent(this.getLeftComponent());
        FlippingSplitPane.maybeResetToPreferredSizesComponent(this.getRightComponent());
    }

    private static void maybeCenterDividerLocationsComponent(Component c) {
        if (c instanceof FlippingSplitPane) {
            ((FlippingSplitPane)c).centerDividerLocations();
        }
    }

    private void centerDividerLocations() {
        this.setDividerLocation(0.5);
        FlippingSplitPane.maybeCenterDividerLocationsComponent(this.getLeftComponent());
        FlippingSplitPane.maybeCenterDividerLocationsComponent(this.getRightComponent());
    }

    private static void maybeResetToPreferredSizesComponent(Component c) {
        if (c instanceof FlippingSplitPane) {
            ((FlippingSplitPane)c).resetToPreferredSizes();
        }
    }

    private void fixedResetToPreferredSizes() {
        this.setDividerLocation((this.getMinimumDividerLocation() + this.getMaximumDividerLocation()) / 2);
    }

    private static int invertOrientation(int orientation) {
        return orientation == 1 ? 0 : 1;
    }

    private static void maybeFlipComponent(Component c) {
        if (c instanceof FlippingSplitPane) {
            ((FlippingSplitPane)c).flipOrientation();
        }
    }

    private void flipOrientation() {
        super.setOrientation(FlippingSplitPane.invertOrientation(this.getOrientation()));
        FlippingSplitPane.maybeFlipComponent(this.getLeftComponent());
        FlippingSplitPane.maybeFlipComponent(this.getRightComponent());
        this.resetToPreferredSizes();
    }

    private static void maybeSetContinuousLayoutComponent(Component c, boolean newContinuousLayout) {
        if (c instanceof FlippingSplitPane) {
            ((FlippingSplitPane)c).setContinuousLayout(newContinuousLayout);
        }
    }

    private static void maybeSetOneTouchExpandableComponent(Component c, boolean newOneTouchExpandable) {
        if (c instanceof FlippingSplitPane) {
            ((FlippingSplitPane)c).setOneTouchExpandable(newOneTouchExpandable);
        }
    }

    private static void maybeSetOrientationComponent(Component c, int newOrientation) {
        if (c instanceof FlippingSplitPane) {
            ((FlippingSplitPane)c).setOrientation(newOrientation);
        }
    }

    private boolean isLocked() {
        return this.locked;
    }

    private static void maybeSetLockedComponent(Component c, boolean locked) {
        if (c instanceof FlippingSplitPane) {
            ((FlippingSplitPane)c).setLocked(locked);
        }
    }

    private void setLocked(boolean locked) {
        if (locked == this.isLocked()) {
            return;
        }
        this.locked = locked;
        if (this.locked) {
            this.wasContinuousLayout = this.isContinuousLayout();
            this.setContinuousLayout(true);
        } else {
            this.setContinuousLayout(this.wasContinuousLayout);
        }
        FlippingSplitPane.maybeSetLockedComponent(this.getLeftComponent(), this.isLocked());
        FlippingSplitPane.maybeSetLockedComponent(this.getRightComponent(), this.isLocked());
    }

    private void setupExtensions() {
        SplitPaneUI ui = this.getUI();
        if (ui instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)ui).getDivider().addMouseListener(new PopupListener());
        }
        this.setResizeWeight(0.5);
    }

    private class ResetMenuItem
    extends JMenuItem {
        ResetMenuItem() {
            super(PropertyFactory.getString("in_reset"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_reset"));
            this.setIcon(RESET_ICON);
            this.addActionListener(new ResetActionListener());
        }
    }

    private class ResetActionListener
    implements ActionListener {
        private ResetActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            FlippingSplitPane.this.resetToPreferredSizes();
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (Utilities.isRightMouseButton(e)) {
                int x = e.getX();
                int y = e.getY();
                JPopupMenu popupMenu = new JPopupMenu();
                if (!FlippingSplitPane.this.isLocked()) {
                    popupMenu.add(new CenterMenuItem());
                    popupMenu.add(new FlipMenuItem());
                    popupMenu.add(new ResetMenuItem());
                    popupMenu.addSeparator();
                }
                popupMenu.add(new LockMenuItem());
                if (!FlippingSplitPane.this.isLocked()) {
                    popupMenu.addSeparator();
                    popupMenu.add(new OptionsMenu());
                }
                popupMenu.show(e.getComponent(), x, y);
            } else if (Utilities.isShiftLeftMouseButton(e) && !FlippingSplitPane.this.isLocked()) {
                FlippingSplitPane.this.flipOrientation();
            }
        }
    }

    private class OptionsMenu
    extends JMenu {
        OptionsMenu() {
            super(PropertyFactory.getString("in_options"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_options"));
            this.add(new OneTouchExpandableMenuItem());
            this.add(new ContinuousLayoutMenuItem());
        }
    }

    private class OneTouchExpandableMenuItem
    extends JCheckBoxMenuItem {
        OneTouchExpandableMenuItem() {
            super(PropertyFactory.getString("in_oneTouchExp"));
            boolean oneTouchExpandable = FlippingSplitPane.this.isOneTouchExpandable();
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_oneTouchExp"));
            this.setSelected(oneTouchExpandable);
            this.addActionListener(new OneTouchExpandableActionListener(!oneTouchExpandable));
        }
    }

    private class OneTouchExpandableActionListener
    implements ActionListener {
        private boolean oneTouchExpandable;

        OneTouchExpandableActionListener(boolean oneTouchExpandable) {
            this.oneTouchExpandable = oneTouchExpandable;
        }

        public void actionPerformed(ActionEvent e) {
            FlippingSplitPane.this.setOneTouchExpandable(this.oneTouchExpandable);
        }
    }

    private class LockMenuItem
    extends JMenuItem {
        LockMenuItem() {
            boolean locked = !FlippingSplitPane.this.isLocked();
            this.setText(locked ? PropertyFactory.getString("in_lock") : PropertyFactory.getString("in_unlock"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_lock"));
            this.setIcon(LOCK_ICON);
            this.addActionListener(new LockActionListener(locked));
        }
    }

    private class LockActionListener
    implements ActionListener {
        private boolean locked;

        LockActionListener(boolean locked) {
            this.locked = locked;
        }

        public void actionPerformed(ActionEvent e) {
            FlippingSplitPane.this.setLocked(this.locked);
        }
    }

    private class FlipMenuItem
    extends JMenuItem {
        FlipMenuItem() {
            super(PropertyFactory.getString("in_flip"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_flip"));
            this.setIcon(FLIP_ICON);
            this.addActionListener(new FlipActionListener());
        }
    }

    private class FlipActionListener
    implements ActionListener {
        private FlipActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            FlippingSplitPane.this.flipOrientation();
        }
    }

    private class ContinuousLayoutMenuItem
    extends JCheckBoxMenuItem {
        ContinuousLayoutMenuItem() {
            super(PropertyFactory.getString("in_smothRes"));
            boolean continuousLayout = FlippingSplitPane.this.isContinuousLayout();
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_smothRes"));
            this.setSelected(continuousLayout);
            this.addActionListener(new ContinuousLayoutActionListener(!continuousLayout));
        }
    }

    private class ContinuousLayoutActionListener
    implements ActionListener {
        boolean continuousLayout;

        ContinuousLayoutActionListener(boolean continuousLayout) {
            this.continuousLayout = continuousLayout;
        }

        public void actionPerformed(ActionEvent e) {
            FlippingSplitPane.this.setContinuousLayout(this.continuousLayout);
        }
    }

    private class CenterMenuItem
    extends JMenuItem {
        CenterMenuItem() {
            super(PropertyFactory.getString("in_center"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_center"));
            this.setIcon(CENTER_ICON);
            this.addActionListener(new CenterActionListener());
        }
    }

    private class CenterActionListener
    implements ActionListener {
        private CenterActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            FlippingSplitPane.this.centerDividerLocations();
        }
    }
}

