/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.panes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.plaf.TabbedPaneUI;
import pcgen.gui.panes.Utilities;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class SpinningTabbedPane
extends JTabbedPane {
    static final long serialVersionUID = 4980035692406423131L;
    private static final int PLACE_OFFSET = 0;
    private static final int MOVE_LEFT_RIGHT_OFFSET = 4;
    private static final int MOVE_UP_DOWN_OFFSET = 8;
    private static final int GROUP_OFFSET = 12;
    private static final int TAB_OFFSET = 16;
    private static final int UNGROUP_CHILD_OFFSET = 20;
    private static final int UNGROUP_SELF_OFFSET = 24;
    private static final int UNGROUP_SINGLE_OFFSET = 28;
    private static final String[] labels = new String[]{PropertyFactory.getString("in_top"), PropertyFactory.getString("in_left"), PropertyFactory.getString("in_bottom"), PropertyFactory.getString("in_right"), PropertyFactory.getString("in_beginning"), PropertyFactory.getString("in_left"), PropertyFactory.getString("in_end"), PropertyFactory.getString("in_right"), PropertyFactory.getString("in_top"), PropertyFactory.getString("in_up"), PropertyFactory.getString("in_bottom"), PropertyFactory.getString("in_down"), PropertyFactory.getString("in_up"), PropertyFactory.getString("in_left"), PropertyFactory.getString("in_down"), PropertyFactory.getString("in_right"), null, null, null, null, PropertyFactory.getString("in_ungroupTop"), PropertyFactory.getString("in_ungroupLeft"), PropertyFactory.getString("in_ungroupBottom"), PropertyFactory.getString("in_ungroupRight"), PropertyFactory.getString("in_ungroupTop"), PropertyFactory.getString("in_ungroupLeft"), PropertyFactory.getString("in_ungroupBottom"), PropertyFactory.getString("in_ungroupRight"), PropertyFactory.getString("in_ungroupUp"), PropertyFactory.getString("in_ungroupLeft"), PropertyFactory.getString("in_ungroupDown"), PropertyFactory.getString("in_ungroupRight")};
    private static final ImageIcon[] icons = new ImageIcon[]{Utilities.UP_ICON, Utilities.LEFT_ICON, Utilities.DOWN_ICON, Utilities.RIGHT_ICON, Utilities.BEGINNING_ICON, Utilities.LEFT_ICON, Utilities.END_ICON, Utilities.RIGHT_ICON, Utilities.TOP_ICON, Utilities.UP_ICON, Utilities.BOTTOM_ICON, Utilities.DOWN_ICON, Utilities.UP_ICON, Utilities.LEFT_ICON, Utilities.DOWN_ICON, Utilities.RIGHT_ICON, Utilities.UP_ICON, Utilities.LEFT_ICON, Utilities.DOWN_ICON, Utilities.RIGHT_ICON, Utilities.TOP_ICON, Utilities.BEGINNING_ICON, Utilities.BOTTOM_ICON, Utilities.END_ICON, Utilities.TOP_ICON, Utilities.BEGINNING_ICON, Utilities.BOTTOM_ICON, Utilities.END_ICON, Utilities.UP_ICON, Utilities.LEFT_ICON, Utilities.DOWN_ICON, Utilities.RIGHT_ICON};
    private static final String[] tips = new String[]{PropertyFactory.getString("in_spinTips1"), PropertyFactory.getString("in_spinTips2"), PropertyFactory.getString("in_spinTips3"), PropertyFactory.getString("in_spinTips4"), PropertyFactory.getString("in_spinTips5"), PropertyFactory.getString("in_spinTips6"), PropertyFactory.getString("in_spinTips7"), PropertyFactory.getString("in_spinTips8"), PropertyFactory.getString("in_spinTips9"), PropertyFactory.getString("in_spinTips10"), PropertyFactory.getString("in_spinTips11"), PropertyFactory.getString("in_spinTips12"), PropertyFactory.getString("in_spinTips13"), PropertyFactory.getString("in_spinTips14"), PropertyFactory.getString("in_spinTips15"), PropertyFactory.getString("in_spinTips16"), PropertyFactory.getString("in_spinTips17"), PropertyFactory.getString("in_spinTips18"), PropertyFactory.getString("in_spinTips19"), PropertyFactory.getString("in_spinTips20"), PropertyFactory.getString("in_spinTips21"), PropertyFactory.getString("in_spinTips22"), PropertyFactory.getString("in_spinTips23"), PropertyFactory.getString("in_spinTips24"), PropertyFactory.getString("in_spinTips25"), PropertyFactory.getString("in_spinTips26"), PropertyFactory.getString("in_spinTips27"), PropertyFactory.getString("in_spinTips28"), PropertyFactory.getString("in_spinTips29"), PropertyFactory.getString("in_spinTips30"), PropertyFactory.getString("in_spinTips31"), PropertyFactory.getString("in_spinTips32")};
    private PopupMenuPolicy policy = new DefaultPopupMenuPolicy();
    private Set locked = new HashSet();
    private SpinningTabbedPane parent = null;

    public SpinningTabbedPane() {
        this.addMouseListener(new PopupListener());
    }

    public final void setTabPlacement(int placement) {
        super.setTabPlacement(placement);
        if (this.parent != null) {
            this.parent.updateTabUIAt(this.parent.indexOfComponent(this));
        }
    }

    public final void setTitleAt(int index, String title) {
        String extra = this.getExtraTitleAt(index);
        if (extra != null) {
            title = title == null || title.length() == 0 ? extra : title + " " + extra;
        }
        super.setTitleAt(index, title);
    }

    public final int indexAtLocation(int x, int y) {
        if (this.ui != null) {
            return ((TabbedPaneUI)this.ui).tabForCoordinate(this, x, y);
        }
        return -1;
    }

    private static void setMenuItem(JMenuItem menuItem, int offset) {
        String label = labels[offset];
        menuItem.setText(label);
        if (label != null) {
            menuItem.setMnemonic(label.charAt(0));
        }
        menuItem.setIcon(icons[offset]);
        menuItem.setToolTipText(tips[offset]);
    }

    private static final SpinningTabbedPane createPane() {
        return new SpinningTabbedPane();
    }

    private static int offsetForPlacement(int placement) {
        return placement - 1;
    }

    private static int placementForSlot(int slot, int placement) {
        return (placement - 1 + slot) % 4 + 1;
    }

    private final String getExtraTitleAt(int index) {
        Component c = this.getComponentAt(index);
        return c instanceof SpinningTabbedPane ? "(" + ((SpinningTabbedPane)c).getSpinTabCount() + ")" : null;
    }

    private final int getMovableTabCount() {
        int n = 0;
        int x = this.getTabCount();
        for (int i = 0; i < x; ++i) {
            if (!this.policy.canMove(i) || this.isTabLockedAt(i)) continue;
            ++n;
        }
        return n;
    }

    private final int[] getMovableTabIndices() {
        int x = this.getTabCount();
        int[] list1 = new int[x];
        int n = 0;
        for (int i = 0; i < x; ++i) {
            if (!this.policy.canMove(i) || this.isTabLockedAt(i)) continue;
            list1[n++] = i;
        }
        int[] list2 = new int[n];
        for (int i = 0; i < n; ++i) {
            list2[i] = list1[i];
        }
        return list2;
    }

    private final String getPlainTitleAt(int index) {
        String title = this.getTitleAt(index);
        Component c = this.getComponentAt(index);
        if (title == null) {
            return "";
        }
        if (title.length() == 0 || !(c instanceof SpinningTabbedPane)) {
            return title;
        }
        String extra = this.getExtraTitleAt(index);
        if (title.length() == extra.length()) {
            return "";
        }
        return title.substring(0, title.length() - extra.length() - 1);
    }

    private final int getSpinTabCount() {
        int n = this.getTabCount();
        int x = n;
        for (int i = 0; i < x; ++i) {
            Component c = this.getComponentAt(i);
            if (!(c instanceof SpinningTabbedPane)) continue;
            --n;
            n += ((SpinningTabbedPane)c).getSpinTabCount();
        }
        return n;
    }

    private final int getSpinTabPlacementAt(int index) {
        Component c = this.getComponentAt(index);
        if (c instanceof SpinningTabbedPane) {
            return ((SpinningTabbedPane)c).getTabPlacement();
        }
        return -1;
    }

    private final boolean isTabLockedAt(int index) {
        return this.locked.contains(this.getComponentAt(index));
    }

    private final void addNewTab() {
        this.add(new JPanel());
    }

    private final void lockTabAt(int index) {
        this.locked.add(this.getComponentAt(index));
        this.setIconAt(index, Utilities.LOCK_ICON);
    }

    private final void spinTabsAt(int index, int placement) {
        Component c;
        SpinningTabbedPane pane = SpinningTabbedPane.createPane();
        this.moveTabAtTo(index, -1, pane);
        int x = this.getTabCount();
        for (int i = index; i < x && !((c = this.getComponentAt(index)) instanceof SpinningTabbedPane); ++i) {
            this.moveTabAtTo(index, -1, pane);
        }
        this.add((Component)pane, index);
        this.setTitleAt(index, "");
        pane.parent = this;
        pane.setTabPlacement(placement);
        this.updateTabUIAt(index);
    }

    private final void unlockTabAt(int index) {
        this.locked.remove(this.getComponentAt(index));
        this.setIconAt(index, null);
    }

    private final void unspinAll() {
        int parentIndex = this.parent.indexOfComponent(this);
        this.parent.removeTabAt(parentIndex);
        int x = this.getTabCount();
        while (--x >= 0) {
            this.moveTabAtTo(x, parentIndex, this.parent);
        }
        this.parent = null;
    }

    private final void unspinTabAt(int index) {
        if (this.getTabCount() == 1) {
            this.unspinAll();
        } else {
            int parentIndex = this.parent.indexOfComponent(this);
            this.moveTabAtTo(index, parentIndex, this.parent);
            this.parent.updateTabUIAt(parentIndex + 1);
        }
    }

    private void moveTabAtTo(int fromIndex, int toIndex, JTabbedPane to) {
        Component c = this.getComponentAt(fromIndex);
        if (c instanceof SpinningTabbedPane) {
            ((SpinningTabbedPane)c).parent = this;
        }
        Color background = this.getBackgroundAt(fromIndex);
        Icon disabledIcon = this.getDisabledIconAt(fromIndex);
        Color foreground = this.getForegroundAt(fromIndex);
        Icon icon = this.getIconAt(fromIndex);
        String title = this.getTitleAt(fromIndex);
        String tip = this.getToolTipTextAt(fromIndex);
        this.removeTabAt(fromIndex);
        if (toIndex == -1) {
            toIndex = to.getTabCount();
        }
        to.add(c, toIndex);
        to.setBackgroundAt(toIndex, background);
        to.setDisabledIconAt(toIndex, disabledIcon);
        to.setForegroundAt(toIndex, foreground);
        to.setIconAt(toIndex, icon);
        to.setTitleAt(toIndex, title);
        to.setToolTipTextAt(toIndex, tip);
    }

    private void updateTabUIAt(int index) {
        SpinningTabbedPane pane = (SpinningTabbedPane)this.getComponentAt(index);
        int offset = SpinningTabbedPane.offsetForPlacement(pane.getTabPlacement()) + 16;
        this.setTitleAt(index, this.getPlainTitleAt(index));
        this.setIconAt(index, icons[offset]);
        this.setToolTipTextAt(index, tips[offset]);
    }

    private class UnlockMenuItem
    extends JMenuItem {
        UnlockMenuItem(int index) {
            super(PropertyFactory.getString("in_unlock"));
            this.addActionListener(new UnlockActionListener(index));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_unlock"));
            this.setIcon(Utilities.LOCK_ICON);
        }
    }

    private class UnlockActionListener
    implements ActionListener {
        private int index;

        UnlockActionListener(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            SpinningTabbedPane.this.unlockTabAt(this.index);
        }
    }

    private class UngroupSingleMenuItem
    extends JMenuItem {
        UngroupSingleMenuItem(int index) {
            int offset = SpinningTabbedPane.offsetForPlacement(SpinningTabbedPane.this.parent.getTabPlacement()) + 28;
            this.addActionListener(new UngroupSingleActionListener(index));
            SpinningTabbedPane.setMenuItem(this, offset);
        }
    }

    private class UngroupSingleActionListener
    implements ActionListener {
        private int index;

        UngroupSingleActionListener(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            SpinningTabbedPane.this.unspinTabAt(this.index);
            SpinningTabbedPane.this.parent.setSelectedIndex(SpinningTabbedPane.this.parent.indexOfComponent(SpinningTabbedPane.this) - 1);
        }
    }

    private class UngroupSelfMenuItem
    extends JMenuItem {
        UngroupSelfMenuItem() {
            int offset = SpinningTabbedPane.offsetForPlacement(SpinningTabbedPane.this.parent.getTabPlacement()) + 24;
            this.addActionListener(new UngroupSelfActionListener());
            SpinningTabbedPane.setMenuItem(this, offset);
        }
    }

    private class UngroupSelfActionListener
    implements ActionListener {
        private UngroupSelfActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            int index = SpinningTabbedPane.this.parent.indexOfComponent(SpinningTabbedPane.this);
            int newIndex = SpinningTabbedPane.this.getSelectedIndex();
            SpinningTabbedPane parent = SpinningTabbedPane.this.parent;
            SpinningTabbedPane.this.unspinAll();
            parent.setSelectedIndex(index + newIndex);
        }
    }

    private class UngroupChildMenuItem
    extends JMenuItem {
        UngroupChildMenuItem(int index) {
            int offset = SpinningTabbedPane.offsetForPlacement(SpinningTabbedPane.this.getTabPlacement()) + 20;
            this.addActionListener(new UngroupChildActionListener(index));
            SpinningTabbedPane.setMenuItem(this, offset);
        }
    }

    private class UngroupChildActionListener
    implements ActionListener {
        private int index;

        UngroupChildActionListener(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            SpinningTabbedPane pane = (SpinningTabbedPane)SpinningTabbedPane.this.getComponentAt(this.index);
            int newIndex = pane.getSelectedIndex();
            pane.unspinAll();
            SpinningTabbedPane.this.setSelectedIndex(this.index + newIndex);
        }
    }

    private class RenameMenuItem
    extends JMenuItem {
        RenameMenuItem(int index, MouseEvent e) {
            super(PropertyFactory.getString("in_rename") + "...");
            this.addActionListener(new RenameActionListener(index, e));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_rename"));
        }
    }

    private class RenameActionListener
    implements ActionListener {
        private MouseEvent mouseEvent;
        private int index;

        RenameActionListener(int index, MouseEvent mouseEvent) {
            this.index = index;
            this.mouseEvent = mouseEvent;
        }

        public void actionPerformed(ActionEvent e) {
            int x = this.mouseEvent.getX();
            int y = this.mouseEvent.getY();
            JPopupMenu popupMenu = new JPopupMenu();
            String title = SpinningTabbedPane.this.getPlainTitleAt(this.index);
            JTextField textField = new JTextField(title);
            Logging.errorPrint("document? " + textField.getDocument());
            textField.addActionListener(new RenameTextFieldActionListener(this.index, textField, popupMenu));
            popupMenu.add(textField);
            Component c = this.mouseEvent.getComponent();
            popupMenu.show(c, x, y);
            textField.selectAll();
            textField.setCaretPosition(title.length());
            Component pane = SpinningTabbedPane.this.getComponentAt(this.index);
            Point paneLocation = pane.getLocationOnScreen();
            Point popupLocation = popupMenu.getLocationOnScreen();
            Dimension paneSize = pane.getSize();
            Dimension popupSize = popupMenu.getSize();
            boolean reshow = false;
            if (popupLocation.x + popupSize.width >= paneLocation.x + paneSize.width) {
                reshow = true;
                x = paneLocation.x + paneSize.width - popupSize.width - 1;
            }
            if (popupLocation.y + popupSize.height >= paneLocation.y + paneSize.height) {
                reshow = true;
                y = paneLocation.y + paneSize.height - popupSize.height - 1;
            }
            if (reshow) {
                popupMenu.show(c, x, y);
            }
        }

        private class RenameTextFieldActionListener
        implements ActionListener {
            private JPopupMenu popupMenu;
            private JTextField textField;
            private int index;

            RenameTextFieldActionListener(int index, JTextField textField, JPopupMenu popupMenu) {
                this.index = index;
                this.textField = textField;
                this.popupMenu = popupMenu;
            }

            public void actionPerformed(ActionEvent e) {
                SpinningTabbedPane.this.setTitleAt(this.index, this.textField.getText());
                this.popupMenu.setVisible(false);
            }
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (Utilities.isRightMouseButton(e)) {
                boolean usePlaceMenu;
                int x = e.getX();
                int y = e.getY();
                int index = SpinningTabbedPane.this.indexAtLocation(x, y);
                int tabPlacement = SpinningTabbedPane.this.getTabPlacement();
                JPopupMenu popupMenu = new JPopupMenu();
                NewMenuItem newMenuItem = null;
                CloseMenuItem closeMenuItem = null;
                JMenuItem lockMenuItem = null;
                RenameMenuItem renameMenuItem = null;
                JMenu groupMenu = null;
                JMenu moveMenu = null;
                PlaceMenu placeMenu = null;
                if (SpinningTabbedPane.this.policy.canNew(index)) {
                    newMenuItem = new NewMenuItem(index);
                }
                if (index >= 0) {
                    int spinTabPlacement = SpinningTabbedPane.this.getSpinTabPlacementAt(index);
                    if (SpinningTabbedPane.this.policy.canClose(index) && !SpinningTabbedPane.this.isTabLockedAt(index)) {
                        closeMenuItem = new CloseMenuItem(index);
                    }
                    if (SpinningTabbedPane.this.policy.canLock(index)) {
                        JMenuItem jMenuItem = lockMenuItem = SpinningTabbedPane.this.isTabLockedAt(index) ? new UnlockMenuItem(index) : new LockMenuItem(index);
                    }
                    if (SpinningTabbedPane.this.policy.canRename(index)) {
                        renameMenuItem = new RenameMenuItem(index, e);
                    }
                    if (SpinningTabbedPane.this.policy.hasGroupMenu(index, e) && !SpinningTabbedPane.this.isTabLockedAt(index)) {
                        groupMenu = new GroupMenu(index, spinTabPlacement == -1 ? tabPlacement : spinTabPlacement);
                    }
                    if (SpinningTabbedPane.this.policy.hasMoveMenu(index, e) && SpinningTabbedPane.this.getMovableTabCount() > 1 && !SpinningTabbedPane.this.isTabLockedAt(index)) {
                        moveMenu = new MoveMenu(index);
                    }
                }
                if (SpinningTabbedPane.this.policy.hasPlaceMenu(index, e)) {
                    placeMenu = new PlaceMenu(tabPlacement);
                }
                boolean useNewMenuItem = newMenuItem != null;
                boolean useCloseMenuItem = closeMenuItem != null;
                boolean useLockMenuItem = lockMenuItem != null;
                boolean useRenameMenuItem = renameMenuItem != null;
                boolean useGroupMenu = groupMenu != null && groupMenu.getMenuComponentCount() > 0;
                boolean useMoveMenu = moveMenu != null && moveMenu.getMenuComponentCount() > 0;
                boolean bl = usePlaceMenu = placeMenu != null && placeMenu.getMenuComponentCount() > 0;
                if (popupMenu.getComponentCount() > 0 && (useNewMenuItem || useCloseMenuItem)) {
                    popupMenu.addSeparator();
                }
                if (useNewMenuItem) {
                    popupMenu.add(newMenuItem);
                }
                if (useCloseMenuItem) {
                    popupMenu.add(closeMenuItem);
                }
                if (popupMenu.getComponentCount() > 0 && (useLockMenuItem || useRenameMenuItem)) {
                    popupMenu.addSeparator();
                }
                if (useLockMenuItem) {
                    popupMenu.add(lockMenuItem);
                }
                if (useRenameMenuItem) {
                    popupMenu.add(renameMenuItem);
                }
                if (popupMenu.getComponentCount() > 0 && (useGroupMenu || useMoveMenu || usePlaceMenu)) {
                    popupMenu.addSeparator();
                }
                if (useGroupMenu) {
                    popupMenu.add(groupMenu);
                }
                if (useMoveMenu) {
                    popupMenu.add(moveMenu);
                }
                if (usePlaceMenu) {
                    popupMenu.add(placeMenu);
                }
                popupMenu.show(e.getComponent(), x, y);
            } else if (Utilities.isShiftLeftMouseButton(e)) {
                int index = SpinningTabbedPane.this.indexAtLocation(e.getX(), e.getY());
                SpinningTabbedPane.this.spinTabsAt(index, SpinningTabbedPane.placementForSlot(3, SpinningTabbedPane.this.getTabPlacement()));
                SpinningTabbedPane.this.setSelectedIndex(index);
            }
        }
    }

    private class PlaceMenuItem
    extends JMenuItem {
        PlaceMenuItem(SpinningTabbedPane pane, int placement) {
            int offset = SpinningTabbedPane.offsetForPlacement(placement) + 0;
            this.addActionListener(new PlaceActionListener(pane, placement));
            SpinningTabbedPane.setMenuItem(this, offset);
        }
    }

    private class PlaceMenu
    extends JMenu {
        PlaceMenu(int placement) {
            super(PropertyFactory.getString("in_placeTabs"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_placeTabs"));
            for (int j = 3; j > 0; --j) {
                this.add(new PlaceMenuItem(SpinningTabbedPane.this, SpinningTabbedPane.placementForSlot(j, placement)));
            }
        }
    }

    private class PlaceActionListener
    implements ActionListener {
        private SpinningTabbedPane pane;
        private int placement;

        PlaceActionListener(SpinningTabbedPane pane, int placement) {
            this.pane = pane;
            this.placement = placement;
        }

        public void actionPerformed(ActionEvent e) {
            this.pane.setTabPlacement(this.placement);
        }
    }

    private class NewMenuItem
    extends JMenuItem {
        NewMenuItem(int index) {
            super(PropertyFactory.getString("in_new"));
            this.addActionListener(new NewActionListener(index));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_new"));
            this.setIcon(Utilities.NEW_ICON);
        }
    }

    private class NewActionListener
    implements ActionListener {
        int index;

        NewActionListener(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            SpinningTabbedPane.this.addNewTab();
        }
    }

    private class MoveTabMenuItem
    extends JMenuItem {
        MoveTabMenuItem(int index, int placement) {
            int offset = SpinningTabbedPane.offsetForPlacement(placement);
            switch (SpinningTabbedPane.this.getTabPlacement()) {
                case 1: 
                case 3: {
                    offset += 4;
                    break;
                }
                case 2: 
                case 4: {
                    offset += 8;
                }
            }
            this.addActionListener(new MoveActionListener(index, placement));
            SpinningTabbedPane.setMenuItem(this, offset);
        }
    }

    private class MoveMenu
    extends JMenu {
        MoveMenu(int index) {
            super(PropertyFactory.getString("in_moveTab"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_movetab"));
            int[] indices = SpinningTabbedPane.this.getMovableTabIndices();
            int primum = -1;
            int secundum = -1;
            int penultimatum = -1;
            int ultimatum = -1;
            switch (indices.length) {
                case 0: {
                    this.setEnabled(false);
                    break;
                }
                case 1: {
                    this.setEnabled(false);
                    break;
                }
                case 2: {
                    primum = indices[0];
                    secundum = Integer.MAX_VALUE;
                    penultimatum = Integer.MIN_VALUE;
                    ultimatum = indices[1];
                    break;
                }
                case 3: {
                    primum = indices[0];
                    secundum = penultimatum = indices[1];
                    ultimatum = indices[2];
                }
                default: {
                    primum = indices[0];
                    secundum = indices[1];
                    penultimatum = indices[indices.length - 2];
                    ultimatum = indices[indices.length - 1];
                }
            }
            for (int i = 0; i < indices.length; ++i) {
                if (index < indices[i]) continue;
                if (index > primum) {
                    if (index > secundum) {
                        this.add(new MoveTabMenuItem(index, 1));
                    }
                    this.add(new MoveTabMenuItem(index, 2));
                }
                if (index >= ultimatum) break;
                this.add(new MoveTabMenuItem(index, 4));
                if (index >= penultimatum) break;
                this.add(new MoveTabMenuItem(index, 3));
                break;
            }
        }
    }

    private class MoveActionListener
    implements ActionListener {
        int index;
        int placement;

        MoveActionListener(int index, int placement) {
            this.index = index;
            this.placement = placement;
        }

        public void actionPerformed(ActionEvent e) {
            int[] indices = SpinningTabbedPane.this.getMovableTabIndices();
            int i = -1;
            switch (this.placement) {
                case 1: {
                    i = indices[0];
                    break;
                }
                case 2: {
                    i = this.previous(this.index, indices);
                    break;
                }
                case 3: {
                    i = indices[indices.length - 1];
                    break;
                }
                case 4: {
                    i = this.next(this.index, indices);
                }
            }
            SpinningTabbedPane.this.moveTabAtTo(this.index, i, SpinningTabbedPane.this);
            SpinningTabbedPane.this.setSelectedIndex(i);
        }

        private int next(int current, int[] indices) {
            int x = indices.length - 1;
            for (int i = 0; i < x; ++i) {
                if (current != indices[i]) continue;
                return indices[i + 1];
            }
            return -1;
        }

        private int previous(int current, int[] indices) {
            for (int i = 1; i < indices.length; ++i) {
                if (current != indices[i]) continue;
                return indices[i - 1];
            }
            return -1;
        }
    }

    private class LockMenuItem
    extends JMenuItem {
        LockMenuItem(int index) {
            super(PropertyFactory.getString("in_lock"));
            this.addActionListener(new LockActionListener(index));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_lock"));
            this.setIcon(Utilities.LOCK_ICON);
        }
    }

    private class LockActionListener
    implements ActionListener {
        private int index;

        LockActionListener(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            SpinningTabbedPane.this.lockTabAt(this.index);
        }
    }

    private class GroupMenuItem
    extends JMenuItem {
        GroupMenuItem(int index, int placement) {
            int offset = SpinningTabbedPane.offsetForPlacement(placement) + 12;
            this.addActionListener(new GroupActionListener(index, placement));
            SpinningTabbedPane.setMenuItem(this, offset);
        }
    }

    private class GroupMenu
    extends JMenu {
        GroupMenu(int index, int placement) {
            super(PropertyFactory.getString("in_groupTabs"));
            int j;
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_groupTabs"));
            Component c = SpinningTabbedPane.this.getComponentAt(index);
            boolean first = true;
            if (SpinningTabbedPane.this.parent == null) {
                if (c instanceof SpinningTabbedPane) {
                    this.add(new UngroupChildMenuItem(index));
                    this.addSeparator();
                    for (j = 3; j > 0; --j) {
                        this.add(new PlaceMenuItem((SpinningTabbedPane)c, SpinningTabbedPane.placementForSlot(j, placement)));
                    }
                    first = false;
                }
            } else {
                this.add(new UngroupSelfMenuItem());
                if (c instanceof SpinningTabbedPane) {
                    this.add(new UngroupChildMenuItem(index));
                } else {
                    this.add(new UngroupSingleMenuItem(index));
                }
                first = false;
            }
            if (SpinningTabbedPane.this.policy.canGroup(index)) {
                if (!first) {
                    this.addSeparator();
                }
                for (j = 4; j > 0; --j) {
                    this.add(new GroupMenuItem(index, SpinningTabbedPane.placementForSlot(j, placement)));
                }
            }
        }
    }

    private class GroupActionListener
    implements ActionListener {
        private int index;
        private int placement;

        GroupActionListener(int index, int placement) {
            this.index = index;
            this.placement = placement;
        }

        public void actionPerformed(ActionEvent e) {
            SpinningTabbedPane.this.spinTabsAt(this.index, this.placement);
            SpinningTabbedPane.this.setSelectedIndex(this.index);
        }
    }

    private class CloseMenuItem
    extends JMenuItem {
        CloseMenuItem(int index) {
            super(PropertyFactory.getString("in_close"));
            this.addActionListener(new CloseActionListener(index));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_close"));
            this.setIcon(Utilities.CLOSE_ICON);
        }
    }

    private class CloseActionListener
    implements ActionListener {
        private int index;

        CloseActionListener(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            SpinningTabbedPane.this.removeTabAt(this.index);
        }
    }

    private final class DefaultPopupMenuPolicy
    implements PopupMenuPolicy {
        private DefaultPopupMenuPolicy() {
        }

        public boolean canClose(int index) {
            return true;
        }

        public boolean canGroup(int index) {
            return true;
        }

        public boolean canLock(int index) {
            return true;
        }

        public boolean canMove(int index) {
            return true;
        }

        public boolean canNew(int index) {
            return true;
        }

        public boolean canRename(int index) {
            return true;
        }

        public boolean hasGroupMenu(int index, MouseEvent e) {
            return true;
        }

        public boolean hasMoveMenu(int index, MouseEvent e) {
            return true;
        }

        public boolean hasPlaceMenu(int index, MouseEvent e) {
            return true;
        }
    }

    public static interface PopupMenuPolicy {
        public boolean canClose(int var1);

        public boolean canGroup(int var1);

        public boolean canLock(int var1);

        public boolean canMove(int var1);

        public boolean canNew(int var1);

        public boolean canRename(int var1);

        public boolean hasGroupMenu(int var1, MouseEvent var2);

        public boolean hasMoveMenu(int var1, MouseEvent var2);

        public boolean hasPlaceMenu(int var1, MouseEvent var2);
    }
}

