/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.panes;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.plaf.SplitPaneUI;
import javax.swing.plaf.basic.BasicSplitPaneUI;
import pcgen.gui.panes.Utilities;
import pcgen.util.PropertyFactory;

final class SplitPane
extends JSplitPane {
    static final long serialVersionUID = 7077400429448626205L;

    public SplitPane() {
        this.setupExtensions();
    }

    public void setContinuousLayout(boolean newContinuousLayout) {
        if (newContinuousLayout == this.isContinuousLayout()) {
            return;
        }
        super.setContinuousLayout(newContinuousLayout);
        SplitPane.maybeSetContinuousLayoutComponent(this.getLeftComponent(), newContinuousLayout);
        SplitPane.maybeSetContinuousLayoutComponent(this.getRightComponent(), newContinuousLayout);
    }

    public void setEnabled(boolean enabled) {
        SplitPane.maybeSetEnabledComponent(this.getLeftComponent(), enabled);
        SplitPane.maybeSetEnabledComponent(this.getRightComponent(), enabled);
        super.setEnabled(enabled);
    }

    public void setOneTouchExpandable(boolean newOneTouchExpandable) {
        if (newOneTouchExpandable == this.isOneTouchExpandable()) {
            return;
        }
        super.setOneTouchExpandable(newOneTouchExpandable);
        SplitPane.maybeSetOneTouchExpandableComponent(this.getLeftComponent(), newOneTouchExpandable);
        SplitPane.maybeSetOneTouchExpandableComponent(this.getRightComponent(), newOneTouchExpandable);
    }

    public void setOrientation(int newOrientation) {
        if (newOrientation == this.getOrientation()) {
            return;
        }
        super.setOrientation(newOrientation);
        int subOrientation = SplitPane.invertOrientation(newOrientation);
        SplitPane.maybeSetOrientationComponent(this.getLeftComponent(), subOrientation);
        SplitPane.maybeSetOrientationComponent(this.getRightComponent(), subOrientation);
    }

    public void resetToPreferredSizes() {
        SplitPane.maybeResetToPreferredSizesComponent(this.getLeftComponent());
        SplitPane.maybeResetToPreferredSizesComponent(this.getRightComponent());
        this.fixedResetToPreferredSizes();
    }

    private static void maybeCenterDividerLocationsComponent(Component c) {
        if (c instanceof SplitPane) {
            ((SplitPane)c).centerDividerLocations();
        }
    }

    private double getDividerProportion(int orientation) {
        Component c1 = this.getLeftComponent();
        Component c2 = this.getRightComponent();
        double n1 = c1 instanceof SplitPane ? (double)((SplitPane)c1).getPaneCount(orientation) : 1.0;
        double n2 = c2 instanceof SplitPane ? (double)((SplitPane)c2).getPaneCount(orientation) : 1.0;
        return n1 / (n1 + n2);
    }

    private int getPaneCount(int orientation) {
        SplitPane pane;
        Component c1 = this.getLeftComponent();
        Component c2 = this.getRightComponent();
        int n1 = c1 instanceof SplitPane ? ((pane = (SplitPane)c1).getOrientation() == orientation ? pane.getPaneCount(orientation) : 1) : 1;
        int n2 = c2 instanceof SplitPane ? ((pane = (SplitPane)c2).getOrientation() == orientation ? pane.getPaneCount(orientation) : 1) : 1;
        return n1 + n2;
    }

    private void centerDividerLocations() {
        this.setDividerLocation(this.getDividerProportion(this.getOrientation()));
        SplitPane.maybeCenterDividerLocationsComponent(this.getLeftComponent());
        SplitPane.maybeCenterDividerLocationsComponent(this.getRightComponent());
    }

    private static void maybeFlipComponent(Component c) {
        if (c instanceof SplitPane) {
            ((SplitPane)c).flipOrientation();
        }
    }

    private static void maybeResetToPreferredSizesComponent(Component c) {
        if (c instanceof SplitPane) {
            ((SplitPane)c).resetToPreferredSizes();
        }
    }

    private void fixedResetToPreferredSizes() {
        this.setDividerLocation((this.getMinimumDividerLocation() + this.getMaximumDividerLocation()) / 2);
    }

    private static int invertOrientation(int orientation) {
        return orientation == 1 ? 0 : 1;
    }

    private void flipOrientation() {
        super.setOrientation(SplitPane.invertOrientation(this.getOrientation()));
        SplitPane.maybeFlipComponent(this.getLeftComponent());
        SplitPane.maybeFlipComponent(this.getRightComponent());
        this.resetToPreferredSizes();
    }

    private static void maybeSetContinuousLayoutComponent(Component c, boolean newContinuousLayout) {
        if (c instanceof SplitPane) {
            ((SplitPane)c).setContinuousLayout(newContinuousLayout);
        }
    }

    private static void maybeSetEnabledComponent(Component c, boolean enabled) {
        if (c instanceof SplitPane) {
            c.setEnabled(enabled);
        }
    }

    private static void maybeSetOneTouchExpandableComponent(Component c, boolean newOneTouchExpandable) {
        if (c instanceof SplitPane) {
            ((SplitPane)c).setOneTouchExpandable(newOneTouchExpandable);
        }
    }

    private static void maybeSetOrientationComponent(Component c, int newOrientation) {
        if (c instanceof SplitPane) {
            ((SplitPane)c).setOrientation(newOrientation);
        }
    }

    private void setupExtensions() {
        SplitPaneUI ui = this.getUI();
        if (ui instanceof BasicSplitPaneUI) {
            ((BasicSplitPaneUI)ui).getDivider().addMouseListener(new PopupListener());
        }
        this.setResizeWeight(0.5);
    }

    private class ResetMenuItem
    extends JMenuItem {
        ResetMenuItem() {
            super(PropertyFactory.getString("in_reset"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_reset"));
            this.setIcon(Utilities.RESET_ICON);
            this.addActionListener(new ResetActionListener());
        }
    }

    private class ResetActionListener
    implements ActionListener {
        private ResetActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SplitPane.this.resetToPreferredSizes();
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (Utilities.isRightMouseButton(e)) {
                int x = e.getX();
                int y = e.getY();
                JPopupMenu popupMenu = new JPopupMenu();
                if (SplitPane.this.isEnabled()) {
                    popupMenu.add(new CenterMenuItem());
                    popupMenu.add(new FlipMenuItem());
                    popupMenu.add(new ResetMenuItem());
                    popupMenu.addSeparator();
                }
                popupMenu.add(new LockMenuItem());
                if (SplitPane.this.isEnabled()) {
                    popupMenu.addSeparator();
                    popupMenu.add(new OptionsMenu());
                }
                popupMenu.show(e.getComponent(), x, y);
            } else if (Utilities.isShiftLeftMouseButton(e) && SplitPane.this.isEnabled()) {
                SplitPane.this.flipOrientation();
            }
        }
    }

    private class OptionsMenu
    extends JMenu {
        OptionsMenu() {
            super(PropertyFactory.getString("in_options"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_options"));
            this.add(new OneTouchExpandableMenuItem());
            this.add(new ContinuousLayoutMenuItem());
        }
    }

    private class OneTouchExpandableMenuItem
    extends JCheckBoxMenuItem {
        OneTouchExpandableMenuItem() {
            super(PropertyFactory.getString("in_oneTouchExp"));
            boolean oneTouchExpandable = SplitPane.this.isOneTouchExpandable();
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_oneTouchExp"));
            this.setSelected(oneTouchExpandable);
            this.addActionListener(new OneTouchExpandableActionListener(!oneTouchExpandable));
        }
    }

    private class OneTouchExpandableActionListener
    implements ActionListener {
        private boolean oneTouchExpandable;

        OneTouchExpandableActionListener(boolean oneTouchExpandable) {
            this.oneTouchExpandable = oneTouchExpandable;
        }

        public void actionPerformed(ActionEvent e) {
            SplitPane.this.setOneTouchExpandable(this.oneTouchExpandable);
        }
    }

    private class LockMenuItem
    extends JMenuItem {
        LockMenuItem() {
            boolean enabled = !SplitPane.this.isEnabled();
            this.setText(enabled ? PropertyFactory.getString("in_unlock") : PropertyFactory.getString("in_lock"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_lock"));
            this.setIcon(Utilities.LOCK_ICON);
            this.addActionListener(new LockActionListener(enabled));
        }
    }

    private class LockActionListener
    implements ActionListener {
        private boolean enabled;

        LockActionListener(boolean enabled) {
            this.enabled = enabled;
        }

        public void actionPerformed(ActionEvent e) {
            SplitPane.this.setEnabled(this.enabled);
        }
    }

    private class FlipMenuItem
    extends JMenuItem {
        FlipMenuItem() {
            super(PropertyFactory.getString("in_flip"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_flip"));
            this.setIcon(Utilities.FLIP_ICON);
            this.addActionListener(new FlipActionListener());
        }
    }

    private class FlipActionListener
    implements ActionListener {
        private FlipActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SplitPane.this.flipOrientation();
        }
    }

    private class ContinuousLayoutMenuItem
    extends JCheckBoxMenuItem {
        ContinuousLayoutMenuItem() {
            super(PropertyFactory.getString("in_smothRes"));
            boolean continuousLayout = SplitPane.this.isContinuousLayout();
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_smothRes"));
            this.setSelected(continuousLayout);
            this.addActionListener(new ContinuousLayoutActionListener(!continuousLayout));
        }
    }

    private class ContinuousLayoutActionListener
    implements ActionListener {
        private boolean continuousLayout;

        ContinuousLayoutActionListener(boolean continuousLayout) {
            this.continuousLayout = continuousLayout;
        }

        public void actionPerformed(ActionEvent e) {
            SplitPane.this.setContinuousLayout(this.continuousLayout);
        }
    }

    private class CenterMenuItem
    extends JMenuItem {
        CenterMenuItem() {
            super(PropertyFactory.getString("in_center"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_center"));
            this.setIcon(Utilities.CENTER_ICON);
            this.addActionListener(new CenterActionListener());
        }
    }

    private class CenterActionListener
    implements ActionListener {
        private CenterActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            SplitPane.this.centerDividerLocations();
        }
    }
}

