/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.panes;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.plaf.TabbedPaneUI;
import pcgen.gui.panes.Utilities;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class TabbedPane
extends JTabbedPane {
    static final long serialVersionUID = 2185939737510098609L;
    private static final int PLACE_OFFSET = 0;
    private static final int MOVE_LEFT_RIGHT_OFFSET = 4;
    private static final int MOVE_UP_DOWN_OFFSET = 8;
    private static final String[] labels = new String[]{PropertyFactory.getString("in_top"), PropertyFactory.getString("in_left"), PropertyFactory.getString("in_bottom"), PropertyFactory.getString("in_right"), PropertyFactory.getString("in_beginning"), PropertyFactory.getString("in_left"), PropertyFactory.getString("in_end"), PropertyFactory.getString("in_right"), PropertyFactory.getString("in_top"), PropertyFactory.getString("in_up"), PropertyFactory.getString("in_bottom"), PropertyFactory.getString("in_down")};
    private static final ImageIcon[] icons = new ImageIcon[]{Utilities.UP_ICON, Utilities.LEFT_ICON, Utilities.DOWN_ICON, Utilities.RIGHT_ICON, Utilities.BEGINNING_ICON, Utilities.LEFT_ICON, Utilities.END_ICON, Utilities.RIGHT_ICON, Utilities.TOP_ICON, Utilities.UP_ICON, Utilities.BOTTOM_ICON, Utilities.DOWN_ICON};
    private static final String[] tips = new String[]{PropertyFactory.getString("in_tabTips1"), PropertyFactory.getString("in_tabTips2"), PropertyFactory.getString("in_tabTips3"), PropertyFactory.getString("in_tabTips4"), PropertyFactory.getString("in_tabTips5"), PropertyFactory.getString("in_tabTips6"), PropertyFactory.getString("in_tabTips7"), PropertyFactory.getString("in_tabTips8"), PropertyFactory.getString("in_tabTips9"), PropertyFactory.getString("in_tabTips10"), PropertyFactory.getString("in_tabTips11"), PropertyFactory.getString("in_tabTips12")};
    private PopupMenuPolicy policy = new DefaultPopupMenuPolicy();
    private Set locked = new HashSet();

    public TabbedPane() {
        this.addMouseListener(new PopupListener());
    }

    public final int indexAtLocation(int x, int y) {
        if (this.ui == null) {
            return -1;
        }
        return ((TabbedPaneUI)this.ui).tabForCoordinate(this, x, y);
    }

    private static void setMenuItem(JMenuItem menuItem, int offset) {
        String label = labels[offset];
        menuItem.setText(label);
        if (label != null) {
            menuItem.setMnemonic(label.charAt(0));
        }
        menuItem.setIcon(icons[offset]);
        menuItem.setToolTipText(tips[offset]);
    }

    private static int offsetForPlacement(int placement) {
        return placement - 1;
    }

    private static int placementForSlot(int slot, int placement) {
        return (placement - 1 + slot) % 4 + 1;
    }

    private final int getMovableTabCount() {
        int n = 0;
        int x = this.getTabCount();
        for (int i = 0; i < x; ++i) {
            if (!this.policy.canMove(i) || this.isTabLockedAt(i)) continue;
            ++n;
        }
        return n;
    }

    private final int[] getMovableTabIndices() {
        int x = this.getTabCount();
        int[] list1 = new int[x];
        int n = 0;
        for (int i = 0; i < x; ++i) {
            if (!this.policy.canMove(i) || this.isTabLockedAt(i)) continue;
            list1[n++] = i;
        }
        int[] list2 = new int[n];
        for (int i = 0; i < n; ++i) {
            list2[i] = list1[i];
        }
        return list2;
    }

    private final boolean isTabLockedAt(int index) {
        return this.locked.contains(this.getComponentAt(index));
    }

    private void addNewTab() {
        this.add(new JPanel());
    }

    private final void lockTabAt(int index) {
        this.locked.add(this.getComponentAt(index));
        this.setIconAt(index, Utilities.LOCK_ICON);
    }

    private final void unlockTabAt(int index) {
        this.locked.remove(this.getComponentAt(index));
        this.setIconAt(index, null);
    }

    private void moveTabAtTo(int fromIndex, int toIndex, JTabbedPane to) {
        Component c = this.getComponentAt(fromIndex);
        Color background = this.getBackgroundAt(fromIndex);
        Icon disabledIcon = this.getDisabledIconAt(fromIndex);
        Color foreground = this.getForegroundAt(fromIndex);
        Icon icon = this.getIconAt(fromIndex);
        String title = this.getTitleAt(fromIndex);
        String tip = this.getToolTipTextAt(fromIndex);
        this.removeTabAt(fromIndex);
        if (toIndex == -1) {
            toIndex = to.getTabCount();
        }
        to.add(c, toIndex);
        to.setBackgroundAt(toIndex, background);
        to.setDisabledIconAt(toIndex, disabledIcon);
        to.setForegroundAt(toIndex, foreground);
        to.setIconAt(toIndex, icon);
        to.setTitleAt(toIndex, title);
        to.setToolTipTextAt(toIndex, tip);
    }

    private class UnlockMenuItem
    extends JMenuItem {
        UnlockMenuItem(int index) {
            super(PropertyFactory.getString("in_unlock"));
            this.addActionListener(new UnlockActionListener(index));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_unlock"));
            this.setIcon(Utilities.LOCK_ICON);
        }
    }

    private class UnlockActionListener
    implements ActionListener {
        private int index;

        UnlockActionListener(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            TabbedPane.this.unlockTabAt(this.index);
        }
    }

    private class RenameMenuItem
    extends JMenuItem {
        RenameMenuItem(int index, MouseEvent e) {
            super(PropertyFactory.getString("in_rename") + "...");
            this.addActionListener(new RenameActionListener(index, e));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_rename"));
        }
    }

    private class RenameActionListener
    implements ActionListener {
        private MouseEvent mouseEvent;
        private int index;

        RenameActionListener(int index, MouseEvent mouseEvent) {
            this.index = index;
            this.mouseEvent = mouseEvent;
        }

        public void actionPerformed(ActionEvent e) {
            int x = this.mouseEvent.getX();
            int y = this.mouseEvent.getY();
            JPopupMenu popupMenu = new JPopupMenu();
            String title = TabbedPane.this.getTitleAt(this.index);
            JTextField textField = new JTextField(title);
            Logging.errorPrint("document? " + textField.getDocument());
            textField.addActionListener(new RenameTextFieldActionListener(this.index, textField, popupMenu));
            popupMenu.add(textField);
            Component c = this.mouseEvent.getComponent();
            popupMenu.show(c, x, y);
            textField.selectAll();
            textField.setCaretPosition(title.length());
            Component pane = TabbedPane.this.getComponentAt(this.index);
            Point paneLocation = pane.getLocationOnScreen();
            Point popupLocation = popupMenu.getLocationOnScreen();
            Dimension paneSize = pane.getSize();
            Dimension popupSize = popupMenu.getSize();
            boolean reshow = false;
            if (popupLocation.x + popupSize.width >= paneLocation.x + paneSize.width) {
                reshow = true;
                x = paneLocation.x + paneSize.width - popupSize.width - 1;
            }
            if (popupLocation.y + popupSize.height >= paneLocation.y + paneSize.height) {
                reshow = true;
                y = paneLocation.y + paneSize.height - popupSize.height - 1;
            }
            if (reshow) {
                popupMenu.show(c, x, y);
            }
        }

        private class RenameTextFieldActionListener
        implements ActionListener {
            private JPopupMenu popupMenu;
            private JTextField textField;
            private int index;

            RenameTextFieldActionListener(int index, JTextField textField, JPopupMenu popupMenu) {
                this.index = index;
                this.textField = textField;
                this.popupMenu = popupMenu;
            }

            public void actionPerformed(ActionEvent e) {
                TabbedPane.this.setTitleAt(this.index, this.textField.getText());
                this.popupMenu.setVisible(false);
            }
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (Utilities.isRightMouseButton(e)) {
                boolean usePlaceMenu;
                int x = e.getX();
                int y = e.getY();
                int index = TabbedPane.this.indexAtLocation(x, y);
                int tabPlacement = TabbedPane.this.getTabPlacement();
                JPopupMenu popupMenu = new JPopupMenu();
                NewMenuItem newMenuItem = null;
                CloseMenuItem closeMenuItem = null;
                JMenuItem lockMenuItem = null;
                RenameMenuItem renameMenuItem = null;
                JMenu moveMenu = null;
                PlaceMenu placeMenu = null;
                if (TabbedPane.this.policy.canNew(index)) {
                    newMenuItem = new NewMenuItem(index);
                }
                if (index >= 0) {
                    if (TabbedPane.this.policy.canClose(index) && !TabbedPane.this.isTabLockedAt(index)) {
                        closeMenuItem = new CloseMenuItem(index);
                    }
                    if (TabbedPane.this.policy.canLock(index)) {
                        JMenuItem jMenuItem = lockMenuItem = TabbedPane.this.isTabLockedAt(index) ? new UnlockMenuItem(index) : new LockMenuItem(index);
                    }
                    if (TabbedPane.this.policy.canRename(index)) {
                        renameMenuItem = new RenameMenuItem(index, e);
                    }
                    if (TabbedPane.this.policy.hasMoveMenu(index, e) && TabbedPane.this.getMovableTabCount() > 1 && !TabbedPane.this.isTabLockedAt(index)) {
                        moveMenu = new MoveMenu(index);
                    }
                }
                if (TabbedPane.this.policy.hasPlaceMenu(index, e)) {
                    placeMenu = new PlaceMenu(tabPlacement);
                }
                boolean useNewMenuItem = newMenuItem != null;
                boolean useCloseMenuItem = closeMenuItem != null;
                boolean useLockMenuItem = lockMenuItem != null;
                boolean useRenameMenuItem = renameMenuItem != null;
                boolean useMoveMenu = moveMenu != null && moveMenu.getMenuComponentCount() > 0;
                boolean bl = usePlaceMenu = placeMenu != null && placeMenu.getMenuComponentCount() > 0;
                if (popupMenu.getComponentCount() > 0 && (useNewMenuItem || useCloseMenuItem)) {
                    popupMenu.addSeparator();
                }
                if (useNewMenuItem) {
                    popupMenu.add(newMenuItem);
                }
                if (useCloseMenuItem) {
                    popupMenu.add(closeMenuItem);
                }
                if (popupMenu.getComponentCount() > 0 && (useLockMenuItem || useRenameMenuItem)) {
                    popupMenu.addSeparator();
                }
                if (useLockMenuItem) {
                    popupMenu.add(lockMenuItem);
                }
                if (useRenameMenuItem) {
                    popupMenu.add(renameMenuItem);
                }
                if (popupMenu.getComponentCount() > 0 && (useMoveMenu || usePlaceMenu)) {
                    popupMenu.addSeparator();
                }
                if (useMoveMenu) {
                    popupMenu.add(moveMenu);
                }
                if (usePlaceMenu) {
                    popupMenu.add(placeMenu);
                }
                popupMenu.show(e.getComponent(), x, y);
            }
        }
    }

    private class PlaceMenuItem
    extends JMenuItem {
        PlaceMenuItem(TabbedPane pane, int placement) {
            int offset = TabbedPane.offsetForPlacement(placement) + 0;
            this.addActionListener(new PlaceActionListener(pane, placement));
            TabbedPane.setMenuItem(this, offset);
        }
    }

    private class PlaceMenu
    extends JMenu {
        PlaceMenu(int placement) {
            super(PropertyFactory.getString("in_placeTabs"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_placeTabs"));
            for (int j = 3; j > 0; --j) {
                this.add(new PlaceMenuItem(TabbedPane.this, TabbedPane.placementForSlot(j, placement)));
            }
        }
    }

    private static class PlaceActionListener
    implements ActionListener {
        private TabbedPane pane;
        private int placement;

        PlaceActionListener(TabbedPane pane, int placement) {
            this.pane = pane;
            this.placement = placement;
        }

        public void actionPerformed(ActionEvent e) {
            this.pane.setTabPlacement(this.placement);
        }
    }

    private class NewMenuItem
    extends JMenuItem {
        NewMenuItem(int index) {
            super(PropertyFactory.getString("in_new"));
            this.addActionListener(new NewActionListener());
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_new"));
            this.setIcon(Utilities.NEW_ICON);
        }
    }

    private class NewActionListener
    implements ActionListener {
        NewActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            TabbedPane.this.addNewTab();
        }
    }

    private class MoveTabMenuItem
    extends JMenuItem {
        MoveTabMenuItem(int index, int placement) {
            int offset = TabbedPane.offsetForPlacement(placement);
            switch (TabbedPane.this.getTabPlacement()) {
                case 1: 
                case 3: {
                    offset += 4;
                    break;
                }
                case 2: 
                case 4: {
                    offset += 8;
                }
            }
            this.addActionListener(new MoveActionListener(index, placement));
            TabbedPane.setMenuItem(this, offset);
        }
    }

    private class MoveMenu
    extends JMenu {
        MoveMenu(int index) {
            super(PropertyFactory.getString("in_moveTab"));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_moveTab"));
            int[] indices = TabbedPane.this.getMovableTabIndices();
            int primum = -1;
            int secundum = -1;
            int penultimatum = -1;
            int ultimatum = -1;
            switch (indices.length) {
                case 0: {
                    this.setEnabled(false);
                    break;
                }
                case 1: {
                    this.setEnabled(false);
                    break;
                }
                case 2: {
                    primum = indices[0];
                    secundum = Integer.MAX_VALUE;
                    penultimatum = Integer.MIN_VALUE;
                    ultimatum = indices[1];
                    break;
                }
                case 3: {
                    primum = indices[0];
                    secundum = penultimatum = indices[1];
                    ultimatum = indices[2];
                }
                default: {
                    primum = indices[0];
                    secundum = indices[1];
                    penultimatum = indices[indices.length - 2];
                    ultimatum = indices[indices.length - 1];
                }
            }
            for (int i = 0; i < indices.length; ++i) {
                if (index < indices[i]) continue;
                if (index > primum) {
                    if (index > secundum) {
                        this.add(new MoveTabMenuItem(index, 1));
                    }
                    this.add(new MoveTabMenuItem(index, 2));
                }
                if (index >= ultimatum) break;
                this.add(new MoveTabMenuItem(index, 4));
                if (index >= penultimatum) break;
                this.add(new MoveTabMenuItem(index, 3));
                break;
            }
        }
    }

    private class MoveActionListener
    implements ActionListener {
        int index;
        int placement;

        MoveActionListener(int index, int placement) {
            this.index = index;
            this.placement = placement;
        }

        public void actionPerformed(ActionEvent e) {
            int[] indices = TabbedPane.this.getMovableTabIndices();
            int i = -1;
            switch (this.placement) {
                case 1: {
                    i = indices[0];
                    break;
                }
                case 2: {
                    i = this.previous(this.index, indices);
                    break;
                }
                case 3: {
                    i = indices[indices.length - 1];
                    break;
                }
                case 4: {
                    i = this.next(this.index, indices);
                }
            }
            TabbedPane.this.moveTabAtTo(this.index, i, TabbedPane.this);
            TabbedPane.this.setSelectedIndex(i);
        }

        private int next(int current, int[] indices) {
            int x = indices.length - 1;
            for (int i = 0; i < x; ++i) {
                if (current != indices[i]) continue;
                return indices[i + 1];
            }
            return -1;
        }

        private int previous(int current, int[] indices) {
            for (int i = 1; i < indices.length; ++i) {
                if (current != indices[i]) continue;
                return indices[i - 1];
            }
            return -1;
        }
    }

    private class LockMenuItem
    extends JMenuItem {
        LockMenuItem(int index) {
            super(PropertyFactory.getString("in_lock"));
            this.addActionListener(new LockActionListener(index));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_lock"));
            this.setIcon(Utilities.LOCK_ICON);
        }
    }

    private class LockActionListener
    implements ActionListener {
        private int index;

        LockActionListener(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            TabbedPane.this.lockTabAt(this.index);
        }
    }

    private class CloseMenuItem
    extends JMenuItem {
        CloseMenuItem(int index) {
            super(PropertyFactory.getString("in_close"));
            this.addActionListener(new CloseActionListener(index));
            this.setMnemonic(PropertyFactory.getMnemonic("in_mn_close"));
            this.setIcon(Utilities.CLOSE_ICON);
        }
    }

    private class CloseActionListener
    implements ActionListener {
        private int index;

        CloseActionListener(int index) {
            this.index = index;
        }

        public void actionPerformed(ActionEvent e) {
            TabbedPane.this.removeTabAt(this.index);
        }
    }

    private final class DefaultPopupMenuPolicy
    implements PopupMenuPolicy {
        private DefaultPopupMenuPolicy() {
        }

        public boolean canClose(int index) {
            return true;
        }

        public boolean canLock(int index) {
            return true;
        }

        public boolean canMove(int index) {
            return true;
        }

        public boolean canNew(int index) {
            return true;
        }

        public boolean canRename(int index) {
            return true;
        }

        public boolean hasMoveMenu(int index, MouseEvent evt) {
            return true;
        }

        public boolean hasPlaceMenu(int index, MouseEvent evt) {
            return true;
        }
    }

    public static interface PopupMenuPolicy {
        public boolean canClose(int var1);

        public boolean canLock(int var1);

        public boolean canMove(int var1);

        public boolean canNew(int var1);

        public boolean canRename(int var1);

        public boolean hasMoveMenu(int var1, MouseEvent var2);

        public boolean hasPlaceMenu(int var1, MouseEvent var2);
    }
}

