/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Observer;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.UIManager;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.party.Party;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.MessageWrapper;
import pcgen.core.utils.ShowMessageConsoleObserver;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.HPFrame;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.SplashScreen;
import pcgen.gui.TipOfTheDay;
import pcgen.gui.UIFactory;
import pcgen.gui.utils.Hyperactive;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.ShowMessageGuiObserver;
import pcgen.gui.utils.Utility;
import pcgen.io.ExportHandler;
import pcgen.util.InputFactory;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;

public class pcGenGUI {
    private static SplashScreen splash;
    private static String templateName;
    private static String inFileName;
    private static String outFileName;
    private static boolean partyMode;
    private static String[] startupArgs;
    private static HPFrame hpFrame;
    private PCGen_Frame1 frame;
    private boolean packFrame = false;

    public pcGenGUI() {
        Dimension d = null;
        try {
            if (SettingsHandler.getFirstRun() && Globals.getUseGUI()) {
                pcGenGUI.hideSplashScreen();
                this.askFileLocation();
            }
            SettingsHandler.readOptionsProperties();
            d = SettingsHandler.getOptionsFromProperties(Globals.getCurrentPC());
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            String message = e.getMessage();
            if (message == null || message.length() == 0) {
                message = "Unknown error whilst reading options.ini";
            }
            message = message + "\n\nIt MAY be possible to fix this problem by deleting your options.ini file.";
            ShowMessageDelegate.showMessageDialog(new MessageWrapper(message, "PCGen - Error processing Options.ini", MessageType.ERROR));
            if (Globals.getUseGUI()) {
                pcGenGUI.hideSplashScreen();
            }
            System.exit(0);
        }
        if (System.getProperty("os.name").equals("Mac OS X")) {
            System.setProperty("com.apple.mrj.application.growbox.intrudes", "false");
            System.setProperty("com.apple.mrj.application.live-resize", "false");
            System.setProperty("com.apple.macos.smallTabs", "true");
            System.setProperty("apple.laf.useScreenMenuBar", "true");
        }
        if (!Globals.getUseGUI()) {
            this.runNonGui();
            return;
        }
        this.frame = new PCGen_Frame1();
        this.frame.setMainClass(this);
        if (this.packFrame) {
            this.frame.pack();
        } else {
            this.frame.validate();
        }
        int x = -11;
        int y = -11;
        if (SettingsHandler.getLeftUpperCorner() != null) {
            x = (int)SettingsHandler.getLeftUpperCorner().getX();
            y = (int)SettingsHandler.getLeftUpperCorner().getY();
        }
        if (x < -10 || y < -10 || d.height == 0 || d.width == 0) {
            Utility.centerFrame(this.frame, false);
        } else {
            this.frame.setLocation(x, y);
            this.frame.setSize(d);
        }
        int windowState = SettingsHandler.getWindowState();
        if (windowState != 0) {
            this.frame.setExtendedState(windowState);
        }
        UIFactory.initLookAndFeel();
        this.processStartupArgs();
        pcGenGUI.hideSplashScreen();
        SettingsHandler.readGUIOptionsProperties();
        Utility.handleToolTipShownStateChange();
        PCGen_Frame1.enableDisableMenuItems();
        this.frame.setVisible(true);
        if (SettingsHandler.getShowTipOfTheDay()) {
            pcGenGUI.showTipOfTheDay();
        }
    }

    private void runNonGui() {
        boolean loaded = this.runNonGuiLoad(new File(inFileName));
        if (loaded) {
            this.runNonGuiExport();
        }
    }

    private void runNonGuiExport() {
        try {
            BufferedWriter bw = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFileName), "UTF-8"));
            File template = new File(templateName);
            if (partyMode) {
                SettingsHandler.setSelectedPartyHTMLOutputSheet(template.getAbsolutePath());
                new ExportHandler(template).write(Globals.getPCList(), bw);
            } else {
                SettingsHandler.setSelectedCharacterHTMLOutputSheet(template.getAbsolutePath(), Globals.getCurrentPC());
                new ExportHandler(template).write(Globals.getCurrentPC(), bw);
            }
            bw.close();
        }
        catch (Exception ex) {
            Logging.errorPrint("Exception in writing", ex);
        }
        Globals.executePostExportCommand(outFileName);
    }

    private boolean runNonGuiLoad(File file) {
        boolean loaded = false;
        Party party = partyMode ? Party.makePartyFromFile(file) : Party.makeSingleCharacterParty(file);
        if (!party.load(null)) {
            ShowMessageDelegate.showMessageDialog(new MessageWrapper("Problems occurred while loading the file:" + file.getName(), "Error", MessageType.ERROR));
        } else {
            loaded = true;
        }
        return loaded;
    }

    public static void main(String[] args) {
        templateName = System.getProperty("pcgen.templatefile");
        inFileName = System.getProperty("pcgen.inputfile");
        outFileName = System.getProperty("pcgen.outputfile");
        startupArgs = args;
        if (inFileName != null && templateName != null && outFileName != null) {
            partyMode = inFileName.endsWith(".pcp");
            Globals.setUseGUI(false);
        }
        Observer messageObserver = null;
        if (Globals.getUseGUI()) {
            messageObserver = new ShowMessageGuiObserver();
            ChooserFactory.setInterfaceClassname("pcgen.gui.utils.SwingChooser");
            ChooserFactory.setRadioInterfaceClassname("pcgen.gui.utils.SwingChooserRadio");
            InputFactory.setInterfaceClassname("pcgen.gui.utils.DialogInputInterface");
        } else {
            messageObserver = new ShowMessageConsoleObserver();
        }
        ShowMessageDelegate.getInstance().addObserver(messageObserver);
        try {
            String sVersion = System.getProperty("java.version");
            if (Double.valueOf(Globals.javaVersion.substring(0, 3)) < 1.3) {
                ShowMessageDelegate.showMessageDialog(new MessageWrapper("PCGen requires Java 2 v1.3.\nYour version of java is currently " + sVersion + ".\n" + "To be able to run PCGen properly you will need:\n" + " * The Java 2 v1.3 runtime environment available from\n" + "   http://java.sun.com/j2se/1.3/jre/\n\n" + "You'll need to pick the version of java appropriate for your\n" + "OS (the choices are Solaris/SPARC, Linux and Windows).", "PCGen", MessageType.INFORMATION));
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (Globals.getUseGUI()) {
                if (args.length > 0 && args[0].equals("-j")) {
                    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                } else {
                    UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
                }
            }
        }
        catch (Exception e) {
            Logging.errorPrint("Couldn't set look and feel", e);
        }
        if (Globals.getUseGUI()) {
            pcGenGUI.showSplashScreen();
        }
        new pcGenGUI();
    }

    public static void showHpFrame(PlayerCharacter aPC) {
        pcGenGUI.initHpFrame(aPC);
        hpFrame.setPSize();
        hpFrame.pack();
        hpFrame.setVisible(true);
    }

    public static void showLicense() {
        String aString = " ";
        aString = aString + pcGenGUI.readTextFromFile(SettingsHandler.getPcgenSystemDir() + File.separator + "opengaminglicense.10a.txt");
        if (Globals.getSection15() != null) {
            aString = aString + Globals.getSection15().toString();
        }
        pcGenGUI.showLicense("OGL License 1.0a", aString);
    }

    public static void showLicense(String title, List fileList) {
        Iterator i = fileList.iterator();
        while (i.hasNext()) {
            String fileName = (String)i.next();
            String fileText = null;
            fileText = fileName.startsWith("file:/") ? pcGenGUI.readTextFromFile(fileName.substring(6)) : pcGenGUI.readTextFromFile(Globals.getDefaultPath() + File.separator + (String)i.next());
            pcGenGUI.showLicense(title, fileText);
        }
    }

    public static void showLicense(String title, String text) {
        if (title == null) {
            title = "OGL License 1.0a";
        }
        if (text == null) {
            text = "No license information found";
        }
        final JFrame aFrame = new JFrame(title);
        JButton jClose = new JButton("Close");
        JPanel jPanel = new JPanel();
        final JCheckBox jCheckBox = new JCheckBox("Show on source load");
        jPanel.add(jCheckBox);
        jCheckBox.setSelected(SettingsHandler.showLicense());
        jCheckBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                SettingsHandler.setShowLicense(jCheckBox.isSelected());
            }
        });
        jPanel.add(jClose);
        jClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                aFrame.dispose();
            }
        });
        IconUtilitities.maybeSetIcon(aFrame, "PcgenIcon.gif");
        JEditorPane a = new JEditorPane("text/html", text);
        a.setEditable(false);
        JScrollPane aPane = new JScrollPane();
        aPane.setViewportView(a);
        aFrame.getContentPane().setLayout(new BorderLayout());
        aFrame.getContentPane().add((Component)aPane, "Center");
        aFrame.getContentPane().add((Component)jPanel, "South");
        aFrame.setSize(new Dimension(700, 500));
        Utility.centerFrame(aFrame, false);
        aFrame.setVisible(true);
    }

    public static void showMandatoryD20Info() {
        ImageIcon imgIcon = IconUtilitities.getImageIcon("D20_logo_RGB.jpg");
        if (imgIcon != null) {
            final JFrame aFrame = new JFrame("D20 Required Information");
            IconUtilitities.maybeSetIcon(aFrame, "PcgenIcon.gif");
            JPanel jPanel1 = new JPanel();
            JPanel jPanel2 = new JPanel();
            JPanel jPanel3 = new JPanel();
            JLabel jLabel1 = new JLabel(imgIcon);
            final JCheckBox jCheckBox1 = new JCheckBox("Show on source load");
            JButton jClose = new JButton("Close");
            jPanel1.add(jLabel1);
            jPanel2.setLayout(new BorderLayout());
            aFrame.getContentPane().add((Component)jPanel1, "North");
            aFrame.getContentPane().add((Component)jPanel2, "Center");
            aFrame.getContentPane().add((Component)jPanel3, "South");
            String d20License = pcGenGUI.readTextFromFile(SettingsHandler.getPcgenSystemDir() + File.separator + "D20System.htm");
            JEditorPane a = new JEditorPane("text/html", d20License);
            a.setEditable(false);
            a.addHyperlinkListener(new Hyperactive());
            JScrollPane aPane = new JScrollPane();
            aPane.setViewportView(a);
            jPanel2.add((Component)aPane, "Center");
            jPanel3.add(jCheckBox1);
            jPanel3.add(jClose);
            jCheckBox1.setSelected(SettingsHandler.showD20Info());
            jClose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    aFrame.dispose();
                }
            });
            jCheckBox1.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent evt) {
                    SettingsHandler.setShowD20Info(jCheckBox1.isSelected());
                }
            });
            aFrame.setSize(new Dimension(456, 352));
            Utility.centerFrame(aFrame, false);
            aFrame.setVisible(true);
        }
    }

    public static void showTipOfTheDay() {
        new TipOfTheDay().setVisible(true);
    }

    private void askFileLocation() {
        Object[] oOk = new Object[]{"OK"};
        JLabel aLabel = new JLabel("<html>Select a directory to store PCGen options in:<hr><b>PCGen Dir</b>: This is the directory that PCGen is installed into (default)<br><b>Home Dir</b>: This is your home directory<br><b>Select</b>: Select a directory to use <br>If you have an existing options.ini file, then select the directory containing that file<hr>");
        JPanel aPanel = new JPanel();
        JPanel bPanel = new JPanel();
        JPanel cPanel = new JPanel(new BorderLayout());
        JPanel allPanel = new JPanel(new BorderLayout());
        ButtonGroup rGroup = new ButtonGroup();
        JRadioButton rPButton = new JRadioButton("PCGen Dir", true);
        JRadioButton rUButton = new JRadioButton("Home Dir");
        JRadioButton rSButton = new JRadioButton("Select a directory");
        final JTextField textField = new JTextField(String.valueOf(SettingsHandler.getPcgenFilesDir()));
        textField.setEditable(false);
        textField.setMinimumSize(new Dimension(90, 25));
        final JButton dirButton = new JButton("...");
        dirButton.setEnabled(false);
        rGroup.add(rPButton);
        rGroup.add(rUButton);
        rGroup.add(rSButton);
        aPanel.add(aLabel);
        bPanel.add(rPButton);
        bPanel.add(rUButton);
        cPanel.add((Component)rSButton, "North");
        rPButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SettingsHandler.setFilePaths("pcgen");
                textField.setText(System.getProperty("user.dir"));
            }
        });
        rUButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SettingsHandler.setFilePaths("user");
                textField.setText(System.getProperty("user.home") + File.separator + ".pcgen");
            }
        });
        rSButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SettingsHandler.setFilePaths("select");
                dirButton.setEnabled(true);
            }
        });
        dirButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                File returnFile = SettingsHandler.getPcgenFilesDir();
                JFileChooser fc = returnFile == null ? new JFileChooser() : new JFileChooser(returnFile);
                fc.setFileSelectionMode(1);
                int rVal = fc.showOpenDialog(null);
                if (rVal == 0) {
                    returnFile = fc.getSelectedFile();
                }
                textField.setText(String.valueOf(returnFile));
                SettingsHandler.setPcgenFilesDir(returnFile);
            }
        });
        cPanel.add((Component)textField, "Center");
        cPanel.add((Component)dirButton, "East");
        allPanel.setSize(new Dimension(400, 200));
        allPanel.add((Component)aPanel, "North");
        allPanel.add((Component)bPanel, "Center");
        allPanel.add((Component)cPanel, "South");
        Object[] message = new Object[]{allPanel};
        JOptionPane.showOptionDialog(null, message, "Directory for options.ini location", -1, 1, null, oOk, oOk[0]);
    }

    private static void hideSplashScreen() {
        if (splash != null) {
            splash.dispose();
            splash = null;
        }
    }

    private static void initHpFrame(PlayerCharacter aPC) {
        if (hpFrame == null) {
            hpFrame = new HPFrame();
        }
        hpFrame.setCharacter(aPC);
    }

    private boolean processStartupArgs() {
        boolean status = true;
        for (int i = 0; i < startupArgs.length; ++i) {
            if (startupArgs[i].endsWith(".pcg")) {
                if (this.frame.loadPCFromFile(new File(startupArgs[i]))) continue;
                Logging.errorPrint("No such PC file: " + startupArgs[i]);
                status = false;
                continue;
            }
            if (!startupArgs[i].endsWith(".pcp") || this.frame.loadPartyFromFile(new File(startupArgs[i]))) continue;
            Logging.errorPrint("No such Party file: " + startupArgs[i]);
            status = false;
        }
        return status;
    }

    private static String readTextFromFile(String fileName) {
        String aString;
        File aFile = new File(fileName);
        if (!aFile.exists()) {
            Logging.errorPrint("Could not find license at " + fileName);
            String aString2 = "No license information found";
            return aString2;
        }
        try {
            BufferedReader theReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(aFile), "UTF-8"));
            int length = (int)aFile.length();
            char[] inputLine = new char[length];
            theReader.read(inputLine, 0, length);
            theReader.close();
            aString = new String(inputLine);
        }
        catch (IOException e) {
            Logging.errorPrint("Could not read license at " + fileName, e);
            aString = "No license information found";
        }
        return aString;
    }

    private static void showSplashScreen() {
        splash = new SplashScreen();
    }

    static {
        templateName = "";
        inFileName = "";
        outFileName = "";
        partyMode = false;
        startupArgs = new String[0];
        hpFrame = null;
    }
}

