/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import pcgen.core.CharacterDomain;
import pcgen.core.Constants;
import pcgen.core.Domain;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.Language;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SpecialAbility;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.AddSpecialAbility;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.utils.Utility;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;
import pcgen.util.PropertyFactory;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

public final class InfoAbilities
extends JPanel
implements CharacterInfoTab {
    static final long serialVersionUID = -7316622743996841985L;
    private static boolean needsUpdate = true;
    private JButton weaponButton = null;
    private JButton langButton = null;
    private JButton langButton2 = null;
    private JButton spAddButton = null;
    private JButton spRemButton = null;
    private JTextArea languageText = new JTextArea();
    private JTextArea saText = new JTextArea();
    private JTextArea weaponText = new JTextArea();
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;

    public InfoAbilities(PlayerCharacter pc) {
        this.pc = pc;
        this.setName(Constants.tabNames[0]);
        this.initComponents();
        this.initActionListeners();
    }

    public void setPc(PlayerCharacter pc) {
        if (this.pc != pc || pc.getSerial() > this.serial) {
            this.pc = pc;
            this.serial = pc.getSerial();
            this.forceRefresh();
        }
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Abilities.Order", 0);
    }

    public void setTabOrder(int order) {
        SettingsHandler.setPCGenOption(".Panel.Abilities.Order", order);
    }

    public String getTabName() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabName(0);
    }

    public boolean isShown() {
        return SettingsHandler.isAbilitiesShownAsATab();
    }

    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    public JComponent getView() {
        return this;
    }

    public static void setNeedsUpdate(boolean flag) {
        needsUpdate = flag;
    }

    private void updateCharacterInfo() {
        if (this.pc == null) {
            return;
        }
        ArrayList specialAbilities = this.pc.getSpecialAbilityTimesList();
        this.pc.getAutoLanguages();
        String languages = this.pc.getLanguagesListNames();
        if (specialAbilities.size() > 0) {
            this.saText.setText(CoreUtility.commaDelimit(specialAbilities));
        } else {
            this.saText.setText("None");
        }
        if (languages.length() > 0) {
            this.languageText.setText(languages);
        } else {
            this.languageText.setText("None");
        }
        this.showWeaponProfList();
        needsUpdate = false;
    }

    private List getOptionalWeaponProficiencies() {
        if (this.pc != null) {
            ArrayList<Object> bonusCategory = new ArrayList<Object>();
            Race pcRace = this.pc.getRace();
            if (pcRace != null && pcRace.getWeaponProfBonus().size() != 0) {
                bonusCategory.add(pcRace);
            }
            Iterator e = this.pc.getClassList().iterator();
            while (e.hasNext()) {
                PCClass aClass = (PCClass)e.next();
                if (aClass.getWeaponProfBonus().size() == 0) continue;
                bonusCategory.add(aClass);
            }
            e = this.pc.getTemplateList().iterator();
            while (e.hasNext()) {
                PCTemplate aTemplate = (PCTemplate)e.next();
                if (aTemplate.getWeaponProfBonusSize() == 0) continue;
                bonusCategory.add(aTemplate);
            }
            List pcDomains = this.pc.getCharacterDomainList();
            Iterator e2 = pcDomains.iterator();
            while (e2.hasNext()) {
                CharacterDomain aCD = (CharacterDomain)e2.next();
                if (!aCD.isFromPCClass() && !aCD.isFromFeat() || aCD.toString().length() == 0 || !aCD.getDomain().getChoiceString().startsWith("WEAPONPROF|")) continue;
                bonusCategory.add(aCD);
            }
            return bonusCategory;
        }
        return null;
    }

    private void addSpecialAbility() {
        if (this.pc == null || this.pc.getClassList().isEmpty()) {
            return;
        }
        new AddSpecialAbility(this.pc, this);
        this.refresh();
    }

    private void ensureFocus() {
        this.getRootPane().getParent().requestFocus();
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.getStatusBar().setText(PropertyFactory.getString("in_iaLangTip"));
        this.refresh();
    }

    private void initActionListeners() {
        this.langButton.addActionListener(new racialLanguageButtonListener());
        this.langButton2.addActionListener(new skillLanguageButtonListener());
        this.spAddButton.addActionListener(new addSpecialButtonListener());
        this.spRemButton.addActionListener(new removeSpecialButtonListener());
        this.weaponButton.addActionListener(new weaponSelectButtonListener());
        this.addComponentListener(new componentShownAdapter());
        this.addFocusListener(new focusAdapter());
    }

    private void initComponents() {
        this.readyForRefresh = true;
        this.setLayout(new BorderLayout());
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BorderLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        GridBagLayout gridbag = new GridBagLayout();
        gbc.fill = 1;
        gbc.anchor = 11;
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(gridbag);
        JPanel langPanel = new JPanel();
        langPanel.setLayout(new BorderLayout());
        JPanel lPanel = new JPanel();
        lPanel.setLayout(new FlowLayout());
        lPanel.add(new JLabel(PropertyFactory.getString("in_languages")));
        this.langButton = new JButton(PropertyFactory.getString("in_other"));
        this.langButton2 = new JButton(PropertyFactory.getString("in_skill"));
        lPanel.add(this.langButton2);
        lPanel.add(this.langButton);
        langPanel.add((Component)lPanel, "North");
        JScrollPane languageScroll = new JScrollPane();
        this.languageText.setLineWrap(true);
        this.languageText.setWrapStyleWord(true);
        this.languageText.setEditable(false);
        languageScroll.setViewportView(this.languageText);
        langPanel.add((Component)languageScroll, "Center");
        Utility.buildConstraints(gbc, 0, 0, 1, 1, 1.0, 0.5);
        gridbag.setConstraints(langPanel, gbc);
        bottomPanel.add(langPanel);
        JPanel specialPanel = new JPanel();
        specialPanel.setLayout(new BorderLayout());
        JPanel sPanel = new JPanel();
        sPanel.setLayout(new FlowLayout());
        sPanel.add(new JLabel(PropertyFactory.getString("in_specialAb")));
        this.spAddButton = new JButton(PropertyFactory.getString("in_add"));
        sPanel.add(this.spAddButton);
        this.spRemButton = new JButton(PropertyFactory.getString("in_remove"));
        sPanel.add(this.spRemButton);
        specialPanel.add((Component)sPanel, "North");
        JScrollPane saScroll = new JScrollPane();
        this.saText.setLineWrap(true);
        this.saText.setWrapStyleWord(true);
        this.saText.setEditable(false);
        saScroll.setViewportView(this.saText);
        specialPanel.add((Component)saScroll, "Center");
        Utility.buildConstraints(gbc, 0, 1, 1, 1, 0.0, 0.5);
        gridbag.setConstraints(specialPanel, gbc);
        bottomPanel.add(specialPanel);
        JPanel weaponProfPanel = new JPanel();
        weaponProfPanel.setLayout(new BorderLayout());
        JPanel bPanel = new JPanel();
        bPanel.setLayout(new FlowLayout());
        JLabel aLabel = new JLabel(PropertyFactory.getString("in_weaProfs"));
        bPanel.add(aLabel);
        this.weaponButton = new JButton(PropertyFactory.getString("in_optProfs"));
        Utility.setDescription(this.weaponButton, PropertyFactory.getString("in_iaOptTip"));
        bPanel.add(this.weaponButton);
        weaponProfPanel.add((Component)bPanel, "North");
        this.weaponText.setLineWrap(true);
        this.weaponText.setWrapStyleWord(true);
        this.weaponText.setEditable(false);
        JScrollPane weaponScroll = new JScrollPane();
        weaponScroll.setViewportView(this.weaponText);
        weaponProfPanel.add((Component)weaponScroll, "Center");
        Utility.buildConstraints(gbc, 0, 2, 1, 1, 0.0, 0.5);
        gridbag.setConstraints(weaponProfPanel, gbc);
        bottomPanel.add(weaponProfPanel);
        this.add((Component)bottomPanel, "Center");
    }

    private void racialLanguageSelectPressed() {
        if (this.pc != null) {
            Language aLang;
            this.pc.setDirty(true);
            SortedSet autoLangs = this.pc.getAutoLanguages();
            ArrayList<Language> availableLangs = new ArrayList<Language>();
            ArrayList<String> selectedLangNames = new ArrayList<String>();
            ArrayList<Language> excludedLangs = new ArrayList<Language>();
            ArrayList<Language> selLangs = new ArrayList<Language>();
            Skill speakLanguage = null;
            Iterator a = this.pc.getSkillList().iterator();
            while (a.hasNext()) {
                Skill aSkill = (Skill)a.next();
                if (aSkill.getChoiceString().indexOf(PropertyFactory.getString("in_language")) < 0) continue;
                speakLanguage = aSkill;
            }
            int numLanguages = this.pc.languageNum(false);
            Iterator langIter = Globals.getLanguageList().iterator();
            while (langIter.hasNext()) {
                aLang = (Language)langIter.next();
                if (aLang == null || !PrereqHandler.passesAll(aLang.getPreReqList(), this.pc, aLang)) continue;
                availableLangs.add(aLang);
            }
            langIter = this.pc.getLanguagesList().iterator();
            while (langIter.hasNext()) {
                aLang = (Language)langIter.next();
                boolean addLang = false;
                if (speakLanguage != null && speakLanguage.containsAssociated(aLang.getName())) {
                    addLang = false;
                } else if (!autoLangs.contains(aLang)) {
                    addLang = true;
                }
                if (addLang) {
                    selectedLangNames.add(aLang.getName());
                    continue;
                }
                availableLangs.remove(aLang);
                excludedLangs.add(aLang);
            }
            Globals.sortPObjectList(availableLangs);
            ChooserInterface lc = ChooserFactory.getChooserInstance();
            lc.setVisible(false);
            lc.setAvailableList(availableLangs);
            lc.setSelectedList(selectedLangNames);
            if (this.pc.getTotalLevels() > 1) {
                if (Globals.checkRule("INTBONUSLANG")) {
                    lc.setPool(numLanguages - selectedLangNames.size());
                } else {
                    lc.setPool(0);
                }
            } else {
                lc.setPool(numLanguages - selectedLangNames.size());
            }
            lc.setPoolFlag(false);
            lc.setVisible(true);
            if (lc.getSelectedList().size() > numLanguages) {
                return;
            }
            Iterator e = lc.getSelectedList().iterator();
            while (e.hasNext()) {
                String aString = (String)e.next();
                Language aLang2 = Globals.getLanguageNamed(aString);
                if (aLang2 == null) continue;
                selLangs.add(aLang2);
            }
            this.pc.getLanguagesList().clear();
            this.pc.getLanguagesList().addAll(selLangs);
            this.pc.getLanguagesList().addAll(excludedLangs);
            this.refresh();
            this.ensureFocus();
        }
    }

    private void removeSpecialAbility() {
        ArrayList<String> aList = new ArrayList<String>();
        ArrayList bList = new ArrayList();
        ArrayList<SpecialAbility> cList = new ArrayList<SpecialAbility>();
        Iterator pcClassIter = this.pc.getClassList().iterator();
        while (pcClassIter.hasNext()) {
            PCClass aClass = (PCClass)pcClassIter.next();
            Iterator ii = aClass.getSpecialAbilityList().iterator();
            while (ii.hasNext()) {
                SpecialAbility sa = (SpecialAbility)ii.next();
                if (!sa.getSASource().endsWith("|0")) continue;
                aList.add(sa.getName());
                cList.add(sa);
            }
        }
        ChooserInterface lc = ChooserFactory.getChooserInstance();
        lc.setVisible(false);
        lc.setTitle(PropertyFactory.getString("in_iaReSpeAb"));
        lc.setMessageText(PropertyFactory.getString("in_iaSelSpeAb"));
        lc.setAvailableList(aList);
        lc.setSelectedList(bList);
        lc.setPool(aList.size());
        lc.setPoolFlag(false);
        lc.setVisible(true);
        Iterator selListIter = lc.getSelectedList().iterator();
        while (selListIter.hasNext()) {
            SpecialAbility sa;
            String bString;
            PCClass aClass;
            String aString = (String)selListIter.next();
            int ix = aList.indexOf(aString);
            if (ix < 0 || ix >= cList.size() || (aClass = this.pc.getClassNamed((bString = (sa = (SpecialAbility)cList.get(ix)).getSASource()).substring(bString.indexOf("|") + 1, bString.lastIndexOf("|")))) == null) continue;
            aClass.removeSave(sa.getName());
            aClass.getSpecialAbilityList().remove(sa);
        }
        this.pc = null;
        this.refresh();
        this.ensureFocus();
    }

    private void showWeaponProfList() {
        TreeSet weaponProfs;
        if (this.weaponButton != null) {
            List bonusCategory = this.getOptionalWeaponProficiencies();
            this.weaponButton.setEnabled(bonusCategory != null && bonusCategory.size() > 0);
        }
        if ((weaponProfs = this.pc.getWeaponProfList()).size() > 0) {
            this.weaponText.setText(CoreUtility.commaDelimit(weaponProfs));
        } else {
            this.weaponText.setText("None");
        }
        this.weaponText.setCaretPosition(0);
    }

    private void skillLanguageSelectPressed() {
        if (Skill.chooseSpokenLanguage(this.pc)) {
            this.refresh();
        }
        this.ensureFocus();
    }

    /*
     * WARNING - void declaration
     */
    private void weaponSelectPressed() {
        if (this.pc != null) {
            List bonusCategory = this.getOptionalWeaponProficiencies();
            if (bonusCategory.size() == 0) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_iaNoOptProfs"), "PCGen", MessageType.INFORMATION);
                return;
            }
            int selIdx = 0;
            do {
                ArrayList profWeapons;
                void var3_3;
                Object profBonusObject;
                if (bonusCategory.size() == 1) {
                    profBonusObject = bonusCategory.get(0);
                } else {
                    InputInterface ii = InputFactory.getInputInstance();
                    Object selectedValue = ii.showInputDialog(null, PropertyFactory.getString("in_iaMultiChoice1") + Constants.s_LINE_SEP + PropertyFactory.getString("in_iaMultiChoice2"), "PCGen", MessageType.INFORMATION, bonusCategory.toArray(), bonusCategory.get(selIdx));
                    if (selectedValue != null) {
                        profBonusObject = selectedValue;
                        selIdx = bonusCategory.indexOf(selectedValue);
                    } else {
                        this.ensureFocus();
                        return;
                    }
                }
                if (var3_3 instanceof CharacterDomain) {
                    Domain aDomain = ((CharacterDomain)var3_3).getDomain();
                    aDomain.getChoices(aDomain.getChoiceString(), new ArrayList(), this.pc);
                } else if (var3_3 instanceof PCClass) {
                    profWeapons = ((PCClass)var3_3).getWeaponProfBonus();
                    ((PCClass)var3_3).getChoices("WEAPONPROF|1|" + CoreUtility.join((Collection)profWeapons, "[WEAPONPROF]|") + PropertyFactory.getString("in_proficiency"), new ArrayList(), this.pc);
                } else if (var3_3 instanceof Race) {
                    profWeapons = ((Race)var3_3).getWeaponProfBonus();
                    ((Race)var3_3).getChoices("WEAPONPROF|1|" + CoreUtility.join((Collection)profWeapons, "[WEAPONPROF]|") + PropertyFactory.getString("in_proficiency"), new ArrayList(), this.pc);
                } else if (var3_3 instanceof PCTemplate) {
                    profWeapons = ((PCTemplate)var3_3).getWeaponProfBonus();
                    ((PCTemplate)var3_3).getChoices("WEAPONPROF|1|" + CoreUtility.join((Collection)profWeapons, "[WEAPONPROF]|") + PropertyFactory.getString("in_proficiency"), new ArrayList(), this.pc);
                }
                this.pc.setDirty(true);
                this.pc.aggregateFeatList();
                this.showWeaponProfList();
            } while (bonusCategory.size() != 1);
            this.ensureFocus();
            return;
        }
    }

    private class focusAdapter
    extends FocusAdapter {
        private focusAdapter() {
        }

        public void focusGained(FocusEvent evt) {
            InfoAbilities.this.refresh();
        }
    }

    private class componentShownAdapter
    extends ComponentAdapter {
        private componentShownAdapter() {
        }

        public void componentShown(ComponentEvent evt) {
            InfoAbilities.this.formComponentShown();
        }
    }

    private class weaponSelectButtonListener
    implements ActionListener {
        private weaponSelectButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            InfoAbilities.this.weaponSelectPressed();
        }
    }

    private class removeSpecialButtonListener
    implements ActionListener {
        private removeSpecialButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            InfoAbilities.this.removeSpecialAbility();
        }
    }

    private class addSpecialButtonListener
    implements ActionListener {
        private addSpecialButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            InfoAbilities.this.addSpecialAbility();
        }
    }

    private class skillLanguageButtonListener
    implements ActionListener {
        private skillLanguageButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            InfoAbilities.this.skillLanguageSelectPressed();
        }
    }

    private class racialLanguageButtonListener
    implements ActionListener {
        private racialLanguageButtonListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            InfoAbilities.this.racialLanguageSelectPressed();
        }
    }
}

