/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.core.Constants;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.SubClass;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfo;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.pcGenGUI;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.Utility;
import pcgen.gui.utils.WholeNumberField;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public final class InfoClasses
extends FilterAdapterPanel
implements CharacterInfoTab {
    static final long serialVersionUID = 9141488354194857537L;
    private static boolean needsUpdate = true;
    private static int viewMode = 0;
    private static int viewSelectMode = 0;
    private static int splitOrientation = 1;
    private static final int COL_NAME = 0;
    private static final int COL_REQ_LEVEL = 1;
    private static final int COL_SRC = 2;
    private static PObjectNode typeRoot;
    private final JLabel avaLabel = new JLabel(PropertyFactory.getString("in_available"));
    private final JLabel selLabel = new JLabel(PropertyFactory.getString("in_selected"));
    private Border etched;
    private ClassModel availableModel = null;
    private ClassModel selectedModel = null;
    private FlippingSplitPane asplit;
    private FlippingSplitPane bsplit;
    private FlippingSplitPane splitPane;
    private JButton addButton;
    private JButton adjXP = new JButton(PropertyFactory.getString("in_adjXP"));
    private JButton hpButton = new JButton();
    private JButton removeButton;
    private JComboBoxEx viewComboBox = new JComboBoxEx();
    private JComboBoxEx viewSelectComboBox = new JComboBoxEx();
    private JTree availableTree = null;
    private JTree selectedTree = null;
    private JLabel featCount = new JLabel();
    private JLabel lAHP = new JLabel();
    private JLabel lBAB = new JLabel();
    private JLabel lDefense = new JLabel();
    private JLabel lVariableDisplay = new JLabel();
    private JLabel lVariableDisplay2 = new JLabel();
    private JLabel lVariableDisplay3 = new JLabel();
    private JLabel lblAltHP = new JLabel();
    private JLabel lblBAB = new JLabel();
    private JLabel lblDefense = new JLabel();
    private JLabel lblExperience = new JLabel();
    private JLabel lblFeats = new JLabel();
    private JLabel lblHP = new JLabel();
    private JLabel lblNextLevel = new JLabel();
    private JLabel lblSkills = new JLabel();
    private JLabel lblVariableDisplay = new JLabel();
    private JLabel lblVariableDisplay2 = new JLabel();
    private JLabel lblVariableDisplay3 = new JLabel();
    private JLabel skillCount = new JLabel();
    private JLabelPane infoLabel = new JLabelPane();
    private JPanel center = new JPanel();
    private JPanel jPanel1 = new JPanel();
    private JPanel pnlAltHP = new JPanel();
    private JPanel pnlBAB = new JPanel();
    private JPanel pnlDefense = new JPanel();
    private JPanel pnlEast = new JPanel();
    private JPanel pnlFeats = new JPanel();
    private JPanel pnlFillerEast = new JPanel();
    private JPanel pnlFillerSouth = new JPanel();
    private JPanel pnlFillerWest = new JPanel();
    private JPanel pnlHP = new JPanel();
    private JPanel pnlSkills = new JPanel();
    private JPanel pnlVariableDisplay = new JPanel();
    private JPanel pnlVariableDisplay2 = new JPanel();
    private JPanel pnlVariableDisplay3 = new JPanel();
    private JPanel pnlWest = new JPanel();
    private JPanel pnlXP = new JPanel();
    private JScrollPane cScroll = new JScrollPane();
    private JTreeTable availableTable;
    private JTreeTable selectedTable;
    private JTreeTableSorter availableSort = null;
    private PCClass lastClass = null;
    private TreePath selPath;
    private WholeNumberField experience = new WholeNumberField();
    private WholeNumberField txtNextLevel = new WholeNumberField();
    private JLabel[] lCheck;
    private JLabel[] lblCheck;
    private JPanel[] pnlCheck;
    private boolean hasBeenSized = false;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;
    static /* synthetic */ Class class$pcgen$gui$utils$TreeTableModel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;

    public InfoClasses(PlayerCharacter pc) {
        this.pc = pc;
        this.setName(Constants.tabNames[2]);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoClasses.this.initComponents();
                InfoClasses.this.initActionListeners();
            }
        });
    }

    public void setPc(PlayerCharacter pc) {
        if (this.pc != pc || pc.getSerial() > this.serial) {
            this.pc = pc;
            this.serial = pc.getSerial();
            this.forceRefresh();
        }
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Classes.Order", 2);
    }

    public void setTabOrder(int order) {
        SettingsHandler.setPCGenOption(".Panel.Classes.Order", order);
    }

    public String getTabName() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabName(2);
    }

    public boolean isShown() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabShown(2);
    }

    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    public JComponent getView() {
        return this;
    }

    public static void setNeedsUpdate(boolean flag) {
        needsUpdate = flag;
    }

    public boolean isMatchAnyEnabled() {
        return true;
    }

    public boolean isNegateEnabled() {
        return true;
    }

    public int getSelectionMode() {
        return 2;
    }

    public void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
        FilterFactory.registerAllClassFilters(this);
        FilterFactory.registerAllPrereqAlignmentFilters(this);
    }

    public void refreshFiltering() {
        this.forceRefresh();
    }

    public void updateHP() {
        if (this.pc == null) {
            return;
        }
        this.lblHP.setText(String.valueOf(this.pc.hitPoints()));
    }

    private void setInfoLabelText(PCClass aClass, PObjectNode pn) {
        boolean isSubClass = false;
        this.lastClass = aClass;
        if (this.lastClass instanceof SubClass) {
            this.lastClass = (PCClass)pn.getParent().getItem();
            isSubClass = true;
        }
        if (aClass != null) {
            StringBuffer b = new StringBuffer();
            b.append("<html><b>").append(aClass.piSubString()).append("</b>");
            String aString = aClass.getType();
            if (isSubClass && aString.length() == 0) {
                aString = this.lastClass.getType();
            }
            b.append(" &nbsp;<b>").append(PropertyFactory.getString("in_type")).append("</b>:").append(aString);
            aString = aClass.preReqHTMLStrings(this.pc, false);
            if (isSubClass && aString.length() == 0) {
                aString = this.lastClass.preReqHTMLStrings(this.pc, false);
            }
            if (aString.length() > 0) {
                b.append(" &nbsp;<b>").append(PropertyFactory.getString("in_requirements")).append("</b>:").append(aString);
            }
            aString = aClass.getSource();
            if (isSubClass && aString.length() == 0) {
                aString = this.lastClass.getSource();
            }
            if (aString.length() > 0) {
                b.append(" <b>").append(PropertyFactory.getString("in_sourceLabel")).append("</b>:").append(aString);
            }
            b.append(" <b>BAB:</b>:").append(aClass.getAttackBonusType());
            int hitDie = aClass.getBaseHitDie();
            if (isSubClass && hitDie == 0) {
                hitDie = this.lastClass.getBaseHitDie();
            }
            b.append(" <b>HD:</b>:1d").append(hitDie);
            if (Globals.getGameModeShowSpellTab()) {
                aString = aClass.getSpellType();
                if (isSubClass && (aString.length() == 0 || aString.equalsIgnoreCase("None"))) {
                    aString = this.lastClass.getSpellType();
                }
                b.append(" <b>").append(PropertyFactory.getString("in_spellType")).append("</b>:").append(aString);
                aString = aClass.getSpellBaseStat();
                if (isSubClass && (aString == null || aString.length() == 0)) {
                    aString = this.lastClass.getSpellBaseStat();
                }
                b.append(" <b>").append(PropertyFactory.getString("in_baseStat")).append("</b>:").append(aString);
            }
            b.append("</html>");
            this.infoLabel.setText(b.toString());
        }
    }

    private PCClass getSelectedClass() {
        if (this.lastClass == null) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_clNoClass"), "PCGen", MessageType.ERROR);
        }
        return this.lastClass;
    }

    private int getSelectedIndex(ListSelectionEvent e) {
        DefaultListSelectionModel model = (DefaultListSelectionModel)e.getSource();
        if (model == null) {
            return -1;
        }
        return model.getMinSelectionIndex();
    }

    private void addClass(int levels) {
        if (Globals.getGameModeAlignmentText().length() != 0 && levels > 0 && this.pc.getAlignment() == SettingsHandler.getGame().getIndexOfAlignment("None")) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_clSelAlign"), "PCGen", MessageType.ERROR);
            return;
        }
        PCClass theClass = this.getSelectedClass();
        if (theClass == null || !theClass.isQualified(this.pc)) {
            return;
        }
        this.pc.setDirty(true);
        PCClass aClass = this.pc.getClassNamed(theClass.getName());
        if (levels >= 0 && aClass != null && !Globals.checkRule("LEVELCAP") && (Globals.checkRule("LEVELCAP") || aClass.getLevel() >= aClass.getMaxLevel())) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_clMaxLvl"), "PCGen", MessageType.INFORMATION);
            return;
        }
        this.pc.incrementClassLevel(levels, theClass);
        CharacterInfo pane = PCGen_Frame1.getCharacterPane();
        pane.setPaneForUpdate(pane.infoFeats());
        pane.setPaneForUpdate(pane.infoDomain());
        pane.setPaneForUpdate(pane.infoSkills());
        pane.setPaneForUpdate(pane.infoSpells());
        pane.setPaneForUpdate(pane.infoAbilities());
        pane.setPaneForUpdate(pane.infoSummary());
        pane.refresh();
        if (levels > 0 && Globals.checkRule("FREECLOTHES") && this.pc.totalNonMonsterLevels() == 1) {
            List clothes = EquipmentList.getEquipmentOfType(this.pc.getEquipmentList(), "Clothing.Resizable", "Magic");
            boolean hasClothes = false;
            String pcSize = this.pc.getSize();
            if (clothes.size() != 0) {
                Iterator e = clothes.iterator();
                while (e.hasNext()) {
                    Equipment eq = (Equipment)e.next();
                    if (!CoreUtility.doublesEqual(eq.getCost(this.pc).doubleValue(), 0.0) || !pcSize.equals(eq.getSize())) continue;
                    hasClothes = true;
                    break;
                }
            }
            if (!hasClothes) {
                String aString;
                Equipment eq;
                clothes = EquipmentList.getEquipmentOfType(EquipmentList.getEquipmentList(), "Clothing.Resizable", "Magic.Custom.Auto_Gen");
                ArrayList selectedClothes = new ArrayList();
                Globals.chooseFromList(PropertyFactory.getString("in_clCloSet"), clothes, selectedClothes, 1);
                if (selectedClothes.size() != 0 && (eq = EquipmentList.getEquipmentNamed(aString = (String)selectedClothes.get(0))) != null) {
                    eq = (Equipment)eq.clone();
                    eq.setQty(new Float(1.0f));
                    if (!pcSize.equals(eq.getSize())) {
                        eq.resizeItem(this.pc, pcSize);
                    }
                    eq.setCostMod("-" + eq.getCost(this.pc).toString());
                    if (this.pc.getEquipmentNamed(eq.nameItemFromModifiers(this.pc)) == null) {
                        this.pc.addEquipment(eq);
                    } else {
                        Logging.errorPrint(PropertyFactory.getString("in_clEqEr"));
                    }
                }
            }
        }
        this.pc.setDirty(true);
        this.forceRefresh();
    }

    private void buildEastPanel() {
        GridBagConstraints gbc;
        this.pnlEast.setLayout(new GridBagLayout());
        List checkList = SettingsHandler.getGame().getUnmodifiableCheckList();
        int countChecks = checkList.size();
        if (countChecks != 0) {
            this.pnlCheck = new JPanel[countChecks];
            this.lCheck = new JLabel[countChecks];
            this.lblCheck = new JLabel[countChecks];
            for (int i = 0; i < countChecks; ++i) {
                this.pnlCheck[i] = new JPanel();
                this.pnlCheck[i].setLayout(new BorderLayout(5, 5));
                this.lblCheck[i] = new JLabel();
                this.lCheck[i] = new JLabel();
                this.pnlCheck[i].add((Component)this.lblCheck[i], "West");
                this.pnlCheck[i].add((Component)this.lCheck[i], "East");
                gbc = new GridBagConstraints();
                gbc.gridx = 0;
                if (i == 0) {
                    gbc.gridy = 0;
                }
                gbc.fill = 1;
                gbc.anchor = 17;
                gbc.weightx = 1.0;
                this.pnlEast.add((Component)this.pnlCheck[i], gbc);
            }
        }
        this.pnlVariableDisplay.setLayout(new BorderLayout(5, 5));
        String aString = Globals.getGameModeVariableDisplayText();
        this.lblVariableDisplay.setText(aString);
        this.pnlVariableDisplay.add((Component)this.lblVariableDisplay, "West");
        this.pnlVariableDisplay.setVisible(aString.length() != 0);
        this.pnlVariableDisplay.add((Component)this.lVariableDisplay, "East");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        this.pnlEast.add((Component)this.pnlVariableDisplay, gbc);
        this.pnlVariableDisplay2.setLayout(new BorderLayout(5, 5));
        aString = Globals.getGameModeVariableDisplay2Text();
        this.lblVariableDisplay2.setText(aString);
        this.pnlVariableDisplay2.add((Component)this.lblVariableDisplay2, "West");
        this.pnlVariableDisplay2.setVisible(aString.length() != 0);
        this.pnlVariableDisplay2.add((Component)this.lVariableDisplay2, "East");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        this.pnlEast.add((Component)this.pnlVariableDisplay2, gbc);
        this.pnlVariableDisplay3.setLayout(new BorderLayout(5, 5));
        aString = Globals.getGameModeVariableDisplay3Text();
        this.lblVariableDisplay3.setText(aString);
        this.pnlVariableDisplay3.add((Component)this.lblVariableDisplay3, "West");
        this.pnlVariableDisplay3.setVisible(aString.length() != 0);
        this.pnlVariableDisplay3.add((Component)this.lVariableDisplay3, "East");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        this.pnlEast.add((Component)this.pnlVariableDisplay3, gbc);
        this.pnlAltHP.setLayout(new BorderLayout(5, 5));
        aString = Globals.getGameModeAltHPText();
        this.lblAltHP.setText(aString);
        this.pnlAltHP.add((Component)this.lblAltHP, "West");
        this.pnlAltHP.setVisible(aString.length() != 0);
        this.pnlAltHP.add((Component)this.lAHP, "East");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        this.pnlEast.add((Component)this.pnlAltHP, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.pnlEast.add((Component)this.pnlFillerEast, gbc);
        this.pnlEast.setVisible(true);
        this.pnlEast.updateUI();
    }

    private void createAvailableModel() {
        if (this.availableModel == null) {
            this.availableModel = new ClassModel(viewMode, true);
        } else {
            this.availableModel.resetModel(InfoClasses.viewMode, true);
        }
        if (this.availableSort != null) {
            this.availableSort.setRoot((PObjectNode)this.availableModel.getRoot());
            this.availableSort.sortNodeOnColumn();
        }
    }

    private void createModels() {
        this.createSelectedModel();
        this.createAvailableModel();
    }

    private void createSelectedModel() {
        if (this.selectedModel == null) {
            this.selectedModel = new ClassModel(viewSelectMode, false);
        } else {
            this.selectedModel.resetModel(InfoClasses.viewSelectMode, false);
        }
    }

    private void createTreeTables() {
        this.availableTable = new JTreeTable(this.availableModel);
        this.availableTable.setSelectionMode(0);
        this.availableTree = this.availableTable.getTree();
        this.availableTree.setRootVisible(false);
        this.availableTree.setShowsRootHandles(true);
        this.availableTree.setCellRenderer(new LabelTreeCellRenderer());
        this.selectedTable = new JTreeTable(this.selectedModel);
        this.selectedTable.setSelectionMode(0);
        this.selectedTree = this.selectedTable.getTree();
        this.selectedTree.setRootVisible(false);
        this.selectedTree.setShowsRootHandles(true);
        this.selectedTree.setCellRenderer(new LabelTreeCellRenderer());
        this.hookupPopupMenu(this.availableTable);
        this.hookupPopupMenu(this.selectedTable);
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.getStatusBar().setText(PropertyFactory.getString("in_clNotQualify"));
        this.refresh();
        int s = this.splitPane.getDividerLocation();
        int t = this.bsplit.getDividerLocation();
        int u = this.asplit.getDividerLocation();
        if (!this.hasBeenSized) {
            int width;
            TableColumn sCol;
            int i;
            this.hasBeenSized = true;
            s = SettingsHandler.getPCGenOption("InfoClasses.splitPane", (int)(this.getSize().getWidth() * 7.0 / 10.0));
            t = SettingsHandler.getPCGenOption("InfoClasses.bsplit", (int)(this.getSize().getHeight() - 140.0));
            u = SettingsHandler.getPCGenOption("InfoClasses.asplit", (int)(this.getSize().getWidth() - 334.0));
            for (i = 0; i < this.selectedTable.getColumnCount(); ++i) {
                sCol = this.selectedTable.getColumnModel().getColumn(i);
                width = Globals.getCustColumnWidth("ClassSel", i);
                if (width != 0) {
                    sCol.setPreferredWidth(width);
                }
                sCol.addPropertyChangeListener(new ResizeColumnListener(this.selectedTable, "ClassSel", i));
            }
            for (i = 0; i < this.availableTable.getColumnCount(); ++i) {
                sCol = this.availableTable.getColumnModel().getColumn(i);
                width = Globals.getCustColumnWidth("ClassAva", i);
                if (width != 0) {
                    sCol.setPreferredWidth(width);
                }
                sCol.addPropertyChangeListener(new ResizeColumnListener(this.availableTable, "ClassAva", i));
            }
        }
        if (s > 0) {
            this.splitPane.setDividerLocation(s);
            SettingsHandler.setPCGenOption("InfoClasses.splitPane", s);
        }
        if (t > 0) {
            this.bsplit.setDividerLocation(t);
            SettingsHandler.setPCGenOption("InfoClasses.bsplit", t);
        }
        if (u > 0) {
            this.asplit.setDividerLocation(u);
            SettingsHandler.setPCGenOption("InfoClasses.asplit", u);
        }
    }

    private void hookupPopupMenu(JTreeTable treeTable) {
        treeTable.addMouseListener(new ClassPopupListener(treeTable, new ClassPopupMenu(treeTable)));
    }

    private void initActionListeners() {
        this.addFocusListener(new PaneFocusAdapter());
        this.addComponentListener(new PaneComponentAdapter());
        this.removeButton.addActionListener(new RemoveClassButtonActionListener());
        this.adjXP.addActionListener(new AdjustXPButtonActionListener());
        this.addButton.addActionListener(new AddClassButtonActionListener());
        this.viewComboBox.addActionListener(new ViewComboBoxActionListener());
        this.viewSelectComboBox.addActionListener(new ViewSelectComboBoxActionListener());
        this.hpButton.addActionListener(new HpButtonActionListener());
        this.experience.addFocusListener(new ExperienceBoxFocusAdapter());
        this.availableTable.getSelectionModel().addListSelectionListener(new AvailableListSelectionListener());
        this.selectedTable.getSelectionModel().addListSelectionListener(new SelectedListSelectionListener());
        this.availableTree.addMouseListener(new AvailableTreeMouseAdapter());
        this.selectedTree.addMouseListener(new SelectedTreeMouseAdapter());
        FilterFactory.restoreFilterSettings(this);
    }

    private void initComponents() {
        this.readyForRefresh = true;
        typeRoot = new PObjectNode();
        ArrayList<String> tList = new ArrayList<String>();
        Iterator i = Globals.getClassList().iterator();
        while (i.hasNext()) {
            PCClass aClass = (PCClass)i.next();
            for (int ii = 0; ii < aClass.getMyTypeCount(); ++ii) {
                String aString = aClass.getMyType(ii);
                if (tList.contains(aString)) continue;
                tList.add(aString);
            }
        }
        Collections.sort(tList);
        if (!tList.contains(PropertyFactory.getString("in_other"))) {
            tList.add(PropertyFactory.getString("in_other"));
        }
        PObjectNode[] p = new PObjectNode[tList.size()];
        for (int i2 = 0; i2 < p.length; ++i2) {
            p[i2] = new PObjectNode();
            p[i2].setItem(tList.get(i2).toString());
            p[i2].setParent(typeRoot);
        }
        typeRoot.setChildren(p);
        int iView = SettingsHandler.getClassTab_AvailableListMode();
        if (iView >= 0 && iView <= 1) {
            viewMode = iView;
        }
        SettingsHandler.setClassTab_AvailableListMode(viewMode);
        this.viewComboBox.addItem(PropertyFactory.getString("in_nameLabel"));
        this.viewComboBox.addItem(PropertyFactory.getString("in_typeName"));
        Utility.setDescription(this.viewComboBox, PropertyFactory.getString("in_clChangCl"));
        this.viewComboBox.setSelectedIndex(viewMode);
        iView = SettingsHandler.getClassTab_SelectedListMode();
        if (iView >= 0 && iView <= 1) {
            viewSelectMode = iView;
        }
        SettingsHandler.setClassTab_SelectedListMode(viewSelectMode);
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_nameLabel"));
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_typeName"));
        Utility.setDescription(this.viewSelectComboBox, PropertyFactory.getString("in_clChangCl"));
        this.viewSelectComboBox.setSelectedIndex(viewSelectMode);
        this.createModels();
        this.createTreeTables();
        this.center.setLayout(new BorderLayout());
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel leftPane = new JPanel();
        JPanel rightPane = new JPanel();
        leftPane.setLayout(gridbag);
        this.splitPane = new FlippingSplitPane(splitOrientation, leftPane, rightPane);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.center.add((Component)this.splitPane, "Center");
        Utility.buildConstraints(c, 0, 0, 1, 1, 100.0, 5.0);
        c.fill = 0;
        c.anchor = 10;
        JPanel aPanel = new JPanel();
        gridbag.setConstraints(aPanel, c);
        aPanel.add(this.avaLabel);
        aPanel.add(this.viewComboBox);
        ImageIcon newImage = IconUtilitities.getImageIcon("Forward16.gif");
        this.addButton = new JButton(newImage);
        Utility.setDescription(this.addButton, PropertyFactory.getString("in_clAddTip"));
        this.addButton.setEnabled(false);
        aPanel.add(this.addButton);
        leftPane.add(aPanel);
        this.selectedTable.setColAlign(1, 0);
        this.selectedTable.getColumnModel().getColumn(1).setPreferredWidth(15);
        Utility.buildConstraints(c, 0, 1, 1, 1, 0.0, 95.0);
        c.fill = 1;
        c.anchor = 10;
        JScrollPane scrollPane = new JScrollPane(this.availableTable);
        gridbag.setConstraints(scrollPane, c);
        leftPane.add(scrollPane);
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        rightPane.setLayout(gridbag);
        Utility.buildConstraints(c, 0, 0, 1, 1, 100.0, 5.0);
        c.fill = 0;
        c.anchor = 10;
        aPanel = new JPanel();
        gridbag.setConstraints(aPanel, c);
        aPanel.add(this.selLabel);
        aPanel.add(this.viewSelectComboBox);
        newImage = IconUtilitities.getImageIcon("Back16.gif");
        this.removeButton = new JButton(newImage);
        Utility.setDescription(this.removeButton, PropertyFactory.getString("in_clRemoveTip"));
        this.removeButton.setEnabled(false);
        aPanel.add(this.removeButton);
        rightPane.add(aPanel);
        Utility.buildConstraints(c, 0, 1, 1, 1, 0.0, 95.0);
        c.fill = 1;
        c.anchor = 10;
        scrollPane = new JScrollPane(this.selectedTable);
        gridbag.setConstraints(scrollPane, c);
        rightPane.add(scrollPane);
        TitledBorder title1 = BorderFactory.createTitledBorder(this.etched, PropertyFactory.getString("in_clInfo"));
        title1.setTitleJustification(2);
        this.cScroll.setBorder(title1);
        this.infoLabel.setBackground(rightPane.getBackground());
        this.cScroll.setViewportView(this.infoLabel);
        Utility.setDescription(this.cScroll, PropertyFactory.getString("in_infoScrollTip"));
        this.initSEPanel(this.jPanel1);
        this.asplit = new FlippingSplitPane(1, this.cScroll, this.jPanel1);
        this.asplit.setOneTouchExpandable(true);
        this.asplit.setDividerSize(10);
        JPanel botPane = new JPanel();
        botPane.setLayout(new BorderLayout());
        botPane.add((Component)this.asplit, "Center");
        this.bsplit = new FlippingSplitPane(0, this.center, botPane);
        this.bsplit.setOneTouchExpandable(true);
        this.bsplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bsplit, "Center");
        this.availableSort = new JTreeTableSorter(this.availableTable, (PObjectNode)this.availableModel.getRoot(), this.availableModel);
    }

    private boolean maybeSetExperience(int xp) {
        this.pc.setXP(xp);
        if (xp >= this.pc.minXPForNextECL()) {
            ShowMessageDelegate.showMessageDialog(SettingsHandler.getGame().getLevelUpMessage(), "PCGen", MessageType.INFORMATION);
        }
        return true;
    }

    private void experienceFocusLost() {
        this.maybeSetExperience(this.experience.getValue());
    }

    private void initSEPanel(JPanel sep) {
        sep.setLayout(new GridBagLayout());
        this.hpButton.setText(Globals.getGameModeHPAbbrev());
        this.hpButton.setAlignmentY(0.0f);
        this.hpButton.setHorizontalAlignment(2);
        this.pnlHP.add(this.hpButton);
        this.lblHP.setHorizontalAlignment(11);
        this.pnlHP.add(this.lblHP);
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, 0, 5);
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        sep.add((Component)this.pnlHP, gbc);
        this.pnlWest.setLayout(new GridBagLayout());
        this.pnlFeats.setLayout(new BorderLayout(5, 5));
        this.lblFeats.setText(PropertyFactory.getString("in_feats"));
        this.pnlFeats.add((Component)this.lblFeats, "West");
        this.featCount.setText("0");
        this.pnlFeats.add((Component)this.featCount, "East");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.fill = 1;
        gbc.anchor = 18;
        gbc.weightx = 1.0;
        this.pnlWest.add((Component)this.pnlFeats, gbc);
        this.pnlSkills.setLayout(new BorderLayout(5, 5));
        this.lblSkills.setText(PropertyFactory.getString("in_skills"));
        this.pnlSkills.add((Component)this.lblSkills, "West");
        this.skillCount.setText("0");
        this.pnlSkills.add((Component)this.skillCount, "East");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        this.pnlWest.add((Component)this.pnlSkills, gbc);
        this.pnlBAB.setLayout(new BorderLayout(5, 5));
        this.lblBAB.setText("BAB");
        this.pnlBAB.add((Component)this.lblBAB, "West");
        this.lBAB.setText("0");
        this.pnlBAB.add((Component)this.lBAB, "East");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        this.pnlWest.add((Component)this.pnlBAB, gbc);
        this.pnlDefense.setLayout(new BorderLayout(5, 5));
        String aString = Globals.getGameModeACText();
        this.lblDefense.setText(aString);
        this.pnlDefense.add((Component)this.lblDefense, "West");
        this.pnlDefense.setVisible(aString.length() != 0);
        this.lDefense.setText("0");
        this.pnlDefense.add((Component)this.lDefense, "East");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        this.pnlWest.add((Component)this.pnlDefense, gbc);
        this.pnlAltHP.setLayout(new BorderLayout(5, 5));
        aString = Globals.getGameModeAltHPText();
        this.lblAltHP.setText(aString);
        this.pnlAltHP.add((Component)this.lblAltHP, "West");
        this.pnlAltHP.setVisible(aString.length() != 0);
        this.pnlAltHP.add((Component)this.lAHP, "East");
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        this.pnlWest.add((Component)this.pnlAltHP, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.fill = 1;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        this.pnlWest.add((Component)this.pnlFillerWest, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridheight = 2;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 6, 0, 6);
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        sep.add((Component)this.pnlWest, gbc);
        this.buildEastPanel();
        gbc = new GridBagConstraints();
        gbc.gridx = 1;
        gbc.gridy = 1;
        gbc.gridheight = 2;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, 0, 5);
        gbc.anchor = 13;
        gbc.weightx = 1.0;
        sep.add((Component)this.pnlEast, gbc);
        this.pnlXP.setLayout(new GridBagLayout());
        this.lblExperience.setText(PropertyFactory.getString("in_experience"));
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.anchor = 17;
        this.pnlXP.add((Component)this.lblExperience, gbc);
        this.experience.setHorizontalAlignment(11);
        this.experience.setText("0");
        gbc = new GridBagConstraints();
        gbc.fill = 2;
        gbc.insets = new Insets(0, 3, 0, 3);
        gbc.weightx = 1.0;
        this.pnlXP.add((Component)this.experience, gbc);
        this.pnlXP.add((Component)this.adjXP, new GridBagConstraints());
        this.lblNextLevel.setText("Next Level");
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.anchor = 17;
        this.pnlXP.add((Component)this.lblNextLevel, gbc);
        this.txtNextLevel.setHorizontalAlignment(11);
        this.txtNextLevel.setBorder(BorderFactory.createEtchedBorder(Color.lightGray, Color.lightGray));
        this.txtNextLevel.setBackground(Color.lightGray);
        this.txtNextLevel.setEditable(false);
        this.txtNextLevel.setValue(0);
        gbc = new GridBagConstraints();
        gbc.gridy = 1;
        gbc.fill = 2;
        gbc.insets = new Insets(0, 3, 0, 3);
        gbc.weightx = 1.0;
        this.pnlXP.add((Component)this.txtNextLevel, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.insets = new Insets(0, 5, 0, 5);
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        sep.add((Component)this.pnlXP, gbc);
        gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridwidth = 2;
        gbc.fill = 1;
        gbc.anchor = 17;
        gbc.weightx = 1.0;
        gbc.weighty = 1.0;
        sep.add((Component)this.pnlFillerSouth, gbc);
    }

    private void updateAvailableModel() {
        List pathList = this.availableTable.getExpandedPaths();
        this.createAvailableModel();
        this.availableTable.updateUI();
        this.availableTable.expandPathList(pathList);
    }

    private void updateCharacterInfo() {
        if (this.pc == null || !needsUpdate) {
            return;
        }
        String aString = Globals.getGameModeHPAbbrev();
        this.hpButton.setText(aString);
        aString = Globals.getGameModeACText();
        if (Globals.getGameModeShowClassDefense()) {
            this.lblDefense.setText(aString + " (Class)");
            this.pnlDefense.setVisible(true);
        } else {
            this.pnlDefense.setVisible(false);
        }
        aString = Globals.getGameModeAltHPText();
        if (aString.length() != 0) {
            this.lblAltHP.setText(aString);
            this.pnlAltHP.setVisible(true);
        } else {
            this.pnlAltHP.setVisible(false);
        }
        aString = Globals.getGameModeVariableDisplayText();
        if (aString.length() != 0) {
            this.lblVariableDisplay.setText(aString);
            this.pnlVariableDisplay.setVisible(true);
        } else {
            this.pnlVariableDisplay.setVisible(false);
        }
        aString = Globals.getGameModeVariableDisplay2Text();
        if (aString.length() != 0) {
            this.lblVariableDisplay2.setText(aString);
            this.pnlVariableDisplay2.setVisible(true);
        } else {
            this.pnlVariableDisplay2.setVisible(false);
        }
        aString = Globals.getGameModeVariableDisplay3Text();
        if (aString.length() != 0) {
            this.lblVariableDisplay3.setText(aString);
            this.pnlVariableDisplay3.setVisible(true);
        } else {
            this.pnlVariableDisplay3.setVisible(false);
        }
        this.pc.setAggregateFeatsStable(false);
        this.pc.setAutomaticFeatsStable(false);
        this.pc.setVirtualFeatsStable(false);
        this.updateAvailableModel();
        this.updateSelectedModel();
        this.pc.aggregateFeatList();
        this.updateHP();
        this.featCount.setText(Double.toString(this.pc.getFeats()));
        this.skillCount.setText(Integer.toString(this.pc.getSkillPoints()));
        this.lBAB.setText(Integer.toString(this.pc.baseAttackBonus()));
        this.lDefense.setText(Integer.toString(this.pc.classAC()));
        this.updateChecks();
        this.lAHP.setText(Integer.toString(this.pc.altHP()));
        this.updateXP(this.pc);
        int mytempvar = (int)this.pc.getTotalBonusTo("VAR", Globals.getGameModeVariableDisplayName());
        this.lVariableDisplay.setText(Integer.toString(mytempvar));
        int mytempvar2 = (int)this.pc.getTotalBonusTo("VAR", Globals.getGameModeVariableDisplay2Name());
        this.lVariableDisplay2.setText(Integer.toString(mytempvar2));
        int mytempvar3 = (int)this.pc.getTotalBonusTo("VAR", Globals.getGameModeVariableDisplay3Name());
        this.lVariableDisplay3.setText(Integer.toString(mytempvar3));
        needsUpdate = false;
    }

    private void updateChecks() {
        List checkList = SettingsHandler.getGame().getUnmodifiableCheckList();
        int countChecks = checkList.size();
        if (this.lCheck == null || countChecks != this.lCheck.length) {
            this.buildEastPanel();
        }
        if (countChecks != 0) {
            for (int i = 0; i < countChecks; ++i) {
                PObject obj = (PObject)checkList.get(i);
                this.lblCheck[i].setText(obj.getName());
                this.lCheck[i].setText(Delta.toString((int)this.pc.getBonus(i + 1, true)));
            }
        }
    }

    private void updateSelectedModel() {
        List pathList = this.selectedTable.getExpandedPaths();
        this.createSelectedModel();
        this.selectedTable.updateUI();
        this.selectedTable.expandPathList(pathList);
    }

    private void updateXP(PlayerCharacter currentPC) {
        if (currentPC == null) {
            return;
        }
        this.experience.setValue(currentPC.getXP());
        this.txtNextLevel.setValue(currentPC.minXPForNextECL());
    }

    private void viewComboBoxActionPerformed() {
        int index = this.viewComboBox.getSelectedIndex();
        if (index != viewMode) {
            viewMode = index;
            SettingsHandler.setClassTab_AvailableListMode(viewMode);
            this.updateAvailableModel();
        }
    }

    private void viewSelectComboBoxActionPerformed() {
        int index = this.viewSelectComboBox.getSelectedIndex();
        if (index != viewSelectMode) {
            viewSelectMode = index;
            SettingsHandler.setClassTab_SelectedListMode(viewSelectMode);
            this.updateSelectedModel();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SelectedTreeMouseAdapter
    extends MouseAdapter {
        private SelectedTreeMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            int selRow = InfoClasses.this.selectedTree.getRowForLocation(e.getX(), e.getY());
            TreePath mlSelPath = InfoClasses.this.selectedTree.getPathForLocation(e.getX(), e.getY());
            if (selRow != -1) {
                if (e.getClickCount() == 1) {
                    InfoClasses.this.selectedTree.setSelectionPath(mlSelPath);
                } else if (e.getClickCount() == 2) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ SelectedTreeMouseAdapter this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            InfoClasses.access$2900(SelectedTreeMouseAdapter.access$4800(this.this$1), -1);
                        }
                    });
                }
            }
        }

        static /* synthetic */ InfoClasses access$4800(SelectedTreeMouseAdapter x0) {
            return x0.InfoClasses.this;
        }
    }

    private class AvailableTreeMouseAdapter
    extends MouseAdapter {
        private AvailableTreeMouseAdapter() {
        }

        public void mousePressed(MouseEvent e) {
            int selRow = InfoClasses.this.availableTree.getRowForLocation(e.getX(), e.getY());
            TreePath mlSelPath = InfoClasses.this.availableTree.getPathForLocation(e.getX(), e.getY());
            if (selRow != -1) {
                if (e.getClickCount() == 1 && mlSelPath != null) {
                    InfoClasses.this.availableTree.setSelectionPath(mlSelPath);
                } else if (e.getClickCount() == 2) {
                    SwingUtilities.invokeLater(new Runnable(this){
                        private final /* synthetic */ AvailableTreeMouseAdapter this$1;
                        {
                            this.this$1 = this$1;
                        }

                        public void run() {
                            InfoClasses.access$2900(AvailableTreeMouseAdapter.access$4600(this.this$1), 1);
                        }
                    });
                }
            }
        }

        static /* synthetic */ InfoClasses access$4600(AvailableTreeMouseAdapter x0) {
            return x0.InfoClasses.this;
        }
    }

    private class SelectedListSelectionListener
    implements ListSelectionListener {
        private SelectedListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                Object t;
                int idx = InfoClasses.this.getSelectedIndex(e);
                if (idx < 0) {
                    return;
                }
                Object temp = InfoClasses.this.selectedTable.getTree().getPathForRow(idx).getLastPathComponent();
                if (temp == null) {
                    InfoClasses.this.lastClass = null;
                    InfoClasses.this.infoLabel.setText();
                    return;
                }
                PCClass aClass = null;
                PObjectNode pn = null;
                if (temp instanceof PObjectNode && (t = (pn = (PObjectNode)temp).getItem()) instanceof PCClass) {
                    aClass = (PCClass)t;
                }
                InfoClasses.this.removeButton.setEnabled(aClass != null);
                InfoClasses.this.setInfoLabelText(aClass, pn);
            }
        }
    }

    private class AvailableListSelectionListener
    implements ListSelectionListener {
        private AvailableListSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                int idx = InfoClasses.this.getSelectedIndex(e);
                if (idx < 0) {
                    return;
                }
                Object temp = InfoClasses.this.availableTable.getTree().getPathForRow(idx).getLastPathComponent();
                if (temp == null) {
                    InfoClasses.this.lastClass = null;
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_clNoClass"), "PCGen", MessageType.ERROR);
                    return;
                }
                PCClass aClass = null;
                PObjectNode pn = null;
                if (temp instanceof PObjectNode) {
                    pn = (PObjectNode)temp;
                    if ((temp = ((PObjectNode)temp).getItem()) instanceof PCClass) {
                        aClass = (PCClass)temp;
                    }
                }
                InfoClasses.this.addButton.setEnabled(aClass != null);
                InfoClasses.this.setInfoLabelText(aClass, pn);
            }
        }
    }

    private class AdjustXPButtonActionListener
    implements ActionListener {
        private AdjustXPButtonActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            String selectedValue = JOptionPane.showInputDialog(null, PropertyFactory.getString("in_clEnterXP"), "PCGen", 3);
            if (selectedValue != null) {
                try {
                    int x = Integer.parseInt(selectedValue) + InfoClasses.this.pc.getXP();
                    if (InfoClasses.this.maybeSetExperience(x)) {
                        InfoClasses.this.experience.setValue(x);
                    }
                }
                catch (NumberFormatException e) {
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_clInvalidNum"), "PCGen", MessageType.ERROR);
                    return;
                }
            }
        }
    }

    private class RemoveClassButtonActionListener
    implements ActionListener {
        private RemoveClassButtonActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            InfoClasses.this.addClass(-1);
        }
    }

    private class AddClassButtonActionListener
    implements ActionListener {
        private AddClassButtonActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            InfoClasses.this.addClass(1);
        }
    }

    private class HpButtonActionListener
    implements ActionListener {
        private HpButtonActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            pcGenGUI.showHpFrame(InfoClasses.this.pc);
        }
    }

    private class ExperienceBoxFocusAdapter
    extends FocusAdapter {
        private boolean isProcessingExperienceFocusLost = false;

        private ExperienceBoxFocusAdapter() {
        }

        public void focusLost(FocusEvent evt) {
            if (!this.isProcessingExperienceFocusLost) {
                this.isProcessingExperienceFocusLost = true;
                InfoClasses.this.experienceFocusLost();
                this.isProcessingExperienceFocusLost = false;
            }
        }
    }

    private class ViewSelectComboBoxActionListener
    implements ActionListener {
        private ViewSelectComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            InfoClasses.this.viewSelectComboBoxActionPerformed();
        }
    }

    private class ViewComboBoxActionListener
    implements ActionListener {
        private ViewComboBoxActionListener() {
        }

        public void actionPerformed(ActionEvent evt) {
            InfoClasses.this.viewComboBoxActionPerformed();
        }
    }

    private class PaneComponentAdapter
    extends ComponentAdapter {
        private PaneComponentAdapter() {
        }

        public void componentShown(ComponentEvent evt) {
            InfoClasses.this.formComponentShown();
        }

        public void componentResized(ComponentEvent e) {
            InfoClasses.this.bsplit.setDividerLocation((int)(InfoClasses.this.getSize().getHeight() - 140.0));
            InfoClasses.this.asplit.setDividerLocation((int)(InfoClasses.this.getSize().getWidth() - 334.0));
        }
    }

    private class PaneFocusAdapter
    extends FocusAdapter {
        private PaneFocusAdapter() {
        }

        public void focusGained(FocusEvent evt) {
            InfoClasses.this.refresh();
        }
    }

    private class ClassPopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = 9141488354194857537L;

        ClassPopupMenu(JTreeTable treeTable) {
            if (treeTable == InfoClasses.this.availableTable) {
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_add1"), "shortcut EQUALS"));
            } else {
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_add1"), "shortcut EQUALS"));
                this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_remove1"), "shortcut MINUS"));
            }
        }

        private JMenuItem createAddMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new AddClassActionListener(), PropertyFactory.getString("in_add1"), '\u0000', accelerator, PropertyFactory.getString("in_add1lvl"), "Add16.gif", true);
        }

        private JMenuItem createRemoveMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new RemoveClassActionListener(), PropertyFactory.getString("in_remove1"), '\u0000', accelerator, PropertyFactory.getString("in_remove1lvl"), "Remove16.gif", true);
        }

        private class RemoveClassActionListener
        extends ClassActionListener {
            private RemoveClassActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoClasses.this.addClass(-1);
            }
        }

        private class ClassActionListener
        implements ActionListener {
            private ClassActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
            }
        }

        private class AddClassActionListener
        extends ClassActionListener {
            private AddClassActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoClasses.this.addClass(1);
            }
        }
    }

    private class ClassPopupListener
    extends MouseAdapter {
        private ClassPopupMenu menu;
        private JTree tree;

        ClassPopupListener(JTreeTable treeTable, ClassPopupMenu aMenu) {
            this.tree = treeTable.getTree();
            this.menu = aMenu;
            KeyListener myKeyListener = new KeyListener(this){
                private final /* synthetic */ ClassPopupListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTyped(KeyEvent e) {
                    ClassPopupListener.access$2000(this.this$1).dispatchEvent(e);
                }

                public void keyPressed(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    if (keyCode != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                        for (int i = 0; i < ClassPopupListener.access$2100(this.this$1).getComponentCount(); ++i) {
                            JMenuItem menuItem = (JMenuItem)ClassPopupListener.access$2100(this.this$1).getComponent(i);
                            KeyStroke ks = menuItem.getAccelerator();
                            if (ks == null || !keyStroke.equals(ks)) continue;
                            InfoClasses.access$2202(ClassPopupListener.access$2000(this.this$1), ClassPopupListener.access$2300(this.this$1).getSelectionPath());
                            menuItem.doClick(2);
                            return;
                        }
                    }
                    ClassPopupListener.access$2000(this.this$1).dispatchEvent(e);
                }

                public void keyReleased(KeyEvent e) {
                    ClassPopupListener.access$2000(this.this$1).dispatchEvent(e);
                }
            };
            treeTable.addKeyListener(myKeyListener);
        }

        public void mousePressed(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        private void maybeShowPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                InfoClasses.this.selPath = this.tree.getClosestPathForLocation(evt.getX(), evt.getY());
                if (InfoClasses.this.selPath == null) {
                    return;
                }
                this.tree.setSelectionPath(InfoClasses.this.selPath);
                this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        static /* synthetic */ InfoClasses access$2000(ClassPopupListener x0) {
            return x0.InfoClasses.this;
        }

        static /* synthetic */ ClassPopupMenu access$2100(ClassPopupListener x0) {
            return x0.menu;
        }

        static /* synthetic */ JTree access$2300(ClassPopupListener x0) {
            return x0.tree;
        }
    }

    private final class ClassModel
    extends AbstractTreeTableModel {
        private int modelType = 0;

        private ClassModel(int mode, boolean available) {
            super(null);
            if (!available) {
                this.modelType = 1;
            }
            this.resetModel(mode, available);
        }

        public boolean isCellEditable(Object node, int column) {
            return column == 0;
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return class$pcgen$gui$utils$TreeTableModel == null ? (class$pcgen$gui$utils$TreeTableModel = InfoClasses.class$("pcgen.gui.utils.TreeTableModel")) : class$pcgen$gui$utils$TreeTableModel;
                }
                case 1: {
                    if (this.modelType == 0) {
                        return class$java$lang$String == null ? (class$java$lang$String = InfoClasses.class$("java.lang.String")) : class$java$lang$String;
                    }
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = InfoClasses.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
                case 2: {
                    return class$java$lang$String == null ? (class$java$lang$String = InfoClasses.class$("java.lang.String")) : class$java$lang$String;
                }
            }
            Logging.errorPrint(PropertyFactory.getString("in_clICEr4") + " " + column + " " + PropertyFactory.getString("in_clICEr2"));
            return class$java$lang$String == null ? (class$java$lang$String = InfoClasses.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return PropertyFactory.getString("in_nameLabel");
                }
                case 1: {
                    if (this.modelType == 0) {
                        return PropertyFactory.getString("in_preReqs");
                    }
                    return PropertyFactory.getString("in_level");
                }
                case 2: {
                    return PropertyFactory.getString("in_sourceLabel");
                }
            }
            Logging.errorPrint(PropertyFactory.getString("in_clICEr3") + " " + column + " " + PropertyFactory.getString("in_clICEr2"));
            return "";
        }

        public Object getRoot() {
            return (PObjectNode)super.getRoot();
        }

        public Object getValueAt(Object node, int column) {
            PObjectNode fn = (PObjectNode)node;
            PCClass aClass = null;
            if (fn != null && fn.getItem() instanceof PCClass) {
                aClass = (PCClass)fn.getItem();
            }
            Integer c = new Integer(0);
            switch (column) {
                case 0: {
                    if (fn != null) {
                        return fn.toString();
                    }
                    Logging.errorPrint(PropertyFactory.getString("in_clICEr5"));
                    return "";
                }
                case 1: {
                    if (this.modelType == 0) {
                        if (aClass != null) {
                            return aClass.preReqHTMLStrings(InfoClasses.this.pc);
                        }
                        return "";
                    }
                    if (aClass != null) {
                        return new Integer(aClass.getLevel());
                    }
                    return c;
                }
                case 2: {
                    if (fn != null) {
                        return fn.getSource();
                    }
                    return "";
                }
                case -1: {
                    if (fn != null) {
                        return fn.getItem();
                    }
                    Logging.errorPrint(PropertyFactory.getString("in_clICEr5"));
                    return null;
                }
            }
            Logging.errorPrint(PropertyFactory.getString("in_clICEr6") + " " + column + " " + PropertyFactory.getString("in_ICEr2"));
            return null;
        }

        private void setRoot(PObjectNode aNode) {
            super.setRoot(aNode);
        }

        private void addSubClassesTo(PObjectNode aFN, PCClass aClass) {
            if (aClass.getSubClassList() != null && !aClass.getSubClassList().isEmpty()) {
                Iterator sI = aClass.getSubClassList().iterator();
                while (sI.hasNext()) {
                    SubClass sClass = (SubClass)sI.next();
                    PObjectNode aSN = new PObjectNode();
                    aSN.setParent(aFN);
                    aSN.setItem(sClass);
                    aSN.setIsValid(PrereqHandler.passesAll(sClass.getPreReqList(), InfoClasses.this.pc, sClass));
                    aFN.addChild(aSN);
                }
            }
        }

        private void resetModel(int mode, boolean available) {
            PObjectNode rootAsPObjectNode;
            Iterator fI = available ? Globals.getClassList().iterator() : InfoClasses.this.pc.getClassList().iterator();
            switch (mode) {
                case 0: {
                    PCClass aClass;
                    this.setRoot(new PObjectNode());
                    while (fI.hasNext()) {
                        aClass = (PCClass)fI.next();
                        if (!this.shouldDisplayThis(aClass)) continue;
                        PObjectNode aFN = new PObjectNode();
                        aFN.setParent((PObjectNode)super.getRoot());
                        aFN.setItem(aClass);
                        aFN.setIsValid(PrereqHandler.passesAll(aClass.getPreReqList(), InfoClasses.this.pc, aClass));
                        ((PObjectNode)super.getRoot()).addChild(aFN);
                        if (!available) continue;
                        this.addSubClassesTo(aFN, aClass);
                    }
                    break;
                }
                case 1: {
                    PCClass aClass;
                    this.setRoot((PObjectNode)typeRoot.clone());
                    while (fI.hasNext()) {
                        aClass = (PCClass)fI.next();
                        if (!this.shouldDisplayThis(aClass)) continue;
                        PObjectNode rootAsPObjectNode2 = (PObjectNode)super.getRoot();
                        boolean added = false;
                        for (int i = 0; i < rootAsPObjectNode2.getChildCount(); ++i) {
                            if ((added || i != rootAsPObjectNode2.getChildCount() - 1) && !aClass.isType(((PObjectNode)rootAsPObjectNode2.getChildren().get(i)).getItem().toString())) continue;
                            PObjectNode aFN = new PObjectNode();
                            aFN.setParent(rootAsPObjectNode2.getChild(i));
                            aFN.setItem(aClass);
                            aFN.setIsValid(PrereqHandler.passesAll(aClass.getPreReqList(), InfoClasses.this.pc, aClass));
                            rootAsPObjectNode2.getChild(i).addChild(aFN);
                            added = true;
                            if (!available) continue;
                            this.addSubClassesTo(aFN, aClass);
                        }
                    }
                    break;
                }
                default: {
                    Logging.errorPrint(PropertyFactory.getString("in_clICEr1") + " " + mode + " " + PropertyFactory.getString("in_clICEr2"));
                }
            }
            if ((rootAsPObjectNode = (PObjectNode)super.getRoot()).getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }

        private boolean shouldDisplayThis(PCClass aClass) {
            if (SettingsHandler.hideMonsterClasses() && aClass.isMonster()) {
                return false;
            }
            return this.modelType == 1 || aClass.isVisible() && InfoClasses.this.accept(InfoClasses.this.pc, aClass);
        }
    }
}

