/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import pcgen.core.Constants;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.NoteItem;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.NameGui;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.PortraitChooser;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.Utility;
import pcgen.gui.utils.WholeNumberField;
import pcgen.util.DecimalNumberField;
import pcgen.util.Delta;
import pcgen.util.PropertyFactory;

public final class InfoDescription
extends JPanel
implements CharacterInfoTab {
    static final long serialVersionUID = -8015559748421397718L;
    private static boolean needsUpdate = true;
    private static boolean bEditingAge = false;
    private static final int BIO_NOTEID = -2;
    private static final int DESCRIPTION_NOTEID = -3;
    private static final int COMPANION_NOTEID = -4;
    private static final int OTHERASSETS_NOTEID = -5;
    private static final int MAGICITEMS_NOTEID = -6;
    private static final int PORTRAIT_NOTEID = -7;
    private static final String in_noPortraitChildrenMessage = PropertyFactory.getString("in_noPortraitChildrenMessage");
    private static final String in_noPortraitDeletionMessage = PropertyFactory.getString("in_noPortraitDeletionMessage");
    private static final String in_noPortraitRenamingMessage = PropertyFactory.getString("in_noPortraitRenamingMessage");
    private ActionListener al1 = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            if (InfoDescription.this.handedComboBox != null && InfoDescription.this.handedComboBox.getSelectedItem() != null) {
                InfoDescription.this.pc.setDirty(true);
                InfoDescription.this.pc.setHanded(InfoDescription.this.handedComboBox.getSelectedItem().toString());
            }
        }
    };
    private ActionListener al2 = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            if (InfoDescription.this.genderComboBox != null && InfoDescription.this.genderComboBox.getSelectedItem() != null) {
                InfoDescription.this.pc.setDirty(true);
                InfoDescription.this.pc.setGender(InfoDescription.this.genderComboBox.getSelectedItem().toString());
            }
        }
    };
    private Border etched;
    private CardLayout dataLayout;
    private DecimalNumberField htText = new DecimalNumberField(0.0, 0);
    private DecimalNumberField wtText = new DecimalNumberField(0.0, 0);
    private DefaultTreeModel notesModel;
    private DocumentListener noteChangeListener = new DocumentListener(){

        public void insertUpdate(DocumentEvent e) {
            InfoDescription.this.textIsDirty = true;
        }

        public void removeUpdate(DocumentEvent e) {
            InfoDescription.this.textIsDirty = true;
        }

        public void changedUpdate(DocumentEvent e) {
            InfoDescription.this.textIsDirty = true;
        }
    };
    private FlippingSplitPane splitPane;
    private JButton addButton;
    private JButton checkAll;
    private JButton deleteButton;
    private JButton moveButton;
    private JButton randAll;
    private JButton randName;
    private JButton renameButton;
    private JButton revertButton;
    private JButton uncheckAll;
    private JCheckBox ageBox = new JCheckBox();
    private JCheckBox birthplaceBox = new JCheckBox();
    private JCheckBox catchPhraseBox = new JCheckBox();
    private JCheckBox eyeColorBox = new JCheckBox();
    private JCheckBox hairColorBox = new JCheckBox();
    private JCheckBox hairStyleBox = new JCheckBox();
    private JCheckBox htwtBox = new JCheckBox();
    private JCheckBox interestsBox = new JCheckBox();
    private JCheckBox locationBox = new JCheckBox();
    private JCheckBox personality1Box = new JCheckBox();
    private JCheckBox personality2Box = new JCheckBox();
    private JCheckBox phobiaBox = new JCheckBox();
    private JCheckBox residenceBox = new JCheckBox();
    private JCheckBox skinBox = new JCheckBox();
    private JCheckBox speechPatternBox = new JCheckBox();
    private JComboBoxEx ageComboBox = new JComboBoxEx();
    private JComboBoxEx genderComboBox = new JComboBoxEx();
    private JComboBoxEx handedComboBox = new JComboBoxEx();
    private JEditorPane dataText;
    private JLabel labelHeight = null;
    private JLabel labelName = null;
    private JLabel labelWeight = null;
    private JPanel buttonPanel;
    private JPanel centerCenterPanel = new JPanel();
    private JPanel centerNorthPanel = new JPanel();
    private JPanel centerPanel = new JPanel();
    private JPanel dataPanel;
    private JPanel northPanel = new JPanel();
    private JScrollPane dataScroll;
    private JScrollPane notesScroll;
    private JTextField birthplaceText = new JTextField();
    private JTextField catchPhraseText = new JTextField();
    private JTextField eyeColorText = new JTextField();
    private JTextField fregionText = new JTextField();
    private JTextField hairColorText = new JTextField();
    private JTextField hairStyleText = new JTextField();
    private JTextField interestsText = new JTextField();
    private JTextField locationText = new JTextField();
    private JTextField personality1Text = new JTextField();
    private JTextField personality2Text = new JTextField();
    private JTextField phobiaText = new JTextField();
    private JTextField playerNameText = new JTextField();
    private JTextField residenceText = new JTextField();
    private JTextField skinText = new JTextField();
    private JTextField speechPatternText = new JTextField();
    private JTextField txtName = new JTextField();
    private JTree notesTree;
    private List nodesToBeAddedList = new ArrayList();
    private NameGui nameFrame = null;
    private NoteItem bioNote = null;
    private NoteItem companionNote = null;
    private NoteItem currentItem = null;
    private NoteItem descriptionNote = null;
    private NoteItem lastItem = null;
    private NoteItem magicItemsNote = null;
    private NoteItem otherAssetsNote = null;
    private NoteItem portraitNote = null;
    private NoteTreeNode rootTreeNode;
    private PortraitChooser portrait;
    private WholeNumberField ageText = new WholeNumberField(0, 0);
    private boolean textIsDirty = false;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;

    public InfoDescription(PlayerCharacter pc) {
        this.pc = pc;
        this.setName(Constants.tabNames[3]);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoDescription.this.initComponents();
                InfoDescription.this.initNonDataDrivenEventListeners();
                InfoDescription.this.refreshDisplay();
            }
        });
    }

    public void setPc(PlayerCharacter pc) {
        if (this.pc != pc || pc.getSerial() > this.serial) {
            this.pc = pc;
            this.serial = pc.getSerial();
            this.forceRefresh();
        }
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Description.Order", 3);
    }

    public void setTabOrder(int order) {
        SettingsHandler.setPCGenOption(".Panel.Description.Order", order);
    }

    public String getTabName() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabName(3);
    }

    public boolean isShown() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabShown(3);
    }

    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    public JComponent getView() {
        return this;
    }

    public static void setNeedsUpdate(boolean flag) {
        needsUpdate = flag;
    }

    public JTextField getTxtName() {
        return this.txtName;
    }

    private void ageComboBoxActionPerformed() {
        String ageCategory;
        Race pcRace = this.pc.getRace();
        if (pcRace != null && !pcRace.equals(Globals.s_EMPTYRACE) && (ageCategory = (String)this.ageComboBox.getSelectedItem()) != null) {
            int idx = Globals.getBioSet().getAgeSetNamed(ageCategory);
            if (idx >= 0) {
                if (!bEditingAge) {
                    Globals.getBioSet().randomize("AGECAT" + Integer.toString(idx), this.pc);
                    this.ageText.setText(Integer.toString(this.pc.getAge()));
                    this.pc.setDirty(true);
                }
            } else {
                this.ageComboBox.setSelectedIndex(-1);
            }
        }
    }

    private void checkAll_click() {
        this.ageBox.setSelected(true);
        this.htwtBox.setSelected(true);
        this.skinBox.setSelected(true);
        this.hairColorBox.setSelected(true);
        this.hairStyleBox.setSelected(true);
        this.eyeColorBox.setSelected(true);
        this.speechPatternBox.setSelected(true);
        this.phobiaBox.setSelected(true);
        this.interestsBox.setSelected(true);
        this.catchPhraseBox.setSelected(true);
        this.personality1Box.setSelected(true);
        this.personality2Box.setSelected(true);
        this.residenceBox.setSelected(true);
        this.locationBox.setSelected(true);
        this.birthplaceBox.setSelected(true);
    }

    private void establishTreeNodes(NoteTreeNode aNode, NoteItem note) {
        int i;
        int index = -1;
        if (aNode == null) {
            aNode = this.rootTreeNode = new NoteTreeNode(null);
            ArrayList testList = this.pc.getNotesList();
            for (i = 0; i < testList.size(); ++i) {
                NoteItem testnote = (NoteItem)testList.get(i);
                if (testnote.getName().equals("Hidden")) continue;
                this.nodesToBeAddedList.add(testnote);
            }
            int order = 0;
            this.portraitNote = new NoteItem(-7, -1, PropertyFactory.getString("in_portrait"), "");
            this.nodesToBeAddedList.add(order++, this.portraitNote);
            this.bioNote = new NoteItem(-2, -1, "Bio", this.pc.getBio());
            this.nodesToBeAddedList.add(order++, this.bioNote);
            this.descriptionNote = new NoteItem(-3, -1, PropertyFactory.getString("in_descrip"), this.pc.getDescription());
            this.nodesToBeAddedList.add(order++, this.descriptionNote);
            this.companionNote = new NoteItem(-4, -1, PropertyFactory.getString("in_companions"), (String)this.pc.getMiscList().get(1));
            this.nodesToBeAddedList.add(order++, this.companionNote);
            this.otherAssetsNote = new NoteItem(-5, -1, PropertyFactory.getString("in_otherAssets"), (String)this.pc.getMiscList().get(0));
            this.nodesToBeAddedList.add(order++, this.otherAssetsNote);
            this.magicItemsNote = new NoteItem(-6, -1, PropertyFactory.getString("in_magicItems"), (String)this.pc.getMiscList().get(2));
            this.nodesToBeAddedList.add(order++, this.magicItemsNote);
        } else {
            index = note.getId();
        }
        ArrayList<NoteItem> aList = new ArrayList<NoteItem>();
        for (int x = 0; x < this.nodesToBeAddedList.size(); ++x) {
            NoteItem ni = (NoteItem)this.nodesToBeAddedList.get(x);
            if (ni.getParentId() != index) continue;
            NoteTreeNode dNode = new NoteTreeNode(ni);
            aNode.add(dNode);
            this.nodesToBeAddedList.remove(x);
            --x;
            aList.add(ni);
        }
        for (i = 0; i < aNode.getChildCount(); ++i) {
            this.establishTreeNodes((NoteTreeNode)aNode.getChildAt(i), (NoteItem)aList.get(i));
        }
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.getStatusBar().setText("");
        this.refresh();
    }

    private void initComponents() {
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.northPanel.setLayout(gridbag);
        Utility.buildConstraints(c, 0, 0, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        this.labelName = new JLabel(PropertyFactory.getString("in_nameLabel") + ": ");
        gridbag.setConstraints(this.labelName, c);
        this.northPanel.add(this.labelName);
        Utility.buildConstraints(c, 1, 0, 2, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.txtName, c);
        this.northPanel.add(this.txtName);
        Utility.buildConstraints(c, 3, 0, 2, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 17;
        this.randName = new JButton(PropertyFactory.getString("in_randomButton"));
        gridbag.setConstraints(this.randName, c);
        this.northPanel.add(this.randName);
        Utility.buildConstraints(c, 0, 1, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        JLabel label = new JLabel(PropertyFactory.getString("in_player") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 1, 1, 2, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.playerNameText, c);
        this.northPanel.add(this.playerNameText);
        Utility.buildConstraints(c, 7, 1, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        label = new JLabel(PropertyFactory.getString("in_gender") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 8, 1, 1, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.genderComboBox, c);
        this.northPanel.add(this.genderComboBox);
        this.genderComboBox.addItem(PropertyFactory.getString("in_genderMale"));
        this.genderComboBox.addItem(PropertyFactory.getString("in_genderFemale"));
        this.genderComboBox.addItem(PropertyFactory.getString("in_genderNeuter"));
        this.genderComboBox.addItem(PropertyFactory.getString("in_comboNone"));
        this.genderComboBox.addItem(PropertyFactory.getString("in_comboOther"));
        Utility.buildConstraints(c, 7, 2, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        label = new JLabel(PropertyFactory.getString("in_handString") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 8, 2, 1, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.handedComboBox, c);
        this.northPanel.add(this.handedComboBox);
        this.handedComboBox.addItem(PropertyFactory.getString("in_handRight"));
        this.handedComboBox.addItem(PropertyFactory.getString("in_handLeft"));
        this.handedComboBox.addItem(PropertyFactory.getString("in_handBoth"));
        this.handedComboBox.addItem(PropertyFactory.getString("in_comboNone"));
        this.handedComboBox.addItem(PropertyFactory.getString("in_comboOther"));
        Utility.buildConstraints(c, 0, 2, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        this.labelHeight = " ftin".equals(Globals.getHeightUnit()) ? new JLabel(PropertyFactory.getString("in_height") + " (in.): ") : new JLabel(PropertyFactory.getString("in_height") + " (" + Globals.getUnitSet().getHeightUnit() + "): ");
        gridbag.setConstraints(this.labelHeight, c);
        this.northPanel.add(this.labelHeight);
        Utility.buildConstraints(c, 1, 2, 2, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.htText, c);
        this.northPanel.add(this.htText);
        Utility.buildConstraints(c, 3, 2, 1, 2, 5.0, 10.0);
        c.fill = 10;
        c.anchor = 17;
        gridbag.setConstraints(this.htwtBox, c);
        this.northPanel.add(this.htwtBox);
        Utility.buildConstraints(c, 0, 3, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        this.labelWeight = new JLabel(PropertyFactory.getString("in_weight") + " (" + Globals.getUnitSet().getWeightUnit() + "): ");
        gridbag.setConstraints(this.labelWeight, c);
        this.northPanel.add(this.labelWeight);
        Utility.buildConstraints(c, 1, 3, 2, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.wtText, c);
        this.northPanel.add(this.wtText);
        Utility.buildConstraints(c, 0, 4, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        label = new JLabel(PropertyFactory.getString("in_age") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 1, 4, 1, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.ageText, c);
        this.northPanel.add(this.ageText);
        ArrayList<String> cats = new ArrayList<String>();
        Iterator e = Globals.getBioSet().getAgeMap().values().iterator();
        while (e.hasNext()) {
            String aString = (String)e.next();
            int idx = aString.indexOf(9);
            if (idx >= 0) {
                aString = aString.substring(0, idx);
            }
            if (cats.contains(aString)) continue;
            cats.add(aString);
        }
        Collections.sort(cats);
        this.ageComboBox.setModel(new DefaultComboBoxModel<Object>(cats.toArray()));
        this.ageComboBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    InfoDescription.this.ageComboBoxActionPerformed();
                }
            }
        });
        Utility.buildConstraints(c, 2, 4, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        gridbag.setConstraints(this.ageComboBox, c);
        this.northPanel.add(this.ageComboBox);
        Utility.buildConstraints(c, 3, 4, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 17;
        gridbag.setConstraints(this.ageBox, c);
        this.northPanel.add(this.ageBox);
        Utility.buildConstraints(c, 7, 3, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        label = new JLabel(PropertyFactory.getString("in_skin") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 8, 3, 1, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.skinText, c);
        this.northPanel.add(this.skinText);
        Utility.buildConstraints(c, 9, 3, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 17;
        gridbag.setConstraints(this.skinBox, c);
        this.northPanel.add(this.skinBox);
        Utility.buildConstraints(c, 4, 1, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        label = new JLabel(PropertyFactory.getString("in_region") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 5, 1, 1, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.fregionText, c);
        this.northPanel.add(this.fregionText);
        this.fregionText.setEditable(false);
        Utility.buildConstraints(c, 4, 2, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        label = new JLabel(PropertyFactory.getString("in_birthplace") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 5, 2, 1, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.birthplaceText, c);
        this.northPanel.add(this.birthplaceText);
        Utility.buildConstraints(c, 6, 2, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 17;
        gridbag.setConstraints(this.birthplaceBox, c);
        this.northPanel.add(this.birthplaceBox);
        Utility.buildConstraints(c, 4, 5, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        label = new JLabel(PropertyFactory.getString("in_phobias") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 5, 5, 1, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.phobiaText, c);
        this.northPanel.add(this.phobiaText);
        Utility.buildConstraints(c, 6, 5, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 17;
        gridbag.setConstraints(this.phobiaBox, c);
        this.northPanel.add(this.phobiaBox);
        Utility.buildConstraints(c, 4, 3, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        label = new JLabel(PropertyFactory.getString("in_personality") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 5, 3, 1, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.personality1Text, c);
        this.northPanel.add(this.personality1Text);
        Utility.buildConstraints(c, 6, 3, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 17;
        gridbag.setConstraints(this.personality1Box, c);
        this.northPanel.add(this.personality1Box);
        Utility.buildConstraints(c, 7, 4, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        label = new JLabel(PropertyFactory.getString("in_eye") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 8, 4, 1, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.eyeColorText, c);
        this.northPanel.add(this.eyeColorText);
        Utility.buildConstraints(c, 9, 4, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 17;
        gridbag.setConstraints(this.eyeColorBox, c);
        this.northPanel.add(this.eyeColorBox);
        Utility.buildConstraints(c, 4, 6, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        label = new JLabel(PropertyFactory.getString("in_interest") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 5, 6, 1, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.interestsText, c);
        this.northPanel.add(this.interestsText);
        Utility.buildConstraints(c, 6, 6, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 17;
        gridbag.setConstraints(this.interestsBox, c);
        this.northPanel.add(this.interestsBox);
        Utility.buildConstraints(c, 4, 4, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        label = new JLabel(PropertyFactory.getString("in_personality") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 5, 4, 1, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.personality2Text, c);
        this.northPanel.add(this.personality2Text);
        Utility.buildConstraints(c, 6, 4, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 17;
        gridbag.setConstraints(this.personality2Box, c);
        this.northPanel.add(this.personality2Box);
        Utility.buildConstraints(c, 7, 5, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        label = new JLabel(PropertyFactory.getString("in_hair") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 8, 5, 1, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.hairColorText, c);
        this.northPanel.add(this.hairColorText);
        Utility.buildConstraints(c, 9, 5, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 17;
        gridbag.setConstraints(this.hairColorBox, c);
        this.northPanel.add(this.hairColorBox);
        Utility.buildConstraints(c, 0, 6, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        label = new JLabel(PropertyFactory.getString("in_home") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 1, 6, 2, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.residenceText, c);
        this.northPanel.add(this.residenceText);
        Utility.buildConstraints(c, 3, 6, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 17;
        gridbag.setConstraints(this.residenceBox, c);
        this.northPanel.add(this.residenceBox);
        Utility.buildConstraints(c, 7, 7, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        label = new JLabel(PropertyFactory.getString("in_speech") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 8, 7, 1, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.speechPatternText, c);
        this.northPanel.add(this.speechPatternText);
        Utility.buildConstraints(c, 9, 7, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 17;
        gridbag.setConstraints(this.speechPatternBox, c);
        this.northPanel.add(this.speechPatternBox);
        Utility.buildConstraints(c, 7, 6, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        label = new JLabel(PropertyFactory.getString("in_style") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 8, 6, 1, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.hairStyleText, c);
        this.northPanel.add(this.hairStyleText);
        Utility.buildConstraints(c, 9, 6, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 17;
        gridbag.setConstraints(this.hairStyleBox, c);
        this.northPanel.add(this.hairStyleBox);
        Utility.buildConstraints(c, 0, 5, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        label = new JLabel(PropertyFactory.getString("in_location") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 1, 5, 2, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.locationText, c);
        this.northPanel.add(this.locationText);
        Utility.buildConstraints(c, 3, 5, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 17;
        gridbag.setConstraints(this.locationBox, c);
        this.northPanel.add(this.locationBox);
        Utility.buildConstraints(c, 4, 7, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 13;
        label = new JLabel(PropertyFactory.getString("in_phrase") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 5, 7, 1, 1, 5.0, 10.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.catchPhraseText, c);
        this.northPanel.add(this.catchPhraseText);
        Utility.buildConstraints(c, 6, 7, 1, 1, 5.0, 10.0);
        c.fill = 0;
        c.anchor = 17;
        gridbag.setConstraints(this.catchPhraseBox, c);
        this.northPanel.add(this.catchPhraseBox);
        this.centerNorthPanel.setLayout(new BorderLayout());
        JPanel pane = new JPanel(new FlowLayout());
        this.checkAll = new JButton(PropertyFactory.getString("in_checkButton"));
        pane.add(this.checkAll);
        this.randAll = new JButton(PropertyFactory.getString("in_randomButton"));
        pane.add(this.randAll);
        this.uncheckAll = new JButton(PropertyFactory.getString("in_uncheckButton"));
        pane.add(this.uncheckAll);
        this.centerNorthPanel.add((Component)pane, "North");
        this.txtName.setMinimumSize(new Dimension(110, 21));
        this.txtName.setPreferredSize(new Dimension(200, 21));
        this.playerNameText.setMinimumSize(new Dimension(110, 21));
        this.playerNameText.setPreferredSize(new Dimension(200, 21));
        this.htText.setMinimumSize(new Dimension(110, 21));
        this.htText.setPreferredSize(new Dimension(200, 21));
        this.wtText.setMinimumSize(new Dimension(110, 21));
        this.wtText.setPreferredSize(new Dimension(200, 21));
        this.ageText.setMinimumSize(new Dimension(110, 21));
        this.ageText.setPreferredSize(new Dimension(200, 21));
        this.genderComboBox.setMinimumSize(new Dimension(110, 21));
        this.genderComboBox.setPreferredSize(new Dimension(200, 21));
        this.handedComboBox.setMinimumSize(new Dimension(110, 21));
        this.handedComboBox.setPreferredSize(new Dimension(200, 21));
        this.skinText.setMinimumSize(new Dimension(110, 21));
        this.skinText.setPreferredSize(new Dimension(200, 21));
        this.eyeColorText.setMinimumSize(new Dimension(110, 21));
        this.eyeColorText.setPreferredSize(new Dimension(200, 21));
        this.hairColorText.setMinimumSize(new Dimension(110, 21));
        this.hairColorText.setPreferredSize(new Dimension(200, 21));
        this.hairStyleText.setMinimumSize(new Dimension(110, 21));
        this.hairStyleText.setPreferredSize(new Dimension(200, 21));
        this.speechPatternText.setMinimumSize(new Dimension(110, 21));
        this.speechPatternText.setPreferredSize(new Dimension(200, 21));
        this.phobiaText.setMinimumSize(new Dimension(110, 21));
        this.phobiaText.setPreferredSize(new Dimension(200, 21));
        this.interestsText.setMinimumSize(new Dimension(110, 21));
        this.interestsText.setPreferredSize(new Dimension(200, 21));
        this.catchPhraseText.setMinimumSize(new Dimension(110, 21));
        this.catchPhraseText.setPreferredSize(new Dimension(200, 21));
        this.personality1Text.setMinimumSize(new Dimension(110, 21));
        this.personality1Text.setPreferredSize(new Dimension(200, 21));
        this.personality2Text.setMinimumSize(new Dimension(110, 21));
        this.personality2Text.setPreferredSize(new Dimension(200, 21));
        this.fregionText.setMinimumSize(new Dimension(110, 21));
        this.fregionText.setPreferredSize(new Dimension(200, 21));
        this.residenceText.setMinimumSize(new Dimension(110, 21));
        this.residenceText.setPreferredSize(new Dimension(200, 21));
        this.locationText.setMinimumSize(new Dimension(110, 21));
        this.locationText.setPreferredSize(new Dimension(200, 21));
        this.birthplaceText.setMinimumSize(new Dimension(110, 21));
        this.birthplaceText.setPreferredSize(new Dimension(200, 21));
        this.randAll.setMinimumSize(new Dimension(90, 25));
        this.randAll.setPreferredSize(new Dimension(90, 25));
        this.checkAll.setMinimumSize(new Dimension(90, 25));
        this.checkAll.setPreferredSize(new Dimension(90, 25));
        this.uncheckAll.setMinimumSize(new Dimension(110, 25));
        this.uncheckAll.setPreferredSize(new Dimension(110, 25));
        this.randName.setMinimumSize(new Dimension(90, 21));
        this.randName.setPreferredSize(new Dimension(90, 21));
        this.setLayout(new BorderLayout());
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new FlowLayout());
        this.addButton = new JButton(PropertyFactory.getString("in_add"));
        this.deleteButton = new JButton(PropertyFactory.getString("in_delete"));
        this.renameButton = new JButton(PropertyFactory.getString("in_rename"));
        this.revertButton = new JButton(PropertyFactory.getString("in_revert"));
        this.moveButton = new JButton(PropertyFactory.getString("in_move"));
        this.buttonPanel.add(this.addButton);
        this.buttonPanel.add(this.deleteButton);
        this.buttonPanel.add(this.renameButton);
        this.buttonPanel.add(this.moveButton);
        this.buttonPanel.add(this.revertButton);
        this.establishTreeNodes(null, null);
        this.notesModel = new DefaultTreeModel(this.rootTreeNode);
        this.notesTree = new JTree(this.notesModel);
        this.notesTree.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 0));
        this.notesScroll = new JScrollPane(this.notesTree);
        this.notesScroll.setViewportView(this.notesTree);
        this.dataText = new JTextPane();
        this.dataText.setEditable(true);
        this.dataText.setText("");
        this.dataScroll = new JScrollPane(this.dataText);
        this.dataScroll.setViewportView(this.dataText);
        this.portrait = new PortraitChooser(null);
        this.dataLayout = new CardLayout();
        this.dataPanel = new JPanel();
        this.dataPanel.setLayout(this.dataLayout);
        this.dataPanel.add((Component)this.dataScroll, PropertyFactory.getString("in_notes"));
        this.dataPanel.add((Component)this.portrait, PropertyFactory.getString("in_portraits"));
        this.splitPane = new FlippingSplitPane(1, this.notesScroll, this.dataPanel);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.splitPane.setDividerLocation(100);
        TitledBorder title1 = BorderFactory.createTitledBorder(this.etched, PropertyFactory.getString("in_notes"));
        title1.setTitleJustification(1);
        this.centerCenterPanel.setBorder(title1);
        this.centerCenterPanel.setLayout(new BorderLayout());
        this.centerCenterPanel.add((Component)this.splitPane, "Center");
        this.centerCenterPanel.add((Component)this.buttonPanel, "South");
        this.centerPanel.setLayout(new BorderLayout());
        this.centerPanel.add((Component)this.centerCenterPanel, "Center");
        this.centerPanel.add((Component)this.centerNorthPanel, "North");
        this.setLayout(new BorderLayout());
        this.add((Component)this.northPanel, "North");
        this.add((Component)this.centerPanel, "Center");
        Utility.setDescription(this.ageBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.htwtBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.skinBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.hairColorBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.hairStyleBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.eyeColorBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.speechPatternBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.phobiaBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.interestsBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.catchPhraseBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.personality1Box, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.personality2Box, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.residenceBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.locationBox, PropertyFactory.getString("in_randCheckTipString"));
        Utility.setDescription(this.randName, PropertyFactory.getString("in_randNameTipString"));
        Utility.setDescription(this.randAll, PropertyFactory.getString("in_randTraitTipString"));
        Utility.setDescription(this.checkAll, PropertyFactory.getString("in_checkTipString"));
        Utility.setDescription(this.uncheckAll, PropertyFactory.getString("in_uncheckTipString"));
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                InfoDescription.this.formComponentShown();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                InfoDescription.this.refresh();
            }
        });
        this.readyForRefresh = true;
    }

    private void initNonDataDrivenEventListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                InfoDescription.this.formComponentShown();
            }
        });
        this.txtName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfoDescription.this.txtName_Changed();
                InfoDescription.this.labelName.requestFocus();
            }
        });
        this.txtName.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                InfoDescription.this.txtName_Changed();
            }
        });
        this.randName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (InfoDescription.this.nameFrame == null) {
                    InfoDescription.this.nameFrame = new NameGui();
                }
                InfoDescription.this.nameFrame.setVisible(true);
            }
        });
        FocusAdapter fl = new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                InfoDescription.this.updateTextFields();
            }
        };
        this.skinText.addFocusListener(fl);
        this.hairColorText.addFocusListener(fl);
        this.hairStyleText.addFocusListener(fl);
        this.eyeColorText.addFocusListener(fl);
        this.speechPatternText.addFocusListener(fl);
        this.phobiaText.addFocusListener(fl);
        this.interestsText.addFocusListener(fl);
        this.catchPhraseText.addFocusListener(fl);
        this.personality1Text.addFocusListener(fl);
        this.personality2Text.addFocusListener(fl);
        this.fregionText.addFocusListener(fl);
        this.residenceText.addFocusListener(fl);
        this.locationText.addFocusListener(fl);
        this.birthplaceText.addFocusListener(fl);
        this.checkAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoDescription.this.checkAll_click();
            }
        });
        this.randAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoDescription.this.randAll_click();
                InfoDescription.this.pc.setDirty(true);
            }
        });
        this.uncheckAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoDescription.this.uncheckAll_click();
            }
        });
        this.ageText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                InfoDescription.this.pc.setDirty(true);
                InfoDescription.this.pc.setAge(Delta.parseInt("0" + InfoDescription.this.ageText.getText()));
                InfoDescription.this.updateDisplayedAge();
            }
        });
        this.htText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                InfoDescription.this.pc.setDirty(true);
                InfoDescription.this.pc.setHeight(Delta.parseDouble("0" + InfoDescription.this.htText.getText()));
            }
        });
        this.wtText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                InfoDescription.this.pc.setDirty(true);
                InfoDescription.this.pc.setWeight(Delta.parseDouble("0" + InfoDescription.this.wtText.getText()));
            }
        });
        this.playerNameText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                InfoDescription.this.pc.setPlayersName(InfoDescription.this.playerNameText.getText());
            }
        });
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = InfoDescription.this.notesTree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = InfoDescription.this.notesTree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1 && e.getClickCount() == 1 && selPath != null) {
                    InfoDescription.this.selectNotesNode(selRow);
                }
                InfoDescription.this.lastItem = null;
            }
        };
        this.notesTree.addMouseListener(ml);
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int parentId = -1;
                int newNodeId = 0;
                TreePath selPath = InfoDescription.this.notesTree.getSelectionPath();
                if (selPath == null) {
                    return;
                }
                NoteTreeNode parentTreeNode = (NoteTreeNode)selPath.getLastPathComponent();
                if (parentTreeNode != null && parentTreeNode.getItem() != null) {
                    parentId = parentTreeNode.getItem().getId();
                }
                if (parentId == -7) {
                    JOptionPane.showMessageDialog(null, in_noPortraitChildrenMessage);
                    return;
                }
                Iterator allNotes = InfoDescription.this.pc.getNotesList().iterator();
                while (allNotes.hasNext()) {
                    NoteItem currItem = (NoteItem)allNotes.next();
                    if (currItem.getId() <= newNodeId) continue;
                    newNodeId = currItem.getId();
                }
                NoteItem a = new NoteItem(++newNodeId, parentId, PropertyFactory.getString("in_newItem"), PropertyFactory.getString("in_newValue"));
                NoteTreeNode aNode = new NoteTreeNode(a);
                if (parentTreeNode != null) {
                    parentTreeNode.add(aNode);
                }
                InfoDescription.this.pc.addNotesItem(a);
                InfoDescription.this.pc.setDirty(true);
                InfoDescription.this.notesTree.expandPath(selPath);
                InfoDescription.this.notesTree.updateUI();
            }
        });
        Utility.setDescription(this.addButton, PropertyFactory.getString("in_addChild"));
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                int numChildren = 0;
                TreePath selPath = InfoDescription.this.notesTree.getSelectionPath();
                if (selPath == null) {
                    return;
                }
                Object anObject = selPath.getLastPathComponent();
                if (anObject == null || ((NoteTreeNode)anObject).getItem() == null) {
                    return;
                }
                NoteTreeNode aNode = (NoteTreeNode)anObject;
                if (aNode.getItem().getId() == -7) {
                    JOptionPane.showMessageDialog(null, in_noPortraitDeletionMessage);
                    return;
                }
                Enumeration<TreeNode> allChildren = aNode.breadthFirstEnumeration();
                while (allChildren.hasMoreElements()) {
                    NoteTreeNode ancestorNode = (NoteTreeNode)allChildren.nextElement();
                    if (ancestorNode == aNode) continue;
                    ++numChildren;
                }
                int reallyDelete = JOptionPane.showConfirmDialog(null, PropertyFactory.getString("in_delNote1") + " " + aNode.toString() + (numChildren > 0 ? " " + PropertyFactory.getString("in_delNote2") + " " + numChildren + " " + PropertyFactory.getString("in_delNote3") : " ") + "?", PropertyFactory.getString("in_delNote4"), 2);
                if (reallyDelete == 0) {
                    NoteTreeNode parent = (NoteTreeNode)aNode.getParent();
                    if (parent != null) {
                        allChildren = aNode.breadthFirstEnumeration();
                        while (allChildren.hasMoreElements()) {
                            NoteTreeNode ancestorNode = (NoteTreeNode)allChildren.nextElement();
                            InfoDescription.this.pc.getNotesList().remove(ancestorNode.getItem());
                        }
                        parent.remove(aNode);
                        InfoDescription.this.pc.setDirty(true);
                    }
                    InfoDescription.this.notesTree.updateUI();
                }
            }
        });
        Utility.setDescription(this.deleteButton, PropertyFactory.getString("in_delSelIt"));
        this.renameButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreePath selPath = InfoDescription.this.notesTree.getSelectionPath();
                if (selPath == null) {
                    return;
                }
                Object anObject = selPath.getLastPathComponent();
                if (anObject == null || ((NoteTreeNode)anObject).getItem() == null) {
                    return;
                }
                NoteTreeNode aNode = (NoteTreeNode)anObject;
                if (aNode.getItem().getId() == -7) {
                    JOptionPane.showMessageDialog(null, in_noPortraitRenamingMessage);
                    return;
                }
                String selectedValue = JOptionPane.showInputDialog(null, PropertyFactory.getString("in_idEnNewName"), "PCGen", 3);
                if (selectedValue != null && selectedValue.trim().length() > 0) {
                    aNode.getItem().setName(selectedValue.trim());
                    InfoDescription.this.pc.setDirty(true);
                    InfoDescription.this.notesTree.updateUI();
                }
            }
        });
        Utility.setDescription(this.renameButton, PropertyFactory.getString("in_idRenSelIt"));
        this.revertButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
            }
        });
        Utility.setDescription(this.revertButton, PropertyFactory.getString("in_idLoseChan"));
        this.revertButton.setEnabled(false);
        this.moveButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoDescription.this.lastItem = InfoDescription.this.currentItem;
            }
        });
        Utility.setDescription(this.moveButton, PropertyFactory.getString("in_idSwitch"));
        this.dataText.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                InfoDescription.this.updateNoteItem();
            }
        });
        this.notesTree.addMouseListener(new NotePopupListener(this.notesTree, new NotePopupMenu()));
    }

    private void randAll_click() {
        int roll;
        int iSize;
        List globalTraitList = SystemCollections.getUnmodifiableTraitList();
        List globalPhobiaList = SystemCollections.getUnmodifiablePhobiaList();
        List globalLocationList = SystemCollections.getUnmodifiableLocationList();
        List globalInterestsList = SystemCollections.getUnmodifiableInterestsList();
        List globalPhraseList = SystemCollections.getUnmodifiablePhraseList();
        List globalHairStyleList = SystemCollections.getUnmodifiableHairStyleList();
        List globalSpeechList = SystemCollections.getUnmodifiableSpeechList();
        List globalCityList = SystemCollections.getUnmodifiableCityList();
        List globalBirthplaceList = SystemCollections.getUnmodifiableBirthplaceList();
        StringBuffer randomString = new StringBuffer();
        if (this.eyeColorBox.isSelected()) {
            randomString.append("EYES.");
        }
        if (this.hairColorBox.isSelected()) {
            randomString.append("HAIR.");
        }
        if (this.skinBox.isSelected()) {
            randomString.append("SKIN.");
        }
        if ((iSize = globalTraitList.size()) != 0 && this.personality1Box.isSelected()) {
            roll = Globals.getRandomInt();
            if (roll < 0) {
                roll = -roll;
            }
            this.personality1Text.setText((String)globalTraitList.get(roll %= iSize));
        }
        if (iSize != 0 && this.personality2Box.isSelected()) {
            roll = Globals.getRandomInt();
            if (roll < 0) {
                roll = -roll;
            }
            this.personality2Text.setText((String)globalTraitList.get(roll %= iSize));
        }
        if ((iSize = globalPhobiaList.size()) != 0 && this.phobiaBox.isSelected()) {
            roll = Globals.getRandomInt();
            if (roll < 0) {
                roll = -roll;
            }
            this.phobiaText.setText((String)globalPhobiaList.get(roll %= iSize));
        }
        if ((iSize = globalLocationList.size()) != 0 && this.locationBox.isSelected()) {
            roll = Globals.getRandomInt();
            if (roll < 0) {
                roll = -roll;
            }
            this.locationText.setText((String)globalLocationList.get(roll %= iSize));
        }
        if ((iSize = globalInterestsList.size()) != 0 && this.interestsBox.isSelected()) {
            roll = Globals.getRandomInt();
            if (roll < 0) {
                roll = -roll;
            }
            this.interestsText.setText((String)globalInterestsList.get(roll %= iSize));
        }
        if ((iSize = globalPhraseList.size()) != 0 && this.catchPhraseBox.isSelected()) {
            roll = Globals.getRandomInt();
            if (roll < 0) {
                roll = -roll;
            }
            this.catchPhraseText.setText((String)globalPhraseList.get(roll %= iSize));
        }
        if ((iSize = globalHairStyleList.size()) != 0 && this.hairStyleBox.isSelected()) {
            roll = Globals.getRandomInt();
            if (roll < 0) {
                roll = -roll;
            }
            this.hairStyleText.setText((String)globalHairStyleList.get(roll %= iSize));
        }
        if ((iSize = globalSpeechList.size()) != 0 && this.speechPatternBox.isSelected()) {
            roll = Globals.getRandomInt();
            if (roll < 0) {
                roll = -roll;
            }
            this.speechPatternText.setText((String)globalSpeechList.get(roll %= iSize));
        }
        if (this.htwtBox.isSelected()) {
            randomString.append("HT.WT.");
        }
        if (this.ageBox.isSelected()) {
            String ageCategory = (String)this.ageComboBox.getSelectedItem();
            if (ageCategory != null) {
                int idx = Globals.getBioSet().getAgeSetNamed(ageCategory);
                if (idx >= 0) {
                    randomString.append("AGECAT").append(idx).append('.');
                }
            } else {
                randomString.append("AGE.");
            }
        }
        if ((iSize = globalCityList.size()) != 0 && this.residenceBox.isSelected()) {
            roll = Globals.getRandomInt();
            if (roll < 0) {
                roll = -roll;
            }
            this.residenceText.setText((String)globalCityList.get(roll %= iSize));
        }
        if ((iSize = globalBirthplaceList.size()) != 0 && this.birthplaceBox.isSelected()) {
            roll = Globals.getRandomInt();
            if (roll < 0) {
                roll = -roll;
            }
            this.birthplaceText.setText((String)globalBirthplaceList.get(roll %= iSize));
        }
        this.updateTextFields();
        if (randomString.length() > 0) {
            Globals.getBioSet().randomize(randomString.toString(), this.pc);
            this.refreshDisplay();
        }
    }

    private void refreshDisplay() {
        Race pcRace = this.pc.getRace();
        if (!pcRace.equals(Globals.s_EMPTYRACE)) {
            this.handedComboBox.setSelectedItem(this.pc.getHanded());
            this.genderComboBox.setSelectedItem(this.pc.getGender());
            this.wtText.setText(Globals.displayWeightInUnitSet(this.pc.getWeight()));
            this.htText.setText(Globals.displayHeightInUnitSet(this.pc.getHeight()));
            if ("ftin".equals(Globals.getUnitSet().getHeightUnit())) {
                this.labelHeight.setText(PropertyFactory.getString("in_height") + " (in.): ");
            } else {
                this.labelHeight.setText(PropertyFactory.getString("in_height") + " (" + Globals.getUnitSet().getHeightUnit() + "): ");
            }
            this.labelWeight.setText(PropertyFactory.getString("in_weight") + " (" + Globals.getUnitSet().getWeightUnit() + "): ");
        }
        this.updateDisplayedAge();
        this.playerNameText.setText(this.pc.getPlayersName());
        this.txtName.setText(this.pc.getName());
        this.skinText.setText(this.pc.getSkinColor());
        this.fregionText.setText(this.pc.getFullRegion());
        this.hairColorText.setText(this.pc.getHairColor());
        this.hairStyleText.setText(this.pc.getHairStyle());
        this.eyeColorText.setText(this.pc.getEyeColor());
        this.speechPatternText.setText(this.pc.getSpeechTendency());
        this.phobiaText.setText(this.pc.getPhobias());
        this.interestsText.setText(this.pc.getInterests());
        this.catchPhraseText.setText(this.pc.getCatchPhrase());
        this.personality1Text.setText(this.pc.getTrait1());
        this.personality2Text.setText(this.pc.getTrait2());
        this.residenceText.setText(this.pc.getResidence());
        this.locationText.setText(this.pc.getLocation());
        this.birthplaceText.setText(this.pc.getBirthplace());
        if (this.portrait != null) {
            this.portrait.refresh(this.pc);
        }
    }

    private void selectNotesNode(int rowNum) {
        this.stopListeners();
        this.notesTree.requestFocus();
        this.notesTree.setSelectionRow(rowNum);
        TreePath path = this.notesTree.getSelectionPath();
        Object anObj = path.getLastPathComponent();
        if (anObj != null && anObj instanceof NoteTreeNode) {
            NoteItem selectedItem;
            if (this.currentItem != null) {
                this.updateNoteItem();
            }
            this.currentItem = selectedItem = ((NoteTreeNode)anObj).getItem();
            if (this.currentItem != null && this.currentItem.getId() == -7) {
                this.dataLayout.last(this.dataPanel);
            } else {
                this.dataLayout.first(this.dataPanel);
            }
            if (selectedItem != null) {
                this.dataText.setText(this.currentItem.getValue());
                if (this.lastItem != null) {
                    int oldParent = this.currentItem.getParentId();
                    this.currentItem.setParentId(this.lastItem.getParentId());
                    this.lastItem.setParentId(oldParent);
                    this.establishTreeNodes(null, null);
                    this.notesModel.setRoot(this.rootTreeNode);
                    this.notesTree.updateUI();
                }
                this.dataText.setEnabled(true);
                this.dataText.setEditable(true);
            } else {
                this.dataText.setText(PropertyFactory.getString("in_idNoteEdit"));
                this.dataText.setEnabled(false);
                this.dataText.setEditable(false);
            }
            this.dataText.setCaretPosition(0);
        }
        this.startListeners();
    }

    private void startListeners() {
        this.handedComboBox.addActionListener(this.al1);
        this.genderComboBox.addActionListener(this.al2);
        if (this.dataText != null && this.dataText.getDocument() != null) {
            this.dataText.getDocument().addDocumentListener(this.noteChangeListener);
        }
    }

    private void stopListeners() {
        this.handedComboBox.removeActionListener(this.al1);
        this.genderComboBox.removeActionListener(this.al2);
        if (this.dataText != null && this.dataText.getDocument() != null) {
            this.dataText.getDocument().removeDocumentListener(this.noteChangeListener);
        }
    }

    private void txtName_Changed() {
        if (this.pc != null) {
            this.pc.setName(this.txtName.getText());
            PCGen_Frame1.forceUpdate_PlayerTabs();
        }
    }

    private void uncheckAll_click() {
        this.ageBox.setSelected(false);
        this.htwtBox.setSelected(false);
        this.skinBox.setSelected(false);
        this.hairColorBox.setSelected(false);
        this.hairStyleBox.setSelected(false);
        this.eyeColorBox.setSelected(false);
        this.speechPatternBox.setSelected(false);
        this.phobiaBox.setSelected(false);
        this.interestsBox.setSelected(false);
        this.catchPhraseBox.setSelected(false);
        this.personality1Box.setSelected(false);
        this.personality2Box.setSelected(false);
        this.residenceBox.setSelected(false);
        this.locationBox.setSelected(false);
        this.birthplaceBox.setSelected(false);
    }

    private void updateCharacterInfo() {
        this.stopListeners();
        if (this.pc != null && this.currentItem != null) {
            this.updateNoteItem();
        }
        this.currentItem = null;
        this.dataText.setText("");
        if (this.pc == null) {
            this.startListeners();
            return;
        }
        this.refreshDisplay();
        this.establishTreeNodes(null, null);
        this.notesModel.setRoot(this.rootTreeNode);
        this.notesTree.updateUI();
        needsUpdate = false;
        this.startListeners();
        this.selectNotesNode(1);
    }

    private void updateDisplayedAge() {
        int selIdx = -1;
        this.ageText.setText(Integer.toString(this.pc.getAge()));
        Race pcRace = this.pc.getRace();
        if (pcRace != null && !pcRace.equals(Globals.s_EMPTYRACE)) {
            int idx = Globals.getBioSet().getPCAgeSet(this.pc);
            String aString = Globals.getBioSet().getAgeMapIndex(this.pc.getRegion(), idx);
            if (idx >= 0 && aString != null) {
                idx = aString.indexOf(9);
                if (idx > 0) {
                    aString = aString.substring(0, idx);
                }
                for (int i = 0; i < this.ageComboBox.getModel().getSize(); ++i) {
                    if (!aString.equals(this.ageComboBox.getModel().getElementAt(i))) continue;
                    selIdx = i;
                    break;
                }
            }
        }
        bEditingAge = true;
        this.ageComboBox.setSelectedIndex(selIdx);
        bEditingAge = false;
    }

    private void updateNoteItem() {
        if (this.currentItem != null && this.textIsDirty) {
            int x = this.pc.getNotesList().indexOf(this.currentItem);
            this.currentItem.setValue(this.dataText.getText());
            if (x > -1) {
                ((NoteItem)this.pc.getNotesList().get(x)).setValue(this.dataText.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.bioNote) {
                this.pc.setBio(this.dataText.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.descriptionNote) {
                this.pc.setDescription(this.dataText.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.companionNote) {
                this.pc.getMiscList().set(1, this.dataText.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.otherAssetsNote) {
                this.pc.getMiscList().set(0, this.dataText.getText());
                this.pc.setDirty(true);
            } else if (this.currentItem == this.magicItemsNote) {
                this.pc.getMiscList().set(2, this.dataText.getText());
                this.pc.setDirty(true);
            }
            this.textIsDirty = false;
        }
    }

    private void updateTextFields() {
        this.pc.setSkinColor(this.skinText.getText());
        this.pc.setHairColor(this.hairColorText.getText());
        this.pc.setHairStyle(this.hairStyleText.getText());
        this.pc.setEyeColor(this.eyeColorText.getText());
        this.pc.setSpeechTendency(this.speechPatternText.getText());
        this.pc.setPhobias(this.phobiaText.getText());
        this.pc.setInterests(this.interestsText.getText());
        this.pc.setCatchPhrase(this.catchPhraseText.getText());
        this.pc.setTrait1(this.personality1Text.getText());
        this.pc.setTrait2(this.personality2Text.getText());
        this.pc.setResidence(this.residenceText.getText());
        this.pc.setLocation(this.locationText.getText());
        this.pc.setBirthplace(this.birthplaceText.getText());
        this.pc.setAge(Delta.parseInt("0" + this.ageText.getText()));
        this.pc.setHeight(Delta.parseInt("0" + this.htText.getText()));
        this.pc.setWeight(Delta.parseInt("0" + this.wtText.getText()));
    }

    private class NoteTreeNode
    extends DefaultMutableTreeNode {
        static final long serialVersionUID = -8015559748421397718L;
        private NoteItem item;

        NoteTreeNode(NoteItem x) {
            this.item = x;
        }

        public String toString() {
            if (this.item != null) {
                return this.item.toString();
            }
            return InfoDescription.this.pc.getDisplayName();
        }

        private final NoteItem getItem() {
            return this.item;
        }
    }

    private class NotePopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = -8015559748421397718L;

        NotePopupMenu() {
            this.add(this.createAddMenuItem(PropertyFactory.getString("in_add"), "shortcut EQUALS"));
            this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_remove"), "shortcut MINUS"));
            this.add(this.createRenameMenuItem(PropertyFactory.getString("in_rename"), "alt M"));
            this.add(this.createMoveMenuItem(PropertyFactory.getString("in_move"), "alt Z"));
        }

        private JMenuItem createAddMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new AddNoteActionListener(), PropertyFactory.getString("in_add"), '\u0000', accelerator, PropertyFactory.getString("in_add"), "Add16.gif", true);
        }

        private JMenuItem createMoveMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new MoveNoteActionListener(), PropertyFactory.getString("in_move"), '\u0000', accelerator, PropertyFactory.getString("in_move"), "Add16.gif", true);
        }

        private JMenuItem createRemoveMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new RemoveNoteActionListener(), PropertyFactory.getString("in_delete"), '\u0000', accelerator, PropertyFactory.getString("in_delete"), "Remove16.gif", true);
        }

        private JMenuItem createRenameMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new RenameNoteActionListener(), PropertyFactory.getString("in_rename"), '\u0000', accelerator, PropertyFactory.getString("in_rename"), "Add16.gif", true);
        }

        private class RenameNoteActionListener
        extends NoteActionListener {
            RenameNoteActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoDescription.this.renameButton.doClick();
            }
        }

        private class RemoveNoteActionListener
        extends NoteActionListener {
            RemoveNoteActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoDescription.this.deleteButton.doClick();
            }
        }

        private class NoteActionListener
        implements ActionListener {
            private NoteTreeNode aNode = null;

            NoteActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
            }
        }

        private class MoveNoteActionListener
        extends NoteActionListener {
            MoveNoteActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoDescription.this.moveButton.doClick();
            }
        }

        private class AddNoteActionListener
        extends NoteActionListener {
            AddNoteActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoDescription.this.addButton.doClick();
            }
        }
    }

    private class NotePopupListener
    extends MouseAdapter {
        private JTree tree;
        private NotePopupMenu menu;

        NotePopupListener(JTree atree, NotePopupMenu aMenu) {
            this.tree = atree;
            this.menu = aMenu;
            KeyListener myKeyListener = new KeyListener(this){
                private final /* synthetic */ NotePopupListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTyped(KeyEvent e) {
                    NotePopupListener.access$3000(this.this$1).dispatchEvent(e);
                }

                public void keyPressed(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    if (keyCode != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                        for (int i = 0; i < NotePopupListener.access$3100(this.this$1).getComponentCount(); ++i) {
                            JMenuItem menuItem = (JMenuItem)NotePopupListener.access$3100(this.this$1).getComponent(i);
                            KeyStroke ks = menuItem.getAccelerator();
                            if (ks == null || !keyStroke.equals(ks)) continue;
                            menuItem.doClick(2);
                            return;
                        }
                    }
                    NotePopupListener.access$3000(this.this$1).dispatchEvent(e);
                }

                public void keyReleased(KeyEvent e) {
                    NotePopupListener.access$3000(this.this$1).dispatchEvent(e);
                }
            };
            this.tree.addKeyListener(myKeyListener);
        }

        public void mousePressed(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        private void maybeShowPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                TreePath selPath = this.tree.getClosestPathForLocation(evt.getX(), evt.getY());
                if (selPath == null) {
                    return;
                }
                this.tree.setSelectionPath(selPath);
                this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        static /* synthetic */ InfoDescription access$3000(NotePopupListener x0) {
            return x0.InfoDescription.this;
        }

        static /* synthetic */ NotePopupMenu access$3100(NotePopupListener x0) {
            return x0.menu;
        }
    }
}

