/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.ListSelectionModel;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import pcgen.core.CharacterDomain;
import pcgen.core.Constants;
import pcgen.core.Deity;
import pcgen.core.Domain;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfo;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.LstEditorMain;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.TableSorter;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class InfoDomain
extends FilterAdapterPanel
implements CharacterInfoTab {
    static final long serialVersionUID = -4223585346813683966L;
    private static List selectedDomainList = new ArrayList();
    private static boolean needsUpdate = true;
    private static int splitOrientation = 1;
    private static final String[] s_columnNames = new String[]{PropertyFactory.getString("in_nameLabel"), PropertyFactory.getString("in_domains"), PropertyFactory.getString("in_alignLabel"), PropertyFactory.getString("in_sourceLabel")};
    private static final String[] s_domainColList = new String[]{PropertyFactory.getString("in_domains"), PropertyFactory.getString("in_sourceLabel")};
    private DeityModel deityModel = new DeityModel();
    private DomainModel domainModel = new DomainModel();
    private FlippingSplitPane aSplit;
    private FlippingSplitPane bSplit;
    private FlippingSplitPane splitPane;
    private JButton deitySelect;
    private JButton domainSelect;
    private JLabel deityName;
    private JLabel domChosen = new JLabel();
    private JLabel domSelected;
    private JLabel domTotal = new JLabel();
    private JLabel ofLabel;
    private JLabelPane deityInfo = new JLabelPane();
    private JPanel center = new JPanel();
    private JTableEx deityTable = null;
    private JTableEx domainTable = null;
    private final int[] deiColumnWidth = new int[]{60, 231, 36, 71};
    private Border etched;
    private JLabelPane domainInfo = new JLabelPane();
    private JScrollPane deityScroll = new JScrollPane();
    private JScrollPane domainScroll = new JScrollPane();
    private TableSorter deitySorter = null;
    private TableSorter domainSorter = null;
    private boolean hasBeenSized = false;
    private int numDomains = 0;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;
    static /* synthetic */ Class class$java$lang$String;

    public InfoDomain(PlayerCharacter pc) {
        this.pc = pc;
        this.setName(Constants.tabNames[4]);
        this.initComponents();
        FilterFactory.restoreFilterSettings(this);
    }

    public void setPc(PlayerCharacter pc) {
        if (this.pc != pc || pc.getSerial() > this.serial) {
            this.pc = pc;
            this.serial = pc.getSerial();
            this.forceRefresh();
        }
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Domain.Order", 4);
    }

    public void setTabOrder(int order) {
        SettingsHandler.setPCGenOption(".Panel.Domain.Order", order);
    }

    public String getTabName() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabName(4);
    }

    public boolean isShown() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabShown(4);
    }

    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    public JComponent getView() {
        return this;
    }

    public static void setNeedsUpdate(boolean flag) {
        needsUpdate = flag;
    }

    public final boolean isMatchAnyEnabled() {
        return true;
    }

    public final boolean isNegateEnabled() {
        return true;
    }

    public final int getSelectionMode() {
        return 2;
    }

    public final void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
        FilterFactory.registerAllDeityFilters(this);
    }

    public final void refreshFiltering() {
        this.forceRefresh();
    }

    private void setDeityInfoText(Deity aDeity) {
        if (aDeity != null) {
            StringBuffer infoText = new StringBuffer().append("<html><b>").append(aDeity.piSubString()).append("</b>");
            String aString = aDeity.getTitle();
            if (aString.length() != 0) {
                infoText.append("&nbsp;(").append(aString).append(")");
            }
            infoText.append(" &nbsp;<b>").append(PropertyFactory.getString("in_descrip")).append("</b>:").append(aDeity.piDescString());
            aString = aDeity.preReqHTMLStrings(this.pc, false);
            if (aString.length() != 0) {
                infoText.append(" &nbsp;<b>").append(PropertyFactory.getString("in_requirements")).append("</b>:").append(aString);
            }
            if ((aString = aDeity.getFavoredWeapon()).length() != 0) {
                infoText.append(" &nbsp;<b>").append(PropertyFactory.getString("in_deityFavWeap")).append("</b>:").append(aString);
            }
            if ((aString = aDeity.getHolyItem()).length() != 0) {
                infoText.append(" &nbsp;<b>").append(PropertyFactory.getString("in_deityHolyIt")).append("</b>:").append(aString);
            }
            if ((aString = aDeity.getWorshippers()).length() != 0) {
                infoText.append(" &nbsp;<b>").append(PropertyFactory.getString("in_deityWorshippers")).append("</b>:").append(aString);
            }
            infoText.append("</html>");
            this.deityInfo.setText(infoText.toString());
        } else {
            this.deityInfo.setText();
        }
    }

    private void setDomainInfoText(Domain aDomain) {
        StringBuffer infoText = new StringBuffer().append("<html>");
        if (aDomain != null) {
            infoText.append("<b>").append(aDomain.piSubString());
            String aString = aDomain.getDescription();
            if (aString.length() != 0) {
                infoText.append(" &nbsp;").append(PropertyFactory.getString("in_domainGrant")).append("</b>:").append(aString);
            }
            if ((aString = aDomain.preReqHTMLStrings(this.pc, false)).length() != 0) {
                infoText.append(" &nbsp;<b>").append(PropertyFactory.getString("in_requirements")).append("</b>:").append(aString);
            }
        }
        infoText.append("</html>");
        this.domainInfo.setText(infoText.toString());
    }

    private final void addUnfilteredDomains(List availDomainList, Deity pcDeity) {
        availDomainList.clear();
        if (pcDeity != null) {
            Iterator iter = pcDeity.getDomainList().iterator();
            while (iter.hasNext()) {
                Domain aDomain = (Domain)iter.next();
                if (availDomainList.contains(aDomain = (Domain)aDomain.clone())) continue;
                availDomainList.add(aDomain);
            }
        }
        Iterator i = this.pc.getClassList().iterator();
        while (i.hasNext()) {
            Domain prestigeDomain;
            String prestigeName;
            int level;
            StringTokenizer domainTok;
            String prestigeString;
            PCClass aClass = (PCClass)i.next();
            Iterator d = aClass.getAddDomains().iterator();
            while (d.hasNext()) {
                prestigeString = d.next().toString();
                domainTok = new StringTokenizer(prestigeString, "|", false);
                level = Integer.parseInt(domainTok.nextToken());
                if (aClass.getLevel() < level) continue;
                while (domainTok.hasMoreTokens()) {
                    prestigeName = domainTok.nextToken();
                    prestigeDomain = Globals.getDomainNamed(prestigeName);
                    if (prestigeDomain != null) {
                        prestigeDomain = (Domain)prestigeDomain.clone();
                    }
                    if (availDomainList.contains(prestigeDomain)) continue;
                    availDomainList.add(prestigeDomain);
                }
            }
            d = aClass.getDomainList().iterator();
            while (d.hasNext()) {
                prestigeString = d.next().toString();
                domainTok = new StringTokenizer(prestigeString, "|", false);
                level = Integer.parseInt(domainTok.nextToken());
                if (aClass.getLevel() < level) continue;
                while (domainTok.hasMoreTokens()) {
                    prestigeName = domainTok.nextToken();
                    prestigeDomain = Globals.getDomainNamed(prestigeName);
                    if (prestigeDomain != null) {
                        prestigeDomain = (Domain)prestigeDomain.clone();
                    }
                    if (availDomainList.contains(prestigeDomain)) continue;
                    availDomainList.add(prestigeDomain);
                }
            }
        }
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.getStatusBar().setText(PropertyFactory.getString("in_statusBarDeity"));
        this.refresh();
        int splitPaneDividerLocation = this.splitPane.getDividerLocation();
        int bSplitDividerLocation = this.bSplit.getDividerLocation();
        int aSplitDividerLocation = this.aSplit.getDividerLocation();
        if (!this.hasBeenSized) {
            int width;
            TableColumn sCol;
            int i;
            this.hasBeenSized = true;
            double thisWidth = this.getSize().getWidth();
            splitPaneDividerLocation = SettingsHandler.getPCGenOption("InfoDomain.splitPane", (int)(thisWidth * 4.0 / 10.0));
            bSplitDividerLocation = SettingsHandler.getPCGenOption("InfoDomain.bSplit", (int)(this.getSize().getHeight() * 75.0 / 100.0));
            aSplitDividerLocation = SettingsHandler.getPCGenOption("InfoDomain.aSplit", (int)(thisWidth * 5.0 / 10.0));
            for (i = 0; i < this.deityTable.getColumnCount(); ++i) {
                sCol = this.deityTable.getColumnModel().getColumn(i);
                width = Globals.getCustColumnWidth(PropertyFactory.getString("in_deity"), i);
                if (width != 0) {
                    sCol.setPreferredWidth(width);
                }
                sCol.addPropertyChangeListener(new ResizeColumnListener(this.deityTable, PropertyFactory.getString("in_deity"), i));
            }
            for (i = 0; i < this.domainTable.getColumnCount(); ++i) {
                sCol = this.domainTable.getColumnModel().getColumn(i);
                width = Globals.getCustColumnWidth(PropertyFactory.getString("in_domains"), i);
                if (width != 0) {
                    sCol.setPreferredWidth(width);
                }
                sCol.addPropertyChangeListener(new ResizeColumnListener(this.domainTable, PropertyFactory.getString("in_domains"), i));
            }
        }
        if (splitPaneDividerLocation > 0) {
            this.splitPane.setDividerLocation(splitPaneDividerLocation);
            SettingsHandler.setPCGenOption("InfoDomain.splitPane", splitPaneDividerLocation);
        }
        if (bSplitDividerLocation > 0) {
            this.bSplit.setDividerLocation(bSplitDividerLocation);
            SettingsHandler.setPCGenOption("InfoDomain.bSplit", bSplitDividerLocation);
        }
        if (aSplitDividerLocation > 0) {
            this.aSplit.setDividerLocation(aSplitDividerLocation);
            SettingsHandler.setPCGenOption("InfoDomain.aSplit", aSplitDividerLocation);
        }
    }

    private void hookupPopupMenu(JTableEx treeTable) {
        treeTable.addMouseListener(new ClassPopupListener(treeTable, new ClassPopupMenu(treeTable)));
    }

    private void initComponents() {
        this.readyForRefresh = true;
        Utility.setDescription(this, PropertyFactory.getString("in_tabToolTip"));
        this.deitySorter = new TableSorter(this.deityModel);
        this.deityTable = new JTableEx(this.deitySorter);
        this.deitySorter.addMouseListenerToHeaderInTable(this.deityTable);
        this.deityTable.setSelectionMode(0);
        Utility.setDescription(this.deityTable, PropertyFactory.getString("in_deityTableTip"));
        for (int i = 0; i < s_columnNames.length; ++i) {
            TableColumn column = this.deityTable.getColumnModel().getColumn(i);
            column.setPreferredWidth(this.deiColumnWidth[i]);
        }
        DeityMouseAdapter deityMouse = new DeityMouseAdapter();
        this.deityTable.addMouseListener(deityMouse);
        this.domainSorter = new TableSorter(this.domainModel);
        this.domainTable = new JTableEx(this.domainSorter);
        this.domainSorter.addMouseListenerToHeaderInTable(this.domainTable);
        this.domainTable.setSelectionMode(0);
        Utility.setDescription(this.domainTable, PropertyFactory.getString("in_domainTableTip"));
        DomainMouseAdapter domainMouse = new DomainMouseAdapter();
        this.domainTable.addMouseListener(domainMouse);
        this.center.setLayout(new BorderLayout());
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel leftPane = new JPanel();
        JPanel rightPane = new JPanel();
        leftPane.setLayout(gridbag);
        this.splitPane = new FlippingSplitPane(splitOrientation, leftPane, rightPane);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.splitPane.setDividerLocation(350);
        this.center.add((Component)this.splitPane, "Center");
        Utility.buildConstraints(c, 0, 0, 1, 1, 100.0, 5.0);
        c.fill = 3;
        c.anchor = 10;
        JPanel aPanel = new JPanel();
        gridbag.setConstraints(aPanel, c);
        JLabel aLabel = new JLabel(PropertyFactory.getString("in_deity") + ": ");
        aPanel.add(aLabel);
        this.deityName = new JLabel(PropertyFactory.getString("in_nameLabel"));
        aPanel.add(this.deityName);
        this.deitySelect = new JButton(PropertyFactory.getString("in_select"));
        Utility.setDescription(this.deitySelect, PropertyFactory.getString("in_deityButTip"));
        this.deitySelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListSelectionModel lsm = InfoDomain.this.deityTable.getSelectionModel();
                int selectedRow = InfoDomain.this.deitySorter.getRowTranslated(lsm.getMinSelectionIndex());
                InfoDomain.this.selectDeityIndex(selectedRow);
            }
        });
        aPanel.add(this.deitySelect);
        leftPane.add(aPanel);
        Utility.buildConstraints(c, 0, 1, 1, 1, 0.0, 95.0);
        c.fill = 1;
        c.anchor = 10;
        JScrollPane scrollPane = new JScrollPane(this.deityTable);
        gridbag.setConstraints(scrollPane, c);
        leftPane.add(scrollPane);
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        rightPane.setLayout(gridbag);
        Utility.buildConstraints(c, 0, 0, 1, 1, 100.0, 5.0);
        c.fill = 3;
        c.anchor = 10;
        aPanel = new JPanel();
        gridbag.setConstraints(aPanel, c);
        this.domSelected = new JLabel(PropertyFactory.getString("in_domainSelected") + ": ");
        this.ofLabel = new JLabel(PropertyFactory.getString("in_ofString"));
        aPanel.add(this.domSelected);
        aPanel.add(this.domChosen);
        aPanel.add(this.ofLabel);
        aPanel.add(this.domTotal);
        this.domainSelect = new JButton(PropertyFactory.getString("in_select"));
        Utility.setDescription(this.domainSelect, PropertyFactory.getString("in_domainButTip"));
        this.domainSelect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ListSelectionModel lsm = InfoDomain.this.domainTable.getSelectionModel();
                int selectedRow = InfoDomain.this.domainSorter.getRowTranslated(lsm.getMinSelectionIndex());
                InfoDomain.this.selectDomainIndex(selectedRow);
            }
        });
        aPanel.add(this.domainSelect);
        rightPane.add(aPanel);
        Utility.buildConstraints(c, 0, 1, 1, 1, 0.0, 95.0);
        c.fill = 1;
        c.anchor = 10;
        scrollPane = new JScrollPane(this.domainTable);
        gridbag.setConstraints(scrollPane, c);
        rightPane.add(scrollPane);
        TitledBorder title1 = BorderFactory.createTitledBorder(this.etched, PropertyFactory.getString("in_deityInfo"));
        title1.setTitleJustification(2);
        this.deityScroll.setBorder(title1);
        this.deityInfo.setBackground(rightPane.getBackground());
        this.deityScroll.setViewportView(this.deityInfo);
        Utility.setDescription(this.deityScroll, PropertyFactory.getString("in_infoScrollTip"));
        TitledBorder title2 = BorderFactory.createTitledBorder(this.etched, PropertyFactory.getString("in_domainInfo"));
        title2.setTitleJustification(2);
        this.domainScroll.setBorder(title2);
        this.domainInfo.setBackground(rightPane.getBackground());
        this.domainScroll.setViewportView(this.domainInfo);
        Utility.setDescription(this.domainScroll, PropertyFactory.getString("in_infoScrollTip"));
        this.aSplit = new FlippingSplitPane(1, this.deityScroll, this.domainScroll);
        this.aSplit.setOneTouchExpandable(true);
        this.aSplit.setDividerSize(10);
        this.aSplit.setDividerLocation(300);
        JPanel botPane = new JPanel();
        botPane.setLayout(new BorderLayout());
        botPane.add((Component)this.aSplit, "Center");
        this.bSplit = new FlippingSplitPane(0, this.center, botPane);
        this.bSplit.setOneTouchExpandable(true);
        this.bSplit.setDividerSize(10);
        this.bSplit.setDividerLocation(300);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bSplit, "Center");
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                InfoDomain.this.refresh();
            }
        });
        scrollPane.setVerticalScrollBarPolicy(20);
        scrollPane.setHorizontalScrollBarPolicy(30);
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                InfoDomain.this.formComponentShown();
            }
        });
        this.hookupPopupMenu(this.deityTable);
        this.hookupPopupMenu(this.domainTable);
    }

    private final void selectDeityIndex(int selectedRow) {
        int areYouSure;
        Object value = this.deityModel.getValueAt(selectedRow, -1);
        if (!(value instanceof Deity)) {
            return;
        }
        Deity aDeity = (Deity)value;
        if (aDeity == null) {
            return;
        }
        if (this.pc.getDeity() != null && aDeity.equals(this.pc.getDeity())) {
            return;
        }
        if (!this.pc.canSelectDeity(aDeity)) {
            ListSelectionModel lsm = this.deityTable.getSelectionModel();
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_reqMess") + aDeity.getName() + ".", "PCGen", MessageType.INFORMATION);
            lsm.clearSelection();
            return;
        }
        ArrayList potentialDomains = new ArrayList();
        this.addUnfilteredDomains(potentialDomains, aDeity);
        Iterator selectedIter = selectedDomainList.iterator();
        boolean allDomainsAvailable = true;
        while (selectedIter.hasNext()) {
            Object domain = selectedIter.next();
            if (potentialDomains.contains(domain)) continue;
            allDomainsAvailable = false;
            break;
        }
        if (!allDomainsAvailable && (areYouSure = JOptionPane.showConfirmDialog(null, PropertyFactory.getString("in_confDomLost1") + " " + aDeity.getName() + System.getProperty("line.separator") + PropertyFactory.getString("in_confDomLost2"), "PCGen", 2)) != 0) {
            return;
        }
        this.pc.setDeity(aDeity);
        this.deityName.setText(aDeity.piString());
        this.buildDomainLists();
        this.deityModel.fireTableDataChanged();
    }

    private final void updateCharacterInfo() {
        if (this.pc != null && this.numDomains != this.pc.getCharacterDomainList().size()) {
            needsUpdate = true;
            this.numDomains = this.pc.getCharacterDomainList().size();
        }
        if (needsUpdate || this.pc == null) {
            if (this.pc == null) {
                return;
            }
            List deityList = this.deityModel.getData();
            deityList.clear();
            Iterator it = Globals.getDeityList().iterator();
            while (it.hasNext()) {
                Deity aDeity = (Deity)it.next();
                if (!this.accept(this.pc, aDeity)) continue;
                deityList.add(aDeity);
            }
            this.deityModel.fireTableDataChanged();
            if (this.pc.getDeity() != null) {
                this.deityName.setText(this.pc.getDeity().piString());
            } else {
                this.deityName.setText(PropertyFactory.getString("in_tempName"));
            }
            this.setDeityInfoText(this.pc.getDeity());
            this.buildDomainLists();
            needsUpdate = false;
        }
    }

    private void buildDomainLists() {
        List availDomainList = this.domainModel.getAvailDomainList();
        selectedDomainList.clear();
        availDomainList.clear();
        this.addUnfilteredDomains(availDomainList, this.pc.getDeity());
        for (int i = 0; i < this.pc.getCharacterDomainList().size(); ++i) {
            CharacterDomain aCD = (CharacterDomain)this.pc.getCharacterDomainList().get(i);
            if (aCD == null || aCD.getDomain() == null) continue;
            Domain aCDDomain = aCD.getDomain();
            if (!availDomainList.contains(aCDDomain)) {
                availDomainList.add(aCDDomain);
            }
            if (selectedDomainList.contains(aCDDomain)) continue;
            selectedDomainList.add(aCDDomain);
        }
        Iterator domainIter = availDomainList.iterator();
        while (domainIter.hasNext()) {
            Domain domain = (Domain)domainIter.next();
            if (this.accept(this.pc, domain) || selectedDomainList.contains(domain)) continue;
            domainIter.remove();
        }
        this.domTotal.setText(Integer.toString(this.pc.getMaxCharacterDomains()));
        this.domChosen.setText(Integer.toString(this.pc.getCharacterDomainUsed()) + "*");
        this.domainSorter.tableChanged(null);
        this.domainModel.fireTableDataChanged();
    }

    private final void selectDomainIndex(int selectedRow) {
        if (selectedRow < 0 || selectedRow >= this.domainModel.getRowCount()) {
            return;
        }
        if (this.pc.getMaxCharacterDomains() <= 0) {
            ShowMessageDelegate.showMessageDialog("Not allowed to choose a domain", "PCGen", MessageType.INFORMATION);
            return;
        }
        Domain addedDomain = (Domain)this.domainModel.getValueAt(selectedRow, -1);
        if (addedDomain == null) {
            return;
        }
        if (!addedDomain.qualifiesForDomain(this.pc)) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_qualifyMess") + addedDomain.getName(), "PCGen", MessageType.INFORMATION);
            return;
        }
        CharacterDomain aCD = this.pc.getCharacterDomainForDomain(addedDomain.getName());
        if (aCD == null) {
            aCD = this.pc.getNewCharacterDomain();
        }
        if (aCD == null) {
            Logging.errorPrint("No more allowed domains");
            return;
        }
        Domain existingDomain = aCD.getDomain();
        if (existingDomain != null && existingDomain.equals(addedDomain)) {
            selectedDomainList.remove(existingDomain);
            this.pc.removeCharacterDomain(aCD);
        }
        if (this.pc.getCharacterDomainUsed() >= this.pc.getMaxCharacterDomains()) {
            ShowMessageDelegate.showMessageDialog("No more domains allowed", "PCGen", MessageType.INFORMATION);
            return;
        }
        if (existingDomain == null) {
            addedDomain.setIsLocked(true, this.pc);
            aCD.setDomain(addedDomain, this.pc);
            this.pc.addCharacterDomain(aCD);
            if (!selectedDomainList.contains(addedDomain)) {
                selectedDomainList.add(addedDomain);
            }
            this.pc.calcActiveBonuses();
        }
        this.domChosen.setText(Integer.toString(this.pc.getCharacterDomainUsed()) + "*");
        this.domainSorter.tableChanged(null);
        this.domainModel.fireTableDataChanged();
        this.forceUpdates();
    }

    private static void createDeityButtonClick() {
        LstEditorMain lem = new LstEditorMain();
        lem.setVisible(true);
        lem.editIt(null, 1);
    }

    private void forceUpdates() {
        this.pc.setDirty(true);
        needsUpdate = true;
        CharacterInfo pane = PCGen_Frame1.getCharacterPane();
        pane.setPaneForUpdate(pane.infoSpells());
        pane.setPaneForUpdate(pane.infoFeats());
        pane.refresh();
    }

    private void deleteDeityButtonClick() {
        Deity aDeity;
        ListSelectionModel lsm = this.deityTable.getSelectionModel();
        int selectedRow = this.deitySorter.getRowTranslated(lsm.getMinSelectionIndex());
        if (selectedRow >= 0 && (aDeity = (Deity)this.deityModel.getValueAt(selectedRow, -1)) != null) {
            if (aDeity.isType("CUSTOM")) {
                int areYouSure = JOptionPane.showConfirmDialog(null, PropertyFactory.getString("in_delDeity") + aDeity.getName() + "?", "PCGen", 2);
                if (areYouSure != 0) {
                    return;
                }
                Globals.getDeityList().remove(aDeity);
            } else {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_domIDEr4"), "PCGen", MessageType.ERROR);
            }
        }
    }

    private void editDeityButtonClick() {
        int selectedRow;
        Deity aDeity = null;
        ListSelectionModel lsm = this.deityTable.getSelectionModel();
        int row = lsm.getMinSelectionIndex();
        if (row >= 0 && (selectedRow = this.deitySorter.getRowTranslated(lsm.getMinSelectionIndex())) >= 0) {
            aDeity = (Deity)this.deityModel.getValueAt(selectedRow, -1);
        }
        LstEditorMain lem = new LstEditorMain();
        lem.setVisible(true);
        lem.editIt(aDeity, 1);
    }

    static /* synthetic */ void access$1400(InfoDomain x0) {
        x0.editDeityButtonClick();
    }

    static /* synthetic */ void access$1500() {
        InfoDomain.createDeityButtonClick();
    }

    static /* synthetic */ void access$1600(InfoDomain x0) {
        x0.deleteDeityButtonClick();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class DomainMouseAdapter
    extends MouseAdapter {
        private final ListSelectionModel lsm;

        private DomainMouseAdapter() {
            this.lsm = InfoDomain.this.domainTable.getSelectionModel();
        }

        public void mouseClicked(MouseEvent f) {
            int selectedRow = InfoDomain.this.domainSorter.getRowTranslated(this.lsm.getMinSelectionIndex());
            if (selectedRow < 0) {
                return;
            }
            int clickCount = f.getClickCount();
            switch (clickCount) {
                case 1: {
                    String domainName = InfoDomain.this.domainModel.getValueAt(selectedRow, -1).toString();
                    if (domainName == null) break;
                    Domain aDomain = Globals.getDomainNamed(domainName);
                    InfoDomain.this.setDomainInfoText(aDomain);
                    break;
                }
                default: {
                    InfoDomain.this.selectDomainIndex(selectedRow);
                }
            }
        }
    }

    private final class DomainModel
    extends AbstractTableModel {
        private List availDomainList = new ArrayList();

        private DomainModel() {
        }

        public List getAvailDomainList() {
            return this.availDomainList;
        }

        public Class getColumnClass(int col) {
            return this.getValueAt(0, col).getClass();
        }

        public int getColumnCount() {
            return s_domainColList.length;
        }

        public String getColumnName(int column) {
            return s_domainColList[column];
        }

        public int getRowCount() {
            return this.availDomainList.size();
        }

        public Object getValueAt(int row, int col) {
            if (row < 0 || row >= this.availDomainList.size()) {
                return "";
            }
            Domain aDomain = (Domain)this.availDomainList.get(row);
            if (aDomain == null) {
                return null;
            }
            StringBuffer retVal = new StringBuffer(80);
            switch (col) {
                case -1: {
                    return aDomain;
                }
                case 0: {
                    if (selectedDomainList.contains(this.availDomainList.get(row))) {
                        retVal.append("<html><b>").append(aDomain.piSubString()).append("*</b></html>");
                        break;
                    }
                    if (!aDomain.qualifiesForDomain(InfoDomain.this.pc)) {
                        retVal.append("<html>").append(SettingsHandler.getPrereqFailColorAsHtmlStart()).append(aDomain.piSubString()).append(SettingsHandler.getPrereqFailColorAsHtmlEnd()).append("</html>");
                        break;
                    }
                    retVal.append(aDomain.piString());
                    break;
                }
                case 1: {
                    try {
                        retVal.append(aDomain.getSource());
                    }
                    catch (Exception exc) {
                        Logging.errorPrint(PropertyFactory.getString("in_errorMess"), exc);
                    }
                    break;
                }
                default: {
                    Logging.errorPrint(PropertyFactory.getString("in_domIDEr1") + " " + col + " " + PropertyFactory.getString("in_domIDEr3"));
                }
            }
            return retVal.toString();
        }
    }

    private final class DeityMouseAdapter
    extends MouseAdapter {
        private DeityMouseAdapter() {
        }

        public void mouseClicked(MouseEvent f) {
            ListSelectionModel lsm = InfoDomain.this.deityTable.getSelectionModel();
            int selectedRow = InfoDomain.this.deitySorter.getRowTranslated(lsm.getMinSelectionIndex());
            switch (f.getClickCount()) {
                case 1: {
                    if (selectedRow >= 0) {
                        Deity aDeity = (Deity)InfoDomain.this.deityModel.getValueAt(selectedRow, -1);
                        InfoDomain.this.setDeityInfoText(aDeity);
                        break;
                    }
                    InfoDomain.this.setDeityInfoText(null);
                    break;
                }
                case 2: {
                    if (selectedRow < 0) break;
                    InfoDomain.this.selectDeityIndex(selectedRow);
                    break;
                }
            }
        }
    }

    private final class DeityModel
    extends AbstractTableModel {
        private List deities = new ArrayList();

        private DeityModel() {
        }

        public boolean isCellEditable(int row, int column) {
            return false;
        }

        public Class getColumnClass(int columnIndex) {
            return class$java$lang$String == null ? (class$java$lang$String = InfoDomain.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            return s_columnNames.length;
        }

        public String getColumnName(int column) {
            return s_columnNames[column];
        }

        public List getData() {
            return this.deities;
        }

        public int getRowCount() {
            if (Globals.getDeityList() != null) {
                return this.deities.size();
            }
            return 0;
        }

        public Object getValueAt(int row, int column) {
            String retVal = "";
            if (this.deities != null && row >= 0 && row < this.deities.size()) {
                Deity aDeity = (Deity)this.deities.get(row);
                switch (column) {
                    case -1: {
                        return aDeity;
                    }
                    case 0: {
                        if (InfoDomain.this.pc != null && InfoDomain.this.pc.canSelectDeity(aDeity)) {
                            retVal = aDeity.piString();
                            break;
                        }
                        retVal = "<html>" + SettingsHandler.getPrereqFailColorAsHtmlStart() + aDeity.piSubString() + SettingsHandler.getPrereqFailColorAsHtmlEnd() + "</html>";
                        break;
                    }
                    case 1: {
                        retVal = aDeity.getDomainListPIString();
                        break;
                    }
                    case 2: {
                        retVal = aDeity.getAlignment();
                        break;
                    }
                    case 3: {
                        retVal = aDeity.getSource();
                        break;
                    }
                    default: {
                        Logging.errorPrint(PropertyFactory.getString("in_domIDEr1") + " " + column + " " + PropertyFactory.getString("in_domIDEr2"));
                    }
                }
            }
            return retVal;
        }
    }

    private final class ClassPopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = -4223585346813683966L;

        ClassPopupMenu(JTableEx treeTable) {
            if (treeTable == InfoDomain.this.deityTable) {
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_select"), "shortcut EQUALS"));
                this.addSeparator();
                this.add(Utility.createMenuItem(PropertyFactory.getString("in_editDeity"), new ActionListener(this){
                    private final /* synthetic */ ClassPopupMenu this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent e) {
                        InfoDomain.access$1400(ClassPopupMenu.access$1300(this.this$1));
                    }
                }, "editDeity", '\u0000', "alt E", PropertyFactory.getString("in_editDeity"), null, true));
                this.add(Utility.createMenuItem(PropertyFactory.getString("in_createDeity"), new ActionListener(this){
                    private final /* synthetic */ ClassPopupMenu this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent e) {
                        InfoDomain.access$1500();
                    }
                }, "createDeity", '\u0000', "alt C", PropertyFactory.getString("in_createDeity"), null, true));
                this.add(Utility.createMenuItem(PropertyFactory.getString("in_delDeity"), new ActionListener(this){
                    private final /* synthetic */ ClassPopupMenu this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent e) {
                        InfoDomain.access$1600(ClassPopupMenu.access$1300(this.this$1));
                    }
                }, "deleteDeity", '\u0000', "DELETE", PropertyFactory.getString("in_delDeity"), null, true));
            } else {
                this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_select"), "shortcut EQUALS"));
            }
        }

        private JMenuItem createAddMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new AddClassActionListener(), PropertyFactory.getString("in_select"), '\u0000', accelerator, PropertyFactory.getString("in_selDeity"), "Add16.gif", true);
        }

        private JMenuItem createRemoveMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new RemoveClassActionListener(), PropertyFactory.getString("in_select"), '\u0000', accelerator, PropertyFactory.getString("in_selDomain"), "Add16.gif", true);
        }

        private class RemoveClassActionListener
        extends ClassActionListener {
            private RemoveClassActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoDomain.this.domainSelect.doClick();
            }
        }

        private class ClassActionListener
        implements ActionListener {
            private ClassActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
            }
        }

        private class AddClassActionListener
        extends ClassActionListener {
            private AddClassActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoDomain.this.deitySelect.doClick();
            }
        }
    }

    private final class ClassPopupListener
    extends MouseAdapter {
        private ClassPopupMenu menu;
        private JTableEx aTable;

        ClassPopupListener(JTableEx treeTable, ClassPopupMenu aMenu) {
            this.menu = aMenu;
            this.aTable = treeTable;
            KeyListener myKeyListener = new KeyListener(this){
                private final /* synthetic */ ClassPopupListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTyped(KeyEvent e) {
                    ClassPopupListener.access$1100(this.this$1).dispatchEvent(e);
                }

                public void keyPressed(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    if (keyCode != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                        for (int i = 0; i < ClassPopupListener.access$1200(this.this$1).getComponentCount(); ++i) {
                            KeyStroke ks;
                            Component menuComponent = ClassPopupListener.access$1200(this.this$1).getComponent(i);
                            if (!(menuComponent instanceof JMenuItem) || (ks = ((JMenuItem)menuComponent).getAccelerator()) == null || !keyStroke.equals(ks)) continue;
                            ((JMenuItem)menuComponent).doClick(2);
                            return;
                        }
                    }
                    ClassPopupListener.access$1100(this.this$1).dispatchEvent(e);
                }

                public void keyReleased(KeyEvent e) {
                    ClassPopupListener.access$1100(this.this$1).dispatchEvent(e);
                }
            };
            treeTable.addKeyListener(myKeyListener);
        }

        public void mousePressed(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        private void maybeShowPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                int selRow = this.aTable.getSelectedRow();
                if (selRow == -1) {
                    return;
                }
                this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        static /* synthetic */ InfoDomain access$1100(ClassPopupListener x0) {
            return x0.InfoDomain.this;
        }

        static /* synthetic */ ClassPopupMenu access$1200(ClassPopupListener x0) {
            return x0.menu;
        }
    }
}

