/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.core.Constants;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.SystemCollections;
import pcgen.core.WeaponProf;
import pcgen.core.bonus.BonusObj;
import pcgen.core.character.EquipSet;
import pcgen.core.character.EquipSlot;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfo;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.Utility;
import pcgen.io.ExportHandler;
import pcgen.util.BigDecimalHelper;
import pcgen.util.FOPHandler;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;
import pcgen.util.chooser.ChooserRadio;

public class InfoEquipping
extends FilterAdapterPanel
implements CharacterInfoTab {
    static final long serialVersionUID = 6988134124127535195L;
    private static List equipSetList = new ArrayList();
    private static List tempSetList = new ArrayList();
    private static final String[] loadTypes = new String[]{"LIGHT", "MEDIUM", "HEAVY", "OVERLOADED"};
    private static final String defaultEquipSet = PropertyFactory.getString("in_ieDefault");
    private static final String nameAdded = PropertyFactory.getString("in_ieAddEqSet");
    private static final String nameNotAdded = PropertyFactory.getString("in_ieNotAdd");
    private static int splitOrientation = 1;
    private static boolean needsUpdate = true;
    private static final int MODEL_AVAIL = 0;
    private static final int MODEL_SELECTED = 1;
    private static final int COL_NAME = 0;
    private static final int COL_TYPE = 1;
    private static final int COL_QTY = 2;
    private static final int COL_LOCATION = 3;
    private static final int COL_COST = 4;
    private static final int COL_WEIGHT = 5;
    private static final int COL_BONUS = 6;
    private Border etched;
    private EquipModel availableModel = null;
    private EquipModel selectedModel = null;
    private final JLabel avaLabel = new JLabel(PropertyFactory.getString("in_ieSort"));
    private final JLabel calcLabel = new JLabel(PropertyFactory.getString("in_ieCalc"));
    private final JLabel loadLabel = new JLabel(PropertyFactory.getString("in_load") + ": ");
    private final JLabel weightLabel = new JLabel(PropertyFactory.getString("in_weight") + ": ");
    private Equipment lastEquip = null;
    private FlippingSplitPane asplit;
    private FlippingSplitPane bsplit;
    private FlippingSplitPane splitPane;
    private JButton addEquipButton;
    private JButton addEquipSetButton;
    private JButton delEquipButton;
    private JButton delEquipSetButton;
    private JButton exportEqSetButton;
    private JButton selectTemplateButton;
    private JButton setNoteButton;
    private JButton setQtyButton;
    private JButton viewEqSetButton;
    private JComboBoxEx calcComboBox = new JComboBoxEx();
    private JComboBoxEx viewComboBox = new JComboBoxEx();
    private JLabelPane infoLabel = new JLabelPane();
    private final JTextField loadWeight = new JTextField();
    private final JTextField totalWeight = new JTextField();
    private JMenuItem AddAllMenu;
    private JMenuItem AddMenu;
    private JMenuItem AddNumMenu;
    private JMenuItem BuyMenu;
    private JMenuItem BuyNumMenu;
    private JMenuItem CopyEquipSetMenu;
    private JMenuItem DelMenu;
    private JMenuItem RenameEquipSetMenu;
    private JMenuItem SellMenu;
    private JMenuItem SellNumMenu;
    private JMenuItem SetLocationMenu;
    private JMenuItem SetNoteMenu;
    private JMenuItem SetQtyMenu;
    private JPanel botPane = new JPanel();
    private JPanel topPane = new JPanel();
    private JTextField equipSetTextField = new JTextField();
    private JTextField templateTextField = new JTextField();
    private JTreeTable availableTable;
    private JTreeTable selectedTable;
    private JTreeTableSorter availableSort = null;
    private JTreeTableSorter selectedSort = null;
    private String selectedEquipSet = "";
    private TreePath selPath;
    private boolean hasBeenSized = false;
    private int viewMode = 0;
    private int viewSelectMode = 0;
    private Map equipAddMap = new HashMap();
    private Map equipNotMap = new HashMap();
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;
    private ActionListener calcComboBoxListener;
    static /* synthetic */ Class class$pcgen$gui$utils$TreeTableModel;
    static /* synthetic */ Class class$java$lang$String;

    public InfoEquipping(PlayerCharacter pc) {
        this.pc = pc;
        this.setName(Constants.tabNames[12]);
        this.initComponents();
        this.initActionListeners();
        FilterFactory.restoreFilterSettings(this);
    }

    public void setPc(PlayerCharacter pc) {
        if (this.pc != pc || pc.getSerial() > this.serial) {
            this.pc = pc;
            this.serial = pc.getSerial();
            this.forceRefresh();
        }
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Equipping.Order", 12);
    }

    public void setTabOrder(int order) {
        SettingsHandler.setPCGenOption(".Panel.Equipping.Order", order);
    }

    public String getTabName() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabName(12);
    }

    public boolean isShown() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabShown(12);
    }

    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    public JComponent getView() {
        return this;
    }

    public final boolean isMatchAnyEnabled() {
        return true;
    }

    public static void setNeedsUpdate(boolean flag) {
        needsUpdate = flag;
    }

    public final boolean isNegateEnabled() {
        return true;
    }

    public final int getSelectionMode() {
        return -2;
    }

    public final void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
    }

    public final void refreshFiltering() {
        this.updateAvailableModel();
        this.updateSelectedModel();
    }

    private final void updateCharacterInfo() {
        if (this.pc == null || !needsUpdate) {
            return;
        }
        EquipSet cES = this.pc.getEquipSetByIdPath(this.pc.getCalcEquipSetId());
        if (cES != null) {
            this.selectedEquipSet = cES.getName();
            this.equipSetTextField.setText(this.selectedEquipSet);
        }
        this.calcComboBoxFill();
        this.updateTotalWeight();
        this.updateAvailableModel();
        this.updateSelectedModel();
        needsUpdate = false;
    }

    private EquipSet getCurrentEquipSet() {
        TreePath ceSelPath = this.selectedTable.getTree().getSelectionPath();
        EquipSet eSet = null;
        if (ceSelPath == null) {
            String equipSetName = this.equipSetTextField.getText();
            eSet = this.pc.getEquipSetByName(equipSetName);
        } else {
            Object endComp = ceSelPath.getPathComponent(1);
            MyPONode fNode = (MyPONode)endComp;
            if (fNode.getItem() instanceof EquipSet) {
                eSet = (EquipSet)fNode.getItem();
            }
        }
        return eSet;
    }

    private static String getEqTypeName(Equipment eqI) {
        String locTypeName = "";
        if (eqI.isWeapon()) {
            locTypeName = "Weapon";
        } else if (eqI.isArmor()) {
            locTypeName = "Armor";
        } else if (eqI.isShield()) {
            locTypeName = "Shield";
        } else if (eqI.isAmmunition()) {
            locTypeName = "Ammo";
        } else if (eqI.isSuit()) {
            locTypeName = "Suit";
        } else if (eqI.isMonk()) {
            locTypeName = "Monk";
        } else if (eqI.isUnarmed()) {
            locTypeName = "Unarmed";
        } else if (eqI.isContainer()) {
            locTypeName = "Container";
        } else if (eqI.isType("ROBE")) {
            locTypeName = "Robe";
        } else if (eqI.isType("HEADGEAR")) {
            locTypeName = "Headgear";
        } else if (eqI.isType("EYEGEAR")) {
            locTypeName = "Eyegear";
        } else if (eqI.isType("MASK")) {
            locTypeName = "Mask";
        } else if (eqI.isType("AMULET") || eqI.isType("NECKLACE")) {
            locTypeName = "Amulet";
        } else if (eqI.isType("CAPE") || eqI.isType("CLOAK")) {
            locTypeName = "Cape";
        } else if (eqI.isType("CLOTHING")) {
            locTypeName = "Clothing";
        } else if (eqI.isType("SHIRT") || eqI.isType("VEST")) {
            locTypeName = "Shirt";
        } else if (eqI.isType("BRACER") || eqI.isType("ARMWEAR")) {
            locTypeName = "Bracers";
        } else if (eqI.isType("GLOVE")) {
            locTypeName = "Glove";
        } else if (eqI.isType("RING")) {
            locTypeName = "Ring";
        } else if (eqI.isType("BELT")) {
            locTypeName = "Belt";
        } else if (eqI.isType("BOOT")) {
            locTypeName = "Boot";
        } else if (eqI.isType("POTION")) {
            locTypeName = "Potion";
        } else if (eqI.isType("ROD")) {
            locTypeName = "Rod";
        } else if (eqI.isType("STAFF")) {
            locTypeName = "Staff";
        } else if (eqI.isType("WAND")) {
            locTypeName = "Wand";
        } else if (eqI.isType("INSTRUMENT")) {
            locTypeName = "Instrument";
        } else if (eqI.isType("BOOK")) {
            locTypeName = "Book";
        }
        return locTypeName;
    }

    private void setInfoLabelText(Equipment eqI) {
        this.lastEquip = eqI;
        if (eqI != null) {
            int charges;
            Integer a;
            String bString;
            String IDS;
            String cString;
            StringBuffer b = new StringBuffer(300);
            b.append("<html><font size=+1><b>").append(eqI.piSubString()).append("</b></font>");
            if (!eqI.longName().equals(eqI.getName())) {
                b.append("(").append(eqI.longName()).append(")");
            }
            b.append(" <b>Type:</b> ").append(eqI.getType());
            if (eqI.isWeapon() || eqI.isArmor() || eqI.isShield()) {
                b.append(" <b>PROFICIENT</b>:").append(this.pc.isProficientWith(eqI) && eqI.meetsPreReqs() ? "Y" : SettingsHandler.getPrereqFailColorAsHtmlStart() + "N" + SettingsHandler.getPrereqFailColorAsHtmlEnd());
            }
            if ((cString = eqI.preReqHTMLStrings(this.pc, false)).length() > 0) {
                b.append(" <b>Requirements</b>:").append(cString);
            }
            if ((IDS = eqI.getInterestingDisplayString(this.pc)).length() > 0) {
                b.append(" <b>Properties</b>:").append(eqI.getInterestingDisplayString(this.pc));
            }
            if ((bString = eqI.getWeight(this.pc).toString()).length() > 0) {
                b.append(" <b>WT</b>:").append(bString).append(Globals.getWeightUnit());
            }
            if ((a = eqI.getACBonus(this.pc)) > 0) {
                b.append(" <b>AC</b>:").append(a.toString());
            }
            if (eqI.isArmor() || eqI.isShield()) {
                a = eqI.getMaxDex(this.pc);
                b.append(" <b>MAXDEX</b>:").append(a.toString());
                a = eqI.acCheck(this.pc);
                b.append(" <b>ACCHECK</b>:").append(a.toString());
            }
            if (Globals.getGameModeShowSpellTab()) {
                a = eqI.spellFailure(this.pc);
                if (eqI.isArmor() || eqI.isShield() || a != 0) {
                    b.append(" <b>Arcane Failure</b>:").append(a.toString());
                }
            }
            if ((bString = Globals.getGameModeDamageResistanceText()).length() != 0) {
                a = eqI.eDR(this.pc);
                if (eqI.isArmor() || eqI.isShield() || a != 0) {
                    b.append(" <b>").append(bString).append("</b>:").append(a.toString());
                }
            }
            if ((bString = eqI.moveString()).length() > 0) {
                b.append(" <b>Move</b>:").append(bString);
            }
            if ((bString = eqI.getSize()).length() > 0) {
                b.append(" <b>Size</b>:").append(bString);
            }
            if ((bString = eqI.getDamage(this.pc)).length() > 0) {
                b.append(" <b>Damage</b>:").append(bString);
                if (eqI.isDouble()) {
                    b.append('/').append(eqI.getAltDamage(this.pc));
                }
            }
            if ((bString = eqI.getCritRange(this.pc)).length() > 0) {
                b.append(" <b>Crit Range</b>:").append(bString);
                if (eqI.isDouble() && !eqI.getCritRange(this.pc).equals(eqI.getAltCritRange(this.pc))) {
                    b.append('/').append(eqI.getAltCritRange(this.pc));
                }
            }
            if ((bString = eqI.getCritMult()).length() > 0) {
                b.append(" <b>Crit Mult</b>:").append(bString);
                if (eqI.isDouble() && !eqI.getCritMult().equals(eqI.getAltCritMult())) {
                    b.append('/').append(eqI.getAltCritMult());
                }
            }
            if (eqI.isWeapon() && (bString = Globals.displayDistanceInUnitSet(Globals.convertDistanceToUnitSet(eqI.getRange(this.pc).intValue()))).length() > 0) {
                b.append(" <b>Range</b>:").append(bString).append(Globals.getDistanceUnit());
            }
            if ((bString = eqI.getContainerCapacityString()).length() > 0) {
                b.append(" <b>Container</b>:").append(bString);
            }
            if ((bString = eqI.getContainerContentsString()).length() > 0) {
                b.append(" <b>Currently Contains</b>:").append(bString);
                BigDecimal d = new BigDecimal(String.valueOf(eqI.getContainedValue(this.pc)));
                String aVal = BigDecimalHelper.formatBigDecimal(d, 2).toString();
                b.append(" <b>Contained Value</b>:").append(aVal).append("gp");
            }
            if ((charges = eqI.getRemainingCharges()) >= 0) {
                b.append(" <b>Charges</b>:").append(charges);
            }
            b.append(" <b>Cost</b>:").append(eqI.getCost(this.pc));
            bString = eqI.getSource();
            if (bString.length() > 0) {
                b.append(" <b>SOURCE:</b> ").append(bString);
            }
            b.append("</html>");
            this.infoLabel.setText(b.toString());
        }
    }

    private void setLocationButton() {
        TreePath slSelPath = this.selectedTable.getTree().getSelectionPath();
        EquipSet eSet = null;
        EquipSet rootSet = null;
        String locName = "";
        Equipment eqI = null;
        if (slSelPath == null) {
            ShowMessageDelegate.showMessageDialog("First select an Item to change location", "PCGen", MessageType.ERROR);
            return;
        }
        Object endComp = slSelPath.getLastPathComponent();
        MyPONode fNode = (MyPONode)endComp;
        if (fNode.getItem() instanceof EquipSet) {
            eSet = (EquipSet)fNode.getItem();
            rootSet = this.pc.getEquipSetByIdPath(eSet.getRootIdPath());
            eqI = eSet.getItem();
        }
        if (eqI == null) {
            ShowMessageDelegate.showMessageDialog("First select an Item to change location", "PCGen", MessageType.ERROR);
            return;
        }
        StringTokenizer aTok = new StringTokenizer(eSet.getIdPath(), ".", false);
        if (aTok.countTokens() > 3) {
            ShowMessageDelegate.showMessageDialog("Can not change item locations inside a container", "PCGen", MessageType.ERROR);
            return;
        }
        ArrayList containers = new ArrayList();
        List aList = this.locationChoices(eqI, containers);
        ChooserRadio c = ChooserFactory.getRadioInstance();
        if (containers.size() != 0) {
            c.setComboData("Container", containers);
        }
        c.setAvailableList(aList);
        c.setVisible(false);
        c.setTitle(eqI.getName());
        c.setMessageText("Select a location for this item");
        c.setVisible(true);
        Equipment eqTarget = null;
        EquipSet eTargetSet = null;
        aList = c.getSelectedList();
        if (c.getSelectedList().size() > 0) {
            Object loc = aList.get(0);
            if (loc instanceof String) {
                locName = (String)loc;
            } else {
                eTargetSet = ((EqSetWrapper)loc).getEqSet();
                eqTarget = eTargetSet.getItem();
                rootSet = this.pc.getEquipSetByIdPath(eTargetSet.getIdPath());
                if (eqTarget.canContain(this.pc, eqI) == 1) {
                    locName = eqTarget.getName();
                } else {
                    ShowMessageDelegate.showMessageDialog("Container " + eqTarget.getName() + " is full", "PCGen", MessageType.ERROR);
                    return;
                }
            }
        }
        if ("".equals(locName) || locName.length() == 0) {
            return;
        }
        if (eTargetSet != null && eSet.getIdPath().equals(eTargetSet.getIdPath())) {
            ShowMessageDelegate.showMessageDialog("Can not put an item inside itself", "PCGen", MessageType.ERROR);
            return;
        }
        if (!this.canAddEquip(rootSet, locName, eqI, eqTarget)) {
            ShowMessageDelegate.showMessageDialog("Can not equip " + eqI.getName() + " to " + locName, "PCGen", MessageType.ERROR);
            return;
        }
        if (eqTarget != null && eqTarget.isContainer()) {
            eqTarget.insertChild(this.pc, eqI);
            eqI.setParent(eqTarget);
        }
        if (eTargetSet != null) {
            String oldPath = eSet.getIdPath();
            eSet.setIdPath(this.getNewIdPath(eTargetSet));
            if (eqI.isContainer()) {
                Iterator e = this.pc.getEquipSet().iterator();
                while (e.hasNext()) {
                    String oldIdPath;
                    EquipSet es = (EquipSet)e.next();
                    String pIdPath = es.getParentIdPath() + ".";
                    if (!pIdPath.startsWith(oldIdPath = oldPath + ".")) continue;
                    es.setIdPath(this.getNewIdPath(eSet));
                }
            }
        }
        eSet.setName(locName);
        this.pc.setDirty(true);
        this.updateSelectedModel();
        this.pc.calcActiveBonuses();
    }

    private String getNewIdPath(EquipSet eSet) {
        String pid = "0";
        int newID = 0;
        if (eSet != null) {
            pid = eSet.getIdPath();
        }
        Iterator e = this.pc.getEquipSet().iterator();
        while (e.hasNext()) {
            EquipSet es = (EquipSet)e.next();
            if (!es.getParentIdPath().equals(pid) || es.getId() <= newID) continue;
            newID = es.getId();
        }
        return pid + '.' + ++newID;
    }

    private void setNoteButton() {
        TreePath noteSelPath = this.selectedTable.getTree().getSelectionPath();
        if (noteSelPath == null) {
            ShowMessageDelegate.showMessageDialog("Select the Equipment first", "PCGen", MessageType.ERROR);
            return;
        }
        Object endComp = noteSelPath.getLastPathComponent();
        MyPONode fNode = (MyPONode)endComp;
        if (!(fNode.getItem() instanceof EquipSet)) {
            return;
        }
        EquipSet eSet = (EquipSet)fNode.getItem();
        String pid = eSet.getIdPath();
        Equipment eqI = (eSet = this.pc.getEquipSetByIdPath(pid)).getItem();
        if (eqI == null) {
            ShowMessageDelegate.showMessageDialog("Select the Equipment first", "PCGen", MessageType.ERROR);
            return;
        }
        InputInterface ii = InputFactory.getInputInstance();
        Object selectedValue = ii.showInputDialog(null, "Enter new Note", "PCGen", MessageType.QUESTION, null, eSet.getNote());
        if (selectedValue == null) {
            return;
        }
        String newNote = ((String)selectedValue).trim();
        if (newNote != null) {
            eSet.setNote(newNote);
        }
        this.pc.setDirty(true);
        this.updateSelectedModel();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setQtyButton(Float aQty) {
        float newNum;
        TreePath qtySelPath = this.selectedTable.getTree().getSelectionPath();
        if (qtySelPath == null) {
            ShowMessageDelegate.showMessageDialog("Select the Equipment first", "PCGen", MessageType.ERROR);
            return;
        }
        Object endComp = qtySelPath.getLastPathComponent();
        MyPONode fNode = (MyPONode)endComp;
        if (!(fNode.getItem() instanceof EquipSet)) {
            return;
        }
        EquipSet eSet = (EquipSet)fNode.getItem();
        String pid = eSet.getIdPath();
        eSet = this.pc.getEquipSetByIdPath(pid);
        Equipment eqI = eSet.getItem();
        StringTokenizer aTok = new StringTokenizer(eSet.getIdPath(), ".", false);
        if (eqI == null) {
            ShowMessageDelegate.showMessageDialog("Select the Equipment first", "PCGen", MessageType.ERROR);
            return;
        }
        if (eqI.isContainer()) {
            ShowMessageDelegate.showMessageDialog("Can not change quantity of containers", "PCGen", MessageType.ERROR);
            return;
        }
        if (aTok.countTokens() <= 3 && eqI.isEquipped()) {
            ShowMessageDelegate.showMessageDialog("Can not change quantity of Equipped items", "PCGen", MessageType.ERROR);
            return;
        }
        Float currentNum = eSet.getQty();
        Float numCarried = eqI.getCarried();
        if (aQty.floatValue() <= 0.0f) {
            String selectedValue = JOptionPane.showInputDialog(null, "Enter new Quantity", "PCGen", 3);
            if (selectedValue == null) return;
            try {
                newNum = Float.parseFloat(selectedValue.trim());
            }
            catch (Exception e) {
                ShowMessageDelegate.showMessageDialog("Invalid number!", "PCGen", MessageType.ERROR);
                return;
            }
        } else {
            newNum = aQty.floatValue();
        }
        if (CoreUtility.doublesEqual(newNum, currentNum.floatValue())) {
            return;
        }
        float addNum = newNum;
        if (currentNum.floatValue() > 0.0f) {
            addNum = newNum - currentNum.floatValue();
        }
        if (addNum > this.diffItemCount(eSet, eqI).floatValue()) {
            ShowMessageDelegate.showMessageDialog("You do not have " + newNum + " " + eqI.getName(), "PCGen", MessageType.ERROR);
            return;
        }
        if (aTok.countTokens() > 3) {
            Equipment eqP = (Equipment)eqI.getParent();
            eqI.setQty(new Float(addNum));
            eqI.setNumberCarried(new Float(addNum));
            if (eqP.canContain(this.pc, eqI) != 1) {
                eqI.setQty(currentNum);
                eqI.setNumberCarried(numCarried);
                ShowMessageDelegate.showMessageDialog("Container " + eqP.getName() + " is full", "PCGen", MessageType.ERROR);
                return;
            }
        }
        eSet.setQty(new Float(newNum));
        eqI.setNumberCarried(new Float(newNum));
        this.pc.setDirty(true);
        this.updateTotalWeight();
        this.updateSelectedModel();
    }

    private String getSingleLocation(Equipment eqI) {
        if (eqI.isNatural() && eqI.getSlots(this.pc) == 0) {
            if (eqI.modifiedName().endsWith("Primary")) {
                return "Natural-Primary";
            }
            return "Natural-Secondary";
        }
        if (eqI.isWeapon() && !eqI.isArmor()) {
            return "";
        }
        List eqSlotList = SystemCollections.getUnmodifiableEquipSlotList();
        if (eqSlotList == null || eqSlotList.isEmpty()) {
            return "";
        }
        Iterator eI = eqSlotList.iterator();
        while (eI.hasNext()) {
            EquipSlot es = (EquipSlot)eI.next();
            if (!es.canContainType(eqI.getType())) continue;
            return es.getSlotName();
        }
        return "";
    }

    private void setTableSelectedIndex(JTreeTable aTable, int idx) {
        aTable.setRowSelectionInterval(idx, idx);
    }

    private static int getTableSelectedIndex(ListSelectionEvent e) {
        DefaultListSelectionModel model = (DefaultListSelectionModel)e.getSource();
        if (model == null) {
            return -1;
        }
        return model.getMinSelectionIndex();
    }

    private final void createTreeTables() {
        this.availableTable = new JTreeTable(this.availableModel);
        final JTree atree = this.availableTable.getTree();
        atree.setRootVisible(false);
        atree.setShowsRootHandles(true);
        atree.setCellRenderer(new LabelTreeCellRenderer());
        atree.getSelectionModel().setSelectionMode(4);
        this.availableTable.setSelectionMode(2);
        this.availableTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int iRow = InfoEquipping.getTableSelectedIndex(e);
                    TreePath avaPath = atree.getPathForRow(iRow);
                    if (iRow < 0) {
                        avaPath = atree.getSelectionPath();
                    }
                    if (avaPath == null) {
                        return;
                    }
                    Object temp = avaPath.getLastPathComponent();
                    if (temp == null) {
                        InfoEquipping.this.lastEquip = null;
                        InfoEquipping.this.infoLabel.setText();
                        return;
                    }
                    MyPONode fNode = (MyPONode)temp;
                    if (fNode.getItem() instanceof Equipment) {
                        Equipment eqI = (Equipment)fNode.getItem();
                        if (eqI != null) {
                            InfoEquipping.this.AddMenu.setEnabled(true);
                            InfoEquipping.this.AddNumMenu.setEnabled(true);
                            InfoEquipping.this.AddAllMenu.setEnabled(true);
                            InfoEquipping.this.addEquipButton.setEnabled(true);
                            InfoEquipping.this.setInfoLabelText(eqI);
                        }
                    } else {
                        InfoEquipping.this.AddMenu.setEnabled(false);
                        InfoEquipping.this.AddNumMenu.setEnabled(false);
                        InfoEquipping.this.AddAllMenu.setEnabled(false);
                        InfoEquipping.this.addEquipButton.setEnabled(false);
                    }
                }
            }
        });
        MouseAdapter aml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TreePath avaPath = atree.getPathForLocation(e.getX(), e.getY());
                if (avaPath != null) {
                    if (e.getClickCount() == 2) {
                        InfoEquipping.this.addEquipButton(new Float(1.0f));
                    } else if (e.getClickCount() == 1 && e.isControlDown()) {
                        if (atree.isPathSelected(avaPath)) {
                            atree.removeSelectionPath(avaPath);
                        } else if (!atree.isPathSelected(avaPath)) {
                            atree.addSelectionPath(avaPath);
                        }
                    }
                }
            }
        };
        atree.addMouseListener(aml);
        this.selectedTable = new JTreeTable(this.selectedModel);
        final JTree stree = this.selectedTable.getTree();
        stree.setRootVisible(false);
        stree.setShowsRootHandles(true);
        stree.setCellRenderer(new LabelTreeCellRenderer());
        this.selectedTable.setSelectionMode(0);
        this.selectedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Object temp;
                    MyPONode fn;
                    EquipSet eSet;
                    int iRow = InfoEquipping.getTableSelectedIndex(e);
                    TreePath vcSelPath = stree.getPathForRow(iRow);
                    if (iRow < 0) {
                        vcSelPath = stree.getSelectionPath();
                    }
                    if (vcSelPath == null) {
                        return;
                    }
                    if (!stree.isSelectionEmpty() && (eSet = (EquipSet)(fn = (MyPONode)vcSelPath.getPathComponent(1)).getItem()) != null && !eSet.getName().equals(InfoEquipping.this.equipSetTextField.getText())) {
                        InfoEquipping.this.equipSetTextField.setText(eSet.getName());
                        InfoEquipping.this.selectedEquipSet = eSet.getName();
                        int index = InfoEquipping.this.viewComboBox.getSelectedIndex();
                        if (index == 2) {
                            InfoEquipping.this.updateAvailableModel();
                        }
                    }
                    if ((temp = vcSelPath.getLastPathComponent()) == null) {
                        InfoEquipping.this.lastEquip = null;
                        InfoEquipping.this.infoLabel.setText();
                        return;
                    }
                    MyPONode fNode = (MyPONode)temp;
                    if (fNode.getItem() instanceof EquipSet) {
                        EquipSet eSet2 = (EquipSet)fNode.getItem();
                        Equipment eqI = eSet2.getItem();
                        if (eqI == null) {
                            InfoEquipping.this.CopyEquipSetMenu.setEnabled(true);
                            InfoEquipping.this.RenameEquipSetMenu.setEnabled(true);
                            InfoEquipping.this.DelMenu.setEnabled(false);
                            InfoEquipping.this.SetQtyMenu.setEnabled(false);
                            InfoEquipping.this.SetLocationMenu.setEnabled(false);
                            InfoEquipping.this.SetNoteMenu.setEnabled(false);
                            InfoEquipping.this.delEquipButton.setEnabled(false);
                            InfoEquipping.this.setQtyButton.setEnabled(false);
                            InfoEquipping.this.setNoteButton.setEnabled(false);
                        }
                        if (eqI != null) {
                            InfoEquipping.this.CopyEquipSetMenu.setEnabled(false);
                            InfoEquipping.this.RenameEquipSetMenu.setEnabled(false);
                            InfoEquipping.this.DelMenu.setEnabled(true);
                            InfoEquipping.this.SetQtyMenu.setEnabled(true);
                            InfoEquipping.this.SetLocationMenu.setEnabled(true);
                            InfoEquipping.this.SetNoteMenu.setEnabled(true);
                            InfoEquipping.this.delEquipButton.setEnabled(true);
                            InfoEquipping.this.setQtyButton.setEnabled(true);
                            InfoEquipping.this.setNoteButton.setEnabled(true);
                            InfoEquipping.this.setInfoLabelText(eqI);
                        }
                    }
                }
            }
        });
        MouseAdapter sml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TreePath mlSelPath = stree.getPathForLocation(e.getX(), e.getY());
                if (mlSelPath != null) {
                    if (e.getClickCount() == 2) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 4 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                InfoEquipping.access$2300(4.access$2200(this.this$1));
                            }
                        });
                    } else if (e.getClickCount() == 1 && e.isControlDown()) {
                        if (stree.isPathSelected(mlSelPath)) {
                            stree.removeSelectionPath(mlSelPath);
                        } else if (!stree.isPathSelected(mlSelPath)) {
                            stree.addSelectionPath(mlSelPath);
                        }
                    }
                }
            }

            static /* synthetic */ InfoEquipping access$2200(4 x0) {
                return x0.InfoEquipping.this;
            }
        };
        stree.addMouseListener(sml);
        this.hookupPopupMenu(this.availableTable);
        this.hookupPopupMenu(this.selectedTable);
    }

    private static List getWeaponLocationChoices(int hands, String multiHand) {
        ArrayList<String> result = new ArrayList<String>(hands + 2);
        if (hands > 0) {
            result.add("Primary Hand");
            for (int i = 1; i < hands; ++i) {
                if (i > 1) {
                    result.add("Secondary Hand " + i);
                    continue;
                }
                result.add("Secondary Hand");
            }
            if (multiHand.length() > 0) {
                result.add(multiHand);
            }
        }
        return result;
    }

    private void addAllEquipButton() {
        this.addEquipButton(new Float(-1.0f));
    }

    private void addEquipButton(Float newQty) {
        int index;
        if (this.selectedTable.getTree().isSelectionEmpty()) {
            ShowMessageDelegate.showMessageDialog("First select an Equip Set to add the item to", "PCGen", MessageType.ERROR);
            return;
        }
        TreePath aeSelPath = this.selectedTable.getTree().getSelectionPath();
        String equipSetName = this.equipSetTextField.getText();
        String locName = "";
        Equipment eqTarget = null;
        EquipSet eSet = null;
        Object endComp = aeSelPath.getLastPathComponent();
        MyPONode parentNode = (MyPONode)endComp;
        if (parentNode.getItem() instanceof EquipSet && !"".equals((eSet = (EquipSet)parentNode.getItem()).getValue())) {
            eqTarget = eSet.getItem();
            if (eqTarget == null) {
                eqTarget = EquipmentList.getEquipmentNamed(eSet.getValue());
            }
            if (!eqTarget.isContainer()) {
                eSet = this.getCurrentEquipSet();
                parentNode = (MyPONode)aeSelPath.getPathComponent(1);
            }
        }
        if (eSet == null || parentNode == null) {
            ShowMessageDelegate.showMessageDialog("First select an Equip Set to add the item to", "PCGen", MessageType.ERROR);
            return;
        }
        TreePath[] avaCPaths = this.availableTable.getTree().getSelectionPaths();
        for (index = 0; index < avaCPaths.length; ++index) {
            Object aComp = avaCPaths[index].getLastPathComponent();
            MyPONode fNode = (MyPONode)aComp;
            if (!(fNode.getItem() instanceof Equipment)) {
                return;
            }
            Equipment eq = (Equipment)fNode.getItem();
            int outIndex = eq.getOutputIndex();
            Equipment eqI = (Equipment)eq.clone();
            eqI.setOutputIndex(outIndex);
            EquipSet newSet = this.addEquipToTarget(eSet, eqTarget, locName, eqI, newQty);
            if (newSet == null) {
                Logging.errorPrint("Could not add Equipment");
                return;
            }
            MyPONode fN = new MyPONode();
            fN.setItem(newSet);
            fN.setParent(parentNode);
            parentNode.addChild(fN);
        }
        this.selectedEquipSet = equipSetName;
        this.updateTotalWeight();
        this.updateSelectedModel();
        index = this.viewComboBox.getSelectedIndex();
        if (index == 2) {
            this.updateAvailableModel();
        }
        this.pc.calcActiveBonuses();
    }

    private void addEquipSetButton() {
        String equipSetFieldText = this.equipSetTextField.getText();
        if (equipSetFieldText.equals(this.selectedEquipSet)) {
            return;
        }
        EquipSet pcSet = this.pc.getEquipSetByName(equipSetFieldText);
        if (pcSet != null) {
            return;
        }
        String id = this.getNewIdPath(null);
        EquipSet eSet = new EquipSet(id, equipSetFieldText);
        this.pc.setDirty(true);
        this.selectedEquipSet = equipSetFieldText;
        this.pc.addEquipSet(eSet);
        this.calcComboBoxFill();
        this.updateSelectedModel();
    }

    private EquipSet addEquipToTarget(EquipSet eSet, Equipment eqTarget, String locName, Equipment eqI, Float newQty) {
        Float tempQty = newQty;
        boolean addAll = false;
        boolean mergeItem = false;
        if (newQty.floatValue() < 0.0f) {
            tempQty = this.diffItemCount(eSet, eqI);
            newQty = new Float(tempQty.floatValue() + this.existingQty(eSet, eqI).floatValue());
            addAll = true;
        }
        if (tempQty.floatValue() > this.diffItemCount(eSet, eqI).floatValue()) {
            ShowMessageDelegate.showMessageDialog("You have already added all your " + eqI.getName(), "PCGen", MessageType.ERROR);
            return null;
        }
        if (eqTarget != null && eqTarget.isContainer()) {
            eqI.setQty(newQty);
            eqI.setNumberCarried(newQty);
            if (eqTarget.canContain(this.pc, eqI) == 1) {
                locName = eqTarget.getName();
                addAll = true;
                mergeItem = true;
            } else {
                ShowMessageDelegate.showMessageDialog("Container " + eqTarget.getName() + " is full", "PCGen", MessageType.ERROR);
                return null;
            }
        }
        if ("".equals(locName) || locName.length() == 0) {
            ArrayList containers = new ArrayList();
            List aList = this.locationChoices(eqI, containers);
            locName = this.getSingleLocation(eqI);
            if (locName.length() == 0 || !this.canAddEquip(eSet, locName, eqI, eqTarget)) {
                ChooserRadio c = ChooserFactory.getRadioInstance();
                if (containers.size() != 0) {
                    c.setComboData("Container", containers);
                }
                c.setAvailableList(aList);
                c.setVisible(false);
                c.setTitle(eqI.getName());
                c.setMessageText("Select a location for this item");
                c.setVisible(true);
                aList = c.getSelectedList();
                if (c.getSelectedList().size() > 0) {
                    Object loc = aList.get(0);
                    if (loc instanceof String) {
                        locName = (String)loc;
                        mergeItem = true;
                    } else {
                        eSet = ((EqSetWrapper)loc).getEqSet();
                        eqTarget = eSet.getItem();
                        if (eqTarget.canContain(this.pc, eqI) == 1) {
                            locName = eqTarget.getName();
                            addAll = true;
                            mergeItem = true;
                        } else {
                            ShowMessageDelegate.showMessageDialog("Container " + eqTarget.getName() + " is full", "PCGen", MessageType.ERROR);
                            return null;
                        }
                    }
                }
            }
        }
        if ("".equals(locName) || locName.length() == 0) {
            return null;
        }
        if (!this.canAddEquip(eSet, locName, eqI, eqTarget)) {
            ShowMessageDelegate.showMessageDialog("Can not equip " + eqI.getName() + " to " + locName, "PCGen", MessageType.ERROR);
            return null;
        }
        if (eqI.isContainer()) {
            mergeItem = false;
        }
        EquipSet existingSet = this.existingItem(eSet, eqI);
        if (addAll && mergeItem && existingSet != null) {
            newQty = new Float(tempQty.floatValue() + this.existingQty(eSet, eqI).floatValue());
            existingSet.setQty(newQty);
            eqI.setQty(newQty);
            eqI.setNumberCarried(newQty);
            this.pc.setDirty(true);
            if (eqTarget != null && eqTarget.isContainer()) {
                eqTarget.updateContainerContentsString(this.pc);
            }
            return existingSet;
        }
        if (eqTarget != null && eqTarget.isContainer()) {
            eqTarget.insertChild(this.pc, eqI);
            eqI.setParent(eqTarget);
        }
        String id = this.getNewIdPath(eSet);
        EquipSet newSet = new EquipSet(id, locName, eqI.getName(), eqI);
        eqI.setQty(newQty);
        newSet.setQty(newQty);
        this.pc.addEquipSet(newSet);
        this.pc.setDirty(true);
        return newSet;
    }

    private void addNumEquipButton() {
        String selectedValue = JOptionPane.showInputDialog(null, "Enter Quantity", "PCGen", 3);
        if (selectedValue != null) {
            Float newQty;
            try {
                newQty = new Float(selectedValue.trim());
            }
            catch (Exception e) {
                ShowMessageDelegate.showMessageDialog("Invalid number!", "PCGen", MessageType.ERROR);
                return;
            }
            this.addEquipButton(newQty);
        }
    }

    private void buyEquipButton(Float newQty) {
        String selectedValue;
        if (newQty.floatValue() <= 0.0f && (selectedValue = JOptionPane.showInputDialog(null, "Enter Quantity to buy", "PCGen", 3)) != null) {
            try {
                newQty = new Float(selectedValue.trim());
            }
            catch (Exception e) {
                ShowMessageDelegate.showMessageDialog("Invalid number!", "PCGen", MessageType.ERROR);
                return;
            }
        }
        TreePath[] avaCPaths = this.availableTable.getTree().getSelectionPaths();
        for (int index = 0; index < avaCPaths.length; ++index) {
            Object aComp = avaCPaths[index].getLastPathComponent();
            MyPONode fNode = (MyPONode)aComp;
            if (!(fNode.getItem() instanceof Equipment)) {
                return;
            }
            Equipment eq = (Equipment)fNode.getItem();
            PCGen_Frame1.getCharacterPane().infoInventory().getInfoGear().buySpecifiedEquipment(eq, newQty.doubleValue());
            this.forceRefresh();
        }
    }

    private void calcComboBoxActionPerformed() {
        String eqSetId;
        EquipSet eSet = (EquipSet)this.calcComboBox.getSelectedItem();
        if (eSet != null && !(eqSetId = eSet.getIdPath()).equals(this.pc.getCalcEquipSetId())) {
            this.pc.setCalcEquipSetId(eqSetId);
            this.pc.setCalcEquipmentList();
            this.pc.setDirty(true);
            this.updateTotalWeight();
            CharacterInfo pane = PCGen_Frame1.getCharacterPane();
            pane.setPaneForUpdate(pane.infoAbilities());
            pane.setPaneForUpdate(pane.infoClasses());
            pane.setPaneForUpdate(pane.infoFeats());
            pane.setPaneForUpdate(pane.infoSkills());
            pane.setPaneForUpdate(pane.infoSpells());
            pane.setPaneForUpdate(pane.infoSummary());
            pane.refresh();
        }
    }

    private void calcComboBoxFill() {
        if (this.calcComboBoxListener != null) {
            this.calcComboBox.removeActionListener(this.calcComboBoxListener);
        }
        ArrayList<String> calcList = new ArrayList<String>(1);
        this.calcComboBox.removeAllItems();
        equipSetList = this.pc.getEquipSet();
        Iterator e = equipSetList.iterator();
        while (e.hasNext()) {
            EquipSet es = (EquipSet)e.next();
            if (!es.getParentIdPath().equals("0") || calcList.contains(es.getIdPath())) continue;
            calcList.add(es.getIdPath());
            this.calcComboBox.addItem(es);
        }
        EquipSet cES = this.pc.getEquipSetByIdPath(this.pc.getCalcEquipSetId());
        if (cES == null) {
            if (this.calcComboBoxListener != null) {
                this.calcComboBox.addActionListener(this.calcComboBoxListener);
            }
            return;
        }
        for (int i = 0; i <= this.calcComboBox.getItemCount(); ++i) {
            EquipSet es = (EquipSet)this.calcComboBox.getItemAt(i);
            if (es == null || !es.getIdPath().equals(cES.getIdPath())) continue;
            this.calcComboBox.setSelectedIndex(i);
        }
        if (this.calcComboBoxListener != null) {
            this.calcComboBox.addActionListener(this.calcComboBoxListener);
        }
    }

    private boolean canAddEquip(EquipSet eSet, String locName, Equipment eqI, Equipment eqTarget) {
        String abID;
        String esID;
        EquipSet es;
        String idPath = eSet.getIdPath();
        if (eqTarget != null && eqTarget.isContainer()) {
            return true;
        }
        if (locName.startsWith("Carried") || locName.startsWith("Equipped") || locName.startsWith("Not Carried")) {
            return true;
        }
        if (eqI.isUnarmed()) {
            return true;
        }
        if (locName.equals("Natural-Secondary")) {
            return true;
        }
        if (eqI.isWeapon() && Globals.isWeaponOutsizedForPC(this.pc, eqI) && !eqI.isNatural()) {
            return false;
        }
        HashMap<String, String> slotMap = new HashMap<String, String>();
        Iterator e = this.pc.getEquipSet().iterator();
        while (e.hasNext()) {
            es = (EquipSet)e.next();
            esID = es.getParentIdPath() + ".";
            if (!esID.startsWith(abID = idPath + ".") || !es.getName().equals(locName)) continue;
            Equipment eItem = es.getItem();
            String nString = (String)slotMap.get(locName);
            int existNum = 0;
            if (nString != null) {
                existNum = Integer.parseInt(nString);
            }
            if (eItem != null) {
                existNum += eItem.getSlots(this.pc);
            }
            slotMap.put(locName, String.valueOf(existNum));
        }
        e = this.pc.getEquipSet().iterator();
        while (e.hasNext()) {
            es = (EquipSet)e.next();
            esID = es.getParentIdPath() + ".";
            if (!esID.startsWith(abID = idPath + ".")) continue;
            if (eqI.isWeapon()) {
                if (es.getName().equals(locName)) {
                    return false;
                }
                if ((locName.equals("Both Hands") || locName.equals("Double Weapon")) && (es.getName().equals("Primary Hand") || es.getName().equals("Secondary Hand") || es.getName().equals("Both Hands") || es.getName().equals("Double Weapon"))) {
                    return false;
                }
                if ((locName.equals("Primary Hand") || locName.equals("Secondary Hand")) && (es.getName().equals("Both Hands") || es.getName().equals("Double Weapon"))) {
                    return false;
                }
            }
            if (!es.getName().equals(locName)) continue;
            String nString = (String)slotMap.get(locName);
            int existNum = 0;
            if (nString != null) {
                existNum = Integer.parseInt(nString);
            }
            existNum += eqI.getSlots(this.pc);
            EquipSlot eSlot = Globals.getEquipSlotByName(locName);
            if (eSlot == null) {
                return true;
            }
            return existNum <= eSlot.getSlotCount() + (int)this.pc.getTotalBonusTo("SLOTS", eSlot.getContainType());
        }
        return true;
    }

    private void addEquipTreeNodes(MyPONode aNode, EquipSet aSet) {
        ArrayList<EquipSet> aList = new ArrayList<EquipSet>();
        String idPath = "0";
        if (aSet != null) {
            idPath = aSet.getIdPath();
        }
        for (int iSet = 0; iSet < tempSetList.size(); ++iSet) {
            EquipSet es = (EquipSet)tempSetList.get(iSet);
            if (!es.getParentIdPath().equals(idPath)) continue;
            MyPONode fN = new MyPONode();
            fN.setItem(es);
            fN.setParent(aNode);
            aNode.addChild(fN);
            aList.add(es);
            tempSetList.remove(es);
            --iSet;
        }
        for (int i = 0; i < aList.size(); ++i) {
            this.addEquipTreeNodes((MyPONode)aNode.getChild(i), (EquipSet)aList.get(i));
        }
    }

    private void chooseTempBonuses(EquipSet eSet) {
        TempWrap tw;
        LinkedList aList = new LinkedList();
        LinkedList<String> checkList = new LinkedList<String>();
        LinkedList<TempWrap> tbList = new LinkedList<TempWrap>();
        LinkedList<String> sList = new LinkedList<String>();
        Iterator fI = this.pc.getTempBonusList().iterator();
        while (fI.hasNext()) {
            BonusObj aBonus = (BonusObj)fI.next();
            Object aC = aBonus.getCreatorObject();
            Object aT = aBonus.getTargetObject();
            tw = new TempWrap(aC, aT, aBonus);
            tbList.add(tw);
            String sString = tw.getName();
            if (sList.contains(sString)) continue;
            sList.add(sString);
        }
        ChooserInterface lc = ChooserFactory.getChooserInstance();
        lc.setVisible(false);
        lc.setTitle("Select Bonuses");
        lc.setMessageText("Temp bonuses applied to this EquipSet");
        lc.setAvailableList(sList);
        lc.setPool(sList.size());
        lc.setPoolFlag(false);
        lc.setVisible(true);
        Iterator as = lc.getSelectedList().iterator();
        while (as.hasNext()) {
            String aString = (String)as.next();
            for (int j = 0; j < tbList.size(); ++j) {
                tw = (TempWrap)tbList.get(j);
                String tbString = tw.getName();
                if (!aString.equals(tbString) || checkList.contains(tbString)) continue;
                String sourceStr = tw.getCreatorName();
                String targetStr = tw.getTargetName();
                aList.addAll(this.pc.getTempBonusList(sourceStr, targetStr));
                checkList.add(tbString);
            }
        }
        eSet.setTempBonusList(aList);
        this.pc.setDirty(true);
    }

    private void copyEquipSetButton() {
        ArrayList<EquipSet> newEquipSet = new ArrayList<EquipSet>();
        EquipSet eSet = this.getCurrentEquipSet();
        if (eSet == null) {
            ShowMessageDelegate.showMessageDialog("First select an Equip Set to duplicate.", "PCGen", MessageType.ERROR);
            return;
        }
        String pid = eSet.getIdPath();
        String newName = JOptionPane.showInputDialog(null, "Enter name for new Equip Set", "PCGen", 3);
        if (newName == null || newName.length() <= 0) {
            return;
        }
        EquipSet pcSet = this.pc.getEquipSetByName(newName);
        if (pcSet != null) {
            ShowMessageDelegate.showMessageDialog("An EquipSet all ready exists with that name.", "PCGen", MessageType.ERROR);
            return;
        }
        String id = this.getNewIdPath(null);
        eSet = (EquipSet)eSet.clone();
        eSet.setIdPath(id);
        eSet.setName(newName);
        this.selectedEquipSet = newName;
        this.pc.addEquipSet(eSet);
        Iterator e = equipSetList.iterator();
        while (e.hasNext()) {
            String pIdPath;
            EquipSet es = (EquipSet)e.next();
            String esIdPath = es.getParentIdPath() + ".";
            if (!esIdPath.startsWith(pIdPath = pid + ".")) continue;
            EquipSet equipItem = (EquipSet)es.clone();
            equipItem.setIdPath(id + es.getIdPath().substring(pid.length()));
            newEquipSet.add(equipItem);
        }
        e = newEquipSet.iterator();
        while (e.hasNext()) {
            this.pc.addEquipSet((EquipSet)e.next());
        }
        this.pc.setDirty(true);
        this.calcComboBoxFill();
        this.updateSelectedModel();
    }

    private final void createAvailableModel() {
        if (this.availableModel == null) {
            this.availableModel = new EquipModel(this.viewMode, 0);
        } else {
            this.availableModel.resetModel(this.viewMode, 0);
        }
        if (this.availableSort != null) {
            this.availableSort.setRoot((MyPONode)this.availableModel.getRoot());
            this.availableSort.sortNodeOnColumn();
        }
    }

    private final void createModels() {
        this.createAvailableModel();
        this.createSelectedModel();
    }

    private final void createSelectedModel() {
        if (this.selectedModel == null) {
            this.selectedModel = new EquipModel(this.viewSelectMode, 1);
        } else {
            this.selectedModel.resetModel(this.viewSelectMode, 1);
        }
        if (this.selectedSort != null) {
            this.selectedSort.setRoot((MyPONode)this.selectedModel.getRoot());
            this.selectedSort.sortNodeOnColumn();
        }
    }

    private void delEquipButton() {
        int index;
        TreePath delSelPath = this.selectedTable.getTree().getSelectionPath();
        if (delSelPath == null) {
            ShowMessageDelegate.showMessageDialog("Select the Equipment to remove from this set", "PCGen", MessageType.ERROR);
            return;
        }
        TreePath[] selCPaths = this.selectedTable.getTree().getSelectionPaths();
        for (index = 0; index < selCPaths.length; ++index) {
            Equipment eqP;
            Object endComp = selCPaths[index].getLastPathComponent();
            MyPONode fNode = (MyPONode)endComp;
            if (!(fNode.getItem() instanceof EquipSet)) {
                return;
            }
            EquipSet eSet = (EquipSet)fNode.getItem();
            if (eSet.getItem() == null) {
                ShowMessageDelegate.showMessageDialog("Use this to remove equipment, not the Equipment Set itself", "PCGen", MessageType.ERROR);
                return;
            }
            Equipment eqI = eSet.getItem();
            StringTokenizer aTok = new StringTokenizer(eSet.getIdPath(), ".", false);
            this.pc.delEquipSet(eSet);
            if (aTok.countTokens() <= 3 || (eqP = (Equipment)eqI.getParent()) == null) continue;
            eqP.removeChild(this.pc, eqI);
        }
        this.pc.setDirty(true);
        this.updateTotalWeight();
        this.updateSelectedModel();
        this.pc.calcActiveBonuses();
        index = this.viewComboBox.getSelectedIndex();
        if (index == 2) {
            this.updateAvailableModel();
        }
    }

    private void delEquipSetButton() {
        String equipSetFieldText = this.equipSetTextField.getText();
        EquipSet eSet = this.pc.getEquipSetByName(equipSetFieldText);
        if (eSet == null) {
            Logging.errorPrint("delEquipSetButton: No EquipSet named: " + equipSetFieldText);
            return;
        }
        int iConfirm = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete?", "Confirm Remove", 0);
        if (iConfirm != 0) {
            return;
        }
        if (!this.pc.delEquipSet(eSet)) {
            Logging.errorPrint("delEquipSetButton:failed ");
            return;
        }
        this.pc.setDirty(true);
        this.calcComboBoxFill();
        this.selectedEquipSet = "";
        this.updateSelectedModel();
    }

    private Float diffItemCount(EquipSet eSet, Equipment eqI) {
        Float aVal = new Float(2.1474836E9f);
        String rPath = eSet.getRootIdPath();
        float cQty = 0.0f;
        Equipment masterEq = this.pc.getEquipmentNamed(eqI.getName());
        if (masterEq == null) {
            return aVal;
        }
        Iterator e = this.pc.getEquipSet().iterator();
        while (e.hasNext()) {
            String rIdPath;
            EquipSet es = (EquipSet)e.next();
            String esIdPath = es.getIdPath() + ".";
            if (!esIdPath.startsWith(rIdPath = rPath + ".") || !eqI.getName().equals(es.getValue())) continue;
            cQty += es.getQty().floatValue();
        }
        if (cQty <= masterEq.getQty().floatValue()) {
            aVal = new Float(masterEq.getQty().floatValue() - cQty);
        }
        return aVal;
    }

    private void eqSetPrintToWriter(BufferedWriter bw, String template) throws IOException {
        File esTemplate = new File(template);
        int[] tests = new int[]{0, 0};
        int length = 0;
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(esTemplate), "UTF-8"));
        while (br.readLine() != null) {
            ++length;
        }
        br.close();
        File reParse = File.createTempFile("eqTTemp_", ".tmp");
        String reparseName = reParse.getPath();
        BufferedWriter rpW = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(reparseName, true), "UTF-8"));
        File temp = File.createTempFile("eqTemp_", ".tmp");
        while (tests[0] < length) {
            String aLine;
            int[] ret = InfoEquipping.eqsheetSplit(esTemplate, temp, tests);
            tests[0] = ret[0];
            if (ret[1] == 1) {
                this.equipItch(temp, rpW);
                rpW.flush();
                continue;
            }
            BufferedReader tempReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(temp), "UTF-8"));
            while ((aLine = tempReader.readLine()) != null) {
                rpW.write(aLine);
                rpW.newLine();
            }
            rpW.flush();
            tempReader.close();
        }
        rpW.close();
        temp.delete();
        bw.flush();
        new ExportHandler(reParse).write(this.pc, bw);
        reParse.deleteOnExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static int[] eqsheetSplit(File template, File tmpFile, int[] tests) {
        block17: {
            done = false;
            eqset = false;
            ret = new int[2];
            lineNum = tests[0];
            output = null;
            try {
                try {
                    output = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), "UTF-8"));
                    br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(template), "UTF-8"));
                    lines = new ArrayList<String>();
                    while ((aLine = br.readLine()) != null) {
                        lines.add(aLine);
                    }
                    br.close();
                    while (!done && lineNum < lines.size()) {
                        line = (String)lines.get(lineNum);
                        if (line.indexOf("|EQSET.START|") > -1) {
                            ++lineNum;
                            done = true;
                            continue;
                        }
                        if (line.indexOf("|EQSET.END|") > -1) {
                            ++lineNum;
                            done = true;
                            eqset = true;
                            continue;
                        }
                        output.write(line);
                        output.newLine();
                        ++lineNum;
                    }
                    var13_13 = null;
                    if (output == null) break block17;
                }
                catch (IOException ioe) {
                    ShowMessageDelegate.showMessageDialog("Could not create temporary equip sets preview file.", "PCGen", MessageType.ERROR);
                    Logging.errorPrint("Could not create temporary equip sets preview file.");
                    var13_14 = null;
                    if (output != null) {
                        try {
                            output.flush();
                            output.close();
                        }
                        catch (IOException e) {
                        }
                        catch (NullPointerException e) {}
                    }
                    break block17;
                }
            }
            catch (Throwable var12_22) {
                var13_15 = null;
                if (output == null) throw var12_22;
                ** try [egrp 2[TRYBLOCK] [4, 5 : 248->261)] { 
lbl53:
                // 1 sources

                output.flush();
                output.close();
                throw var12_22;
lbl56:
                // 1 sources

                catch (IOException e) {
                    throw var12_22;
                }
lbl58:
                // 1 sources

                catch (NullPointerException e) {
                    // empty catch block
                }
                throw var12_22;
            }
            ** try [egrp 2[TRYBLOCK] [4, 5 : 248->261)] { 
lbl63:
            // 1 sources

            output.flush();
            output.close();
lbl66:
            // 1 sources

            catch (IOException e) {
            }
lbl68:
            // 1 sources

            catch (NullPointerException e) {}
        }
        ret[0] = lineNum;
        if (eqset) {
            ret[1] = 1;
            return ret;
        }
        ret[1] = 0;
        return ret;
    }

    private void equipItch(File template, BufferedWriter out) {
        ArrayList<EquipSet> eqRootList = new ArrayList<EquipSet>();
        Iterator e = equipSetList.iterator();
        while (e.hasNext()) {
            EquipSet es = (EquipSet)e.next();
            if (!es.getParentIdPath().equals("0")) continue;
            eqRootList.add(es);
        }
        String oldEqId = this.pc.getCalcEquipSetId();
        Collections.sort(equipSetList);
        List aList = this.pc.getTempBonusList();
        int eqCount = 0;
        Iterator i = eqRootList.iterator();
        while (i.hasNext()) {
            EquipSet esRL = (EquipSet)i.next();
            String pid = esRL.getIdPath();
            this.pc.setCurrentEquipSetName(esRL.getName());
            this.pc.setCalcEquipSetId(pid);
            this.pc.setEquipSetNumber(eqCount);
            ++eqCount;
            boolean currentTempBonus = this.pc.getUseTempMods();
            this.pc.setUseTempMods(esRL.getUseTempMods());
            if (esRL.useTempBonusList()) {
                this.pc.setTempBonusList(esRL.getTempBonusList());
            }
            new ExportHandler(template).write(this.pc, out);
            this.pc.setUseTempMods(currentTempBonus);
            this.pc.setTempBonusList(aList);
        }
        try {
            out.flush();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.pc.setCalcEquipSetId(oldEqId);
        this.pc.setCalcEquipmentList();
        this.pc.setEquipSetNumber(0);
    }

    private EquipSet existingItem(EquipSet eSet, Equipment eqI) {
        String rPath = eSet.getIdPath();
        Iterator e = this.pc.getEquipSet().iterator();
        while (e.hasNext()) {
            String rIdPath;
            EquipSet es = (EquipSet)e.next();
            String esIdPath = es.getIdPath() + ".";
            if (!esIdPath.startsWith(rIdPath = rPath + ".") || !eqI.getName().equals(es.getValue())) continue;
            return es;
        }
        return null;
    }

    private Float existingQty(EquipSet eSet, Equipment eqI) {
        String rPath = eSet.getIdPath();
        Iterator e = this.pc.getEquipSet().iterator();
        while (e.hasNext()) {
            String rIdPath;
            EquipSet es = (EquipSet)e.next();
            String esIdPath = es.getIdPath() + ".";
            if (!esIdPath.startsWith(rIdPath = rPath + ".") || !eqI.getName().equals(es.getValue())) continue;
            return es.getQty();
        }
        return new Float(0.0f);
    }

    private void formComponentShown() {
        PCGen_Frame1.getStatusBar().setText("Select containers to add equipment to them");
        this.refresh();
        int s = this.splitPane.getDividerLocation();
        int t = this.bsplit.getDividerLocation();
        int u = this.asplit.getDividerLocation();
        if (!this.hasBeenSized) {
            int width;
            TableColumn sCol;
            int i;
            this.hasBeenSized = true;
            Container c = this.getParent();
            s = SettingsHandler.getPCGenOption("InfoEquipping.splitPane", c.getWidth() * 7 / 10);
            t = SettingsHandler.getPCGenOption("InfoEquipping.bsplit", c.getHeight() - 101);
            u = SettingsHandler.getPCGenOption("InfoEquipping.asplit", c.getWidth() - 408);
            for (i = 0; i < this.selectedTable.getColumnCount(); ++i) {
                sCol = this.selectedTable.getColumnModel().getColumn(i);
                width = Globals.getCustColumnWidth("EquipSel", i);
                if (width != 0) {
                    sCol.setPreferredWidth(width);
                }
                sCol.addPropertyChangeListener(new ResizeColumnListener(this.selectedTable, "EquipSel", i));
            }
            for (i = 0; i < this.availableTable.getColumnCount(); ++i) {
                sCol = this.availableTable.getColumnModel().getColumn(i);
                width = Globals.getCustColumnWidth("EquipAva", i);
                if (width != 0) {
                    sCol.setPreferredWidth(width);
                }
                sCol.addPropertyChangeListener(new ResizeColumnListener(this.availableTable, "EquipAva", i));
            }
            this.calcComboBoxListener = new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    InfoEquipping.this.calcComboBoxActionPerformed();
                }
            };
            this.calcComboBox.addActionListener(this.calcComboBoxListener);
        }
        if (s > 0) {
            this.splitPane.setDividerLocation(s);
            SettingsHandler.setPCGenOption("InfoEquipping.splitPane", s);
        }
        if (t > 0) {
            this.bsplit.setDividerLocation(t);
            SettingsHandler.setPCGenOption("InfoEquipping.bsplit", t);
        }
        if (u > 0) {
            this.asplit.setDividerLocation(u);
            SettingsHandler.setPCGenOption("InfoEquipping.asplit", u);
        }
    }

    private void hookupPopupMenu(JTreeTable treeTable) {
        treeTable.addMouseListener(new EquipPopupListener(treeTable, new EquipPopupMenu(treeTable)));
    }

    private void initActionListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                InfoEquipping.this.formComponentShown();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                int s = InfoEquipping.this.splitPane.getDividerLocation();
                if (s > 0) {
                    SettingsHandler.setPCGenOption("InfoEquipping.splitPane", s);
                }
                if ((s = InfoEquipping.this.asplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoEquipping.asplit", s);
                }
                if ((s = InfoEquipping.this.bsplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoEquipping.bsplit", s);
                }
            }
        });
        this.viewEqSetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfoEquipping.this.viewEqSetButton();
            }
        });
        this.exportEqSetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfoEquipping.this.exportEqSetButton();
            }
        });
        this.selectTemplateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfoEquipping.this.selectTemplateButton();
            }
        });
        this.addEquipButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.addEquipButton(new Float(1.0f));
            }
        });
        this.delEquipButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.delEquipButton();
            }
        });
        this.setQtyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.setQtyButton(new Float(0.0f));
            }
        });
        this.setNoteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.setNoteButton();
            }
        });
        this.addEquipSetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.addEquipSetButton();
            }
        });
        this.delEquipSetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.delEquipSetButton();
            }
        });
        this.viewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.viewComboBoxActionPerformed();
            }
        });
    }

    private void initComponents() {
        this.readyForRefresh = true;
        int iView = SettingsHandler.getEquipTab_AvailableListMode();
        this.viewMode = iView >= 0 && iView <= 3 ? iView : 0;
        SettingsHandler.setEquipTab_AvailableListMode(this.viewMode);
        iView = SettingsHandler.getEquipTab_SelectedListMode();
        this.viewSelectMode = iView >= 0 && iView <= 1 ? iView : 0;
        SettingsHandler.setEquipTab_SelectedListMode(this.viewSelectMode);
        this.viewComboBox.addItem(PropertyFactory.getString("in_nameLabel") + "     ");
        this.viewComboBox.addItem(PropertyFactory.getString("in_ieLoc") + " ");
        this.viewComboBox.addItem(PropertyFactory.getString("in_ieEquipped") + " ");
        this.viewComboBox.addItem(PropertyFactory.getString("in_type") + "     ");
        Utility.setDescription(this.viewComboBox, "Blah Blah");
        this.viewComboBox.setSelectedIndex(this.viewMode);
        ImageIcon newImage = IconUtilitities.getImageIcon("Forward16.gif");
        this.addEquipButton = new JButton(newImage);
        newImage = IconUtilitities.getImageIcon("Back16.gif");
        this.delEquipButton = new JButton(newImage);
        this.setQtyButton = new JButton(PropertyFactory.getString("in_ieSetQt"));
        this.setNoteButton = new JButton(PropertyFactory.getString("in_ieSetNote"));
        this.createModels();
        this.createTreeTables();
        this.calcComboBoxFill();
        EquipSet es = (EquipSet)this.calcComboBox.getSelectedItem();
        if (es != null) {
            this.equipSetTextField.setText(es.getName());
            this.selectedEquipSet = this.equipSetTextField.getText();
            TreePath initSelPath = this.selectedTable.getTree().getPathForRow(0);
            if (initSelPath != null) {
                this.selectedTable.getTree().setSelectionPath(initSelPath);
            }
        }
        this.topPane.setLayout(new BorderLayout());
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel leftPane = new JPanel();
        JPanel rightPane = new JPanel();
        leftPane.setLayout(gridbag);
        rightPane.setLayout(gridbag);
        this.splitPane = new FlippingSplitPane(splitOrientation, leftPane, rightPane);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.topPane.add((Component)this.splitPane, "Center");
        Utility.buildConstraints(c, 0, 0, 1, 1, 0.0, 0.0);
        c.fill = 0;
        c.anchor = 11;
        JPanel aPanel = new JPanel();
        gridbag.setConstraints(aPanel, c);
        aPanel.add(this.avaLabel);
        aPanel.add(this.viewComboBox);
        Utility.setDescription(this.addEquipButton, PropertyFactory.getString("in_ieAddEqBut"));
        this.addEquipButton.setEnabled(false);
        aPanel.add(this.addEquipButton);
        Utility.setDescription(aPanel, PropertyFactory.getString("in_ieAddEqRight"));
        leftPane.add(aPanel);
        Utility.buildConstraints(c, 0, 2, 1, 1, 10.0, 10.0);
        c.fill = 1;
        c.anchor = 11;
        c.ipadx = 1;
        JScrollPane scrollPane = new JScrollPane(this.availableTable);
        gridbag.setConstraints(scrollPane, c);
        leftPane.add(scrollPane);
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        rightPane.setLayout(gridbag);
        Utility.buildConstraints(c, 0, 0, 1, 1, 0.0, 0.0);
        c.fill = 2;
        c.anchor = 11;
        aPanel = new JPanel();
        gridbag.setConstraints(aPanel, c);
        JLabel selProfileLabel = new JLabel(PropertyFactory.getString("in_ieEquipSet") + ":");
        aPanel.add(selProfileLabel);
        this.equipSetTextField.setPreferredSize(new Dimension(100, 20));
        aPanel.add(this.equipSetTextField);
        this.addEquipSetButton = new JButton(PropertyFactory.getString("in_add"));
        aPanel.add(this.addEquipSetButton);
        this.delEquipSetButton = new JButton(PropertyFactory.getString("in_ieDel"));
        aPanel.add(this.delEquipSetButton);
        rightPane.add(aPanel);
        Utility.buildConstraints(c, 0, 1, 1, 1, 0.0, 0.0);
        c.fill = 2;
        c.anchor = 11;
        JPanel bPanel = new JPanel();
        gridbag.setConstraints(bPanel, c);
        Utility.setDescription(this.setNoteButton, "Add additional info to this item");
        this.setNoteButton.setEnabled(false);
        bPanel.add(this.setNoteButton);
        Utility.setDescription(this.setQtyButton, "Click to change number of items");
        this.setQtyButton.setEnabled(false);
        bPanel.add(this.setQtyButton);
        Utility.setDescription(this.delEquipButton, "Click to remove selected equipment from this set");
        this.delEquipButton.setEnabled(false);
        bPanel.add(this.delEquipButton);
        rightPane.add(bPanel);
        Utility.buildConstraints(c, 0, 2, 1, 1, 10.0, 10.0);
        c.fill = 1;
        c.anchor = 11;
        c.ipadx = 1;
        scrollPane = new JScrollPane(this.selectedTable);
        gridbag.setConstraints(scrollPane, c);
        rightPane.add(scrollPane);
        this.availableTable.setColAlign(1, 4);
        this.availableTable.setColAlign(2, 0);
        this.availableTable.setColAlign(4, 4);
        this.availableTable.setColAlign(3, 4);
        this.selectedTable.setColAlign(1, 4);
        this.selectedTable.setColAlign(2, 0);
        this.selectedTable.getColumnModel().getColumn(1).setCellRenderer(new ColorRenderer());
        this.selectedTable.getColumnModel().getColumn(3).setCellRenderer(new ColorRenderer());
        this.selectedTable.getColumnModel().getColumn(2).setCellEditor(new QuantityEditor());
        this.selectedTable.getColumnModel().getColumn(4).setCellEditor(new BonusEditor());
        this.botPane.setLayout(new BorderLayout());
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        JPanel bLeftPane = new JPanel();
        JPanel bRightPane = new JPanel();
        bLeftPane.setLayout(gridbag);
        bRightPane.setLayout(gridbag);
        this.asplit = new FlippingSplitPane(1, bLeftPane, bRightPane);
        this.asplit.setOneTouchExpandable(true);
        this.asplit.setDividerSize(10);
        this.botPane.add((Component)this.asplit, "Center");
        Utility.buildConstraints(c, 0, 0, 1, 1, 0.0, 0.0);
        c.fill = 1;
        c.anchor = 10;
        JPanel wPanel = new JPanel();
        gridbag.setConstraints(wPanel, c);
        this.totalWeight.setEditable(false);
        this.totalWeight.setOpaque(false);
        this.totalWeight.setBorder(null);
        this.totalWeight.setBackground(Color.lightGray);
        this.loadWeight.setEditable(false);
        this.loadWeight.setOpaque(false);
        this.loadWeight.setBorder(null);
        this.loadWeight.setBackground(Color.lightGray);
        wPanel.add(this.weightLabel);
        wPanel.add(this.totalWeight);
        wPanel.add(this.loadLabel);
        wPanel.add(this.loadWeight);
        Utility.buildConstraints(c, 0, 1, 1, 1, 2.0, 2.0);
        c.fill = 1;
        c.anchor = 10;
        JScrollPane sScroll = new JScrollPane();
        gridbag.setConstraints(sScroll, c);
        TitledBorder sTitle = BorderFactory.createTitledBorder(this.etched, "Equipment Info");
        sTitle.setTitleJustification(2);
        sScroll.setBorder(sTitle);
        this.infoLabel.setBackground(this.topPane.getBackground());
        sScroll.setViewportView(this.infoLabel);
        bLeftPane.add(wPanel);
        bLeftPane.add(sScroll);
        Utility.buildConstraints(c, 0, 0, 1, 1, 1.0, 1.0);
        c.fill = 2;
        c.anchor = 17;
        JPanel ePanel = new JPanel();
        gridbag.setConstraints(ePanel, c);
        ePanel.add(this.calcLabel);
        ePanel.add(this.calcComboBox);
        Utility.buildConstraints(c, 0, 1, 1, 1, 1.0, 1.0);
        c.fill = 2;
        c.anchor = 17;
        JPanel iPanel = new JPanel();
        gridbag.setConstraints(iPanel, c);
        this.viewEqSetButton = new JButton("View in Browser");
        Utility.setDescription(this.viewEqSetButton, "Launches a browser and displays Equipment Sets");
        this.viewEqSetButton.setEnabled(true);
        iPanel.add(this.viewEqSetButton);
        this.exportEqSetButton = new JButton("Export to File");
        Utility.setDescription(this.exportEqSetButton, "Export Equipment Sets to a File");
        this.exportEqSetButton.setEnabled(true);
        iPanel.add(this.exportEqSetButton);
        Utility.buildConstraints(c, 0, 2, 1, 1, 1.0, 1.0);
        c.fill = 2;
        c.anchor = 17;
        JPanel iiPanel = new JPanel();
        gridbag.setConstraints(iiPanel, c);
        this.templateTextField.setEditable(false);
        Utility.setDescription(this.templateTextField, "Display only");
        this.templateTextField.setBackground(Color.lightGray);
        this.templateTextField.setText(SettingsHandler.getSelectedEqSetTemplateName());
        this.selectTemplateButton = new JButton("Select template");
        Utility.setDescription(this.selectTemplateButton, "Select an EquipSet output template");
        iiPanel.add(this.selectTemplateButton);
        iiPanel.add(this.templateTextField);
        bRightPane.add(ePanel);
        bRightPane.add(iPanel);
        bRightPane.add(iiPanel);
        this.bsplit = new FlippingSplitPane(0, this.topPane, this.botPane);
        this.bsplit.setOneTouchExpandable(true);
        this.bsplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bsplit, "Center");
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                InfoEquipping.this.refresh();
            }
        });
        this.availableSort = new JTreeTableSorter(this.availableTable, (MyPONode)this.availableModel.getRoot(), this.availableModel);
        this.selectedSort = new JTreeTableSorter(this.selectedTable, (MyPONode)this.selectedModel.getRoot(), this.selectedModel);
    }

    private final List locationChoices(Equipment eqI, List containers) {
        EquipSet eqSet;
        Race race;
        int hands = 0;
        if (this.pc != null && (race = this.pc.getRace()) != null) {
            hands = race.getHands();
        }
        List<String> aList = new ArrayList<String>();
        if (eqI.isWeapon()) {
            if (eqI.isUnarmed()) {
                aList.add("Unarmed");
            } else if (eqI.isShield()) {
                aList.add("Shield");
            } else if (!eqI.isMelee() || !Globals.isWeaponOutsizedForPC(this.pc, eqI)) {
                String wpSingle = eqI.profName(1, this.pc);
                WeaponProf wp = Globals.getWeaponProfNamed(wpSingle);
                if (Globals.handsRequired(this.pc, eqI, wp) == 1) {
                    aList = InfoEquipping.getWeaponLocationChoices(hands, "Both Hands");
                    if (eqI.isMelee() && eqI.isDouble()) {
                        aList.add("Double Weapon");
                    }
                } else {
                    aList.add("Both Hands");
                    if (eqI.isMelee() && eqI.isDouble()) {
                        aList.add("Double Weapon");
                    }
                }
            }
        } else {
            String locName = this.getSingleLocation(eqI);
            if (locName.length() != 0) {
                aList.add(locName);
            } else {
                aList.add("Equipped");
            }
        }
        if (!eqI.isUnarmed()) {
            aList.add("Carried");
            aList.add("Not Carried");
        }
        if (containers != null && (eqSet = this.getCurrentEquipSet()) != null) {
            String idPath = eqSet.getIdPath();
            for (int iSet = 0; iSet < this.pc.getEquipSet().size(); ++iSet) {
                String abID;
                EquipSet es = (EquipSet)this.pc.getEquipSet().get(iSet);
                String esID = es.getParentIdPath() + ".";
                if (!esID.startsWith(abID = idPath + ".") || es.getItem() == null || !es.getItem().isContainer()) continue;
                containers.add(new EqSetWrapper(es));
            }
        }
        return aList;
    }

    private void exportEqSetButton() {
        String template = SettingsHandler.getSelectedEqSetTemplate();
        if (template == null || template.length() == 0) {
            ShowMessageDelegate.showMessageDialog("An equip-set template must be selected before the equip-set can be exported.", "PCGen", MessageType.ERROR);
            return;
        }
        String ext = template.substring(template.lastIndexOf(46));
        JFileChooser fcExport = new JFileChooser();
        fcExport.setCurrentDirectory(SettingsHandler.getPcgPath());
        fcExport.setDialogTitle("Export EquipSet " + this.pc.getDisplayName());
        if (fcExport.showSaveDialog(this) != 0) {
            return;
        }
        String aFileName = fcExport.getSelectedFile().getAbsolutePath();
        if (aFileName.length() < 1) {
            ShowMessageDelegate.showMessageDialog("You must set a filename.", "PCGen", MessageType.ERROR);
            return;
        }
        try {
            int reallyClose;
            File outFile = new File(aFileName);
            if (outFile.isDirectory()) {
                ShowMessageDelegate.showMessageDialog("You cannot overwrite a directory with a file.", "PCGen", MessageType.ERROR);
                return;
            }
            if (outFile.exists() && (reallyClose = JOptionPane.showConfirmDialog(this, "The file " + outFile.getName() + " already exists, are you sure you want to overwrite it?", "Confirm overwriting " + outFile.getName(), 0)) != 0) {
                return;
            }
            if (ext.equalsIgnoreCase(".htm") || ext.equalsIgnoreCase(".html")) {
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
                this.eqSetPrintToWriter(w, template);
                w.flush();
                w.close();
            } else if (ext.equalsIgnoreCase(".fo") || ext.equalsIgnoreCase(".pdf")) {
                File tmpFile = File.createTempFile("equipSet_", ".fo");
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), "UTF-8"));
                this.eqSetPrintToWriter(w, template);
                w.flush();
                w.close();
                FOPHandler fh = new FOPHandler();
                fh.setMode(0);
                fh.setInputFile(tmpFile);
                fh.setOutputFile(outFile);
                fh.run();
                tmpFile.deleteOnExit();
                String errMessage = fh.getErrorMessage();
                if (errMessage.length() > 0) {
                    ShowMessageDelegate.showMessageDialog(errMessage, "PCGen", MessageType.ERROR);
                }
            }
        }
        catch (IOException ex) {
            ShowMessageDelegate.showMessageDialog("Could not export " + this.pc.getDisplayName() + ". Try another filename", "PCGen", MessageType.ERROR);
            Logging.errorPrint("Could not export " + this.pc.getDisplayName(), ex);
        }
    }

    private void refreshButton() {
        this.forceRefresh();
    }

    private void renameEquipSetButton() {
        EquipSet eSet = this.getCurrentEquipSet();
        if (eSet == null) {
            ShowMessageDelegate.showMessageDialog("First select an Equip Set to duplicate.", "PCGen", MessageType.ERROR);
            return;
        }
        String oldName = eSet.getName();
        String newName = JOptionPane.showInputDialog(null, "Enter new name for Equip Set", "PCGen", 3);
        if (newName.equals(oldName)) {
            return;
        }
        if (newName != null && newName.length() > 0) {
            EquipSet pcSet = this.pc.getEquipSetByName(newName);
            if (pcSet != null) {
                ShowMessageDelegate.showMessageDialog("An EquipSet all ready exists with that name.", "PCGen", MessageType.ERROR);
                return;
            }
            eSet.setName(newName);
            this.selectedEquipSet = newName;
            this.pc.setDirty(true);
            this.calcComboBoxFill();
            this.updateSelectedModel();
        }
    }

    private void selectTemplateButton() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Find and select your EquipSet template");
        fc.setCurrentDirectory(SettingsHandler.getPcgenOutputSheetDir());
        fc.setSelectedFile(new File(SettingsHandler.getSelectedEqSetTemplate()));
        if (fc.showOpenDialog(this) == 0) {
            SettingsHandler.setSelectedEqSetTemplate(fc.getSelectedFile().getAbsolutePath());
            this.templateTextField.setText(SettingsHandler.getSelectedEqSetTemplateName());
        }
    }

    private void sellEquipButton(Float newQty) {
        String selectedValue;
        if (newQty.floatValue() <= 0.0f && (selectedValue = JOptionPane.showInputDialog(null, "Enter Quantity to Sell", "PCGen", 3)) != null) {
            try {
                newQty = new Float(selectedValue.trim());
            }
            catch (Exception e) {
                ShowMessageDelegate.showMessageDialog("Invalid number!", "PCGen", MessageType.ERROR);
                return;
            }
        }
        TreePath[] avaCPaths = this.availableTable.getTree().getSelectionPaths();
        for (int index = 0; index < avaCPaths.length; ++index) {
            Object aComp = avaCPaths[index].getLastPathComponent();
            MyPONode fNode = (MyPONode)aComp;
            if (!(fNode.getItem() instanceof Equipment)) {
                return;
            }
            Equipment eq = (Equipment)fNode.getItem();
            PCGen_Frame1.getCharacterPane().infoInventory().getInfoGear().sellSpecifiedEquipment(eq, newQty.doubleValue());
            this.forceRefresh();
        }
    }

    private void updateAvailableModel() {
        List pathList = this.availableTable.getExpandedPaths();
        this.createAvailableModel();
        this.availableTable.updateUI();
        this.availableTable.expandPathList(pathList);
    }

    private void updateSelectedModel() {
        List pathList = this.selectedTable.getExpandedPaths();
        TreePath modelSelPath = this.selectedTable.getTree().getSelectionPath();
        int idx = this.selectedTable.getTree().getRowForPath(modelSelPath);
        this.createSelectedModel();
        this.selectedTable.updateUI();
        this.selectedTable.expandPathList(pathList);
        this.selectedTable.getTree().setSelectionPath(modelSelPath);
        this.selectedTable.getTree().expandPath(modelSelPath);
        int count = this.selectedTable.getTree().getRowCount();
        if (idx >= 0 && idx < count) {
            this.setTableSelectedIndex(this.selectedTable, idx);
        }
    }

    private void updateTotalWeight() {
        if (this.pc == null) {
            return;
        }
        this.pc.setCalcEquipmentList();
        Float weight = this.pc.totalWeight();
        Float roundedValue = new Float(new Float(Math.round(weight.doubleValue() * 10000.0)).floatValue() / 10000.0f);
        this.totalWeight.setText(roundedValue.toString() + " " + Globals.getWeightUnit());
        this.loadWeight.setText(loadTypes[Globals.loadTypeForLoadScore(this.pc.getVariableValue("LOADSCORE", "").intValue(), weight, this.pc)]);
    }

    private void viewComboBoxActionPerformed() {
        int index = this.viewComboBox.getSelectedIndex();
        if (index != this.viewMode) {
            this.viewMode = index;
            SettingsHandler.setEquipTab_AvailableListMode(this.viewMode);
            this.updateAvailableModel();
        }
    }

    private void viewEqSetButton() {
        String template = SettingsHandler.getSelectedEqSetTemplate();
        if (template == null || template.length() == 0) {
            ShowMessageDelegate.showMessageDialog("An equip-set template must be selected before the equip-set can be viewed.", "PCGen", MessageType.ERROR);
            return;
        }
        File outFile = Utility.getTempPreviewFile();
        if (outFile == null) {
            return;
        }
        try {
            BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
            this.eqSetPrintToWriter(w, template);
            w.flush();
            w.close();
            URL url = outFile.toURL();
            Utility.viewInBrowser(url.toString());
        }
        catch (Exception ex) {
            Logging.errorPrint("Could not preview file in external browser.", ex);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class MyPONode
    extends PObjectNode {
        private MyPONode() {
        }

        private MyPONode(Object anItem) {
            super(anItem);
        }

        public String toString() {
            Object item = super.getItem();
            if (item == null) {
                return "";
            }
            if (item instanceof EquipSet) {
                EquipSet eSet = (EquipSet)item;
                Equipment eqI = eSet.getItem();
                if (eSet == null) {
                    return "";
                }
                if (eqI == null) {
                    StringBuffer b = new StringBuffer();
                    b.append("B|");
                    b.append(eSet.toString());
                    return b.toString();
                }
                if (eqI != null) {
                    return eqI.piString();
                }
                return eSet.toString();
            }
            if (item instanceof Equipment) {
                Equipment eqI = (Equipment)item;
                if (eqI != null) {
                    return eqI.piString();
                }
            } else {
                return super.toString();
            }
            return "";
        }
    }

    private final class QuantityEditor
    extends JTextField
    implements TableCellEditor {
        private final transient List d_listeners = new ArrayList();
        private transient String d_originalValue = "";

        private QuantityEditor() {
            this.setEditable(true);
            this.setHorizontalAlignment(4);
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ QuantityEditor this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$1.stopCellEditing();
                }
            });
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public Object getCellEditorValue() {
            try {
                return new Float(this.getText());
            }
            catch (NumberFormatException nfe) {
                return new Float(this.d_originalValue);
            }
        }

        public Component getTableCellEditorComponent(JTable jTable, Object obj, boolean isSelected, int row, int column) {
            if (obj instanceof Number && (float)((Number)obj).intValue() == ((Number)obj).floatValue()) {
                this.setText(Integer.toString(((Number)obj).intValue()));
            } else if (obj != null) {
                this.setText(obj.toString());
            } else {
                this.setText("0");
            }
            this.d_originalValue = this.getText();
            jTable.setRowSelectionInterval(row, row);
            jTable.setColumnSelectionInterval(column, column);
            this.setHorizontalAlignment(4);
            this.selectAll();
            return this;
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.add(cellEditorListener);
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.remove(cellEditorListener);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            InfoEquipping.this.setQtyButton((Float)this.getCellEditorValue());
            return true;
        }

        private void fireEditingCanceled() {
            this.setText(this.d_originalValue);
            ChangeEvent ce = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                ((CellEditorListener)this.d_listeners.get(i)).editingCanceled(ce);
            }
        }

        private void fireEditingStopped() {
            ChangeEvent ce = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                ((CellEditorListener)this.d_listeners.get(i)).editingStopped(ce);
            }
        }
    }

    private class EquipPopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = 6988134124127535195L;

        EquipPopupMenu(JTreeTable treeTable) {
            if (treeTable == InfoEquipping.this.availableTable) {
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_ieAddItem2"), "shortcut EQUALS"));
                this.add(this.createAddNumMenuItem(PropertyFactory.getString("in_ieAddItem")));
                this.add(this.createAddAllMenuItem(PropertyFactory.getString("in_ieAddAllItem")));
                this.addSeparator();
                this.add(this.createBuyMenuItem("Buy 1"));
                this.add(this.createBuyNumMenuItem("Buy #"));
                this.add(this.createSellMenuItem("Sell 1"));
                this.add(this.createSellNumMenuItem("Sell #"));
                this.addSeparator();
                this.add(this.createRefreshMenuItem("Redraw/recalc Panel"));
            } else {
                this.add(this.createDelMenuItem(PropertyFactory.getString("in_ieRemEq"), "shortcut MINUS"));
                this.add(this.createSetQtyMenuItem(PropertyFactory.getString("in_ieSetQt")));
                this.add(this.createSetLocationMenuItem(PropertyFactory.getString("in_ieChangeLoc")));
                this.add(this.createSetNoteMenuItem(PropertyFactory.getString("in_ieSetNote")));
                this.addSeparator();
                this.add(this.createCopyEquipSetMenuItem(PropertyFactory.getString("in_ieCopyEq")));
                this.add(this.createRenameEquipSetMenuItem(PropertyFactory.getString("in_ieRenameEq")));
                this.addSeparator();
                this.add(this.createRefreshMenuItem("Redraw/recalc Panel"));
            }
        }

        private JMenuItem createAddAllMenuItem(String label) {
            InfoEquipping.this.AddAllMenu = Utility.createMenuItem(label, new AddAllEquipActionListener(), PropertyFactory.getString("in_ieAddAll"), '\u0000', null, PropertyFactory.getString("in_ieAddAllItem"), "", true);
            return InfoEquipping.this.AddAllMenu;
        }

        private JMenuItem createAddMenuItem(String label, String accelerator) {
            InfoEquipping.this.AddMenu = Utility.createMenuItem(label, new AddEquipActionListener(), PropertyFactory.getString("in_add") + " 1", '\u0000', accelerator, PropertyFactory.getString("in_ieAddEq"), "", true);
            return InfoEquipping.this.AddMenu;
        }

        private JMenuItem createAddNumMenuItem(String label) {
            InfoEquipping.this.AddNumMenu = Utility.createMenuItem(label, new AddNumEquipActionListener(), PropertyFactory.getString("in_add") + " #", '\u0000', null, PropertyFactory.getString("in_ieAddItem"), "", true);
            return InfoEquipping.this.AddNumMenu;
        }

        private JMenuItem createBuyMenuItem(String label) {
            InfoEquipping.this.BuyMenu = Utility.createMenuItem(label, new BuyEquipActionListener(), "Buy 1", '\u0000', null, "", "", true);
            return InfoEquipping.this.BuyMenu;
        }

        private JMenuItem createBuyNumMenuItem(String label) {
            InfoEquipping.this.BuyNumMenu = Utility.createMenuItem(label, new BuyNumEquipActionListener(), "Buy #", '\u0000', null, "", "", true);
            return InfoEquipping.this.BuyNumMenu;
        }

        private JMenuItem createCopyEquipSetMenuItem(String label) {
            InfoEquipping.this.CopyEquipSetMenu = Utility.createMenuItem(label, new CopyEquipSetActionListener(), PropertyFactory.getString("in_ieCopyEq"), '\u0000', null, PropertyFactory.getString("in_ieDupEq"), "", true);
            return InfoEquipping.this.CopyEquipSetMenu;
        }

        private JMenuItem createDelMenuItem(String label, String accelerator) {
            InfoEquipping.this.DelMenu = Utility.createMenuItem(label, new DelEquipActionListener(), PropertyFactory.getString("in_remove") + " 1", '\u0000', accelerator, PropertyFactory.getString("in_ieRemEq"), "", true);
            return InfoEquipping.this.DelMenu;
        }

        private JMenuItem createRefreshMenuItem(String label) {
            return Utility.createMenuItem(label, new RefreshActionListener(), "Redraw/Recalc Panel", '\u0000', null, "Redraw/Recalc this panels info", "", true);
        }

        private JMenuItem createRenameEquipSetMenuItem(String label) {
            InfoEquipping.this.RenameEquipSetMenu = Utility.createMenuItem(label, new RenameEquipSetActionListener(), PropertyFactory.getString("in_ieRenameEq"), '\u0000', null, PropertyFactory.getString("in_ieRenameEqThis"), "", true);
            return InfoEquipping.this.RenameEquipSetMenu;
        }

        private JMenuItem createSellMenuItem(String label) {
            InfoEquipping.this.SellMenu = Utility.createMenuItem(label, new SellEquipActionListener(), "Sell 1", '\u0000', null, "", "", true);
            return InfoEquipping.this.SellMenu;
        }

        private JMenuItem createSellNumMenuItem(String label) {
            InfoEquipping.this.SellNumMenu = Utility.createMenuItem(label, new SellNumEquipActionListener(), "Sell #", '\u0000', null, "", "", true);
            return InfoEquipping.this.SellNumMenu;
        }

        private JMenuItem createSetLocationMenuItem(String label) {
            InfoEquipping.this.SetLocationMenu = Utility.createMenuItem(label, new SetLocationActionListener(), PropertyFactory.getString("in_ieChangeLoc"), '\u0000', null, PropertyFactory.getString("in_ieChangeLoc"), "", true);
            return InfoEquipping.this.SetLocationMenu;
        }

        private JMenuItem createSetNoteMenuItem(String label) {
            InfoEquipping.this.SetNoteMenu = Utility.createMenuItem(label, new SetNoteActionListener(), PropertyFactory.getString("in_ieSetNote"), '\u0000', null, PropertyFactory.getString("in_ieSetNotefull"), "", true);
            return InfoEquipping.this.SetNoteMenu;
        }

        private JMenuItem createSetQtyMenuItem(String label) {
            InfoEquipping.this.SetQtyMenu = Utility.createMenuItem(label, new SetQtyActionListener(), PropertyFactory.getString("in_ieSetQt"), '\u0000', null, PropertyFactory.getString("in_ieSetQtfull"), "", true);
            return InfoEquipping.this.SetQtyMenu;
        }

        private class SetQtyActionListener
        extends EquipActionListener {
            private SetQtyActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.setQtyButton(new Float(0.0f));
            }
        }

        private class SetNoteActionListener
        extends EquipActionListener {
            private SetNoteActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.setNoteButton();
            }
        }

        private class SetLocationActionListener
        extends EquipActionListener {
            private SetLocationActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.setLocationButton();
            }
        }

        private class SellNumEquipActionListener
        extends EquipActionListener {
            private SellNumEquipActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.sellEquipButton(new Float(-1.0f));
            }
        }

        private class SellEquipActionListener
        extends EquipActionListener {
            private SellEquipActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.sellEquipButton(new Float(1.0f));
            }
        }

        private class RenameEquipSetActionListener
        extends EquipActionListener {
            private RenameEquipSetActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.renameEquipSetButton();
            }
        }

        private class RefreshActionListener
        extends EquipActionListener {
            private RefreshActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.refreshButton();
            }
        }

        private class EquipActionListener
        implements ActionListener {
            private EquipActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
            }
        }

        private class DelEquipActionListener
        extends EquipActionListener {
            private DelEquipActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.delEquipButton();
            }
        }

        private class CopyEquipSetActionListener
        extends EquipActionListener {
            private CopyEquipSetActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.copyEquipSetButton();
            }
        }

        private class BuyNumEquipActionListener
        extends EquipActionListener {
            private BuyNumEquipActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.buyEquipButton(new Float(-1.0f));
            }
        }

        private class BuyEquipActionListener
        extends EquipActionListener {
            private BuyEquipActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.buyEquipButton(new Float(1.0f));
            }
        }

        private class AddNumEquipActionListener
        extends EquipActionListener {
            private AddNumEquipActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.addNumEquipButton();
            }
        }

        private class AddEquipActionListener
        extends EquipActionListener {
            private AddEquipActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.addEquipButton(new Float(1.0f));
            }
        }

        private class AddAllEquipActionListener
        extends EquipActionListener {
            private AddAllEquipActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoEquipping.this.addAllEquipButton();
            }
        }
    }

    private class EquipPopupListener
    extends MouseAdapter {
        private EquipPopupMenu menu;
        private JTree tree;

        EquipPopupListener(JTreeTable treeTable, EquipPopupMenu aMenu) {
            this.tree = treeTable.getTree();
            this.menu = aMenu;
            KeyListener myKeyListener = new KeyListener(this){
                private final /* synthetic */ EquipPopupListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTyped(KeyEvent e) {
                    EquipPopupListener.access$5800(this.this$1).dispatchEvent(e);
                }

                public void keyPressed(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    if (keyCode != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                        for (int i = 0; i < EquipPopupListener.access$5900(this.this$1).getComponentCount(); ++i) {
                            KeyStroke ks;
                            Component menuComponent = EquipPopupListener.access$5900(this.this$1).getComponent(i);
                            if (!(menuComponent instanceof JMenuItem) || (ks = ((JMenuItem)menuComponent).getAccelerator()) == null || !keyStroke.equals(ks)) continue;
                            InfoEquipping.access$6002(EquipPopupListener.access$5800(this.this$1), EquipPopupListener.access$6100(this.this$1).getSelectionPath());
                            ((JMenuItem)menuComponent).doClick(2);
                            return;
                        }
                    }
                    EquipPopupListener.access$5800(this.this$1).dispatchEvent(e);
                }

                public void keyReleased(KeyEvent e) {
                    EquipPopupListener.access$5800(this.this$1).dispatchEvent(e);
                }
            };
            treeTable.addKeyListener(myKeyListener);
        }

        public void mousePressed(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        private void maybeShowPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                InfoEquipping.this.selPath = this.tree.getClosestPathForLocation(evt.getX(), evt.getY());
                if (InfoEquipping.this.selPath == null) {
                    return;
                }
                if (this.tree.isSelectionEmpty()) {
                    this.tree.setSelectionPath(InfoEquipping.this.selPath);
                    this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                } else if (!this.tree.isPathSelected(InfoEquipping.this.selPath)) {
                    this.tree.setSelectionPath(InfoEquipping.this.selPath);
                    this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                } else {
                    this.tree.addSelectionPath(InfoEquipping.this.selPath);
                    this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        }

        static /* synthetic */ InfoEquipping access$5800(EquipPopupListener x0) {
            return x0.InfoEquipping.this;
        }

        static /* synthetic */ EquipPopupMenu access$5900(EquipPopupListener x0) {
            return x0.menu;
        }

        static /* synthetic */ JTree access$6100(EquipPopupListener x0) {
            return x0.tree;
        }
    }

    private final class EquipModel
    extends AbstractTreeTableModel {
        private String[] avaNameList = new String[]{"Name", "Type", "Qty", "Weight", "Cost"};
        private String[] selNameList = new String[]{"Item", "Type", "Qty", "Location", "Temp Bonus"};
        private int modelType = 0;
        private MyPONode avaRoot;
        private MyPONode selRoot;

        private EquipModel(int mode, int model) {
            super(null);
            this.modelType = model;
            this.resetModel(mode, model);
        }

        public boolean isCellEditable(Object node, int column) {
            EquipSet eSet;
            MyPONode fn;
            if ((column = this.adjustAvailColumnConst(column)) == 0) {
                return true;
            }
            if (this.modelType == 1 && column == 4) {
                return true;
            }
            return column == 2 ? (fn = (MyPONode)node) != null && fn.getItem() instanceof EquipSet && (eSet = (EquipSet)fn.getItem()).getItem() != null : column == 6 && (fn = (MyPONode)node) != null && fn.getItem() instanceof EquipSet && (eSet = (EquipSet)fn.getItem()).getItem() == null;
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return class$pcgen$gui$utils$TreeTableModel == null ? (class$pcgen$gui$utils$TreeTableModel = InfoEquipping.class$("pcgen.gui.utils.TreeTableModel")) : class$pcgen$gui$utils$TreeTableModel;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
                default: {
                    Logging.errorPrint("In InfoEquipping.getColumnClass the column " + column + " is not supported.");
                }
            }
            return class$java$lang$String == null ? (class$java$lang$String = InfoEquipping.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            return this.modelType == 0 ? this.avaNameList.length : this.selNameList.length;
        }

        public String getColumnName(int column) {
            return this.modelType == 0 ? this.avaNameList[column] : this.selNameList[column];
        }

        public Object getRoot() {
            return (MyPONode)super.getRoot();
        }

        public void setValueAt(Object value, Object node, int column) {
            if (InfoEquipping.this.pc == null || this.modelType != 1) {
                return;
            }
            MyPONode fn = (MyPONode)node;
            if (!(fn.getItem() instanceof EquipSet)) {
                return;
            }
            EquipSet eSet = (EquipSet)fn.getItem();
            if (eSet == null) {
                return;
            }
            column = this.adjustAvailColumnConst(column);
            switch (column) {
                case 6: {
                    int i = (Integer)value;
                    if (i == 0) {
                        eSet.setUseTempMods(false);
                        eSet.clearTempBonusList();
                        break;
                    }
                    if (i == 1) {
                        eSet.setUseTempMods(true);
                        eSet.clearTempBonusList();
                        InfoEquipping.this.chooseTempBonuses(eSet);
                        break;
                    }
                    eSet.setUseTempMods(true);
                    eSet.clearTempBonusList();
                    break;
                }
            }
        }

        public Object getValueAt(Object node, int column) {
            MyPONode fn = (MyPONode)node;
            EquipSet eSet = null;
            Equipment eqI = null;
            if (fn == null) {
                Logging.errorPrint("Somehow we have no active node when doing getValueAt in InfoEquipping.");
                return null;
            }
            column = this.adjustAvailColumnConst(column);
            if (fn.getItem() instanceof Equipment) {
                eqI = (Equipment)fn.getItem();
            }
            if (fn.getItem() instanceof EquipSet) {
                eSet = (EquipSet)fn.getItem();
                eqI = eSet.getItem();
            }
            switch (column) {
                case 0: {
                    return fn != null ? fn.toString() : null;
                }
                case 1: {
                    if (eqI != null) {
                        StringTokenizer aTok;
                        String type = InfoEquipping.getEqTypeName(eqI);
                        if ("".equals(type) && (aTok = new StringTokenizer(eqI.getType(), ".", false)).hasMoreTokens()) {
                            type = aTok.nextToken();
                        }
                        if (eqI.isContainer() && this.modelType == 1) {
                            StringBuffer b = new StringBuffer();
                            b.append("B|");
                            b.append(type);
                            return b.toString();
                        }
                        return type;
                    }
                    return null;
                }
                case 2: {
                    if (eSet != null && eSet.getValue().length() > 0) {
                        return BigDecimalHelper.trimZeros(eSet.getQty().toString());
                    }
                    if (eqI != null) {
                        if (InfoEquipping.this.viewMode == 2 && fn.getParent().getNodeName() != null) {
                            String nodeName = fn.getParent().getNodeName();
                            if (nodeName.equals(nameAdded)) {
                                return InfoEquipping.this.equipAddMap.get(eqI.getName());
                            }
                            return InfoEquipping.this.equipNotMap.get(eqI.getName());
                        }
                        return BigDecimalHelper.trimZeros(eqI.getQty().toString());
                    }
                    return null;
                }
                case 3: {
                    StringBuffer b = new StringBuffer();
                    if (eSet != null && eqI != null) {
                        StringTokenizer aTok = new StringTokenizer(eSet.getIdPath(), ".", false);
                        if (aTok.countTokens() > 3) {
                            b.append("I|");
                            b.append(eSet.toString());
                        } else {
                            b.append(eSet.toString());
                        }
                        if (eSet.getNote().length() > 0) {
                            b.append(" [");
                            b.append(eSet.getNote());
                            b.append("]");
                        }
                        return b.toString();
                    }
                    if (eSet != null) {
                        b.append(" (");
                        b.append(InfoEquipping.this.pc.getEquipSetWeight(eSet.getIdPath()));
                        b.append(" ");
                        b.append(Globals.getWeightUnit());
                        b.append(")");
                        return b.toString();
                    }
                    return fn != null ? fn.toString() : null;
                }
                case 5: {
                    return eqI != null ? BigDecimalHelper.trimZeros(eqI.getWeight(InfoEquipping.this.pc).toString()) : null;
                }
                case 4: {
                    return eqI != null ? BigDecimalHelper.trimZeros(eqI.getCost(InfoEquipping.this.pc).toString()) : null;
                }
                case 6: {
                    if (eqI == null && eSet != null) {
                        if (eSet.getUseTempMods()) {
                            if (eSet.useTempBonusList()) {
                                return "Selected";
                            }
                            return "Yes";
                        }
                        return "No";
                    }
                    return null;
                }
            }
            if (fn != null) {
                return fn.toString();
            }
            Logging.errorPrint("Somehow we have no active node when doing getValueAt in InfoEquip");
            return null;
        }

        private void setRoot(MyPONode aNode) {
            super.setRoot(aNode);
        }

        private int adjustAvailColumnConst(int column) {
            if (this.modelType == 0 && column == 3) {
                return 5;
            }
            if (this.modelType == 1 && column == 4) {
                return 6;
            }
            return column;
        }

        private void resetModel(int mode, int model) {
            block26: {
                block25: {
                    EquipSet cES;
                    ArrayList<String> typeList = new ArrayList<String>();
                    ArrayList<String> locList = new ArrayList<String>();
                    typeList.add("CUSTOM");
                    Iterator iSet = InfoEquipping.this.pc.getEquipmentMasterList().iterator();
                    while (iSet.hasNext()) {
                        Equipment bEq = (Equipment)iSet.next();
                        StringTokenizer aTok = new StringTokenizer(bEq.getType(), ".", false);
                        while (aTok.hasMoreTokens()) {
                            String aString = aTok.nextToken();
                            if (typeList.contains(aString)) continue;
                            typeList.add(aString);
                        }
                    }
                    Iterator eI = SystemCollections.getUnmodifiableEquipSlotList().iterator();
                    while (eI.hasNext()) {
                        EquipSlot eSlot = (EquipSlot)eI.next();
                        String aString = eSlot.getSlotName();
                        if (locList.contains(aString) || aString.length() <= 0) continue;
                        locList.add(aString);
                    }
                    locList.add("Other");
                    Collections.sort(typeList);
                    Collections.sort(locList);
                    if (InfoEquipping.this.pc.getEquipSet().size() == 0) {
                        String id = InfoEquipping.this.getNewIdPath(null);
                        EquipSet eSet = new EquipSet(id, defaultEquipSet);
                        InfoEquipping.this.pc.addEquipSet(eSet);
                        InfoEquipping.this.selectedEquipSet = defaultEquipSet;
                    }
                    if ("".equals(InfoEquipping.this.selectedEquipSet) && (cES = InfoEquipping.this.pc.getEquipSetByIdPath(InfoEquipping.this.pc.getCalcEquipSetId())) != null) {
                        InfoEquipping.this.selectedEquipSet = cES.getName();
                        InfoEquipping.this.equipSetTextField.setText(InfoEquipping.this.selectedEquipSet);
                    }
                    if (model != 0) break block25;
                    this.avaRoot = new MyPONode();
                    switch (mode) {
                        case 3: {
                            this.setRoot(this.avaRoot);
                            PObjectNode[] eq = new MyPONode[typeList.size()];
                            for (int iType = 0; iType < typeList.size(); ++iType) {
                                String aType = (String)typeList.get(iType);
                                eq[iType] = new MyPONode(aType);
                                Iterator fI = InfoEquipping.this.pc.getEquipmentMasterList().iterator();
                                while (fI.hasNext()) {
                                    Equipment aEq = (Equipment)fI.next();
                                    if (!aEq.isType(aType)) continue;
                                    MyPONode aFN = new MyPONode(aEq);
                                    aFN.setParent(eq[iType]);
                                    eq[iType].addChild(aFN);
                                }
                                if (eq[iType].isLeaf()) continue;
                                eq[iType].setParent(this.avaRoot);
                            }
                            this.avaRoot.setChildren(eq);
                            break;
                        }
                        case 1: {
                            this.setRoot(this.avaRoot);
                            PObjectNode[] loc = new MyPONode[locList.size()];
                            for (int iLoc = 0; iLoc < locList.size(); ++iLoc) {
                                String aLoc = (String)locList.get(iLoc);
                                loc[iLoc] = new MyPONode(aLoc);
                                Iterator fI = InfoEquipping.this.pc.getEquipmentMasterList().iterator();
                                while (fI.hasNext()) {
                                    Equipment aEq = (Equipment)fI.next();
                                    String aString = InfoEquipping.this.getSingleLocation(aEq);
                                    if (aEq.isShield()) {
                                        aString = "Shield";
                                    } else if (aEq.isWeapon()) {
                                        aString = "Weapon";
                                    } else if (aEq.isType("RING")) {
                                        aString = "Fingers";
                                    }
                                    if (aString.length() == 0) {
                                        aString = "Other";
                                    }
                                    if (!aLoc.equals(aString)) continue;
                                    MyPONode aFN = new MyPONode(aEq);
                                    aFN.setParent(loc[iLoc]);
                                    loc[iLoc].addChild(aFN);
                                }
                                if (loc[iLoc].isLeaf()) continue;
                                loc[iLoc].setParent(this.avaRoot);
                            }
                            this.avaRoot.setChildren(loc);
                            break;
                        }
                        case 0: {
                            this.setRoot(this.avaRoot);
                            Iterator fI = InfoEquipping.this.pc.getEquipmentMasterList().iterator();
                            while (fI.hasNext()) {
                                Equipment aEq = (Equipment)fI.next();
                                MyPONode aFN = new MyPONode(aEq);
                                aFN.setParent(this.avaRoot);
                                this.avaRoot.addChild(aFN, true);
                            }
                            break block26;
                        }
                        case 2: {
                            this.setRoot(this.avaRoot);
                            String esN = InfoEquipping.this.equipSetTextField.getText();
                            EquipSet pSet = InfoEquipping.this.pc.getEquipSetByName(esN);
                            if (pSet == null) break;
                            List eqList = InfoEquipping.this.pc.getEquipSet();
                            String pId = pSet.getIdPath();
                            PObjectNode[] add = new MyPONode[]{new MyPONode(nameAdded), new MyPONode(nameNotAdded)};
                            InfoEquipping.this.equipAddMap.clear();
                            InfoEquipping.this.equipNotMap.clear();
                            Iterator fI = InfoEquipping.this.pc.getEquipmentMasterList().iterator();
                            while (fI.hasNext()) {
                                MyPONode aFN;
                                Equipment aEq = (Equipment)fI.next();
                                String eqName = aEq.getName();
                                Float countAdd = InfoEquipping.this.pc.getEquipSetCount(pId, eqName);
                                Float countNot = new Float(aEq.getQty().floatValue() - countAdd.floatValue());
                                if (countAdd.floatValue() > 0.0f) {
                                    aFN = new MyPONode(aEq);
                                    aFN.setParent(add[0]);
                                    add[0].addChild(aFN);
                                    add[0].setParent(this.avaRoot);
                                    InfoEquipping.this.equipAddMap.put(eqName, countAdd);
                                }
                                if (!(countNot.floatValue() > 0.0f)) continue;
                                aFN = new MyPONode(aEq);
                                aFN.setParent(add[1]);
                                add[1].addChild(aFN);
                                add[1].setParent(this.avaRoot);
                                InfoEquipping.this.equipNotMap.put(eqName, countNot);
                            }
                            this.avaRoot.setChildren(add);
                            break;
                        }
                        default: {
                            Logging.errorPrint("In InfoEquipping.resetModel the mode " + mode + " is not supported.");
                            break;
                        }
                    }
                    break block26;
                }
                this.selRoot = new MyPONode();
                equipSetList = InfoEquipping.this.pc.getEquipSet();
                Collections.sort(equipSetList);
                tempSetList = (ArrayList)((ArrayList)equipSetList).clone();
                InfoEquipping.this.addEquipTreeNodes(this.selRoot, null);
                this.setRoot(this.selRoot);
            }
            MyPONode rootAsmyPONode = (MyPONode)super.getRoot();
            if (rootAsmyPONode.getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }
    }

    private static final class ColorRenderer
    extends DefaultTableCellRenderer {
        private ColorRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel comp = (JLabel)super.getTableCellRendererComponent(jTable, value, isSelected, hasFocus, row, column);
            if (value instanceof String) {
                Font aFont = comp.getFont();
                String fontName = aFont.getName();
                int iSize = aFont.getSize();
                String aString = comp.getText();
                if (aString.indexOf("B|") == 0) {
                    aString = aString.substring(2, aString.length());
                    Font newFont = new Font(fontName, 1, iSize);
                    comp.setFont(newFont);
                } else if (aString.indexOf("I|") == 0) {
                    aString = aString.substring(2, aString.length());
                    Font newFont = new Font(fontName, 2, iSize);
                    comp.setFont(newFont);
                }
                comp.setText(aString);
            }
            return comp;
        }
    }

    private static final class BonusEditor
    extends JComboBoxEx
    implements TableCellEditor {
        private final transient List d_listeners = new ArrayList();
        private transient int d_originalValue = 0;

        private BonusEditor() {
            super(new String[]{"No", "Selected", "Yes"});
            this.setEditable(true);
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ BonusEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$0.stopCellEditing();
                }
            });
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public Object getCellEditorValue() {
            switch (this.getSelectedIndex()) {
                case 0: {
                    return new Integer(0);
                }
                case 1: {
                    return new Integer(1);
                }
                case 2: {
                    return new Integer(2);
                }
            }
            return new Integer(0);
        }

        public Component getTableCellEditorComponent(JTable jTable, Object obj, boolean isSelected, int row, int column) {
            if (obj == null) {
                return this;
            }
            this.d_originalValue = this.getSelectedIndex();
            if (obj instanceof Integer) {
                int i = (Integer)obj;
                if (i == 0) {
                    this.setSelectedItem("No");
                } else if (i == 1) {
                    this.setSelectedItem("Selected");
                } else {
                    this.setSelectedItem("Yes");
                }
            } else {
                this.setSelectedItem("No");
            }
            jTable.setRowSelectionInterval(row, row);
            jTable.setColumnSelectionInterval(column, column);
            return this;
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.add(cellEditorListener);
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.remove(cellEditorListener);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        private void fireEditingCanceled() {
            this.setSelectedIndex(this.d_originalValue);
            ChangeEvent ce = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                ((CellEditorListener)this.d_listeners.get(i)).editingCanceled(ce);
            }
        }

        private void fireEditingStopped() {
            ChangeEvent ce = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                ((CellEditorListener)this.d_listeners.get(i)).editingStopped(ce);
            }
        }
    }

    private static class EqSetWrapper
    implements Serializable {
        private EquipSet eqSet;

        public EqSetWrapper(EquipSet argEqSet) {
            this.eqSet = argEqSet;
        }

        public EquipSet getEqSet() {
            return this.eqSet;
        }

        public String toString() {
            return this.eqSet.getItem().getName();
        }
    }

    public static final class TempWrap {
        private BonusObj _bonus = null;
        private Object _creator = null;
        private Object _target = null;

        public TempWrap(Object aMod, Object aTarget, BonusObj aBonus) {
            this._creator = aMod;
            this._target = aTarget;
            this._bonus = aBonus;
        }

        public BonusObj getBonus() {
            return this._bonus;
        }

        public Object getCreator() {
            return this._creator;
        }

        public Object getTarget() {
            return this._target;
        }

        public String getName() {
            StringBuffer b = new StringBuffer();
            if (this._creator instanceof PlayerCharacter) {
                b.append(((PlayerCharacter)this._creator).getName());
            } else if (this._creator instanceof PObject) {
                b.append(this._creator.toString());
            }
            b.append(" [");
            if (this._target instanceof PlayerCharacter) {
                b.append("Player");
            } else if (this._target instanceof Equipment) {
                b.append(((Equipment)this._target).getName());
            }
            b.append("]");
            return b.toString();
        }

        public String getCreatorName() {
            if (this._creator instanceof PlayerCharacter) {
                return ((PlayerCharacter)this._creator).getName();
            }
            if (this._creator instanceof PObject) {
                return ((PObject)this._creator).getName();
            }
            return "";
        }

        public String getTargetName() {
            if (this._target instanceof PlayerCharacter) {
                return ((PlayerCharacter)this._target).getName();
            }
            if (this._target instanceof PObject) {
                return ((PObject)this._target).getName();
            }
            return "";
        }
    }
}

