/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import pcgen.core.Constants;
import pcgen.core.Feat;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfo;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;

public final class InfoFeats
extends FilterAdapterPanel
implements CharacterInfoTab {
    private static final String NO_QUALIFY_MESSAGE = "You do not meet the prerequisites required to take this feat.";
    private static final String DUPLICATE_MESSAGE = "You already have that feat.";
    private static final String FEAT_FULL_MESSAGE = "You cannot select any more feats.";
    private static boolean needsUpdate = true;
    private static PObjectNode typeRoot = new PObjectNode();
    private static PObjectNode preReqTreeRoot = null;
    private static int splitOrientation = 1;
    private static int viewAvailMode = 0;
    private static int viewSelectMode = 1;
    private static final int HASFEAT_NO = 0;
    private static final int HASFEAT_CHOSEN = 1;
    private static final int HASFEAT_AUTOMATIC = 2;
    private static final int HASFEAT_VIRTUAL = 4;
    static final int FEAT_OK = 0;
    static final int FEAT_DUPLICATE = 1;
    static final int FEAT_NOT_QUALIFIED = 2;
    static final int FEAT_FULL_FEAT = 3;
    private Border etched;
    private FeatModel availableModel = null;
    private FeatModel selectedModel = null;
    private FlippingSplitPane splitBotLeftRight;
    private FlippingSplitPane splitTopBot;
    private FlippingSplitPane splitTopLeftRight;
    private JButton addButton;
    private JButton leftButton;
    private JComboBoxEx viewAvailComboBox = new JComboBoxEx();
    private JComboBoxEx viewSelectComboBox = new JComboBoxEx();
    private JLabelPane infoLabel = new JLabelPane();
    private JMenuItem addMenu;
    private JMenuItem removeMenu;
    private JPanel topPane = new JPanel();
    private JScrollPane infoScroll = new JScrollPane();
    private JTextField numFeatsField = new JTextField();
    private JTreeTable availableTable;
    private JTreeTable selectedTable;
    private JTreeTableSorter availableSort = null;
    private JTreeTableSorter selectedSort = null;
    private TreePath selPath;
    private boolean hasBeenSized = false;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;
    static /* synthetic */ Class class$pcgen$gui$utils$TreeTableModel;
    static /* synthetic */ Class class$java$lang$String;

    public InfoFeats(PlayerCharacter pc) {
        this.pc = pc;
        this.setName(Constants.tabNames[5]);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoFeats.this.initComponents();
                InfoFeats.this.initActionListeners();
            }
        });
    }

    public void setPc(PlayerCharacter pc) {
        if (this.pc != pc || pc.getSerial() > this.serial) {
            this.pc = pc;
            this.serial = pc.getSerial();
            this.forceRefresh();
        }
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Feats.Order", 5);
    }

    public void setTabOrder(int order) {
        SettingsHandler.setPCGenOption(".Panel.Feats.Order", order);
    }

    public String getTabName() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabName(5);
    }

    public boolean isShown() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabShown(5);
    }

    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            PObjectNode.resetPC();
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    public JComponent getView() {
        return this;
    }

    public static void setNeedsUpdate(boolean flag) {
        needsUpdate = flag;
    }

    public boolean isMatchAnyEnabled() {
        return true;
    }

    public boolean isNegateEnabled() {
        return true;
    }

    public int getSelectionMode() {
        return 2;
    }

    public void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
        FilterFactory.registerAllFeatFilters(this);
        this.setKitFilter("FEAT");
    }

    public void refreshFiltering() {
        this.forceRefresh();
    }

    private static int getEventSelectedIndex(ListSelectionEvent e) {
        DefaultListSelectionModel model = (DefaultListSelectionModel)e.getSource();
        if (model == null) {
            return -1;
        }
        return model.getMinSelectionIndex();
    }

    private void setAddEnabled(boolean enabled) {
        this.addButton.setEnabled(enabled);
        this.addMenu.setEnabled(enabled);
    }

    private void setRemoveEnabled(boolean enabled) {
        this.leftButton.setEnabled(enabled);
        this.removeMenu.setEnabled(enabled);
    }

    private void addFeat() {
        String aString = null;
        Object temp = this.availableTable.getTree().getLastSelectedPathComponent();
        if (temp == null) {
            ShowMessageDelegate.showMessageDialog("Somehow, no feat was selected. Try again.", "PCGen", MessageType.ERROR);
            return;
        }
        if (temp instanceof PObjectNode && (temp = ((PObjectNode)temp).getItem()) instanceof Feat) {
            aString = ((Feat)temp).getName();
        }
        int fq = this.checkFeatQualify((Feat)temp);
        switch (fq) {
            case 2: {
                ShowMessageDelegate.showMessageDialog(NO_QUALIFY_MESSAGE, "PCGen", MessageType.INFORMATION);
                return;
            }
            case 1: {
                ShowMessageDelegate.showMessageDialog(DUPLICATE_MESSAGE, "PCGen", MessageType.INFORMATION);
                return;
            }
            case 3: {
                ShowMessageDelegate.showMessageDialog(FEAT_FULL_MESSAGE, "PCGen", MessageType.INFORMATION);
                return;
            }
            case 0: {
                break;
            }
            default: {
                Logging.errorPrint("Feat " + ((Feat)temp).getName() + " is somehow in state " + fq + " which is not handled" + " in InfoFeats.addFeat()");
            }
        }
        try {
            this.pc.setDirty(true);
            this.pc.modFeat(aString, true, false);
        }
        catch (Exception exc) {
            ShowMessageDelegate.showMessageDialog("InfoFeats1: " + exc.getMessage(), "PCGen", MessageType.ERROR);
        }
        CharacterInfo pane = PCGen_Frame1.getCharacterPane();
        pane.setPaneForUpdate(pane.infoSkills());
        pane.setPaneForUpdate(pane.infoInventory());
        pane.setPaneForUpdate(pane.infoSpells());
        pane.setPaneForUpdate(pane.infoSummary());
        pane.refresh();
        this.pc.aggregateFeatList();
        this.updateAvailableModel();
        this.updateSelectedModel();
        this.selectedTable.getColumnModel().getColumn(0).setHeaderValue("Feats (" + this.pc.getUsedFeatCount() + ")");
        this.numFeatsField.setText(String.valueOf(this.pc.getFeats()));
        this.setAddEnabled(false);
        this.pc.calcActiveBonuses();
    }

    private int checkFeatQualify(Feat aFeat) {
        boolean pcHasIt;
        String aString = aFeat.getName();
        boolean bl = pcHasIt = (aFeat = this.pc.getFeatNonAggregateNamed(aString)) != null;
        if (pcHasIt && !aFeat.isMultiples()) {
            return 1;
        }
        if (!(pcHasIt || (aFeat = Globals.getFeatNamed(aString)) == null || PrereqHandler.passesAll(aFeat.getPreReqList(), this.pc, aFeat) || Globals.checkRule("FEATPRE"))) {
            return 2;
        }
        if (aFeat != null && aFeat.getCost(this.pc) > this.pc.getFeats() && !pcHasIt) {
            return 3;
        }
        return 0;
    }

    private void createModelAvailable() {
        if (this.availableModel == null) {
            this.availableModel = new FeatModel(viewAvailMode, true);
        } else {
            this.availableModel.resetModel(InfoFeats.viewAvailMode, true);
        }
        if (this.availableSort != null) {
            this.availableSort.setRoot((PObjectNode)this.availableModel.getRoot());
        }
    }

    private void createModelSelected() {
        if (this.selectedModel == null) {
            this.selectedModel = new FeatModel(viewSelectMode, false);
        } else {
            this.selectedModel.resetModel(InfoFeats.viewSelectMode, false);
        }
        if (this.selectedSort != null) {
            this.selectedSort.setRoot((PObjectNode)this.selectedModel.getRoot());
        }
    }

    private void createModels() {
        this.createModelAvailable();
        this.createModelSelected();
    }

    private void createTreeTables() {
        this.availableTable = new JTreeTable(this.availableModel);
        this.availableTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int idx = InfoFeats.getEventSelectedIndex(e);
                    if (idx < 0) {
                        return;
                    }
                    Object temp = InfoFeats.this.availableTable.getTree().getPathForRow(idx).getLastPathComponent();
                    if (temp == null) {
                        ShowMessageDelegate.showMessageDialog("Somehow, no feat was selected. Try again.", "PCGen", MessageType.ERROR);
                        return;
                    }
                    Feat aFeat = null;
                    if (temp instanceof PObjectNode && (temp = ((PObjectNode)temp).getItem()) instanceof Feat) {
                        aFeat = (Feat)temp;
                    }
                    if (SettingsHandler.isExpertGUI()) {
                        InfoFeats.this.setAddEnabled(aFeat != null && InfoFeats.this.checkFeatQualify(aFeat) == 0);
                    } else {
                        InfoFeats.this.setAddEnabled(aFeat != null);
                    }
                    if (aFeat != null) {
                        String cString;
                        StringBuffer bString = new StringBuffer().append("<html><b>").append(aFeat.piSubString()).append("</b> &nbsp;TYPE:").append(aFeat.getType());
                        if (aFeat.isMultiples()) {
                            bString.append(" &nbsp;Can be taken more than once");
                        }
                        if (aFeat.isStacks()) {
                            bString.append(" &nbsp;Stacks");
                        }
                        if ((cString = aFeat.preReqHTMLStrings(InfoFeats.this.pc, false)).length() > 0) {
                            bString.append(" &nbsp;<b>Requirements</b>:").append(cString);
                        }
                        bString.append(" &nbsp;<b>Description</b>:").append(aFeat.piDescSubString()).append(" &nbsp;<b>Source</b>:").append(aFeat.getSource()).append("</html>");
                        InfoFeats.this.infoLabel.setText(bString.toString());
                    }
                }
            }
        });
        final JTree tree = this.availableTable.getTree();
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setCellRenderer(new LabelTreeCellRenderer());
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = tree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    if (e.getClickCount() == 1 && selPath != null) {
                        tree.setSelectionPath(selPath);
                    } else if (e.getClickCount() == 2) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                InfoFeats.access$1100(3.access$1000(this.this$1));
                            }
                        });
                    }
                }
            }

            static /* synthetic */ InfoFeats access$1000(3 x0) {
                return x0.InfoFeats.this;
            }
        };
        tree.addMouseListener(ml);
        this.selectedTable = new JTreeTable(this.selectedModel);
        final JTree btree = this.selectedTable.getTree();
        btree.setRootVisible(false);
        btree.setShowsRootHandles(true);
        btree.setCellRenderer(new LabelTreeCellRenderer());
        this.selectedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int idx = InfoFeats.getEventSelectedIndex(e);
                    if (idx < 0) {
                        return;
                    }
                    Object temp = btree.getPathForRow(idx).getLastPathComponent();
                    if (temp == null) {
                        return;
                    }
                    boolean removeAllowed = false;
                    Feat aFeat = null;
                    if (temp instanceof PObjectNode && (temp = ((PObjectNode)temp).getItem()) instanceof Feat) {
                        aFeat = (Feat)temp;
                        removeAllowed = aFeat.getFeatType() == 0;
                    }
                    InfoFeats.this.setRemoveEnabled(removeAllowed);
                    if (aFeat != null) {
                        String cString;
                        StringBuffer bString = new StringBuffer().append("<html><b>").append(aFeat.piSubString()).append("</b> &nbsp;TYPE:").append(aFeat.getType());
                        if (aFeat.isMultiples()) {
                            bString.append(" &nbsp;Can be taken more than once");
                        }
                        if (aFeat.isStacks()) {
                            bString.append(" &nbsp;Stacks");
                        }
                        if ((cString = aFeat.preReqHTMLStrings(InfoFeats.this.pc, false)).length() > 0) {
                            bString.append(" &nbsp;<b>Requirements</b>:").append(cString);
                        }
                        bString.append(" &nbsp;<b>Description</b>:").append(aFeat.piDescSubString()).append(" &nbsp;<b>Source</b>:").append(aFeat.getSource()).append("</html>");
                        InfoFeats.this.infoLabel.setText(bString.toString());
                    }
                }
            }
        });
        ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = btree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = btree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    if (e.getClickCount() == 1) {
                        btree.setSelectionPath(selPath);
                    } else if (e.getClickCount() == 2 && InfoFeats.this.leftButton.isEnabled()) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 6 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                InfoFeats.access$1500(6.access$1400(this.this$1));
                            }
                        });
                    }
                }
            }

            static /* synthetic */ InfoFeats access$1400(6 x0) {
                return x0.InfoFeats.this;
            }
        };
        btree.addMouseListener(ml);
        this.hookupPopupMenu(this.availableTable);
        this.hookupPopupMenu(this.selectedTable);
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.getStatusBar().setText("Feats are color coded: Red = Character does not qualify; Yellow = Automatic Feat; Magenta = Virtual Feat");
        this.refresh();
        int s = this.splitTopLeftRight.getDividerLocation();
        int t = this.splitTopBot.getDividerLocation();
        int u = this.splitBotLeftRight.getDividerLocation();
        if (!this.hasBeenSized) {
            int width;
            this.hasBeenSized = true;
            s = SettingsHandler.getPCGenOption("InfoFeats.splitTopLeftRight", (int)(this.getSize().getWidth() * 6.0 / 10.0));
            t = SettingsHandler.getPCGenOption("InfoFeats.splitTopBot", (int)(this.getSize().getHeight() * 75.0 / 100.0));
            u = SettingsHandler.getPCGenOption("InfoFeats.splitBotLeftRight", (int)(this.getSize().getWidth() * 6.0 / 10.0));
            TableColumnModel selectedTableColumnModel = this.selectedTable.getColumnModel();
            for (int i = 0; i < this.selectedTable.getColumnCount(); ++i) {
                TableColumn sCol = selectedTableColumnModel.getColumn(i);
                width = Globals.getCustColumnWidth("FeatSel", i);
                if (width != 0) {
                    sCol.setPreferredWidth(width);
                }
                sCol.addPropertyChangeListener(new ResizeColumnListener(this.selectedTable, "FeatSel", i));
            }
            TableColumnModel availableTableColumnModel = this.availableTable.getColumnModel();
            for (int i = 0; i < this.availableTable.getColumnCount(); ++i) {
                TableColumn aCol = availableTableColumnModel.getColumn(i);
                width = Globals.getCustColumnWidth("FeatAva", i);
                if (width != 0) {
                    aCol.setPreferredWidth(width);
                }
                aCol.addPropertyChangeListener(new ResizeColumnListener(this.availableTable, "FeatAva", i));
            }
        }
        if (s > 0) {
            this.splitTopLeftRight.setDividerLocation(s);
            SettingsHandler.setPCGenOption("InfoFeats.splitTopLeftRight", s);
        }
        if (t > 0) {
            this.splitTopBot.setDividerLocation(t);
            SettingsHandler.setPCGenOption("InfoFeats.splitTopBot", t);
        }
        if (u > 0) {
            this.splitBotLeftRight.setDividerLocation(u);
            SettingsHandler.setPCGenOption("InfoFeats.splitBotLeftRight", u);
        }
    }

    private void hookupPopupMenu(JTreeTable treeTable) {
        treeTable.addMouseListener(new FeatPopupListener(treeTable, new FeatPopupMenu(treeTable)));
    }

    private static int xlatInternalType(int featType) {
        int iRetVal;
        switch (featType) {
            case 1: {
                iRetVal = 0;
                break;
            }
            case 2: {
                iRetVal = 1;
                break;
            }
            case 4: {
                iRetVal = 2;
                break;
            }
            default: {
                iRetVal = -1;
            }
        }
        return iRetVal;
    }

    private void initActionListeners() {
        this.numFeatsField.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                if (InfoFeats.this.numFeatsField.getText().length() > 0) {
                    if (InfoFeats.this.pc != null) {
                        InfoFeats.this.pc.setDirty(true);
                        InfoFeats.this.pc.setFeats(Double.parseDouble(InfoFeats.this.numFeatsField.getText()));
                    }
                } else if (InfoFeats.this.pc != null) {
                    InfoFeats.this.numFeatsField.setText(String.valueOf(InfoFeats.this.pc.getFeats()));
                }
            }
        });
        this.viewAvailComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoFeats.this.viewAvailComboBoxActionPerformed();
            }
        });
        this.viewSelectComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoFeats.this.viewSelectComboBoxActionPerformed();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                InfoFeats.this.formComponentShown();
            }
        });
        this.leftButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoFeats.this.removeFeat();
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoFeats.this.addFeat();
            }
        });
        FilterFactory.restoreFilterSettings(this);
    }

    private void initComponents() {
        this.readyForRefresh = true;
        int iView = SettingsHandler.getFeatTab_AvailableListMode();
        if (iView >= 0 && iView <= 2) {
            viewAvailMode = iView;
        }
        SettingsHandler.setFeatTab_AvailableListMode(viewAvailMode);
        iView = SettingsHandler.getFeatTab_SelectedListMode();
        if (iView >= 0 && iView <= 2) {
            viewSelectMode = iView;
        }
        SettingsHandler.setFeatTab_SelectedListMode(viewSelectMode);
        this.viewAvailComboBox.addItem("Type/Name");
        this.viewAvailComboBox.addItem("Name");
        this.viewAvailComboBox.addItem("Pre-Req Tree");
        Utility.setDescription(this.viewAvailComboBox, "You can change how the feats in the Available and Selected Tables are listed - either by name or in a directory-like structure.");
        this.viewAvailComboBox.setSelectedIndex(viewAvailMode);
        this.viewSelectComboBox.addItem("Type/Name");
        this.viewSelectComboBox.addItem("Name");
        this.viewSelectComboBox.addItem("Pre-Req Tree");
        Utility.setDescription(this.viewSelectComboBox, "You can change how the feats in the Selected Tables are listed - either by name or in a directory-like structure.");
        this.viewSelectComboBox.setSelectedIndex(viewSelectMode);
        ArrayList<String> aList = new ArrayList<String>();
        for (int i = 0; i < Globals.getFeatList().size(); ++i) {
            Feat bFeat = Globals.getFeatListFeat(i);
            if (bFeat.isVisible() != 1 && bFeat.isVisible() != 3) continue;
            StringTokenizer aTok = new StringTokenizer(bFeat.getType(), ".");
            while (aTok.hasMoreTokens()) {
                String aString = aTok.nextToken();
                if (aList.contains(aString)) continue;
                aList.add(aString);
            }
        }
        Collections.sort(aList);
        PObjectNode[] cc = new PObjectNode[aList.size()];
        for (int i = 0; i < aList.size(); ++i) {
            cc[i] = new PObjectNode();
            cc[i].setItem(aList.get(i).toString());
            cc[i].setParent(typeRoot);
        }
        typeRoot.setChildren(cc);
        this.createModels();
        this.createTreeTables();
        this.topPane.setLayout(new BorderLayout());
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel tLeftPane = new JPanel();
        JPanel tRightPane = new JPanel();
        this.splitTopLeftRight = new FlippingSplitPane(splitOrientation, tLeftPane, tRightPane);
        this.splitTopLeftRight.setOneTouchExpandable(true);
        this.splitTopLeftRight.setDividerSize(10);
        this.topPane.add((Component)this.splitTopLeftRight, "Center");
        tLeftPane.setLayout(gridbag);
        Utility.buildConstraints(c, 0, 0, 1, 1, 100.0, 5.0);
        c.fill = 0;
        c.anchor = 10;
        JPanel aPanel = new JPanel();
        gridbag.setConstraints(aPanel, c);
        JLabel avaLabel = new JLabel("Available: ");
        aPanel.add(avaLabel);
        aPanel.add(this.viewAvailComboBox);
        ImageIcon newImage = IconUtilitities.getImageIcon("Forward16.gif");
        this.addButton = new JButton(newImage);
        Utility.setDescription(this.addButton, "Click to add the selected feat from the Available list of feats");
        this.addButton.setEnabled(false);
        aPanel.add(this.addButton);
        tLeftPane.add(aPanel);
        Utility.buildConstraints(c, 0, 2, 1, 1, 0.0, 95.0);
        c.fill = 1;
        c.anchor = 10;
        JScrollPane scrollPane = new JScrollPane(this.availableTable);
        gridbag.setConstraints(scrollPane, c);
        tLeftPane.add(scrollPane);
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        tRightPane.setLayout(gridbag);
        Utility.buildConstraints(c, 0, 0, 1, 1, 100.0, 5.0);
        c.fill = 0;
        c.anchor = 10;
        aPanel = new JPanel();
        gridbag.setConstraints(aPanel, c);
        JLabel selLabel = new JLabel("Selected: ");
        aPanel.add(selLabel);
        aPanel.add(this.viewSelectComboBox);
        newImage = IconUtilitities.getImageIcon("Back16.gif");
        this.leftButton = new JButton(newImage);
        Utility.setDescription(this.leftButton, "Click to remove the selected feat from the Selected list of feats");
        this.leftButton.setEnabled(false);
        aPanel.add(this.leftButton);
        tRightPane.add(aPanel);
        Utility.buildConstraints(c, 0, 1, 1, 1, 0.0, 95.0);
        c.fill = 1;
        c.anchor = 10;
        scrollPane = new JScrollPane(this.selectedTable);
        gridbag.setConstraints(scrollPane, c);
        tRightPane.add(scrollPane);
        JPanel botPane = new JPanel();
        botPane.setLayout(new BorderLayout());
        JPanel bLeftPane = new JPanel();
        JPanel bRightPane = new JPanel();
        this.splitBotLeftRight = new FlippingSplitPane(splitOrientation, bLeftPane, bRightPane);
        this.splitBotLeftRight.setOneTouchExpandable(true);
        this.splitBotLeftRight.setDividerSize(10);
        botPane.add((Component)this.splitBotLeftRight, "Center");
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        bLeftPane.setLayout(gridbag);
        Utility.buildConstraints(c, 0, 0, 1, 1, 1.0, 1.0);
        c.fill = 1;
        c.anchor = 10;
        gridbag.setConstraints(this.infoScroll, c);
        TitledBorder title1 = BorderFactory.createTitledBorder(this.etched, "Feat Info");
        title1.setTitleJustification(2);
        this.infoScroll.setBorder(title1);
        this.infoLabel.setBackground(bLeftPane.getBackground());
        this.infoScroll.setViewportView(this.infoLabel);
        Utility.setDescription(this.infoScroll, "Any requirements you don't meet are in italics.");
        bLeftPane.add(this.infoScroll);
        JPanel cPanel = new JPanel();
        cPanel.setLayout(new FlowLayout());
        cPanel.add(new JLabel("Feats remaining: "));
        if (this.pc != null) {
            this.numFeatsField.setText(String.valueOf(this.pc.getFeats()));
            this.numFeatsField.setColumns(3);
        }
        cPanel.add(this.numFeatsField);
        Utility.setDescription(this.numFeatsField, "How many feats you have left to choose (editable).");
        bRightPane.add(cPanel);
        this.splitTopBot = new FlippingSplitPane(0, this.topPane, botPane);
        this.splitTopBot.setOneTouchExpandable(true);
        this.splitTopBot.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.splitTopBot, "Center");
        this.availableSort = new JTreeTableSorter(this.availableTable, (PObjectNode)this.availableModel.getRoot(), this.availableModel);
        this.selectedSort = new JTreeTableSorter(this.selectedTable, (PObjectNode)this.selectedModel.getRoot(), this.selectedModel);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                InfoFeats.this.refresh();
            }
        });
    }

    private void removeFeat() {
        String aString = null;
        Object temp = this.selectedTable.getTree().getLastSelectedPathComponent();
        if (temp == null) {
            ShowMessageDelegate.showMessageDialog("Somehow, no feat was selected.  Try again.", "PCGen", MessageType.ERROR);
            return;
        }
        if (temp instanceof PObjectNode && (temp = ((PObjectNode)temp).getItem()) instanceof Feat) {
            aString = ((Feat)temp).getName();
        }
        try {
            this.pc.setDirty(true);
            this.pc.modFeat(aString, false, false);
        }
        catch (Exception exc) {
            ShowMessageDelegate.showMessageDialog("InfoFeats2: " + exc.getMessage(), "PCGen", MessageType.ERROR);
        }
        CharacterInfo pane = PCGen_Frame1.getCharacterPane();
        pane.setPaneForUpdate(pane.infoSkills());
        pane.setPaneForUpdate(pane.infoInventory());
        pane.setPaneForUpdate(pane.infoSpells());
        pane.setPaneForUpdate(pane.infoSummary());
        pane.refresh();
        this.pc.aggregateFeatList();
        this.updateAvailableModel();
        this.updateSelectedModel();
        this.selectedTable.getColumnModel().getColumn(0).setHeaderValue("Feats (" + this.pc.getUsedFeatCount() + ")");
        this.numFeatsField.setText(String.valueOf(this.pc.getFeats()));
        this.setRemoveEnabled(false);
    }

    private void updateAvailableModel() {
        List pathList = this.availableTable.getExpandedPaths();
        this.createModelAvailable();
        if (this.availableSort != null) {
            this.availableSort.sortNodeOnColumn();
        }
        this.availableTable.updateUI();
        this.availableTable.expandPathList(pathList);
    }

    private void updateCharacterInfo() {
        PObjectNode.resetPC();
        if (this.pc == null || this.pc.isAggregateFeatsStable() && !needsUpdate) {
            return;
        }
        this.pc.setAggregateFeatsStable(false);
        this.pc.setAutomaticFeatsStable(false);
        this.pc.setVirtualFeatsStable(false);
        this.pc.aggregateFeatList();
        JViewport aPort = this.infoScroll.getColumnHeader();
        if (aPort != null) {
            aPort.setVisible(false);
        }
        this.updateAvailableModel();
        this.updateSelectedModel();
        this.selectedTable.getColumnModel().getColumn(0).setHeaderValue("Feats (" + this.pc.getUsedFeatCount() + ")");
        this.numFeatsField.setText(String.valueOf(this.pc.getFeats()));
        needsUpdate = false;
    }

    private void updateSelectedModel() {
        List pathList = this.selectedTable.getExpandedPaths();
        this.createModelSelected();
        if (this.selectedSort != null) {
            this.selectedSort.sortNodeOnColumn();
        }
        this.selectedTable.updateUI();
        this.selectedTable.expandPathList(pathList);
    }

    private void viewAvailComboBoxActionPerformed() {
        int index = this.viewAvailComboBox.getSelectedIndex();
        if (index != viewAvailMode) {
            viewAvailMode = index;
            SettingsHandler.setFeatTab_AvailableListMode(viewAvailMode);
            this.updateAvailableModel();
        }
    }

    private void viewSelectComboBoxActionPerformed() {
        int index = this.viewSelectComboBox.getSelectedIndex();
        if (index != viewSelectMode) {
            viewSelectMode = index;
            SettingsHandler.setFeatTab_SelectedListMode(viewSelectMode);
            this.updateSelectedModel();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class FeatPopupMenu
    extends JPopupMenu {
        private JMenuItem duplicateMenuItem;
        private JMenuItem featFullMenuItem;
        private JMenuItem noQualifyMenuItem;
        private JTreeTable treeTable;

        private FeatPopupMenu(JTreeTable treeTable) {
            this.treeTable = treeTable;
            if (this.treeTable == InfoFeats.this.availableTable) {
                this.add(InfoFeats.this.addMenu = Utility.createMenuItem("Add Feat", new ActionListener(this){
                    private final /* synthetic */ FeatPopupMenu this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent evt) {
                        InfoFeats.access$1100(FeatPopupMenu.access$3300(this.this$1));
                    }
                }, "infoFeats.addFeat", '\u0000', "shortcut EQUALS", "Add Feat", "Add16.gif", true));
                this.noQualifyMenuItem = Utility.createMenuItem(InfoFeats.NO_QUALIFY_MESSAGE, null, null, '\u0000', null, null, null, false);
                this.duplicateMenuItem = Utility.createMenuItem(InfoFeats.DUPLICATE_MESSAGE, null, null, '\u0000', null, null, null, false);
                this.featFullMenuItem = Utility.createMenuItem(InfoFeats.FEAT_FULL_MESSAGE, null, null, '\u0000', null, null, null, false);
            } else {
                this.add(InfoFeats.this.removeMenu = Utility.createMenuItem("Remove Feat", new ActionListener(this){
                    private final /* synthetic */ FeatPopupMenu this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent evt) {
                        InfoFeats.access$1500(FeatPopupMenu.access$3300(this.this$1));
                    }
                }, "infoFeats.removeFeat", '\u0000', "shortcut MINUS", "Remove Feat", "Remove16.gif", true));
            }
        }

        public void show(Component source, int x, int y) {
            Feat aFeat = (Feat)((PObjectNode)this.treeTable.getTree().getLastSelectedPathComponent()).getItem();
            if (this.treeTable == InfoFeats.this.availableTable) {
                int ok = InfoFeats.this.checkFeatQualify(aFeat);
                if (ok == 0) {
                    this.removeAll();
                    this.add(InfoFeats.this.addMenu);
                    super.show(source, x, y);
                    return;
                }
                if (SettingsHandler.isExpertGUI()) {
                    return;
                }
                switch (ok) {
                    case 2: {
                        this.removeAll();
                        this.add(this.noQualifyMenuItem);
                        super.show(source, x, y);
                        return;
                    }
                    case 1: {
                        this.removeAll();
                        this.add(this.duplicateMenuItem);
                        super.show(source, x, y);
                        return;
                    }
                    case 3: {
                        this.removeAll();
                        this.add(this.featFullMenuItem);
                        super.show(source, x, y);
                        return;
                    }
                }
                Logging.errorPrint("Feat " + aFeat.getName() + " is somehow in state " + ok + " which is not handled" + " in InfoFeats.FeatPopupMenu.show()");
            } else {
                super.show(source, x, y);
            }
        }

        static /* synthetic */ InfoFeats access$3300(FeatPopupMenu x0) {
            return x0.InfoFeats.this;
        }
    }

    private class FeatPopupListener
    extends MouseAdapter {
        private FeatPopupMenu menu;
        private JTree tree;
        private JTreeTable aTreeTable;

        private FeatPopupListener(JTreeTable treeTable, FeatPopupMenu aMenu) {
            this.aTreeTable = treeTable;
            this.tree = treeTable.getTree();
            this.menu = aMenu;
            KeyListener myKeyListener = new KeyListener(this){
                private final /* synthetic */ FeatPopupListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTyped(KeyEvent e) {
                    FeatPopupListener.access$2800(this.this$1).dispatchEvent(e);
                }

                public void keyPressed(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    if (keyCode != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                        for (int i = 0; i < FeatPopupListener.access$2900(this.this$1).getComponentCount(); ++i) {
                            KeyStroke ks;
                            Component menuComponent = FeatPopupListener.access$2900(this.this$1).getComponent(i);
                            if (!(menuComponent instanceof JMenuItem) || (ks = ((JMenuItem)menuComponent).getAccelerator()) == null || !keyStroke.equals(ks)) continue;
                            InfoFeats.access$3002(FeatPopupListener.access$2800(this.this$1), FeatPopupListener.access$3100(this.this$1).getSelectionPath());
                            ((JMenuItem)menuComponent).doClick(2);
                            return;
                        }
                    }
                    FeatPopupListener.access$2800(this.this$1).dispatchEvent(e);
                }

                public void keyReleased(KeyEvent e) {
                    FeatPopupListener.access$2800(this.this$1).dispatchEvent(e);
                }
            };
            treeTable.addKeyListener(myKeyListener);
        }

        public void mousePressed(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        private void maybeShowPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                InfoFeats.this.selPath = this.tree.getClosestPathForLocation(evt.getX(), evt.getY());
                if (InfoFeats.this.selPath == null) {
                    return;
                }
                if (this.tree.isSelectionEmpty()) {
                    this.tree.setSelectionPath(InfoFeats.this.selPath);
                    this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                } else if (!this.tree.isPathSelected(InfoFeats.this.selPath)) {
                    this.tree.setSelectionPath(InfoFeats.this.selPath);
                    this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                } else {
                    this.tree.addSelectionPath(InfoFeats.this.selPath);
                    this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        }

        static /* synthetic */ InfoFeats access$2800(FeatPopupListener x0) {
            return x0.InfoFeats.this;
        }

        static /* synthetic */ FeatPopupMenu access$2900(FeatPopupListener x0) {
            return x0.menu;
        }

        static /* synthetic */ JTree access$3100(FeatPopupListener x0) {
            return x0.tree;
        }
    }

    private final class FeatModel
    extends AbstractTreeTableModel {
        private String[] cNames = new String[]{"Name", "Modified"};
        private Class[] cTypes = new Class[]{class$pcgen$gui$utils$TreeTableModel == null ? (class$pcgen$gui$utils$TreeTableModel = InfoFeats.class$("pcgen.gui.utils.TreeTableModel")) : class$pcgen$gui$utils$TreeTableModel, class$java$lang$String == null ? (class$java$lang$String = InfoFeats.class$("java.lang.String")) : class$java$lang$String};
        private int modelType = 0;

        private FeatModel(int mode, boolean available) {
            super(null);
            this.resetModel(mode, available);
        }

        public Class getColumnClass(int column) {
            return this.cTypes[column];
        }

        public int getColumnCount() {
            return this.cNames.length;
        }

        public String getColumnName(int column) {
            if (column == 0) {
                if (this.modelType == 0) {
                    return "Feat";
                }
                return "Feat (" + InfoFeats.this.pc.getUsedFeatCount() + ")";
            }
            if (this.modelType == 0) {
                return "Source";
            }
            return "Choices";
        }

        public Object getRoot() {
            return (PObjectNode)super.getRoot();
        }

        public Object getValueAt(Object node, int column) {
            PObjectNode fn = (PObjectNode)node;
            switch (column) {
                case 0: {
                    return fn.toString();
                }
                case 1: {
                    if (this.modelType == 0) {
                        return fn.getSource();
                    }
                    return fn.getChoices();
                }
                case -1: {
                    return fn.getItem();
                }
            }
            Logging.errorPrint("In InfoFeats.getValueAt the column " + column + " is not supported.");
            return null;
        }

        private void setRoot(PObjectNode aNode) {
            this.setRoot(aNode.clone());
        }

        private List buildPCFeatList() {
            ArrayList<Feat> returnValue = new ArrayList<Feat>(InfoFeats.this.pc.aggregateFeatList().size());
            Iterator pcFeats = InfoFeats.this.pc.aggregateFeatList().iterator();
            while (pcFeats.hasNext()) {
                Feat aFeat = (Feat)pcFeats.next();
                if (aFeat.isMultiples()) {
                    String featName = aFeat.getName();
                    if (InfoFeats.this.pc.hasFeat(featName)) {
                        returnValue.add(InfoFeats.this.pc.getFeatNonAggregateNamed(featName));
                    }
                    if (InfoFeats.this.pc.hasFeatAutomatic(featName)) {
                        returnValue.add(InfoFeats.this.pc.getFeatAutomaticNamed(featName));
                    }
                    if (!InfoFeats.this.pc.hasFeatVirtual(featName)) continue;
                    returnValue.add(PlayerCharacter.getFeatNamedInList(InfoFeats.this.pc.getVirtualFeatList(), featName));
                    continue;
                }
                returnValue.add(aFeat);
            }
            return Globals.sortPObjectList(returnValue);
        }

        private void buildTreeNameOnly(boolean available) {
            super.setRoot(new PObjectNode());
            Iterator fI = available ? Globals.getFeatList().iterator() : this.buildPCFeatList().iterator();
            while (fI.hasNext()) {
                Feat aFeat = (Feat)fI.next();
                if (!InfoFeats.this.accept(InfoFeats.this.pc, aFeat) || aFeat.isVisible() != 1 && aFeat.isVisible() != 3) continue;
                int hasIt = 0;
                String featName = aFeat.getName();
                if (available) {
                    if (InfoFeats.this.pc.hasFeat(featName)) {
                        hasIt = 1;
                    } else if (InfoFeats.this.pc.hasFeatAutomatic(featName)) {
                        hasIt = 2;
                    } else if (InfoFeats.this.pc.hasFeatVirtual(featName)) {
                        hasIt = 4;
                    }
                }
                if ((!available || hasIt != 4 && hasIt != 0 && !aFeat.isMultiples()) && available) continue;
                PObjectNode aFN = new PObjectNode();
                aFN.setParent((PObjectNode)super.getRoot());
                if (!available) {
                    aFN.setCheckFeatState(2);
                }
                aFN.setItem(aFeat);
                ((PObjectNode)super.getRoot()).addChild(aFN);
            }
        }

        private void buildTreePrereqTree(boolean available) {
            Feat aFeat;
            Iterator it;
            if (preReqTreeRoot == null && available) {
                preReqTreeRoot = new PObjectNode();
            }
            if (available) {
                this.setRoot(preReqTreeRoot);
            } else {
                this.setRoot(new PObjectNode());
            }
            ArrayList<Feat> aList = new ArrayList<Feat>();
            ArrayList<Feat> fList = new ArrayList<Feat>();
            if (available) {
                it = Globals.getFeatList().iterator();
                while (it.hasNext()) {
                    aFeat = (Feat)it.next();
                    if (!InfoFeats.this.accept(InfoFeats.this.pc, aFeat) || aFeat.isVisible() != 1 && aFeat.isVisible() != 3) continue;
                    fList.add(aFeat);
                }
            } else {
                it = this.buildPCFeatList().iterator();
                while (it.hasNext()) {
                    aFeat = (Feat)it.next();
                    if (!InfoFeats.this.accept(InfoFeats.this.pc, aFeat) || aFeat.isVisible() != 1 && aFeat.isVisible() != 3) continue;
                    fList.add(aFeat);
                }
            }
            for (int i = 0; i < fList.size(); ++i) {
                Feat aFeat2 = (Feat)fList.get(i);
                if (aFeat2.hasPreReqTypeOf("FEAT")) continue;
                fList.remove(aFeat2);
                aList.add(aFeat2);
                --i;
            }
            PObjectNode rootAsPObjectNode = (PObjectNode)super.getRoot();
            PObjectNode[] cc = new PObjectNode[aList.size()];
            for (int i = 0; i < aList.size(); ++i) {
                cc[i] = new PObjectNode();
                cc[i].setItem(aList.get(i));
                cc[i].setParent(rootAsPObjectNode);
                if (available) continue;
                cc[i].setCheckFeatState(2);
            }
            rootAsPObjectNode.setChildren(cc);
            int loopmax = 6;
            while (fList.size() > 0 && loopmax-- > 0) {
                for (int i = 0; i < fList.size(); ++i) {
                    Feat aFeat3 = (Feat)fList.get(i);
                    int placed = 0;
                    for (int j = 0; j < rootAsPObjectNode.getChildCount(); ++j) {
                        PObjectNode po = rootAsPObjectNode.getChild(j);
                        ArrayList<Prerequisite> preReqList = new ArrayList<Prerequisite>();
                        for (int pi = aFeat3.getPreReqCount() - 1; pi >= 0; --pi) {
                            Prerequisite prereq = aFeat3.getPreReq(pi);
                            if (prereq.getKind() == null || !prereq.getKind().equalsIgnoreCase("FEAT")) continue;
                            preReqList.add(prereq);
                        }
                        placed = this.placedThisFeatInThisTree(aFeat3, po, preReqList, 0, available);
                        if (placed > 0) break;
                    }
                    if (placed != 2) continue;
                    fList.remove(aFeat3);
                    --i;
                }
            }
            if (fList.size() > 0) {
                PObjectNode po = new PObjectNode();
                po.setItem("Other");
                cc = new PObjectNode[fList.size()];
                for (int i = 0; i < fList.size(); ++i) {
                    cc[i] = new PObjectNode();
                    cc[i].setItem(fList.get(i));
                    cc[i].setParent(po);
                    cc[i].setCheckFeatState(this.modelType == 1 ? (available ? 1 : 2) : 0);
                }
                po.setChildren(cc);
                rootAsPObjectNode.addChild(po);
            }
        }

        private void buildTreeTypeName(boolean available) {
            this.setRoot(typeRoot);
            Iterator fI = available ? Globals.getFeatList().iterator() : this.buildPCFeatList().iterator();
            while (fI.hasNext()) {
                Feat aFeat = (Feat)fI.next();
                if (!InfoFeats.this.accept(InfoFeats.this.pc, aFeat) || aFeat.isVisible() != 1 && aFeat.isVisible() != 3) continue;
                int hasIt = 0;
                String featName = aFeat.getName();
                if (available) {
                    if (InfoFeats.this.pc.hasFeat(featName)) {
                        hasIt = 1;
                    } else if (InfoFeats.this.pc.hasFeatAutomatic(featName)) {
                        hasIt = 2;
                    } else if (InfoFeats.this.pc.hasFeatVirtual(featName)) {
                        hasIt = 4;
                    }
                }
                PObjectNode rootAsPObjectNode = (PObjectNode)super.getRoot();
                if ((!available || hasIt != 4 && hasIt != 0 && !aFeat.isMultiples()) && available) continue;
                for (int i = 0; i < rootAsPObjectNode.getChildCount(); ++i) {
                    if (!aFeat.isType(rootAsPObjectNode.getChild(i).toString())) continue;
                    PObjectNode aFN = new PObjectNode();
                    if (!available) {
                        aFN.setCheckFeatState(2);
                    }
                    aFN.setParent(rootAsPObjectNode.getChild(i));
                    aFN.setItem(aFeat);
                    if (Globals.checkRule("FEATPRE")) {
                        aFN.setIsValid(true);
                    } else {
                        aFN.setIsValid(PrereqHandler.passesAll(aFeat.getPreReqList(), InfoFeats.this.pc, aFeat));
                    }
                    rootAsPObjectNode.getChild(i).addChild(aFN);
                }
            }
        }

        private int placedThisFeatInThisTree(Feat aFeat, PObjectNode po, List aList, int level, boolean available) {
            Feat bFeat = (Feat)po.getItem();
            boolean trychildren = false;
            boolean thisisit = false;
            Iterator it = aList.iterator();
            while (it.hasNext()) {
                Prerequisite prereq = (Prerequisite)it.next();
                String pString = prereq.getKey();
                if (pString.equalsIgnoreCase(bFeat.getName())) {
                    thisisit = true;
                } else {
                    trychildren = true;
                }
                if (thisisit) {
                    PObjectNode p = new PObjectNode();
                    p.setItem(aFeat);
                    p.setParent(po);
                    po.addChild(p);
                    p.setCheckFeatState(this.modelType == 1 ? (available ? 1 : 2) : 0);
                    return 2;
                }
                if (!trychildren) continue;
                for (int i = 0; i < po.getChildCount(); ++i) {
                    int j = this.placedThisFeatInThisTree(aFeat, po.getChild(i), aList, level + 1, available);
                    if (j != 2) continue;
                    return 2;
                }
            }
            return 0;
        }

        private void resetModel(int mode, boolean available) {
            if (!available) {
                this.modelType = 1;
            }
            switch (mode) {
                case 0: {
                    this.buildTreeTypeName(available);
                    break;
                }
                case 1: {
                    this.buildTreeNameOnly(available);
                    break;
                }
                case 2: {
                    this.buildTreePrereqTree(available);
                    break;
                }
                default: {
                    Logging.errorPrint("In InfoFeats.resetModel the mode " + mode + " is not supported.");
                }
            }
            PObjectNode rootAsPObjectNode = (PObjectNode)super.getRoot();
            if (rootAsPObjectNode.getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }
    }
}

