/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.core.Constants;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.EQFrame;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.Utility;
import pcgen.util.BigDecimalHelper;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;
import pcgen.util.Logging;

public final class InfoGear
extends FilterAdapterPanel
implements CharacterInfoTab {
    static final long serialVersionUID = -2320970658737297916L;
    private static boolean needsUpdate = true;
    private static int splitOrientation = 1;
    private static int viewMode = 0;
    private static int viewSelectMode = 2;
    private static final int NUM_COL_AVAILABLE = 3;
    private static final int NUM_COL_SELECTED = 4;
    private static final int COL_NAME = 0;
    private static final int COL_COST = 1;
    private static final int COL_QTY_SRC = 2;
    private static final int COL_INDEX = 3;
    private static Object typeSubtypeRoot;
    private static Object typeRoot;
    private static Object allTypeRoot;
    private Border etched;
    private BuyGearActionListener buyOneListener = new BuyGearActionListener(1);
    private EQFrame eqFrame = null;
    private EquipmentModel availableModel = null;
    private EquipmentModel selectedModel = null;
    private FlippingSplitPane asplit;
    private FlippingSplitPane bsplit;
    private FlippingSplitPane splitPane;
    private JComboBoxEx cmbBuyPercent = new JComboBoxEx();
    private JComboBoxEx cmbSellPercent = new JComboBoxEx();
    private final JLabel avaLabel = new JLabel("Available");
    private final JLabel goldLabel = new JLabel(Globals.getLongCurrencyDisplay() + ": ");
    private final JLabel lblBuyRate = new JLabel("Buy percentage:");
    private final JLabel lblSellRate = new JLabel("Sell percentage:");
    private final JLabel selLabel = new JLabel("Selected");
    private final JLabel valueLabel = new JLabel("Total Value: ");
    private JButton addButton;
    private JButton removeButton;
    private JCheckBox allowDebtBox = new JCheckBox("Allow Debt");
    private JCheckBox autoSort = new JCheckBox("Auto-sort output", true);
    private JCheckBox costBox = new JCheckBox("Ignore Cost");
    private JComboBoxEx viewComboBox = new JComboBoxEx();
    private JComboBoxEx viewSelectComboBox = new JComboBoxEx();
    private JLabelPane infoLabel = new JLabelPane();
    private JMenu pcCopyMenu = Utility.createMenu("Copy Item To", '\u0000', "Copy Item To", null, true);
    private JMenu pcMoveMenu = Utility.createMenu("Move Item To", '\u0000', "Move Item To", null, true);
    private JPanel center = new JPanel();
    private JPanel pnlBuy = new JPanel();
    private JPanel pnlSell = new JPanel();
    private JPanel south = new JPanel();
    private JScrollPane eqScroll = new JScrollPane();
    private JScrollPane scrollPane;
    private JTextField gold = new JTextField();
    private JTextField totalValue = new JTextField("Temp");
    private JTreeTable availableTable;
    private JTreeTable selectedTable;
    private JTreeTableSorter availableSort = null;
    private JTreeTableSorter selectedSort = null;
    private SellGearActionListener sellOneListener = new SellGearActionListener(1);
    private Runnable sellOneRunnable = new Runnable(){

        public void run() {
            InfoGear.this.sellOneListener.actionPerformed(null);
        }
    };
    private String lastSearch = "";
    private TreePath selPath;
    private boolean hasBeenSized = false;
    private boolean readyForRefresh = false;
    private int selRow;
    private PlayerCharacter pc;
    private int serial = 0;
    static /* synthetic */ Class class$pcgen$gui$utils$TreeTableModel;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;

    public InfoGear(PlayerCharacter pc) {
        this.pc = pc;
        this.setName(Constants.tabNames[11]);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoGear.this.initComponents();
                InfoGear.this.initActionListeners();
            }
        });
    }

    public void setPc(PlayerCharacter pc) {
        if (this.pc != pc || pc.getSerial() > this.serial) {
            this.pc = pc;
            this.serial = pc.getSerial();
            this.forceRefresh();
        }
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Gear.Order", 11);
    }

    public void setTabOrder(int order) {
        SettingsHandler.setPCGenOption(".Panel.Gear.Order", order);
    }

    public String getTabName() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabName(11);
    }

    public boolean isShown() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabShown(11);
    }

    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    public JComponent getView() {
        return this;
    }

    public static void setNeedsUpdate(boolean flag) {
        needsUpdate = flag;
    }

    public boolean isMatchAnyEnabled() {
        return true;
    }

    public boolean isNegateEnabled() {
        return true;
    }

    public int getSelectionMode() {
        return 2;
    }

    public void buySpecifiedEquipment(Equipment selectedEquipment, double newQty) {
        this.buySpecifiedEquipmentRate(selectedEquipment, newQty, SettingsHandler.getGearTab_BuyRate());
    }

    public void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
        FilterFactory.registerAllSizeFilters(this);
        FilterFactory.registerAllEquipmentFilters(this);
        this.setKitFilter("GEAR");
    }

    public void refreshAvailableList(Equipment newEq, boolean purchase, boolean isCurrent) {
        this.availableModel.addItemToModel(newEq, true);
        this.availableModel.updateTree();
        this.availableTable.updateUI();
        if (isCurrent && this.availableTable.search(newEq.getName(), true) != null) {
            this.availableTable.requestFocus();
        }
        if (purchase) {
            this.buySpecifiedEquipment(newEq, 1.0);
        }
    }

    public void refreshFiltering() {
        this.forceRefresh();
    }

    public void sellSpecifiedEquipment(Equipment selectedEquipment, double qty) {
        this.sellSpecifiedEquipmentRate(selectedEquipment, qty, SettingsHandler.getGearTab_SellRate());
    }

    private void updateCharacterInfo() {
        int ix = 0;
        this.pcMoveMenu.removeAll();
        this.pcCopyMenu.removeAll();
        Iterator i = Globals.getPCList().iterator();
        while (i.hasNext()) {
            PlayerCharacter testPc = (PlayerCharacter)i.next();
            if (testPc != this.pc) {
                this.pcMoveMenu.add(Utility.createMenuItem(testPc.getName(), new MoveItemListener(ix, 0), "MoveItemTo", '\u0000', null, "Move Item To " + testPc.getName(), null, true));
                this.pcCopyMenu.add(Utility.createMenuItem(testPc.getName(), new MoveItemListener(ix, 1), "CopyItemTo", '\u0000', null, "Copy Item To " + testPc.getName(), null, true));
            }
            ++ix;
        }
        this.pcMoveMenu.setEnabled(this.pcMoveMenu.getItemCount() > 0);
        this.pcCopyMenu.setEnabled(this.pcCopyMenu.getItemCount() > 0);
        if (!needsUpdate) {
            return;
        }
        this.autoSort.setSelected(this.pc.isAutoSortGear());
        this.pc.aggregateFeatList();
        this.updateAvailableModel();
        this.updateSelectedModel();
        this.gold.setText(this.pc.getGold().toString());
        this.updateTotalValue();
        needsUpdate = false;
    }

    private static int getEventSelectedIndex(ListSelectionEvent e) {
        DefaultListSelectionModel model = (DefaultListSelectionModel)e.getSource();
        if (model == null) {
            return -1;
        }
        return model.getMinSelectionIndex();
    }

    private Object getCurrentAvailableTableItem() {
        Object item = null;
        int row = this.availableTable.getSelectionModel().getAnchorSelectionIndex();
        if (row >= 0) {
            TreePath treePath = this.availableTable.getTree().getPathForRow(row);
            Object eo = treePath.getLastPathComponent();
            PObjectNode e = (PObjectNode)eo;
            item = e.getItem();
        }
        return item;
    }

    private Object getCurrentSelectedTableItem() {
        Object item = null;
        int row = this.selectedTable.getSelectionModel().getAnchorSelectionIndex();
        if (row >= 0) {
            TreePath treePath = this.selectedTable.getTree().getPathForRow(row);
            Object eo = treePath.getLastPathComponent();
            PObjectNode e = (PObjectNode)eo;
            item = e.getItem();
        }
        return item;
    }

    private int getHighestOutputIndex() {
        int maxOutputIndex = 0;
        if (this.pc == null) {
            return 0;
        }
        Iterator i = this.pc.getEquipmentMasterList().iterator();
        while (i.hasNext()) {
            Equipment item = (Equipment)i.next();
            if (item.getOutputIndex() <= maxOutputIndex) continue;
            maxOutputIndex = item.getOutputIndex();
        }
        return maxOutputIndex;
    }

    private void setInfoLabelText(Equipment aEq) {
        if (aEq != null) {
            int charges;
            Integer a;
            String bString;
            String IDS;
            String cString;
            StringBuffer b = new StringBuffer();
            b.append("<html><b>").append(aEq.piSubString()).append("</b>");
            if (!aEq.longName().equals(aEq.getName())) {
                b.append("(").append(aEq.longName()).append(")");
            }
            b.append(" &nbsp;<b>TYPE</b>:").append(aEq.getType());
            if (aEq.isWeapon() || aEq.isArmor() || aEq.isShield()) {
                b.append(" <b>PROFICIENT</b>:");
                b.append(this.pc.isProficientWith(aEq) && aEq.meetsPreReqs() ? "Y" : SettingsHandler.getPrereqFailColorAsHtmlStart() + "N" + SettingsHandler.getPrereqFailColorAsHtmlEnd());
            }
            if ((cString = aEq.preReqHTMLStrings(this.pc, false)).length() > 0) {
                b.append(" &nbsp;<b>Requirements</b>:").append(cString);
            }
            if ((IDS = aEq.getInterestingDisplayString(this.pc)).length() > 0) {
                b.append(" &nbsp;<b>Properties</b>:").append(IDS);
            }
            if ((bString = aEq.getWeight(this.pc).toString()).length() > 0) {
                b.append(" <b>WT</b>:").append(bString).append(Globals.getWeightUnit());
            }
            if ((a = aEq.getMaxDex(this.pc)) != 100) {
                b.append(" <b>MAXDEX</b>:").append(a.toString());
            }
            a = aEq.acCheck(this.pc);
            if (aEq.isArmor() || aEq.isShield() || a != 0) {
                b.append(" <b>ACCHECK</b>:").append(a.toString());
            }
            if (Globals.getGameModeACText().length() != 0) {
                a = aEq.getACBonus(this.pc);
                if (aEq.isArmor() || aEq.isShield() || a != 0) {
                    b.append(" <b>").append(Globals.getGameModeACText()).append(" Bonus</b>:").append(a.toString());
                }
            }
            if (Globals.getGameModeShowSpellTab()) {
                a = aEq.spellFailure(this.pc);
                if (aEq.isArmor() || aEq.isShield() || a != 0) {
                    b.append(" <b>Arcane Failure</b>:").append(a.toString());
                }
            }
            if ((bString = Globals.getGameModeDamageResistanceText()).length() != 0) {
                a = aEq.eDR(this.pc);
                if (aEq.isArmor() || aEq.isShield() || a != 0) {
                    b.append(" <b>").append(bString).append("</b>:").append(a.toString());
                }
            }
            if ((bString = aEq.moveString()).length() > 0) {
                b.append(" <b>Move</b>:").append(bString);
            }
            if ((bString = aEq.getSize()).length() > 0) {
                b.append(" <b>Size</b>:").append(bString);
            }
            if ((bString = aEq.getDamage(this.pc)).length() > 0) {
                b.append(" <b>Damage</b>:").append(bString);
                if (aEq.isDouble()) {
                    b.append('/').append(aEq.getAltDamage(this.pc));
                }
            }
            if ((bString = aEq.getCritRange(this.pc)).length() > 0) {
                b.append(" <b>Crit Range</b>:").append(bString);
                if (aEq.isDouble() && !aEq.getCritRange(this.pc).equals(aEq.getAltCritRange(this.pc))) {
                    b.append('/').append(aEq.getAltCritRange(this.pc));
                }
            }
            if ((bString = aEq.getCritMult()).length() > 0) {
                b.append(" <b>Crit Mult</b>:").append(bString);
                if (aEq.isDouble() && !aEq.getCritMult().equals(aEq.getAltCritMult())) {
                    b.append('/').append(aEq.getAltCritMult());
                }
            }
            if (aEq.isWeapon() && (bString = Globals.displayDistanceInUnitSet(Globals.convertDistanceToUnitSet(aEq.getRange(this.pc).intValue()))).length() > 0) {
                b.append(" <b>Range</b>:").append(bString).append(Globals.getDistanceUnit());
            }
            if ((bString = aEq.getContainerCapacityString()).length() > 0) {
                b.append(" <b>Container</b>:").append(bString);
            }
            if ((bString = aEq.getContainerContentsString()).length() > 0) {
                b.append(" <b>Currently Contains</b>:").append(bString);
            }
            if ((charges = aEq.getRemainingCharges()) >= 0) {
                b.append(" <b>Charges</b>:").append(charges);
            }
            if ((bString = aEq.getSource()).length() > 0) {
                b.append(" <b>SOURCE</b>:").append(bString);
            }
            b.append("</html>");
            this.infoLabel.setText(b.toString());
        } else {
            this.infoLabel.setText();
        }
    }

    private double adjustBelongings(Equipment equipItemToAdjust, double adjustment) {
        int nextOutputIndex = 1;
        double actualAdjustment = adjustment;
        if (this.pc != null) {
            Equipment updatedItem = this.pc.getEquipmentNamed(equipItemToAdjust.getName());
            if (updatedItem != null) {
                double prevQty = updatedItem.qty() < 0.0 ? 0.0 : updatedItem.qty();
                double newQty = prevQty + adjustment;
                if (newQty <= 0.0) {
                    actualAdjustment = -prevQty;
                    updatedItem.setNumberCarried(new Float(0.0f));
                    updatedItem.setLocation(8);
                    Equipment eqParent = (Equipment)updatedItem.getParent();
                    if (eqParent != null) {
                        eqParent.removeChild(this.pc, updatedItem);
                    }
                    this.pc.removeEquipment(updatedItem);
                    this.pc.delEquipSetItem(updatedItem);
                    this.selectedModel.removeItemFromNodes(null, updatedItem);
                    this.pc.setCalcEquipmentList();
                    this.pc.totalWeight();
                } else {
                    Float qty = new Float(newQty);
                    updatedItem.setQty(qty);
                    updatedItem.setNumberCarried(qty);
                    this.selectedModel.setValueForItemInNodes(null, updatedItem, newQty, 2);
                }
            } else if (adjustment > 0.0 && (updatedItem = (Equipment)equipItemToAdjust.clone()) != null) {
                if (this.autoSort.isSelected()) {
                    updatedItem.setOutputIndex(nextOutputIndex);
                    this.resortSelected(0, true);
                } else if (updatedItem.getOutputIndex() == 0) {
                    updatedItem.setOutputIndex(this.getHighestOutputIndex() + 1);
                }
                Float qty = new Float(adjustment);
                updatedItem.setQty(qty);
                updatedItem.setNumberCarried(qty);
                this.pc.addEquipment(updatedItem);
                this.selectedModel.addItemToModel(updatedItem, true);
            }
            this.pc.setCalcEquipmentList();
            this.updateEqInfo(updatedItem);
            this.pc.setDirty(true);
            this.selectedModel.updateTree();
            this.selectedTable.updateUI();
            return actualAdjustment;
        }
        return 0.0;
    }

    private void adjustGold(Equipment base, double diffQty, int buyRate, int sellRate) {
        if (!this.costBox.isSelected() && this.pc != null) {
            double itemCost = diffQty * (double)base.getCost(this.pc).floatValue() * -0.01;
            if (diffQty < 0.0) {
                itemCost *= (double)sellRate;
            } else if (diffQty > 0.0) {
                itemCost *= (double)buyRate;
            }
            this.pc.setDirty(true);
            this.pc.adjustGold(itemCost);
            this.gold.setText(this.pc.getGold().toString());
        }
    }

    private void buySpecifiedEquipmentRate(Equipment selectedEquipment, double qty) {
        String defaultValue = this.cmbSellPercent.getSelectedItem().toString();
        InputInterface ii = InputFactory.getInputInstance();
        Object input = ii.showInputDialog(this, "Enter buy price percentage:", "Buy at Percent", MessageType.QUESTION, null, defaultValue);
        if (input != null) {
            String iString = input.toString().trim();
            try {
                int buyRate = Integer.parseInt(iString);
                this.buySpecifiedEquipmentRate(selectedEquipment, qty, buyRate);
            }
            catch (NumberFormatException nfe) {
                ShowMessageDelegate.showMessageDialog("You must enter an integer value.", "Error", MessageType.ERROR);
            }
        }
    }

    private void buySpecifiedEquipmentRate(Equipment selectedEquipment, double qtyToBuy, int buyRate) {
        try {
            if (selectedEquipment.getModifiersRequired() && selectedEquipment.getEqModifierList(true).size() == 0 && selectedEquipment.getEqModifierList(false).size() == 0) {
                ShowMessageDelegate.showMessageDialog("You cannot buy this item as is; you must \"customize\" it first.", "PCGen", MessageType.ERROR);
                return;
            }
            double buyQty = qtyToBuy;
            if (buyQty < 0.0) {
                String selectedValue = JOptionPane.showInputDialog(null, "Enter Quantity", "PCGen", 3);
                if (selectedValue != null) {
                    try {
                        buyQty = Float.parseFloat(selectedValue.trim());
                    }
                    catch (Exception e) {
                        ShowMessageDelegate.showMessageDialog("Invalid number!", "PCGen", MessageType.ERROR);
                        return;
                    }
                } else {
                    return;
                }
            }
            if (selectedEquipment.acceptsChildren() && !CoreUtility.doublesEqual(buyQty % 1.0, 0.0)) {
                ShowMessageDelegate.showMessageDialog("You cannot buy, own or carry non-integral numbers of containers\ni.e. Half a sack is nonsensical.", "PCGen", MessageType.ERROR);
                return;
            }
            if (this.canAfford(selectedEquipment, buyQty, buyRate)) {
                this.adjustBelongings(selectedEquipment, buyQty);
                this.adjustGold(selectedEquipment, buyQty, buyRate, 0);
            } else {
                ShowMessageDelegate.showMessageDialog("Insufficient funds for purchase of " + qtyToBuy + " " + selectedEquipment.getName(), "PCGen", MessageType.INFORMATION);
            }
        }
        catch (Exception exc) {
            ShowMessageDelegate.showMessageDialog("buySpecifiedEquipment: Exception:" + exc.getMessage(), "PCGen", MessageType.ERROR);
        }
    }

    private boolean canAfford(Equipment selected, double purchaseQty, int buyRate) {
        float currentFunds = this.pc != null ? this.pc.getGold().floatValue() : 0.0f;
        double itemCost = purchaseQty * (double)buyRate * (double)0.01f * (double)selected.getCost(this.pc).floatValue();
        return this.costBox.isSelected() || this.allowDebtBox.isSelected() || itemCost <= (double)currentFunds;
    }

    private void createAvailableModel() {
        if (this.availableModel == null) {
            this.availableModel = new EquipmentModel(viewMode, true);
        } else {
            this.availableModel.resetModel(InfoGear.viewMode, true);
        }
        if (this.availableSort != null) {
            this.availableSort.setRoot((PObjectNode)this.availableModel.getRoot());
            this.availableSort.sortNodeOnColumn();
        }
    }

    private void createModels() {
        this.createAvailableModel();
        this.createSelectedModel();
    }

    private void createSelectedModel() {
        if (this.selectedModel == null) {
            this.selectedModel = new EquipmentModel(viewSelectMode, false);
        } else {
            this.selectedModel.resetModel(InfoGear.viewSelectMode, false);
        }
        if (this.selectedSort != null) {
            this.selectedSort.setRoot((PObjectNode)this.selectedModel.getRoot());
            this.selectedSort.sortNodeOnColumn();
        }
    }

    private void createTreeTables() {
        this.availableTable = new JTreeTable(this.availableModel);
        final JTree avaTree = this.availableTable.getTree();
        avaTree.setRootVisible(false);
        avaTree.setShowsRootHandles(true);
        avaTree.setCellRenderer(new LabelTreeCellRenderer());
        this.availableTable.setSelectionMode(0);
        this.availableTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    PObjectNode pobjn;
                    int idx = InfoGear.getEventSelectedIndex(e);
                    if (idx < 0) {
                        return;
                    }
                    Object temp = InfoGear.this.availableTable.getTree().getPathForRow(idx).getLastPathComponent();
                    if (temp != null) {
                        pobjn = (PObjectNode)temp;
                        if (!(pobjn.getItem() instanceof Equipment)) {
                            InfoGear.this.setInfoLabelText(null);
                            return;
                        }
                    } else {
                        return;
                    }
                    Equipment aEq = (Equipment)pobjn.getItem();
                    InfoGear.this.addButton.setEnabled(aEq != null);
                    InfoGear.this.setInfoLabelText(aEq);
                }
            }
        });
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TreePath mlSelPath = avaTree.getPathForLocation(e.getX(), e.getY());
                if (mlSelPath != null) {
                    if (e.getClickCount() == 2) {
                        InfoGear.this.buyOneListener.actionPerformed(null);
                    } else if (e.getClickCount() == 1 && e.isControlDown()) {
                        if (avaTree.isPathSelected(mlSelPath)) {
                            avaTree.removeSelectionPath(mlSelPath);
                        } else if (!avaTree.isPathSelected(mlSelPath)) {
                            avaTree.addSelectionPath(mlSelPath);
                        }
                    }
                }
            }
        };
        avaTree.addMouseListener(ml);
        this.selectedTable = new JTreeTable(this.selectedModel);
        this.selectedTable.getColumnModel().getColumn(2).setCellEditor(new QuantityEditor());
        this.selectedTable.getColumnModel().getColumn(3).setCellEditor(new OutputOrderEditor(new String[]{"First", "Last", "Hidden"}));
        final JTree selTree = this.selectedTable.getTree();
        selTree.setRootVisible(false);
        selTree.setShowsRootHandles(true);
        selTree.setCellRenderer(new LabelTreeCellRenderer());
        this.selectedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    String aString = null;
                    Equipment aEq = null;
                    Object temp = InfoGear.this.getCurrentSelectedTableItem();
                    if (temp != null) {
                        if (!(temp instanceof Equipment)) {
                            InfoGear.this.setInfoLabelText(null);
                            return;
                        }
                        aEq = (Equipment)temp;
                        aString = temp.toString();
                    } else {
                        InfoGear.this.infoLabel.setText();
                    }
                    InfoGear.this.removeButton.setEnabled(aEq != null);
                    InfoGear.this.setInfoLabelText(aEq);
                }
            }
        });
        this.selectedTable.setSelectionMode(0);
        ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TreePath mlSelPath = selTree.getPathForLocation(e.getX(), e.getY());
                if (InfoGear.this.selRow != -1) {
                    if (e.getClickCount() == 1 && mlSelPath != null) {
                        selTree.setSelectionPath(mlSelPath);
                    } else if (e.getClickCount() == 2) {
                        SwingUtilities.invokeLater(InfoGear.this.sellOneRunnable);
                    }
                }
            }
        };
        selTree.addMouseListener(ml);
        this.hookupPopupMenu(this.availableTable);
        this.hookupPopupMenu(this.selectedTable);
    }

    private void customizeButtonClick() {
        if (!this.addButton.isEnabled()) {
            return;
        }
        int currentRow = this.availableTable.getSelectedRow();
        if (currentRow >= 0) {
            int row = this.availableTable.getSelectionModel().getAnchorSelectionIndex();
            TreePath treePath = this.availableTable.getTree().getPathForRow(row);
            Object eo = treePath.getLastPathComponent();
            PObjectNode e = (PObjectNode)eo;
            if (!(e.getItem() instanceof Equipment)) {
                ShowMessageDelegate.showMessageDialog("Can only customise items, not types.", "PCGen", MessageType.ERROR);
                return;
            }
            Equipment aEq = (Equipment)e.getItem();
            this.openCustomizer(aEq);
        }
    }

    private void deleteCustomButtonClick() {
        int currentRow = this.availableTable.getSelectedRow();
        if (currentRow >= 0) {
            int row = this.availableTable.getSelectionModel().getAnchorSelectionIndex();
            TreePath treePath = this.availableTable.getTree().getPathForRow(row);
            Object eo = treePath.getLastPathComponent();
            PObjectNode e = (PObjectNode)eo;
            if (!(e.getItem() instanceof Equipment)) {
                ShowMessageDelegate.showMessageDialog("Cannot delete types.", "PCGen", MessageType.ERROR);
                return;
            }
            Equipment aEq = (Equipment)e.getItem();
            if (!aEq.isType("CUSTOM")) {
                ShowMessageDelegate.showMessageDialog("Can only delete custom items.", "PCGen", MessageType.ERROR);
                return;
            }
            ArrayList<String> whoHasIt = new ArrayList<String>();
            Iterator pcIterator = Globals.getPCList().iterator();
            while (pcIterator.hasNext()) {
                PlayerCharacter pc = (PlayerCharacter)pcIterator.next();
                if (pc.getEquipmentNamed(aEq.getName()) == null) continue;
                whoHasIt.add(pc.getName());
            }
            if (whoHasIt.size() != 0) {
                String whose = ((Object)whoHasIt).toString();
                whose = whose.substring(1, whose.length() - 1);
                ShowMessageDelegate.showMessageDialog("Can only delete items that are in no character's possession. The following character(s) have this item in their possession:\n" + whose, "PCGen", MessageType.ERROR);
                return;
            }
            if ((aEq = EquipmentList.getEquipmentKeyed(aEq.getKeyName())) != null) {
                if (JOptionPane.showConfirmDialog(null, "Delete " + aEq.getName() + " from database?", "PCGen", 0) == 1) {
                    return;
                }
                EquipmentList.getEquipmentList().remove(aEq);
                this.updateAvailableModel();
            }
        }
    }

    private void editChargesButtonClicked() {
        Object item = this.getCurrentSelectedTableItem();
        if (!(item instanceof Equipment)) {
            return;
        }
        Equipment aEq = (Equipment)item;
        int minCharges = aEq.getMinCharges();
        int maxCharges = aEq.getMaxCharges();
        if (minCharges < 0) {
            ShowMessageDelegate.showMessageDialog("This item cannot hold charges.", "PCGen", MessageType.ERROR);
            return;
        }
        InputInterface ii = InputFactory.getInputInstance();
        Object selectedValue = ii.showInputDialog(null, "Enter Number of Charges (" + Integer.toString(minCharges) + "-" + Integer.toString(maxCharges) + ")", "PCGen", MessageType.INFORMATION, null, Integer.toString(aEq.getRemainingCharges()));
        if (selectedValue == null) {
            return;
        }
        try {
            String aString = ((String)selectedValue).trim();
            int charges = Integer.parseInt(aString);
            if (charges < minCharges || charges > maxCharges) {
                ShowMessageDelegate.showMessageDialog("Value out of range", "PCGen", MessageType.ERROR);
                return;
            }
            if (aEq.getRemainingCharges() != charges) {
                Equipment newEq = (Equipment)aEq.clone();
                newEq.setRemainingCharges(charges);
                this.pc.updateEquipSetItem(aEq, newEq);
                if (aEq.getQty().floatValue() <= 1.0f) {
                    this.pc.removeEquipment(aEq);
                }
                this.pc.addEquipment(newEq);
                this.updateEqInfo(newEq);
                this.updateSelectedModel();
                this.pc.setDirty(true);
                return;
            }
        }
        catch (Exception exc) {
            // empty catch block
        }
    }

    private void formComponentShown() {
        int i;
        this.requestFocus();
        PCGen_Frame1.getStatusBar().setText("Equipment character is not proficient with are in Red.");
        this.refresh();
        int s = this.splitPane.getDividerLocation();
        int t = this.bsplit.getDividerLocation();
        int u = this.asplit.getDividerLocation();
        TableColumn[] acol = new TableColumn[3];
        TableColumn[] scol = new TableColumn[4];
        int[] awidth = new int[3];
        int[] swidth = new int[4];
        for (i = 0; i < 3; ++i) {
            acol[i] = this.availableTable.getColumnModel().getColumn(i);
            awidth[i] = acol[i].getWidth();
        }
        for (i = 0; i < 4; ++i) {
            scol[i] = this.selectedTable.getColumnModel().getColumn(i);
            swidth[i] = scol[i].getWidth();
        }
        if (!this.hasBeenSized) {
            int width;
            TableColumn sCol;
            this.hasBeenSized = true;
            s = SettingsHandler.getPCGenOption("InfoGear.splitPane", (int)(this.getSize().getWidth() * 6.0 / 10.0));
            t = SettingsHandler.getPCGenOption("InfoGear.bsplit", (int)(this.getSize().getHeight() - 120.0));
            u = SettingsHandler.getPCGenOption("InfoGear.asplit", (int)(this.getSize().getWidth() - 295.0));
            for (i = 0; i < this.selectedTable.getColumnCount(); ++i) {
                sCol = this.selectedTable.getColumnModel().getColumn(i);
                width = Globals.getCustColumnWidth("InvSel", i);
                if (width == 0) {
                    sCol.setPreferredWidth(swidth[i]);
                } else {
                    sCol.setPreferredWidth(width);
                }
                sCol.addPropertyChangeListener(new ResizeColumnListener(this.selectedTable, "InvSel", i));
            }
            for (i = 0; i < this.availableTable.getColumnCount(); ++i) {
                sCol = this.availableTable.getColumnModel().getColumn(i);
                width = Globals.getCustColumnWidth("InvAva", i);
                if (width == 0) {
                    sCol.setPreferredWidth(swidth[i]);
                } else {
                    sCol.setPreferredWidth(width);
                }
                sCol.addPropertyChangeListener(new ResizeColumnListener(this.availableTable, "InvAva", i));
            }
        }
        if (s > 0) {
            this.splitPane.setDividerLocation(s);
            SettingsHandler.setPCGenOption("InfoGear.splitPane", s);
        }
        if (t > 0) {
            this.bsplit.setDividerLocation(t);
            SettingsHandler.setPCGenOption("InfoGear.bsplit", t);
        }
        if (u > 0) {
            this.asplit.setDividerLocation(u);
            SettingsHandler.setPCGenOption("InfoGear.asplit", u);
        }
    }

    private void hookupPopupMenu(JTreeTable treeTable) {
        treeTable.addMouseListener(new GearPopupListener(treeTable, new GearPopupMenu(treeTable)));
    }

    private void initActionListeners() {
        this.gold.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                if (InfoGear.this.gold.getText().length() > 0) {
                    if (InfoGear.this.pc != null) {
                        InfoGear.this.pc.setDirty(true);
                        InfoGear.this.pc.setGold(InfoGear.this.gold.getText());
                    }
                } else if (InfoGear.this.pc != null) {
                    InfoGear.this.gold.setText(InfoGear.this.pc.getGold().toString());
                }
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                InfoGear.this.formComponentShown();
            }

            public void componentResized(ComponentEvent e) {
                InfoGear.this.bsplit.setDividerLocation((int)(InfoGear.this.getSize().getHeight() - 120.0));
                InfoGear.this.asplit.setDividerLocation((int)(InfoGear.this.getSize().getWidth() - 295.0));
            }
        });
        this.removeButton.addActionListener(this.sellOneListener);
        this.addButton.addActionListener(this.buyOneListener);
        this.viewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoGear.this.viewComboBoxActionPerformed();
            }
        });
        this.viewSelectComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoGear.this.viewSelectComboBoxActionPerformed();
            }
        });
        this.costBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SettingsHandler.setGearTab_IgnoreCost(InfoGear.this.costBox.isSelected());
            }
        });
        this.allowDebtBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SettingsHandler.setGearTab_AllowDebt(InfoGear.this.allowDebtBox.isSelected());
            }
        });
        this.autoSort.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (InfoGear.this.pc != null) {
                    InfoGear.this.pc.setDirty(true);
                    InfoGear.this.pc.setAutoSortGear(InfoGear.this.autoSort.isSelected());
                }
            }
        });
        FilterFactory.restoreFilterSettings(this);
    }

    private void initComponents() {
        int i;
        this.readyForRefresh = true;
        int iView = SettingsHandler.getGearTab_AvailableListMode();
        if (iView >= 0 && iView <= 3) {
            viewMode = iView;
        }
        SettingsHandler.setGearTab_AvailableListMode(viewMode);
        iView = SettingsHandler.getGearTab_SelectedListMode();
        if (iView >= 0 && iView <= 3) {
            viewSelectMode = iView;
        }
        SettingsHandler.setGearTab_SelectedListMode(viewSelectMode);
        this.viewComboBox.addItem("Type/SubType/Name");
        this.viewComboBox.addItem("Type/Name");
        this.viewComboBox.addItem("Name");
        this.viewComboBox.addItem("All Types");
        Utility.setDescription(this.viewComboBox, "You can change how the Equipment in the Tables are listed.");
        this.viewComboBox.setSelectedIndex(viewMode);
        this.viewSelectComboBox.addItem("Type/SubType/Name");
        this.viewSelectComboBox.addItem("Type/Name");
        this.viewSelectComboBox.addItem("Name");
        this.viewSelectComboBox.addItem("All Types");
        Utility.setDescription(this.viewSelectComboBox, "You can change how the Equipment in the Tables are listed.");
        this.viewSelectComboBox.setSelectedIndex(viewSelectMode);
        boolean customExists = Equipment.getEquipmentTypes().contains("CUSTOM");
        typeSubtypeRoot = new PObjectNode();
        typeRoot = new PObjectNode();
        allTypeRoot = new PObjectNode();
        ArrayList<String> aList = new ArrayList<String>();
        ArrayList<String> bList = new ArrayList<String>();
        if (customExists) {
            aList.add("CUSTOM");
            bList.add("CUSTOM");
        }
        for (int i2 = 0; i2 < EquipmentList.getEquipmentList().size(); ++i2) {
            Equipment bEq = (Equipment)EquipmentList.getEquipmentList().get(i2);
            StringTokenizer aTok = new StringTokenizer(bEq.getType(), ".", false);
            if (!aTok.hasMoreTokens()) continue;
            String aString = aTok.nextToken();
            if (!aList.contains(aString)) {
                aList.add(aString);
            }
            if (!bList.contains(aString)) {
                bList.add(aString);
            }
            while (aTok.hasMoreTokens()) {
                aString = aTok.nextToken();
                if (bList.contains(aString)) continue;
                bList.add(aString);
            }
        }
        Collections.sort(aList);
        Collections.sort(bList);
        PObjectNode[] cc = new PObjectNode[aList.size()];
        PObjectNode[] dc = new PObjectNode[aList.size()];
        for (i = 0; i < aList.size(); ++i) {
            cc[i] = new PObjectNode();
            cc[i].setItem(aList.get(i).toString());
            cc[i].setParent((PObjectNode)typeSubtypeRoot);
            dc[i] = new PObjectNode();
            dc[i].setItem(aList.get(i).toString());
            dc[i].setParent((PObjectNode)typeRoot);
        }
        ((PObjectNode)typeSubtypeRoot).setChildren(cc);
        ((PObjectNode)typeRoot).setChildren(dc);
        for (i = 0; i < cc.length; ++i) {
            aList.clear();
            for (int j = 0; j < EquipmentList.getEquipmentList().size(); ++j) {
                String topType;
                Equipment bEq = (Equipment)EquipmentList.getEquipmentList().get(j);
                if (!bEq.isType(topType = cc[i].toString())) continue;
                StringTokenizer aTok = new StringTokenizer(bEq.getType(), ".", false);
                while (aTok.hasMoreTokens()) {
                    String aString = aTok.nextToken();
                    if (aString.equals(topType) || aList.contains(aString)) continue;
                    aList.add(aString);
                }
            }
            Collections.sort(aList);
            Iterator lI = aList.iterator();
            while (lI.hasNext()) {
                String aString = (String)lI.next();
                PObjectNode d = new PObjectNode();
                d.setParent(cc[i]);
                cc[i].addChild(d);
                d.setItem(aString);
            }
        }
        PObjectNode[] ec = new PObjectNode[bList.size()];
        for (int i3 = 0; i3 < bList.size(); ++i3) {
            ec[i3] = new PObjectNode();
            ec[i3].setItem(bList.get(i3).toString());
            ec[i3].setParent((PObjectNode)allTypeRoot);
        }
        ((PObjectNode)allTypeRoot).setChildren(ec);
        this.createModels();
        this.createTreeTables();
        this.center.setLayout(new BorderLayout());
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel leftPane = new JPanel();
        JPanel rightPane = new JPanel();
        leftPane.setLayout(gridbag);
        this.splitPane = new FlippingSplitPane(splitOrientation, leftPane, rightPane);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.center.add((Component)this.splitPane, "Center");
        Utility.buildConstraints(c, 0, 0, 1, 1, 100.0, 5.0);
        c.fill = 0;
        c.anchor = 10;
        JPanel aPanel = new JPanel();
        gridbag.setConstraints(aPanel, c);
        aPanel.add(this.avaLabel);
        aPanel.add(this.viewComboBox);
        ImageIcon newImage = IconUtilitities.getImageIcon("Forward16.gif");
        this.addButton = new JButton(newImage);
        Utility.setDescription(this.addButton, "Click to add the selected item from the Available list of equipment");
        this.addButton.setEnabled(false);
        aPanel.add(this.addButton);
        leftPane.add(aPanel);
        Utility.buildConstraints(c, 0, 1, 1, 1, 0.0, 95.0);
        c.fill = 1;
        c.anchor = 10;
        this.scrollPane = new JScrollPane(this.availableTable);
        gridbag.setConstraints(this.scrollPane, c);
        leftPane.add(this.scrollPane);
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        rightPane.setLayout(gridbag);
        Utility.buildConstraints(c, 0, 0, 1, 1, 100.0, 5.0);
        c.fill = 0;
        c.anchor = 10;
        aPanel = new JPanel();
        gridbag.setConstraints(aPanel, c);
        aPanel.add(this.selLabel);
        aPanel.add(this.viewSelectComboBox);
        newImage = IconUtilitities.getImageIcon("Back16.gif");
        this.removeButton = new JButton(newImage);
        Utility.setDescription(this.removeButton, "Click to add the selected item from the Selected list of equipment");
        this.removeButton.setEnabled(false);
        aPanel.add(this.removeButton);
        aPanel.add(this.autoSort);
        rightPane.add(aPanel);
        this.availableTable.setColAlign(1, 4);
        this.availableTable.getColumnModel().getColumn(1).setPreferredWidth(15);
        this.availableTable.setColAlign(2, 2);
        this.selectedTable.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.selectedTable.setColAlign(1, 4);
        this.selectedTable.getColumnModel().getColumn(1).setPreferredWidth(15);
        this.selectedTable.setColAlign(2, 0);
        this.selectedTable.getColumnModel().getColumn(2).setPreferredWidth(10);
        this.selectedTable.getColumnModel().getColumn(3).setCellRenderer(new OutputOrderRenderer());
        this.selectedTable.getColumnModel().getColumn(3).setPreferredWidth(20);
        Utility.buildConstraints(c, 0, 2, 1, 1, 0.0, 90.0);
        c.fill = 1;
        c.anchor = 10;
        this.scrollPane = new JScrollPane(this.selectedTable);
        gridbag.setConstraints(this.scrollPane, c);
        rightPane.add(this.scrollPane);
        TitledBorder title1 = BorderFactory.createTitledBorder(this.etched, "Equipment Info");
        title1.setTitleJustification(2);
        this.eqScroll.setBorder(title1);
        this.infoLabel.setBackground(rightPane.getBackground());
        this.eqScroll.setViewportView(this.infoLabel);
        Utility.setDescription(this.eqScroll, "Any requirements you don't meet are in italics.");
        GridBagLayout gridbag2 = new GridBagLayout();
        GridBagConstraints c2 = new GridBagConstraints();
        this.south.setLayout(gridbag2);
        this.south.setMinimumSize(new Dimension(280, 66));
        this.totalValue.setEditable(false);
        this.totalValue.setColumns(8);
        this.totalValue.setBorder(null);
        this.totalValue.setOpaque(false);
        this.gold.setColumns(9);
        JPanel fPanel = new JPanel();
        fPanel.setLayout(new BorderLayout());
        JPanel f2Panel = new JPanel();
        f2Panel.setLayout(new BorderLayout());
        f2Panel.add((Component)this.goldLabel, "West");
        f2Panel.add((Component)this.gold, "East");
        fPanel.add((Component)f2Panel, "East");
        Utility.buildConstraints(c2, 0, 0, 1, 1, 0.0, 0.0);
        c2.fill = 1;
        c2.anchor = 17;
        gridbag2.setConstraints(fPanel, c2);
        this.south.add(fPanel);
        JPanel gPanel = new JPanel();
        gPanel.setLayout(new BorderLayout());
        JPanel g2Panel = new JPanel();
        g2Panel.setLayout(new BorderLayout());
        g2Panel.add((Component)this.valueLabel, "West");
        g2Panel.add((Component)this.totalValue, "East");
        gPanel.add((Component)g2Panel, "East");
        Utility.buildConstraints(c2, 0, 1, 1, 1, 0.0, 0.0);
        c2.fill = 1;
        c2.anchor = 17;
        gridbag2.setConstraints(gPanel, c2);
        this.south.add(gPanel);
        JPanel hPanel = new JPanel();
        hPanel.setLayout(new BorderLayout());
        hPanel.add((Component)this.allowDebtBox, "West");
        hPanel.add((Component)this.costBox, "East");
        Utility.buildConstraints(c2, 0, 2, 1, 1, 0.0, 0.0);
        c2.fill = 1;
        c2.anchor = 17;
        gridbag2.setConstraints(hPanel, c2);
        this.south.add(hPanel);
        this.costBox.setSelected(SettingsHandler.getGearTab_IgnoreCost());
        this.allowDebtBox.setSelected(SettingsHandler.getGearTab_AllowDebt());
        Integer[] predefinedPercent = new Integer[5];
        for (int i4 = 0; i4 < 5; ++i4) {
            predefinedPercent[i4] = new Integer(i4 * 50);
        }
        this.cmbBuyPercent.setEditable(true);
        this.cmbSellPercent.setEditable(true);
        this.cmbBuyPercent.setModel(new DefaultComboBoxModel<Integer>(predefinedPercent));
        this.cmbSellPercent.setModel(new DefaultComboBoxModel<Integer>(predefinedPercent));
        this.cmbBuyPercent.setSelectedItem(new Integer(SettingsHandler.getGearTab_BuyRate()));
        this.cmbSellPercent.setSelectedItem(new Integer(SettingsHandler.getGearTab_SellRate()));
        this.cmbBuyPercent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (evt.getActionCommand().equals("comboBoxChanged")) {
                    int rate;
                    Object enteredRate = InfoGear.this.cmbBuyPercent.getSelectedItem();
                    if (enteredRate instanceof Integer) {
                        rate = (Integer)enteredRate;
                    } else {
                        try {
                            rate = Integer.parseInt((String)enteredRate);
                        }
                        catch (Exception exc) {
                            rate = -1;
                        }
                    }
                    if (rate < 0) {
                        rate = SettingsHandler.getGearTab_BuyRate();
                        InfoGear.this.cmbBuyPercent.setSelectedItem(new Integer(rate));
                    }
                    SettingsHandler.setGearTab_BuyRate(rate);
                }
            }
        });
        this.cmbSellPercent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (evt.getActionCommand().equals("comboBoxChanged")) {
                    int rate;
                    Object enteredRate = InfoGear.this.cmbSellPercent.getSelectedItem();
                    if (enteredRate instanceof Integer) {
                        rate = (Integer)enteredRate;
                    } else {
                        try {
                            rate = Integer.parseInt((String)enteredRate);
                        }
                        catch (Exception exc) {
                            rate = -1;
                        }
                    }
                    if (rate < 0) {
                        rate = SettingsHandler.getGearTab_SellRate();
                        InfoGear.this.cmbSellPercent.setSelectedItem(new Integer(rate));
                    }
                    SettingsHandler.setGearTab_SellRate(rate);
                }
            }
        });
        this.pnlBuy.setLayout(new BorderLayout());
        this.pnlSell.setLayout(new BorderLayout());
        this.pnlBuy.add((Component)this.lblBuyRate, "West");
        this.pnlBuy.add((Component)this.cmbBuyPercent, "East");
        this.pnlSell.add((Component)this.lblSellRate, "West");
        this.pnlSell.add((Component)this.cmbSellPercent, "East");
        Utility.buildConstraints(c2, 0, 3, 1, 1, 0.0, 0.0);
        c2.fill = 1;
        c2.anchor = 17;
        gridbag2.setConstraints(this.pnlBuy, c2);
        this.south.add((Component)this.pnlBuy, c2);
        Utility.buildConstraints(c2, 0, 4, 1, 1, 0.0, 0.0);
        c2.fill = 1;
        c2.anchor = 17;
        gridbag2.setConstraints(this.pnlSell, c2);
        this.south.add(this.pnlSell);
        this.asplit = new FlippingSplitPane(1, this.eqScroll, this.south);
        this.asplit.setOneTouchExpandable(true);
        this.asplit.setDividerSize(10);
        JPanel botPane = new JPanel();
        botPane.setLayout(new BorderLayout());
        botPane.setMinimumSize(new Dimension(200, 120));
        botPane.add((Component)this.asplit, "Center");
        this.bsplit = new FlippingSplitPane(0, this.center, botPane);
        this.bsplit.setOneTouchExpandable(true);
        this.bsplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bsplit, "Center");
        this.availableSort = new JTreeTableSorter(this.availableTable, (PObjectNode)this.availableModel.getRoot(), this.availableModel);
        this.selectedSort = new JTreeTableSorter(this.selectedTable, (PObjectNode)this.selectedModel.getRoot(), this.selectedModel);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                InfoGear.this.refresh();
            }
        });
    }

    private void openCustomizer(Equipment aEq) {
        if (aEq != null) {
            if (this.eqFrame == null) {
                this.eqFrame = new EQFrame(this.pc);
            }
            if (this.eqFrame.setEquipment(aEq)) {
                this.eqFrame.setVisible(true);
                this.eqFrame.toFront();
            }
        }
    }

    private double removeSpecifiedEquipment(Equipment selectedEquipment, double qty) {
        double sellQty = qty;
        if (sellQty < 0.0) {
            String selectedValue = JOptionPane.showInputDialog(null, "Enter Quantity", "PCGen", 3);
            if (selectedValue != null) {
                try {
                    sellQty = Float.parseFloat(selectedValue.trim());
                }
                catch (Exception e) {
                    ShowMessageDelegate.showMessageDialog("Invalid number!", "PCGen", MessageType.ERROR);
                    return 0.0;
                }
            } else {
                return 0.0;
            }
        }
        if (selectedEquipment.getChildCount() == 0) {
            if (!selectedEquipment.acceptsChildren() || CoreUtility.doublesEqual(sellQty % 1.0, 0.0)) {
                return this.adjustBelongings(selectedEquipment, -sellQty);
            }
            ShowMessageDelegate.showMessageDialog("You cannot buy, own or carry non-integral numbers of containers\ni.e. Half a sack is nonsensical.", "PCGen", MessageType.ERROR);
            return 0.0;
        }
        ShowMessageDelegate.showMessageDialog("Cannot remove container unless it is empty.", "PCGen", MessageType.ERROR);
        return 0.0;
    }

    private void resortSelected(int sort, boolean sortOrder) {
        ResortComparator comparator = new ResortComparator(sort, sortOrder, this.pc);
        int nextOutputIndex = 1;
        List eqList = this.pc.getEquipmentMasterList();
        Collections.sort(eqList, comparator);
        Iterator eI = eqList.iterator();
        while (eI.hasNext()) {
            Equipment item = (Equipment)eI.next();
            if (item.getOutputIndex() < 0) continue;
            item.setOutputIndex(nextOutputIndex++);
        }
        this.selectedModel.updateTree();
        this.selectedTable.updateUI();
        this.pc.setDirty(true);
    }

    private void searchButtonClick(JTreeTable tbl) {
        InputInterface ii = InputFactory.getInputInstance();
        Object selectedValue = ii.showInputDialog(null, "Enter the name of the item to find", "PCGen", MessageType.INFORMATION, null, this.lastSearch);
        if (selectedValue != null) {
            String aString;
            this.lastSearch = aString = (String)selectedValue;
            if (aString.length() != 0 && tbl.search(aString, true) != null) {
                tbl.requestFocus();
            }
        }
    }

    private void sellSpecifiedEquipmentRate(Equipment selectedEquipment) {
        this.sellSpecifiedEquipmentRate(selectedEquipment, selectedEquipment.qty());
    }

    private void sellSpecifiedEquipmentRate(Equipment selectedEquipment, double qty) {
        String defaultValue = this.cmbSellPercent.getSelectedItem().toString();
        InputInterface ii = InputFactory.getInputInstance();
        Object input = ii.showInputDialog(this, "Enter sell price percentage:", "Sell at Percent", MessageType.QUESTION, null, defaultValue);
        if (input != null) {
            String iString = input.toString().trim();
            try {
                int sellRate = Integer.parseInt(iString);
                this.sellSpecifiedEquipmentRate(selectedEquipment, qty, sellRate);
            }
            catch (NumberFormatException nfe) {
                ShowMessageDelegate.showMessageDialog("You must enter an integer value.", "Error", MessageType.ERROR);
            }
        }
    }

    private void sellSpecifiedEquipmentRate(Equipment selectedEquipment, double qty, int sellRate) {
        this.adjustGold(selectedEquipment, this.removeSpecifiedEquipment(selectedEquipment, qty), 0, sellRate);
    }

    private void updateAvailableModel() {
        List pathList = this.availableTable.getExpandedPaths();
        this.createAvailableModel();
        this.availableTable.updateUI();
        this.availableTable.expandPathList(pathList);
    }

    private void updateEqInfo(Equipment selectedEquipment) {
        this.updateTotalValue();
        if (selectedEquipment.hasVFeats()) {
            this.pc.setVirtualFeatsStable(false);
        }
    }

    private void updateSelectedModel() {
        List pathList = this.selectedTable.getExpandedPaths();
        this.createSelectedModel();
        this.selectedTable.updateUI();
        this.selectedTable.expandPathList(pathList);
    }

    private void updateTotalValue() {
        this.totalValue.setText(BigDecimalHelper.trimZeros(this.pc.totalValue()) + " " + Globals.getCurrencyDisplay());
    }

    private void viewComboBoxActionPerformed() {
        int index = this.viewComboBox.getSelectedIndex();
        if (index != viewMode) {
            viewMode = index;
            SettingsHandler.setGearTab_AvailableListMode(viewMode);
            this.updateAvailableModel();
        }
    }

    private void viewSelectComboBoxActionPerformed() {
        int index = this.viewSelectComboBox.getSelectedIndex();
        if (index != viewSelectMode) {
            viewSelectMode = index;
            SettingsHandler.setGearTab_SelectedListMode(viewSelectMode);
            this.updateSelectedModel();
        }
    }

    static /* synthetic */ void access$4100(InfoGear x0, JTreeTable x1) {
        x0.searchButtonClick(x1);
    }

    static /* synthetic */ void access$4200(InfoGear x0) {
        x0.customizeButtonClick();
    }

    static /* synthetic */ void access$4300(InfoGear x0) {
        x0.deleteCustomButtonClick();
    }

    static /* synthetic */ void access$4400(InfoGear x0) {
        x0.editChargesButtonClicked();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SellRateGearActionListener
    extends SelectedGearActionListener {
        SellRateGearActionListener(int qty) {
            super(qty);
        }

        protected void updateEquipment(Equipment eq, int argQty) {
            if (argQty < -1) {
                InfoGear.this.sellSpecifiedEquipmentRate(eq);
            } else {
                InfoGear.this.sellSpecifiedEquipmentRate(eq, argQty);
            }
        }
    }

    private class SellGearActionListener
    extends SelectedGearActionListener {
        SellGearActionListener(int qty) {
            super(qty);
        }

        protected void updateEquipment(Equipment eq, int argQty) {
            if (argQty < -1) {
                InfoGear.this.sellSpecifiedEquipment(eq, eq.qty());
            } else {
                InfoGear.this.sellSpecifiedEquipment(eq, argQty);
            }
        }
    }

    private static final class QuantityEditor
    extends JTextField
    implements TableCellEditor {
        private final transient List d_listeners = new ArrayList();
        private transient String d_originalValue = "";

        private QuantityEditor() {
            this.setAlignmentX(1.0f);
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public Object getCellEditorValue() {
            try {
                return new Float(this.getText());
            }
            catch (NumberFormatException nfe) {
                return new Float(this.d_originalValue);
            }
        }

        public Component getTableCellEditorComponent(JTable jTable, Object obj, boolean isSelected, int row, int column) {
            if (obj instanceof Number && (float)((Number)obj).intValue() == ((Number)obj).floatValue()) {
                this.setText(Integer.toString(((Number)obj).intValue()));
            } else if (obj != null) {
                this.setText(obj.toString());
            } else {
                this.setText("0");
            }
            this.d_originalValue = this.getText();
            jTable.setRowSelectionInterval(row, row);
            jTable.setColumnSelectionInterval(column, column);
            this.setAlignmentX(1.0f);
            this.selectAll();
            return this;
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.add(cellEditorListener);
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.remove(cellEditorListener);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        private void fireEditingCanceled() {
            this.setText(this.d_originalValue);
            ChangeEvent ce = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                ((CellEditorListener)this.d_listeners.get(i)).editingCanceled(ce);
            }
        }

        private void fireEditingStopped() {
            ChangeEvent ce = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                ((CellEditorListener)this.d_listeners.get(i)).editingStopped(ce);
            }
        }
    }

    private final class EquipmentModel
    extends AbstractTreeTableModel {
        private int currentMode = 0;
        private int modelType = 0;

        private EquipmentModel(int mode, boolean available) {
            super(null);
            if (!available) {
                this.modelType = 1;
            }
            this.resetModel(mode, available);
        }

        public boolean isCellEditable(Object node, int column) {
            return column == 0 || this.modelType == 1 && ((PObjectNode)node).getItem() instanceof Equipment && (column == 2 || column == 3);
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return class$pcgen$gui$utils$TreeTableModel == null ? (class$pcgen$gui$utils$TreeTableModel = InfoGear.class$("pcgen.gui.utils.TreeTableModel")) : class$pcgen$gui$utils$TreeTableModel;
                }
                case 1: {
                    return class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = InfoGear.class$("java.math.BigDecimal")) : class$java$math$BigDecimal;
                }
                case 2: {
                    if (this.modelType == 0) {
                        return class$java$lang$String == null ? (class$java$lang$String = InfoGear.class$("java.lang.String")) : class$java$lang$String;
                    }
                    return class$java$lang$Float == null ? (class$java$lang$Float = InfoGear.class$("java.lang.Float")) : class$java$lang$Float;
                }
                case 3: {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = InfoGear.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
            }
            Logging.errorPrint("In InfoGear.EquipmentModel.getColumnClass the column " + column + " is not supported.");
            return class$java$lang$String == null ? (class$java$lang$String = InfoGear.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            if (this.modelType == 0) {
                return 3;
            }
            return 4;
        }

        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return "Item";
                }
                case 1: {
                    return "Cost";
                }
                case 2: {
                    if (this.modelType == 0) {
                        return "Source";
                    }
                    return "Qty";
                }
                case 3: {
                    return "Order";
                }
            }
            Logging.errorPrint("In InfoGear.EquipmentModel.getColumnName the column " + column + " is not supported.");
            return "";
        }

        public Object getRoot() {
            return (PObjectNode)super.getRoot();
        }

        public void setValueAt(Object value, Object node, int column) {
            if (InfoGear.this.pc == null) {
                return;
            }
            if (this.modelType != 1) {
                return;
            }
            if (!(((PObjectNode)node).getItem() instanceof Equipment)) {
                return;
            }
            Equipment selectedEquipment = (Equipment)((PObjectNode)node).getItem();
            Equipment baseEquipment = this.getBaseEquipment(selectedEquipment);
            if (baseEquipment == null) {
                return;
            }
            switch (column) {
                case 2: {
                    double qtyToAdd = (double)((Float)value).floatValue() - selectedEquipment.qty();
                    if (qtyToAdd > 0.0) {
                        InfoGear.this.buySpecifiedEquipment(selectedEquipment, qtyToAdd);
                        break;
                    }
                    if (!(qtyToAdd < 0.0)) break;
                    InfoGear.this.sellSpecifiedEquipment(selectedEquipment, -qtyToAdd);
                    break;
                }
                case 3: {
                    int outputIndex = (Integer)value;
                    int workingIndex = 1;
                    if (outputIndex == 1000) {
                        outputIndex = InfoGear.this.getHighestOutputIndex() + 1;
                    } else if (outputIndex == 0) {
                        outputIndex = 1;
                        workingIndex = 2;
                    }
                    selectedEquipment.setOutputIndex(outputIndex);
                    Iterator i = InfoGear.this.pc.getEquipmentMasterListInOutputOrder().iterator();
                    while (i.hasNext()) {
                        Equipment item = (Equipment)i.next();
                        if (workingIndex == outputIndex) {
                            ++workingIndex;
                        }
                        if (item.getOutputIndex() <= -1 || item == selectedEquipment) continue;
                        item.setOutputIndex(workingIndex++);
                    }
                    InfoGear.this.selectedModel.updateTree();
                    InfoGear.this.selectedTable.updateUI();
                    InfoGear.this.pc.setDirty(true);
                    break;
                }
                default: {
                    Logging.errorPrint("In InfoGear.EquipmentModel.setValueAt the column " + column + " is not supported.");
                }
            }
        }

        public Object getValueAt(Object node, int column) {
            PObjectNode fn = (PObjectNode)node;
            Equipment aEq = null;
            if (fn != null && fn.getItem() instanceof Equipment) {
                aEq = (Equipment)fn.getItem();
            }
            switch (column) {
                case 0: {
                    if (fn != null) {
                        return fn.toString();
                    }
                    Logging.errorPrint("Somehow we have no active node when doing getValueAt in InfoGear.");
                    return "";
                }
                case 1: {
                    if (aEq == null) break;
                    return BigDecimalHelper.trimBigDecimal(aEq.getCost(InfoGear.this.pc));
                }
                case 2: {
                    if (fn != null && this.modelType == 0) {
                        StringBuffer b = new StringBuffer();
                        b.append("   ");
                        b.append(fn.getSource());
                        return b.toString();
                    }
                    if (aEq == null) break;
                    return new Float(aEq.qty());
                }
                case 3: {
                    int outputIndex = 0;
                    if (aEq != null) {
                        outputIndex = aEq.getOutputIndex();
                    }
                    return new Integer(outputIndex);
                }
                case -1: {
                    if (fn != null) {
                        return fn.getItem();
                    }
                    Logging.errorPrint("Somehow we have no active node when doing getValueAt in InfoGear.");
                    break;
                }
                default: {
                    Logging.errorPrint("In InfoGear.EquipmentModel.getValueAt the column " + column + " is not supported.");
                }
            }
            return null;
        }

        private Equipment getBaseEquipment(Equipment selectedEquipment) {
            String keyName = selectedEquipment.getKeyName();
            Equipment baseEquipment = EquipmentList.getEquipmentNamed(keyName);
            if (baseEquipment == null) {
                baseEquipment = InfoGear.this.pc.getEquipmentNamed(keyName);
            }
            return baseEquipment;
        }

        private void setRoot(PObjectNode aNode) {
            super.setRoot(aNode);
        }

        private void setValueForItemInNodes(PObjectNode p, Equipment e, double f, int column) {
            block7: {
                block6: {
                    if (p == null) {
                        p = (PObjectNode)super.getRoot();
                    }
                    Object obj = p.getItem();
                    if (p.getChildCount() != 0 || obj == null || !(obj instanceof Equipment) || !obj.equals(e)) break block6;
                    Equipment pe = (Equipment)obj;
                    switch (column) {
                        case 2: {
                            pe.setQty(new Float(f));
                            if ((double)pe.getCarried().floatValue() > f) {
                                pe.setNumberCarried(new Float(f));
                                break;
                            }
                            break block7;
                        }
                        default: {
                            Logging.errorPrint("In InfoGear.EquipmentModel.setValueForItemInNodes the column " + column + " is not supported.");
                            break;
                        }
                    }
                    break block7;
                }
                for (int i = 0; i < p.getChildCount(); ++i) {
                    this.setValueForItemInNodes(p.getChild(i), e, f, column);
                }
            }
        }

        private boolean addChild(Object aChild, Object aParent, boolean sort) {
            PObjectNode aFN = new PObjectNode();
            aFN.setItem(aChild);
            aFN.setParent((PObjectNode)aParent);
            if (aChild instanceof Equipment) {
                Equipment eq = (Equipment)aChild;
                aFN.setIsValid(PrereqHandler.passesAll(eq.getPreReqList(), InfoGear.this.pc, eq));
            }
            return ((PObjectNode)aParent).addChild(aFN, sort);
        }

        private void addItemToModel(Equipment aEq, boolean fireEvent) {
            PObjectNode rootAsPObjectNode = (PObjectNode)super.getRoot();
            if (aEq == null) {
                return;
            }
            if (!this.shouldDisplayThis(aEq)) {
                return;
            }
            if (fireEvent) {
                String treeType;
                int i;
                boolean bInserted = false;
                if (aEq.isType("CUSTOM")) {
                    this.addChild("CUSTOM", typeSubtypeRoot, true);
                    bInserted |= this.addChild("CUSTOM", typeRoot, true);
                    if (this.currentMode != 2) {
                        this.addChild("CUSTOM", super.getRoot(), true);
                    }
                }
                String type = aEq.typeIndex(0);
                this.addChild(type, typeSubtypeRoot, true);
                PObjectNode typeSubtypeRootAsPObjectNode = (PObjectNode)typeSubtypeRoot;
                Iterator e = aEq.typeList().iterator();
                while (e.hasNext()) {
                    type = (String)e.next();
                    for (i = 0; i < typeSubtypeRootAsPObjectNode.getChildCount(); ++i) {
                        treeType = typeSubtypeRootAsPObjectNode.getChild(i).toString();
                        if (typeSubtypeRootAsPObjectNode.getChild(i).getItem() instanceof PObject || !aEq.isType(treeType) || type.equals(treeType)) continue;
                        this.addChild(type, typeSubtypeRootAsPObjectNode.getChild(i), true);
                    }
                }
                this.addChild(type, typeRoot, true);
                e = aEq.typeList().iterator();
                while (e.hasNext()) {
                    type = (String)e.next();
                    this.addChild(type, allTypeRoot, true);
                }
                switch (this.currentMode) {
                    case 0: {
                        bInserted |= this.addChild(type, super.getRoot(), true);
                        e = aEq.typeList().iterator();
                        while (e.hasNext()) {
                            type = (String)e.next();
                            for (i = 0; i < rootAsPObjectNode.getChildCount(); ++i) {
                                treeType = rootAsPObjectNode.getChild(i).toString();
                                if (rootAsPObjectNode.getChild(i).getItem() instanceof PObject || !aEq.isType(treeType) || type.equals(treeType)) continue;
                                bInserted |= this.addChild(type, rootAsPObjectNode.getChild(i), true);
                            }
                        }
                        break;
                    }
                    case 1: {
                        bInserted |= this.addChild(type, super.getRoot(), true);
                        break;
                    }
                    case 2: {
                        break;
                    }
                    case 3: {
                        e = aEq.typeList().iterator();
                        while (e.hasNext()) {
                            type = (String)e.next();
                            bInserted |= this.addChild(type, allTypeRoot, true);
                        }
                        break;
                    }
                    default: {
                        Logging.errorPrint("In InfoGear.EquipmentModel.addItemToModel the mode " + this.currentMode + " is not supported.");
                    }
                }
            }
            switch (this.currentMode) {
                case 0: {
                    int i;
                    for (i = 0; i < rootAsPObjectNode.getChildCount(); ++i) {
                        ArrayList d;
                        if (!aEq.isType(rootAsPObjectNode.getChild(i).toString())) continue;
                        if (aEq.typeList().size() == 1) {
                            d = new ArrayList(1);
                            d.add(rootAsPObjectNode.getChild(i));
                        } else {
                            d = rootAsPObjectNode.getChild(i).getChildren();
                        }
                        for (int k = 0; d != null && k < d.size(); ++k) {
                            if (((PObjectNode)d.get(k)).getItem() instanceof PObject || !aEq.isType(((PObjectNode)d.get(k)).toString())) continue;
                            this.addChild(aEq, (PObjectNode)d.get(k), fireEvent);
                        }
                    }
                    break;
                }
                case 1: {
                    int i;
                    for (i = 0; i < rootAsPObjectNode.getChildCount(); ++i) {
                        if (!aEq.isType(rootAsPObjectNode.getChild(i).toString())) continue;
                        this.addChild(aEq, rootAsPObjectNode.getChild(i), fireEvent);
                    }
                    break;
                }
                case 2: {
                    this.addChild(aEq, super.getRoot(), fireEvent);
                    break;
                }
                case 3: {
                    int i;
                    for (i = 0; i < rootAsPObjectNode.getChildCount(); ++i) {
                        if (!aEq.isType(rootAsPObjectNode.getChild(i).toString())) continue;
                        this.addChild(aEq, rootAsPObjectNode.getChild(i), fireEvent);
                    }
                    break;
                }
                default: {
                    Logging.errorPrint("In InfoGear.EquipmentModel.addItemToModel (second switch) the mode " + this.currentMode + " is not supported.");
                }
            }
        }

        private void removeItemFromNodes(PObjectNode p, Object e) {
            if (p == null) {
                p = (PObjectNode)super.getRoot();
            }
            p.removeItemFromNodes(e);
        }

        private void resetModel(int mode, boolean available) {
            Iterator fI = available ? EquipmentList.getEquipmentList().iterator() : InfoGear.this.pc.getEquipmentMasterList().iterator();
            this.currentMode = mode;
            switch (mode) {
                case 0: {
                    this.setRoot((PObjectNode)((PObjectNode)typeSubtypeRoot).clone());
                    break;
                }
                case 1: {
                    this.setRoot((PObjectNode)((PObjectNode)typeRoot).clone());
                    break;
                }
                case 2: {
                    this.setRoot(new PObjectNode());
                    break;
                }
                case 3: {
                    this.setRoot((PObjectNode)((PObjectNode)allTypeRoot).clone());
                    break;
                }
                default: {
                    Logging.errorPrint("In InfoGear.EquipmentModel.resetModel the mode " + mode + " is not supported.");
                }
            }
            while (fI.hasNext()) {
                Equipment aEq = (Equipment)fI.next();
                this.addItemToModel(aEq, false);
            }
            PObjectNode rootAsmyPONode = (PObjectNode)super.getRoot();
            if (rootAsmyPONode.getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }

        private boolean shouldDisplayThis(Equipment equip) {
            if (this.modelType == 0) {
                return InfoGear.this.accept(InfoGear.this.pc, equip);
            }
            return true;
        }
    }

    private static final class OutputOrderRenderer
    extends DefaultTableCellRenderer {
        private OutputOrderRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel comp = (JLabel)super.getTableCellRendererComponent(jTable, value, isSelected, hasFocus, row, column);
            if (value instanceof Integer) {
                int i = (Integer)value;
                if (i == -1) {
                    comp.setText("Hidden");
                } else if (i == 0) {
                    comp.setText("");
                } else {
                    comp.setText(String.valueOf(i));
                }
            }
            return comp;
        }
    }

    private static final class OutputOrderEditor
    extends JComboBoxEx
    implements TableCellEditor {
        private final transient List d_listeners = new ArrayList();
        private transient int d_originalValue = 0;

        private OutputOrderEditor(String[] choices) {
            super(choices);
            this.setEditable(true);
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ OutputOrderEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$0.stopCellEditing();
                }
            });
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public Object getCellEditorValue() {
            switch (this.getSelectedIndex()) {
                case 0: {
                    return new Integer(0);
                }
                case 1: {
                    return new Integer(1000);
                }
                case 2: {
                    return new Integer(-1);
                }
            }
            return new Integer((String)this.getSelectedItem());
        }

        public Component getTableCellEditorComponent(JTable jTable, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                return this;
            }
            this.d_originalValue = this.getSelectedIndex();
            if (value instanceof Integer) {
                int i = (Integer)value;
                if (i == -1) {
                    this.setSelectedItem("Hidden");
                } else {
                    this.setSelectedItem(String.valueOf(i));
                }
            } else {
                this.setSelectedItem("Hidden");
            }
            jTable.setRowSelectionInterval(row, row);
            jTable.setColumnSelectionInterval(column, column);
            return this;
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.add(cellEditorListener);
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.remove(cellEditorListener);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        private void fireEditingCanceled() {
            this.setSelectedIndex(this.d_originalValue);
            ChangeEvent ce = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                ((CellEditorListener)this.d_listeners.get(i)).editingCanceled(ce);
            }
        }

        private void fireEditingStopped() {
            ChangeEvent ce = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                ((CellEditorListener)this.d_listeners.get(i)).editingStopped(ce);
            }
        }
    }

    private class GearPopupListener
    extends MouseAdapter {
        private GearPopupMenu menu;
        private JTree tree;

        private GearPopupListener(JTreeTable treeTable, GearPopupMenu aMenu) {
            this.tree = treeTable.getTree();
            this.menu = aMenu;
            KeyListener myKeyListener = new KeyListener(this){
                private final /* synthetic */ GearPopupListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTyped(KeyEvent e) {
                    GearPopupListener.access$5300(this.this$1).dispatchEvent(e);
                }

                public void keyPressed(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    if (keyCode != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                        for (int i = 0; i < GearPopupListener.access$5400(this.this$1).getComponentCount(); ++i) {
                            KeyStroke ks;
                            Component menuComponent = GearPopupListener.access$5400(this.this$1).getComponent(i);
                            if (!(menuComponent instanceof JMenuItem) || (ks = ((JMenuItem)menuComponent).getAccelerator()) == null || !keyStroke.equals(ks)) continue;
                            InfoGear.access$5502(GearPopupListener.access$5300(this.this$1), GearPopupListener.access$5600(this.this$1).getSelectionPath());
                            ((JMenuItem)menuComponent).doClick(2);
                            return;
                        }
                    }
                    GearPopupListener.access$5300(this.this$1).dispatchEvent(e);
                }

                public void keyReleased(KeyEvent e) {
                    GearPopupListener.access$5300(this.this$1).dispatchEvent(e);
                }
            };
            treeTable.addKeyListener(myKeyListener);
        }

        public void mousePressed(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        private void maybeShowPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                InfoGear.this.selPath = this.tree.getClosestPathForLocation(evt.getX(), evt.getY());
                if (InfoGear.this.selPath == null) {
                    return;
                }
                if (this.tree.isSelectionEmpty()) {
                    this.tree.setSelectionPath(InfoGear.this.selPath);
                    this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                } else if (!this.tree.isPathSelected(InfoGear.this.selPath)) {
                    this.tree.setSelectionPath(InfoGear.this.selPath);
                    this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                } else {
                    this.tree.addSelectionPath(InfoGear.this.selPath);
                    this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        }

        static /* synthetic */ InfoGear access$5300(GearPopupListener x0) {
            return x0.InfoGear.this;
        }

        static /* synthetic */ GearPopupMenu access$5400(GearPopupListener x0) {
            return x0.menu;
        }

        static /* synthetic */ JTree access$5600(GearPopupListener x0) {
            return x0.tree;
        }
    }

    private static class ResortComparator
    implements Comparator {
        public static final int RESORT_NAME = 0;
        public static final int RESORT_WEIGHT = 1;
        public static final boolean RESORT_ASCENDING = true;
        public static final boolean RESORT_DESCENDING = false;
        private boolean sortOrder = true;
        private int sort = 0;
        private PlayerCharacter pc;

        public ResortComparator(int sort, boolean sortOrder, PlayerCharacter pc) {
            this.sort = sort;
            this.sortOrder = sortOrder;
            this.pc = pc;
        }

        public int compare(Object obj1, Object obj2) {
            Equipment e2;
            Equipment e1;
            if (this.sortOrder) {
                e1 = (Equipment)obj1;
                e2 = (Equipment)obj2;
            } else {
                e1 = (Equipment)obj2;
                e2 = (Equipment)obj1;
            }
            switch (this.sort) {
                case 1: {
                    return e1.getWeight(this.pc).compareTo(e2.getWeight(this.pc));
                }
            }
            return e1.getName().compareToIgnoreCase(e2.getName());
        }
    }

    private class ResortActionListener
    implements ActionListener {
        boolean sortOrder;
        int sort;

        public ResortActionListener(int i, boolean aBool) {
            this.sort = i;
            this.sortOrder = aBool;
        }

        public void actionPerformed(ActionEvent e) {
            InfoGear.this.resortSelected(this.sort, this.sortOrder);
        }
    }

    private class RemoveGearActionListener
    extends SelectedGearActionListener {
        RemoveGearActionListener(int qty) {
            super(qty);
        }

        protected void updateEquipment(Equipment eq, int argQty) {
            if (argQty < -1) {
                InfoGear.this.removeSpecifiedEquipment(eq, eq.qty());
            } else {
                InfoGear.this.removeSpecifiedEquipment(eq, argQty);
            }
        }
    }

    private class MoveItemListener
    implements ActionListener {
        int moveType;
        int pcIndex;

        public MoveItemListener(int index, int typeOfMove) {
            this.pcIndex = index;
            this.moveType = typeOfMove;
        }

        public void actionPerformed(ActionEvent e) {
            PlayerCharacter pc = (PlayerCharacter)Globals.getPCList().get(this.pcIndex);
            Equipment eq = (Equipment)InfoGear.this.getCurrentSelectedTableItem();
            if (eq == null) {
                return;
            }
            if (this.moveType == 0) {
                pc.addEquipment(eq);
                pc.setDirty(true);
                pc.removeEquipment(eq);
                pc.setDirty(true);
            } else {
                pc.addEquipment((Equipment)eq.clone());
            }
            pc.setDirty(true);
            InfoGear.this.updateSelectedModel();
        }
    }

    private class GearPopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = -2320970658737297916L;

        private GearPopupMenu(JTreeTable treeTable) {
            if (treeTable == InfoGear.this.availableTable) {
                this.add(this.createBuyMenuItem("Buy  1", 1, "shortcut EQUALS"));
                JMenu buyMenu = Utility.createMenu("Buy # ...", '\u0000', "Buy # ...", null, true);
                buyMenu.add(this.createBuyMenuItem("Buy  2", 2, null));
                buyMenu.add(this.createBuyMenuItem("Buy  5", 5, null));
                buyMenu.add(this.createBuyMenuItem("Buy 10", 10, null));
                buyMenu.add(this.createBuyMenuItem("Buy 15", 15, null));
                buyMenu.add(this.createBuyMenuItem("Buy 20", 20, null));
                buyMenu.add(this.createBuyMenuItem("Buy 50", 50, null));
                this.add(buyMenu);
                this.add(this.createBuyMenuItem("Buy  n", -1, "alt N"));
                this.addSeparator();
                this.add(this.createBuyRateMenuItem("Buy  1 at...", 1, null));
                JMenu buyAtMenu = Utility.createMenu("Buy # at ...", '\u0000', "Buy # at ...", null, true);
                buyAtMenu.add(this.createBuyRateMenuItem("Buy  2 at...", 2, null));
                buyAtMenu.add(this.createBuyRateMenuItem("Buy  5 at...", 5, null));
                buyAtMenu.add(this.createBuyRateMenuItem("Buy 10 at...", 10, null));
                buyAtMenu.add(this.createBuyRateMenuItem("Buy 15 at...", 15, null));
                buyAtMenu.add(this.createBuyRateMenuItem("Buy 20 at...", 20, null));
                buyAtMenu.add(this.createBuyRateMenuItem("Buy 50 at...", 50, null));
                this.add(buyAtMenu);
                this.add(this.createBuyRateMenuItem("Buy  n at...", -1, "alt N"));
                this.addSeparator();
                this.add(Utility.createMenuItem("Find item", new ActionListener(this){
                    private final /* synthetic */ GearPopupMenu this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent e) {
                        InfoGear.access$4100(GearPopupMenu.access$4000(this.this$1), InfoGear.access$1000(GearPopupMenu.access$4000(this.this$1)));
                    }
                }, "searchItem", '\u0000', "shortcut F", "Find item", null, true));
                this.addSeparator();
                this.add(Utility.createMenuItem("Create custom item", new ActionListener(this){
                    private final /* synthetic */ GearPopupMenu this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent e) {
                        InfoGear.access$4200(GearPopupMenu.access$4000(this.this$1));
                    }
                }, "newCustomItem", '\u0000', "alt C", "Create new customized item", null, true));
                this.add(Utility.createMenuItem("Delete custom item", new ActionListener(this){
                    private final /* synthetic */ GearPopupMenu this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent e) {
                        InfoGear.access$4300(GearPopupMenu.access$4000(this.this$1));
                    }
                }, "deleteItem", '\u0000', "DELETE", "Delete custom item", null, true));
            } else {
                this.add(this.createRemoveMenuItem("Remove  1", 1, "shortcut MINUS"));
                JMenu remMenu = Utility.createMenu("Remove # ...", '\u0000', "Remove # ...", null, true);
                remMenu.add(this.createRemoveMenuItem("Remove  2", 2, null));
                remMenu.add(this.createRemoveMenuItem("Remove  5", 5, null));
                remMenu.add(this.createRemoveMenuItem("Remove 10", 10, null));
                remMenu.add(this.createRemoveMenuItem("Remove 15", 15, null));
                remMenu.add(this.createRemoveMenuItem("Remove 20", 20, null));
                remMenu.add(this.createRemoveMenuItem("Remove 50", 50, null));
                remMenu.add(this.createRemoveMenuItem("Remove  n", -1, null));
                this.add(remMenu);
                this.add(this.createRemoveMenuItem("Remove All", -5, null));
                this.addSeparator();
                this.add(this.createSellMenuItem("Sell  1", 1, null));
                JMenu sellMenu = Utility.createMenu("Sell # ...", '\u0000', "Sell # ...", null, true);
                sellMenu.add(this.createSellMenuItem("Sell  2", 2, null));
                sellMenu.add(this.createSellMenuItem("Sell  5", 5, null));
                sellMenu.add(this.createSellMenuItem("Sell 10", 10, null));
                sellMenu.add(this.createSellMenuItem("Sell 15", 15, null));
                sellMenu.add(this.createSellMenuItem("Sell 20", 20, null));
                sellMenu.add(this.createSellMenuItem("Sell 50", 50, null));
                sellMenu.add(this.createSellMenuItem("Sell  n", -1, null));
                this.add(sellMenu);
                this.add(this.createSellMenuItem("Sell  All", -5, null));
                this.addSeparator();
                this.add(this.createSellRateMenuItem("Sell 1 at...", 1, null));
                this.add(this.createSellRateMenuItem("Sell n at...", -1, null));
                this.add(this.createSellRateMenuItem("Sell All at...", -5, null));
                this.addSeparator();
                this.add(Utility.createMenuItem("Modify Charges", new ActionListener(this){
                    private final /* synthetic */ GearPopupMenu this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent e) {
                        InfoGear.access$4400(GearPopupMenu.access$4000(this.this$1));
                    }
                }, "editCharges", '\u0000', "shortcut ?", "Edit charges", null, true));
                this.addSeparator();
                this.add(Utility.createMenuItem("Find item", new ActionListener(this){
                    private final /* synthetic */ GearPopupMenu this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void actionPerformed(ActionEvent e) {
                        InfoGear.access$4100(GearPopupMenu.access$4000(this.this$1), InfoGear.access$4500(GearPopupMenu.access$4000(this.this$1)));
                    }
                }, "searchItem", '\u0000', "shortcut F", "Find item", null, true));
                this.addSeparator();
                this.add(InfoGear.this.pcMoveMenu);
                this.add(InfoGear.this.pcCopyMenu);
                this.addSeparator();
                JMenu resortMenu = Utility.createMenu("Output Order", '\u0000', "Output Order", null, true);
                this.add(resortMenu);
                resortMenu.add(Utility.createMenuItem("By name (ascending)", new ResortActionListener(0, true), "sortOutput", '\u0000', null, "Sort equipment list by name in ascending alphabetical order", null, true));
                resortMenu.add(Utility.createMenuItem("By name (descending)", new ResortActionListener(0, false), "sortOutput", '\u0000', null, "Sort equipment list by name in descending alphabetical order", null, true));
                resortMenu.add(Utility.createMenuItem("By weight (ascending)", new ResortActionListener(1, true), "sortOutput", '\u0000', null, "Sort equipment list by weight in ascending order", null, true));
                resortMenu.add(Utility.createMenuItem("By weight (descending)", new ResortActionListener(1, false), "sortOutput", '\u0000', null, "Sort equipment list by weight in descending order", null, true));
            }
        }

        private JMenuItem createBuyMenuItem(String label, int qty, String accelerator) {
            return Utility.createMenuItem(label, new BuyGearActionListener(qty), "Buy" + qty, '\u0000', accelerator, "Buy " + (qty < 0 ? "n" : Integer.toString(qty)) + " at the current rate", "Add16.gif", true);
        }

        private JMenuItem createBuyRateMenuItem(String label, int qty, String accelerator) {
            return Utility.createMenuItem(label, new BuyRateGearActionListener(qty), "Buy" + qty, '\u0000', accelerator, "Buy " + (qty < 0 ? "n" : Integer.toString(qty)) + " at a specified rate", "Add16.gif", true);
        }

        private JMenuItem createRemoveMenuItem(String label, int qty, String accelerator) {
            return Utility.createMenuItem(label, new RemoveGearActionListener(qty), "Remove" + qty, '\u0000', accelerator, "Remove " + (qty < 0 ? "n" : Integer.toString(qty)) + " from your inventory", "Remove16.gif", true);
        }

        private JMenuItem createSellMenuItem(String label, int qty, String accelerator) {
            return Utility.createMenuItem(label, new SellGearActionListener(qty), "Sell" + qty, '\u0000', accelerator, "Sell " + (qty < 0 ? "n" : Integer.toString(qty)) + " from your inventory", null, true);
        }

        private JMenuItem createSellRateMenuItem(String label, int qty, String accelerator) {
            return Utility.createMenuItem(label, new SellRateGearActionListener(qty), "Sell" + qty, '\u0000', accelerator, "Sell " + (qty < 0 ? "n" : Integer.toString(qty)) + " from your inventory at a rate", null, true);
        }

        static /* synthetic */ InfoGear access$4000(GearPopupMenu x0) {
            return x0.InfoGear.this;
        }
    }

    private class BuyRateGearActionListener
    extends AvailableGearActionListener {
        private BuyRateGearActionListener(int qty) {
            super(qty);
        }

        protected void updateEquipment(Equipment eq, int argQty) {
            InfoGear.this.buySpecifiedEquipmentRate(eq, argQty);
        }
    }

    private class BuyGearActionListener
    extends AvailableGearActionListener {
        private BuyGearActionListener(int qty) {
            super(qty);
        }

        protected void updateEquipment(Equipment eq, int argQty) {
            InfoGear.this.buySpecifiedEquipment(eq, argQty);
        }
    }

    private abstract class SelectedGearActionListener
    extends GearActionListener {
        private SelectedGearActionListener(int aQty) {
            super(aQty);
        }

        public void actionPerformed(ActionEvent evt) {
            Object pe = InfoGear.this.getCurrentSelectedTableItem();
            if (pe != null && pe instanceof Equipment) {
                this.updateEquipment((Equipment)pe, this.qty);
            }
        }
    }

    private abstract class AvailableGearActionListener
    extends GearActionListener {
        private AvailableGearActionListener(int aQty) {
            super(aQty);
        }

        public void actionPerformed(ActionEvent evt) {
            Object pe = InfoGear.this.getCurrentAvailableTableItem();
            if (pe != null && pe instanceof Equipment) {
                this.updateEquipment((Equipment)pe, this.qty);
            }
        }
    }

    private static abstract class GearActionListener
    implements ActionListener {
        int qty = 0;

        private GearActionListener(int aQty) {
            this.qty = aQty;
        }

        protected abstract void updateEquipment(Equipment var1, int var2);
    }
}

