/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.Component;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import pcgen.core.Constants;
import pcgen.core.GameMode;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.PToolBar;
import pcgen.gui.filter.Filterable;
import pcgen.gui.tabs.InfoEquipping;
import pcgen.gui.tabs.InfoGear;
import pcgen.gui.tabs.InfoNaturalWeapons;
import pcgen.gui.tabs.InfoResources;
import pcgen.gui.tabs.InfoTempMod;
import pcgen.util.PropertyFactory;

public final class InfoInventory
extends JTabbedPane
implements Filterable,
CharacterInfoTab {
    static final long serialVersionUID = -4186874622211290063L;
    private static final int GEAR_INDEX = 0;
    private static final int EQUIPPING_INDEX = 1;
    private static final int RESOURCES_INDEX = 2;
    private static final int TEMPMOD_INDEX = 3;
    private static final int NATURAL_INDEX = 4;
    private InfoEquipping equipment;
    private InfoGear gear;
    private InfoNaturalWeapons naturalWeapons;
    private InfoResources resources;
    private InfoTempMod tempmod;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;

    public InfoInventory(PlayerCharacter pc) {
        this.pc = pc;
        this.equipment = new InfoEquipping(pc);
        this.gear = new InfoGear(pc);
        this.resources = new InfoResources(pc);
        this.tempmod = new InfoTempMod(pc);
        this.setName(Constants.tabNames[6]);
        this.initComponents();
        this.initActionListeners();
        InfoGear.setNeedsUpdate(true);
    }

    public void setPc(PlayerCharacter pc) {
        if (this.pc != pc || pc.getSerial() > this.serial) {
            this.pc = pc;
            this.serial = pc.getSerial();
            this.forceRefresh();
        }
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Inventory.Order", 6);
    }

    public void setTabOrder(int order) {
        SettingsHandler.setPCGenOption(".Panel.Inventory.Order", order);
    }

    public String getTabName() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabName(6);
    }

    public boolean isShown() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabShown(6);
    }

    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    public void forceRefresh() {
        if (this.readyForRefresh) {
            InfoInventory.setNeedsUpdate(true);
            this.updateCharacterInfo();
            this.gear.setPc(this.pc);
            this.equipment.setPc(this.pc);
            this.resources.setPc(this.pc);
            this.tempmod.setPc(this.pc);
            if (SettingsHandler.showNaturalWeaponTab()) {
                this.naturalWeapons.forceRefresh();
            }
        } else {
            this.serial = 0;
        }
    }

    public JComponent getView() {
        return this;
    }

    public List getAvailableFilters() {
        return this.gear.getAvailableFilters();
    }

    public void setFilterMode(int mode) {
        if (this.getSelectedIndex() == 0) {
            this.gear.setFilterMode(mode);
        }
    }

    public int getFilterMode() {
        if (this.getSelectedIndex() == 0) {
            return this.gear.getFilterMode();
        }
        return 0;
    }

    public InfoGear getInfoGear() {
        return this.gear;
    }

    public boolean isMatchAnyEnabled() {
        if (this.getSelectedIndex() == 0) {
            return this.gear.isMatchAnyEnabled();
        }
        return false;
    }

    public static void setNeedsUpdate(boolean b) {
        InfoGear.setNeedsUpdate(b);
        InfoEquipping.setNeedsUpdate(b);
        InfoResources.setNeedsUpdate(b);
        InfoTempMod.setNeedsUpdate(b);
        if (SettingsHandler.showNaturalWeaponTab()) {
            InfoNaturalWeapons.setNeedsUpdate(b);
        }
    }

    public boolean isNegateEnabled() {
        if (this.getSelectedIndex() == 0) {
            return this.gear.isNegateEnabled();
        }
        return false;
    }

    public List getRemovedFilters() {
        return this.gear.getRemovedFilters();
    }

    public List getSelectedFilters() {
        return this.gear.getSelectedFilters();
    }

    public int getSelectionMode() {
        if (this.getSelectedIndex() == 0) {
            return this.gear.getSelectionMode();
        }
        return -2;
    }

    public void initializeFilters() {
        this.gear.initializeFilters();
        this.gear.setKitFilter("GEAR");
    }

    public void refreshFiltering() {
        this.gear.refreshFiltering();
    }

    private void initActionListeners() {
        this.gear.addComponentListener(PToolBar.getCurrentInstance().getComponentListener());
        this.equipment.addComponentListener(PToolBar.getCurrentInstance().getComponentListener());
        this.resources.addComponentListener(PToolBar.getCurrentInstance().getComponentListener());
        this.tempmod.addComponentListener(PToolBar.getCurrentInstance().getComponentListener());
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                ComponentEvent childEvent = new ComponentEvent(InfoInventory.this.getSelectedComponent(), 102);
                PToolBar.getCurrentInstance().getComponentListener().componentShown(childEvent);
                InfoInventory.this.refresh();
            }
        });
        this.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (InfoInventory.this.getSelectedIndex() == 0) {
                    InfoGear.setNeedsUpdate(true);
                } else if (InfoInventory.this.getSelectedIndex() == 1) {
                    InfoEquipping.setNeedsUpdate(true);
                } else if (InfoInventory.this.getSelectedIndex() == 2) {
                    InfoResources.setNeedsUpdate(true);
                } else if (InfoInventory.this.getSelectedIndex() == 3) {
                    InfoTempMod.setNeedsUpdate(true);
                }
            }
        });
    }

    private void initComponents() {
        this.readyForRefresh = true;
        this.add((Component)this.gear, 0);
        this.setTitleAt(0, PropertyFactory.getString("in_Info" + this.gear.getName()));
        this.add((Component)this.equipment, 1);
        this.setTitleAt(1, PropertyFactory.getString("in_Info" + this.equipment.getName()));
        this.add((Component)this.resources, 2);
        this.setTitleAt(2, PropertyFactory.getString("in_Info" + this.resources.getName()));
        this.add((Component)this.tempmod, 3);
        this.setTitleAt(3, PropertyFactory.getString("in_Info" + this.tempmod.getName()));
        if (SettingsHandler.showNaturalWeaponTab()) {
            this.naturalWeapons = new InfoNaturalWeapons(this.pc);
            this.add((Component)this.naturalWeapons, 4);
            this.setTitleAt(4, PropertyFactory.getString("in_Info" + this.naturalWeapons.getName()));
        }
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                InfoInventory.this.refresh();
            }
        });
    }

    private void updateCharacterInfo() {
        this.gear.forceRefresh();
        this.equipment.forceRefresh();
        this.resources.forceRefresh();
        this.tempmod.forceRefresh();
        if (SettingsHandler.showNaturalWeaponTab()) {
            this.naturalWeapons.forceRefresh();
        }
    }
}

