/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import pcgen.core.Constants;
import pcgen.core.Equipment;
import pcgen.core.GameMode;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.utils.JTableEx;
import pcgen.util.Delta;

public class InfoNaturalWeapons
extends FilterAdapterPanel
implements CharacterInfoTab {
    static final long serialVersionUID = 7796493138427983908L;
    private static boolean needsUpdate = true;
    private JScrollPane scpNaturalAttacks;
    private JTableEx tblNaturalAttacks;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;

    public InfoNaturalWeapons(PlayerCharacter pc) {
        this.pc = pc;
        this.setName(Constants.tabNames[15]);
        this.initComponents();
    }

    public void setPc(PlayerCharacter pc) {
        if (this.pc != pc || pc.getSerial() > this.serial) {
            this.pc = pc;
            this.serial = pc.getSerial();
            this.forceRefresh();
        }
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.NaturalWeapons.Order", 15);
    }

    public void setTabOrder(int order) {
        SettingsHandler.setPCGenOption(".Panel.NaturalWeapons.Order", order);
    }

    public String getTabName() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabName(15);
    }

    public boolean isShown() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabShown(15);
    }

    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    public JComponent getView() {
        return this;
    }

    public boolean isMatchAnyEnabled() {
        return true;
    }

    public static void setNeedsUpdate(boolean bNeedsUpdate) {
        needsUpdate = bNeedsUpdate;
    }

    public boolean isNegateEnabled() {
        return true;
    }

    public int getSelectionMode() {
        return 2;
    }

    public void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
        FilterFactory.registerAllSizeFilters(this);
        FilterFactory.registerAllEquipmentFilters(this);
        this.setKitFilter("NATURALWEAPON");
    }

    public void refreshFiltering() {
        this.forceRefresh();
    }

    private void updateCharacterInfo() {
        Equipment eq;
        if (!needsUpdate) {
            // empty if block
        }
        ArrayList<Equipment> naturalWeapons = new ArrayList<Equipment>();
        Iterator e = this.pc.getEquipmentMasterList().iterator();
        while (e.hasNext()) {
            eq = (Equipment)e.next();
            if (!eq.isWeapon() || !eq.isType("Natural")) continue;
            naturalWeapons.add(eq);
        }
        DefaultTableModel tblModel = (DefaultTableModel)this.tblNaturalAttacks.getModel();
        for (int i = tblModel.getRowCount() - 1; i >= 0; --i) {
            tblModel.removeRow(i);
        }
        int weaponCount = naturalWeapons.size();
        if (weaponCount == 0) {
            return;
        }
        if (weaponCount >= 1) {
            Collections.sort(naturalWeapons, new Comparator(){

                public final int compare(Object o1, Object o2) {
                    int mem2;
                    int mem1 = ((Equipment)o1).getMemberOfKit();
                    if (mem1 < (mem2 = ((Equipment)o2).getMemberOfKit())) {
                        return -1;
                    }
                    if (mem1 > mem2) {
                        return 1;
                    }
                    if (((Equipment)o1).isType("Primary")) {
                        return -1;
                    }
                    return ((Equipment)o1).getName().compareToIgnoreCase(((Equipment)o2).getName());
                }
            });
        }
        int meleeBonus = (int)this.pc.getStatBonusTo("TOHIT", "TYPE=MELEE");
        int rangeBonus = (int)this.pc.getStatBonusTo("TOHIT", "TYPE=RANGED");
        int damagBonus = (int)this.pc.getStatBonusTo("DAMAGE", "TYPE=MELEE");
        int BAB = this.pc.baseAttackBonus();
        int sizeAdj = (int)this.pc.getSizeAdjustmentBonusTo("TOHIT", "TOHIT");
        int prevKitNo = -9;
        boolean iWeaponCount = false;
        for (int i = 0; i < weaponCount; ++i) {
            eq = (Equipment)naturalWeapons.get(i);
            int wpBonus = (int)this.pc.getTotalBonusTo("WEAPONPROF=" + eq.profName(this.pc), "TOHIT");
            if (prevKitNo != eq.getMemberOfKit()) {
                iWeaponCount = false;
            }
            Object[] newRow = new Object[7];
            newRow[0] = eq.getName();
            newRow[1] = new Integer((int)eq.qty());
            StringBuffer tohitStr = new StringBuffer(12);
            int toHit = BAB + sizeAdj;
            toHit = !eq.isType("Primary") ? (toHit -= 5 - (int)this.pc.getTotalBonusTo("COMBAT", "TOHIT-SECONDARY")) : (toHit += (int)this.pc.getTotalBonusTo("COMBAT", "TOHIT-PRIMARY"));
            if (eq.isMelee()) {
                tohitStr.append(Delta.toString(toHit + meleeBonus + wpBonus));
                tohitStr.append(" melee");
            } else if (eq.isRanged()) {
                tohitStr.append(Delta.toString(toHit + rangeBonus));
                tohitStr.append(" ranged");
            }
            newRow[2] = tohitStr.toString();
            int damBonus = damagBonus;
            if (damBonus > 0) {
                if (eq.isType("Primary") && naturalWeapons.size() == 1 && (int)eq.qty() == 1) {
                    if (!eq.isRanged()) {
                        damBonus = damBonus * 3 / 2;
                    }
                } else if (eq.isType("Secondary")) {
                    damBonus /= 2;
                }
            }
            StringBuffer damage = new StringBuffer(12);
            damage.append(eq.getDamage(this.pc));
            if (damBonus != 0) {
                damage.append(Delta.toString(damBonus));
            }
            newRow[3] = damage.toString();
            newRow[4] = false;
            newRow[5] = false;
            newRow[6] = true;
            tblModel.addRow(newRow);
        }
    }

    private void initComponents() {
        this.readyForRefresh = true;
        this.scpNaturalAttacks = new JScrollPane();
        this.tblNaturalAttacks = new JTableEx();
        this.setLayout(new BorderLayout());
        this.tblNaturalAttacks.setBackground(this.getBackground());
        this.tblNaturalAttacks.setModel(new DefaultTableModel(new String[]{"Attack", "#", "To-Hit Modifier", "Damage/Attack", "Excludes Weapons", "Iterative BAB", "Enabled"}, 0){
            Class[] types = new Class[]{class$java$lang$String == null ? (class$java$lang$String = InfoNaturalWeapons.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Integer == null ? (class$java$lang$Integer = InfoNaturalWeapons.class$("java.lang.Integer")) : class$java$lang$Integer, class$java$lang$String == null ? (class$java$lang$String = InfoNaturalWeapons.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = InfoNaturalWeapons.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Boolean == null ? (class$java$lang$Boolean = InfoNaturalWeapons.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = InfoNaturalWeapons.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = InfoNaturalWeapons.class$("java.lang.Boolean")) : class$java$lang$Boolean};
            boolean[] canEdit = new boolean[]{false, false, false, false, true, true, true};

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.scpNaturalAttacks.setViewportView(this.tblNaturalAttacks);
        this.add((Component)this.scpNaturalAttacks, "Center");
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                InfoNaturalWeapons.this.refresh();
            }
        });
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

