/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.core.Constants;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfo;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.TableSorter;
import pcgen.gui.utils.Utility;
import pcgen.gui.utils.WholeNumberField;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class InfoRace
extends FilterAdapterPanel
implements CharacterInfoTab {
    static final long serialVersionUID = 2565545289875422981L;
    private static int splitOrientation = 1;
    private static boolean needsUpdate = true;
    private static final int COL_NAME = 0;
    private static final int COL_STAT = 1;
    private static final int COL_PRE = 2;
    private static final int COL_SIZE = 3;
    private static final int COL_MOVE = 4;
    private static final int COL_VISION = 5;
    private static final int COL_CLASS = 6;
    private static final int COL_LEVEL = 7;
    private AllTemplatesTableModel allTemplatesDataModel = new AllTemplatesTableModel();
    private Border etched;
    private FlippingSplitPane asplit;
    private FlippingSplitPane bsplit;
    private FlippingSplitPane splitPane;
    private JButton btnAddHD = new JButton("+");
    private JButton btnRemoveHD = new JButton("-");
    private JButton leftButton;
    private JButton rightButton;
    private JButton selButton = new JButton(PropertyFactory.getString("in_select"));
    private JComboBoxEx viewComboBox = new JComboBoxEx();
    private final JLabel avaLabel = new JLabel(PropertyFactory.getString("in_irAvaTmpl"));
    private JLabel lblHDModify = new JLabel(PropertyFactory.getString("in_sumHDToAddRem"));
    private JLabel lblMonsterHD = new JLabel(PropertyFactory.getString("in_sumMonsterHitDice"));
    private JLabel raceText = new JLabel();
    private JLabel raceTextLabel = new JLabel(PropertyFactory.getString("in_irSelectedRace"));
    private final JLabel selLabel = new JLabel(PropertyFactory.getString("in_irSelTmpl"));
    private JLabel sortLabel = new JLabel(PropertyFactory.getString("in_irSortRaces"));
    private JLabel txtMonsterHD = new JLabel("1");
    private JLabelPane infoLabel = new JLabelPane();
    private JPanel botPane = new JPanel();
    private JPanel pnlHD = new JPanel();
    private JPanel topPane = new JPanel();
    private JScrollPane allTemplatesPane;
    private JScrollPane currentTemplatesPane;
    private JTableEx allTemplatesTable;
    private JTableEx currentTemplatesTable;
    private JTreeTable raceTable;
    private JTreeTableSorter raceSort = null;
    private List currentPCdisplayTemplates = new ArrayList(0);
    private PCTemplatesTableModel currentTemplatesDataModel = new PCTemplatesTableModel();
    private RaceModel raceModel = null;
    private TableSorter sortedAllTemplatesModel = new TableSorter();
    private TableSorter sortedCurrentTemplatesModel = new TableSorter();
    private TreePath selPath;
    private WholeNumberField txtHD = new WholeNumberField(1, 3);
    private boolean hasBeenSized = false;
    private int viewMode = 0;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$pcgen$gui$utils$TreeTableModel;

    public InfoRace(PlayerCharacter pc) {
        this.pc = pc;
        this.setName(Constants.tabNames[7]);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoRace.this.initComponents();
                InfoRace.this.initActionListeners();
            }
        });
    }

    public void setPc(PlayerCharacter pc) {
        if (this.pc != pc || pc.getSerial() > this.serial) {
            this.pc = pc;
            this.serial = pc.getSerial();
            this.forceRefresh();
        }
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Race.Order", 7);
    }

    public void setTabOrder(int order) {
        SettingsHandler.setPCGenOption(".Panel.Race.Order", order);
    }

    public String getTabName() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabName(7);
    }

    public boolean isShown() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabShown(7);
    }

    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    public JComponent getView() {
        return this;
    }

    public final boolean isMatchAnyEnabled() {
        return true;
    }

    public static void setNeedsUpdate(boolean flag) {
        needsUpdate = flag;
    }

    public void pushUpdate() {
        PCGen_Frame1 rootFrame = PCGen_Frame1.getInst();
        rootFrame.featList_Changed();
        rootFrame.hpTotal_Changed();
        PCGen_Frame1.forceUpdate_PlayerTabs();
        CharacterInfo pane = PCGen_Frame1.getCharacterPane();
        pane.setPaneForUpdate(pane.infoSkills());
        pane.setPaneForUpdate(pane.infoSpells());
        pane.setPaneForUpdate(pane.infoDomain());
        pane.setPaneForUpdate(pane.infoInventory());
        pane.setPaneForUpdate(pane.infoSummary());
        pane.refresh();
    }

    public final boolean isNegateEnabled() {
        return true;
    }

    public final int getSelectionMode() {
        return 2;
    }

    public final void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
        FilterFactory.registerAllSizeFilters(this);
        FilterFactory.registerAllRaceFilters(this);
        FilterFactory.registerAllPrereqAlignmentFilters(this);
    }

    public final void refreshFiltering() {
        this.createModel();
        this.raceTable.updateUI();
        this.allTemplatesDataModel.updateModel();
    }

    private final void createTreeTables() {
        this.raceTable = new JTreeTable(this.raceModel);
        this.raceTable.setSelectionMode(0);
        final JTree atree = this.raceTable.getTree();
        atree.setRootVisible(false);
        atree.setShowsRootHandles(true);
        atree.setCellRenderer(new LabelTreeCellRenderer());
        this.raceTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int idx = InfoRace.getSelectedIndex(e);
                    if (idx < 0) {
                        return;
                    }
                    Object temp = atree.getPathForRow(idx).getLastPathComponent();
                    if (temp == null) {
                        return;
                    }
                    PObjectNode fNode = (PObjectNode)temp;
                    if (fNode.getItem() instanceof Race) {
                        Race aRace = (Race)fNode.getItem();
                        InfoRace.this.setInfoLabelText(aRace);
                    }
                }
            }
        });
        MouseAdapter aml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int avaRow = atree.getRowForLocation(e.getX(), e.getY());
                TreePath avaPath = atree.getPathForLocation(e.getX(), e.getY());
                if (avaRow != -1) {
                    if (e.getClickCount() == 1 && avaPath != null) {
                        atree.setSelectionPath(avaPath);
                    } else if (e.getClickCount() == 2) {
                        InfoRace.this.selButton();
                    }
                }
            }
        };
        atree.addMouseListener(aml);
        this.hookupPopupMenu(this.raceTable);
    }

    private void setInfoLabelText(Race aRace) {
        StringBuffer b = new StringBuffer();
        b.append("<html>");
        if (aRace != null && !aRace.getName().startsWith("<none")) {
            b.append("<b>").append(aRace.piSubString()).append("</b>");
            b.append(" &nbsp;<b>TYPE</b>:").append(aRace.getType());
            String bString = aRace.getSource();
            if (bString.length() > 0) {
                b.append(" &nbsp;<b>SOURCE</b>:").append(bString);
            }
        }
        b.append("</html>");
        this.infoLabel.setText(b.toString());
    }

    private static int getSelectedIndex(ListSelectionEvent e) {
        DefaultListSelectionModel model = (DefaultListSelectionModel)e.getSource();
        if (model == null) {
            return -1;
        }
        return model.getMinSelectionIndex();
    }

    private void addTemplate() {
        if (this.allTemplatesTable.getSelectedRowCount() <= 0) {
            return;
        }
        this.pc.setDirty(true);
        PCTemplate theTmpl = this.allTemplatesDataModel.get(this.sortedAllTemplatesModel.getRowTranslated(this.allTemplatesTable.getSelectedRow()));
        if (theTmpl != null && theTmpl.isQualified(this.pc)) {
            PCTemplate aTmpl = this.pc.getTemplateNamed(theTmpl.getName());
            if (aTmpl == null) {
                this.pc.addTemplate(theTmpl);
                this.pushUpdate();
                this.allTemplatesDataModel.updateModel();
            } else {
                JOptionPane.showMessageDialog(null, PropertyFactory.getString("in_irHaveTemplate"));
            }
        }
        this.currentTemplatesDataModel.setFilter(this.currentTemplatesDataModel.curFilter);
    }

    private final void createModel() {
        if (this.raceModel == null) {
            this.raceModel = new RaceModel(this.viewMode);
        } else {
            this.raceModel.resetModel(this.viewMode);
        }
        if (this.raceSort != null) {
            this.raceSort.setRoot((PObjectNode)this.raceModel.getRoot());
            this.raceSort.sortNodeOnColumn();
        }
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.getStatusBar().setText(PropertyFactory.getString("in_irSelectRace"));
        this.refresh();
        int s = this.splitPane.getDividerLocation();
        int t = this.bsplit.getDividerLocation();
        int u = this.asplit.getDividerLocation();
        if (!this.hasBeenSized) {
            int width;
            TableColumn sCol;
            int i;
            s = SettingsHandler.getPCGenOption("InfoRace.splitPane", (int)(this.getSize().getWidth() * 75.0 / 100.0));
            t = SettingsHandler.getPCGenOption("InfoRace.bsplit", (int)(this.getSize().getHeight() - 120.0));
            u = SettingsHandler.getPCGenOption("InfoRace.asplit", (int)(this.getSize().getWidth() * 75.0 / 100.0));
            for (i = 0; i < this.raceTable.getColumnCount(); ++i) {
                sCol = this.raceTable.getColumnModel().getColumn(i);
                width = Globals.getCustColumnWidth("Race", i);
                if (width != 0) {
                    sCol.setPreferredWidth(width);
                }
                sCol.addPropertyChangeListener(new ResizeColumnListener(this.raceTable, "Race", i));
            }
            for (i = 0; i < this.allTemplatesTable.getColumnCount(); ++i) {
                sCol = this.allTemplatesTable.getColumnModel().getColumn(i);
                width = Globals.getCustColumnWidth("Tamplate", i);
                if (width != 0) {
                    sCol.setPreferredWidth(width);
                }
                sCol.addPropertyChangeListener(new ResizeColumnListener(this.allTemplatesTable, "Tamplate", i));
            }
            if (s > 0) {
                this.hasBeenSized = true;
            }
        }
        if (s > 0) {
            this.splitPane.setDividerLocation(s);
            SettingsHandler.setPCGenOption("InfoRace.splitPane", s);
        }
        if (t > 0) {
            this.bsplit.setDividerLocation(t);
            SettingsHandler.setPCGenOption("InfoRace.bsplit", t);
        }
        if (u > 0) {
            this.asplit.setDividerLocation(u);
            SettingsHandler.setPCGenOption("InfoRace.asplit", u);
        }
    }

    private void hookupPopupMenu(JTreeTable treeTable) {
        treeTable.addMouseListener(new RacePopupListener(treeTable, new RacePopupMenu()));
    }

    private void hookupTemplatePopupMenu(JTableEx table) {
        table.addMouseListener(new TemplatePopupListener(table, new TemplatePopupMenu(table)));
    }

    private void initActionListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                InfoRace.this.formComponentShown();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                int s = InfoRace.this.splitPane.getDividerLocation();
                if (s > 0) {
                    SettingsHandler.setPCGenOption("InfoRace.splitPane", s);
                }
                if ((s = InfoRace.this.asplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoRace.asplit", s);
                }
                if ((s = InfoRace.this.bsplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoRace.bsplit", s);
                }
            }
        });
        this.selButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoRace.this.selButton();
            }
        });
        this.leftButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoRace.this.removeTemplate();
            }
        });
        this.rightButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoRace.this.addTemplate();
            }
        });
        this.viewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoRace.this.viewComboBoxActionPerformed();
            }
        });
        FilterFactory.restoreFilterSettings(this);
        this.currentTemplatesDataModel.setFilter(this.currentTemplatesDataModel.curFilter);
    }

    private void initComponents() {
        this.readyForRefresh = true;
        int iView = SettingsHandler.getRaceTab_ListMode();
        if (iView >= 0 && iView <= 2) {
            this.viewMode = iView;
        }
        SettingsHandler.setRaceTab_ListMode(this.viewMode);
        this.viewComboBox.addItem(PropertyFactory.getString("in_nameLabel") + "   ");
        this.viewComboBox.addItem(PropertyFactory.getString("in_type") + "   ");
        this.viewComboBox.addItem(PropertyFactory.getString("in_source") + " ");
        this.viewComboBox.setSelectedIndex(this.viewMode);
        this.raceModel = new RaceModel(this.viewMode);
        this.createTreeTables();
        this.topPane.setLayout(new BorderLayout());
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel leftPane = new JPanel();
        JPanel rightPane = new JPanel();
        leftPane.setLayout(gridbag);
        rightPane.setLayout(gridbag);
        this.splitPane = new FlippingSplitPane(splitOrientation, leftPane, rightPane);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.topPane.add((Component)this.splitPane, "Center");
        Utility.buildConstraints(c, 0, 0, 1, 1, 100.0, 5.0);
        c.fill = 0;
        c.anchor = 10;
        JPanel aPanel = new JPanel();
        gridbag.setConstraints(aPanel, c);
        JPanel tPanel = new JPanel();
        tPanel.add(this.sortLabel);
        tPanel.add(this.viewComboBox);
        this.raceText.setPreferredSize(new Dimension(120, 25));
        this.raceText.setBorder(BorderFactory.createEtchedBorder());
        this.raceText.setHorizontalAlignment(0);
        tPanel.add(this.raceTextLabel);
        tPanel.add(this.raceText);
        tPanel.add(this.selButton);
        aPanel.setLayout(new GridBagLayout());
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 3;
        c.fill = 2;
        aPanel.add((Component)tPanel, c);
        this.pnlHD.setLayout(new FlowLayout(0));
        this.pnlHD.add(this.lblHDModify);
        this.pnlHD.add(this.txtHD);
        this.pnlHD.add(this.btnAddHD);
        this.pnlHD.add(this.btnRemoveHD);
        c = new GridBagConstraints();
        c.gridx = 2;
        c.gridy = 1;
        c.anchor = 13;
        c.weightx = 0.3;
        aPanel.add((Component)this.pnlHD, c);
        c = new GridBagConstraints();
        c.gridx = 1;
        c.gridy = 1;
        c.fill = 2;
        c.anchor = 17;
        aPanel.add((Component)this.txtMonsterHD, c);
        c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 1;
        c.anchor = 13;
        aPanel.add((Component)this.lblMonsterHD, c);
        this.btnAddHD.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PCGen_Frame1.addMonsterHD(1);
                InfoRace.this.updateHD();
            }
        });
        this.btnRemoveHD.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                PCGen_Frame1.addMonsterHD(-1);
                InfoRace.this.updateHD();
            }
        });
        leftPane.add(aPanel);
        Utility.buildConstraints(c, 0, 1, 1, 1, 100.0, 95.0);
        c.fill = 1;
        c.anchor = 10;
        JScrollPane scrollPane = new JScrollPane(this.raceTable);
        gridbag.setConstraints(scrollPane, c);
        this.raceTable.setColAlign(3, 0);
        this.raceTable.setColAlign(7, 0);
        leftPane.add(scrollPane);
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        rightPane.setLayout(gridbag);
        Utility.buildConstraints(c, 0, 0, 1, 1, 1.0, 1.0);
        c.fill = 1;
        c.anchor = 10;
        JScrollPane rScroll = new JScrollPane();
        gridbag.setConstraints(rScroll, c);
        TitledBorder title1 = BorderFactory.createTitledBorder(this.etched, PropertyFactory.getString("in_irRaceInfo"));
        title1.setTitleJustification(2);
        rScroll.setBorder(title1);
        this.infoLabel.setBackground(this.topPane.getBackground());
        rScroll.setViewportView(this.infoLabel);
        rightPane.add(rScroll);
        this.botPane.setLayout(new BorderLayout());
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        JPanel bLeftPane = new JPanel();
        JPanel bRightPane = new JPanel();
        bLeftPane.setLayout(gridbag);
        bRightPane.setLayout(gridbag);
        this.asplit = new FlippingSplitPane(1, bLeftPane, bRightPane);
        this.asplit.setOneTouchExpandable(true);
        this.asplit.setDividerSize(10);
        this.botPane.add((Component)this.asplit, "Center");
        Utility.buildConstraints(c, 0, 0, 1, 1, 1.0, 1.0);
        c.fill = 2;
        c.anchor = 11;
        aPanel = new JPanel();
        gridbag.setConstraints(aPanel, c);
        aPanel.add(this.avaLabel);
        ImageIcon newImage = IconUtilitities.getImageIcon("Forward16.gif");
        this.rightButton = new JButton(newImage);
        Utility.setDescription(this.rightButton, PropertyFactory.getString("in_irTemplAddTip"));
        this.rightButton.setEnabled(true);
        aPanel.add(this.rightButton);
        bLeftPane.add(aPanel);
        Utility.buildConstraints(c, 0, 1, 1, 1, 10.0, 10.0);
        c.fill = 1;
        c.anchor = 11;
        this.allTemplatesTable = new JTableEx();
        this.allTemplatesPane = new JScrollPane(this.allTemplatesTable);
        gridbag.setConstraints(this.allTemplatesPane, c);
        MouseAdapter aml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    InfoRace.this.addTemplate();
                }
            }
        };
        this.allTemplatesTable.addMouseListener(aml);
        this.sortedAllTemplatesModel.setModel(this.allTemplatesDataModel);
        this.allTemplatesTable.setModel(this.sortedAllTemplatesModel);
        this.allTemplatesPane.setViewportView(this.allTemplatesTable);
        this.allTemplatesTable.setSelectionMode(0);
        this.hookupTemplatePopupMenu(this.allTemplatesTable);
        bLeftPane.add(this.allTemplatesPane);
        this.allTemplatesTable.setColAlign(0, 0);
        this.allTemplatesTable.setColAlign(2, 0);
        Utility.buildConstraints(c, 0, 0, 1, 1, 1.0, 1.0);
        c.fill = 2;
        c.anchor = 11;
        JPanel bPanel = new JPanel();
        gridbag.setConstraints(bPanel, c);
        bPanel.add(this.selLabel);
        newImage = IconUtilitities.getImageIcon("Back16.gif");
        this.leftButton = new JButton(newImage);
        Utility.setDescription(this.leftButton, PropertyFactory.getString("in_irTemplRemoveTip"));
        this.leftButton.setEnabled(true);
        bPanel.add(this.leftButton);
        bRightPane.add(bPanel);
        Utility.buildConstraints(c, 0, 1, 1, 1, 10.0, 10.0);
        c.fill = 1;
        c.anchor = 11;
        this.currentTemplatesPane = new JScrollPane();
        gridbag.setConstraints(this.currentTemplatesPane, c);
        this.currentTemplatesTable = new JTableEx();
        this.sortedCurrentTemplatesModel.setModel(this.currentTemplatesDataModel);
        this.sortedCurrentTemplatesModel.addMouseListenerToHeaderInTable(this.currentTemplatesTable);
        aml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    InfoRace.this.removeTemplate();
                }
            }
        };
        this.currentTemplatesTable.addMouseListener(aml);
        this.currentTemplatesTable.setModel(this.sortedCurrentTemplatesModel);
        this.currentTemplatesTable.setSelectionMode(0);
        this.currentTemplatesTable.setDoubleBuffered(false);
        this.currentTemplatesPane.setViewportView(this.currentTemplatesTable);
        this.hookupTemplatePopupMenu(this.currentTemplatesTable);
        bRightPane.add(this.currentTemplatesPane);
        this.bsplit = new FlippingSplitPane(0, this.topPane, this.botPane);
        this.bsplit.setOneTouchExpandable(true);
        this.bsplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bsplit, "Center");
        this.raceSort = new JTreeTableSorter(this.raceTable, (PObjectNode)this.raceModel.getRoot(), this.raceModel);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                InfoRace.this.refresh();
            }
        });
    }

    private void removeTemplate() {
        if (this.currentTemplatesTable.getSelectedRowCount() <= 0) {
            return;
        }
        this.pc.setDirty(true);
        PCTemplate theTmpl = (PCTemplate)this.currentPCdisplayTemplates.get(this.sortedCurrentTemplatesModel.getRowTranslated(this.currentTemplatesTable.getSelectedRow()));
        if (!theTmpl.isRemovable()) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_irNotRemovable"), "PCGen", MessageType.ERROR);
            return;
        }
        this.pc.removeTemplate(theTmpl);
        this.pushUpdate();
        this.allTemplatesDataModel.updateModel();
        this.currentTemplatesDataModel.setFilter(this.currentTemplatesDataModel.curFilter);
    }

    private void selButton() {
        TreePath aPath = this.raceTable.getTree().getSelectionPath();
        if (aPath == null) {
            return;
        }
        Object endComp = aPath.getLastPathComponent();
        PObjectNode fNode = (PObjectNode)endComp;
        if (!(fNode.getItem() instanceof Race)) {
            return;
        }
        Race aRace = (Race)fNode.getItem();
        if (aRace == null) {
            return;
        }
        Race oldRace = this.pc.getRace();
        if (!aRace.equals(oldRace)) {
            this.pc.setRace(aRace);
            PCGen_Frame1.forceUpdate_PlayerTabs();
            CharacterInfo pane = PCGen_Frame1.getCharacterPane();
            pane.setPaneForUpdate(pane.infoClasses());
            pane.setPaneForUpdate(pane.infoFeats());
            pane.setPaneForUpdate(pane.infoSkills());
            pane.setPaneForUpdate(pane.infoSpells());
            pane.setPaneForUpdate(pane.infoSummary());
            pane.refresh();
            if (this.pc.getRace().hitDice(this.pc) != 0) {
                this.pc.getRace().rollHP(this.pc);
            }
            this.allTemplatesDataModel.updateModel();
            this.currentTemplatesDataModel.setFilter(this.currentTemplatesDataModel.curFilter);
            this.raceText.setText(this.pc.getRace().piString());
            this.raceText.setMinimumSize(new Dimension(120, 25));
            this.setInfoLabelText(this.pc.getRace());
            if (this.pnlHD.isVisible()) {
                this.updateHD();
            }
        }
    }

    private final void updateCharacterInfo() {
        this.lblMonsterHD.setVisible(SettingsHandler.hideMonsterClasses());
        this.txtMonsterHD.setVisible(SettingsHandler.hideMonsterClasses());
        this.lblHDModify.setVisible(SettingsHandler.hideMonsterClasses());
        this.pnlHD.setVisible(SettingsHandler.hideMonsterClasses());
        if (!needsUpdate) {
            return;
        }
        try {
            this.raceText.setText(this.pc.getRace().piString());
            this.raceText.setMinimumSize(new Dimension(120, 25));
            this.setInfoLabelText(this.pc.getRace());
        }
        catch (Exception exc) {
            this.raceText.setText("");
            this.setInfoLabelText(null);
        }
        this.allTemplatesDataModel.updateModel();
        this.currentTemplatesDataModel.setFilter(this.currentTemplatesDataModel.curFilter);
        this.createModel();
        this.raceTable.updateUI();
        if (this.pnlHD.isVisible()) {
            this.updateHD();
            this.txtHD.setValue(1);
        }
        needsUpdate = false;
    }

    private void updateHD() {
        String monsterClass;
        int monsterHD = -1;
        int minLevel = 0;
        if (this.pc != null && (monsterClass = this.pc.getRace().getMonsterClass(this.pc, false)) != null) {
            monsterHD = this.pc.getRace().hitDice(this.pc);
            minLevel = this.pc.getRace().hitDice(this.pc) + this.pc.getRace().getMonsterClassLevels(this.pc);
            PCClass aClass = this.pc.getClassNamed(monsterClass);
            if (aClass != null) {
                monsterHD += aClass.getLevel();
            }
        }
        this.btnAddHD.setEnabled(this.pc.getRace().hasAdvancement() && monsterHD >= 0);
        this.btnRemoveHD.setEnabled(monsterHD > minLevel);
        if (monsterHD < 0) {
            monsterHD = 0;
        }
        this.txtMonsterHD.setText(Integer.toString(monsterHD));
        this.txtHD.setEnabled(this.btnAddHD.isEnabled() | this.btnRemoveHD.isEnabled());
    }

    private void viewComboBoxActionPerformed() {
        int index = this.viewComboBox.getSelectedIndex();
        if (index != this.viewMode) {
            this.viewMode = index;
            SettingsHandler.setRaceTab_ListMode(this.viewMode);
            this.createModel();
            this.raceTable.updateUI();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class RacePopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = 2565545289875422981L;

        RacePopupMenu() {
            this.add(this.createAddMenuItem(PropertyFactory.getString("in_select"), "shortcut EQUALS"));
        }

        private JMenuItem createAddMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new AddRaceActionListener(), PropertyFactory.getString("in_select"), '\u0000', accelerator, PropertyFactory.getString("in_irSelRaceTip"), "Add16.gif", true);
        }

        private class RaceActionListener
        implements ActionListener {
            private RaceActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
            }
        }

        private class AddRaceActionListener
        extends RaceActionListener {
            private AddRaceActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoRace.this.selButton();
            }
        }
    }

    private class RacePopupListener
    extends MouseAdapter {
        private JTree tree;
        private RacePopupMenu menu;

        RacePopupListener(JTreeTable treeTable, RacePopupMenu aMenu) {
            this.tree = treeTable.getTree();
            this.menu = aMenu;
            KeyListener myKeyListener = new KeyListener(this){
                private final /* synthetic */ RacePopupListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTyped(KeyEvent e) {
                    RacePopupListener.access$3200(this.this$1).dispatchEvent(e);
                }

                public void keyPressed(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    if (keyCode != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                        for (int i = 0; i < RacePopupListener.access$3300(this.this$1).getComponentCount(); ++i) {
                            KeyStroke ks;
                            Component menuComponent = RacePopupListener.access$3300(this.this$1).getComponent(i);
                            if (!(menuComponent instanceof JMenuItem) || (ks = ((JMenuItem)menuComponent).getAccelerator()) == null || !keyStroke.equals(ks)) continue;
                            InfoRace.access$3402(RacePopupListener.access$3200(this.this$1), RacePopupListener.access$3500(this.this$1).getSelectionPath());
                            ((JMenuItem)menuComponent).doClick(2);
                            return;
                        }
                    }
                    RacePopupListener.access$3200(this.this$1).dispatchEvent(e);
                }

                public void keyReleased(KeyEvent e) {
                    RacePopupListener.access$3200(this.this$1).dispatchEvent(e);
                }
            };
            treeTable.addKeyListener(myKeyListener);
        }

        public void mousePressed(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        private void maybeShowPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                InfoRace.this.selPath = this.tree.getClosestPathForLocation(evt.getX(), evt.getY());
                if (InfoRace.this.selPath == null) {
                    return;
                }
                this.tree.setSelectionPath(InfoRace.this.selPath);
                this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        static /* synthetic */ InfoRace access$3200(RacePopupListener x0) {
            return x0.InfoRace.this;
        }

        static /* synthetic */ RacePopupMenu access$3300(RacePopupListener x0) {
            return x0.menu;
        }

        static /* synthetic */ JTree access$3500(RacePopupListener x0) {
            return x0.tree;
        }
    }

    private final class RaceModel
    extends AbstractTreeTableModel {
        private PObjectNode raceRoot;
        private final String[] raceNameList = new String[]{PropertyFactory.getString("in_nameLabel"), PropertyFactory.getString("in_irTableStat"), PropertyFactory.getString("in_preReqs"), PropertyFactory.getString("in_size"), PropertyFactory.getString("in_speed"), PropertyFactory.getString("in_vision"), PropertyFactory.getString("in_favoredClass"), PropertyFactory.getString("in_lvlAdj")};
        private List raceList = new ArrayList();
        private List sourceList = new ArrayList();
        private List typeList = new ArrayList();

        private RaceModel(int mode) {
            super(null);
            this.resetModel(mode);
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return class$pcgen$gui$utils$TreeTableModel == null ? (class$pcgen$gui$utils$TreeTableModel = InfoRace.class$("pcgen.gui.utils.TreeTableModel")) : class$pcgen$gui$utils$TreeTableModel;
            }
            return class$java$lang$String == null ? (class$java$lang$String = InfoRace.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            return this.raceNameList.length;
        }

        public String getColumnName(int column) {
            return this.raceNameList[column];
        }

        public Object getRoot() {
            return (PObjectNode)super.getRoot();
        }

        public Object getValueAt(Object node, int column) {
            PObjectNode fn = (PObjectNode)node;
            Race race = null;
            String sRet = "";
            if (fn == null) {
                Logging.errorPrint("No active node when doing getValueAt in InfoRace");
                return null;
            }
            if (fn.getItem() instanceof Race) {
                race = (Race)fn.getItem();
            }
            switch (column) {
                case 0: {
                    return fn.toString();
                }
                case 1: {
                    if (race == null) {
                        return null;
                    }
                    StringBuffer aString = new StringBuffer();
                    for (int i = 0; i < SettingsHandler.getGame().s_ATTRIBSHORT.length; ++i) {
                        if (race.isNonAbility(i)) {
                            if (aString.length() > 0) {
                                aString.append(' ');
                            }
                            aString.append(SettingsHandler.getGame().s_ATTRIBSHORT[i]).append(":Nonability");
                            continue;
                        }
                        if (race.getStatMod(i, InfoRace.this.pc) == 0) continue;
                        if (aString.length() > 0) {
                            aString.append(' ');
                        }
                        aString.append(SettingsHandler.getGame().s_ATTRIBSHORT[i]).append(':').append(race.getStatMod(i, InfoRace.this.pc));
                    }
                    sRet = aString.toString();
                    break;
                }
                case 2: {
                    if (race == null) {
                        return null;
                    }
                    sRet = race.preReqHTMLStrings(InfoRace.this.pc);
                    break;
                }
                case 3: {
                    if (race == null) {
                        return null;
                    }
                    sRet = race.getSize();
                    break;
                }
                case 4: {
                    if (race == null) {
                        return null;
                    }
                    if (race.getNumberOfMovements() <= 0) break;
                    StringBuffer movelabel = new StringBuffer(race.getMovementType(0)).append(' ').append(race.getMovement(0)).append(Globals.getDistanceUnit());
                    for (int i = 1; i < race.getNumberOfMovements(); ++i) {
                        movelabel.append(", ").append(race.getMovementType(i)).append(' ').append(race.getMovement(i)).append(Globals.getDistanceUnit());
                    }
                    sRet = movelabel.toString();
                    break;
                }
                case 5: {
                    if (race == null) {
                        return null;
                    }
                    sRet = race.getDisplayVision(InfoRace.this.pc);
                    break;
                }
                case 6: {
                    if (race == null) {
                        return null;
                    }
                    sRet = !".".equals(race.getFavoredClass()) ? race.getFavoredClass() : PropertyFactory.getString("in_various");
                    break;
                }
                case 7: {
                    if (race == null) {
                        return null;
                    }
                    return new Integer(race.getLevelAdjustment(InfoRace.this.pc));
                }
                default: {
                    Logging.errorPrint("In InfoRace.RaceModel.getValueAt the column " + column + " is not supported.");
                }
            }
            return sRet;
        }

        private void setRoot(PObjectNode aNode) {
            super.setRoot(aNode);
        }

        private void resetModel(int mode) {
            this.raceList.clear();
            Iterator it = Globals.getRaceMap().values().iterator();
            while (it.hasNext()) {
                Race aRace = (Race)it.next();
                if (!InfoRace.this.accept(InfoRace.this.pc, aRace)) continue;
                if (!this.raceList.contains(aRace)) {
                    this.raceList.add(aRace);
                }
                if (!this.typeList.contains(aRace.getType())) {
                    this.typeList.add(aRace.getType());
                }
                if (this.sourceList.contains(aRace.getSourceNoPage()) || aRace.getSourceNoPage().length() <= 0) continue;
                this.sourceList.add(aRace.getSourceNoPage());
            }
            this.raceRoot = new PObjectNode();
            this.setRoot(this.raceRoot);
            switch (mode) {
                case 0: {
                    PObjectNode[] rn = new PObjectNode[this.raceList.size()];
                    for (int iName = 0; iName < this.raceList.size(); ++iName) {
                        Race aRace = (Race)this.raceList.get(iName);
                        if (aRace == null) continue;
                        rn[iName] = new PObjectNode();
                        rn[iName].setItem(aRace);
                        rn[iName].setParent(this.raceRoot);
                    }
                    this.raceRoot.setChildren(rn);
                    break;
                }
                case 1: {
                    PObjectNode[] rt = new PObjectNode[this.typeList.size()];
                    for (int iType = 0; iType < this.typeList.size(); ++iType) {
                        String aType = (String)this.typeList.get(iType);
                        rt[iType] = new PObjectNode();
                        rt[iType].setItem(aType);
                        Iterator fI = Globals.getRaceMap().values().iterator();
                        while (fI.hasNext()) {
                            Race aRace = (Race)fI.next();
                            if (aRace == null || !aRace.getType().equals(aType)) continue;
                            PObjectNode aFN = new PObjectNode();
                            aFN.setItem(aRace);
                            aFN.setParent(rt[iType]);
                            rt[iType].addChild(aFN);
                        }
                        if (rt[iType].isLeaf()) continue;
                        rt[iType].setParent(this.raceRoot);
                    }
                    this.raceRoot.setChildren(rt);
                    break;
                }
                case 2: {
                    PObjectNode[] rs = new PObjectNode[this.sourceList.size()];
                    for (int iSource = 0; iSource < this.sourceList.size(); ++iSource) {
                        String aSource = (String)this.sourceList.get(iSource);
                        rs[iSource] = new PObjectNode();
                        rs[iSource].setItem(aSource);
                        Iterator fI = Globals.getRaceMap().values().iterator();
                        while (fI.hasNext()) {
                            Race aRace = (Race)fI.next();
                            if (aRace == null || !aRace.getSourceNoPage().equals(aSource)) continue;
                            PObjectNode aFN = new PObjectNode();
                            aFN.setItem(aRace);
                            aFN.setParent(rs[iSource]);
                            rs[iSource].addChild(aFN);
                        }
                        if (rs[iSource].isLeaf()) continue;
                        rs[iSource].setParent(this.raceRoot);
                    }
                    this.raceRoot.setChildren(rs);
                    break;
                }
                default: {
                    Logging.errorPrint("In InfoRace.RaceModel.resetModel the mode " + mode + " is not supported.");
                }
            }
            PObjectNode rootAsPObjectNode = (PObjectNode)super.getRoot();
            if (rootAsPObjectNode.getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }
    }

    private class TemplatePopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = 2565545289875422981L;

        TemplatePopupMenu(JTableEx table) {
            if (table == InfoRace.this.allTemplatesTable) {
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_irAddTemplate"), "shortcut EQUALS"));
            } else {
                this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_irRemoveTemplate"), "shortcut MINUS"));
            }
        }

        private JMenuItem createAddMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new AddTemplateActionListener(), PropertyFactory.getString("in_select"), '\u0000', accelerator, PropertyFactory.getString("in_irAddTemplateTip"), "Add16.gif", true);
        }

        private JMenuItem createRemoveMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new RemoveTemplateActionListener(), PropertyFactory.getString("in_select"), '\u0000', accelerator, PropertyFactory.getString("in_irRemoveTemplateTip"), "Remove16.gif", true);
        }

        private class TemplateActionListener
        implements ActionListener {
            private TemplateActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
            }
        }

        private class RemoveTemplateActionListener
        extends TemplateActionListener {
            private RemoveTemplateActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoRace.this.removeTemplate();
            }
        }

        private class AddTemplateActionListener
        extends TemplateActionListener {
            private AddTemplateActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoRace.this.addTemplate();
            }
        }
    }

    private class TemplatePopupListener
    extends MouseAdapter {
        private JTableEx table;
        private TemplatePopupMenu menu;

        TemplatePopupListener(JTableEx aTable, TemplatePopupMenu aMenu) {
            this.table = aTable;
            this.menu = aMenu;
            KeyListener myKeyListener = new KeyListener(this){
                private final /* synthetic */ TemplatePopupListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTyped(KeyEvent e) {
                    TemplatePopupListener.access$2400(this.this$1).dispatchEvent(e);
                }

                public void keyPressed(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    if (keyCode != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                        for (int i = 0; i < TemplatePopupListener.access$2500(this.this$1).getComponentCount(); ++i) {
                            KeyStroke ks;
                            Component menuComponent = TemplatePopupListener.access$2500(this.this$1).getComponent(i);
                            if (!(menuComponent instanceof JMenuItem) || (ks = ((JMenuItem)menuComponent).getAccelerator()) == null || !keyStroke.equals(ks)) continue;
                            ((JMenuItem)menuComponent).doClick(2);
                            return;
                        }
                    }
                    TemplatePopupListener.access$2400(this.this$1).dispatchEvent(e);
                }

                public void keyReleased(KeyEvent e) {
                    TemplatePopupListener.access$2400(this.this$1).dispatchEvent(e);
                }
            };
            this.table.addKeyListener(myKeyListener);
        }

        public void mousePressed(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        private void maybeShowPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                Point p = evt.getPoint();
                int rowIndex = this.table.rowAtPoint(p);
                this.table.setRowSelectionInterval(rowIndex, rowIndex);
                this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        static /* synthetic */ InfoRace access$2400(TemplatePopupListener x0) {
            return x0.InfoRace.this;
        }

        static /* synthetic */ TemplatePopupMenu access$2500(TemplatePopupListener x0) {
            return x0.menu;
        }
    }

    private final class PCTemplatesTableModel
    extends AbstractTableModel {
        static final long serialVersionUID = 2565545289875422981L;
        private int curFilter;
        private int prevGlobalTemplateCount;

        private PCTemplatesTableModel() {
        }

        public Class getColumnClass(int columnIndex) {
            return class$java$lang$String == null ? (class$java$lang$String = InfoRace.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Template";
                }
                case 1: {
                    return "Removable";
                }
            }
            Logging.errorPrint("In InfoRace.PCTemplatesTableModel.getColumnName the column " + columnIndex + " is not supported.");
            return "Out Of Bounds";
        }

        public int getRowCount() {
            return InfoRace.this.currentPCdisplayTemplates.size();
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (InfoRace.this.pc != null && InfoRace.this.pc.getTemplateList() != null) {
                PCTemplate t = (PCTemplate)InfoRace.this.currentPCdisplayTemplates.get(rowIndex);
                switch (columnIndex) {
                    case 0: {
                        return t.toString();
                    }
                    case 1: {
                        return t.isRemovable() ? "Yes" : "No";
                    }
                }
                Logging.errorPrint("In InfoRace.PCTemplatesTableModel.getValueAt the column " + columnIndex + " is not supported.");
            }
            return null;
        }

        private void setFilter(int filterID) {
            if (InfoRace.this.pc == null) {
                InfoRace.this.currentPCdisplayTemplates = new ArrayList(0);
            } else {
                this.prevGlobalTemplateCount = InfoRace.this.pc.getTemplateList().size();
                InfoRace.this.currentPCdisplayTemplates = new ArrayList(this.prevGlobalTemplateCount);
                switch (filterID) {
                    case 0: {
                        Iterator it = InfoRace.this.pc.getTemplateList().iterator();
                        while (it.hasNext()) {
                            PCTemplate pcTmpl = (PCTemplate)it.next();
                            if (pcTmpl.isVisible() != 1 && pcTmpl.isVisible() != 3) continue;
                            InfoRace.this.currentPCdisplayTemplates.add(pcTmpl);
                        }
                        break;
                    }
                    case 1: {
                        Iterator it = InfoRace.this.pc.getTemplateList().iterator();
                        while (it.hasNext()) {
                            PCTemplate pcTmpl = (PCTemplate)it.next();
                            if (pcTmpl.isVisible() != 0 && pcTmpl.isVisible() != 2) continue;
                            InfoRace.this.currentPCdisplayTemplates.add(pcTmpl);
                        }
                        break;
                    }
                    case 2: {
                        InfoRace.this.currentPCdisplayTemplates.addAll(InfoRace.this.pc.getTemplateList());
                        break;
                    }
                    default: {
                        Logging.errorPrint("In InfoRace.PCTemplatesTableModel.setFilter the filter ID " + filterID + " is not supported.");
                    }
                }
            }
            this.fireTableDataChanged();
            this.curFilter = filterID;
        }
    }

    private final class AllTemplatesTableModel
    extends AbstractTableModel {
        static final long serialVersionUID = 2565545289875422981L;
        private List displayTemplates = new ArrayList();
        private final String[] ALL_TEMPLATES_COLUMN_NAMES = new String[]{PropertyFactory.getString("in_Q"), PropertyFactory.getString("in_nameLabel"), PropertyFactory.getString("in_lvlAdj"), PropertyFactory.getString("in_modifier"), PropertyFactory.getString("in_preReqs"), PropertyFactory.getString("in_source")};
        private int curFilter;
        private int prevGlobalTemplateCount;

        private AllTemplatesTableModel() {
            this.updateModel();
        }

        public Class getColumnClass(int columnIndex) {
            return class$java$lang$String == null ? (class$java$lang$String = InfoRace.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            return this.ALL_TEMPLATES_COLUMN_NAMES.length;
        }

        public String getColumnName(int columnIndex) {
            return columnIndex >= 0 && columnIndex < this.ALL_TEMPLATES_COLUMN_NAMES.length ? this.ALL_TEMPLATES_COLUMN_NAMES[columnIndex] : "Out Of Bounds";
        }

        public int getRowCount() {
            if (this.prevGlobalTemplateCount != Globals.getTemplateList().size()) {
                this.updateFilter();
            }
            return this.displayTemplates != null ? this.displayTemplates.size() : 0;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (this.displayTemplates != null) {
                PCTemplate selectedTemplate = (PCTemplate)this.displayTemplates.get(rowIndex);
                PCTemplate pcTemplate = InfoRace.this.pc.getTemplateNamed(selectedTemplate.toString());
                if (pcTemplate != null) {
                    selectedTemplate = pcTemplate;
                }
                switch (columnIndex) {
                    case 0: {
                        return selectedTemplate.isQualified(InfoRace.this.pc) ? "Y" : "N";
                    }
                    case 1: {
                        return selectedTemplate.toString();
                    }
                    case 2: {
                        return "" + selectedTemplate.getLevelAdjustment(InfoRace.this.pc);
                    }
                    case 3: {
                        return selectedTemplate.modifierString(InfoRace.this.pc);
                    }
                    case 4: {
                        return selectedTemplate.preReqStrings();
                    }
                    case 5: {
                        return selectedTemplate.getSource();
                    }
                }
                Logging.errorPrint("In InfoRace.AllTemplatesTableModel.getValueAt the column " + columnIndex + " is not supported.");
            }
            return null;
        }

        private void setFilter(int filterID) {
            this.prevGlobalTemplateCount = Globals.getTemplateList().size();
            this.displayTemplates = new ArrayList();
            switch (filterID) {
                case 0: {
                    Iterator it = Globals.getTemplateList().iterator();
                    while (it.hasNext()) {
                        PCTemplate pcTmpl = (PCTemplate)it.next();
                        if (pcTmpl.isVisible() != 1 && pcTmpl.isVisible() != 3) continue;
                        this.displayTemplates.add(pcTmpl);
                    }
                    break;
                }
                case 1: {
                    Iterator it = Globals.getTemplateList().iterator();
                    while (it.hasNext()) {
                        PCTemplate pcTmpl = (PCTemplate)it.next();
                        if (pcTmpl.isVisible() != 1 && pcTmpl.isVisible() != 3 || !pcTmpl.isQualified(InfoRace.this.pc)) continue;
                        this.displayTemplates.add(pcTmpl);
                    }
                    break;
                }
                default: {
                    Logging.errorPrint("In InfoRace.AllTemplatesTableModel.setFilter the filter ID " + filterID + " is not supported.");
                }
            }
            this.fireTableDataChanged();
            this.curFilter = filterID;
        }

        private PCTemplate get(int index) {
            return (PCTemplate)this.displayTemplates.get(index);
        }

        private void updateFilter() {
            this.setFilter(this.curFilter);
        }

        private void updateModel() {
            this.displayTemplates.clear();
            Iterator it = Globals.getTemplateList().iterator();
            while (it.hasNext()) {
                PCTemplate aPCTemplate = (PCTemplate)it.next();
                if (aPCTemplate.isVisible() % 2 != 1 || !InfoRace.this.accept(InfoRace.this.pc, aPCTemplate)) continue;
                this.displayTemplates.add(aPCTemplate);
            }
            this.fireTableDataChanged();
        }
    }
}

