/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.core.Constants;
import pcgen.core.Equipment;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.character.CompanionMod;
import pcgen.core.character.Follower;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfo;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.Utility;
import pcgen.io.PCGIOHandler;
import pcgen.util.Logging;

public class InfoResources
extends FilterAdapterPanel
implements CharacterInfoTab {
    static final long serialVersionUID = 7236403406005940947L;
    private static boolean needsUpdate = true;
    private static final int MODEL_AVAILABLE = 0;
    private static final int MODEL_SELECTED = 1;
    private Border etched;
    private FlippingSplitPane botSplit = new FlippingSplitPane(1);
    private FlippingSplitPane centerSplit = new FlippingSplitPane(0);
    private FlippingSplitPane topSplit = new FlippingSplitPane(1);
    private FollowerModel availableModel = null;
    private FollowerModel selectedModel = null;
    private JButton addButton = new JButton();
    private JButton addModButton = new JButton();
    private JButton delButton = new JButton();
    private JButton delModButton = new JButton();
    private JButton loadButton = new JButton();
    private JButton updateButton = new JButton();
    private JCheckBox shouldLoadCompanion = new JCheckBox("Auto load companions");
    private final JLabel modeLabel = new JLabel("Select Type of Resource:");
    private JComboBoxEx viewModeBox = new JComboBoxEx();
    private final JLabel sortLabel = new JLabel("Sort");
    private JComboBoxEx viewSortBox = new JComboBoxEx();
    private JLabelPane followerInfo = new JLabelPane();
    private JLabelPane infoLabel = new JLabelPane();
    private JPanel botPane = new JPanel();
    private JPanel followerPane = new JPanel();
    private JPanel masterPane = new JPanel();
    private JPanel modePane = new JPanel();
    private JPanel topPane = new JPanel();
    private JTreeTable availableTable;
    private JTreeTable selectedTable;
    private JTreeTableSorter availableSort = null;
    private JTreeTableSorter selectedSort = null;
    private TreePath selPath;
    private boolean hasBeenSized = false;
    private int viewMode = 0;
    private int viewSortMode = 0;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;
    static /* synthetic */ Class class$pcgen$gui$utils$TreeTableModel;
    static /* synthetic */ Class class$java$lang$String;

    public InfoResources(PlayerCharacter pc) {
        this.pc = pc;
        this.setName(Constants.tabNames[13]);
        this.initComponents();
        this.initActionListeners();
    }

    public void setPc(PlayerCharacter pc) {
        if (this.pc != pc || pc.getSerial() > this.serial) {
            this.pc = pc;
            this.serial = pc.getSerial();
            this.forceRefresh();
        }
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Resources.Order", 13);
    }

    public void setTabOrder(int order) {
        SettingsHandler.setPCGenOption(".Panel.Resources.Order", order);
    }

    public String getTabName() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabName(13);
    }

    public boolean isShown() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabShown(13);
    }

    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    public JComponent getView() {
        return this;
    }

    public final boolean isMatchAnyEnabled() {
        return true;
    }

    public static void setNeedsUpdate(boolean flag) {
        needsUpdate = flag;
    }

    public final boolean isNegateEnabled() {
        return true;
    }

    public final int getSelectionMode() {
        return -2;
    }

    public final void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
    }

    public final void refreshFiltering() {
        this.updateAvailableModel();
        this.updateSelectedModel();
    }

    public final void updateCharacterInfo() {
        if (this.pc == null || !needsUpdate) {
            return;
        }
        this.shouldLoadCompanion.setSelected(this.pc.getLoadCompanion());
        if (this.pc.getMaster() != null) {
            this.setFollowerInfo(this.pc);
            this.remove(this.masterPane);
            this.add((Component)this.followerPane, "Center");
            this.followerPane.setVisible(true);
            this.masterPane.setVisible(false);
            this.followerPane.updateUI();
            this.updateUI();
        } else {
            this.updateAvailableModel();
            this.updateSelectedModel();
            this.remove(this.followerPane);
            this.add((Component)this.masterPane, "Center");
            this.masterPane.setVisible(true);
            this.followerPane.setVisible(false);
            this.followerPane.updateUI();
            this.masterPane.updateUI();
            this.updateUI();
        }
        needsUpdate = false;
    }

    private void setFollowerInfo(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof PlayerCharacter) {
            Follower aF = this.pc.getMaster();
            PlayerCharacter mPC = null;
            Iterator p = Globals.getPCList().iterator();
            while (p.hasNext()) {
                PlayerCharacter nPC = (PlayerCharacter)p.next();
                if (!aF.getFileName().equals(nPC.getFileName())) continue;
                mPC = nPC;
            }
            if (mPC == null) {
                this.followerInfo.setText("NOTICE: Load Master from File to display info");
                return;
            }
            StringBuffer b = new StringBuffer();
            b.append("<html>");
            b.append(InfoResources.followerStatBlock(aF, this.pc));
            PlayerCharacter curPC = Globals.getCurrentPC();
            Globals.setCurrentPC(mPC);
            b.append("<p>");
            b.append("<font size=+1><b>Master Information</b></font><br>");
            b.append("<b>PC Name:</b> ").append(mPC.getName());
            b.append("<br>");
            b.append("<b>File:</b> ").append(mPC.getFileName());
            b.append("<br>");
            b.append("<b>Race:</b> ").append(mPC.getRace());
            b.append("<br>");
            b.append("<b>").append(Globals.getGameModeHPAbbrev()).append("</b>: ").append(mPC.hitPoints());
            b.append("<br>");
            int bonus = mPC.baseAttackBonus();
            b.append("<b>BAB</b>: ").append(bonus >= 0 ? "+" : "").append(bonus);
            b.append("<br>");
            b.append("</html>");
            Globals.setCurrentPC(curPC);
            this.followerInfo.setText(b.toString());
            this.followerInfo.setVisible(true);
            this.followerInfo.repaint();
        }
    }

    private void addButton() {
        if ("".equals(this.pc.getFileName())) {
            ShowMessageDelegate.showMessageDialog("You must save the current character first", "PCGen", MessageType.ERROR);
            return;
        }
        TreePath avaCPath = this.availableTable.getTree().getSelectionPath();
        TreePath selCPath = this.selectedTable.getTree().getSelectionPath();
        if (selCPath == null) {
            ShowMessageDelegate.showMessageDialog("First select destination", "PCGen", MessageType.ERROR);
            return;
        }
        String target = selCPath.getPathComponent(1).toString();
        Object endComp = avaCPath.getLastPathComponent();
        PObjectNode fNode = (PObjectNode)endComp;
        if (fNode.getItem() instanceof Race) {
            int iConfirm;
            Race aRace = (Race)fNode.getItem();
            if (aRace == null) {
                return;
            }
            Logging.errorPrint("addButton:race: " + aRace.getName() + " -> " + target);
            String nValue = JOptionPane.showInputDialog(null, "Please enter a name for new " + target + ":", "PCGen", 3);
            if (nValue == null) {
                return;
            }
            String nName = nValue.trim();
            JFileChooser fc = new JFileChooser();
            fc.setDialogTitle("Save new " + target + " named: " + nName);
            fc.setSelectedFile(new File(SettingsHandler.getPcgPath(), nName + ".pcg"));
            fc.setCurrentDirectory(SettingsHandler.getPcgPath());
            if (fc.showSaveDialog(this) != 0) {
                return;
            }
            File file = fc.getSelectedFile();
            if (!file.getName().endsWith(".pcg")) {
                file = new File(file.getParent(), file.getName() + ".pcg");
            }
            if (file.exists() && (iConfirm = JOptionPane.showConfirmDialog(null, "The file " + file.getName() + " already exists. Are you sure you want to overwrite it?", "Confirm OverWrite", 0)) != 0) {
                return;
            }
            PlayerCharacter newPC = new PlayerCharacter();
            newPC.setName(nName);
            newPC.setFileName(file.getAbsolutePath());
            Iterator i = newPC.getStatList().getStats().iterator();
            while (i.hasNext()) {
                PCStat aStat = (PCStat)i.next();
                aStat.setBaseScore(10);
            }
            newPC.setAlignment(this.pc.getAlignment(), true, true);
            newPC.setRace(aRace);
            if (newPC.getRace().hitDice(this.pc) != 0) {
                newPC.getRace().rollHP(this.pc);
            }
            newPC.setDirty(true);
            String aType = target;
            Follower newMaster = new Follower(this.pc.getFileName(), this.pc.getName(), aType);
            newPC.setMaster(newMaster, Globals.getCurrentPC());
            Follower newFollower = new Follower(file.getAbsolutePath(), nName, aType);
            newFollower.setRace(newPC.getRace().getName());
            this.pc.addFollower(newFollower);
            this.pc.setDirty(true);
            this.pc.setCalcFollowerBonus(Globals.getCurrentPC());
            this.pc.setAggregateFeatsStable(false);
            this.pc.setVirtualFeatsStable(false);
            ShowMessageDelegate.showMessageDialog("Saving " + nName + " and switching tabs", "PCGen", MessageType.INFORMATION);
            try {
                new PCGIOHandler().write(newPC, file.getAbsolutePath());
            }
            catch (Exception ex) {
                ShowMessageDelegate.showMessageDialog("Could not save " + newPC.getDisplayName(), "PCGen", MessageType.ERROR);
                Logging.errorPrint("Could not save " + newPC.getDisplayName(), ex);
                return;
            }
            InfoResources.setNeedsUpdate(true);
            Globals.getCurrentPC().calcActiveBonuses();
            PCGen_Frame1.getInst().loadPCFromFile(file);
            Globals.getCurrentPC().calcActiveBonuses();
            CharacterInfo pane = PCGen_Frame1.getCharacterPane();
            pane.setPaneForUpdate(pane.infoSummary());
            pane.refresh();
        } else if (fNode.getItem() instanceof Equipment) {
            Equipment eqI = (Equipment)fNode.getItem();
            if (eqI == null) {
                return;
            }
            Logging.errorPrint("addButton:item: " + eqI.getName() + " -> " + target);
            this.pc.setDirty(true);
            this.updateSelectedModel();
        }
    }

    private void addFileButton() {
        if ("".equals(this.pc.getFileName())) {
            ShowMessageDelegate.showMessageDialog("You must save the current character first", "PCGen", MessageType.ERROR);
            return;
        }
        TreePath selCPath = this.selectedTable.getTree().getSelectionPath();
        if (selCPath == null) {
            ShowMessageDelegate.showMessageDialog("First select destination", "PCGen", MessageType.ERROR);
            return;
        }
        String target = selCPath.getPathComponent(1).toString();
        File file = null;
        if ((file = this.findPCGFile(file)) == null || !file.exists()) {
            return;
        }
        PlayerCharacter newPC = null;
        PlayerCharacter oldPC = this.pc;
        int oldIndex = PCGen_Frame1.getBaseTabbedPane().getSelectedIndex();
        int newIndex = PCGen_Frame1.FIRST_CHAR_TAB;
        Iterator i = Globals.getPCList().iterator();
        while (i.hasNext()) {
            PlayerCharacter iPC = (PlayerCharacter)i.next();
            if (iPC.getFileName().equals(file.toString())) {
                Logging.errorPrint("already open");
                PCGen_Frame1.getBaseTabbedPane().setSelectedIndex(newIndex);
                newPC = iPC;
                break;
            }
            ++newIndex;
        }
        if (newPC == null && PCGen_Frame1.getInst().loadPCFromFile(file)) {
            newPC = Globals.getCurrentPC();
        } else if (newPC == null) {
            Logging.errorPrint("Unable to load " + file.toString());
            Globals.setCurrentPC(oldPC);
            return;
        }
        String aType = target;
        Follower newMaster = new Follower(oldPC.getFileName(), oldPC.getName(), aType);
        newPC.setMaster(newMaster, Globals.getCurrentPC());
        Follower newFollower = new Follower(file.getAbsolutePath(), newPC.getName(), aType);
        newFollower.setRace(newPC.getRace().getName());
        oldPC.addFollower(newFollower);
        oldPC.setDirty(true);
        newPC.setDirty(true);
        PCGen_Frame1.getInst().savePC(oldPC, false);
        PCGen_Frame1.getInst().savePC(newPC, false);
        PCGen_Frame1.getBaseTabbedPane().setSelectedIndex(oldIndex);
        PCGen_Frame1.getInst().revertToSavedItem_actionPerformed(null);
        InfoResources.setNeedsUpdate(true);
        CharacterInfo pane = PCGen_Frame1.getCharacterPane();
        pane.setPaneForUpdate(pane.infoInventory());
        pane.refresh();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoResources.this.formComponentShown();
            }
        });
    }

    private final void createAvailableModel() {
        if (this.availableModel == null) {
            this.availableModel = new FollowerModel(this.viewSortMode, true);
        } else {
            this.availableModel.resetModel(this.viewSortMode, true);
        }
        if (this.availableSort != null) {
            this.availableSort.setRoot((PObjectNode)this.availableModel.getRoot());
        }
    }

    private void createFollowerView() {
        this.followerPane.setLayout(new BorderLayout());
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new FlowLayout(1, 2, 2));
        this.updateButton.setText("Update from Master");
        this.updateButton.setEnabled(true);
        aPanel.add(this.updateButton);
        this.followerPane.add((Component)aPanel, "North");
        JScrollPane scrollPane = new JScrollPane(this.followerInfo);
        TitledBorder sTitle = BorderFactory.createTitledBorder(this.etched, "Follower Information");
        sTitle.setTitleJustification(2);
        scrollPane.setBorder(sTitle);
        this.followerInfo.setBackground(this.topPane.getBackground());
        scrollPane.setViewportView(this.followerInfo);
        scrollPane.setVisible(true);
        this.followerPane.add((Component)scrollPane, "Center");
        this.followerPane.setVisible(true);
    }

    private void createMasterView() {
        this.masterPane.setLayout(new BorderLayout());
        this.masterPane.setBorder(BorderFactory.createEtchedBorder());
        this.topPane.setLayout(new BorderLayout());
        JPanel leftPane = new JPanel();
        JPanel rightPane = new JPanel();
        leftPane.setLayout(new BorderLayout());
        rightPane.setLayout(new BorderLayout());
        this.topSplit.setLeftComponent(leftPane);
        this.topSplit.setRightComponent(rightPane);
        this.topSplit.setOneTouchExpandable(true);
        this.topSplit.setDividerSize(10);
        this.topSplit.setBorder(BorderFactory.createEtchedBorder());
        JPanel aPanel = new JPanel();
        JPanel alPanel = new JPanel();
        aPanel.setLayout(new BorderLayout(4, 0));
        alPanel.setLayout(new FlowLayout(1, 8, 0));
        this.shouldLoadCompanion.setSelected(this.pc.getLoadCompanion());
        aPanel.add((Component)this.shouldLoadCompanion, "West");
        alPanel.add(this.sortLabel);
        alPanel.add(this.viewSortBox);
        ImageIcon newImage = IconUtilitities.getImageIcon("Forward16.gif");
        this.addButton.setIcon(newImage);
        Utility.setDescription(this.addButton, "Click to add");
        this.addButton.setEnabled(false);
        alPanel.add(this.addButton);
        aPanel.add((Component)alPanel, "Center");
        leftPane.add((Component)aPanel, "North");
        JScrollPane scrollPane = new JScrollPane(this.availableTable);
        Utility.setDescription(scrollPane, "Right click to add");
        leftPane.add((Component)scrollPane, "Center");
        this.availableTable.setColAlign(1, 0);
        this.availableTable.setColAlign(4, 0);
        aPanel = new JPanel();
        aPanel.setLayout(new FlowLayout(1, 8, 0));
        newImage = IconUtilitities.getImageIcon("Back16.gif");
        this.delButton.setIcon(newImage);
        Utility.setDescription(this.delButton, "Click to remove from List");
        this.delButton.setEnabled(false);
        aPanel.add(this.delButton);
        this.loadButton.setText("Load...");
        this.loadButton.setEnabled(false);
        aPanel.add(this.loadButton);
        rightPane.add((Component)aPanel, "North");
        scrollPane = new JScrollPane(this.selectedTable);
        Utility.setDescription(scrollPane, "Right click to remove");
        rightPane.add((Component)scrollPane, "Center");
        this.topPane.add((Component)this.topSplit, "Center");
        this.botPane.setLayout(new BorderLayout());
        JScrollPane bLeftPane = new JScrollPane(this.infoLabel);
        JPanel bRightPane = new JPanel();
        this.botSplit.setLeftComponent(bLeftPane);
        this.botSplit.setRightComponent(bRightPane);
        this.botSplit.setOneTouchExpandable(true);
        this.botSplit.setDividerSize(10);
        this.botPane.add((Component)this.botSplit, "Center");
        TitledBorder sTitle = BorderFactory.createTitledBorder(this.etched, "Information");
        sTitle.setTitleJustification(2);
        bLeftPane.setBorder(sTitle);
        this.infoLabel.setBackground(this.topPane.getBackground());
        bLeftPane.setViewportView(this.infoLabel);
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new FlowLayout(1, 0, 0));
        this.addModButton.setText("Add Modifier");
        this.addModButton.setEnabled(false);
        iPanel.add(this.addModButton);
        this.delModButton.setText("Delete Modifier");
        this.delModButton.setEnabled(false);
        iPanel.add(this.delModButton);
        bRightPane.add(iPanel);
        this.centerSplit.setTopComponent(this.topPane);
        this.centerSplit.setBottomComponent(this.botPane);
        this.centerSplit.setOneTouchExpandable(true);
        this.centerSplit.setDividerSize(10);
        this.modePane.setLayout(new FlowLayout(1, 0, 0));
        this.modePane.add((Component)this.modeLabel, null);
        this.modePane.add((Component)this.viewModeBox, null);
        this.masterPane.add((Component)this.modePane, "North");
        this.masterPane.add((Component)this.centerSplit, "Center");
    }

    private static String followerStatBlock(Follower aF, PlayerCharacter newPC) {
        PlayerCharacter curPC = Globals.getCurrentPC();
        Globals.setCurrentPC(newPC);
        StringBuffer b = new StringBuffer();
        b.append("<font size=+1><b>Name:</b> ");
        b.append(newPC.getName()).append("</font>");
        b.append("<br>");
        b.append("<b>Type:</b> ").append(aF.getType());
        b.append("<br>");
        b.append("<b>Race:</b> ").append(newPC.getRace());
        b.append("<br>");
        for (int i = 0; i < SettingsHandler.getGame().s_ATTRIBSHORT.length; ++i) {
            b.append("<b>").append(SettingsHandler.getGame().s_ATTRIBSHORT[i]).append("</b>: ").append(newPC.getStatList().getTotalStatFor(SettingsHandler.getGame().s_ATTRIBSHORT[i])).append(" ");
        }
        b.append("<br>");
        if (Globals.getGameModeACText().length() != 0) {
            b.append("<b>").append(Globals.getGameModeACText()).append("</b> ");
            b.append("<i>Total</i>: ").append(newPC.getACTotal());
            b.append(" <i>Flatfooted</i>: ").append(newPC.flatfootedAC());
            b.append(" <i>Touch</i>: ").append(newPC.touchAC());
            b.append("<br>");
        } else {
            b.append("<b>AC</b> ");
            b.append("<i>Total</i>: ").append((int)newPC.getTotalBonusTo("COMBAT", "AC"));
            b.append("<br>");
        }
        int initMod = newPC.initiativeMod();
        b.append("<b>Init</b>: ").append(initMod >= 0 ? "+" : "").append(initMod);
        b.append("<br>");
        int bonus = newPC.baseAttackBonus();
        b.append(" <b>BAB</b>: ").append(bonus >= 0 ? "+" : "").append(bonus);
        b.append("<br>");
        b.append(" <b>").append(Globals.getGameModeHPAbbrev()).append("</b>: ").append(newPC.hitPoints());
        if (Globals.getGameModeAltHPText().length() != 0) {
            b.append(" <b>").append(Globals.getGameModeAltHPAbbrev()).append("</b>: ").append(newPC.altHP());
        }
        b.append("<br>");
        b.append("<b>Saves</b>: ");
        for (int z = 0; z < SettingsHandler.getGame().getUnmodifiableCheckList().size(); ++z) {
            bonus = (int)newPC.getBonus(z + 1, true);
            b.append(" <i>").append(SettingsHandler.getGame().getUnmodifiableCheckList().get(z).toString()).append("</i>: ").append(bonus >= 0 ? "+" : "").append(bonus);
        }
        b.append("<br>");
        bonus = newPC.getSR();
        if (bonus > 0) {
            b.append("<b>Spell Resistance</b>: ").append(newPC.getSR());
        }
        b.append("<br>");
        b.append("<b>Special Abilities:</b>");
        b.append("<ul>");
        Iterator ii = newPC.getSpecialAbilityListStrings().iterator();
        while (ii.hasNext()) {
            String sa = (String)ii.next();
            b.append("<li>").append(sa).append("</li>");
        }
        b.append("</ul>");
        b.append("<br>");
        Globals.setCurrentPC(curPC);
        return b.toString();
    }

    private void setInfoText(Object obj) {
        if (obj == null) {
            return;
        }
        if (obj instanceof Race) {
            Race aRace = (Race)obj;
            if (aRace.getName().startsWith("<none")) {
                return;
            }
            StringBuffer b = new StringBuffer();
            String bString = "";
            b.append("<html><font size=+1><b>").append(aRace.getName()).append("</b></font>");
            b.append("  <b>Type:</b>").append(aRace.getType());
            if (aRace.getNumberOfMovements() > 0) {
                StringBuffer movelabel = new StringBuffer(aRace.getMovementType(0)).append(" ").append(aRace.getMovement(0)).append(Globals.getDistanceUnit()).append(" ");
                for (int i = 1; i < aRace.getNumberOfMovements(); ++i) {
                    movelabel.append(aRace.getMovementType(i)).append(" ").append(aRace.getMovement(i)).append(Globals.getDistanceUnit()).append(" ");
                }
                bString = movelabel.toString();
            }
            if (bString.length() > 0) {
                b.append(" <b>Move</b>:").append(bString);
            }
            if ((bString = aRace.getSize()).length() > 0) {
                b.append(" <b>Size</b>:").append(bString);
            }
            if ((bString = aRace.getSource()).length() > 0) {
                b.append(" <b>SOURCE:</b> ").append(bString);
            }
            b.append("</html>");
            this.infoLabel.setText(b.toString());
        } else if (obj instanceof Follower) {
            Follower aF = (Follower)obj;
            PlayerCharacter newPC = null;
            Iterator p = Globals.getPCList().iterator();
            while (p.hasNext()) {
                PlayerCharacter nPC = (PlayerCharacter)p.next();
                if (!aF.getFileName().equals(nPC.getFileName())) continue;
                newPC = nPC;
            }
            if (newPC == null) {
                this.infoLabel.setText("NOTICE: Load from File to display info");
                return;
            }
            StringBuffer b = new StringBuffer();
            b.append("<html>");
            b.append(InfoResources.followerStatBlock(aF, newPC));
            b.append("</html>");
            this.infoLabel.setText(b.toString());
        }
    }

    private static int getSelectedIndex(ListSelectionEvent e) {
        DefaultListSelectionModel model = (DefaultListSelectionModel)e.getSource();
        if (model == null) {
            return -1;
        }
        return model.getMinSelectionIndex();
    }

    private final void createModels() {
        this.createAvailableModel();
        this.createSelectedModel();
    }

    private final void createSelectedModel() {
        if (this.selectedModel == null) {
            this.selectedModel = new FollowerModel(this.viewSortMode, false);
        } else {
            this.selectedModel.resetModel(this.viewSortMode, false);
        }
        if (this.selectedSort != null) {
            this.selectedSort.setRoot((PObjectNode)this.selectedModel.getRoot());
        }
    }

    private final void createTreeTables() {
        this.availableTable = new JTreeTable(this.availableModel);
        this.availableTable.setSelectionMode(0);
        final JTree atree = this.availableTable.getTree();
        atree.setRootVisible(false);
        atree.setShowsRootHandles(true);
        atree.setCellRenderer(new LabelTreeCellRenderer());
        this.availableTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int idx = InfoResources.getSelectedIndex(e);
                    if (idx < 0) {
                        return;
                    }
                    Object temp = atree.getPathForRow(idx).getLastPathComponent();
                    if (temp == null) {
                        InfoResources.this.infoLabel.setText();
                        return;
                    }
                    PObjectNode fNode = (PObjectNode)temp;
                    if (fNode.getItem() != null) {
                        InfoResources.this.addButton.setEnabled(true);
                        InfoResources.this.setInfoText(fNode.getItem());
                    }
                }
            }
        });
        MouseAdapter aml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int avaRow = atree.getRowForLocation(e.getX(), e.getY());
                TreePath avaPath = atree.getPathForLocation(e.getX(), e.getY());
                if (avaRow != -1) {
                    if (e.getClickCount() == 1 && avaPath != null) {
                        atree.setSelectionPath(avaPath);
                    } else if (e.getClickCount() == 2) {
                        InfoResources.this.addButton();
                    }
                }
            }
        };
        atree.addMouseListener(aml);
        this.selectedTable = new JTreeTable(this.selectedModel);
        this.selectedTable.setSelectionMode(0);
        final JTree stree = this.selectedTable.getTree();
        stree.setRootVisible(false);
        stree.setShowsRootHandles(true);
        stree.setCellRenderer(new LabelTreeCellRenderer());
        this.selectedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int idx = InfoResources.getSelectedIndex(e);
                    if (idx < 0) {
                        return;
                    }
                    Object temp = stree.getPathForRow(idx).getLastPathComponent();
                    if (temp == null) {
                        return;
                    }
                    PObjectNode fN = (PObjectNode)temp;
                    if (fN.getItem() != null && !(fN.getItem() instanceof String)) {
                        InfoResources.this.delButton.setEnabled(true);
                        InfoResources.this.loadButton.setEnabled(true);
                        InfoResources.this.setInfoText(fN.getItem());
                        return;
                    }
                    InfoResources.this.infoLabel.setText("None");
                    InfoResources.this.loadButton.setEnabled(false);
                    return;
                }
            }
        });
        MouseAdapter sml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = stree.getRowForLocation(e.getX(), e.getY());
                TreePath mlSelPath = stree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    if (e.getClickCount() == 1 && mlSelPath != null) {
                        stree.setSelectionPath(mlSelPath);
                    } else if (e.getClickCount() == 2) {
                        InfoResources.this.addFileButton();
                    }
                }
            }
        };
        stree.addMouseListener(sml);
        this.hookupPopupMenu(this.availableTable);
        this.hookupPopupMenu(this.selectedTable);
    }

    private void delButton() {
        TreePath selCPath = this.selectedTable.getTree().getSelectionPath();
        if (selCPath == null) {
            ShowMessageDelegate.showMessageDialog("Select the object to remove", "PCGen", MessageType.ERROR);
            return;
        }
        Object endComp = selCPath.getLastPathComponent();
        PObjectNode fNode = (PObjectNode)endComp;
        int iConfirm = JOptionPane.showConfirmDialog(null, "Are you sure you want to delete?", "Confirm Remove", 0);
        if (iConfirm != 0) {
            return;
        }
        if (fNode.getItem() instanceof Follower) {
            this.pc.delFollower((Follower)fNode.getItem());
        } else if (fNode.getItem() instanceof Equipment) {
            this.pc.removeEquipment((Equipment)fNode.getItem());
        } else {
            return;
        }
        this.pc.setDirty(true);
        this.updateSelectedModel();
    }

    private File findPCGFile(File file) {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Find file");
        fc.setCurrentDirectory(SettingsHandler.getPcgPath());
        if (fc.showOpenDialog(this) != 0) {
            return null;
        }
        file = fc.getSelectedFile();
        if (file.exists() && file.canWrite()) {
            return file;
        }
        return null;
    }

    private void formComponentShown() {
        this.refresh();
        this.requestFocus();
        PCGen_Frame1.getStatusBar().setText("Add followers/cohorts, animal companions, special mounts or familiars");
        int top = this.topSplit.getDividerLocation();
        int bot = this.botSplit.getDividerLocation();
        int cent = this.centerSplit.getDividerLocation();
        if (!this.hasBeenSized) {
            int width;
            TableColumn sCol;
            int i;
            this.hasBeenSized = true;
            Container c = this.getParent();
            top = SettingsHandler.getPCGenOption("InfoResources.topSplit", c.getWidth() * 7 / 10);
            bot = SettingsHandler.getPCGenOption("InfoResources.botSplit", c.getWidth() - 300);
            cent = SettingsHandler.getPCGenOption("InfoResources.centerSplit", c.getHeight() - 100);
            for (i = 0; i < this.selectedTable.getColumnCount(); ++i) {
                sCol = this.selectedTable.getColumnModel().getColumn(i);
                width = Globals.getCustColumnWidth("ResSel", i);
                if (width != 0) {
                    sCol.setPreferredWidth(width);
                }
                sCol.addPropertyChangeListener(new ResizeColumnListener(this.selectedTable, "ResSel", i));
            }
            for (i = 0; i < this.availableTable.getColumnCount(); ++i) {
                sCol = this.availableTable.getColumnModel().getColumn(i);
                width = Globals.getCustColumnWidth("ResAva", i);
                if (width != 0) {
                    sCol.setPreferredWidth(width);
                }
                sCol.addPropertyChangeListener(new ResizeColumnListener(this.availableTable, "ResAva", i));
            }
        }
        if (top > 0) {
            this.topSplit.setDividerLocation(top);
            SettingsHandler.setPCGenOption("InfoResources.topSplit", top);
        }
        if (bot > 0) {
            this.botSplit.setDividerLocation(bot);
            SettingsHandler.setPCGenOption("InfoResources.botSplit", bot);
        }
        if (cent > 0) {
            this.centerSplit.setDividerLocation(cent);
            SettingsHandler.setPCGenOption("InfoResources.centerSplit", cent);
        }
    }

    private void hookupPopupMenu(JTreeTable treeTable) {
        treeTable.addMouseListener(new resPopupListener(treeTable, new ResourcesPopupMenu(treeTable)));
    }

    private void initActionListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                InfoResources.this.formComponentShown();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                int i = InfoResources.this.topSplit.getDividerLocation();
                if (i > 0) {
                    SettingsHandler.setPCGenOption("InfoResources.topSplit", i);
                }
                if ((i = InfoResources.this.botSplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoResources.botSplit", i);
                }
                if ((i = InfoResources.this.centerSplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoResources.centerSplit", i);
                }
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoResources.this.addButton();
            }
        });
        this.delButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoResources.this.delButton();
            }
        });
        this.loadButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoResources.this.loadButton();
            }
        });
        this.updateButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoResources.this.updateButton();
            }
        });
        this.viewModeBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoResources.this.viewModeBoxActionPerformed();
            }
        });
        this.viewSortBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoResources.this.viewSortBoxActionPerformed();
            }
        });
        this.shouldLoadCompanion.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoResources.this.pc.setLoadCompanion(InfoResources.this.shouldLoadCompanion.isSelected());
            }
        });
    }

    private void initComponents() {
        this.readyForRefresh = true;
        this.createModels();
        this.createTreeTables();
        this.viewModeBox.addItem("Followers   ");
        Utility.setDescription(this.viewModeBox, "Choose View Mode");
        this.viewSortBox.addItem("Type ");
        this.viewSortBox.addItem("Name ");
        Utility.setDescription(this.viewSortBox, "Sort Sort");
        this.setLayout(new BorderLayout());
        this.createMasterView();
        this.createFollowerView();
        this.availableSort = new JTreeTableSorter(this.availableTable, (PObjectNode)this.availableModel.getRoot(), this.availableModel);
        this.selectedSort = new JTreeTableSorter(this.selectedTable, (PObjectNode)this.selectedModel.getRoot(), this.selectedModel);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                InfoResources.this.refresh();
            }
        });
    }

    private void loadButton() {
        TreePath selCPath = this.selectedTable.getTree().getSelectionPath();
        if (selCPath == null) {
            ShowMessageDelegate.showMessageDialog("Select the object to load", "PCGen", MessageType.ERROR);
            return;
        }
        Object endComp = selCPath.getLastPathComponent();
        PObjectNode fNode = (PObjectNode)endComp;
        if (fNode.getItem() instanceof Follower) {
            Follower aF = (Follower)fNode.getItem();
            if (aF == null) {
                return;
            }
            Iterator p = Globals.getPCList().iterator();
            while (p.hasNext()) {
                PlayerCharacter nPC = (PlayerCharacter)p.next();
                if (!aF.getFileName().equals(nPC.getFileName())) continue;
                ShowMessageDelegate.showMessageDialog(aF.getName() + " is already loaded", "PCGen", MessageType.INFORMATION);
                return;
            }
            File file = new File(aF.getFileName());
            if (!file.exists()) {
                ShowMessageDelegate.showMessageDialog(aF.getFileName() + " has moved/changed. Please select the new .pcg filename ", "PCGen", MessageType.INFORMATION);
                Logging.errorPrint("b File: " + file.getAbsolutePath());
                file = this.findPCGFile(file);
                if (file == null) {
                    return;
                }
                Logging.errorPrint("a File: " + file.getAbsolutePath());
            }
            aF.setFileName(file.getAbsolutePath());
            ShowMessageDelegate.showMessageDialog("Loading " + aF.getName() + " from " + aF.getFileName() + " and switching tabs", "PCGen", MessageType.INFORMATION);
            PCGen_Frame1.getInst().loadPCFromFile(file);
            InfoResources.setNeedsUpdate(true);
            CharacterInfo pane = PCGen_Frame1.getCharacterPane();
            pane.setPaneForUpdate(pane.infoSummary());
            pane.refresh();
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    InfoResources.this.formComponentShown();
                }
            });
            return;
        }
        if (fNode.getItem() instanceof Equipment) {
            // empty if block
        }
        this.pc.setDirty(true);
        this.updateSelectedModel();
    }

    private void updateAvailableModel() {
        List pathList = this.availableTable.getExpandedPaths();
        this.createAvailableModel();
        this.availableTable.updateUI();
        this.availableTable.expandPathList(pathList);
    }

    private void updateButton() {
        if (this.pc.getMaster() != null) {
            this.pc.setMaster(this.pc.getMaster(), Globals.getCurrentPC());
            CharacterInfo pane = PCGen_Frame1.getCharacterPane();
            pane.setPaneForUpdate(pane.infoSkills());
            pane.setPaneForUpdate(pane.infoSummary());
            pane.setPaneForUpdate(pane.infoClasses());
            pane.setPaneForUpdate(pane.infoSpells());
            pane.setPaneForUpdate(pane.infoInventory());
            pane.refresh();
            ShowMessageDelegate.showMessageDialog("Done updating " + this.pc.getName(), "PCGen", MessageType.INFORMATION);
        }
        this.pc.setDirty(true);
        this.setFollowerInfo(this.pc);
    }

    private void updateSelectedModel() {
        List pathList = this.selectedTable.getExpandedPaths();
        this.createSelectedModel();
        this.selectedTable.updateUI();
        this.selectedTable.expandPathList(pathList);
    }

    private void viewModeBoxActionPerformed() {
        int index = this.viewModeBox.getSelectedIndex();
        if (index != this.viewMode) {
            this.viewMode = index;
            this.updateAvailableModel();
            this.updateSelectedModel();
        }
    }

    private void viewSortBoxActionPerformed() {
        int index = this.viewSortBox.getSelectedIndex();
        if (index != this.viewSortMode) {
            this.viewSortMode = index;
            this.updateAvailableModel();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class resPopupListener
    extends MouseAdapter {
        private JTree tree;
        private ResourcesPopupMenu menu;

        resPopupListener(JTreeTable treeTable, ResourcesPopupMenu aMenu) {
            this.tree = treeTable.getTree();
            this.menu = aMenu;
            KeyListener myKeyListener = new KeyListener(this){
                private final /* synthetic */ resPopupListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTyped(KeyEvent e) {
                    resPopupListener.access$2700(this.this$1).dispatchEvent(e);
                }

                public void keyPressed(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    if (keyCode != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                        for (int i = 0; i < resPopupListener.access$2800(this.this$1).getComponentCount(); ++i) {
                            KeyStroke ks;
                            Component menuComponent = resPopupListener.access$2800(this.this$1).getComponent(i);
                            if (!(menuComponent instanceof JMenuItem) || (ks = ((JMenuItem)menuComponent).getAccelerator()) == null || !keyStroke.equals(ks)) continue;
                            InfoResources.access$2902(resPopupListener.access$2700(this.this$1), resPopupListener.access$3000(this.this$1).getSelectionPath());
                            ((JMenuItem)menuComponent).doClick(2);
                            return;
                        }
                    }
                    resPopupListener.access$2700(this.this$1).dispatchEvent(e);
                }

                public void keyReleased(KeyEvent e) {
                    resPopupListener.access$2700(this.this$1).dispatchEvent(e);
                }
            };
            treeTable.addKeyListener(myKeyListener);
        }

        public void mousePressed(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        private void maybeShowPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                InfoResources.this.selPath = this.tree.getClosestPathForLocation(evt.getX(), evt.getY());
                if (InfoResources.this.selPath == null) {
                    return;
                }
                this.tree.setSelectionPath(InfoResources.this.selPath);
                this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        static /* synthetic */ InfoResources access$2700(resPopupListener x0) {
            return x0.InfoResources.this;
        }

        static /* synthetic */ ResourcesPopupMenu access$2800(resPopupListener x0) {
            return x0.menu;
        }

        static /* synthetic */ JTree access$3000(resPopupListener x0) {
            return x0.tree;
        }
    }

    private class ResourcesPopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = 7236403406005940947L;

        ResourcesPopupMenu(JTreeTable treeTable) {
            if (treeTable == InfoResources.this.availableTable) {
                this.add(this.createAddMenuItem("Add New to List", "shortcut EQUALS"));
            } else {
                this.add(this.createDelMenuItem("Remove from List", "shortcut MINUS"));
                this.add(this.createAddFileMenuItem("Add from existing File", "shortcut PLUS"));
            }
        }

        private JMenuItem createAddFileMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new AddFileActionListener(), "add 1", '\u0000', accelerator, "Add Existing File", "Add16.gif", true);
        }

        private JMenuItem createAddMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new AddActionListener(), "add 1", '\u0000', accelerator, "Add to List", "Add16.gif", true);
        }

        private JMenuItem createDelMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new DelActionListener(), "remove 1", '\u0000', accelerator, "Remove from List", "Remove16.gif", true);
        }

        private class resActionListener
        implements ActionListener {
            private resActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
            }
        }

        private class DelActionListener
        extends resActionListener {
            private DelActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoResources.this.delButton();
            }
        }

        private class AddFileActionListener
        extends resActionListener {
            private AddFileActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoResources.this.addFileButton();
            }
        }

        private class AddActionListener
        extends resActionListener {
            private AddActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoResources.this.addButton();
            }
        }
    }

    private final class FollowerModel
    extends AbstractTreeTableModel {
        private static final int COL_NAME = 0;
        private static final int COL_SIZE = 1;
        private static final int COL_MOVE = 2;
        private static final int COL_VISION = 3;
        private static final int COL_PRE = 4;
        private static final int COL_TYPE = 5;
        private static final int COL_SOURCE = 6;
        private static final int SEL_COL_TYPE = 11;
        private static final int SEL_COL_FILE = 12;
        private static final int VIEW_TYPE = 0;
        private static final int VIEW_NAME = 1;
        private PObjectNode avaRoot;
        private PObjectNode selRoot;
        private String[] avaNameList = new String[]{""};
        private String[] selNameList = new String[]{""};
        private int modelType = 0;

        private FollowerModel(int mode, boolean available) {
            super(null);
            this.avaNameList = new String[]{"Type/Name", "Size", "Speed", "Vision", "Alignment", "Type/Race", "Source"};
            this.selNameList = new String[]{"Type/Name", "Type/Race", "File Name"};
            if (!available) {
                this.modelType = 1;
            }
            this.resetModel(mode, available);
        }

        public boolean isCellEditable(Object node, int column) {
            return column == 0;
        }

        public Class getColumnClass(int column) {
            Class clazz = column == 0 ? (class$pcgen$gui$utils$TreeTableModel == null ? (class$pcgen$gui$utils$TreeTableModel = InfoResources.class$("pcgen.gui.utils.TreeTableModel")) : class$pcgen$gui$utils$TreeTableModel) : (class$java$lang$String == null ? (class$java$lang$String = InfoResources.class$("java.lang.String")) : class$java$lang$String);
            return clazz;
        }

        public int getColumnCount() {
            return this.modelType == 0 ? this.avaNameList.length : this.selNameList.length;
        }

        public String getColumnName(int column) {
            return this.modelType == 0 ? this.avaNameList[column] : this.selNameList[column];
        }

        public Object getRoot() {
            return (PObjectNode)super.getRoot();
        }

        public Object getValueAt(Object node, int column) {
            PObjectNode fn = (PObjectNode)node;
            Race race = null;
            Follower fObj = null;
            String sRet = "";
            if (fn == null) {
                Logging.errorPrint("No active node when doing getValueAt in InfoRace");
                return null;
            }
            if (fn.getItem() instanceof Race) {
                race = (Race)fn.getItem();
            } else if (fn.getItem() instanceof Follower) {
                fObj = (Follower)fn.getItem();
            }
            column = this.adjustColumnConst(column);
            switch (column) {
                case 0: {
                    if (race != null) {
                        return race.getName();
                    }
                    return fn.toString();
                }
                case 1: {
                    if (race == null) break;
                    sRet = race.getSize();
                    break;
                }
                case 2: {
                    if (race == null) {
                        return null;
                    }
                    if (race.getNumberOfMovements() <= 0) break;
                    StringBuffer movelabel = new StringBuffer(race.getMovementType(0)).append(" ").append(race.getMovement(0)).append(Globals.getDistanceUnit()).append(" ");
                    for (int i = 1; i < race.getNumberOfMovements(); ++i) {
                        movelabel.append(race.getMovementType(i)).append(" ").append(race.getMovement(i)).append(Globals.getDistanceUnit()).append(" ");
                    }
                    sRet = movelabel.toString();
                    break;
                }
                case 3: {
                    if (race == null) break;
                    sRet = race.getDisplayVision(InfoResources.this.pc);
                    break;
                }
                case 4: {
                    if (race == null) break;
                    sRet = race.preReqHTMLStrings(InfoResources.this.pc);
                    break;
                }
                case 5: {
                    if (race == null) break;
                    if ("None".equals(race.getDisplayName())) {
                        sRet = race.getType();
                        break;
                    }
                    sRet = race.getDisplayName();
                    break;
                }
                case 6: {
                    if (race == null) break;
                    sRet = race.getSource();
                    break;
                }
                case 11: {
                    if (fObj == null) break;
                    sRet = fObj.getType();
                    break;
                }
                case 12: {
                    if (fObj == null) break;
                    sRet = fObj.getFileName();
                    break;
                }
                default: {
                    Logging.errorPrint("In InfoResources.FollowerModel.getValueAt the column " + column + " is not handled.");
                }
            }
            return sRet;
        }

        private void setRoot(PObjectNode aNode) {
            super.setRoot(aNode);
        }

        private int adjustColumnConst(int column) {
            if (this.modelType == 1) {
                switch (column) {
                    case 1: {
                        return 11;
                    }
                    case 2: {
                        return 12;
                    }
                }
                return column;
            }
            return column;
        }

        private void resetModel(int mode, boolean available) {
            ArrayList<Race> raceList = new ArrayList<Race>();
            ArrayList<String> typeList = new ArrayList<String>();
            ArrayList<String> selectedList = new ArrayList<String>();
            Iterator iRace = Globals.getRaceMap().values().iterator();
            while (iRace.hasNext()) {
                Race aRace = (Race)iRace.next();
                if (!raceList.contains(aRace)) {
                    raceList.add(aRace);
                }
                if (typeList.contains(aRace.getType())) continue;
                typeList.add(aRace.getType());
            }
            Collections.sort(raceList);
            Collections.sort(typeList);
            selectedList.add("Followers");
            Iterator iComp = Globals.getCompanionModList().iterator();
            while (iComp.hasNext()) {
                CompanionMod aComp = (CompanionMod)iComp.next();
                String compType = CoreUtility.capitalizeFirstLetter(aComp.getType());
                Iterator iType = aComp.getVarMap().keySet().iterator();
                while (iType.hasNext()) {
                    String varName = (String)iType.next();
                    if (InfoResources.this.pc.getVariableValue(varName, "").intValue() <= 0 || selectedList.contains(compType)) continue;
                    selectedList.add(compType);
                }
            }
            Iterator iClass = InfoResources.this.pc.getClassList().iterator();
            while (iClass.hasNext()) {
                PCClass aClass = (PCClass)iClass.next();
                if (Globals.getCompanionModList().isEmpty()) continue;
                Iterator iComp2 = Globals.getCompanionModList().iterator();
                while (iComp2.hasNext()) {
                    CompanionMod aComp = (CompanionMod)iComp2.next();
                    String compType = CoreUtility.capitalizeFirstLetter(aComp.getType());
                    if (!aComp.getClassMap().containsKey(aClass.getName()) || selectedList.contains(compType)) continue;
                    selectedList.add(compType);
                }
            }
            if (available) {
                this.avaRoot = new PObjectNode();
                this.setRoot(this.avaRoot);
                switch (mode) {
                    case 1: {
                        PObjectNode[] rn = new PObjectNode[raceList.size()];
                        for (int iName = 0; iName < raceList.size(); ++iName) {
                            Race aRace = (Race)raceList.get(iName);
                            if (aRace == null) continue;
                            rn[iName] = new PObjectNode();
                            rn[iName].setItem(aRace);
                            rn[iName].setParent(this.avaRoot);
                        }
                        this.avaRoot.setChildren(rn);
                        break;
                    }
                    case 0: {
                        PObjectNode[] rt = new PObjectNode[typeList.size()];
                        for (int iType = 0; iType < typeList.size(); ++iType) {
                            String aType = (String)typeList.get(iType);
                            rt[iType] = new PObjectNode();
                            rt[iType].setItem(aType);
                            Iterator fI = Globals.getRaceMap().values().iterator();
                            while (fI.hasNext()) {
                                Race aRace = (Race)fI.next();
                                if (aRace == null || !aRace.getType().equals(aType)) continue;
                                PObjectNode aFN = new PObjectNode(aRace);
                                rt[iType].addChild(aFN);
                            }
                            if (rt[iType].isLeaf()) continue;
                            rt[iType].setParent(this.avaRoot);
                        }
                        this.avaRoot.setChildren(rt);
                        break;
                    }
                    default: {
                        Logging.errorPrint("In InfoResources.FollowerModel.resetModel the mode " + mode + " is not handled.");
                        break;
                    }
                }
            } else {
                this.selRoot = new PObjectNode();
                this.setRoot(this.selRoot);
                PObjectNode[] sl = new PObjectNode[selectedList.size()];
                for (int iSel = 0; iSel < selectedList.size(); ++iSel) {
                    String sString = (String)selectedList.get(iSel);
                    sl[iSel] = new PObjectNode();
                    sl[iSel].setItem(sString);
                    sl[iSel].setParent(this.selRoot);
                    Iterator fList = InfoResources.this.pc.getFollowerList().iterator();
                    while (fList.hasNext()) {
                        Follower aF = (Follower)fList.next();
                        if (!sString.startsWith(aF.getType())) continue;
                        PObjectNode aFN = new PObjectNode();
                        aFN.setItem(aF);
                        aFN.setParent(sl[iSel]);
                        sl[iSel].addChild(aFN);
                    }
                }
                this.selRoot.setChildren(sl);
            }
            PObjectNode rootAsPObjectNode = (PObjectNode)super.getRoot();
            if (rootAsPObjectNode.getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }
    }
}

