/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.tree.TreePath;
import pcgen.core.Constants;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SkillComparator;
import pcgen.core.pclevelinfo.PCLevelInfo;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.InfoSkillsSorter;
import pcgen.gui.InfoSkillsSorters;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.AbstractPObjectFilter;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.filter.PObjectFilter;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.Utility;
import pcgen.gui.utils.WholeNumberField;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.ResetableListIterator;
import pcgen.util.StringIgnoreCaseComparator;

public class InfoSkills
extends FilterAdapterPanel
implements CharacterInfoTab {
    static final long serialVersionUID = -5369872214039221832L;
    private static boolean resetSelectedModel = true;
    private static PCClass previouslySelectedClass = null;
    private static boolean needsUpdate = true;
    private static int splitOrientation = 1;
    private static final int COL_NAME = 0;
    private static final int COL_MOD = 1;
    private static final int COL_RANK = 2;
    private static final int COL_TOTAL = 3;
    private static final int COL_COST = 4;
    private static final int COL_SRC = 5;
    private static final int COL_INDEX = 6;
    private static int viewMode = 4;
    private static int viewSelectMode = 5;
    private static int selectedOutputOrder = 4;
    private static final int MODEL_AVAIL = 0;
    private static final int MODEL_SELECT = 1;
    public static final int nCosts = 3;
    private final JLabel avaLabel = new JLabel(PropertyFactory.getString("in_iskDisplay_By"));
    private final JLabel selLabel = new JLabel(PropertyFactory.getString("in_iskDisplay_By"));
    private Border etched;
    private FlippingSplitPane asplit;
    private FlippingSplitPane bsplit;
    private FlippingSplitPane splitPane;
    private JButton addButton;
    private JButton leftButton;
    private JComboBoxEx currCharacterClass = new JComboBoxEx();
    private JComboBoxEx outputOrderComboBox = new JComboBoxEx();
    private JComboBoxEx skillChoice = new JComboBoxEx();
    private JComboBoxEx viewComboBox = new JComboBoxEx();
    private JComboBoxEx viewSelectComboBox = new JComboBoxEx();
    private JLabel exclusiveLabel = new JLabel();
    private JLabel includeLabel = new JLabel();
    private JLabel jLbClassSkillPoints = new JLabel();
    private JLabel jLbMaxCrossSkill = new JLabel();
    private JLabel jLbMaxSkill = new JLabel();
    private JLabel jLbTotalSkillPointsLeft = new JLabel();
    private JLabel maxCrossSkillRank = new JLabel();
    private JLabel maxSkillRank = new JLabel();
    private JLabelPane infoLabel = new JLabelPane();
    private JPanel center = new JPanel();
    private JPanel jPanel1 = new JPanel();
    private JScrollPane cScroll = new JScrollPane();
    private JTextField exclusiveSkillCost = new JTextField();
    private JTreeTable availableTable;
    private JTreeTable selectedTable;
    private JTreeTableSorter availableSort;
    private JTreeTableSorter selectedSort;
    private Skill lastSkill;
    private SkillModel availableModel;
    private SkillModel selectedModel;
    private TreePath selPath;
    private WholeNumberField currCharClassSkillPnts = new WholeNumberField(0, 4);
    private WholeNumberField totalSkillPointsLeft = new WholeNumberField(0, 4);
    private boolean hasBeenSized = false;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;
    static /* synthetic */ Class class$pcgen$gui$utils$TreeTableModel;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$String;

    public InfoSkills(PlayerCharacter pc) {
        this.pc = pc;
        this.setName(Constants.tabNames[8]);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoSkills.this.initComponents();
                InfoSkills.this.initActionListeners();
            }
        });
    }

    public void setPc(PlayerCharacter pc) {
        if (this.pc != pc || pc.getSerial() > this.serial) {
            this.pc = pc;
            this.serial = pc.getSerial();
            this.forceRefresh();
        }
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Skills.Order", 8);
    }

    public void setTabOrder(int order) {
        SettingsHandler.setPCGenOption(".Panel.Skills.Order", order);
    }

    public String getTabName() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabName(8);
    }

    public boolean isShown() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabShown(8);
    }

    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    public JComponent getView() {
        return this;
    }

    public static final void setNeedsUpdate(boolean flag) {
        needsUpdate = flag;
    }

    public final boolean isMatchAnyEnabled() {
        return true;
    }

    public final boolean isNegateEnabled() {
        return true;
    }

    public final int getSelectionMode() {
        return 2;
    }

    public static SkillWrapper createSkillWrapper(boolean available, Skill skill, PlayerCharacter pc) {
        return available ? new SkillWrapper(skill, new Integer(0), new Float(0.0f), new Integer(0)) : new SkillWrapper(skill, skill.modifier(pc), skill.getTotalRank(pc), new Integer(skill.getOutputIndex()));
    }

    public final void initializeFilters() {
        this.registerFilter(this.createClassSkillFilter());
        this.registerFilter(this.createCrossClassSkillFilter());
        this.registerFilter(this.createExclusiveSkillFilter());
        this.registerFilter(this.createQualifyFilter());
        FilterFactory.registerAllSourceFilters(this);
        FilterFactory.registerAllSkillFilters(this);
        this.setKitFilter("SKILL");
    }

    public final void refreshFiltering() {
        this.updateAvailableModel();
    }

    private PCLevelInfo getSelectedLevelInfo(PlayerCharacter pc) {
        int i = Math.max(0, this.currCharacterClass.getSelectedIndex());
        if (pc.getLevelInfo() == null) {
            return null;
        }
        if (i >= pc.getLevelInfo().size()) {
            return null;
        }
        return (PCLevelInfo)pc.getLevelInfo().get(i);
    }

    public PCClass getSelectedPCClass() {
        PCLevelInfo pcl = this.getSelectedLevelInfo(this.pc);
        if (pcl != null) {
            return this.pc.getClassNamed(pcl.getClassKeyName());
        }
        return null;
    }

    private void setCurrentClassCombo() {
        int idx;
        boolean oldFlag = resetSelectedModel;
        PCClass aClass = null;
        for (idx = 0; idx < this.pc.getLevelInfoSize() - 1; ++idx) {
            PCLevelInfo pcl = (PCLevelInfo)this.pc.getLevelInfo().get(idx);
            if (pcl.getSkillPointsRemaining(this.pc) <= 0) continue;
            aClass = this.pc.getClassNamed(pcl.getClassKeyName());
            break;
        }
        if (idx < this.pc.getLevelInfoSize()) {
            resetSelectedModel = previouslySelectedClass != aClass;
            this.currCharacterClass.setSelectedIndex(idx);
            previouslySelectedClass = aClass;
            resetSelectedModel = oldFlag;
        }
    }

    private int getHighestOutputIndex() {
        int maxOutputIndex = 0;
        Iterator i = this.pc.getSkillList().iterator();
        while (i.hasNext()) {
            Skill bSkill = (Skill)i.next();
            if (bSkill.getOutputIndex() <= maxOutputIndex) continue;
            maxOutputIndex = bSkill.getOutputIndex();
        }
        return maxOutputIndex;
    }

    private static int getSelectedIndex(ListSelectionEvent e) {
        DefaultListSelectionModel model = (DefaultListSelectionModel)e.getSource();
        if (model == null) {
            return -1;
        }
        return model.getMinSelectionIndex();
    }

    private final void createAvailableModel() {
        if (this.availableModel == null) {
            this.availableModel = new SkillModel(viewMode, true);
        } else {
            this.availableModel.resetModel(viewMode, true);
        }
        if (this.availableSort != null) {
            this.availableSort.setRoot((PObjectNode)this.availableModel.getRoot());
            this.availableSort.sortNodeOnColumn();
        }
    }

    private final PObjectFilter createClassSkillFilter() {
        return new ClassSkillFilter();
    }

    private final PObjectFilter createCrossClassSkillFilter() {
        return new CrossClassSkillFilter();
    }

    private final PObjectFilter createExclusiveSkillFilter() {
        return new ExclusiveSkillFilter();
    }

    private final void createModels() {
        this.createAvailableModel();
        this.createSelectedModel();
    }

    private final PObjectFilter createQualifyFilter() {
        return new QualifyFilter();
    }

    private final void createSelectedModel() {
        if (this.selectedModel == null) {
            this.selectedModel = new SkillModel(viewSelectMode, false);
        } else if (resetSelectedModel) {
            this.selectedModel.resetModel(viewSelectMode, false);
        }
        if (this.selectedSort != null) {
            this.selectedSort.setRoot((PObjectNode)this.selectedModel.getRoot());
            this.selectedSort.sortNodeOnColumn();
        }
    }

    private final void createTreeTables() {
        this.availableTable = new JTreeTable(this.availableModel);
        this.availableTable.setSelectionMode(0);
        final JTree tree = this.availableTable.getTree();
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        tree.setCellRenderer(new LabelTreeCellRenderer());
        this.availableTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int idx = InfoSkills.getSelectedIndex(e);
                    if (idx < 0) {
                        return;
                    }
                    Object temp = InfoSkills.this.availableTable.getTree().getPathForRow(idx).getLastPathComponent();
                    if (temp == null) {
                        InfoSkills.this.lastSkill = null;
                        ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_iskErr_message_02"), "PCGen", MessageType.ERROR);
                        return;
                    }
                    Skill aSkill = null;
                    if (temp instanceof PObjectNode && (temp = ((PObjectNode)temp).getItem()) instanceof SkillWrapper) {
                        aSkill = ((SkillWrapper)temp).getSkWrapSkill();
                    }
                    InfoSkills.this.addButton.setEnabled(aSkill != null);
                    InfoSkills.this.setInfoLabelText(aSkill);
                }
            }
        });
        MouseAdapter ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = tree.getRowForLocation(e.getX(), e.getY());
                TreePath mlSelPath = tree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    if (e.getClickCount() == 1 && mlSelPath != null) {
                        tree.setSelectionPath(mlSelPath);
                    } else if (e.getClickCount() == 2) {
                        InfoSkills.this.addSkill(1);
                    }
                }
            }
        };
        tree.addMouseListener(ml);
        this.selectedTable = new JTreeTable(this.selectedModel);
        this.selectedTable.setSelectionMode(0);
        final JTree btree = this.selectedTable.getTree();
        btree.setRootVisible(false);
        btree.setShowsRootHandles(true);
        btree.setCellRenderer(new LabelTreeCellRenderer());
        this.selectedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    int idx = InfoSkills.getSelectedIndex(e);
                    if (idx < 0) {
                        return;
                    }
                    Object temp = InfoSkills.this.selectedTable.getTree().getPathForRow(idx).getLastPathComponent();
                    if (temp == null) {
                        InfoSkills.this.lastSkill = null;
                        InfoSkills.this.infoLabel.setText();
                        return;
                    }
                    Skill aSkill = null;
                    if (temp instanceof PObjectNode && (temp = ((PObjectNode)temp).getItem()) instanceof SkillWrapper) {
                        aSkill = ((SkillWrapper)temp).getSkWrapSkill();
                    }
                    InfoSkills.this.leftButton.setEnabled(aSkill != null);
                    InfoSkills.this.setInfoLabelText(aSkill);
                }
            }
        });
        ml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = btree.getRowForLocation(e.getX(), e.getY());
                TreePath mlSelPath = btree.getPathForLocation(e.getX(), e.getY());
                if (selRow != -1) {
                    if (e.getClickCount() == 1) {
                        btree.setSelectionPath(mlSelPath);
                    } else if (e.getClickCount() == 2) {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 5 this$1;
                            {
                                this.this$1 = this$1;
                            }

                            public void run() {
                                Skill theSkill = InfoSkills.access$1800(5.access$1700(this.this$1));
                                if (theSkill != null) {
                                    if (theSkill.getChoiceString() == null) {
                                        InfoSkills.access$1300(5.access$1700(this.this$1), -1);
                                    } else {
                                        InfoSkills.access$1300(5.access$1700(this.this$1), -theSkill.costForPCClass(5.access$1700(this.this$1).getSelectedPCClass(), InfoSkills.access$1900(5.access$1700(this.this$1))).intValue());
                                    }
                                }
                            }
                        });
                    }
                }
            }

            static /* synthetic */ InfoSkills access$1700(5 x0) {
                return x0.InfoSkills.this;
            }
        };
        btree.addMouseListener(ml);
        this.hookupPopupMenu(this.availableTable);
        this.hookupPopupMenu(this.selectedTable);
    }

    private Skill getSelectedSkill() {
        return this.lastSkill;
    }

    private void addSkill(int points) {
        Skill theSkill = this.getSelectedSkill();
        if (theSkill == null) {
            return;
        }
        if (theSkill.isReadOnly()) {
            ShowMessageDelegate.showMessageDialog("You cannot " + (points < 0 ? "remove" : "add") + " ranks for this skill: " + theSkill.getName(), "PCGen", MessageType.ERROR);
            return;
        }
        if (!this.modRank(theSkill, points)) {
            return;
        }
        PCLevelInfo pcl = this.getSelectedLevelInfo(this.pc);
        this.pc.setDirty(true);
        if (pcl != null) {
            this.currCharClassSkillPnts.setValue(pcl.getSkillPointsRemaining(this.pc));
            this.totalSkillPointsLeft.setValue(this.pc.getSkillPoints());
        }
        this.updateSelectedModel();
        if (points > 0) {
            this.selectedTable.expandByPObjectName(theSkill.getName());
        }
    }

    private void currCharClassSkillPntsFocusLost() {
        PlayerCharacter currentPC = this.pc;
        currentPC.setDirty(true);
        PCClass aClass = this.getSelectedPCClass();
        PCLevelInfo pcl = this.getSelectedLevelInfo(currentPC);
        int skillPool = pcl.getSkillPointsRemaining(this.pc);
        if (this.currCharClassSkillPnts.getText().length() > 0) {
            int anInt = Delta.decode(this.currCharClassSkillPnts.getText());
            if (aClass == null || anInt == skillPool) {
                return;
            }
            int i = skillPool - anInt;
            pcl.setSkillPointsRemaining(anInt, this.pc);
            aClass.setSkillPool(Math.max(0, aClass.getSkillPool(this.pc) - i));
            currentPC.setSkillPoints(Math.max(0, currentPC.getSkillPoints() - i));
        }
        this.currCharClassSkillPnts.setValue(pcl.getSkillPointsRemaining(this.pc));
        this.totalSkillPointsLeft.setValue(currentPC.getSkillPoints());
    }

    private void currCharacterClassActionPerformed() {
        PCLevelInfo pcl = this.getSelectedLevelInfo(this.pc);
        boolean oldFlag = resetSelectedModel;
        PCClass aClass = null;
        if (pcl != null) {
            this.currCharClassSkillPnts.setValue(pcl.getSkillPointsRemaining(this.pc));
            this.totalSkillPointsLeft.setValue(this.pc.getSkillPoints());
            aClass = this.pc.getClassNamed(pcl.getClassKeyName());
            resetSelectedModel = aClass != previouslySelectedClass;
        } else {
            this.currCharClassSkillPnts.setValue(0);
            this.totalSkillPointsLeft.setValue(0);
        }
        this.updateSelectedModel();
        this.updateAvailableModel();
        previouslySelectedClass = aClass;
        resetSelectedModel = oldFlag;
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.getStatusBar().setText("");
        this.refresh();
        int s = this.splitPane.getDividerLocation();
        int t = this.bsplit.getDividerLocation();
        int u = this.asplit.getDividerLocation();
        if (!this.hasBeenSized) {
            int width;
            int i;
            this.hasBeenSized = true;
            s = SettingsHandler.getPCGenOption("InfoSkills.splitPane", (int)(this.getSize().getWidth() * 4.0 / 10.0));
            t = SettingsHandler.getPCGenOption("InfoSkills.bsplit", (int)(this.getSize().getHeight() - 101.0));
            u = SettingsHandler.getPCGenOption("InfoSkills.asplit", (int)(this.getSize().getWidth() - 408.0));
            TableColumnModel selectedTableColumnModel = this.selectedTable.getColumnModel();
            for (i = 0; i < this.selectedTable.getColumnCount(); ++i) {
                TableColumn sCol = selectedTableColumnModel.getColumn(i);
                width = Globals.getCustColumnWidth("InfoSel", i);
                if (width != 0) {
                    sCol.setPreferredWidth(width);
                }
                sCol.addPropertyChangeListener(new ResizeColumnListener(this.selectedTable, "InfoSel", i));
                if (i != 5) continue;
                sCol.setCellEditor(new OutputOrderEditor(new String[]{PropertyFactory.getString("in_iskFirst"), PropertyFactory.getString("in_iskLast"), PropertyFactory.getString("in_iskHidden")}));
            }
            for (i = 0; i < this.availableTable.getColumnCount(); ++i) {
                TableColumnModel availableTableColumnModel = this.availableTable.getColumnModel();
                TableColumn sCol = availableTableColumnModel.getColumn(i);
                width = Globals.getCustColumnWidth("InfoAva", i);
                if (width != 0) {
                    sCol.setPreferredWidth(width);
                }
                sCol.addPropertyChangeListener(new ResizeColumnListener(this.availableTable, "InfoAva", i));
            }
        }
        if (s > 0) {
            this.splitPane.setDividerLocation(s);
            SettingsHandler.setPCGenOption("InfoSkills.splitPane", s);
        }
        if (t > 0) {
            this.bsplit.setDividerLocation(t);
            SettingsHandler.setPCGenOption("InfoSkills.bsplit", t);
        }
        if (u > 0) {
            this.asplit.setDividerLocation(u);
            SettingsHandler.setPCGenOption("InfoSkills.asplit", u);
        }
    }

    private void hookupPopupMenu(JTreeTable treeTable) {
        treeTable.addMouseListener(new SkillPopupListener(treeTable, new SkillPopupMenu(treeTable)));
    }

    private void initActionListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                InfoSkills.this.formComponentShown();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                InfoSkills.this.saveDividerLocations();
            }
        });
        this.asplit.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                InfoSkills.this.saveDividerLocations();
            }
        });
        this.bsplit.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                InfoSkills.this.saveDividerLocations();
            }
        });
        this.splitPane.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                InfoSkills.this.saveDividerLocations();
            }
        });
        this.leftButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoSkills.this.addSkill(-1);
            }
        });
        this.addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoSkills.this.addSkill(1);
            }
        });
        this.viewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoSkills.this.viewComboBoxActionPerformed();
            }
        });
        this.viewSelectComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoSkills.this.viewSelectComboBoxActionPerformed();
            }
        });
        this.outputOrderComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoSkills.this.outputOrderComboBoxActionPerformed();
            }
        });
        FilterFactory.restoreFilterSettings(this);
    }

    private void initComponents() {
        this.readyForRefresh = true;
        int iView = SettingsHandler.getSkillsTab_AvailableListMode();
        if (iView >= 0 && iView <= 5) {
            viewMode = iView;
        }
        SettingsHandler.setSkillsTab_AvailableListMode(viewMode);
        iView = SettingsHandler.getSkillsTab_SelectedListMode();
        if (iView >= 0 && iView <= 5) {
            viewSelectMode = iView;
        }
        SettingsHandler.setSkillsTab_SelectedListMode(viewSelectMode);
        this.viewComboBox.addItem(PropertyFactory.getString("in_iskKeyStat_SubType_Name"));
        this.viewComboBox.addItem(PropertyFactory.getString("in_iskKeyStat_Name"));
        this.viewComboBox.addItem(PropertyFactory.getString("in_iskSubType_Name"));
        this.viewComboBox.addItem(PropertyFactory.getString("in_iskCost_SubType_Name"));
        this.viewComboBox.addItem(PropertyFactory.getString("in_iskCost_Name"));
        this.viewComboBox.addItem(PropertyFactory.getString("in_iskName"));
        Utility.setDescription(this.viewComboBox, PropertyFactory.getString("in_iskSkill_display_order_tooltip"));
        this.viewComboBox.setSelectedIndex(viewMode);
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_iskKeyStat_SubType_Name"));
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_iskKeyStat_Name"));
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_iskSubType_Name"));
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_iskCost_SubType_Name"));
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_iskCost_Name"));
        this.viewSelectComboBox.addItem(PropertyFactory.getString("in_iskName"));
        Utility.setDescription(this.viewSelectComboBox, PropertyFactory.getString("in_iskSkill_display_order_tooltip"));
        this.viewSelectComboBox.setSelectedIndex(viewSelectMode);
        this.outputOrderComboBox.addItem(PropertyFactory.getString("in_iskBy_name_ascending"));
        this.outputOrderComboBox.addItem(PropertyFactory.getString("in_iskBy_name_descending"));
        this.outputOrderComboBox.addItem(PropertyFactory.getString("in_iskBy_trained_then_untrained"));
        this.outputOrderComboBox.addItem(PropertyFactory.getString("in_iskBy_untrained_then_trained"));
        this.outputOrderComboBox.addItem(PropertyFactory.getString("in_iskManual"));
        Utility.setDescription(this.outputOrderComboBox, PropertyFactory.getString("in_iskSkill_output_order_tooltip"));
        this.outputOrderComboBox.setSelectedIndex(selectedOutputOrder);
        this.createModels();
        this.createTreeTables();
        this.center.setLayout(new BorderLayout());
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel leftPane = new JPanel();
        JPanel rightPane = new JPanel();
        leftPane.setLayout(gridbag);
        this.splitPane = new FlippingSplitPane(splitOrientation, leftPane, rightPane);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.center.add((Component)this.splitPane, "Center");
        Utility.buildConstraints(c, 0, 0, 1, 1, 100.0, 5.0);
        c.fill = 0;
        c.anchor = 10;
        JPanel aPanel = new JPanel();
        gridbag.setConstraints(aPanel, c);
        aPanel.add(this.avaLabel);
        aPanel.add(this.viewComboBox);
        ImageIcon newImage = IconUtilitities.getImageIcon("Forward16.gif");
        this.addButton = new JButton(newImage);
        Utility.setDescription(this.addButton, PropertyFactory.getString("in_iskAdd_skill_tooltip"));
        this.addButton.setEnabled(false);
        aPanel.add(this.addButton);
        leftPane.add(aPanel);
        this.availableTable.setColAlign(1, 0);
        this.availableTable.getColumnModel().getColumn(1).setPreferredWidth(15);
        this.selectedTable.getColumnModel().getColumn(0).setPreferredWidth(60);
        this.selectedTable.setColAlign(1, 0);
        this.selectedTable.getColumnModel().getColumn(1).setPreferredWidth(15);
        this.selectedTable.setColAlign(2, 0);
        this.selectedTable.getColumnModel().getColumn(2).setPreferredWidth(15);
        this.selectedTable.setColAlign(3, 0);
        this.selectedTable.getColumnModel().getColumn(3).setPreferredWidth(15);
        this.selectedTable.setColAlign(4, 0);
        this.selectedTable.getColumnModel().getColumn(4).setPreferredWidth(15);
        this.selectedTable.getColumnModel().getColumn(5).setCellRenderer(new OutputOrderRenderer());
        this.selectedTable.getColumnModel().getColumn(5).setPreferredWidth(15);
        Utility.buildConstraints(c, 0, 1, 1, 1, 0.0, 95.0);
        c.fill = 1;
        c.anchor = 10;
        JScrollPane scrollPane = new JScrollPane(this.availableTable);
        gridbag.setConstraints(scrollPane, c);
        leftPane.add(scrollPane);
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        rightPane.setLayout(gridbag);
        Utility.buildConstraints(c, 0, 0, 1, 1, 100.0, 5.0);
        c.fill = 0;
        c.anchor = 10;
        aPanel = new JPanel();
        gridbag.setConstraints(aPanel, c);
        aPanel.add(this.selLabel);
        aPanel.add(this.viewSelectComboBox);
        newImage = IconUtilitities.getImageIcon("Back16.gif");
        this.leftButton = new JButton(newImage);
        Utility.setDescription(this.leftButton, PropertyFactory.getString("in_iskRemove_skill_tooltip"));
        this.leftButton.setEnabled(false);
        aPanel.add(this.leftButton);
        rightPane.add(aPanel);
        Utility.buildConstraints(c, 0, 1, 1, 1, 0.0, 95.0);
        c.fill = 1;
        c.anchor = 10;
        scrollPane = new JScrollPane(this.selectedTable);
        gridbag.setConstraints(scrollPane, c);
        rightPane.add(scrollPane);
        TitledBorder title1 = BorderFactory.createTitledBorder(this.etched, PropertyFactory.getString("in_iskSkill_Info"));
        title1.setTitleJustification(2);
        this.cScroll.setBorder(title1);
        this.infoLabel.setBackground(rightPane.getBackground());
        this.cScroll.setViewportView(this.infoLabel);
        this.jPanel1.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        this.jLbMaxSkill.setText(PropertyFactory.getString("in_iskMax_Class_Skill_Rank"));
        Utility.setDescription(this.jLbMaxSkill, PropertyFactory.getString("in_iskMax_Class_Skill_Rank_tooltip"));
        this.jLbMaxSkill.setForeground(Color.black);
        Utility.buildConstraints(gridBagConstraints2, 0, 0, 1, 1, 5.0, 5.0);
        gridBagConstraints2.anchor = 13;
        this.jPanel1.add((Component)this.jLbMaxSkill, gridBagConstraints2);
        this.maxSkillRank.setForeground(Color.black);
        Utility.buildConstraints(gridBagConstraints2, 1, 0, 1, 1, 5.0, 5.0);
        gridBagConstraints2.anchor = 17;
        this.jPanel1.add((Component)this.maxSkillRank, gridBagConstraints2);
        this.jLbMaxCrossSkill.setText(PropertyFactory.getString("in_iskMax_Cross-Class_Skill_Rank"));
        Utility.setDescription(this.jLbMaxCrossSkill, PropertyFactory.getString("in_iskMax_Cross-Class_Skill_Rank_tooltip"));
        this.jLbMaxCrossSkill.setForeground(Color.black);
        Utility.buildConstraints(gridBagConstraints2, 0, 1, 1, 1, 5.0, 5.0);
        gridBagConstraints2.anchor = 13;
        this.jPanel1.add((Component)this.jLbMaxCrossSkill, gridBagConstraints2);
        this.maxCrossSkillRank.setForeground(Color.black);
        Utility.buildConstraints(gridBagConstraints2, 1, 1, 1, 1, 5.0, 5.0);
        gridBagConstraints2.anchor = 17;
        this.jPanel1.add((Component)this.maxCrossSkillRank, gridBagConstraints2);
        Utility.buildConstraints(gridBagConstraints2, 2, 1, 1, 1, 5.0, 5.0);
        gridBagConstraints2.anchor = 13;
        this.jPanel1.add((Component)new JLabel(PropertyFactory.getString("in_iskSkill_output_order")), gridBagConstraints2);
        Utility.buildConstraints(gridBagConstraints2, 3, 1, 1, 1, 5.0, 5.0);
        gridBagConstraints2.anchor = 17;
        this.jPanel1.add((Component)this.outputOrderComboBox, gridBagConstraints2);
        this.jLbClassSkillPoints.setText(PropertyFactory.getString("in_iskSkill_Points_Left_for_Class"));
        this.jLbClassSkillPoints.setForeground(Color.black);
        Utility.buildConstraints(gridBagConstraints2, 0, 3, 2, 1, 5.0, 5.0);
        gridBagConstraints2.anchor = 13;
        this.jPanel1.add((Component)this.jLbClassSkillPoints, gridBagConstraints2);
        this.currCharacterClass.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoSkills.this.currCharacterClassActionPerformed();
            }
        });
        Utility.buildConstraints(gridBagConstraints2, 2, 3, 1, 1, 5.0, 5.0);
        gridBagConstraints2.anchor = 10;
        int oldFill = gridBagConstraints2.fill;
        gridBagConstraints2.fill = 2;
        this.jPanel1.add((Component)this.currCharacterClass, gridBagConstraints2);
        gridBagConstraints2.fill = oldFill;
        this.jLbTotalSkillPointsLeft.setText(PropertyFactory.getString("in_iskTotal_Skill_Points_Left"));
        this.jLbTotalSkillPointsLeft.setForeground(Color.black);
        Utility.buildConstraints(gridBagConstraints2, 2, 2, 1, 1, 5.0, 5.0);
        gridBagConstraints2.anchor = 13;
        this.jPanel1.add((Component)this.jLbTotalSkillPointsLeft, gridBagConstraints2);
        this.totalSkillPointsLeft.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                InfoSkills.this.totalSkillPointsLeftFocusLost();
            }
        });
        Utility.buildConstraints(gridBagConstraints2, 3, 2, 1, 1, 5.0, 5.0);
        gridBagConstraints2.anchor = 17;
        this.totalSkillPointsLeft.setMinimumSize(new Dimension(40, 17));
        this.totalSkillPointsLeft.setPreferredSize(new Dimension(40, 17));
        this.jPanel1.add((Component)this.totalSkillPointsLeft, gridBagConstraints2);
        this.currCharClassSkillPnts.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                InfoSkills.this.currCharClassSkillPntsFocusLost();
            }
        });
        Utility.buildConstraints(gridBagConstraints2, 3, 3, 1, 1, 5.0, 5.0);
        gridBagConstraints2.anchor = 17;
        this.currCharClassSkillPnts.setPreferredSize(new Dimension(40, 20));
        this.currCharClassSkillPnts.setMinimumSize(new Dimension(40, 20));
        this.jPanel1.add((Component)this.currCharClassSkillPnts, gridBagConstraints2);
        this.includeLabel = new JLabel(PropertyFactory.getString("in_iskInclude_Skills"));
        Utility.buildConstraints(gridBagConstraints2, 2, 0, 1, 1, 5.0, 5.0);
        gridBagConstraints2.anchor = 13;
        this.jPanel1.add((Component)this.includeLabel, gridBagConstraints2);
        this.skillChoice.setModel(new DefaultComboBoxModel<String>(new String[]{PropertyFactory.getString("in_iskNone"), PropertyFactory.getString("in_iskUntrained"), PropertyFactory.getString("in_iskAll")}));
        this.skillChoice.setMaximumRowCount(3);
        Utility.setDescription(this.skillChoice, PropertyFactory.getString("in_iskDisplayed_skills_tooltip"));
        this.skillChoice.setMinimumSize(new Dimension(98, 22));
        this.skillChoice.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoSkills.this.skillChoiceActionPerformed();
            }
        });
        boolean oldFlag = resetSelectedModel;
        resetSelectedModel = true;
        this.skillChoice.setSelectedIndex(SettingsHandler.getSkillsTab_IncludeSkills());
        resetSelectedModel = oldFlag;
        Utility.buildConstraints(gridBagConstraints2, 3, 0, 1, 1, 5.0, 5.0);
        gridBagConstraints2.anchor = 17;
        this.jPanel1.add((Component)this.skillChoice, gridBagConstraints2);
        this.exclusiveLabel = new JLabel(PropertyFactory.getString("in_iskExclusive_skill_cost"));
        Utility.setDescription(this.exclusiveLabel, PropertyFactory.getString("in_iskExclusive_skill_cost_tooltip"));
        Utility.buildConstraints(gridBagConstraints2, 0, 2, 1, 1, 5.0, 5.0);
        gridBagConstraints2.anchor = 13;
        this.jPanel1.add((Component)this.exclusiveLabel, gridBagConstraints2);
        this.exclusiveSkillCost.setColumns(3);
        this.exclusiveSkillCost.setText("0");
        this.exclusiveSkillCost.setMinimumSize(new Dimension(40, 17));
        this.exclusiveSkillCost.setText(Integer.toString(SettingsHandler.getExcSkillCost()));
        this.exclusiveSkillCost.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoSkills.this.updateSkillCost();
            }
        });
        this.exclusiveSkillCost.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent evt) {
                InfoSkills.this.excCostFocusEvent();
            }
        });
        Utility.buildConstraints(gridBagConstraints2, 1, 2, 1, 1, 5.0, 5.0);
        gridBagConstraints2.anchor = 17;
        this.jPanel1.add((Component)this.exclusiveSkillCost, gridBagConstraints2);
        this.asplit = new FlippingSplitPane(1, this.cScroll, this.jPanel1);
        this.asplit.setOneTouchExpandable(true);
        this.asplit.setDividerSize(10);
        JPanel botPane = new JPanel();
        botPane.setLayout(new BorderLayout());
        botPane.add((Component)this.asplit, "Center");
        this.bsplit = new FlippingSplitPane(0, this.center, botPane);
        this.bsplit.setOneTouchExpandable(true);
        this.bsplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bsplit, "Center");
        this.availableSort = new JTreeTableSorter(this.availableTable, (PObjectNode)this.availableModel.getRoot(), this.availableModel);
        this.selectedSort = new JTreeTableSorter(this.selectedTable, (PObjectNode)this.selectedModel.getRoot(), this.selectedModel);
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                InfoSkills.this.refresh();
            }
        });
    }

    private boolean modRank(Skill aSkill, double points) {
        if (CoreUtility.doublesEqual(points, 0.0)) {
            return false;
        }
        int ix = this.currCharacterClass.getSelectedIndex();
        if (points > 0.0) {
            this.updateClassSelection();
        }
        PCLevelInfo pcl = this.getSelectedLevelInfo(this.pc);
        if (ix != this.currCharacterClass.getSelectedIndex()) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_iskErr_message_03a") + pcl.getClassKeyName() + "/" + pcl.getLevel() + PropertyFactory.getString("in_iskErr_message_03b"), "PCGen", MessageType.INFORMATION);
            return false;
        }
        int skillPool = pcl.getSkillPointsRemaining(this.pc);
        if (points > 0.0 && points > (double)skillPool) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_iskErr_message_04a") + skillPool + PropertyFactory.getString("in_iskErr_message_04b"), "PCGen", MessageType.INFORMATION);
            return false;
        }
        if (points < 0.0 && (double)skillPool - points > (double)pcl.getSkillPointsGained(this.pc)) {
            ShowMessageDelegate.showMessageDialog(pcl.getClassKeyName() + "/" + pcl.getLevel() + PropertyFactory.getString("in_iskErr_message_05a") + pcl.getSkillPointsGained(this.pc) + PropertyFactory.getString("in_iskSkill_points"), "PCGen", MessageType.INFORMATION);
            return false;
        }
        Skill bSkill = aSkill;
        PCClass aClass = this.getSelectedPCClass();
        double cost = aSkill.costForPCClass(aClass, this.pc).doubleValue();
        if (CoreUtility.doublesEqual(cost, 0.0)) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_iskErr_message_06"), "PCGen", MessageType.INFORMATION);
            return false;
        }
        double rank = points / cost;
        if (aSkill != null) {
            bSkill = this.pc.addSkill(aSkill);
            Collections.sort(this.pc.getSkillList(), new StringIgnoreCaseComparator());
            if (selectedOutputOrder != 4) {
                this.resortSelected(selectedOutputOrder);
            } else if (bSkill.getOutputIndex() == 0) {
                bSkill.setOutputIndex(this.getHighestOutputIndex() + 1);
            }
        }
        String aString = "";
        if (bSkill != null) {
            aString = bSkill.modRanks(rank, aClass, this.pc);
            if ("".equals(aString)) {
                pcl.setSkillPointsRemaining(skillPool - (int)points, this.pc);
            }
            this.updateClassSelection();
            if (CoreUtility.doublesEqual(bSkill.getRank().doubleValue(), 0.0) && bSkill.getUntrained().charAt(0) != 'Y') {
                this.pc.getSkillList().remove(bSkill);
            }
        }
        if (aString.length() > 0) {
            ShowMessageDelegate.showMessageDialog(aString, "PCGen", MessageType.INFORMATION);
            return false;
        }
        return true;
    }

    private void outputOrderComboBoxActionPerformed() {
        int index = this.outputOrderComboBox.getSelectedIndex();
        if (index != selectedOutputOrder) {
            selectedOutputOrder = index;
            this.resortSelected(selectedOutputOrder);
            if (this.pc != null) {
                this.pc.setDirty(true);
                this.pc.setSkillsOutputOrder(selectedOutputOrder);
            }
        }
    }

    private void resortSelected(int sortSelection) {
        int sort = -1;
        boolean sortOrder = false;
        switch (sortSelection) {
            case 0: {
                sort = 0;
                sortOrder = true;
                break;
            }
            case 1: {
                sort = 0;
                sortOrder = false;
                break;
            }
            case 2: {
                sort = 1;
                sortOrder = true;
                break;
            }
            case 3: {
                sort = 1;
                sortOrder = false;
                break;
            }
            default: {
                this.updateSelectedModel();
                return;
            }
        }
        this.resortSelected(sort, sortOrder);
    }

    private void resortSelected(int sort, boolean sortOrder) {
        if (this.pc == null) {
            return;
        }
        SkillComparator comparator = new SkillComparator(sort, sortOrder);
        int nextOutputIndex = 1;
        ArrayList skillList = this.pc.getSkillList();
        Collections.sort(skillList, comparator);
        Iterator sI = skillList.iterator();
        while (sI.hasNext()) {
            Skill aSkill = (Skill)sI.next();
            if (aSkill.getOutputIndex() < 0) continue;
            aSkill.setOutputIndex(nextOutputIndex++);
        }
        this.updateSelectedModel();
    }

    private void saveDividerLocations() {
        int s = this.splitPane.getDividerLocation();
        if (s > 0) {
            SettingsHandler.setPCGenOption("InfoSkills.splitPane", s);
        }
        if ((s = this.asplit.getDividerLocation()) > 0) {
            SettingsHandler.setPCGenOption("InfoSkills.asplit", s);
        }
        if ((s = this.bsplit.getDividerLocation()) > 0) {
            SettingsHandler.setPCGenOption("InfoSkills.bsplit", s);
        }
    }

    private void skillChoiceActionPerformed() {
        int selection = this.skillChoice.getSelectedIndex();
        int oldSelection = SettingsHandler.getSkillsTab_IncludeSkills();
        if (selection >= 0 && selection <= 2 && (selection != oldSelection || resetSelectedModel)) {
            SettingsHandler.setSkillsTab_IncludeSkills(selection);
            this.pc.populateSkills(SettingsHandler.getSkillsTab_IncludeSkills(), 3);
            this.updateSelectedModel();
        }
    }

    private void totalSkillPointsLeftFocusLost() {
        PlayerCharacter currentPC = this.pc;
        currentPC.setDirty(true);
        if (this.totalSkillPointsLeft.getText().length() > 0) {
            PCClass aClass;
            int anInt = Delta.decode(this.totalSkillPointsLeft.getText());
            if (anInt == currentPC.getSkillPoints()) {
                return;
            }
            currentPC.setSkillPoints(anInt);
            int x = currentPC.getClassList().size();
            int y = anInt / x;
            Iterator i = currentPC.getClassList().iterator();
            while (i.hasNext()) {
                aClass = (PCClass)i.next();
                aClass.setSkillPool(Math.max(0, y));
            }
            PCLevelInfo pcl = this.getSelectedLevelInfo(currentPC);
            int skillPool = pcl.getSkillPointsRemaining(this.pc);
            aClass = this.getSelectedPCClass();
            if (aClass != null) {
                this.currCharClassSkillPnts.setValue(skillPool);
            }
        }
        this.totalSkillPointsLeft.setValue(currentPC.getSkillPoints());
    }

    private final void updateCharacterInfo() {
        PlayerCharacter bPC = this.pc;
        if (bPC != this.pc) {
            needsUpdate = true;
        }
        if (bPC != null && needsUpdate) {
            selectedOutputOrder = bPC.getSkillsOutputOrder();
            this.outputOrderComboBox.setSelectedIndex(selectedOutputOrder);
            bPC.getAllSkillList(true);
            resetSelectedModel = true;
            previouslySelectedClass = null;
            this.resortSelected(selectedOutputOrder);
        }
        this.pc = bPC;
        if (this.pc == null || !needsUpdate) {
            return;
        }
        this.pc.setAggregateFeatsStable(false);
        this.pc.setAutomaticFeatsStable(false);
        this.pc.setVirtualFeatsStable(false);
        this.updateClassSelection();
        PCLevelInfo pcl = this.getSelectedLevelInfo(this.pc);
        if (pcl != null) {
            this.currCharClassSkillPnts.setValue(pcl.getSkillPointsRemaining(this.pc));
            this.totalSkillPointsLeft.setValue(this.pc.getSkillPoints());
        } else {
            this.currCharClassSkillPnts.setValue(0);
            this.totalSkillPointsLeft.setValue(0);
        }
        if (SettingsHandler.isMonsterDefault()) {
            this.maxSkillRank.setText(String.valueOf(PlayerCharacter.maxClassSkillForLevel(this.pc.getTotalLevels() + this.pc.totalHitDice(), this.pc)));
            this.maxCrossSkillRank.setText(String.valueOf(PlayerCharacter.maxCrossClassSkillForLevel(this.pc.getTotalLevels() + this.pc.totalHitDice(), this.pc)));
        } else {
            this.maxSkillRank.setText(String.valueOf(PlayerCharacter.maxClassSkillForLevel(this.pc.getTotalLevels(), this.pc)));
            this.maxCrossSkillRank.setText(String.valueOf(PlayerCharacter.maxCrossClassSkillForLevel(this.pc.getTotalLevels(), this.pc)));
        }
        resetSelectedModel = true;
        this.updateAvailableModel();
        this.updateSelectedModel();
        this.pc.aggregateFeatList();
        this.pc.setAggregateFeatsStable(true);
        this.pc.setAutomaticFeatsStable(true);
        this.pc.setVirtualFeatsStable(true);
        needsUpdate = false;
    }

    private final void updateClassSelection() {
        resetSelectedModel = false;
        this.currCharacterClass.removeAllItems();
        Iterator i = this.pc.getLevelInfo().iterator();
        while (i.hasNext()) {
            PCLevelInfo pcl = (PCLevelInfo)i.next();
            this.currCharacterClass.addItem(pcl.getClassKeyName() + "/" + pcl.getLevel() + " [" + pcl.getSkillPointsRemaining(this.pc) + "/" + pcl.getSkillPointsGained(this.pc) + "]");
        }
        resetSelectedModel = true;
        if (this.currCharacterClass.getItemCount() > 0) {
            this.setCurrentClassCombo();
        }
    }

    private final void updateSkillCost() {
        try {
            SettingsHandler.setExcSkillCost(Integer.parseInt(this.exclusiveSkillCost.getText()));
        }
        catch (NumberFormatException nfe) {
            this.exclusiveSkillCost.setText(Integer.toString(SettingsHandler.getExcSkillCost()));
        }
    }

    private void setInfoLabelText(Skill aSkill) {
        this.lastSkill = aSkill;
        if (aSkill != null) {
            StringBuffer b = new StringBuffer();
            b.append("<html><b>").append(aSkill.piSubString()).append("</b>");
            b.append(PropertyFactory.getString("in_iskHtml_MAXRANK")).append(this.pc.getMaxRank(aSkill.getName(), this.getSelectedPCClass()).doubleValue());
            b.append(PropertyFactory.getString("in_iskHtml_TYPE")).append(aSkill.getType());
            b.append(PropertyFactory.getString("in_iskHtml_KEY_STAT")).append(aSkill.getKeyStat());
            b.append(PropertyFactory.getString("in_iskHtml_UNTRAINED")).append(aSkill.getUntrained());
            b.append(PropertyFactory.getString("in_iskHtml_EXCLUSIVE")).append(aSkill.getExclusive());
            String bString = aSkill.getSource();
            if (bString.length() > 0) {
                b.append(PropertyFactory.getString("in_iskHtml_SOURCE")).append(bString);
            }
            b.append("</html>");
            this.infoLabel.setText(b.toString());
        }
    }

    private void excCostFocusEvent() {
        this.updateSkillCost();
    }

    private void updateAvailableModel() {
        List pathList = this.availableTable.getExpandedPaths();
        this.createAvailableModel();
        this.availableTable.updateUI();
        this.availableTable.expandPathList(pathList);
    }

    private void updateSelectedModel() {
        List pathList = this.selectedTable.getExpandedPaths();
        this.createSelectedModel();
        try {
            this.selectedTable.updateUI();
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
            e.printStackTrace();
        }
        this.selectedTable.expandPathList(pathList);
    }

    private void viewComboBoxActionPerformed() {
        int index = this.viewComboBox.getSelectedIndex();
        if (index != viewMode) {
            viewMode = index;
            SettingsHandler.setSkillsTab_AvailableListMode(viewMode);
            this.updateAvailableModel();
        }
    }

    private void viewSelectComboBoxActionPerformed() {
        int index = this.viewSelectComboBox.getSelectedIndex();
        if (index != viewSelectMode) {
            viewSelectMode = index;
            SettingsHandler.setSkillsTab_SelectedListMode(viewSelectMode);
            this.updateSelectedModel();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SkillPopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = -5369872214039221832L;
        private JMenu resortMenu = null;

        SkillPopupMenu(JTreeTable treeTable) {
            if (treeTable == InfoSkills.this.availableTable) {
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_1"), 1, "shortcut EQUALS"));
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_2"), 2, null));
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_5"), 5, null));
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_10"), 10, null));
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_n"), -1, "alt A"));
                this.add(this.createMaxMenuItem(PropertyFactory.getString("in_iskMax_Ranks"), "alt M"));
            } else {
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_1"), 1, "shortcut EQUALS"));
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_2"), 2, null));
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_5"), 5, null));
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_10"), 10, null));
                this.add(this.createAddMenuItem(PropertyFactory.getString("in_iskAdd_n"), -1, "alt A"));
                this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_iskRemove_1"), 1, "shortcut MINUS"));
                this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_iskRemove_2"), 2, null));
                this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_iskRemove_5"), 5, null));
                this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_iskRemove_10"), 10, null));
                this.add(this.createRemoveMenuItem(PropertyFactory.getString("in_iskRemove_n"), -1, "alt R"));
                this.add(this.createMaxMenuItem(PropertyFactory.getString("in_iskMax_Ranks"), "alt M"));
                this.add(this.createResetMenuItem(PropertyFactory.getString("in_iskZero_Ranks"), "alt Z"));
                this.addSeparator();
                this.resortMenu = Utility.createMenu("Output Order", '\u0000', PropertyFactory.getString("in_iskOutput_Order"), null, true);
                this.add(this.resortMenu);
                this.resortMenu.add(Utility.createMenuItem(PropertyFactory.getString("in_iskBy_name_ascending"), new ResortActionListener(0, true), "sortOutput", '\u0000', null, PropertyFactory.getString("in_iskBy_name_ascending_tooltip"), null, true));
                this.resortMenu.add(Utility.createMenuItem(PropertyFactory.getString("in_iskBy_name_descending"), new ResortActionListener(0, false), "sortOutput", '\u0000', null, PropertyFactory.getString("in_iskBy_name_descending_tooltip"), null, true));
                this.resortMenu.add(Utility.createMenuItem(PropertyFactory.getString("in_iskBy_trained_then_untrained"), new ResortActionListener(1, true), "sortOutput", '\u0000', null, PropertyFactory.getString("in_iskBy_trained_then_untrained_tooltip"), null, true));
                this.resortMenu.add(Utility.createMenuItem(PropertyFactory.getString("in_iskBy_untrained_then_trained"), new ResortActionListener(1, false), "sortOutput", '\u0000', null, PropertyFactory.getString("in_iskBy_untrained_then_trained_tooltip"), null, true));
            }
        }

        private JMenuItem createAddMenuItem(String label, int qty, String accelerator) {
            return Utility.createMenuItem(label, new AddSkillActionListener(qty), "add " + qty, '\u0000', accelerator, PropertyFactory.getString("in_iskAdd") + (qty < 0 ? PropertyFactory.getString("in_iskn") : Integer.toString(qty)) + PropertyFactory.getString("in_isk_skill_point") + (qty == 1 ? "" : PropertyFactory.getString("in_isks")), "Add16.gif", true);
        }

        private JMenuItem createMaxMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new MaxSkillActionListener(0), "max ranks", '\u0000', accelerator, PropertyFactory.getString("in_iskSet_to_max_ranks"), "Add16.gif", true);
        }

        private JMenuItem createRemoveMenuItem(String label, int qty, String accelerator) {
            return Utility.createMenuItem(label, new RemoveSkillActionListener(qty), "remove " + qty, '\u0000', accelerator, PropertyFactory.getString("in_iskRemove") + (qty < 0 ? PropertyFactory.getString("in_iskn") : Integer.toString(qty)) + PropertyFactory.getString("in_isk_skill_point") + (qty == 1 ? "" : PropertyFactory.getString("in_isks")), "Remove16.gif", true);
        }

        private JMenuItem createResetMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new ResetSkillActionListener(0), "reset ranks", '\u0000', accelerator, PropertyFactory.getString("in_iskReset_to_zero_ranks"), "Add16.gif", true);
        }

        public JMenu getResortMenu() {
            return this.resortMenu;
        }

        public void setResortMenu(JMenu resortMenu) {
            this.resortMenu = resortMenu;
        }

        private class SkillActionListener
        implements ActionListener {
            int qty = 0;

            private SkillActionListener(int aQty) {
                this.qty = aQty;
            }

            public void actionPerformed(ActionEvent evt) {
            }
        }

        private class ResetSkillActionListener
        extends SkillActionListener {
            private ResetSkillActionListener(int qty) {
                super(qty);
            }

            public void actionPerformed(ActionEvent evt) {
                Skill aSkill = InfoSkills.this.pc.getSkillNamed(InfoSkills.this.getSelectedSkill().getName());
                if (aSkill != null) {
                    Iterator iter = InfoSkills.this.pc.getClassList().iterator();
                    while (iter.hasNext()) {
                        PCClass aClass = (PCClass)iter.next();
                        int cost = aSkill.costForPCClass(InfoSkills.this.getSelectedPCClass(), InfoSkills.this.pc);
                        double points = -aSkill.getTotalRank(InfoSkills.this.pc).doubleValue() * (double)cost;
                        InfoSkills.this.addSkill((int)points);
                    }
                    if (CoreUtility.doublesEqual(aSkill.getRank().doubleValue(), 0.0) && aSkill.getUntrained().charAt(0) != 'Y') {
                        InfoSkills.this.pc.getSkillList().remove(aSkill);
                    }
                    InfoSkills.this.updateSelectedModel();
                    InfoSkills.this.currCharacterClassActionPerformed();
                }
            }
        }

        private class RemoveSkillActionListener
        extends SkillActionListener {
            private RemoveSkillActionListener(int qty) {
                super(qty);
            }

            public void actionPerformed(ActionEvent evt) {
                int newQty = this.qty;
                if (this.qty < 0) {
                    String selectedValue = JOptionPane.showInputDialog(null, PropertyFactory.getString("in_iskRemove_quantity_tooltip"), "PCGen", 3);
                    if (selectedValue != null) {
                        try {
                            newQty = Math.abs(Integer.parseInt(selectedValue.trim()));
                        }
                        catch (NumberFormatException e) {
                            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_iskInvalid_number"), "PCGen", MessageType.ERROR);
                            return;
                        }
                    } else {
                        return;
                    }
                }
                InfoSkills.this.addSkill(-newQty);
            }
        }

        private class MaxSkillActionListener
        extends SkillActionListener {
            private MaxSkillActionListener(int qty) {
                super(qty);
            }

            public void actionPerformed(ActionEvent evt) {
                Skill aSkill = InfoSkills.this.getSelectedSkill();
                if (aSkill == null) {
                    return;
                }
                PlayerCharacter currentPC = InfoSkills.this.pc;
                currentPC.setDirty(true);
                Skill bSkill = currentPC.getSkillNamed(aSkill.getName());
                if (bSkill != null) {
                    aSkill = bSkill;
                }
                PCClass aClass = InfoSkills.this.getSelectedPCClass();
                PCLevelInfo pcl = InfoSkills.this.getSelectedLevelInfo(currentPC);
                double maxRank = 0.0;
                double skillPool = 0.0;
                if (aClass != null) {
                    maxRank = currentPC.getMaxRank(aSkill.getName(), aClass).doubleValue();
                    skillPool = pcl.getSkillPointsRemaining(InfoSkills.this.pc);
                }
                if (maxRank > aSkill.getRank().doubleValue() || Globals.checkRule("SKILLMAX")) {
                    int cost = aSkill.costForPCClass(InfoSkills.this.getSelectedPCClass(), InfoSkills.this.pc);
                    double pointsNeeded = Math.floor((maxRank - aSkill.getTotalRank(InfoSkills.this.pc).doubleValue()) * (double)cost);
                    Double points = new Double(Math.min(pointsNeeded, skillPool));
                    InfoSkills.this.addSkill(points.intValue());
                } else {
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_iskErr_message_01"), "PCGen", MessageType.INFORMATION);
                }
            }
        }

        private class AddSkillActionListener
        extends SkillActionListener {
            private AddSkillActionListener(int qty) {
                super(qty);
            }

            public void actionPerformed(ActionEvent evt) {
                int newQty = this.qty;
                if (this.qty < 0) {
                    String selectedValue = JOptionPane.showInputDialog(null, PropertyFactory.getString("in_iskAdd_quantity_tooltip"), "PCGen", 3);
                    if (selectedValue != null) {
                        try {
                            newQty = Math.abs(Integer.parseInt(selectedValue.trim()));
                        }
                        catch (NumberFormatException e) {
                            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_iskInvalid_number"), "PCGen", MessageType.ERROR);
                            return;
                        }
                    } else {
                        return;
                    }
                }
                InfoSkills.this.addSkill(newQty);
            }
        }
    }

    private class SkillPopupListener
    extends MouseAdapter {
        private JTree tree;
        private SkillPopupMenu menu;

        private SkillPopupListener(JTreeTable treeTable, SkillPopupMenu aMenu) {
            this.tree = treeTable.getTree();
            this.menu = aMenu;
            KeyListener myKeyListener = new KeyListener(this){
                private final /* synthetic */ SkillPopupListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTyped(KeyEvent e) {
                    SkillPopupListener.access$4000(this.this$1).dispatchEvent(e);
                }

                public void keyPressed(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    if (keyCode != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                        for (int i = 0; i < SkillPopupListener.access$4100(this.this$1).getComponentCount(); ++i) {
                            JMenuItem menuItem;
                            KeyStroke ks;
                            Component aComponent = SkillPopupListener.access$4100(this.this$1).getComponent(i);
                            if (!(aComponent instanceof JMenuItem) || (ks = (menuItem = (JMenuItem)aComponent).getAccelerator()) == null || !keyStroke.equals(ks)) continue;
                            InfoSkills.access$4202(SkillPopupListener.access$4000(this.this$1), SkillPopupListener.access$4300(this.this$1).getSelectionPath());
                            menuItem.doClick(2);
                            return;
                        }
                    }
                    SkillPopupListener.access$4000(this.this$1).dispatchEvent(e);
                }

                public void keyReleased(KeyEvent e) {
                    SkillPopupListener.access$4000(this.this$1).dispatchEvent(e);
                }
            };
            treeTable.addKeyListener(myKeyListener);
        }

        public void mousePressed(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        private void maybeShowPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                InfoSkills.this.selPath = this.tree.getClosestPathForLocation(evt.getX(), evt.getY());
                if (InfoSkills.this.selPath == null) {
                    return;
                }
                this.tree.setSelectionPath(InfoSkills.this.selPath);
                JMenu resortMenu = this.menu.getResortMenu();
                if (resortMenu != null) {
                    resortMenu.setEnabled(selectedOutputOrder == 4);
                }
                this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        static /* synthetic */ InfoSkills access$4000(SkillPopupListener x0) {
            return x0.InfoSkills.this;
        }

        static /* synthetic */ SkillPopupMenu access$4100(SkillPopupListener x0) {
            return x0.menu;
        }

        static /* synthetic */ JTree access$4300(SkillPopupListener x0) {
            return x0.tree;
        }
    }

    private class QualifyFilter
    extends AbstractPObjectFilter {
        private QualifyFilter() {
            super("Miscellaneous", "Qualify");
            if (SettingsHandler.isToolTipTextShown()) {
                this.setDescription(PropertyFactory.getString("in_iskFilter_qual_tooltip"));
            }
        }

        public boolean accept(PlayerCharacter pc, PObject pObject) {
            if (pObject == null) {
                return false;
            }
            if (pObject instanceof Skill) {
                PCClass pcClass = InfoSkills.this.getSelectedPCClass();
                Skill aSkill = (Skill)pObject;
                return pcClass != null && (!aSkill.isExclusive() || aSkill.isClassSkill(pcClass, pc));
            }
            return true;
        }
    }

    private class ExclusiveSkillFilter
    extends AbstractPObjectFilter {
        private ExclusiveSkillFilter() {
            super("Skill", "Exclusive");
            if (SettingsHandler.isToolTipTextShown()) {
                this.setDescription(PropertyFactory.getString("in_iskFilter_exclusive_tooltip"));
            }
        }

        public String getName(PlayerCharacter pc) {
            PCClass pcClass = InfoSkills.this.getSelectedPCClass();
            if (pcClass != null) {
                return super.getName(pc) + " (" + pcClass.getName() + ")";
            }
            return super.getName(pc);
        }

        public boolean accept(PlayerCharacter pc, PObject pObject) {
            if (pObject == null) {
                return false;
            }
            if (pObject instanceof Skill) {
                PCClass pcClass = InfoSkills.this.getSelectedPCClass();
                Skill aSkill = (Skill)pObject;
                return pcClass != null && !aSkill.isClassSkill(pcClass, pc) && aSkill.isExclusive();
            }
            return true;
        }
    }

    private class CrossClassSkillFilter
    extends AbstractPObjectFilter {
        private CrossClassSkillFilter() {
            super("Skill", "Cross-Class");
            if (SettingsHandler.isToolTipTextShown()) {
                this.setDescription(PropertyFactory.getString("in_iskFilter_crossclass_tooltip"));
            }
        }

        public String getName(PlayerCharacter pc) {
            PCClass pcClass = InfoSkills.this.getSelectedPCClass();
            if (pcClass != null) {
                return super.getName(pc) + " (" + pcClass.getName() + ")";
            }
            return super.getName(pc);
        }

        public boolean accept(PlayerCharacter pc, PObject pObject) {
            if (pObject == null) {
                return false;
            }
            if (pObject instanceof Skill) {
                PCClass pcClass = InfoSkills.this.getSelectedPCClass();
                Skill aSkill = (Skill)pObject;
                return pcClass != null && !aSkill.isClassSkill(pcClass, pc) && !aSkill.isExclusive();
            }
            return true;
        }
    }

    private class ClassSkillFilter
    extends AbstractPObjectFilter {
        private ClassSkillFilter() {
            super("Skill", "Class");
            if (SettingsHandler.isToolTipTextShown()) {
                this.setDescription(PropertyFactory.getString("in_iskFilter_class_tooltip"));
            }
        }

        public final String getName(PlayerCharacter pc) {
            PCClass pcClass = InfoSkills.this.getSelectedPCClass();
            if (pcClass != null) {
                return super.getName(pc) + " (" + pcClass.getName() + ")";
            }
            return super.getName(pc);
        }

        public boolean accept(PlayerCharacter pc, PObject pObject) {
            if (pObject == null) {
                return false;
            }
            if (pObject instanceof Skill) {
                PCClass pcClass = InfoSkills.this.getSelectedPCClass();
                return pcClass != null && ((Skill)pObject).isClassSkill(pcClass, pc);
            }
            return true;
        }
    }

    private final class SkillModel
    extends AbstractTreeTableModel {
        private final String[] availNameList = new String[]{PropertyFactory.getString("in_iskSkill"), PropertyFactory.getString("in_iskCost"), PropertyFactory.getString("in_iskSource")};
        private final String[] selNameList = new String[]{PropertyFactory.getString("in_iskSkill"), PropertyFactory.getString("in_iskModifier"), PropertyFactory.getString("in_iskRank"), PropertyFactory.getString("in_iskTotal"), PropertyFactory.getString("in_iskCost"), PropertyFactory.getString("in_iskOrder")};
        private int modelType = 0;

        private SkillModel(int mode, boolean available) {
            super(null);
            if (!available) {
                this.modelType = 1;
            }
            this.resetModel(mode, available);
        }

        public boolean isCellEditable(Object node, int column) {
            return column == 0 || this.modelType == 1 && column == 5 && ((PObjectNode)node).getItem() instanceof SkillWrapper;
        }

        public Class getColumnClass(int column) {
            column = this.adjustAvailColumnConst(column);
            switch (column) {
                case 0: {
                    return class$pcgen$gui$utils$TreeTableModel == null ? (class$pcgen$gui$utils$TreeTableModel = InfoSkills.class$("pcgen.gui.utils.TreeTableModel")) : class$pcgen$gui$utils$TreeTableModel;
                }
                case 1: {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = InfoSkills.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
                case 2: {
                    return class$java$lang$Float == null ? (class$java$lang$Float = InfoSkills.class$("java.lang.Float")) : class$java$lang$Float;
                }
                case 3: {
                    return class$java$lang$Float == null ? (class$java$lang$Float = InfoSkills.class$("java.lang.Float")) : class$java$lang$Float;
                }
                case 4: {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = InfoSkills.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
                case 6: {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = InfoSkills.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
                case 5: {
                    break;
                }
                default: {
                    Logging.errorPrint(PropertyFactory.getString("in_iskErr_message_08") + column + PropertyFactory.getString("in_isk_is_not_handled."));
                }
            }
            return class$java$lang$String == null ? (class$java$lang$String = InfoSkills.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            return this.modelType == 0 ? this.availNameList.length : this.selNameList.length;
        }

        public String getColumnName(int column) {
            return this.modelType == 0 ? this.availNameList[column] : this.selNameList[column];
        }

        public Object getRoot() {
            return (PObjectNode)super.getRoot();
        }

        public void setValueAt(Object aValue, Object node, int column) {
            boolean needRefresh = false;
            if (this.modelType != 1) {
                return;
            }
            if (!(((PObjectNode)node).getItem() instanceof SkillWrapper)) {
                return;
            }
            PObjectNode fn = (PObjectNode)node;
            SkillWrapper skillA = (SkillWrapper)fn.getItem();
            Skill aSkill = skillA.getSkWrapSkill();
            if (aSkill != null) {
                switch (column) {
                    case 5: {
                        int outputIndex = (Integer)aValue;
                        if (outputIndex == 1000) {
                            outputIndex = InfoSkills.this.getHighestOutputIndex() + 1;
                        } else if (outputIndex == 0) {
                            needRefresh = true;
                            outputIndex = 2;
                            Iterator skillListIter = InfoSkills.this.pc.getSkillListInOutputOrder().iterator();
                            while (skillListIter.hasNext()) {
                                Skill bSkill = (Skill)skillListIter.next();
                                if (bSkill.getOutputIndex() <= -1 || bSkill == aSkill) continue;
                                bSkill.setOutputIndex(outputIndex++);
                            }
                            outputIndex = 1;
                        } else if (outputIndex != -1) {
                            int workingIndex = 1;
                            needRefresh = true;
                            Iterator i = InfoSkills.this.pc.getSkillListInOutputOrder().iterator();
                            while (i.hasNext()) {
                                Skill bSkill = (Skill)i.next();
                                if (workingIndex == outputIndex) {
                                    ++workingIndex;
                                }
                                if (bSkill.getOutputIndex() <= -1 || bSkill == aSkill) continue;
                                bSkill.setOutputIndex(workingIndex++);
                            }
                        }
                        aSkill.setOutputIndex(outputIndex);
                        skillA = new SkillWrapper(aSkill, aSkill.modifier(InfoSkills.this.pc), aSkill.getTotalRank(InfoSkills.this.pc), new Integer(aSkill.getOutputIndex()));
                        fn.setItem(skillA);
                        if (!needRefresh) break;
                        InfoSkills.this.updateSelectedModel();
                        break;
                    }
                    default: {
                        Logging.errorPrint(PropertyFactory.getString("in_iskErr_message_11") + column + PropertyFactory.getString("in_isk_is_not_handled."));
                    }
                }
            }
        }

        public Object getValueAt(Object node, int column) {
            PObjectNode fn = (PObjectNode)node;
            if (fn == null) {
                Logging.errorPrint(PropertyFactory.getString("in_iskErr_message_09"));
                return null;
            }
            if (!(fn.getItem() instanceof SkillWrapper)) {
                return column == 0 ? fn.toString() : null;
            }
            SkillWrapper skillA = (SkillWrapper)fn.getItem();
            Skill aSkill = skillA.getSkWrapSkill();
            Integer mods = skillA.getSkWrapMod();
            Float ranks = skillA.getSkWrapRank();
            Integer outputIndex = skillA.getSkWrapOutputIndex();
            column = this.adjustAvailColumnConst(column);
            switch (column) {
                case 0: {
                    return fn.toString();
                }
                case 1: {
                    return mods;
                }
                case 2: {
                    return ranks;
                }
                case 3: {
                    return new Integer(mods + ranks.intValue());
                }
                case 4: {
                    if (aSkill != null) {
                        return aSkill.costForPCClass(InfoSkills.this.getSelectedPCClass(), InfoSkills.this.pc);
                    }
                    return new Integer(0);
                }
                case 5: {
                    if (aSkill != null) {
                        return aSkill.getSource();
                    }
                    return fn.getSource();
                }
                case 6: {
                    return outputIndex;
                }
                case -1: {
                    return fn.getItem();
                }
            }
            Logging.errorPrint(PropertyFactory.getString("in_iskErr_message_10") + column + PropertyFactory.getString("in_isk_is_not_handled."));
            return null;
        }

        private void setRoot(PObjectNode aNode) {
            super.setRoot(aNode);
        }

        private int adjustAvailColumnConst(int column) {
            if (this.modelType == 0 && column > 0) {
                return column + 3;
            }
            if (this.modelType == 1 && column > 4) {
                return column + 1;
            }
            return column;
        }

        private void createRootNode(PObjectNode node, ResetableListIterator skillsIt, InfoSkillsSorter sorter, boolean available) {
            this.populateNode(node, skillsIt, sorter, available);
            if (sorter.nodeHaveNext()) {
                while (node.hasNext()) {
                    this.createRootNode((PObjectNode)node.next(), skillsIt, sorter.nextSorter(), available);
                }
            }
        }

        private void initRoot(boolean available, InfoSkillsSorter sorter) {
            PObjectNode root = new PObjectNode();
            this.createRootNode(root, new DisplayableSkillsIterator(available), sorter, available);
            this.setRoot(sorter.finalPass(root));
        }

        private void populateNode(PObjectNode node, ResetableListIterator skillsIt, InfoSkillsSorter sorter, boolean available) {
            TreeSet<PObjectNode> set = new TreeSet<PObjectNode>(new StringIgnoreCaseComparator());
            set.clear();
            skillsIt.reset();
            while (skillsIt.hasNext()) {
                Skill skill = (Skill)skillsIt.next();
                if (!sorter.nodeGoHere(node, skill)) continue;
                Object part = sorter.whatPart(available, skill);
                if (part instanceof Iterator) {
                    Iterator partIt = (Iterator)part;
                    while (partIt.hasNext()) {
                        set.add(new PObjectNode(partIt.next()));
                    }
                    continue;
                }
                if (available && skill.isVisible() == 2) continue;
                PObjectNode nameNode = new PObjectNode(part);
                nameNode.setIsValid(PrereqHandler.passesAll(skill.getPreReqList(), InfoSkills.this.pc, skill));
                set.add(nameNode);
            }
            Iterator nodeIt = set.iterator();
            while (nodeIt.hasNext()) {
                node.addChild((PObjectNode)nodeIt.next());
            }
        }

        protected void resetModel(int mode, boolean available) {
            switch (mode) {
                case 0: {
                    this.initRoot(available, new InfoSkillsSorters.KeystatSubtypeName_Primary(InfoSkills.this));
                    break;
                }
                case 1: {
                    this.initRoot(available, new InfoSkillsSorters.KeystatName_Primary(InfoSkills.this));
                    break;
                }
                case 2: {
                    this.initRoot(available, new InfoSkillsSorters.SubtypeName_Primary(InfoSkills.this));
                    break;
                }
                case 3: {
                    this.initRoot(available, new InfoSkillsSorters.CostSubtypeName_Primary(InfoSkills.this));
                    break;
                }
                case 4: {
                    this.initRoot(available, new InfoSkillsSorters.CostName_Primary(InfoSkills.this));
                    break;
                }
                case 5: {
                    this.initRoot(available, new InfoSkillsSorters.Name_Primary(InfoSkills.this));
                    break;
                }
                default: {
                    Logging.errorPrint(PropertyFactory.getString("in_iskErr_message_07") + mode + PropertyFactory.getString("in_isk_is_not_handled."));
                }
            }
            PObjectNode rootAsPObjectNode = (PObjectNode)super.getRoot();
            if (rootAsPObjectNode.getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }

        private boolean shouldDisplayThis(Skill aSkill) {
            return this.modelType == 1 || InfoSkills.this.accept(InfoSkills.this.pc, aSkill);
        }

        private class DisplayableSkillsIterator
        implements ResetableListIterator {
            private ListIterator it;
            private Skill peek;
            private boolean available;
            private int index;

            public DisplayableSkillsIterator(boolean available) {
                this.available = available;
                this.reset();
            }

            private DisplayableSkillsIterator() {
            }

            public void add(Object obj) {
                throw new UnsupportedOperationException();
            }

            public boolean hasNext() {
                while (this.it.hasNext()) {
                    this.peek = (Skill)this.it.next();
                    if (!SkillModel.this.shouldDisplayThis(this.peek)) continue;
                    ++this.index;
                    return true;
                }
                return false;
            }

            public boolean hasPrevious() {
                while (this.it.hasPrevious()) {
                    this.peek = (Skill)this.it.next();
                    if (!SkillModel.this.shouldDisplayThis(this.peek)) continue;
                    --this.index;
                    return true;
                }
                return false;
            }

            public Object next() {
                return this.peek;
            }

            public int nextIndex() {
                return this.index;
            }

            public Object previous() {
                return this.peek;
            }

            public int previousIndex() {
                return this.index - 1;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            public void reset() {
                this.it = this.available ? Globals.getSkillList().listIterator() : InfoSkills.this.pc.getSkillList().listIterator();
                this.peek = null;
            }

            public void set(Object obj) {
                throw new UnsupportedOperationException();
            }
        }
    }

    private class ResortActionListener
    implements ActionListener {
        boolean sortOrder;
        int sort;

        public ResortActionListener(int i, boolean aBool) {
            this.sort = i;
            this.sortOrder = aBool;
        }

        public void actionPerformed(ActionEvent e) {
            InfoSkills.this.resortSelected(this.sort, this.sortOrder);
        }
    }

    private static final class OutputOrderRenderer
    extends DefaultTableCellRenderer {
        private OutputOrderRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            JLabel comp = (JLabel)super.getTableCellRendererComponent(jTable, value, isSelected, hasFocus, row, column);
            if (value instanceof Integer) {
                int i = (Integer)value;
                if (i == -1) {
                    comp.setText(PropertyFactory.getString("in_iskHidden"));
                } else if (i == 0) {
                    comp.setText("");
                } else {
                    comp.setText(String.valueOf(i));
                }
            }
            return comp;
        }
    }

    private static final class OutputOrderEditor
    extends JComboBoxEx
    implements TableCellEditor {
        private final transient List d_listeners = new ArrayList();
        private transient int d_originalValue;

        private OutputOrderEditor(String[] choices) {
            super(choices);
            this.setEditable(true);
            this.addActionListener(new ActionListener(this){
                private final /* synthetic */ OutputOrderEditor this$0;
                {
                    this.this$0 = this$0;
                }

                public void actionPerformed(ActionEvent ae) {
                    this.this$0.stopCellEditing();
                }
            });
        }

        public boolean isCellEditable(EventObject eventObject) {
            return true;
        }

        public Object getCellEditorValue() {
            switch (this.getSelectedIndex()) {
                case 0: {
                    return new Integer(0);
                }
                case 1: {
                    return new Integer(1000);
                }
                case 2: {
                    return new Integer(-1);
                }
            }
            return new Integer((String)this.getSelectedItem());
        }

        public Component getTableCellEditorComponent(JTable jTable, Object value, boolean isSelected, int row, int column) {
            if (value == null) {
                return this;
            }
            this.d_originalValue = this.getSelectedIndex();
            if (value instanceof Integer) {
                int i = (Integer)value;
                if (i == -1) {
                    this.setSelectedItem(PropertyFactory.getString("in_iskHidden"));
                } else {
                    this.setSelectedItem(String.valueOf(i));
                }
            } else {
                this.setSelectedItem(PropertyFactory.getString("in_iskHidden"));
            }
            jTable.setRowSelectionInterval(row, row);
            jTable.setColumnSelectionInterval(column, column);
            return this;
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.add(cellEditorListener);
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.d_listeners.remove(cellEditorListener);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            this.fireEditingStopped();
            return true;
        }

        private void fireEditingCanceled() {
            this.setSelectedIndex(this.d_originalValue);
            ChangeEvent ce = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                ((CellEditorListener)this.d_listeners.get(i)).editingCanceled(ce);
            }
        }

        private void fireEditingStopped() {
            ChangeEvent ce = new ChangeEvent(this);
            for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
                ((CellEditorListener)this.d_listeners.get(i)).editingStopped(ce);
            }
        }
    }

    public static final class SkillWrapper {
        private Float _ranks;
        private Integer _mod;
        private Integer _outputIndex;
        private Skill _aSkill = null;

        private SkillWrapper(Skill aSkill, Integer mod, Float ranks, Integer outputIndex) {
            this._aSkill = aSkill;
            this._mod = mod;
            this._ranks = ranks;
            this._outputIndex = outputIndex;
        }

        public String toString() {
            if (this._aSkill == null) {
                return "";
            }
            return this._aSkill.piString();
        }

        protected Integer getSkWrapMod() {
            return this._mod;
        }

        protected Integer getSkWrapOutputIndex() {
            return this._outputIndex;
        }

        protected Float getSkWrapRank() {
            return this._ranks;
        }

        protected Skill getSkWrapSkill() {
            return this._aSkill;
        }
    }
}

