/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.core.CharacterDomain;
import pcgen.core.Constants;
import pcgen.core.Domain;
import pcgen.core.Feat;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellInfo;
import pcgen.core.spell.Spell;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.IconUtilitities;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.Utility;
import pcgen.util.FOPHandler;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserInterface;

public class InfoSpells
extends FilterAdapterPanel
implements CharacterInfoTab {
    static final long serialVersionUID = 755097384157285101L;
    private static List bookList = new ArrayList();
    private static String currSpellBook = Globals.getDefaultSpellBook();
    private static int splitOrientation = 1;
    private static int primaryViewMode = 0;
    private static int secondaryViewMode = 1;
    private static int primaryViewSelectMode = 0;
    private static int secondaryViewSelectMode = 1;
    private static boolean needsUpdate = true;
    private static final int MODEL_AVAIL = 0;
    private static final int MODEL_SELECTED = 1;
    private static final int COL_NAME = 0;
    private static final int COL_SCHOOL = 1;
    private static final int COL_SUBSCHOOL = 2;
    private static final int COL_DESCRIPTOR = 3;
    private static final int COL_COMPONENT = 4;
    private static final int COL_CASTTIME = 5;
    private static final int COL_RANGE = 6;
    private static final int COL_DESCRIPTION = 7;
    private static final int COL_TARGET = 8;
    private static final int COL_DURATION = 9;
    private static final int COL_SAVE = 10;
    private static final int COL_SR = 11;
    private static final int COL_SRC = 12;
    private final JLabel avaLabel = new JLabel("Sort Spells By:");
    private final JLabel selLabel = new JLabel("Sort SpellBooks By:");
    private Border etched;
    private FlippingSplitPane asplit;
    private FlippingSplitPane bsplit;
    private FlippingSplitPane splitPane;
    private JButton addBookButton;
    private JButton addSpellButton;
    private JButton delBookButton;
    private JButton delSpellButton;
    private JButton printHtml;
    private JButton printPdf;
    private JButton selectSpellSheetButton = new JButton("Select Spellsheet");
    private JCheckBox shouldAutoSpells = new JCheckBox("Add auto known spells on level/load");
    private JComboBoxEx primaryViewComboBox = new JComboBoxEx();
    private JComboBoxEx secondaryViewComboBox = new JComboBoxEx();
    private JComboBoxEx primaryViewSelectComboBox = new JComboBoxEx();
    private JComboBoxEx secondaryViewSelectComboBox = new JComboBoxEx();
    private JLabelPane classLabel = new JLabelPane();
    private JLabelPane infoLabel = new JLabelPane();
    private JMenuItem addMMMenu;
    private JMenuItem addMenu;
    private JPanel botPane = new JPanel();
    private JPanel topPane = new JPanel();
    private JTextField selectSpellSheetField = new JTextField();
    private JTextField spellBookNameText = new JTextField();
    private JTreeTable availableTable;
    private JTreeTable selectedTable;
    private JTreeTableSorter availableSort = null;
    private JTreeTableSorter selectedSort = null;
    private Spell lastSpell = null;
    private SpellFeatModel featModel = new SpellFeatModel();
    private SpellModel availableModel = null;
    private SpellModel selectedModel = null;
    private String lastClass = "";
    private TreePath selPath;
    private boolean hasBeenSized = false;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$pcgen$gui$utils$TreeTableModel;

    public InfoSpells(PlayerCharacter pc) {
        this.pc = pc;
        this.setName(Constants.tabNames[9]);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                InfoSpells.this.initComponents();
                InfoSpells.this.initActionListeners();
            }
        });
    }

    public void setPc(PlayerCharacter pc) {
        if (this.pc != pc || pc.getSerial() > this.serial) {
            this.pc = pc;
            this.serial = pc.getSerial();
            this.forceRefresh();
        }
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Spells.Order", 9);
    }

    public void setTabOrder(int order) {
        SettingsHandler.setPCGenOption(".Panel.Spells.Order", order);
    }

    public String getTabName() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabName(9);
    }

    public boolean isShown() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabShown(9);
    }

    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    public JComponent getView() {
        return this;
    }

    public final boolean isMatchAnyEnabled() {
        return true;
    }

    public static void setNeedsUpdate(boolean flag) {
        needsUpdate = flag;
    }

    public final boolean isNegateEnabled() {
        return true;
    }

    public final int getSelectionMode() {
        return -2;
    }

    public final void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
        FilterFactory.registerAllSpellFilters(this);
        this.setKitFilter("SPELL");
    }

    public final void refreshFiltering() {
        this.updateAvailableModel();
        this.updateSelectedModel();
    }

    private void setClassLabelText(PCClass aClass) {
        if (aClass != null) {
            String bString;
            int i;
            this.lastClass = aClass.getName();
            StringBuffer b = new StringBuffer();
            b.append("<html><table border=1><tr><td><font size=-2><b>");
            b.append(aClass.piSubString()).append(" [");
            b.append(String.valueOf(aClass.getLevel() + (int)this.pc.getTotalBonusTo("PCLEVEL", aClass.getName())));
            b.append("]</b></font></td>");
            for (i = 0; i <= 9; ++i) {
                b.append("<td><font size=-2><b><center>&nbsp;").append(i).append("&nbsp;</b></center></font></td>");
            }
            b.append("</tr>");
            b.append("<tr><td><font size=-1><b>Cast</b></font></td>");
            for (i = 0; i <= 9; ++i) {
                b.append("<td><font size=-1><center>").append(InfoSpells.getNumCast(aClass, i, this.pc)).append("</center></font></td>");
            }
            if (aClass.hasKnownSpells(this.pc)) {
                b.append("<tr><td><font size=-1><b>Known</b></font></td>");
                for (i = 0; i <= 9; ++i) {
                    int a = aClass.getKnownForLevel(aClass.getLevel(), i, this.pc);
                    int bonus = aClass.getSpecialtyKnownForLevel(aClass.getLevel(), i, this.pc);
                    StringBuffer bString2 = new StringBuffer();
                    if (bonus > 0) {
                        bString2.append('+').append(bonus);
                    }
                    b.append("<td><font size=-1><center>").append(a).append(bString2).append("</center></font></td>");
                }
            }
            b.append("<tr><td><font size=-1><b>DC</b></font></td>");
            for (i = 0; i <= 9; ++i) {
                b.append("<td><font size=-1><center>").append(InfoSpells.getDC(aClass, i, this.pc)).append("</center></font></td>");
            }
            b.append("</tr></table>");
            b.append("Spell Caster Type: <b>").append(aClass.getSpellType()).append("</b><br>");
            b.append("Primary Stat Bonus: <b>").append(aClass.getSpellBaseStat()).append("</b><br>");
            if (aClass.getSpecialtyListString(this.pc).length() != 0) {
                b.append("School: <b>").append(aClass.getSpecialtyListString(this.pc)).append("</b><br>");
            }
            if (aClass.getProhibitedString().length() != 0) {
                b.append("Prohibited School: <b>").append(aClass.getProhibitedString()).append("</b><br>");
            }
            if ((bString = aClass.getSource()).length() > 0) {
                b.append("<b>SOURCE</b>:").append(bString);
            }
            b.append("</html>");
            this.classLabel.setText(b.toString());
        }
    }

    private static int getDC(PCClass aClass, int level, PlayerCharacter pc) {
        Spell aSpell = new Spell();
        int DC2 = aSpell.getDCForPlayerCharacter(pc, null, aClass, level);
        return DC2;
    }

    private void setInfoLabelText(SpellInfo si) {
        if (si == null) {
            return;
        }
        CharacterSpell cs = si.getOwner();
        this.lastSpell = cs.getSpell();
        Spell aSpell = this.lastSpell;
        if (aSpell != null) {
            String typeName = "CLASS";
            if (cs.getOwner() instanceof Domain) {
                typeName = "DOMAIN";
            }
            StringBuffer b = new StringBuffer();
            b.append("<html><font size=+1><b>").append(aSpell.piSubString()).append("</b></font>");
            String addString = si.toString();
            if (addString.length() > 0) {
                b.append(" &nbsp;").append(addString);
            }
            b.append(" &nbsp;<b>Level:</b>&nbsp; ");
            int[] levels = aSpell.levelForKey(cs.getOwner().getSpellKey(), this.pc);
            for (int index = 0; index < levels.length; ++index) {
                if (index > 0) {
                    b.append(',');
                }
                b.append(levels[index]);
            }
            b.append(" &nbsp;<b>School:</b>&nbsp; ").append(aSpell.getSchool());
            b.append(" &nbsp;<b>SubSchool:</b>&nbsp; ").append(aSpell.getSubschool());
            b.append(" &nbsp;<b>Descriptor:</b>&nbsp; ").append(aSpell.descriptor());
            b.append(" &nbsp;<b>Components:</b>&nbsp; ").append(aSpell.getComponentList());
            b.append(" &nbsp;<b>Casting Time:</b>&nbsp; ").append(aSpell.getCastingTime());
            b.append(" &nbsp;<b>Duration:</b>&nbsp; ").append(this.pc.parseSpellString(aSpell, aSpell.getDuration(), cs.getOwner()));
            b.append(" &nbsp;<b>Range:</b>&nbsp; ").append(aSpell.getRange());
            b.append(" &nbsp;<b>Target:</b>&nbsp; ").append(this.pc.parseSpellString(aSpell, aSpell.getTarget(), cs.getOwner()));
            b.append(" &nbsp;<b>Saving Throw:</b>&nbsp; ").append(aSpell.getSaveInfo());
            b.append(" &nbsp;<b>Spell Resistance:</b>&nbsp; ").append(aSpell.getSpellResistance());
            b.append(" &nbsp;<b>Description:</b>&nbsp; ").append(this.pc.parseSpellString(aSpell, aSpell.getDescription(), cs.getOwner()));
            String spellSource = aSpell.getSource();
            if (spellSource.length() > 0) {
                b.append(" &nbsp;<b>SOURCE:</b>&nbsp;").append(spellSource);
            }
            b.append("</html>");
            this.infoLabel.setText(b.toString());
        }
    }

    private static String getNumCast(PCClass aClass, int level, PlayerCharacter pc) {
        int cLevel = aClass.getLevel();
        String sbook = Globals.getDefaultSpellBook();
        String cast = aClass.getCastForLevel(cLevel, level, sbook, pc) + aClass.getBonusCastForLevelString(cLevel, level, sbook, pc);
        return cast;
    }

    private static int getSelectedIndex(ListSelectionEvent e) {
        DefaultListSelectionModel model = (DefaultListSelectionModel)e.getSource();
        if (model == null) {
            return -1;
        }
        return model.getMinSelectionIndex();
    }

    private final void createTreeTables() {
        this.availableTable = new JTreeTable(this.availableModel);
        this.availableTable.setSelectionMode(2);
        final JTree atree = this.availableTable.getTree();
        atree.setRootVisible(false);
        atree.setShowsRootHandles(true);
        atree.setCellRenderer(new LabelTreeCellRenderer());
        this.availableTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    Object temp;
                    int idx = InfoSpells.getSelectedIndex(e);
                    if (idx < 0) {
                        return;
                    }
                    if (!atree.isSelectionEmpty()) {
                        TreePath avaCPath = atree.getSelectionPath();
                        String className = "";
                        if (primaryViewMode == 0) {
                            className = avaCPath.getPathComponent(1).toString();
                        } else if (secondaryViewMode == 1 && avaCPath.getPathCount() > 2) {
                            className = avaCPath.getPathComponent(2).toString();
                        } else if (InfoSpells.this.lastClass != null) {
                            className = InfoSpells.this.lastClass;
                        }
                        className = Utility.stripHTML(className);
                        PCClass aClass = InfoSpells.this.pc.getClassNamed(className);
                        if (!className.equalsIgnoreCase(InfoSpells.this.lastClass) && className.length() > 0 && aClass != null) {
                            InfoSpells.this.setClassLabelText(aClass);
                        }
                    }
                    if ((temp = atree.getPathForRow(idx).getLastPathComponent()) == null) {
                        InfoSpells.this.lastSpell = null;
                        InfoSpells.this.infoLabel.setText();
                        return;
                    }
                    PObjectNode fNode = (PObjectNode)temp;
                    if (fNode.getItem() instanceof SpellInfo) {
                        CharacterSpell spellA = ((SpellInfo)fNode.getItem()).getOwner();
                        if (spellA.getSpell() != null) {
                            InfoSpells.this.addSpellButton.setEnabled(true);
                            InfoSpells.this.addMenu.setEnabled(true);
                            InfoSpells.this.addMMMenu.setEnabled(true);
                            InfoSpells.this.setInfoLabelText((SpellInfo)fNode.getItem());
                        }
                    } else {
                        InfoSpells.this.addSpellButton.setEnabled(false);
                        InfoSpells.this.addMenu.setEnabled(false);
                        InfoSpells.this.addMMMenu.setEnabled(false);
                    }
                }
            }
        });
        MouseAdapter aml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TreePath avaPath = atree.getPathForLocation(e.getX(), e.getY());
                if (avaPath != null) {
                    if (e.getClickCount() == 2) {
                        InfoSpells.this.addSpellButton();
                    } else if (e.getClickCount() == 1 && e.isControlDown()) {
                        if (atree.isPathSelected(avaPath)) {
                            atree.removeSelectionPath(avaPath);
                        } else if (!atree.isPathSelected(avaPath)) {
                            atree.addSelectionPath(avaPath);
                        }
                    }
                }
            }
        };
        atree.addMouseListener(aml);
        this.selectedTable = new JTreeTable(this.selectedModel);
        this.selectedTable.setSelectionMode(0);
        final JTree selectedTree = this.selectedTable.getTree();
        selectedTree.setRootVisible(false);
        selectedTree.setShowsRootHandles(true);
        selectedTree.setCellRenderer(new LabelTreeCellRenderer());
        this.selectedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    CharacterSpell spellA;
                    Object temp;
                    int idx = InfoSpells.getSelectedIndex(e);
                    if (idx < 0) {
                        return;
                    }
                    TreePath selCPath = selectedTree.getSelectionPath();
                    if (!selectedTree.isSelectionEmpty()) {
                        InfoSpells.this.spellBookNameText.setText(selCPath.getPathComponent(1).toString());
                        InfoSpells.this.spellBookNameTextActionPerformed();
                    }
                    if ((temp = selectedTree.getPathForRow(idx).getLastPathComponent()) == null) {
                        InfoSpells.this.lastSpell = null;
                        InfoSpells.this.infoLabel.setText();
                        return;
                    }
                    PObjectNode fNode = (PObjectNode)temp;
                    if (fNode.getItem() instanceof SpellInfo && (spellA = ((SpellInfo)fNode.getItem()).getOwner()).getSpell() != null) {
                        InfoSpells.this.delSpellButton.setEnabled(true);
                        InfoSpells.this.setInfoLabelText((SpellInfo)fNode.getItem());
                    }
                }
            }
        });
        MouseAdapter sml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TreePath mlSelPath = selectedTree.getPathForLocation(e.getX(), e.getY());
                if (mlSelPath != null) {
                    if (e.getClickCount() == 2) {
                        InfoSpells.this.delSpellButton();
                    } else if (e.getClickCount() == 1 && e.isControlDown()) {
                        if (selectedTree.isPathSelected(mlSelPath)) {
                            selectedTree.removeSelectionPath(mlSelPath);
                        } else if (!selectedTree.isPathSelected(mlSelPath)) {
                            selectedTree.addSelectionPath(mlSelPath);
                        }
                    }
                }
            }
        };
        selectedTree.addMouseListener(sml);
        this.hookupPopupMenu(this.availableTable);
        this.hookupPopupMenu(this.selectedTable);
    }

    private void setSelectedIndex(JTreeTable aTable, int idx) {
        aTable.setRowSelectionInterval(idx, idx);
    }

    private void addBookButton() {
        String aString = this.spellBookNameText.getText();
        if (aString.equals(currSpellBook)) {
            return;
        }
        Iterator i = Globals.getClassList().iterator();
        while (i.hasNext()) {
            PCClass current = (PCClass)i.next();
            if (!aString.equals(current.getName())) continue;
            JOptionPane.showMessageDialog(null, PropertyFactory.getString("in_spellbook_name_error"), "PCGen", 0);
            this.spellBookNameText.setText("");
            return;
        }
        if (!this.pc.addSpellBook(aString)) {
            Logging.errorPrint("addBookButton:failed");
            return;
        }
        this.pc.setDirty(true);
        this.spellBookNameText.setText(aString);
        this.spellBookNameTextActionPerformed();
        this.updateSelectedModel();
    }

    private final void createAvailableModel() {
        if (this.availableModel == null) {
            this.availableModel = new SpellModel(primaryViewMode, secondaryViewMode, true);
        } else {
            this.availableModel.resetModel(InfoSpells.primaryViewMode, InfoSpells.secondaryViewMode, true);
        }
        if (this.availableSort != null) {
            this.availableSort.setRoot((PObjectNode)this.availableModel.getRoot());
            this.availableSort.sortNodeOnColumn();
        }
    }

    private void createFeatList() {
        this.pc.aggregateFeatList();
        this.pc.setAggregateFeatsStable(true);
        this.pc.setAutomaticFeatsStable(true);
        this.pc.setVirtualFeatsStable(true);
        ArrayList<String> featList = new ArrayList<String>();
        List feats = this.pc.aggregateFeatList();
        Globals.sortPObjectList(feats);
        Iterator i = feats.iterator();
        while (i.hasNext()) {
            Feat aFeat = (Feat)i.next();
            if (!aFeat.isType("Metamagic")) continue;
            featList.add(aFeat.getName());
        }
        this.featModel.setData(featList);
    }

    private final void createModels() {
        this.createAvailableModel();
        this.createSelectedModel();
    }

    private final void createSelectedModel() {
        if (this.selectedModel == null) {
            this.selectedModel = new SpellModel(primaryViewSelectMode, secondaryViewSelectMode, false);
        } else {
            this.selectedModel.resetModel(InfoSpells.primaryViewSelectMode, InfoSpells.secondaryViewSelectMode, false);
        }
        if (this.selectedSort != null) {
            this.selectedSort.setRoot((PObjectNode)this.selectedModel.getRoot());
            this.selectedSort.sortNodeOnColumn();
        }
    }

    private static void setNodeSpells(List charSpells, PObjectNode tNode, int iLev, PObject obj, String book, PlayerCharacter pc) {
        Iterator fI = charSpells.iterator();
        while (fI.hasNext()) {
            PObjectNode fCN;
            Object o = fI.next();
            if (o instanceof CharacterSpell) {
                CharacterSpell cs = (CharacterSpell)o;
                SpellInfo si = cs.getSpellInfoFor(book, iLev, -1);
                if (si == null) continue;
                fCN = new PObjectNode();
                fCN.setItem(si);
            } else {
                Spell aSpell = (Spell)o;
                if (!aSpell.levelForKeyContains(obj.getSpellKey(), iLev, pc)) continue;
                CharacterSpell cs = new CharacterSpell(obj, aSpell);
                SpellInfo si = cs.addInfo(iLev, 1, book);
                fCN = new PObjectNode();
                fCN.setItem(si);
            }
            fCN.setParent(tNode);
            tNode.addChild(fCN);
        }
    }

    private void delBookButton() {
        String aString = this.spellBookNameText.getText();
        if (aString.equalsIgnoreCase(Globals.getDefaultSpellBook())) {
            Logging.errorPrint("You may not delete the default spellbook");
            return;
        }
        if (!this.pc.delSpellBook(aString)) {
            Logging.errorPrint("delBookButton:failed ");
            return;
        }
        this.pc.setDirty(true);
        currSpellBook = Globals.getDefaultSpellBook();
        this.updateAvailableModel();
        this.updateSelectedModel();
    }

    private void exportSpellsToFile() {
        String template = SettingsHandler.getSelectedSpellSheet();
        String ext = template.substring(template.lastIndexOf(46));
        JFileChooser fcExport = new JFileChooser();
        fcExport.setCurrentDirectory(SettingsHandler.getPcgPath());
        fcExport.setDialogTitle("Export Spells for " + this.pc.getDisplayName());
        if (fcExport.showSaveDialog(this) != 0) {
            return;
        }
        String aFileName = fcExport.getSelectedFile().getAbsolutePath();
        if (aFileName.length() < 1) {
            ShowMessageDelegate.showMessageDialog("You must set a filename.", "PCGen", MessageType.ERROR);
            return;
        }
        try {
            int reallyClose;
            File outFile = new File(aFileName);
            if (outFile.isDirectory()) {
                ShowMessageDelegate.showMessageDialog("You cannot overwrite a directory with a file.", "PCGen", MessageType.ERROR);
                return;
            }
            if (outFile.exists() && (reallyClose = JOptionPane.showConfirmDialog(this, "The file " + outFile.getName() + " already exists, are you sure you want to overwrite it?", "Confirm overwriting " + outFile.getName(), 0)) != 0) {
                return;
            }
            if (ext.equalsIgnoreCase(".htm") || ext.equalsIgnoreCase(".html")) {
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8"));
                Utility.printToWriter(w, template);
            } else if (ext.equalsIgnoreCase(".fo") || ext.equalsIgnoreCase(".pdf")) {
                File tmpFile = File.createTempFile("tempSpells_", ".fo");
                BufferedWriter w = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), "UTF-8"));
                Utility.printToWriter(w, template);
                FOPHandler fh = new FOPHandler();
                fh.setMode(0);
                fh.setInputFile(tmpFile);
                fh.setOutputFile(outFile);
                fh.run();
                tmpFile.deleteOnExit();
                String errMessage = fh.getErrorMessage();
                if (errMessage.length() > 0) {
                    ShowMessageDelegate.showMessageDialog(errMessage, "PCGen", MessageType.ERROR);
                }
            }
        }
        catch (IOException ex) {
            ShowMessageDelegate.showMessageDialog("Could not export " + this.pc.getDisplayName() + ". Try another filename", "PCGen", MessageType.ERROR);
            Logging.errorPrint("Could not export " + this.pc.getDisplayName(), ex);
        }
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.getStatusBar().setText("");
        this.refresh();
        int s = this.splitPane.getDividerLocation();
        int t = this.bsplit.getDividerLocation();
        int u = this.asplit.getDividerLocation();
        if (!this.hasBeenSized) {
            int width;
            TableColumn sCol;
            int i;
            this.hasBeenSized = true;
            s = SettingsHandler.getPCGenOption("InfoSpells.splitPane", (int)(this.getSize().getWidth() * 2.0 / 10.0));
            t = SettingsHandler.getPCGenOption("InfoSpells.bsplit", (int)(this.getSize().getHeight() - 101.0));
            u = SettingsHandler.getPCGenOption("InfoSpells.asplit", (int)(this.getSize().getWidth() - 408.0));
            for (i = 0; i < this.selectedTable.getColumnCount(); ++i) {
                sCol = this.selectedTable.getColumnModel().getColumn(i);
                width = Globals.getCustColumnWidth("SpellSel", i);
                if (width != 0) {
                    sCol.setPreferredWidth(width);
                }
                sCol.addPropertyChangeListener(new ResizeColumnListener(this.selectedTable, "SpellSel", i));
            }
            for (i = 0; i < this.availableTable.getColumnCount(); ++i) {
                sCol = this.availableTable.getColumnModel().getColumn(i);
                width = Globals.getCustColumnWidth("SpellAva", i);
                if (width != 0) {
                    sCol.setPreferredWidth(width);
                }
                sCol.addPropertyChangeListener(new ResizeColumnListener(this.availableTable, "SpellAva", i));
            }
        }
        if (s > 0) {
            this.splitPane.setDividerLocation(s);
            SettingsHandler.setPCGenOption("InfoSpells.splitPane", s);
        }
        if (t > 0) {
            this.bsplit.setDividerLocation(t);
            SettingsHandler.setPCGenOption("InfoSpells.bsplit", t);
        }
        if (u > 0) {
            this.asplit.setDividerLocation(u);
            SettingsHandler.setPCGenOption("InfoSpells.asplit", u);
        }
    }

    private void hookupPopupMenu(JTreeTable treeTable) {
        treeTable.addMouseListener(new SpellPopupListener(treeTable, new SpellPopupMenu(treeTable)));
    }

    private void initActionListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                InfoSpells.this.formComponentShown();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                int s = InfoSpells.this.splitPane.getDividerLocation();
                if (s > 0) {
                    SettingsHandler.setPCGenOption("InfoSpells.splitPane", s);
                }
                if ((s = InfoSpells.this.asplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoSpells.asplit", s);
                }
                if ((s = InfoSpells.this.bsplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoSpells.bsplit", s);
                }
            }
        });
        this.shouldAutoSpells.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoSpells.this.pc.setAutoSpells(InfoSpells.this.shouldAutoSpells.isSelected());
            }
        });
        this.addSpellButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoSpells.this.addSpellButton();
            }
        });
        this.delSpellButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoSpells.this.delSpellButton();
            }
        });
        this.spellBookNameText.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoSpells.this.spellBookNameTextActionPerformed();
            }
        });
        this.addBookButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoSpells.this.addBookButton();
            }
        });
        this.delBookButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoSpells.this.delBookButton();
            }
        });
        this.primaryViewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoSpells.this.primaryViewComboBoxActionPerformed();
            }
        });
        this.secondaryViewComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoSpells.this.secondaryViewComboBoxActionPerformed();
            }
        });
        this.primaryViewSelectComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoSpells.this.primaryViewSelectComboBoxActionPerformed();
            }
        });
        this.secondaryViewSelectComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoSpells.this.secondaryViewSelectComboBoxActionPerformed();
            }
        });
        this.selectSpellSheetButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoSpells.this.selectSpellSheetButton();
            }
        });
        this.printHtml.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                boolean aBool = SettingsHandler.getPrintSpellsWithPC();
                SettingsHandler.setPrintSpellsWithPC(true);
                Utility.previewInBrowser(SettingsHandler.getSelectedSpellSheet());
                SettingsHandler.setPrintSpellsWithPC(aBool);
            }
        });
        this.printPdf.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                boolean aBool = SettingsHandler.getPrintSpellsWithPC();
                PCGen_Frame1 pcFrame = PCGen_Frame1.getInst();
                SettingsHandler.setPrintSpellsWithPC(true);
                InfoSpells.this.exportSpellsToFile();
                SettingsHandler.setPrintSpellsWithPC(aBool);
            }
        });
        FilterFactory.restoreFilterSettings(this);
    }

    private void initComponents() {
        this.readyForRefresh = true;
        int iView = SettingsHandler.getSpellsTab_AvailableListMode();
        if (iView >= 0 && iView <= 5) {
            primaryViewMode = iView;
        }
        while (secondaryViewMode == primaryViewMode) {
            if (secondaryViewMode == 2) {
                secondaryViewMode = 0;
                continue;
            }
            ++secondaryViewMode;
        }
        SettingsHandler.setSpellsTab_AvailableListMode(primaryViewMode);
        iView = SettingsHandler.getSpellsTab_SelectedListMode();
        if (iView >= 0 && iView <= 5) {
            primaryViewSelectMode = iView;
        }
        while (secondaryViewSelectMode == primaryViewSelectMode) {
            if (secondaryViewSelectMode == 2) {
                secondaryViewSelectMode = 0;
                continue;
            }
            ++secondaryViewSelectMode;
        }
        SettingsHandler.setSpellsTab_SelectedListMode(primaryViewSelectMode);
        this.primaryViewComboBox.addItem("Class");
        this.primaryViewComboBox.addItem("Level");
        this.primaryViewComboBox.addItem("Descriptor");
        this.primaryViewComboBox.addItem("Range");
        this.primaryViewComboBox.addItem("Duration");
        this.primaryViewComboBox.addItem("Type");
        this.primaryViewComboBox.setSelectedIndex(primaryViewMode);
        Utility.setDescription(this.primaryViewComboBox, "You can change how the Spells in the Tables are listed.");
        this.secondaryViewComboBox.addItem("Class");
        this.secondaryViewComboBox.addItem("Level");
        this.secondaryViewComboBox.addItem("Descriptor");
        this.secondaryViewComboBox.addItem("Range");
        this.secondaryViewComboBox.addItem("Duration");
        this.secondaryViewComboBox.addItem("Type");
        this.secondaryViewComboBox.setSelectedIndex(secondaryViewMode);
        this.primaryViewSelectComboBox.addItem("Class");
        this.primaryViewSelectComboBox.addItem("Level");
        this.primaryViewSelectComboBox.addItem("Descriptor");
        this.primaryViewSelectComboBox.addItem("Range");
        this.primaryViewSelectComboBox.addItem("Duration");
        this.primaryViewSelectComboBox.addItem("Type");
        this.primaryViewSelectComboBox.setSelectedIndex(primaryViewSelectMode);
        Utility.setDescription(this.primaryViewSelectComboBox, "You can change how the Spells in the Tables are listed.");
        this.secondaryViewSelectComboBox.addItem("Class");
        this.secondaryViewSelectComboBox.addItem("Level");
        this.secondaryViewSelectComboBox.addItem("Descriptor");
        this.secondaryViewSelectComboBox.addItem("Range");
        this.secondaryViewSelectComboBox.addItem("Duration");
        this.secondaryViewSelectComboBox.addItem("Type");
        Utility.setDescription(this.secondaryViewSelectComboBox, "You can change how the Spells in the Tables are listed.");
        this.secondaryViewSelectComboBox.setSelectedIndex(secondaryViewSelectMode);
        bookList.add(Globals.getDefaultSpellBook());
        ImageIcon newImage = IconUtilitities.getImageIcon("Forward16.gif");
        this.addSpellButton = new JButton(newImage);
        newImage = IconUtilitities.getImageIcon("Back16.gif");
        this.delSpellButton = new JButton(newImage);
        this.createModels();
        this.createTreeTables();
        this.topPane.setLayout(new BorderLayout());
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        JPanel leftPane = new JPanel();
        JPanel rightPane = new JPanel();
        leftPane.setLayout(gridbag);
        rightPane.setLayout(gridbag);
        this.splitPane = new FlippingSplitPane(splitOrientation, leftPane, rightPane);
        this.splitPane.setOneTouchExpandable(true);
        this.splitPane.setDividerSize(10);
        this.topPane.add((Component)this.splitPane, "Center");
        Utility.buildConstraints(c, 0, 0, 1, 1, 0.0, 0.0);
        c.fill = 0;
        c.anchor = 11;
        JPanel aPanel = new JPanel();
        gridbag.setConstraints(aPanel, c);
        aPanel.add(this.avaLabel);
        aPanel.add(this.primaryViewComboBox);
        aPanel.add(this.secondaryViewComboBox);
        Utility.setDescription(this.addSpellButton, "Click to add selected spell to your selected spellbook");
        this.addSpellButton.setEnabled(false);
        aPanel.add(this.addSpellButton);
        Utility.setDescription(aPanel, "Right click to add spells to your spellbooks");
        leftPane.add(aPanel);
        Utility.buildConstraints(c, 0, 1, 1, 1, 0.0, 0.0);
        c.fill = 0;
        c.anchor = 11;
        JPanel bPanel = new JPanel();
        gridbag.setConstraints(bPanel, c);
        this.shouldAutoSpells.setSelected(this.pc.getAutoSpells());
        bPanel.add(this.shouldAutoSpells);
        leftPane.add(bPanel);
        Utility.buildConstraints(c, 0, 2, 1, 1, 10.0, 10.0);
        c.fill = 1;
        c.anchor = 11;
        c.ipadx = 1;
        JScrollPane scrollPane = new JScrollPane(this.availableTable);
        gridbag.setConstraints(scrollPane, c);
        leftPane.add(scrollPane);
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        rightPane.setLayout(gridbag);
        Utility.buildConstraints(c, 0, 0, 1, 1, 2.0, 0.0);
        c.fill = 0;
        c.anchor = 11;
        JPanel iPanel = new JPanel();
        gridbag.setConstraints(iPanel, c);
        Utility.setDescription(this.delSpellButton, "Click to remove selected spell from this spellbook");
        this.delSpellButton.setEnabled(false);
        iPanel.add(this.delSpellButton);
        rightPane.add(iPanel);
        Utility.buildConstraints(c, 1, 0, 1, 1, 1.0, 0.0);
        c.fill = 0;
        c.anchor = 11;
        JPanel sPanel = new JPanel();
        gridbag.setConstraints(sPanel, c);
        sPanel.add(this.selLabel);
        sPanel.add(this.primaryViewSelectComboBox);
        sPanel.add(this.secondaryViewSelectComboBox);
        rightPane.add(sPanel);
        Utility.buildConstraints(c, 2, 0, 1, 1, 1.0, 0.0);
        c.fill = 2;
        c.anchor = 11;
        aPanel = new JPanel();
        gridbag.setConstraints(aPanel, c);
        JLabel spellBookLabel = new JLabel("SpellBook:");
        aPanel.add(spellBookLabel);
        this.spellBookNameText.setEditable(true);
        this.spellBookNameText.setPreferredSize(new Dimension(100, 20));
        aPanel.add(this.spellBookNameText);
        this.addBookButton = new JButton("Add");
        aPanel.add(this.addBookButton);
        this.delBookButton = new JButton("Del");
        aPanel.add(this.delBookButton);
        rightPane.add(aPanel);
        this.selectSpellSheetField.setEditable(false);
        Utility.setDescription(this.selectSpellSheetField, "Display only");
        this.selectSpellSheetField.setBackground(Color.lightGray);
        this.selectSpellSheetField.setText(SettingsHandler.getSelectedSpellSheetName());
        JPanel ssPanel = new JPanel();
        Utility.buildConstraints(c, 0, 1, 3, 1, 1.0, 0.0);
        c.fill = 2;
        c.anchor = 11;
        gridbag.setConstraints(ssPanel, c);
        PCGen_Frame1 pcFrame = PCGen_Frame1.getInst();
        this.printHtml = new JButton();
        IconUtilitities.maybeSetIcon(this.printHtml, "PrintPreview16.gif");
        this.printHtml.setEnabled(true);
        this.printPdf = new JButton();
        IconUtilitities.maybeSetIcon(this.printPdf, "Print16.gif");
        this.printPdf.setEnabled(true);
        ssPanel.add(this.selectSpellSheetButton);
        ssPanel.add(this.selectSpellSheetField);
        ssPanel.add(this.printHtml);
        ssPanel.add(this.printPdf);
        rightPane.add(ssPanel);
        Utility.buildConstraints(c, 0, 2, 3, 1, 10.0, 10.0);
        c.fill = 1;
        c.anchor = 11;
        c.ipadx = 1;
        scrollPane = new JScrollPane(this.selectedTable);
        gridbag.setConstraints(scrollPane, c);
        scrollPane.setHorizontalScrollBarPolicy(32);
        this.selectedTable.setAutoResizeMode(0);
        this.selectedTable.setShowHorizontalLines(true);
        rightPane.add(scrollPane);
        this.botPane.setLayout(new BorderLayout());
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        JPanel bLeftPane = new JPanel();
        JPanel bRightPane = new JPanel();
        bLeftPane.setLayout(gridbag);
        bRightPane.setLayout(gridbag);
        this.asplit = new FlippingSplitPane(1, bLeftPane, bRightPane);
        this.asplit.setOneTouchExpandable(true);
        this.asplit.setDividerSize(10);
        this.botPane.add((Component)this.asplit, "Center");
        Utility.buildConstraints(c, 0, 0, 1, 1, 1.0, 1.0);
        c.fill = 1;
        c.anchor = 10;
        JScrollPane sScroll = new JScrollPane();
        gridbag.setConstraints(sScroll, c);
        TitledBorder sTitle = BorderFactory.createTitledBorder(this.etched, "Spell Info");
        sTitle.setTitleJustification(2);
        sScroll.setBorder(sTitle);
        this.infoLabel.setBackground(this.topPane.getBackground());
        sScroll.setViewportView(this.infoLabel);
        bLeftPane.add(sScroll);
        Utility.buildConstraints(c, 0, 0, 1, 1, 1.0, 1.0);
        c.fill = 1;
        c.anchor = 13;
        JScrollPane iScroll = new JScrollPane();
        TitledBorder iTitle = BorderFactory.createTitledBorder(this.etched, "Class Info");
        iTitle.setTitleJustification(2);
        iScroll.setBorder(iTitle);
        this.classLabel.setBackground(this.topPane.getBackground());
        iScroll.setViewportView(this.classLabel);
        iScroll.setHorizontalScrollBarPolicy(30);
        gridbag.setConstraints(iScroll, c);
        bRightPane.add(iScroll);
        this.bsplit = new FlippingSplitPane(0, this.topPane, this.botPane);
        this.bsplit.setOneTouchExpandable(true);
        this.bsplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.bsplit, "Center");
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                InfoSpells.this.refresh();
            }
        });
        this.availableSort = new JTreeTableSorter(this.availableTable, (PObjectNode)this.availableModel.getRoot(), this.availableModel);
        this.selectedSort = new JTreeTableSorter(this.selectedTable, (PObjectNode)this.selectedModel.getRoot(), this.selectedModel);
    }

    private final void updateCharacterInfo() {
        this.lastClass = "";
        if (this.pc == null || !needsUpdate) {
            return;
        }
        this.pc.getSpellList();
        this.shouldAutoSpells.setSelected(this.pc.getAutoSpells());
        this.updateAvailableModel();
        this.updateSelectedModel();
        this.createFeatList();
        this.classLabel.setText("");
        needsUpdate = false;
    }

    private void addSpellButton() {
        TreePath selCPath = this.selectedTable.getTree().getSelectionPath();
        String bookName = selCPath == null ? this.spellBookNameText.getText() : selCPath.getPathComponent(1).toString();
        if (bookName.length() <= 0) {
            ShowMessageDelegate.showMessageDialog("First select a spellbook to add the spell to", "PCGen", MessageType.ERROR);
            return;
        }
        if (primaryViewMode != 0 && secondaryViewMode != 0 || primaryViewMode != 1 && secondaryViewMode != 1) {
            ShowMessageDelegate.showMessageDialog("Can only add spells if sorted by class and level", "PCGen", MessageType.ERROR);
            return;
        }
        currSpellBook = bookName;
        TreePath[] avaCPaths = this.availableTable.getTree().getSelectionPaths();
        for (int index = avaCPaths.length - 1; index >= 0; --index) {
            Object aComp = avaCPaths[index].getLastPathComponent();
            PObjectNode fNode = (PObjectNode)aComp;
            this.addSpellToTarget(fNode, bookName);
        }
        this.pc.setDirty(true);
        this.updateSelectedModel();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List getInfoFromNode(PObjectNode fNode) {
        String className = "";
        int spLevel = -1;
        ArrayList<Object> returnList = new ArrayList<Object>();
        if (!(fNode.getItem() instanceof SpellInfo)) {
            return null;
        }
        CharacterSpell spellA = ((SpellInfo)fNode.getItem()).getOwner();
        if (spellA.getOwner() instanceof Race) {
            return null;
        }
        CharacterSpell cs = null;
        PObject theOwner = spellA.getOwner();
        PCClass aClass = null;
        if (theOwner == null) {
            ShowMessageDelegate.showMessageDialog("only possible when sorted by class and level", "PCGen", MessageType.ERROR);
            return null;
        }
        spLevel = ((SpellInfo)fNode.getItem()).getActualLevel();
        Spell aSpell = spellA.getSpell();
        if (theOwner instanceof Domain) {
            CharacterDomain cd = this.pc.getCharacterDomainForDomain(theOwner.getName());
            if (cd == null || !cd.isFromPCClass()) return null;
            className = cd.getObjectName();
            aClass = this.pc.getClassNamed(className);
        } else {
            aClass = (PCClass)theOwner;
            className = aClass.getCastAs();
        }
        List aList = aClass.getCharacterSpell(aSpell, "", spLevel);
        returnList.add(spellA);
        returnList.add(className);
        returnList.add(String.valueOf(spLevel));
        Iterator ai = aList.iterator();
        while (ai.hasNext()) {
            cs = (CharacterSpell)ai.next();
            if (cs.equals(spellA)) {
                returnList.set(0, cs);
                return returnList;
            }
            if (!theOwner.equals(cs.getOwner())) {
                cs = null;
                continue;
            }
            returnList.set(0, cs);
            return returnList;
        }
        if (cs != null) return returnList;
        cs = new CharacterSpell(theOwner, aSpell);
        returnList.set(0, cs);
        return returnList;
    }

    private void addSpellToTarget(PObjectNode fNode, String bookName) {
        List aList = this.getInfoFromNode(fNode);
        if (aList == null) {
            return;
        }
        CharacterSpell cs = (CharacterSpell)aList.get(0);
        String className = (String)aList.get(1);
        int spLevel = Integer.parseInt((String)aList.get(2));
        if (cs == null) {
            return;
        }
        ArrayList featList = new ArrayList();
        String aString = this.pc.addSpell(cs, featList, className, bookName, spLevel, spLevel);
        if (aString.length() > 0) {
            ShowMessageDelegate.showMessageDialog(aString, "PCGen", MessageType.ERROR);
            return;
        }
    }

    private void delSpellButton() {
        TreePath selCPath = this.selectedTable.getTree().getSelectionPath();
        if (selCPath == null) {
            ShowMessageDelegate.showMessageDialog("Select the spell to remove from your spellbook.", "PCGen", MessageType.ERROR);
            return;
        }
        Object endComp = selCPath.getLastPathComponent();
        PObjectNode fNode = (PObjectNode)endComp;
        List aList = this.getInfoFromNode(fNode);
        if (aList == null) {
            return;
        }
        CharacterSpell cs = (CharacterSpell)aList.get(0);
        String className = (String)aList.get(1);
        int spLevel = Integer.parseInt((String)aList.get(2));
        if (cs == null) {
            return;
        }
        String bookName = selCPath.getPathComponent(1).toString();
        SpellInfo si = (SpellInfo)fNode.getItem();
        PCClass aClass = this.pc.getClassNamed(className);
        if (aClass == null) {
            ShowMessageDelegate.showMessageDialog("Can only add spells if sorted by class and level", "PCGen", MessageType.ERROR);
            return;
        }
        currSpellBook = bookName;
        String aString = this.pc.delSpell(si, aClass, bookName = currSpellBook);
        if (aString.length() > 0) {
            ShowMessageDelegate.showMessageDialog(aString, "PCGen", MessageType.ERROR);
            return;
        }
        this.pc.setDirty(true);
        this.updateSelectedModel();
    }

    private void metamagicButton() {
        int spLevel;
        TreePath avaCPath = this.availableTable.getTree().getSelectionPath();
        TreePath selCPath = this.selectedTable.getTree().getSelectionPath();
        String bookName = selCPath == null ? this.spellBookNameText.getText() : selCPath.getPathComponent(1).toString();
        if (bookName.length() <= 0) {
            ShowMessageDelegate.showMessageDialog("First select a spellbook to add the spell to", "PCGen", MessageType.ERROR);
            return;
        }
        if (bookName.equals(Globals.getDefaultSpellBook())) {
            ShowMessageDelegate.showMessageDialog("No memorized spells in " + bookName, "PCGen", MessageType.ERROR);
            return;
        }
        currSpellBook = bookName;
        String className = "";
        Object endComp = avaCPath.getLastPathComponent();
        PObjectNode fNode = (PObjectNode)endComp;
        if (!(fNode.getItem() instanceof SpellInfo)) {
            ShowMessageDelegate.showMessageDialog("Unable to metamagic this spell", "PCGen", MessageType.ERROR);
            return;
        }
        SpellInfo si = (SpellInfo)fNode.getItem();
        CharacterSpell spellA = si.getOwner();
        if (!(spellA.getOwner() instanceof PCClass)) {
            ShowMessageDelegate.showMessageDialog("Unable to metamagic spells for " + spellA.getOwner().getName(), "PCGen", MessageType.ERROR);
            return;
        }
        PCClass aClass = (PCClass)spellA.getOwner();
        if (aClass == null) {
            ShowMessageDelegate.showMessageDialog("Can only metamagic spells if sorted by class and level", "PCGen", MessageType.ERROR);
            return;
        }
        if (bookName.equals(Globals.getDefaultSpellBook())) {
            spellA = new CharacterSpell(spellA.getOwner(), spellA.getSpell());
        }
        className = aClass.getCastAs();
        this.createFeatList();
        List featList = this.featModel.getData();
        ChooserInterface c = ChooserFactory.getChooserInstance();
        c.setAvailableList(featList);
        c.setVisible(false);
        c.setPoolFlag(false);
        c.setAllowsDups(true);
        c.setTitle("Add Spell with Metamagic Feats");
        c.setMessageText("Select the Metamagic feats to memorize this spell with");
        c.setPool(99);
        c.setVisible(true);
        ArrayList fList = c.getSelectedList();
        ArrayList<Feat> selFeatList = new ArrayList<Feat>();
        int realLevel = spLevel = si.getActualLevel();
        for (int i = 0; i < fList.size(); ++i) {
            Feat aFeat = this.pc.getFeatNamed(fList.get(i).toString());
            realLevel += aFeat.getAddSpellLevel();
            selFeatList.add(aFeat);
        }
        String aString = this.pc.addSpell(spellA, selFeatList, className, bookName, realLevel, spLevel);
        if (aString.length() > 0) {
            ShowMessageDelegate.showMessageDialog(aString, "PCGen", MessageType.ERROR);
            return;
        }
        this.pc.setDirty(true);
        this.updateSelectedModel();
        this.spellBookNameText.setText(bookName);
    }

    private void selectSpellSheetButton() {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Find and select your Spell output sheet");
        fc.setCurrentDirectory(SettingsHandler.getPcgenOutputSheetDir());
        fc.setSelectedFile(new File(SettingsHandler.getSelectedSpellSheet()));
        if (fc.showOpenDialog(this) == 0) {
            SettingsHandler.setSelectedSpellSheet(fc.getSelectedFile().getAbsolutePath());
            this.selectSpellSheetField.setText(SettingsHandler.getSelectedSpellSheetName());
        }
    }

    private void spellBookNameTextActionPerformed() {
        String aString = this.spellBookNameText.getText();
        if (aString == null || aString.equals(currSpellBook)) {
            return;
        }
        currSpellBook = aString;
        this.spellBookNameText.setText(aString);
        if (!bookList.contains(aString)) {
            bookList.add(aString);
        }
        this.updateAvailableModel();
    }

    private void updateAvailableModel() {
        List pathList = this.availableTable.getExpandedPaths();
        this.createAvailableModel();
        this.availableTable.updateUI();
        this.availableTable.expandPathList(pathList);
    }

    private void updateSelectedModel() {
        List pathList = this.selectedTable.getExpandedPaths();
        TreePath modelSelPath = this.selectedTable.getTree().getSelectionPath();
        int idx = this.selectedTable.getTree().getRowForPath(modelSelPath);
        this.createSelectedModel();
        this.selectedTable.updateUI();
        this.selectedTable.expandPathList(pathList);
        this.selectedTable.getTree().setSelectionPath(modelSelPath);
        this.selectedTable.getTree().expandPath(modelSelPath);
        int count = this.selectedTable.getTree().getRowCount();
        if (idx >= 0 && idx < count) {
            this.setSelectedIndex(this.selectedTable, idx);
        }
    }

    private void primaryViewComboBoxActionPerformed() {
        int index = this.primaryViewComboBox.getSelectedIndex();
        if (index == this.secondaryViewComboBox.getSelectedIndex()) {
            // empty if block
        }
        if (index != primaryViewMode) {
            primaryViewMode = index;
            SettingsHandler.setSpellsTab_AvailableListMode(primaryViewMode);
            this.updateAvailableModel();
        }
    }

    private void secondaryViewComboBoxActionPerformed() {
        int index = this.secondaryViewComboBox.getSelectedIndex();
        if (index == this.primaryViewComboBox.getSelectedIndex()) {
            // empty if block
        }
        if (index != secondaryViewMode) {
            secondaryViewMode = index;
            this.updateAvailableModel();
        }
    }

    private void primaryViewSelectComboBoxActionPerformed() {
        int index = this.primaryViewSelectComboBox.getSelectedIndex();
        if (index == this.secondaryViewSelectComboBox.getSelectedIndex()) {
            // empty if block
        }
        if (index != primaryViewSelectMode) {
            primaryViewSelectMode = index;
            SettingsHandler.setSpellsTab_SelectedListMode(primaryViewSelectMode);
            this.updateSelectedModel();
        }
    }

    private void secondaryViewSelectComboBoxActionPerformed() {
        int index = this.secondaryViewSelectComboBox.getSelectedIndex();
        if (index == this.primaryViewSelectComboBox.getSelectedIndex()) {
            // empty if block
        }
        if (index != secondaryViewSelectMode) {
            secondaryViewSelectMode = index;
            this.updateSelectedModel();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class SpellPopupMenu
    extends JPopupMenu {
        static final long serialVersionUID = 755097384157285101L;

        private SpellPopupMenu(JTreeTable treeTable) {
            if (treeTable == InfoSpells.this.availableTable) {
                this.add(this.createAddMenuItem("Add  Spell to Spellbook", "shortcut EQUALS"));
                this.addSeparator();
                this.add(this.createAddMMMenuItem("Add Spell with Metamagic Feats", "alt C"));
            } else {
                this.add(this.createDelMenuItem("Remove Spell from Spellbook", "shortcut MINUS"));
            }
        }

        private JMenuItem createAddMMMenuItem(String label, String accelerator) {
            InfoSpells.this.addMMMenu = Utility.createMenuItem(label, new AddMMSpellActionListener(), "add 1", '\u0000', accelerator, "Add Spell with Metamagic Feats", "Add16.gif", true);
            return InfoSpells.this.addMMMenu;
        }

        private JMenuItem createAddMenuItem(String label, String accelerator) {
            InfoSpells.this.addMenu = Utility.createMenuItem(label, new AddSpellActionListener(), "add 1", '\u0000', accelerator, "Add Spell to Spellbook", "Add16.gif", true);
            return InfoSpells.this.addMenu;
        }

        private JMenuItem createDelMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new DelSpellActionListener(), "remove 1", '\u0000', accelerator, "Remove Spell from Spellbook", "Remove16.gif", true);
        }

        private class SpellActionListener
        implements ActionListener {
            private SpellActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
            }
        }

        private class DelSpellActionListener
        extends SpellActionListener {
            private DelSpellActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoSpells.this.delSpellButton();
            }
        }

        private class AddSpellActionListener
        extends SpellActionListener {
            private AddSpellActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoSpells.this.addSpellButton();
            }
        }

        private class AddMMSpellActionListener
        extends SpellActionListener {
            private AddMMSpellActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoSpells.this.metamagicButton();
            }
        }
    }

    private class SpellPopupListener
    extends MouseAdapter {
        private JTree tree;
        private JTreeTable aTreeTable;
        private SpellPopupMenu menu;

        private SpellPopupListener(JTreeTable treeTable, SpellPopupMenu aMenu) {
            this.aTreeTable = treeTable;
            this.tree = treeTable.getTree();
            this.menu = aMenu;
            KeyListener myKeyListener = new KeyListener(this){
                private final /* synthetic */ SpellPopupListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTyped(KeyEvent e) {
                    SpellPopupListener.access$4200(this.this$1).dispatchEvent(e);
                }

                public void keyPressed(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    if (keyCode != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                        for (int i = 0; i < SpellPopupListener.access$4300(this.this$1).getComponentCount(); ++i) {
                            KeyStroke ks;
                            Component menuComponent = SpellPopupListener.access$4300(this.this$1).getComponent(i);
                            if (!(menuComponent instanceof JMenuItem) || (ks = ((JMenuItem)menuComponent).getAccelerator()) == null || !keyStroke.equals(ks)) continue;
                            InfoSpells.access$4402(SpellPopupListener.access$4200(this.this$1), SpellPopupListener.access$4500(this.this$1).getSelectionPath());
                            ((JMenuItem)menuComponent).doClick(2);
                            return;
                        }
                    }
                    SpellPopupListener.access$4200(this.this$1).dispatchEvent(e);
                }

                public void keyReleased(KeyEvent e) {
                    SpellPopupListener.access$4200(this.this$1).dispatchEvent(e);
                }
            };
            treeTable.addKeyListener(myKeyListener);
        }

        public void mousePressed(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        private void maybeShowPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                InfoSpells.this.selPath = this.tree.getClosestPathForLocation(evt.getX(), evt.getY());
                if (InfoSpells.this.selPath == null) {
                    return;
                }
                if (this.tree.isSelectionEmpty()) {
                    this.tree.setSelectionPath(InfoSpells.this.selPath);
                    this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                } else if (!this.tree.isPathSelected(InfoSpells.this.selPath)) {
                    this.tree.setSelectionPath(InfoSpells.this.selPath);
                    this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                } else {
                    this.tree.addSelectionPath(InfoSpells.this.selPath);
                    this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
                }
            }
        }

        static /* synthetic */ InfoSpells access$4200(SpellPopupListener x0) {
            return x0.InfoSpells.this;
        }

        static /* synthetic */ SpellPopupMenu access$4300(SpellPopupListener x0) {
            return x0.menu;
        }

        static /* synthetic */ JTree access$4500(SpellPopupListener x0) {
            return x0.tree;
        }
    }

    private final class SpellModel
    extends AbstractTreeTableModel {
        private PObjectNode theRoot;
        private String[] availNameList = new String[]{""};
        private String[] selNameList = new String[]{""};
        private int modelType = 0;
        private boolean includeRace = false;

        private SpellModel(int primaryMode, int secondaryMode, boolean available) {
            super(null);
            this.availNameList = new String[]{"Name", "School", "Descriptor", "Source"};
            this.selNameList = new String[]{"Name", "School", "SubSchool", "Descriptor", "Components", "Casting Time", "Range", "Description", "Target Area", "Duration", "Save Info", "SR", "Source File"};
            if (!available) {
                this.modelType = 1;
            }
            this.resetModel(primaryMode, secondaryMode, available);
        }

        public boolean isCellEditable(Object node, int column) {
            return column == 0;
        }

        public Class getColumnClass(int column) {
            Class clazz = column == 0 ? (class$pcgen$gui$utils$TreeTableModel == null ? (class$pcgen$gui$utils$TreeTableModel = InfoSpells.class$("pcgen.gui.utils.TreeTableModel")) : class$pcgen$gui$utils$TreeTableModel) : (class$java$lang$String == null ? (class$java$lang$String = InfoSpells.class$("java.lang.String")) : class$java$lang$String);
            return clazz;
        }

        public int getColumnCount() {
            return this.modelType == 0 ? this.availNameList.length : this.selNameList.length;
        }

        public String getColumnName(int column) {
            return this.modelType == 0 ? this.availNameList[column] : this.selNameList[column];
        }

        public Object getRoot() {
            return (PObjectNode)super.getRoot();
        }

        public Object getValueAt(Object node, int column) {
            PObjectNode fn = (PObjectNode)node;
            Spell aSpell = null;
            CharacterSpell spellA = null;
            int spLevel = 0;
            if (fn == null) {
                Logging.errorPrint("Somehow we have no active node when doing getValueAt in InfoSpells.");
                return null;
            }
            if (fn.getItem() instanceof SpellInfo) {
                spellA = ((SpellInfo)fn.getItem()).getOwner();
                aSpell = spellA.getSpell();
                spLevel = ((SpellInfo)fn.getItem()).getActualLevel();
            }
            column = this.adjustAvailColumnConst(column);
            switch (column) {
                case 0: {
                    return fn.toString();
                }
                case 1: {
                    return aSpell != null ? aSpell.getSchool() : null;
                }
                case 2: {
                    return aSpell != null ? aSpell.getSubschool() : null;
                }
                case 3: {
                    return aSpell != null ? aSpell.descriptor() : null;
                }
                case 4: {
                    return aSpell != null ? aSpell.getComponentList() : null;
                }
                case 5: {
                    return aSpell != null ? aSpell.getCastingTime() : null;
                }
                case 6: {
                    return aSpell != null ? aSpell.getRange() : null;
                }
                case 7: {
                    if (aSpell != null && spellA != null) {
                        return InfoSpells.this.pc.parseSpellString(aSpell, aSpell.getDescription(), spellA.getOwner());
                    }
                    return aSpell != null ? aSpell.piDescString() : null;
                }
                case 8: {
                    if (aSpell != null && spellA != null) {
                        return InfoSpells.this.pc.parseSpellString(aSpell, aSpell.getTarget(), spellA.getOwner());
                    }
                    return aSpell != null ? aSpell.getTarget() : null;
                }
                case 9: {
                    if (aSpell != null && spellA != null) {
                        return InfoSpells.this.pc.parseSpellString(aSpell, aSpell.getDuration(), spellA.getOwner());
                    }
                    return aSpell != null ? aSpell.getDuration() : null;
                }
                case 10: {
                    return aSpell != null ? aSpell.getSaveInfo() : null;
                }
                case 11: {
                    return aSpell != null ? aSpell.getSpellResistance() : null;
                }
                case 12: {
                    return aSpell != null ? aSpell.getSource() : null;
                }
            }
            return fn.getItem();
        }

        private void setRoot(PObjectNode aNode) {
            super.setRoot(aNode);
        }

        private void addDomainSpellsForClass(String className, PObjectNode theParent, int iLev) {
            int iMax = InfoSpells.this.pc.getCharacterDomainList().size();
            if (iMax == 0) {
                return;
            }
            PObjectNode p = new PObjectNode();
            p.setItem("Domains");
            boolean dom = false;
            for (int iDom = 0; iDom < InfoSpells.this.pc.getCharacterDomainList().size(); ++iDom) {
                CharacterDomain aCD = (CharacterDomain)InfoSpells.this.pc.getCharacterDomainList().get(iDom);
                Domain aDom = aCD.getDomain();
                if (aDom == null || !aCD.isFromPCClass(className)) continue;
                List domainSpells = Globals.getSpellsIn(iLev, "", aDom.getName());
                p.setParent(theParent);
                if (!dom) {
                    theParent.addChild(p);
                }
                dom = true;
                InfoSpells.setNodeSpells(domainSpells, p, iLev, aDom, Globals.getDefaultSpellBook(), InfoSpells.this.pc);
            }
        }

        private int adjustAvailColumnConst(int column) {
            if (this.modelType == 0) {
                if (column == 2) {
                    column = 3;
                } else if (column >= 3) {
                    column = 12;
                }
            }
            return column;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void resetModel(int primaryMode, int secondaryMode, boolean available) {
            ArrayList<PObject> classList = new ArrayList<PObject>();
            ArrayList spellList = new ArrayList();
            this.includeRace = false;
            bookList.clear();
            PObjectNode[] primaryNodes = null;
            PObjectNode[] secondaryNodes = null;
            PObjectNode[] bookNodes = null;
            this.theRoot = new PObjectNode();
            this.setRoot(this.theRoot);
            if (!available) {
                Iterator iBook = InfoSpells.this.pc.getSpellBooks().iterator();
                while (iBook.hasNext()) {
                    String sBook = (String)iBook.next();
                    if (bookList.contains(sBook)) continue;
                    bookList.add(sBook);
                }
                bookNodes = new PObjectNode[bookList.size()];
                int ix = 0;
                Iterator iBook2 = bookList.iterator();
                while (iBook2.hasNext()) {
                    String bookName = (String)iBook2.next();
                    bookNodes[ix] = new PObjectNode();
                    bookNodes[ix].setItem(bookName);
                    bookNodes[ix].setParent(this.theRoot);
                    spellList.addAll(InfoSpells.this.pc.getRace().getCharacterSpell(null, bookName, -1));
                    ++ix;
                }
                this.theRoot.setChildren(bookNodes);
            }
            this.includeRace = !spellList.isEmpty();
            Iterator iClass = InfoSpells.this.pc.getClassList().iterator();
            while (iClass.hasNext()) {
                List aList;
                PCClass aClass = (PCClass)iClass.next();
                if (aClass.getSpellType().equals("None") || aClass.zeroCastSpells() && aClass.getKnownList().isEmpty()) continue;
                classList.add(aClass);
                if (available) {
                    aList = Globals.getSpellsIn(-1, aClass.getSpellKey(), "");
                    Iterator si = aList.iterator();
                    while (si.hasNext()) {
                        Object s = si.next();
                        if (spellList.contains(s)) continue;
                        spellList.add(s);
                    }
                    continue;
                }
                aList = aClass.getCharacterSpellList();
                if (aList == null) continue;
                spellList.addAll(aList);
            }
            if (this.includeRace) {
                classList.add(InfoSpells.this.pc.getRace());
            }
            boolean firstPass = true;
            HashMap<String, ArrayList<SpellInfo>> usedMap = new HashMap<String, ArrayList<SpellInfo>>();
            Iterator ii = spellList.iterator();
            block36: while (true) {
                CharacterSpell cs;
                Spell spell;
                Object sp;
                if (ii.hasNext()) {
                    sp = ii.next();
                    spell = null;
                    cs = null;
                    if (sp instanceof CharacterSpell) {
                        cs = (CharacterSpell)sp;
                        spell = cs.getSpell();
                        if (available && cs.getOwner() instanceof Domain) continue;
                    }
                    if (sp instanceof Spell) {
                        spell = (Spell)sp;
                    }
                } else {
                    PObjectNode rootAsPObjectNode = (PObjectNode)super.getRoot();
                    if (rootAsPObjectNode.getChildCount() > 0) {
                        rootAsPObjectNode.pruneEmpty();
                        this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
                    }
                    if (currSpellBook.equals("")) {
                        currSpellBook = Globals.getDefaultSpellBook();
                    }
                    InfoSpells.this.spellBookNameText.setText(currSpellBook);
                    return;
                }
                int ix = 0;
                while (true) {
                    String bookName;
                    block74: {
                        block75: {
                            if (ix > bookList.size() || !available && ix == bookList.size()) break block75;
                            bookName = currSpellBook;
                            if (!available) {
                                bookName = bookList.get(ix).toString();
                            }
                            if (firstPass) {
                                switch (primaryMode) {
                                    case 0: {
                                        primaryNodes = this.getClassNameNodes(classList);
                                        break;
                                    }
                                    case 1: {
                                        primaryNodes = this.getLevelNodes();
                                        break;
                                    }
                                    case 2: {
                                        primaryNodes = this.getDescriptorNodes();
                                        break;
                                    }
                                    case 3: {
                                        primaryNodes = this.getRangeNodes();
                                        break;
                                    }
                                    case 4: {
                                        primaryNodes = this.getDurationNodes();
                                        break;
                                    }
                                    case 5: {
                                        primaryNodes = this.getTypeNodes();
                                        break;
                                    }
                                }
                                break block74;
                            } else if (!available) {
                                bookNodes[ix].getChildren().toArray(primaryNodes);
                                break block74;
                            } else {
                                this.theRoot.getChildren().toArray(primaryNodes);
                            }
                            break block74;
                        }
                        firstPass = false;
                        continue block36;
                    }
                    block38: for (int pindex = 0; pindex < primaryNodes.length; ++pindex) {
                        if (sp instanceof Spell) {
                            cs = null;
                        }
                        boolean primaryMatch = false;
                        boolean spellMatch = false;
                        SpellInfo si = null;
                        PObject aClass = null;
                        int iLev = -1;
                        switch (primaryMode) {
                            case 0: {
                                aClass = (PObject)classList.get(pindex);
                                boolean bl = primaryMatch = spell.getFirstLevelForKey(aClass.getSpellKey(), InfoSpells.this.pc) >= 0;
                                if (cs == null) break;
                                if (aClass instanceof Race) {
                                    primaryMatch = cs.getOwner() == aClass;
                                    break;
                                }
                                if (cs.getOwner() instanceof Domain) {
                                    List aList = aClass.getCharacterSpellList();
                                    primaryMatch = aList != null && aList.contains(cs);
                                    break;
                                }
                                primaryMatch = aClass == cs.getOwner();
                                break;
                            }
                            case 1: {
                                iLev = pindex;
                                primaryMatch = true;
                                si = null;
                                if (primaryMatch && cs != null) {
                                    si = cs.getSpellInfoFor(bookName, iLev, -1);
                                }
                                if (si == null) {
                                    primaryMatch = spell.isLevel(iLev, InfoSpells.this.pc);
                                    break;
                                }
                                if (!available || si == null || si.getFeatList() == null) break;
                                continue block38;
                            }
                            case 2: {
                                primaryMatch = spell.getDescriptorList().contains(primaryNodes[pindex].toString());
                                break;
                            }
                            case 3: {
                                primaryMatch = spell.getRange().equals(primaryNodes[pindex].toString());
                                break;
                            }
                            case 4: {
                                primaryMatch = spell.getDuration().equals(primaryNodes[pindex].toString());
                                break;
                            }
                            case 5: {
                                primaryMatch = spell.isType(primaryNodes[pindex].toString());
                            }
                        }
                        if (firstPass) {
                            switch (secondaryMode) {
                                case 0: {
                                    secondaryNodes = this.getClassNameNodes(classList);
                                    break;
                                }
                                case 1: {
                                    secondaryNodes = this.getLevelNodes();
                                    break;
                                }
                                case 2: {
                                    secondaryNodes = this.getDescriptorNodes();
                                    break;
                                }
                                case 3: {
                                    secondaryNodes = this.getRangeNodes();
                                    break;
                                }
                                case 4: {
                                    secondaryNodes = this.getDurationNodes();
                                    break;
                                }
                                case 5: {
                                    secondaryNodes = this.getTypeNodes();
                                    break;
                                }
                            }
                        } else {
                            if (!primaryMatch) continue;
                            primaryNodes[pindex].getChildren().toArray(secondaryNodes);
                        }
                        block39: for (int sindex = 0; sindex < secondaryNodes.length; ++sindex) {
                            List aList;
                            String mapKey = bookName + "." + primaryNodes[pindex].toString() + "." + secondaryNodes[sindex].toString();
                            switch (secondaryMode) {
                                case 0: {
                                    aClass = (PObject)classList.get(sindex);
                                    spellMatch = primaryMatch && spell.getFirstLevelForKey(aClass.getSpellKey(), InfoSpells.this.pc) >= 0;
                                    break;
                                }
                                case 1: {
                                    iLev = sindex;
                                    spellMatch = primaryMatch;
                                    si = null;
                                    if (spellMatch && cs != null) {
                                        si = cs.getSpellInfoFor(bookName, iLev, -1);
                                    }
                                    if (si == null && primaryMatch) {
                                        spellMatch = spell.isLevel(iLev, InfoSpells.this.pc);
                                    }
                                    if (!available || si == null || si.getFeatList() == null) break;
                                    continue block39;
                                }
                                case 2: {
                                    spellMatch = primaryMatch && spell.getDescriptorList().contains(secondaryNodes[sindex].toString());
                                    break;
                                }
                                case 3: {
                                    spellMatch = primaryMatch && spell.getRange().equals(secondaryNodes[sindex].toString());
                                    break;
                                }
                                case 4: {
                                    spellMatch = primaryMatch && spell.getRange().equals(secondaryNodes[sindex].toString());
                                    break;
                                }
                                case 5: {
                                    spellMatch = primaryMatch && spell.isType(secondaryNodes[sindex].toString());
                                }
                            }
                            if (firstPass) {
                                secondaryNodes[sindex].setParent(primaryNodes[pindex]);
                                if (available && aClass != null && iLev > -1 && aClass instanceof PCClass) {
                                    this.addDomainSpellsForClass(((PCClass)aClass).getCastAs(), secondaryNodes[sindex], iLev);
                                }
                            }
                            if (si != null && !si.getBook().equals(bookName) || !available && si != null && (aList = (List)usedMap.get(mapKey)) != null && aList.contains(si)) continue;
                            if (aClass != null && iLev > -1 && spellMatch && aClass instanceof PCClass) {
                                int theLevel = iLev;
                                if (si != null) {
                                    theLevel = -1;
                                }
                                PObject theObject = aClass;
                                if (cs != null) {
                                    theObject = cs.getOwner();
                                }
                                spellMatch = spell.levelForKeyContains(theObject.getSpellKey(), theLevel, InfoSpells.this.pc);
                            }
                            if (spellMatch && si == null && available) {
                                PObject bClass = aClass;
                                if (aClass == null && classList.size() == 1) {
                                    bClass = (PObject)classList.get(0);
                                }
                                cs = new CharacterSpell(bClass, spell);
                                si = cs.addInfo(iLev, 1, bookName);
                            }
                            if (!spellMatch || si == null) continue;
                            PObjectNode spellNode = new PObjectNode();
                            spellNode.setItem(si);
                            spellNode.setParent(secondaryNodes[sindex]);
                            secondaryNodes[sindex].addChild(spellNode);
                            ArrayList<SpellInfo> aList2 = (ArrayList<SpellInfo>)usedMap.get(mapKey);
                            if (aList2 == null) {
                                aList2 = new ArrayList<SpellInfo>();
                            }
                            aList2.add(si);
                            usedMap.put(mapKey, aList2);
                        }
                        primaryNodes[pindex].setChildren(secondaryNodes);
                        if (available) {
                            primaryNodes[pindex].setParent(this.theRoot);
                            continue;
                        }
                        primaryNodes[pindex].setParent(bookNodes[ix]);
                    }
                    if (!available) {
                        bookNodes[ix].setChildren(primaryNodes);
                    } else {
                        this.theRoot.setChildren(primaryNodes);
                    }
                    ++ix;
                }
                break;
            }
        }

        private PObjectNode[] getClassNameNodes(List classList) {
            PObjectNode[] tempNodes = new PObjectNode[classList.size()];
            for (int ix = 0; ix < classList.size(); ++ix) {
                PObject obj = (PObject)classList.get(ix);
                String objName = obj.piString();
                tempNodes[ix] = new PObjectNode();
                tempNodes[ix].setItem(objName);
            }
            return tempNodes;
        }

        private PObjectNode[] getLevelNodes() {
            PObjectNode[] tempNodes = new PObjectNode[20];
            for (int ix = 0; ix < 20; ++ix) {
                tempNodes[ix] = new PObjectNode();
                tempNodes[ix].setItem("level " + ix);
            }
            return tempNodes;
        }

        private PObjectNode[] getDescriptorNodes() {
            PObjectNode[] tempNodes = new PObjectNode[Globals.getDescriptorSet().size()];
            int ix = 0;
            Iterator ti = Globals.getDescriptorSet().iterator();
            while (ti.hasNext()) {
                tempNodes[ix] = new PObjectNode();
                tempNodes[ix++].setItem((String)ti.next());
            }
            return tempNodes;
        }

        private PObjectNode[] getRangeNodes() {
            PObjectNode[] tempNodes = new PObjectNode[Globals.getRangesSet().size()];
            int ix = 0;
            Iterator ti = Globals.getRangesSet().iterator();
            while (ti.hasNext()) {
                tempNodes[ix] = new PObjectNode();
                tempNodes[ix++].setItem((String)ti.next());
            }
            return tempNodes;
        }

        private PObjectNode[] getDurationNodes() {
            PObjectNode[] tempNodes = new PObjectNode[Globals.getDurationSet().size()];
            int ix = 0;
            Iterator ti = Globals.getDurationSet().iterator();
            while (ti.hasNext()) {
                tempNodes[ix] = new PObjectNode();
                tempNodes[ix++].setItem((String)ti.next());
            }
            return tempNodes;
        }

        private PObjectNode[] getTypeNodes() {
            PObjectNode[] tempNodes = new PObjectNode[Globals.getTypeForSpells().size()];
            int ix = 0;
            Iterator ti = Globals.getTypeForSpells().iterator();
            while (ti.hasNext()) {
                tempNodes[ix] = new PObjectNode();
                tempNodes[ix++].setItem((String)ti.next());
            }
            return tempNodes;
        }
    }

    private static final class SpellFeatModel
    extends AbstractTableModel {
        static final long serialVersionUID = 755097384157285101L;
        private List data = new ArrayList();
        private final String[] nameList = new String[]{"Metamagic Feats"};

        private SpellFeatModel() {
        }

        public Class getColumnClass(int c) {
            return class$java$lang$String == null ? (class$java$lang$String = InfoSpells.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            return this.nameList.length;
        }

        public String getColumnName(int col) {
            return this.nameList[col];
        }

        public int getRowCount() {
            return this.data.size();
        }

        public Object getValueAt(int row, int col) {
            return this.data.get(row);
        }

        private void setData(List aArrayList) {
            this.data = aArrayList;
        }

        private List getData() {
            return this.data;
        }
    }
}

