/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import pcgen.core.Constants;
import pcgen.core.Equipment;
import pcgen.core.EquipmentList;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCStat;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.StatList;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfo;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.NameGui;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.pcGenGUI;
import pcgen.gui.tabs.InfoAbilities;
import pcgen.gui.utils.FormattedCellEditor;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.RegexFormatter;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.TableSorter;
import pcgen.gui.utils.Utility;
import pcgen.gui.utils.WholeNumberField;
import pcgen.util.Delta;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public final class InfoSummary
extends FilterAdapterPanel
implements CharacterInfoTab {
    private static final String NONABILITY = PropertyFactory.getString("in_sumCannotModifyANonAbility");
    private static final String STAT_UPPER_LIMIT = PropertyFactory.getString("in_sumCannotRaiseStatAbove");
    private static final String IN_PURCHASE_MODE = PropertyFactory.getString("in_sumInPurchaseMode");
    private static final String STAT_LOWER_LIMIT = PropertyFactory.getString("in_sumCannotLowerStatBelow");
    private static final int STAT_COLUMN = 0;
    private static final int BASE_COLUMN = 1;
    private static final int RACE_COLUMN = 2;
    private static final int OTHER_COLUMN = 3;
    private static final int TOTAL_COLUMN = 4;
    private static final int MOD_COLUMN = 5;
    private static final int INC_COLUMN = 6;
    private static final int DEC_COLUMN = 7;
    private static boolean needsUpdate = true;
    private static final int COL_PCLEVEL = 0;
    private static final int COL_CLASSNAME = 1;
    private static final int COL_SRC = 2;
    private ClassComboModel classComboModel = null;
    private ClassModel pcClassTreeModel = null;
    private InfoAbilities infoAbilities;
    private JButton jButtonHP = new JButton();
    private JButton lvlDownButton = new JButton("-");
    private JButton lvlUpButton = new JButton("+");
    private JComboBoxEx alignmentComboBox = new JComboBoxEx();
    private JComboBoxEx classComboBox = new JComboBoxEx();
    private JComboBoxEx raceComboBox = new JComboBoxEx();
    private JFrame abilitiesFrame = new JFrame(PropertyFactory.getString("in_abilities"));
    private JLabel labelAlignment = null;
    private JLabel labelClass = null;
    private JLabel labelHP = new JLabel();
    private JLabel labelName = null;
    private JLabel labelRace = null;
    private JLabel poolLabel = new JLabel(PropertyFactory.getString("in_sumStatCost"));
    private JLabel poolText = new JLabel();
    private JPanel levelPanel = new JPanel();
    private JPanel northPanel = new JPanel();
    private JPanel poolPanel = new JPanel();
    private JTableEx pcClassTable;
    private JTextField pcNameText = new JTextField("");
    private JTextField playerNameText = new JTextField("");
    private JTextField tabNameText = new JTextField("");
    private RaceComboModel raceComboModel = null;
    private WholeNumberField levelText = new WholeNumberField(1, 3);
    private String[] alignmentStrings;
    private boolean abilitiesFrameHasBeenSized = false;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;
    private ActionListener abilitiesListener = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            if (!InfoSummary.this.abilitiesFrameHasBeenSized) {
                Dimension screenSize = PCGen_Frame1.getCharacterPane().getParent().getParent().getSize();
                int screenHeight = screenSize.height;
                int screenWidth = screenSize.width;
                InfoSummary.this.abilitiesFrame.setSize(screenWidth, screenHeight);
                InfoSummary.this.abilitiesFrameHasBeenSized = true;
            }
            InfoSummary.this.abilitiesFrame.setVisible(true);
            InfoAbilities.setNeedsUpdate(true);
        }
    };
    private ActionListener alignmentListener = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            if (InfoSummary.this.alignmentComboBox.getSelectedItem() != null) {
                InfoSummary.this.alignmentChanged();
            }
        }
    };
    private ActionListener classListener = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            if (InfoSummary.this.classComboBox.getSelectedItem() != null) {
                PCClass pcClass = (PCClass)InfoSummary.this.classComboBox.getSelectedItem();
                InfoSummary.this.setInfoLabelText(pcClass);
                if (pcClass.isQualified(InfoSummary.this.pc)) {
                    InfoSummary.this.labelClass.setForeground(new Color(SettingsHandler.getPrereqQualifyColor()));
                } else {
                    InfoSummary.this.labelClass.setForeground(new Color(SettingsHandler.getPrereqFailColor()));
                }
            }
        }
    };
    private ActionListener levelCmdListener = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            int numLevels = InfoSummary.this.levelText.getValue();
            if (numLevels <= 0) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_sumNumberOfLevelsMustBePositive"), "PCGen", MessageType.ERROR);
                return;
            }
            PCClass pcClass = (PCClass)InfoSummary.this.classComboBox.getSelectedItem();
            if (pcClass == null) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_sumYouMustSelectAClass"), "PCGen", MessageType.ERROR);
                return;
            }
            if (!pcClass.isQualified(InfoSummary.this.pc)) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_sumYouAreNotQualifiedToTakeTheClass") + pcClass.getName() + ".", "PCGen", MessageType.ERROR);
                return;
            }
            if (evt.getSource() == InfoSummary.this.lvlDownButton) {
                numLevels *= -1;
            }
            InfoSummary.this.addClass(pcClass, numLevels);
            InfoSummary.this.pcClassTreeModel.fireTableDataChanged();
        }
    };
    private ActionListener raceListener = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            Race race = (Race)InfoSummary.this.raceComboBox.getSelectedItem();
            if (race != null) {
                InfoSummary.this.setInfoLabelText(race);
            }
        }
    };
    private ActionListener randNameListener = new ActionListener(){

        public void actionPerformed(ActionEvent evt) {
            if (InfoSummary.this.nameFrame == null) {
                InfoSummary.this.nameFrame = new NameGui();
            }
            InfoSummary.this.nameFrame.setVisible(true);
        }
    };
    private Border etched;
    private FocusAdapter nonRaceFocusListener = new FocusAdapter(){

        public void focusGained(FocusEvent evt) {
            Runnable doUpdate = new Runnable(this){
                private final /* synthetic */ 7 this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    InfoSummary.access$1600(7.access$1500(this.this$1));
                }
            };
            SwingUtilities.invokeLater(doUpdate);
        }

        static /* synthetic */ InfoSummary access$1500(7 x0) {
            return x0.InfoSummary.this;
        }
    };
    private FocusAdapter pcNameAdapter = new FocusAdapter(){

        public void focusLost(FocusEvent evt) {
            String entry = InfoSummary.this.pcNameText.getText();
            if (entry != null && !entry.equals(InfoSummary.this.pc.getName())) {
                InfoSummary.this.pc.setName(entry);
                PCGen_Frame1.forceUpdate_PlayerTabs();
            }
        }
    };
    private FocusAdapter playerNameAdapter = new FocusAdapter(){

        public void focusLost(FocusEvent evt) {
            String entry = InfoSummary.this.playerNameText.getText();
            if (entry != null && !entry.equals(InfoSummary.this.pc.getPlayersName())) {
                InfoSummary.this.pc.setPlayersName(entry);
            }
        }
    };
    private FocusAdapter raceFocusListener = new FocusAdapter(){

        public void focusLost(FocusEvent evt) {
            if (evt.isTemporary()) {
                return;
            }
            Runnable doUpdate = new Runnable(this){
                private final /* synthetic */ 11 this$1;
                {
                    this.this$1 = this$1;
                }

                public void run() {
                    InfoSummary.access$1600(11.access$1900(this.this$1));
                }
            };
            SwingUtilities.invokeLater(doUpdate);
        }

        static /* synthetic */ InfoSummary access$1900(11 x0) {
            return x0.InfoSummary.this;
        }
    };
    private FocusAdapter tabNameAdapter = new FocusAdapter(){

        public void focusLost(FocusEvent evt) {
            String entry = InfoSummary.this.tabNameText.getText();
            if (entry != null && !entry.equals(InfoSummary.this.pc.getTabName())) {
                InfoSummary.this.pc.setTabName(entry);
            }
        }
    };
    private JButton abilitiesButton;
    private JButton btnAddHD = new JButton("+");
    private JButton btnRemoveHD = new JButton("-");
    private JButton randName;
    private JLabel lblHDModify = new JLabel();
    private JLabel lblMonsterlHD = new JLabel();
    private JLabel txtMonsterlHD = new JLabel();
    private JLabelPane infoPane = new JLabelPane();
    private JLabelPane statPane = new JLabelPane();
    private JLabelPane tipsPane = new JLabelPane();
    private JPanel pnlHD = new JPanel();
    private JTableEx statTable;
    private NameGui nameFrame = null;
    private RendererEditor plusMinusRenderer = new RendererEditor();
    private StatTableModel statTableModel = new StatTableModel();
    private WholeNumberField txtHD = new WholeNumberField(1, 3);
    static /* synthetic */ Class class$java$lang$String;

    public InfoSummary(PlayerCharacter pc) {
        this.pc = pc;
        this.infoAbilities = new InfoAbilities(pc);
        this.setName(Constants.tabNames[10]);
        this.initComponents();
        FilterFactory.restoreFilterSettings(this);
    }

    public void setPc(PlayerCharacter pc) {
        if (this.pc != pc || pc.getSerial() > this.serial) {
            this.pc = pc;
            this.serial = pc.getSerial();
            this.forceRefresh();
        }
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.Summary.Order", 10);
    }

    public void setTabOrder(int order) {
        SettingsHandler.setPCGenOption(".Panel.Summary.Order", order);
    }

    public String getTabName() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabName(10);
    }

    public boolean isShown() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabShown(10);
    }

    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
            this.infoAbilities.setPc(this.pc);
        } else {
            this.serial = 0;
        }
    }

    public JComponent getView() {
        return this;
    }

    public static void setNeedsUpdate(boolean flag) {
        needsUpdate = flag;
    }

    public boolean isMatchAnyEnabled() {
        return true;
    }

    public boolean isNegateEnabled() {
        return true;
    }

    public JTextField getPcNameText() {
        return this.pcNameText;
    }

    public int getSelectionMode() {
        return 2;
    }

    public void addMonsterHD(int direction) {
        PCClass aClass;
        int numHD = this.txtHD.getValue();
        if (numHD <= 0) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_sumNumberOfHitDiceMustBePositive"), "PCGen", MessageType.ERROR);
            return;
        }
        numHD *= direction;
        String monsterClass = this.pc.getRace().getMonsterClass(this.pc, false);
        if (monsterClass != null && (aClass = Globals.getClassNamed(monsterClass)) != null) {
            if (numHD < 0) {
                int minHD = this.pc.getRace().getMonsterClassLevels(this.pc) + this.pc.getRace().hitDice(this.pc);
                PCClass pcClass = this.pc.getClassNamed(monsterClass);
                int currentHD = this.pc.getRace().hitDice(this.pc);
                if (pcClass != null) {
                    currentHD += pcClass.getLevel();
                }
                Logging.errorPrint("minHD=" + minHD + "  currentHD=" + currentHD + "  numHD=" + numHD);
                if (currentHD + numHD < minHD) {
                    numHD = minHD - currentHD;
                    Logging.errorPrint("numHD modified to: " + numHD);
                }
                if (pcClass == null || numHD == 0 || currentHD + numHD < minHD) {
                    ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_sumCannotLowerHitDiceAnyMore"), "PCGen", MessageType.ERROR);
                    return;
                }
            }
            this.addClass(aClass, numHD);
        }
    }

    public void initializeFilters() {
        this.registerFilter(FilterFactory.createPCClassFilter());
        FilterFactory.registerAllSourceFilters(this);
        FilterFactory.registerAllSizeFilters(this);
        FilterFactory.registerAllRaceFilters(this);
        FilterFactory.registerAllClassFilters(this);
        FilterFactory.registerAllPrereqAlignmentFilters(this);
    }

    public synchronized void refreshFiltering() {
        this.stopListeners();
        if (this.raceComboModel != null) {
            this.raceComboModel.updateModel();
        }
        if (this.classComboModel != null) {
            this.classComboModel.updateModel();
        }
        this.startListeners();
    }

    public void updateHP() {
        this.labelHP.setText(String.valueOf(this.pc.hitPoints()));
    }

    private static int getUsedStatPool(PlayerCharacter pc) {
        int i = 0;
        for (int stat = 0; stat < SettingsHandler.getGame().s_ATTRIBLONG.length; ++stat) {
            int statValue = pc.getStatList().getBaseStatFor(SettingsHandler.getGame().s_ATTRIBSHORT[stat]);
            if (!SettingsHandler.getGame().s_ATTRIBROLL[stat]) continue;
            if (statValue > SettingsHandler.getPurchaseScoreMax()) {
                statValue = SettingsHandler.getPurchaseScoreMax();
            }
            if (statValue < SettingsHandler.getPurchaseScoreMin()) continue;
            i += SettingsHandler.getAbilityScoreCost(statValue - SettingsHandler.getPurchaseScoreMin());
        }
        return i;
    }

    private void setInfoLabelText(Race aRace) {
        StringBuffer b = new StringBuffer();
        b.append("<html>");
        if (aRace != null && !aRace.getName().startsWith("<none")) {
            String bString;
            b.append("<b>").append(PropertyFactory.getString("in_sumRace")).append(aRace.getName()).append("</b>");
            b.append(" &nbsp;<b>").append(PropertyFactory.getString("in_sumTYPE")).append("</b>:").append(aRace.getType());
            String cString = aRace.preReqHTMLStrings(this.pc, false);
            if (cString.length() > 0) {
                b.append(" &nbsp;<b>").append(PropertyFactory.getString("in_sumRequirements"));
                b.append("</b>:").append(cString);
            }
            if ((bString = aRace.getSource()).length() > 0) {
                b.append(" &nbsp;<b>").append(PropertyFactory.getString("in_sumSource1"));
                b.append("</b>:").append(bString);
            }
            StringBuffer aString = new StringBuffer();
            for (int i = 0; i < SettingsHandler.getGame().s_ATTRIBSHORT.length; ++i) {
                if (aRace.isNonAbility(i)) {
                    if (aString.length() > 0) {
                        aString.append(' ');
                    }
                    aString.append(SettingsHandler.getGame().s_ATTRIBSHORT[i]).append(PropertyFactory.getString("in_SumNonability"));
                    continue;
                }
                if (aRace.getStatMod(i, this.pc) == 0) continue;
                if (aString.length() > 0) {
                    aString.append(' ');
                }
                aString.append(SettingsHandler.getGame().s_ATTRIBSHORT[i]).append(':').append(aRace.getStatMod(i, this.pc));
            }
            if (aString.length() > 0) {
                b.append(" &nbsp;<b>").append(PropertyFactory.getString("in_sumStatAdj")).append("</b>");
                b.append(String.valueOf(aString));
            }
            b.append(" &nbsp;<b>").append(PropertyFactory.getString("in_sumSize1")).append("</b>");
            b.append(aRace.getSize());
            if (aRace.getNumberOfMovements() > 0) {
                StringBuffer movelabel = new StringBuffer();
                movelabel.append(aRace.getMovementType(0));
                movelabel.append(' ').append(Globals.displayDistanceInUnitSet(Globals.convertDistanceToUnitSet(aRace.getMovement(0))));
                movelabel.append(Globals.getDistanceUnit());
                for (int i = 1; i < aRace.getNumberOfMovements(); ++i) {
                    movelabel.append(aRace.getMovementType(i));
                    movelabel.append(' ').append(Globals.displayDistanceInUnitSet(Globals.convertDistanceToUnitSet(aRace.getMovement(i))));
                    movelabel.append(Globals.getDistanceUnit());
                }
                b.append(" &nbsp;<b>").append(PropertyFactory.getString("in_sumMove")).append("</b>").append(String.valueOf(movelabel));
            }
            b.append(" &nbsp;<b>").append(PropertyFactory.getString("in_sumVision")).append("</b>").append(aRace.getDisplayVision(this.pc));
            if (aRace.getFavoredClass().length() != 0) {
                b.append(" &nbsp;<b>").append("FAVORED CLASS:").append("</b>").append(!aRace.getFavoredClass().equals(".") ? aRace.getFavoredClass() : PropertyFactory.getString("in_sumVarious"));
            }
            if (aRace.getLevelAdjustment(this.pc) > 0) {
                b.append(" &nbsp;<b>").append(PropertyFactory.getString("in_sumLevelAdj")).append("</b>:").append(String.valueOf(aRace.getLevelAdjustment(this.pc)));
            }
        }
        b.append("</html>");
        this.infoPane.setText(b.toString());
    }

    private void setInfoLabelText(PCClass aClass) {
        if (aClass != null) {
            String bString;
            StringBuffer b = new StringBuffer();
            b.append("<html><b>").append(PropertyFactory.getString("in_sumClass")).append(aClass.getName()).append("</b>");
            b.append(" &nbsp;<b>").append(PropertyFactory.getString("in_sumTYPE")).append("</b>:").append(aClass.getType());
            String cString = aClass.preReqHTMLStrings(this.pc, false);
            if (cString.length() > 0) {
                b.append(" &nbsp;<b>").append(PropertyFactory.getString("in_sumRequirements")).append("</b>:").append(cString);
            }
            if ((bString = aClass.getSource()).length() > 0) {
                b.append(" <b>").append(PropertyFactory.getString("in_sumSource")).append("</b>:").append(bString);
            }
            b.append(" <b>").append(PropertyFactory.getString("in_sumBAB1")).append("</b>").append(aClass.getAttackBonusType());
            b.append(" <b>").append(PropertyFactory.getString("in_sumHD")).append("</b>1D").append(aClass.getBaseHitDie() + "");
            if (Globals.getGameModeShowSpellTab()) {
                b.append(" <b>").append(PropertyFactory.getString("in_sumSpelltype")).append("</b>").append(aClass.getSpellType());
                b.append(" <b>").append(PropertyFactory.getString("in_sumBaseStat")).append("</b>").append(aClass.getSpellBaseStat());
            }
            b.append("</html>");
            this.infoPane.setText(b.toString());
        }
    }

    private void setStatLabelText() {
        StringBuffer statBuf = new StringBuffer();
        statBuf.append("<html>");
        if (this.pc != null) {
            if (Globals.getGameModeACText().length() != 0) {
                statBuf.append("<b>").append(Globals.getGameModeACAbbrev()).append("</b> ");
                statBuf.append("<i>").append(PropertyFactory.getString("in_sumTotal")).append("</i>: ").append(this.pc.getACTotal());
                statBuf.append(" <i>").append(PropertyFactory.getString("in_sumFlatfooted")).append("</i>: ").append(this.pc.flatfootedAC());
                statBuf.append(" <i>").append(PropertyFactory.getString("in_sumTouch")).append("</i>: ").append(this.pc.touchAC());
                statBuf.append("<br>");
            } else {
                statBuf.append("<b>").append("Total AC:").append("</b> ").append((int)this.pc.getTotalBonusTo(PropertyFactory.getString("in_sumCombat"), PropertyFactory.getString("in_sumAC")));
                statBuf.append("<br>");
            }
            int initMod = this.pc.initiativeMod();
            statBuf.append("<b>").append(PropertyFactory.getString("in_sumInit")).append("</b>: ").append(Delta.toString(initMod));
            int bonus = this.pc.baseAttackBonus();
            statBuf.append(" <b>").append(PropertyFactory.getString("in_sumBAB")).append("</b>: ").append(Delta.toString(bonus));
            statBuf.append(" <b>").append(Globals.getGameModeHPAbbrev()).append("</b>: ").append(this.pc.hitPoints());
            if (Globals.getGameModeAltHPText().length() != 0) {
                statBuf.append(" <b>").append(Globals.getGameModeAltHPAbbrev()).append("</b>: ").append(this.pc.altHP());
            }
            statBuf.append("<br>");
            statBuf.append("<b>").append(PropertyFactory.getString("in_sumSaves")).append("</b>: ");
            for (int z = 0; z < SettingsHandler.getGame().getUnmodifiableCheckList().size(); ++z) {
                bonus = (int)this.pc.getBonus(z + 1, true);
                statBuf.append(" <i>").append(SettingsHandler.getGame().getUnmodifiableCheckList().get(z).toString()).append("</i>: ").append(Delta.toString(bonus));
            }
            statBuf.append("<br><b>").append(PropertyFactory.getString("in_sumSize")).append("</b>: ").append(this.pc.getSize());
        }
        statBuf.append("</html>");
        this.statPane.setText(statBuf.toString());
    }

    private void addClass(PCClass theClass, int levels) {
        if (Globals.getGameModeAlignmentText().length() != 0 && levels > 0 && this.pc.getAlignment() == SettingsHandler.getGame().getIndexOfAlignment("None")) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_sumYouMustSelectAnAlignmentBeforeAddingClasses"), "PCGen", MessageType.ERROR);
            return;
        }
        if (theClass == null || !theClass.isQualified(this.pc)) {
            return;
        }
        PCClass aClass = this.pc.getClassNamed(theClass.getName());
        if (!Globals.checkRule("LEVELCAP") && (levels > theClass.getMaxLevel() || aClass != null && aClass.getLevel() + levels > aClass.getMaxLevel())) {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_sumMaximumLevelIs") + theClass.getMaxLevel(), "PCGen", MessageType.INFORMATION);
            return;
        }
        if (this.pc.getTotalLevels() == 0 && levels > 0) {
            if (SettingsHandler.isPurchaseStatMode() && SettingsHandler.getPurchaseModeMethodPool() > InfoSummary.getUsedStatPool(this.pc)) {
                int proceed = JOptionPane.showConfirmDialog(this, PropertyFactory.getString("in_sumPoolWarning"), PropertyFactory.getString("in_sumLevelWarnTitle"), 0, 2);
                if (proceed != 0) {
                    return;
                }
            } else if (SettingsHandler.isShowWarningAtFirstLevelUp()) {
                final JCheckBox shouldDisplay = new JCheckBox(PropertyFactory.getString("in_sumAbilitiesWarningCheckBox"), true);
                shouldDisplay.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent evt) {
                        SettingsHandler.setShowWarningAtFirstLevelUp(shouldDisplay.isSelected());
                    }
                });
                JPanel msgPanel = InfoSummary.buildMessageLabelPanel(PropertyFactory.getString("in_sumAbilitiesWarning"), shouldDisplay);
                int proceed = JOptionPane.showConfirmDialog(this, msgPanel, PropertyFactory.getString("in_sumLevelWarnTitle"), 0, 2);
                if (proceed != 0) {
                    return;
                }
            }
        }
        this.pc.incrementClassLevel(levels, theClass);
        PCGen_Frame1.forceUpdate_PlayerTabs();
        CharacterInfo pane = PCGen_Frame1.getCharacterPane();
        pane.setPaneForUpdate(pane.infoClasses());
        pane.setPaneForUpdate(pane.infoSkills());
        pane.setPaneForUpdate(pane.infoFeats());
        pane.setPaneForUpdate(pane.infoDomain());
        pane.setPaneForUpdate(pane.infoSpells());
        pane.setPaneForUpdate(pane.infoInventory());
        pane.refresh();
        this.infoAbilities.refresh();
        this.statTable.invalidate();
        this.statTable.updateUI();
        this.setStatLabelText();
        if (levels > 0 && Globals.checkRule("FREECLOTHES") && this.pc.totalNonMonsterLevels() == 1) {
            List clothes = EquipmentList.getEquipmentOfType(this.pc.getEquipmentList(), "Clothing.Resizable", "Magic");
            boolean hasClothes = false;
            String pcSize = this.pc.getSize();
            if (clothes.size() != 0) {
                Iterator e = clothes.iterator();
                while (e.hasNext()) {
                    Equipment eq = (Equipment)e.next();
                    if (!CoreUtility.doublesEqual(eq.getCost(this.pc).doubleValue(), 0.0) || !pcSize.equals(eq.getSize())) continue;
                    hasClothes = true;
                    break;
                }
            }
            if (!hasClothes) {
                String aString;
                Equipment eq;
                clothes = EquipmentList.getEquipmentOfType(EquipmentList.getEquipmentList(), "Clothing.Resizable", "Magic.Custom.Auto_Gen");
                ArrayList selectedClothes = new ArrayList();
                Globals.chooseFromList(PropertyFactory.getString("in_sumSelectAFreeSetOfClothing"), clothes, selectedClothes, 1);
                if (selectedClothes.size() != 0 && (eq = EquipmentList.getEquipmentNamed(aString = (String)selectedClothes.get(0))) != null) {
                    eq = (Equipment)eq.clone();
                    eq.setQty(new Float(1.0f));
                    if (!pcSize.equals(eq.getSize())) {
                        eq.resizeItem(this.pc, pcSize);
                    }
                    eq.setCostMod('-' + eq.getCost(this.pc).toString());
                    if (this.pc.getEquipmentNamed(eq.nameItemFromModifiers(this.pc)) == null) {
                        this.pc.addEquipment(eq);
                    } else {
                        Logging.errorPrint("Cannot add duplicate equipment to PC");
                    }
                }
            }
        }
        this.forceRefresh();
    }

    public static JPanel buildMessageLabelPanel(String message, JCheckBox checkbox) {
        JLabel label;
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = 0;
        cons.gridx = 0;
        cons.gridwidth = 0;
        cons.gridheight = 1;
        cons.anchor = 17;
        cons.insets = new Insets(0, 0, 3, 0);
        cons.weightx = 1.0;
        cons.weighty = 0.0;
        cons.fill = 0;
        int start = 0;
        int sepPos = -1;
        do {
            String part;
            if ((sepPos = message.indexOf("\n", start)) >= 0) {
                part = message.substring(start, sepPos);
                start = sepPos + 1;
            } else {
                part = message.substring(start);
                start = -1;
            }
            label = new JLabel(part, 10);
            panel.add((Component)label, cons);
            ++cons.gridy;
        } while (start >= 0);
        if (checkbox != null) {
            label = new JLabel("", 10);
            panel.add((Component)label, cons);
            ++cons.gridy;
            panel.add((Component)checkbox, cons);
            ++cons.gridy;
        }
        return panel;
    }

    private void alignmentChanged() {
        PCClass aClass;
        int oldAlignment;
        int newAlignment = this.alignmentComboBox.getSelectedIndex();
        if (newAlignment == (oldAlignment = this.pc.getAlignment())) {
            return;
        }
        StringBuffer unqualified = new StringBuffer();
        ArrayList classList = this.pc.getClassList();
        ArrayList<PCClass> exclassList = new ArrayList<PCClass>();
        Iterator e = classList.iterator();
        while (e.hasNext()) {
            aClass = (PCClass)e.next();
            this.pc.setAlignment(oldAlignment, false, true);
            if (!aClass.isQualified(this.pc)) continue;
            this.pc.setAlignment(newAlignment, false, true);
            if (aClass.isQualified(this.pc) || aClass.getExClass().length() == 0) continue;
            if (unqualified.length() > 0) {
                unqualified.append(", ");
            }
            unqualified.append(aClass.getName());
            exclassList.add(aClass);
        }
        if (unqualified.length() > 0 && JOptionPane.showConfirmDialog(null, PropertyFactory.getString("in_sumExClassesWarning") + Constants.s_LINE_SEP + unqualified, "PCGen", 2, 3) == 2) {
            this.pc.setAlignment(oldAlignment, false, true);
            this.alignmentComboBox.setSelectedIndex(oldAlignment);
            return;
        }
        e = exclassList.iterator();
        while (e.hasNext()) {
            aClass = (PCClass)e.next();
            this.pc.makeIntoExClass(aClass);
        }
        this.pc.setAlignment(newAlignment, false, true);
        this.forceRefresh();
        this.enableControls(newAlignment != SettingsHandler.getGame().getIndexOfAlignment("None"));
    }

    private void createClassComboModel() {
        if (this.classComboModel == null) {
            this.classComboModel = new ClassComboModel();
        } else {
            this.classComboModel.updateModel();
        }
    }

    private void createClassTreeModel() {
        if (this.pcClassTreeModel == null) {
            this.pcClassTreeModel = new ClassModel();
        } else {
            this.pcClassTreeModel.resetModel();
        }
    }

    private void createModels() {
        this.createClassTreeModel();
        this.createRaceComboModel();
        this.createClassComboModel();
    }

    private void createRaceComboModel() {
        if (this.raceComboModel == null) {
            this.raceComboModel = new RaceComboModel();
        } else {
            this.raceComboModel.updateModel();
        }
    }

    private void createTreeTables() {
        this.pcClassTable = new JTableEx(new TableSorter(this.pcClassTreeModel));
        this.pcClassTable.setSelectionMode(0);
        this.pcClassTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                String aString = InfoSummary.this.pc.getLevelInfoClassKeyName(InfoSummary.this.pcClassTable.getSelectedRow());
                PCClass aClass = Globals.getClassKeyed(aString);
                if (aClass != null) {
                    InfoSummary.this.classComboBox.setSelectedItem(aClass);
                }
            }
        });
    }

    private void enableControls(boolean enable) {
        this.raceComboBox.setEnabled(enable);
        this.classComboBox.setEnabled(enable);
        this.levelText.setEnabled(enable);
        this.lvlUpButton.setEnabled(enable);
        this.lvlDownButton.setEnabled(enable);
    }

    private void formComponentHidden() {
        this.updateRace();
    }

    private void formComponentShown() {
        this.requestFocus();
        PCGen_Frame1.getStatusBar().setText("");
        this.refresh();
    }

    private void initComponents() {
        this.readyForRefresh = true;
        JScrollPane statScrollPane = new JScrollPane();
        this.statTable = new JTableEx();
        this.statTable.setModel(this.statTableModel);
        this.statTable.setSelectionMode(0);
        this.statTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                InfoSummary.this.statTableMouseClicked(evt);
            }
        });
        TableColumn col = this.statTable.getColumnModel().getColumn(0);
        int width = Globals.getCustColumnWidth("AbilitiesS", 0);
        if (width == 0) {
            col.setPreferredWidth(40);
        } else {
            col.setPreferredWidth(width);
        }
        col.addPropertyChangeListener(new ResizeColumnListener(this.statTable, "AbilitiesS", 0));
        this.statTable.setColAlign(0, 2);
        col = this.statTable.getColumnModel().getColumn(1);
        width = Globals.getCustColumnWidth("AbilitiesS", 1);
        if (width == 0) {
            col.setPreferredWidth(30);
        } else {
            col.setPreferredWidth(width);
        }
        JFormattedTextField field = new JFormattedTextField(new RegexFormatter("\\d{1,4}|\\*"));
        field.setHorizontalAlignment(0);
        col.setCellEditor(new FormattedCellEditor(field));
        col.addPropertyChangeListener(new ResizeColumnListener(this.statTable, "AbilitiesS", 1));
        this.statTable.setColAlign(1, 0);
        col = this.statTable.getColumnModel().getColumn(2);
        width = Globals.getCustColumnWidth("AbilitiesS", 2);
        if (width == 0) {
            col.setPreferredWidth(20);
        } else {
            col.setPreferredWidth(width);
        }
        col.addPropertyChangeListener(new ResizeColumnListener(this.statTable, "AbilitiesS", 2));
        this.statTable.setColAlign(2, 0);
        col = this.statTable.getColumnModel().getColumn(3);
        width = Globals.getCustColumnWidth("AbilitiesS", 3);
        if (width == 0) {
            col.setPreferredWidth(20);
        } else {
            col.setPreferredWidth(width);
        }
        col.addPropertyChangeListener(new ResizeColumnListener(this.statTable, "AbilitiesS", 3));
        this.statTable.setColAlign(3, 0);
        col = this.statTable.getColumnModel().getColumn(4);
        width = Globals.getCustColumnWidth("AbilitiesS", 4);
        if (width == 0) {
            col.setPreferredWidth(20);
        } else {
            col.setPreferredWidth(width);
        }
        col.addPropertyChangeListener(new ResizeColumnListener(this.statTable, "AbilitiesS", 4));
        this.statTable.setColAlign(4, 0);
        col = this.statTable.getColumnModel().getColumn(5);
        width = Globals.getCustColumnWidth("AbilitiesS", 5);
        if (width == 0) {
            col.setPreferredWidth(20);
        } else {
            col.setPreferredWidth(width);
        }
        col.addPropertyChangeListener(new ResizeColumnListener(this.statTable, "AbilitiesS", 5));
        this.statTable.setColAlign(5, 0);
        col = this.statTable.getColumnModel().getColumn(6);
        col.setCellRenderer(this.plusMinusRenderer);
        col.setMaxWidth(30);
        col.setMinWidth(30);
        col = this.statTable.getColumnModel().getColumn(7);
        col.setCellRenderer(this.plusMinusRenderer);
        col.setMaxWidth(30);
        col.setMinWidth(30);
        statScrollPane.setViewportView(this.statTable);
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.northPanel.setLayout(gridbag);
        c.insets = new Insets(2, 2, 2, 2);
        this.createModels();
        this.createTreeTables();
        Utility.buildConstraints(c, 0, 0, 1, 1, 0.0, 0.0);
        c.fill = 0;
        c.anchor = 13;
        this.labelName = new JLabel(PropertyFactory.getString("in_sumCharString") + ": ");
        gridbag.setConstraints(this.labelName, c);
        this.northPanel.add(this.labelName);
        Utility.buildConstraints(c, 1, 0, 1, 1, 3.0, 0.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.pcNameText, c);
        this.northPanel.add(this.pcNameText);
        Utility.buildConstraints(c, 1, 1, 1, 1, 0.0, 0.0);
        c.fill = 0;
        c.anchor = 17;
        this.randName = new JButton(PropertyFactory.getString("in_sumRandomNameString"));
        gridbag.setConstraints(this.randName, c);
        this.northPanel.add(this.randName);
        Utility.setDescription(this.randName, PropertyFactory.getString("in_randNameTipString"));
        Utility.buildConstraints(c, 0, 2, 1, 1, 0.0, 0.0);
        c.fill = 0;
        c.anchor = 13;
        JLabel tabLabel = new JLabel(PropertyFactory.getString("in_tabString") + ": ");
        gridbag.setConstraints(tabLabel, c);
        this.northPanel.add(tabLabel);
        Utility.buildConstraints(c, 1, 2, 1, 1, 0.0, 0.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.tabNameText, c);
        this.northPanel.add(this.tabNameText);
        this.tabNameText.addFocusListener(this.tabNameAdapter);
        Utility.buildConstraints(c, 0, 3, 1, 1, 0.0, 0.0);
        c.fill = 0;
        c.anchor = 13;
        JLabel label = new JLabel(PropertyFactory.getString("in_sumPlayerString") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 1, 3, 1, 1, 0.0, 0.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.playerNameText, c);
        this.northPanel.add(this.playerNameText);
        this.playerNameText.addFocusListener(this.playerNameAdapter);
        Utility.buildConstraints(c, 3, 0, 1, 1, 0.0, 0.0);
        c.fill = 0;
        c.anchor = 13;
        this.labelAlignment = new JLabel(PropertyFactory.getString("in_alignString") + ": ");
        gridbag.setConstraints(this.labelAlignment, c);
        this.northPanel.add(this.labelAlignment);
        Utility.buildConstraints(c, 4, 0, 1, 1, 2.0, 0.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.alignmentComboBox, c);
        this.northPanel.add(this.alignmentComboBox);
        this.alignmentComboBox.setModel(new DefaultComboBoxModel<String>(this.populateAlignmentStrings()));
        Utility.buildConstraints(c, 3, 1, 1, 1, 0.0, 0.0);
        c.fill = 0;
        c.anchor = 13;
        this.labelRace = new JLabel(PropertyFactory.getString("in_raceString") + ": ");
        gridbag.setConstraints(this.labelRace, c);
        this.northPanel.add(this.labelRace);
        Utility.buildConstraints(c, 4, 1, 1, 1, 0.0, 0.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.raceComboBox, c);
        this.northPanel.add(this.raceComboBox);
        this.raceComboModel = new RaceComboModel();
        this.raceComboBox.setModel(this.raceComboModel);
        Utility.buildConstraints(c, 3, 2, 1, 1, 0.0, 0.0);
        c.fill = 0;
        c.anchor = 13;
        this.labelClass = new JLabel(PropertyFactory.getString("in_classString") + ": ");
        gridbag.setConstraints(this.labelClass, c);
        this.northPanel.add(this.labelClass);
        Utility.buildConstraints(c, 4, 2, 1, 1, 0.0, 0.0);
        c.fill = 2;
        c.anchor = 17;
        gridbag.setConstraints(this.classComboBox, c);
        this.northPanel.add(this.classComboBox);
        this.classComboModel = new ClassComboModel();
        this.classComboBox.setModel(this.classComboModel);
        Utility.buildConstraints(c, 3, 3, 1, 1, 0.0, 0.0);
        c.fill = 0;
        c.anchor = 13;
        label = new JLabel(PropertyFactory.getString("in_levelString") + ": ");
        gridbag.setConstraints(label, c);
        this.northPanel.add(label);
        Utility.buildConstraints(c, 4, 3, 1, 1, 0.0, 0.0);
        c.fill = 2;
        c.anchor = 17;
        Utility.setDescription(this.lvlDownButton, PropertyFactory.getString("in_levelDownButtonTooltip"));
        Utility.setDescription(this.lvlUpButton, PropertyFactory.getString("in_levelUpButtonTooltip"));
        Utility.setDescription(this.levelText, PropertyFactory.getString("in_levelTextTooltip"));
        this.levelPanel.setLayout(new FlowLayout(0));
        this.levelPanel.add(this.levelText);
        this.levelPanel.add(this.lvlUpButton);
        this.levelPanel.add(this.lvlDownButton);
        gridbag.setConstraints(this.levelPanel, c);
        this.northPanel.add(this.levelPanel);
        Utility.buildConstraints(c, 0, 4, 1, 1, 0.0, 0.0);
        this.lblMonsterlHD.setText(PropertyFactory.getString("in_sumMonsterHitDice"));
        c.anchor = 13;
        this.northPanel.add((Component)this.lblMonsterlHD, c);
        Utility.buildConstraints(c, 1, 4, 1, 1, 0.0, 0.0);
        this.txtMonsterlHD.setText("0");
        c.fill = 2;
        c.anchor = 17;
        this.northPanel.add((Component)this.txtMonsterlHD, c);
        Utility.buildConstraints(c, 3, 4, 1, 1, 0.0, 0.0);
        this.lblHDModify.setText(PropertyFactory.getString("in_sumHDToAddRem"));
        c.anchor = 13;
        this.northPanel.add((Component)this.lblHDModify, c);
        this.pnlHD.setLayout(new FlowLayout(0));
        this.pnlHD.add(this.txtHD);
        this.pnlHD.add(this.btnAddHD);
        this.pnlHD.add(this.btnRemoveHD);
        Utility.buildConstraints(c, 4, 4, 1, 1, 0.0, 0.0);
        c.fill = 2;
        c.anchor = 17;
        this.northPanel.add((Component)this.pnlHD, c);
        this.btnAddHD.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfoSummary.this.addMonsterHD(1);
            }
        });
        this.btnRemoveHD.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                InfoSummary.this.addMonsterHD(-1);
            }
        });
        Utility.buildConstraints(c, 0, 5, 5, 2, 0.0, 18.0);
        c.fill = 1;
        c.anchor = 17;
        JPanel statPanel = new JPanel();
        statPanel.setLayout(new BorderLayout());
        statPanel.add((Component)statScrollPane, "Center");
        this.poolPanel.add(this.poolLabel);
        this.poolText.setPreferredSize(new Dimension(60, 20));
        this.poolPanel.add(this.poolText);
        this.jButtonHP.setText(Globals.getGameModeHPAbbrev());
        this.jButtonHP.setAlignmentY(0.0f);
        this.jButtonHP.setHorizontalAlignment(2);
        this.jButtonHP.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                pcGenGUI.showHpFrame(InfoSummary.this.pc);
            }
        });
        this.poolPanel.add(this.jButtonHP);
        this.labelHP.setText("");
        this.labelHP.setHorizontalAlignment(11);
        this.poolPanel.add(this.labelHP);
        statPanel.add((Component)this.poolPanel, "South");
        gridbag.setConstraints(statPanel, c);
        this.northPanel.add(statPanel);
        this.tipsPane.setBackground(this.northPanel.getBackground());
        this.tipsPane.setContentType("text/html");
        StringBuffer tipsText = new StringBuffer("<html><body><UL>");
        int tipNum = 1;
        String tipName = "in_summaryTip" + String.valueOf(tipNum);
        String tip = PropertyFactory.getString(tipName);
        while (tip != null && !tip.equals(tipName + " not defined.")) {
            tipsText.append("<LI>").append(tip);
            tipName = "in_summaryTip" + String.valueOf(++tipNum);
            tip = PropertyFactory.getString(tipName);
        }
        tipsText.append("</UL></body></html>");
        this.tipsPane.setText(tipsText.toString());
        this.tipsPane.setEditable(false);
        JScrollPane scroll = new JScrollPane();
        scroll.setVerticalScrollBarPolicy(20);
        scroll.setHorizontalScrollBarPolicy(30);
        scroll.setViewportView(this.tipsPane);
        scroll.getViewport().setScrollMode(1);
        scroll.setBackground(new Color(255, 255, 255));
        JPanel pane1 = new JPanel();
        pane1.add(scroll);
        TitledBorder title1 = BorderFactory.createTitledBorder(this.etched, PropertyFactory.getString("in_tipsString"));
        title1.setTitleJustification(2);
        pane1.setBorder(title1);
        pane1.setLayout(new BoxLayout(pane1, 1));
        Utility.buildConstraints(c, 0, 7, 5, 1, 0.0, 18.0);
        c.fill = 1;
        c.anchor = 10;
        gridbag.setConstraints(pane1, c);
        this.northPanel.add(pane1);
        this.infoPane.setBackground(this.northPanel.getBackground());
        this.infoPane.setContentType("text/html");
        this.infoPane.setText("");
        this.infoPane.setEditable(false);
        JScrollPane scrol2 = new JScrollPane();
        scrol2.setVerticalScrollBarPolicy(20);
        scrol2.setHorizontalScrollBarPolicy(30);
        scrol2.setViewportView(this.infoPane);
        scrol2.getViewport().setScrollMode(1);
        scrol2.setBackground(this.northPanel.getBackground());
        Utility.setDescription(this.infoPane, PropertyFactory.getString("in_sumAny_requirements_you_don__t_meet_are_in_italics._137"));
        JPanel pane2 = new JPanel();
        pane2.add(scrol2);
        TitledBorder title2 = BorderFactory.createTitledBorder(this.etched, PropertyFactory.getString("in_infoString"));
        title2.setTitleJustification(2);
        pane2.setBorder(title2);
        pane2.setLayout(new BoxLayout(pane2, 0));
        Utility.buildConstraints(c, 5, 0, 1, 5, 9.0, 0.0);
        c.fill = 1;
        c.anchor = 10;
        gridbag.setConstraints(pane2, c);
        this.northPanel.add(pane2);
        col = this.pcClassTable.getColumnModel().getColumn(0);
        col.setPreferredWidth(15);
        this.pcClassTable.setColAlign(0, 0);
        Utility.buildConstraints(c, 5, 5, 1, 1, 0.0, 18.0);
        c.fill = 1;
        c.anchor = 10;
        JScrollPane scrollPane = new JScrollPane(this.pcClassTable);
        JPanel pane3 = new JPanel();
        pane3.add(scrollPane);
        TitledBorder title3 = BorderFactory.createTitledBorder(this.etched, PropertyFactory.getString("in_classesString"));
        title3.setTitleJustification(2);
        pane3.setBorder(title3);
        pane3.setLayout(new BoxLayout(pane3, 0));
        gridbag.setConstraints(pane3, c);
        this.northPanel.add(pane3);
        if (!SettingsHandler.isAbilitiesShownAsATab()) {
            Utility.buildConstraints(c, 5, 6, 1, 1, 0.0, 0.0);
            c.fill = 0;
            c.anchor = 10;
            this.abilitiesButton = new JButton(PropertyFactory.getString("in_abilities"));
            gridbag.setConstraints(this.abilitiesButton, c);
            this.northPanel.add(this.abilitiesButton);
            this.abilitiesFrame.getContentPane().setLayout(new BorderLayout());
            this.abilitiesFrame.getContentPane().add((Component)this.infoAbilities, "Center");
            JPanel cPanel = new JPanel();
            cPanel.setLayout(new FlowLayout());
            JButton closeButton = new JButton(PropertyFactory.getString("in_close"));
            closeButton.setMnemonic(PropertyFactory.getMnemonic("in_mn_close"));
            closeButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent evt) {
                    InfoSummary.this.abilitiesFrame.setVisible(false);
                }
            });
            cPanel.add(closeButton);
            this.abilitiesFrame.getContentPane().add((Component)cPanel, "South");
            ClassLoader loader = this.getClass().getClassLoader();
            Toolkit kit = Toolkit.getDefaultToolkit();
            Image img = kit.getImage(loader.getResource("pcgen/gui/resource/PcgenIcon.gif"));
            loader = null;
            this.abilitiesFrame.setIconImage(img);
        }
        this.statPane.setBackground(this.northPanel.getBackground());
        this.statPane.setContentType("text/html");
        this.statPane.setText("");
        this.statPane.setEditable(false);
        JScrollPane statsScroll = new JScrollPane();
        statsScroll.setVerticalScrollBarPolicy(20);
        statsScroll.setHorizontalScrollBarPolicy(30);
        statsScroll.setViewportView(this.statPane);
        statsScroll.getViewport().setScrollMode(1);
        statsScroll.setBackground(new Color(255, 255, 255));
        JPanel pane4 = new JPanel();
        pane4.add(statsScroll);
        TitledBorder title4 = BorderFactory.createTitledBorder(this.etched, PropertyFactory.getString("in_statsString"));
        title4.setTitleJustification(2);
        pane4.setBorder(title4);
        pane4.setLayout(new BoxLayout(pane4, 1));
        Utility.buildConstraints(c, 5, 7, 1, 1, 0.0, 0.0);
        c.fill = 1;
        c.anchor = 10;
        gridbag.setConstraints(pane4, c);
        this.northPanel.add(pane4);
        this.setLayout(new BorderLayout());
        this.add((Component)this.northPanel, "Center");
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                InfoSummary.this.formComponentShown();
            }

            public void componentHidden(ComponentEvent evt) {
                InfoSummary.this.formComponentHidden();
            }
        });
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                InfoSummary.this.refresh();
            }
        });
    }

    private String[] populateAlignmentStrings() {
        this.alignmentStrings = SettingsHandler.getGame().getAlignmentListStrings(true);
        return this.alignmentStrings;
    }

    private synchronized void refreshDisplay() {
        int align;
        if (this.pc == null) {
            return;
        }
        this.stopListeners();
        this.pcNameText.setText(this.pc.getName());
        this.tabNameText.setText(this.pc.getTabName());
        this.playerNameText.setText(this.pc.getPlayersName());
        boolean rebuild = false;
        if (this.alignmentStrings.length != SettingsHandler.getGame().getUnmodifiableAlignmentList().size()) {
            rebuild = true;
        } else {
            String[] al = SettingsHandler.getGame().getAlignmentListStrings(true);
            for (int i = 0; i < Math.min(this.alignmentStrings.length, al.length); ++i) {
                if (this.alignmentStrings[i].equals(al[i])) continue;
                rebuild = true;
            }
        }
        if (rebuild) {
            this.alignmentComboBox.setModel(new DefaultComboBoxModel<String>(this.populateAlignmentStrings()));
        }
        if ((align = this.pc.getAlignment()) > -1 && align < this.alignmentStrings.length) {
            this.alignmentComboBox.setSelectedIndex(align);
        }
        Race pcRace = this.pc.getRace();
        this.raceComboModel.setSelectedItem(pcRace);
        if (PrereqHandler.passesAll(pcRace.getPreReqList(), this.pc, pcRace)) {
            this.labelRace.setForeground(new Color(SettingsHandler.getPrereqQualifyColor()));
        } else {
            this.labelRace.setForeground(new Color(SettingsHandler.getPrereqFailColor()));
        }
        this.setInfoLabelText(pcRace);
        this.labelClass.setForeground(Color.black);
        if (this.pc.getTotalLevels() == 0) {
            this.classComboBox.setSelectedItem(null);
        } else if (this.pc.getLevelInfoSize() != 0) {
            Object lastSelection = this.classComboBox.getSelectedItem();
            for (int idx = this.pc.getLevelInfoSize() - 1; idx >= 0; --idx) {
                PCClass pcClass = this.pc.getClassKeyed(this.pc.getLevelInfoClassKeyName(idx));
                if (pcClass == null) continue;
                this.classComboBox.setSelectedItem(Globals.getClassKeyed(pcClass.getKeyName()));
                if (this.classComboBox.getSelectedIndex() >= 0) break;
            }
            if (this.classComboBox.getSelectedIndex() < 0 && lastSelection != null) {
                this.classComboBox.setSelectedItem(lastSelection);
            }
        } else if (this.pc.getRace().getMonsterClass(this.pc, false) != null) {
            String monsterClass = this.pc.getRace().getMonsterClass(this.pc, false);
            this.classComboBox.setSelectedItem(Globals.getClassKeyed(monsterClass));
        } else {
            ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_sumClassKindErrMsg"), "PCGen", MessageType.ERROR);
        }
        PCClass pcSelectedClass = (PCClass)this.classComboBox.getSelectedItem();
        if (pcSelectedClass != null && !pcSelectedClass.isQualified(this.pc)) {
            this.labelClass.setForeground(new Color(SettingsHandler.getPrereqFailColor()));
        }
        this.createModels();
        this.statTableModel.fireTableDataChanged();
        this.statTable.invalidate();
        this.statTable.updateUI();
        try {
            this.pcClassTable.updateUI();
        }
        catch (Exception e) {
            // empty catch block
        }
        this.updatePool(false);
        this.setStatLabelText();
        this.enableControls(!this.alignmentComboBox.isVisible() || align != SettingsHandler.getGame().getIndexOfAlignment("None"));
        this.startListeners();
    }

    private void startListeners() {
        this.pcNameText.addFocusListener(this.pcNameAdapter);
        this.randName.addActionListener(this.randNameListener);
        this.alignmentComboBox.addActionListener(this.alignmentListener);
        this.raceComboBox.addActionListener(this.raceListener);
        this.raceComboBox.addFocusListener(this.raceFocusListener);
        this.classComboBox.addActionListener(this.classListener);
        this.classComboBox.addFocusListener(this.nonRaceFocusListener);
        this.tabNameText.addFocusListener(this.tabNameAdapter);
        this.playerNameText.addFocusListener(this.playerNameAdapter);
        this.levelText.addFocusListener(this.nonRaceFocusListener);
        this.lvlDownButton.addActionListener(this.levelCmdListener);
        this.lvlDownButton.addFocusListener(this.nonRaceFocusListener);
        this.lvlUpButton.addActionListener(this.levelCmdListener);
        this.lvlUpButton.addFocusListener(this.nonRaceFocusListener);
        this.statTable.addFocusListener(this.nonRaceFocusListener);
        if (!SettingsHandler.isAbilitiesShownAsATab() && this.abilitiesButton != null) {
            this.abilitiesButton.addActionListener(this.abilitiesListener);
        }
    }

    private void statTableMouseClicked(MouseEvent evt) {
        int selectedStat = this.statTable.getSelectedRow();
        if (selectedStat < 0 || selectedStat >= SettingsHandler.getGame().s_ATTRIBSHORT.length) {
            return;
        }
        int stat = this.pc.getStatList().getBaseStatFor(SettingsHandler.getGame().s_ATTRIBSHORT[selectedStat]);
        boolean makeChange = false;
        boolean checkPurchase = false;
        int increment = 0;
        PCStat aStat = (PCStat)this.pc.getStatList().getStats().get(selectedStat);
        int column = this.statTable.columnAtPoint(evt.getPoint());
        switch (column) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                increment = 1;
                int pcTotalLevels = this.pc.getTotalLevels();
                int pcPlayerLevels = this.pc.getTotalPlayerLevels();
                boolean isPurchaseMode = SettingsHandler.isPurchaseStatMode();
                if (this.pc.isNonAbility(selectedStat)) {
                    if (SettingsHandler.isExpertGUI()) break;
                    ShowMessageDelegate.showMessageDialog(NONABILITY, "PCGen", MessageType.ERROR);
                    break;
                }
                if (stat >= aStat.getMaxValue()) {
                    if (SettingsHandler.isExpertGUI()) break;
                    ShowMessageDelegate.showMessageDialog(STAT_UPPER_LIMIT + Integer.toString(aStat.getMaxValue()), "PCGen", MessageType.ERROR);
                    break;
                }
                if (pcPlayerLevels < 2 && stat >= SettingsHandler.getPurchaseScoreMax() && isPurchaseMode) {
                    if (SettingsHandler.isExpertGUI()) break;
                    ShowMessageDelegate.showMessageDialog(STAT_UPPER_LIMIT + SettingsHandler.getPurchaseScoreMax() + IN_PURCHASE_MODE, "PCGen", MessageType.ERROR);
                    break;
                }
                makeChange = true;
                if (isPurchaseMode && pcTotalLevels == 0) {
                    checkPurchase = true;
                    break;
                }
                if (isPurchaseMode && pcTotalLevels <= 0) break;
                this.pc.setPoolAmount(Math.max(this.pc.getPoolAmount() - 1, 0));
                break;
            }
            case 7: {
                increment = -1;
                int minPurchaseScore = SettingsHandler.getPurchaseScoreMin();
                int pcTotalLevels = this.pc.getTotalLevels();
                int pcPlayerLevels = this.pc.getTotalPlayerLevels();
                boolean isPurchaseMode = SettingsHandler.isPurchaseStatMode();
                if (stat <= aStat.getMinValue()) {
                    if (SettingsHandler.isExpertGUI()) break;
                    ShowMessageDelegate.showMessageDialog(STAT_LOWER_LIMIT + Integer.toString(aStat.getMinValue()), "PCGen", MessageType.ERROR);
                    break;
                }
                if (this.pc.isNonAbility(selectedStat)) {
                    if (SettingsHandler.isExpertGUI()) break;
                    ShowMessageDelegate.showMessageDialog(NONABILITY, "PCGen", MessageType.ERROR);
                    break;
                }
                if (pcPlayerLevels < 2 && stat <= minPurchaseScore && isPurchaseMode) {
                    if (SettingsHandler.isExpertGUI()) break;
                    ShowMessageDelegate.showMessageDialog(STAT_LOWER_LIMIT + minPurchaseScore + IN_PURCHASE_MODE, "PCGen", MessageType.ERROR);
                    break;
                }
                makeChange = true;
                if (isPurchaseMode && pcTotalLevels <= 0) break;
                this.pc.setPoolAmount(this.pc.getPoolAmount() + 1);
                break;
            }
            default: {
                Logging.errorPrint("In InfoSummary.statTableMouseClicked the column " + column + " is not handled.");
            }
        }
        if (makeChange) {
            int preIncHpMod = (int)this.pc.getStatBonusTo("HP", "BONUS");
            aStat.setBaseScore(stat + increment);
            this.pc.saveStatIncrease(aStat.getAbb(), increment, false);
            this.updatePool(increment > 0);
            this.statTableModel.fireTableRowsUpdated(selectedStat, selectedStat);
            this.pc.calcActiveBonuses();
            this.setStatLabelText();
            PCGen_Frame1 rootFrame = PCGen_Frame1.getInst();
            if ((int)this.pc.getStatBonusTo("HP", "BONUS") != preIncHpMod) {
                rootFrame.hpTotal_Changed();
            }
            CharacterInfo pane = PCGen_Frame1.getCharacterPane();
            pane.setPaneForUpdate(pane.infoSkills());
            pane.setPaneForUpdate(pane.infoSpells());
            pane.refresh();
            this.setStatLabelText();
        }
    }

    private void stopListeners() {
        this.pcNameText.removeFocusListener(this.pcNameAdapter);
        this.randName.removeActionListener(this.randNameListener);
        this.alignmentComboBox.removeActionListener(this.alignmentListener);
        this.raceComboBox.removeActionListener(this.raceListener);
        this.raceComboBox.removeFocusListener(this.raceFocusListener);
        this.classComboBox.removeActionListener(this.classListener);
        this.classComboBox.removeFocusListener(this.nonRaceFocusListener);
        this.tabNameText.removeFocusListener(this.tabNameAdapter);
        this.playerNameText.removeFocusListener(this.playerNameAdapter);
        this.levelText.removeFocusListener(this.nonRaceFocusListener);
        this.lvlDownButton.removeActionListener(this.levelCmdListener);
        this.lvlDownButton.removeFocusListener(this.nonRaceFocusListener);
        this.lvlUpButton.removeActionListener(this.levelCmdListener);
        this.lvlUpButton.removeFocusListener(this.nonRaceFocusListener);
        this.statTable.removeFocusListener(this.nonRaceFocusListener);
        if (!SettingsHandler.isAbilitiesShownAsATab() && this.abilitiesButton != null) {
            this.abilitiesButton.removeActionListener(this.abilitiesListener);
        }
    }

    private void updateCharacterInfo() {
        this.lblMonsterlHD.setVisible(SettingsHandler.hideMonsterClasses());
        this.txtMonsterlHD.setVisible(SettingsHandler.hideMonsterClasses());
        this.lblHDModify.setVisible(SettingsHandler.hideMonsterClasses());
        this.pnlHD.setVisible(SettingsHandler.hideMonsterClasses());
        if (this.pc == null || !needsUpdate) {
            return;
        }
        this.infoAbilities.refresh();
        this.updateHP();
        if (Globals.getGameModeAlignmentText().length() == 0) {
            this.labelAlignment.setVisible(false);
            this.alignmentComboBox.setVisible(false);
        } else {
            this.labelAlignment.setVisible(true);
            this.alignmentComboBox.setVisible(true);
        }
        if (this.pnlHD.isVisible()) {
            this.updateHD();
            this.txtHD.setValue(1);
        }
        this.levelText.setValue(1);
        needsUpdate = false;
        this.refreshDisplay();
    }

    private void updateHD() {
        String monsterClass;
        int monsterHD = -1;
        int minLevel = 0;
        if (this.pc != null && (monsterClass = this.pc.getRace().getMonsterClass(this.pc, false)) != null) {
            monsterHD = this.pc.getRace().hitDice(this.pc);
            minLevel = this.pc.getRace().hitDice(this.pc) + this.pc.getRace().getMonsterClassLevels(this.pc);
            PCClass aClass = this.pc.getClassNamed(monsterClass);
            if (aClass != null) {
                monsterHD += aClass.getLevel();
            }
        }
        this.btnAddHD.setEnabled(this.pc.getRace().hasAdvancement() && monsterHD >= 0);
        this.btnRemoveHD.setEnabled(monsterHD > minLevel);
        if (monsterHD < 0) {
            monsterHD = 0;
        }
        this.txtMonsterlHD.setText(Integer.toString(monsterHD));
        this.txtHD.setEnabled(this.btnAddHD.isEnabled() | this.btnRemoveHD.isEnabled());
    }

    private void updatePool(boolean checkPurchasePoints) {
        int usedStatPool = InfoSummary.getUsedStatPool(this.pc);
        int pcPlayerLevels = this.pc.getTotalPlayerLevels();
        if (pcPlayerLevels < 2) {
            this.pc.setCostPool(usedStatPool);
            this.pc.setPoolAmount(usedStatPool);
        }
        if (SettingsHandler.isPurchaseStatMode()) {
            String bString = String.valueOf(this.pc.getCostPool());
            int availablePool = SettingsHandler.getPurchaseModeMethodPool();
            this.poolLabel.setText(PropertyFactory.getString("in_sumStatCost"));
            this.poolText.setText(bString + " / " + availablePool);
            if (checkPurchasePoints && pcPlayerLevels < 2 && availablePool > 0 && usedStatPool > availablePool) {
                ShowMessageDelegate.showMessageDialog(PropertyFactory.getString("in_sumYouHaveExcededTheMaximumPointsOf") + availablePool + PropertyFactory.getString("in_sumAsSpecifiedByTheMethod") + SettingsHandler.getPurchaseModeMethodName() + "\"", "PCGen", MessageType.INFORMATION);
            }
        } else {
            this.poolLabel.setText(PropertyFactory.getString("in_sumStatTotal"));
            int statTotal = 0;
            int modTotal = 0;
            StatList statList = this.pc.getStatList();
            for (int i = 0; i < SettingsHandler.getGame().s_ATTRIBLONG.length; ++i) {
                if (this.pc.isNonAbility(i) || !SettingsHandler.getGame().s_ATTRIBROLL[i]) continue;
                int currentStat = statList.getBaseStatFor(SettingsHandler.getGame().s_ATTRIBSHORT[i]);
                int currentMod = statList.getStatModFor(SettingsHandler.getGame().s_ATTRIBSHORT[i]);
                statTotal += currentStat;
                modTotal += currentMod;
            }
            this.poolLabel.setText(PropertyFactory.getString("in_sumStatTotal") + Integer.toString(statTotal) + PropertyFactory.getString("in_sumModifierTotal") + Integer.toString(modTotal));
            this.poolText.setText("");
        }
    }

    private void updateRace() {
        Race oldRace;
        Race r;
        if (this.raceComboBox.getSelectedItem() != null && !(r = (Race)this.raceComboBox.getSelectedItem()).equals(oldRace = this.pc.getRace())) {
            int numLevels;
            PCClass aClass;
            String monsterClass;
            if (this.pnlHD.isVisible() && (monsterClass = oldRace.getMonsterClass(this.pc, false)) != null && (aClass = this.pc.getClassNamed(monsterClass)) != null && (numLevels = aClass.getLevel() - oldRace.getMonsterClassLevels(this.pc)) > 0) {
                this.addClass(aClass, -numLevels);
            }
            this.pc.setRace(r);
            if (this.pnlHD.isVisible()) {
                this.updateHD();
            }
            PCGen_Frame1.forceUpdate_PlayerTabs();
            CharacterInfo pane = PCGen_Frame1.getCharacterPane();
            pane.setPaneForUpdate(pane.infoRace());
            pane.setPaneForUpdate(pane.infoFeats());
            pane.setPaneForUpdate(pane.infoSkills());
            pane.setPaneForUpdate(pane.infoSpells());
            this.infoAbilities.refresh();
            if (this.pc.getRace().hitDice(this.pc) != 0) {
                this.pc.getRace().rollHP(this.pc);
            }
            this.updateHP();
            this.refreshDisplay();
        }
    }

    static /* synthetic */ void access$1600(InfoSummary x0) {
        x0.updateRace();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class StatTableModel
    extends AbstractTableModel {
        private StatTableModel() {
        }

        public boolean isCellEditable(int row, int col) {
            return col == 1;
        }

        public Class getColumnClass(int columnIndex) {
            return this.getValueAt(0, columnIndex).getClass();
        }

        public int getColumnCount() {
            return 8;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return PropertyFactory.getString("in_sumStat");
                }
                case 1: {
                    return PropertyFactory.getString("in_sumScoreEditable");
                }
                case 2: {
                    return PropertyFactory.getString("in_sumRaceAdj");
                }
                case 3: {
                    return PropertyFactory.getString("in_sumOtherAdj");
                }
                case 4: {
                    return PropertyFactory.getString("in_sumTotal");
                }
                case 5: {
                    return PropertyFactory.getString("in_sumMod");
                }
                case 6: {
                    return "+";
                }
                case 7: {
                    return "-";
                }
            }
            return PropertyFactory.getString("in_sumOut_of_Bounds");
        }

        public int getRowCount() {
            if (InfoSummary.this.pc != null) {
                return SettingsHandler.getGame().s_ATTRIBLONG.length;
            }
            return 0;
        }

        public void setValueAt(Object obj, int rowIndex, int columnIndex) {
            if (rowIndex >= 0 && rowIndex < InfoSummary.this.pc.getStatList().getStats().size() && columnIndex == 1) {
                if (obj == null) {
                    return;
                }
                int statVal = !"*".equals(obj.toString()) ? Delta.parseInt(obj.toString()) : 10;
                int pcPlayerLevels = InfoSummary.this.pc.getTotalPlayerLevels();
                PCStat aStat = (PCStat)InfoSummary.this.pc.getStatList().getStats().get(rowIndex);
                if (InfoSummary.this.pc.isNonAbility(rowIndex)) {
                    ShowMessageDelegate.showMessageDialog(NONABILITY, "PCGen", MessageType.ERROR);
                    return;
                }
                if (statVal < aStat.getMinValue()) {
                    ShowMessageDelegate.showMessageDialog(STAT_LOWER_LIMIT + Integer.toString(aStat.getMinValue()), "PCGen", MessageType.ERROR);
                    return;
                }
                if (statVal > aStat.getMaxValue()) {
                    ShowMessageDelegate.showMessageDialog(STAT_UPPER_LIMIT + Integer.toString(aStat.getMaxValue()), "PCGen", MessageType.ERROR);
                    return;
                }
                if (pcPlayerLevels < 2 && SettingsHandler.isPurchaseStatMode()) {
                    int maxPurchaseScore = SettingsHandler.getPurchaseScoreMax();
                    if (statVal > maxPurchaseScore) {
                        ShowMessageDelegate.showMessageDialog(STAT_UPPER_LIMIT + maxPurchaseScore + IN_PURCHASE_MODE, "PCGen", MessageType.ERROR);
                        return;
                    }
                    int minPurchaseScore = SettingsHandler.getPurchaseModeBaseStatScore();
                    if (statVal < minPurchaseScore) {
                        ShowMessageDelegate.showMessageDialog(STAT_LOWER_LIMIT + minPurchaseScore + IN_PURCHASE_MODE, "PCGen", MessageType.ERROR);
                        return;
                    }
                }
                aStat.setBaseScore(statVal);
                InfoSummary.this.pc.saveStatIncrease(aStat.getAbb(), statVal - aStat.getBaseScore(), false);
                InfoSummary.this.setStatLabelText();
                InfoSummary.this.updatePool(true);
                if (rowIndex == 1) {
                    // empty if block
                }
            }
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                if (rowIndex >= 0 && rowIndex < SettingsHandler.getGame().s_ATTRIBLONG.length) {
                    return SettingsHandler.getGame().s_ATTRIBLONG[rowIndex];
                }
                return PropertyFactory.getString("in_sumOut_of_Bounds");
            }
            String aStat = SettingsHandler.getGame().s_ATTRIBSHORT[rowIndex];
            switch (columnIndex) {
                case 1: {
                    if (InfoSummary.this.pc.isNonAbility(rowIndex)) {
                        return "*";
                    }
                    return new Integer(InfoSummary.this.pc.getStatList().getBaseStatFor(aStat));
                }
                case 2: {
                    if (InfoSummary.this.pc.isNonAbility(rowIndex)) {
                        return "*";
                    }
                    int rBonus = (int)InfoSummary.this.pc.getRaceBonusTo("STAT", aStat);
                    return new Integer(rBonus);
                }
                case 3: {
                    if (InfoSummary.this.pc.isNonAbility(rowIndex)) {
                        return "*";
                    }
                    int iRace = (int)InfoSummary.this.pc.getRaceBonusTo("STAT", aStat);
                    return new Integer(InfoSummary.this.pc.getStatList().getTotalStatFor(aStat) - InfoSummary.this.pc.getStatList().getBaseStatFor(aStat) - iRace);
                }
                case 4: {
                    if (InfoSummary.this.pc.isNonAbility(rowIndex)) {
                        return "*";
                    }
                    return new Integer(InfoSummary.this.pc.getStatList().getTotalStatFor(aStat));
                }
                case 5: {
                    if (InfoSummary.this.pc.isNonAbility(rowIndex)) {
                        return new Integer(0);
                    }
                    return new Integer(InfoSummary.this.pc.getStatList().getStatModFor(aStat));
                }
                case 6: {
                    if (!SettingsHandler.getGame().s_ATTRIBROLL[rowIndex]) {
                        return null;
                    }
                    return "+";
                }
                case 7: {
                    if (!SettingsHandler.getGame().s_ATTRIBROLL[rowIndex]) {
                        return null;
                    }
                    return "-";
                }
            }
            return PropertyFactory.getString("in_sumOut_of_Bounds");
        }
    }

    private final class RendererEditor
    implements TableCellRenderer {
        private DefaultTableCellRenderer def = new DefaultTableCellRenderer();
        private JButton plusButton = new JButton("+");

        private RendererEditor() {
            this.def.setBackground(InfoSummary.this.getBackground());
            this.def.setAlignmentX(0.5f);
            this.def.setHorizontalAlignment(0);
            this.plusButton.setPreferredSize(new Dimension(30, 24));
            this.plusButton.setMinimumSize(new Dimension(30, 24));
            this.plusButton.setMaximumSize(new Dimension(30, 24));
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (column == 6) {
                this.def.setText("+");
                this.def.setBorder(BorderFactory.createEtchedBorder());
                return this.def;
            }
            if (column == 7) {
                this.def.setText("-");
                this.def.setBorder(BorderFactory.createEtchedBorder());
                return this.def;
            }
            return null;
        }
    }

    private final class RaceComboModel
    extends DefaultComboBoxModel {
        private RaceComboModel() {
            this.updateModel();
        }

        private void updateModel() {
            Object pcRace = this.getSelectedItem();
            this.removeAllElements();
            Iterator it = Globals.getRaceMap().values().iterator();
            while (it.hasNext()) {
                Race aRace = (Race)it.next();
                if (!InfoSummary.this.accept(InfoSummary.this.pc, aRace)) continue;
                this.addElement(aRace);
            }
            if (this.getIndexOf(Globals.s_EMPTYRACE) < 0) {
                this.insertElementAt(Globals.s_EMPTYRACE, 0);
            }
            if (pcRace != null && this.getIndexOf(pcRace) < 0) {
                this.insertElementAt(pcRace, 1);
            }
            this.setSelectedItem(pcRace);
        }
    }

    private final class ClassComboModel
    extends DefaultComboBoxModel {
        private ClassComboModel() {
            this.updateModel();
        }

        private void updateModel() {
            Object pcClass = this.getSelectedItem();
            this.removeAllElements();
            Iterator it = Globals.getClassList().iterator();
            while (it.hasNext()) {
                PCClass aClass = (PCClass)it.next();
                if (SettingsHandler.hideMonsterClasses() && aClass.isMonster() || !aClass.isVisible() || !InfoSummary.this.accept(InfoSummary.this.pc, aClass)) continue;
                this.addElement(aClass);
            }
            this.setSelectedItem(pcClass);
        }
    }

    private final class ClassModel
    extends AbstractTableModel {
        private ClassModel() {
        }

        public Class getColumnClass(int column) {
            return class$java$lang$String == null ? (class$java$lang$String = InfoSummary.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            return 3;
        }

        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return PropertyFactory.getString("in_sumLevel");
                }
                case 1: {
                    return PropertyFactory.getString("in_sumClassLvl");
                }
                case 2: {
                    return PropertyFactory.getString("in_sumSource");
                }
            }
            return PropertyFactory.getString("in_sumOut_of_Bounds");
        }

        public int getRowCount() {
            int iCount = 0;
            if (InfoSummary.this.pc != null) {
                for (int idx = 0; idx < InfoSummary.this.pc.getLevelInfoSize(); ++idx) {
                    PCClass aClass = InfoSummary.this.pc.getClassKeyed(InfoSummary.this.pc.getLevelInfoClassKeyName(idx));
                    if (aClass != null && !this.shouldDisplayThis(aClass)) continue;
                    ++iCount;
                }
            }
            return iCount;
        }

        public Object getValueAt(int rowIndex, int columnIndex) {
            String retStr = "";
            switch (columnIndex) {
                case 0: {
                    retStr = Integer.toString(rowIndex + 1);
                    break;
                }
                case 1: {
                    if (InfoSummary.this.pc == null) break;
                    PCClass aClass = null;
                    int lvl = 0;
                    for (int idx = 0; idx < InfoSummary.this.pc.getLevelInfoSize(); ++idx) {
                        String subClass;
                        String classKeyName = InfoSummary.this.pc.getLevelInfoClassKeyName(idx);
                        aClass = InfoSummary.this.pc.getClassKeyed(classKeyName);
                        if (aClass == null || !this.shouldDisplayThis(aClass) || rowIndex-- != 0) continue;
                        retStr = aClass.getName();
                        if (!retStr.equals(subClass = aClass.getDisplayClassName())) {
                            retStr = retStr + "/" + subClass;
                        }
                        lvl = InfoSummary.this.pc.getLevelInfoClassLevel(idx);
                        break;
                    }
                    if (aClass != null && aClass.getLevel() != lvl) break;
                    retStr = retStr + " (" + Integer.toString(lvl) + ')';
                    break;
                }
                case 2: {
                    if (InfoSummary.this.pc == null) break;
                    PObject aClass = null;
                    for (int idx = 0; idx < InfoSummary.this.pc.getLevelInfoSize(); ++idx) {
                        String classKey = InfoSummary.this.pc.getLevelInfoClassKeyName(idx);
                        aClass = InfoSummary.this.pc.getClassKeyed(classKey);
                        if ((aClass == null || this.shouldDisplayThis((PCClass)aClass)) && rowIndex-- == 0) break;
                    }
                    if (aClass == null) break;
                    retStr = aClass.getSource();
                    break;
                }
                default: {
                    retStr = PropertyFactory.getString("in_sumOut_of_Bounds");
                }
            }
            return retStr;
        }

        private void resetModel() {
            this.fireTableDataChanged();
        }

        private boolean shouldDisplayThis(PCClass aClass) {
            return !SettingsHandler.hideMonsterClasses() || !aClass.isMonster();
        }
    }
}

