/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.tabs;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableColumn;
import javax.swing.tree.TreePath;
import pcgen.core.Constants;
import pcgen.core.Equipment;
import pcgen.core.Feat;
import pcgen.core.GameMode;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.bonus.Bonus;
import pcgen.core.bonus.BonusObj;
import pcgen.core.prereq.PrereqHandler;
import pcgen.core.prereq.Prerequisite;
import pcgen.core.spell.Spell;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.CharacterInfo;
import pcgen.gui.CharacterInfoTab;
import pcgen.gui.PCGen_Frame1;
import pcgen.gui.filter.FilterAdapterPanel;
import pcgen.gui.filter.FilterFactory;
import pcgen.gui.panes.FlippingSplitPane;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.JTreeTableSorter;
import pcgen.gui.utils.LabelTreeCellRenderer;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.ResizeColumnListener;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserFactory;
import pcgen.util.chooser.ChooserRadio;

public class InfoTempMod
extends FilterAdapterPanel
implements CharacterInfoTab {
    private static boolean needsUpdate = true;
    private static final int MODEL_BONUS = 0;
    private static final int MODEL_TARGET = 1;
    private static final int COL_NAME = 0;
    private static final int COL_TYPE = 1;
    private static final int COL_SRC = 2;
    private static final int BONUS_COL_NAME = 0;
    private static final int BONUS_COL_TYPE = 1;
    private static final int BONUS_COL_TO = 2;
    private static final int BONUS_COL_VAL = 3;
    private AppliedModel appliedBonusModel;
    private BonusModel bonusModel = null;
    private BonusModel targetModel = null;
    private Border etched;
    private FlippingSplitPane botHorzSplit;
    private FlippingSplitPane centerHorzSplit;
    private FlippingSplitPane topVertSplit;
    private JButton applyBonusButton;
    private JButton removeBonusButton;
    private JLabelPane infoLabel = new JLabelPane();
    private JPanel botPane = new JPanel();
    private JPanel topPane = new JPanel();
    private JTreeTable appliedTable;
    private JTreeTable bonusTable;
    private JTreeTable targetTable;
    private JTreeTableSorter bonusSort = null;
    private JTreeTableSorter targetSort = null;
    private List tbwList;
    private PObject lastAvaObject = null;
    private boolean hasBeenSized = false;
    private PlayerCharacter pc;
    private int serial = 0;
    private boolean readyForRefresh = false;
    static /* synthetic */ Class class$pcgen$gui$utils$TreeTableModel;
    static /* synthetic */ Class class$java$lang$String;

    public InfoTempMod(PlayerCharacter pc) {
        this.pc = pc;
        this.setName(Constants.tabNames[14]);
        this.initComponents();
        this.initActionListeners();
        FilterFactory.restoreFilterSettings(this);
    }

    public void setPc(PlayerCharacter pc) {
        if (this.pc != pc || pc.getSerial() > this.serial) {
            this.pc = pc;
            this.serial = pc.getSerial();
            this.forceRefresh();
            pc.setUseTempMods(true);
        }
    }

    public PlayerCharacter getPc() {
        return this.pc;
    }

    public int getTabOrder() {
        return SettingsHandler.getPCGenOption(".Panel.TempMod.Order", 14);
    }

    public void setTabOrder(int order) {
        SettingsHandler.setPCGenOption(".Panel.TempMod.Order", order);
    }

    public String getTabName() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabName(14);
    }

    public boolean isShown() {
        GameMode game = SettingsHandler.getGame();
        return game.getTabShown(14);
    }

    public void refresh() {
        if (this.pc.getSerial() > this.serial) {
            this.serial = this.pc.getSerial();
            this.forceRefresh();
        }
    }

    public void forceRefresh() {
        if (this.readyForRefresh) {
            needsUpdate = true;
            this.updateCharacterInfo();
        } else {
            this.serial = 0;
        }
    }

    public JComponent getView() {
        return this;
    }

    public final boolean isMatchAnyEnabled() {
        return true;
    }

    public static void setNeedsUpdate(boolean flag) {
        needsUpdate = flag;
    }

    public final boolean isNegateEnabled() {
        return true;
    }

    public final int getSelectionMode() {
        return -2;
    }

    public final void initializeFilters() {
        FilterFactory.registerAllSourceFilters(this);
    }

    public final void refreshFiltering() {
        this.updateBonusModel();
        this.updateTargetModel();
    }

    public final void updateCharacterInfo() {
        if (this.pc == null || !needsUpdate) {
            return;
        }
        this.updateBonusModel();
        this.updateTargetModel();
        this.updateAppliedModel();
        needsUpdate = false;
    }

    private String getBonusChoice(BonusObj newB, String aChoice, String repeatValue) {
        newB.setChoiceString(aChoice);
        if (repeatValue.length() > 0) {
            if (newB.getValue().indexOf("%CHOICE") >= 0) {
                String ac = CoreUtility.replaceAll(newB.getValue(), "%CHOICE", repeatValue);
                newB.setValue(ac);
            }
            return repeatValue;
        }
        StringTokenizer aTok = new StringTokenizer(aChoice, "|");
        if (aChoice.startsWith("NUMBER") && aTok.countTokens() >= 3) {
            int max;
            int min;
            aTok.nextToken();
            String minString = aTok.nextToken();
            String maxString = aTok.nextToken();
            String titleString = "Pick a Number";
            if (aTok.hasMoreTokens() && (titleString = aTok.nextToken()).startsWith("TITLE=")) {
                titleString = titleString.substring(6);
            }
            if (minString.startsWith("MIN=")) {
                minString = minString.substring(4);
                min = this.pc.getVariableValue(minString, "").intValue();
            } else {
                min = this.pc.getVariableValue(minString, "").intValue();
            }
            if (maxString.startsWith("MAX=")) {
                maxString = maxString.substring(4);
                max = this.pc.getVariableValue(maxString, "").intValue();
            } else {
                max = this.pc.getVariableValue(maxString, "").intValue();
            }
            if (max > 0 || min <= max) {
                LinkedList<String> numberList = new LinkedList<String>();
                for (int i = min; i <= max; ++i) {
                    Integer anInt = new Integer(i);
                    numberList.add(anInt.toString());
                }
                ChooserRadio c = ChooserFactory.getRadioInstance();
                c.setAvailableList(numberList);
                c.setVisible(false);
                c.setTitle("Pick a Number");
                c.setMessageText(titleString);
                c.setVisible(true);
                if (c.getSelectedList().size() > 0) {
                    String aI;
                    repeatValue = aI = (String)c.getSelectedList().get(0);
                    if (newB.getValue().indexOf("%CHOICE") >= 0) {
                        String ac;
                        aI = ac = CoreUtility.replaceAll(newB.getValue(), "%CHOICE", aI);
                        newB.setValue(aI);
                    }
                    return repeatValue;
                }
                newB.setValue("0");
            }
        }
        return "";
    }

    private void setInfoLabelText(Object anObj) {
        Equipment eqI = null;
        Spell aSpell = null;
        Feat aFeat = null;
        PCClass aClass = null;
        PCTemplate aTemp = null;
        Skill aSkill = null;
        if (anObj instanceof Equipment) {
            eqI = (Equipment)anObj;
        } else if (anObj instanceof Spell) {
            aSpell = (Spell)anObj;
        } else if (anObj instanceof Feat) {
            aFeat = (Feat)anObj;
        } else if (anObj instanceof PCClass) {
            aClass = (PCClass)anObj;
        } else if (anObj instanceof PCTemplate) {
            aTemp = (PCTemplate)anObj;
        } else if (anObj instanceof Skill) {
            aSkill = (Skill)anObj;
        }
        if (aClass != null) {
            StringBuffer b = new StringBuffer(300);
            b.append("<html><font size=+1><b>").append(aClass.getName()).append("</b></font>");
            String bString = aClass.getSource();
            if (bString.length() > 0) {
                b.append(" <b>SOURCE:</b>").append(bString);
            }
            if ((bString = aClass.getTempDescription()).length() > 0) {
                b.append(" <br><b>Desc:</b>").append(bString);
            }
            b.append("</html>");
            this.infoLabel.setText(b.toString());
        } else if (aFeat != null) {
            StringBuffer b = new StringBuffer(300);
            b.append("<html><font size=+1><b>").append(aFeat.piSubString()).append("</b></font>");
            b.append(" <b>Type:</b> ").append(aFeat.getType());
            String bString = aFeat.getSource();
            if (bString.length() > 0) {
                b.append(" <b>SOURCE:</b>").append(bString);
            }
            if ((bString = aFeat.getTempDescription()).length() > 0) {
                b.append(" <br><b>Desc:</b>").append(bString);
            }
            b.append("</html>");
            this.infoLabel.setText(b.toString());
        } else if (eqI != null) {
            int charges;
            Integer a;
            String bString;
            StringBuffer b = new StringBuffer(300);
            b.append("<html><font size=+1><b>").append(eqI.piSubString()).append("</b></font>");
            if (!eqI.longName().equals(eqI.getName())) {
                b.append("(").append(eqI.longName()).append(")");
            }
            b.append(" <b>Type:</b> ").append(eqI.getType());
            String IDS = eqI.getInterestingDisplayString(this.pc);
            if (IDS.length() > 0) {
                b.append(" <b>Properties</b>:").append(eqI.getInterestingDisplayString(this.pc));
            }
            if ((bString = eqI.getWeight(this.pc).toString()).length() > 0) {
                b.append(" <b>WT</b>:").append(bString);
            }
            if ((a = eqI.getACBonus(this.pc)) > 0) {
                b.append(" <b>AC</b>:").append(a.toString());
            }
            if (eqI.isArmor() || eqI.isShield()) {
                a = eqI.getMaxDex(this.pc);
                b.append(" <b>MAXDEX</b>:").append(a.toString());
                a = eqI.acCheck(this.pc);
                b.append(" <b>ACCHECK</b>:").append(a.toString());
            }
            if (Globals.getGameModeShowSpellTab()) {
                a = eqI.spellFailure(this.pc);
                if (eqI.isArmor() || eqI.isShield() || a != 0) {
                    b.append(" <b>Arcane Failure</b>:").append(a.toString());
                }
            }
            if ((bString = eqI.moveString()).length() > 0) {
                b.append(" <b>Move</b>:").append(bString);
            }
            if ((bString = eqI.getSize()).length() > 0) {
                b.append(" <b>Size</b>:").append(bString);
            }
            if (eqI.isWeapon()) {
                b.append(" <b>Damage</b>:").append(eqI.getDamage(this.pc));
                b.append(" <b>Crit Mult</b>:").append(eqI.getCritMult());
                b.append(" <b>Crit Range</b>:").append(eqI.getCritRange(this.pc));
                bString = eqI.getRange(this.pc).toString();
                if (bString.length() > 0) {
                    b.append(" <b>Range</b>:").append(bString);
                }
            }
            if ((charges = eqI.getRemainingCharges()) >= 0) {
                b.append(" <b>Charges</b>:").append(charges);
            }
            b.append(" <b>Cost</b>:").append(eqI.getCost(this.pc));
            b.append(" <b>SOURCE:</b> ").append(eqI.getSource());
            bString = eqI.getTempDescription();
            if (bString.length() > 0) {
                b.append(" <br><b>Desc:</b>").append(bString);
            }
            b.append("</html>");
            this.infoLabel.setText(b.toString());
        } else if (aSkill != null) {
            StringBuffer b = new StringBuffer(300);
            b.append("<html><font size=+1><b>").append(aSkill.getName()).append("</b></font>");
            String bString = aSkill.getSource();
            if (bString.length() > 0) {
                b.append(" <b>SOURCE:</b>").append(bString);
            }
            if ((bString = aSkill.getTempDescription()).length() > 0) {
                b.append(" <br><b>Desc:</b>").append(bString);
            }
            b.append("</html>");
            this.infoLabel.setText(b.toString());
        } else if (aSpell != null) {
            String bString;
            StringBuffer b = new StringBuffer(300);
            b.append("<html><font size=+1><b>").append(aSpell.piSubString()).append("</b></font>");
            b.append(" <b>Duration:</b> ").append(aSpell.getDuration());
            b.append(" <b>Range:</b> ").append(aSpell.getRange());
            b.append(" <b>Target:</b> ").append(aSpell.getTarget());
            b.append(" <b>Description:</b> ").append(aSpell.piDescSubString());
            String spellSource = aSpell.getSource();
            if (spellSource.length() > 0) {
                b.append(" <b>SOURCE:</b>").append(spellSource);
            }
            if ((bString = aSpell.getTempDescription()).length() > 0) {
                b.append(" <br><b>Desc:</b>").append(bString);
            }
            b.append("</html>");
            this.infoLabel.setText(b.toString());
        } else if (aTemp != null) {
            StringBuffer b = new StringBuffer(300);
            b.append("<html><font size=+1><b>").append(aTemp.getName()).append("</b></font>");
            String bString = aTemp.getSource();
            if (bString.length() > 0) {
                b.append(" <b>SOURCE:</b>").append(bString);
            }
            if ((bString = aTemp.getTempDescription()).length() > 0) {
                b.append(" <br><b>Desc:</b>").append(bString);
            }
            b.append("</html>");
            this.infoLabel.setText(b.toString());
        }
    }

    private final void createTreeTables() {
        this.bonusTable = new JTreeTable(this.bonusModel);
        final JTree atree = this.bonusTable.getTree();
        atree.setRootVisible(false);
        atree.setShowsRootHandles(true);
        atree.setCellRenderer(new LabelTreeCellRenderer());
        this.bonusTable.setSelectionMode(0);
        this.bonusTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    TreePath avaPath = atree.getSelectionPath();
                    if (avaPath == null) {
                        return;
                    }
                    Object temp = avaPath.getLastPathComponent();
                    if (temp == null) {
                        InfoTempMod.this.infoLabel.setText();
                        InfoTempMod.this.lastAvaObject = null;
                        InfoTempMod.this.applyBonusButton.setEnabled(false);
                        return;
                    }
                    PObjectNode fNode = (PObjectNode)temp;
                    if (fNode.getItem() != null && !(fNode.getItem() instanceof String)) {
                        if (fNode.getItem() instanceof ClassWrap) {
                            ClassWrap tempObj = (ClassWrap)fNode.getItem();
                            InfoTempMod.this.lastAvaObject = tempObj.getMyClass();
                        } else {
                            InfoTempMod.this.lastAvaObject = (PObject)fNode.getItem();
                        }
                        InfoTempMod.this.setInfoLabelText(InfoTempMod.this.lastAvaObject);
                        InfoTempMod.this.updateTargetModel();
                        TreePath initTargPath = InfoTempMod.this.targetTable.getTree().getPathForRow(0);
                        if (initTargPath != null) {
                            InfoTempMod.this.applyBonusButton.setEnabled(true);
                            InfoTempMod.this.targetTable.getTree().setSelectionPath(initTargPath);
                        } else {
                            InfoTempMod.this.applyBonusButton.setEnabled(false);
                        }
                    } else {
                        InfoTempMod.this.applyBonusButton.setEnabled(false);
                    }
                }
            }
        });
        MouseAdapter aml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TreePath avaPath = atree.getPathForLocation(e.getX(), e.getY());
                if (avaPath != null) {
                    if (e.getClickCount() == 2) {
                        InfoTempMod.this.applyBonusButton();
                    } else if (e.getClickCount() == 1) {
                        if (atree.isPathSelected(avaPath)) {
                            atree.removeSelectionPath(avaPath);
                        } else {
                            atree.addSelectionPath(avaPath);
                        }
                    }
                }
            }
        };
        atree.addMouseListener(aml);
        this.targetTable = new JTreeTable(this.targetModel);
        final JTree stree = this.targetTable.getTree();
        stree.setRootVisible(false);
        stree.setShowsRootHandles(true);
        stree.setCellRenderer(new LabelTreeCellRenderer());
        this.targetTable.setSelectionMode(0);
        this.targetTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                TreePath selPath;
                if (!e.getValueIsAdjusting() && (selPath = stree.getSelectionPath()) == null) {
                    return;
                }
            }
        });
        MouseAdapter sml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                int selRow = stree.getRowForLocation(e.getX(), e.getY());
                TreePath selPath = stree.getPathForLocation(e.getX(), e.getY());
                if (selRow == -1 || e.getClickCount() != 1 || selPath != null) {
                    // empty if block
                }
            }
        };
        stree.addMouseListener(sml);
        this.appliedTable = new JTreeTable(this.appliedBonusModel);
        final JTree btree = this.appliedTable.getTree();
        btree.setRootVisible(false);
        btree.setShowsRootHandles(true);
        btree.setCellRenderer(new LabelTreeCellRenderer());
        this.appliedTable.setSelectionMode(0);
        this.appliedTable.setShowHorizontalLines(true);
        this.appliedTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    TreePath selPath = btree.getSelectionPath();
                    if (selPath == null) {
                        return;
                    }
                    Object temp = selPath.getLastPathComponent();
                    MyPONode fNode = (MyPONode)temp;
                    if (fNode.getItem() != null) {
                        InfoTempMod.this.removeBonusButton.setEnabled(true);
                    } else {
                        InfoTempMod.this.removeBonusButton.setEnabled(false);
                    }
                }
            }
        });
        MouseAdapter bml = new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                TreePath selPath = btree.getPathForLocation(e.getX(), e.getY());
                if (selPath != null) {
                    if (e.getClickCount() == 2) {
                        InfoTempMod.this.removeBonusButton();
                    } else if (e.getClickCount() == 1) {
                        if (btree.isPathSelected(selPath)) {
                            btree.removeSelectionPath(selPath);
                        } else {
                            btree.addSelectionPath(selPath);
                        }
                    }
                }
            }
        };
        btree.addMouseListener(bml);
        this.hookupPopupMenu(this.bonusTable);
        this.hookupPopupMenu(this.targetTable);
        this.hookupPopupMenu(this.appliedTable);
    }

    private void applyBonusButton() {
        if (this.bonusTable.getTree().isSelectionEmpty()) {
            ShowMessageDelegate.showMessageDialog("First select a type of bonus use", "PCGen", MessageType.ERROR);
            return;
        }
        if (this.targetTable.getTree().isSelectionEmpty()) {
            ShowMessageDelegate.showMessageDialog("First select an item to set the temporary bonus on", "PCGen", MessageType.ERROR);
            return;
        }
        TreePath bonusPath = this.bonusTable.getTree().getSelectionPath();
        TreePath targetPath = this.targetTable.getTree().getSelectionPath();
        Object anObj = null;
        Object aTarget = null;
        PObject aMod = null;
        int bonusLevel = 999;
        Object endComp = targetPath.getLastPathComponent();
        PObjectNode fNode = (PObjectNode)endComp;
        if (fNode.getItem() != null) {
            aTarget = fNode.getItem();
        }
        if (aTarget == null || fNode == null) {
            ShowMessageDelegate.showMessageDialog("First select an item to set the temporary bonus on", "PCGen", MessageType.ERROR);
            return;
        }
        endComp = bonusPath.getLastPathComponent();
        fNode = (PObjectNode)endComp;
        if (fNode.getItem() != null) {
            anObj = fNode.getItem();
        }
        if (anObj == null || fNode == null) {
            ShowMessageDelegate.showMessageDialog("First select a type of bonus use", "PCGen", MessageType.ERROR);
            return;
        }
        if (anObj instanceof PObject) {
            aMod = (PObject)anObj;
        } else if (anObj instanceof ClassWrap) {
            ClassWrap tempObj = (ClassWrap)anObj;
            aMod = tempObj.getMyClass();
            bonusLevel = tempObj.getLevel();
        }
        Equipment aEq = null;
        if (aTarget instanceof Equipment) {
            Equipment eq = (Equipment)aTarget;
            aEq = (Equipment)eq.clone();
            aEq.setAppliedName(aMod.getName());
            aEq.resetTempBonusList();
        }
        String repeatValue = "";
        Iterator e = aMod.getBonusList().iterator();
        while (e.hasNext()) {
            BonusObj aBonus = (BonusObj)e.next();
            String aString = aBonus.toString();
            if (!aBonus.hasPreReqs() || !aBonus.isPreReqKind("APPLY")) continue;
            BonusObj newB = null;
            if (aMod instanceof PCClass) {
                if (aBonus.getPCLevel() == bonusLevel) {
                    int idx = aString.indexOf(124);
                    newB = Bonus.newBonus(aString.substring(idx + 1));
                }
            } else {
                newB = Bonus.newBonus(aString);
            }
            if (newB == null) continue;
            aBonus.getPrereqList();
            Iterator iter = aBonus.getPrereqList().iterator();
            while (iter.hasNext()) {
                Prerequisite prereq = (Prerequisite)iter.next();
                if (prereq.getKind().equalsIgnoreCase("apply")) continue;
                newB.addPreReq(new Prerequisite(prereq));
            }
            if (aTarget instanceof PlayerCharacter) {
                if (PrereqHandler.passesAll(newB.getPrereqList(), this.pc, null)) {
                    newB.setApplied(true);
                } else {
                    newB.setApplied(false);
                }
                newB.setCreatorObject(aMod);
                newB.setTargetObject(aTarget);
                this.pc.addTempBonus(newB);
            } else if (aEq != null) {
                if (PrereqHandler.passesAll(newB.getPrereqList(), this.pc, null)) {
                    newB.setApplied(true);
                } else {
                    newB.setApplied(false);
                }
                newB.setCreatorObject(aMod);
                newB.setTargetObject(aEq);
                aEq.addTempBonus(newB);
                this.pc.addTempBonus(newB);
            }
            if (aMod.getChoiceString().length() > 0) {
                repeatValue = this.getBonusChoice(newB, aMod.getChoiceString(), repeatValue);
            }
            Logging.errorPrint("adding bonus:" + newB.toString());
        }
        if (aEq != null) {
            this.pc.addTempBonusItemList(aEq);
        }
        this.updateAppliedModel();
        this.pc.setDirty(true);
        this.pc.calcActiveBonuses();
        CharacterInfo pane = PCGen_Frame1.getCharacterPane();
        pane.setPaneForUpdate(pane.infoAbilities());
        pane.setPaneForUpdate(pane.infoClasses());
        pane.setPaneForUpdate(pane.infoFeats());
        pane.setPaneForUpdate(pane.infoSkills());
        pane.setPaneForUpdate(pane.infoSpells());
        pane.setPaneForUpdate(pane.infoSummary());
        pane.refresh();
    }

    private boolean checkPreApplyType(String aList, Equipment anEq) {
        boolean flag = true;
        StringTokenizer aTok = new StringTokenizer(aList, ",;", true);
        int iLogicType = -1;
        while (aTok.hasMoreTokens()) {
            String aString = aTok.nextToken();
            if (",".equals(aString)) {
                iLogicType = 0;
                continue;
            }
            if (";".equals(aString)) {
                iLogicType = 1;
                continue;
            }
            boolean bInvert = false;
            if (aString.length() > 0 && aString.charAt(0) == '[' && aString.endsWith("]")) {
                aString = aString.substring(1, aString.length() - 1);
                bInvert = true;
            }
            boolean bIsType = anEq.isType(aString.toUpperCase());
            if (bInvert) {
                boolean bl = bIsType = !bIsType;
            }
            if (iLogicType == -1) {
                flag = bIsType;
                continue;
            }
            if (iLogicType == 0) {
                flag &= bIsType;
                continue;
            }
            flag |= bIsType;
        }
        return flag;
    }

    private final void createBonusModel() {
        if (this.bonusModel == null) {
            this.bonusModel = new BonusModel(0);
        } else {
            this.bonusModel.resetModel(0);
        }
        if (this.bonusSort != null) {
            this.bonusSort.setRoot((PObjectNode)this.bonusModel.getRoot());
            this.bonusSort.sortNodeOnColumn();
        }
    }

    private final void createModels() {
        this.createBonusModel();
        this.createTargetModel();
        this.createAppliedModel();
    }

    private final void createTargetModel() {
        if (this.targetModel == null) {
            this.targetModel = new BonusModel(1);
        } else {
            this.targetModel.resetModel(1);
        }
        if (this.targetSort != null) {
            this.targetSort.setRoot((PObjectNode)this.targetModel.getRoot());
            this.targetSort.sortNodeOnColumn();
        }
    }

    private void createAppliedModel() {
        if (this.appliedBonusModel == null) {
            this.appliedBonusModel = new AppliedModel();
        } else {
            this.appliedBonusModel.resetModel();
        }
    }

    private void formComponentShown() {
        PCGen_Frame1.getStatusBar().setText("");
        this.refresh();
        int s = this.topVertSplit.getDividerLocation();
        int t = this.centerHorzSplit.getDividerLocation();
        int u = this.botHorzSplit.getDividerLocation();
        if (!this.hasBeenSized) {
            int width;
            TableColumn sCol;
            int i;
            this.hasBeenSized = true;
            Container c = this.getParent();
            s = SettingsHandler.getPCGenOption("InfoTempMod.topVertSplit", c.getWidth() * 1 / 2);
            t = SettingsHandler.getPCGenOption("InfoTempMod.centerHorzSplit", c.getHeight() * 1 / 2);
            u = SettingsHandler.getPCGenOption("InfoTempMod.botHorzSplit", this.botPane.getHeight() * 1 / 2);
            for (i = 0; i < this.targetTable.getColumnCount(); ++i) {
                sCol = this.targetTable.getColumnModel().getColumn(i);
                width = Globals.getCustColumnWidth("TempModSel", i);
                if (width != 0) {
                    sCol.setPreferredWidth(width);
                }
                sCol.addPropertyChangeListener(new ResizeColumnListener(this.targetTable, "TempModSel", i));
            }
            for (i = 0; i < this.bonusTable.getColumnCount(); ++i) {
                sCol = this.bonusTable.getColumnModel().getColumn(i);
                width = Globals.getCustColumnWidth("TempModAva", i);
                if (width != 0) {
                    sCol.setPreferredWidth(width);
                }
                sCol.addPropertyChangeListener(new ResizeColumnListener(this.bonusTable, "TempModAva", i));
            }
        }
        if (s > 0) {
            this.topVertSplit.setDividerLocation(s);
            SettingsHandler.setPCGenOption("InfoTempMod.topVertSplit", s);
        }
        if (t > 0) {
            this.centerHorzSplit.setDividerLocation(t);
            SettingsHandler.setPCGenOption("InfoTempMod.centerHorzSplit", t);
        }
        if (u > 0) {
            this.botHorzSplit.setDividerLocation(u);
            SettingsHandler.setPCGenOption("InfoTempMod.botHorzSplit", u);
        }
    }

    private void hookupPopupMenu(JTreeTable treeTable) {
        treeTable.addMouseListener(new BonusPopupListener(treeTable, new BonusPopupMenu(treeTable)));
    }

    private void initActionListeners() {
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                InfoTempMod.this.formComponentShown();
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                int s = InfoTempMod.this.topVertSplit.getDividerLocation();
                if (s > 0) {
                    SettingsHandler.setPCGenOption("InfoTempMod.topVertSplit", s);
                }
                if ((s = InfoTempMod.this.botHorzSplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoTempMod.botHorzSplit", s);
                }
                if ((s = InfoTempMod.this.centerHorzSplit.getDividerLocation()) > 0) {
                    SettingsHandler.setPCGenOption("InfoTempMod.centerHorzSplit", s);
                }
            }
        });
        this.applyBonusButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoTempMod.this.applyBonusButton();
            }
        });
        this.removeBonusButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                InfoTempMod.this.removeBonusButton();
            }
        });
    }

    private void initComponents() {
        this.readyForRefresh = true;
        this.createModels();
        this.createTreeTables();
        GridBagLayout gridbag = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        this.topPane.setLayout(gridbag);
        JPanel leftPane = new JPanel();
        JPanel rightPane = new JPanel();
        leftPane.setLayout(gridbag);
        rightPane.setLayout(gridbag);
        this.applyBonusButton = new JButton("Apply Bonus");
        Utility.setDescription(this.applyBonusButton, "Click to add bonus to selected item");
        this.applyBonusButton.setEnabled(false);
        this.applyBonusButton.setPreferredSize(new Dimension(60, 20));
        this.applyBonusButton.setSize(new Dimension(60, 20));
        Utility.buildConstraints(c, 0, 0, 1, 1, 0.0, 0.0);
        c.fill = 0;
        c.anchor = 11;
        c.insets = new Insets(2, 0, 2, 0);
        gridbag.setConstraints(this.applyBonusButton, c);
        this.topPane.add(this.applyBonusButton);
        JPanel aPanel = new JPanel();
        aPanel.setLayout(new BorderLayout());
        this.topVertSplit = new FlippingSplitPane(1, leftPane, rightPane);
        this.topVertSplit.setOneTouchExpandable(true);
        this.topVertSplit.setDividerSize(10);
        aPanel.add((Component)this.topVertSplit, "Center");
        Utility.buildConstraints(c, 0, 2, 1, 1, 10.0, 10.0);
        c.fill = 1;
        c.anchor = 11;
        c.ipadx = 1;
        gridbag.setConstraints(aPanel, c);
        this.topPane.add(aPanel);
        Utility.buildConstraints(c, 0, 0, 1, 1, 10.0, 10.0);
        c.fill = 1;
        c.anchor = 11;
        c.ipadx = 1;
        JScrollPane scrollPane = new JScrollPane(this.bonusTable);
        gridbag.setConstraints(scrollPane, c);
        leftPane.add(scrollPane);
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        rightPane.setLayout(gridbag);
        Utility.buildConstraints(c, 0, 0, 1, 1, 10.0, 10.0);
        c.fill = 1;
        c.anchor = 11;
        c.ipadx = 1;
        scrollPane = new JScrollPane(this.targetTable);
        gridbag.setConstraints(scrollPane, c);
        this.targetTable.setShowHorizontalLines(true);
        rightPane.add(scrollPane);
        this.botPane.setLayout(new BorderLayout());
        gridbag = new GridBagLayout();
        c = new GridBagConstraints();
        JPanel bHeadPane = new JPanel();
        JPanel bTailPane = new JPanel();
        bHeadPane.setLayout(gridbag);
        bTailPane.setLayout(gridbag);
        this.botHorzSplit = new FlippingSplitPane(0, bHeadPane, bTailPane);
        this.botHorzSplit.setOneTouchExpandable(true);
        this.botHorzSplit.setDividerSize(10);
        this.botPane.add((Component)this.botHorzSplit, "Center");
        Utility.buildConstraints(c, 0, 0, 1, 1, 2.0, 2.0);
        c.fill = 1;
        c.anchor = 10;
        JScrollPane sScroll = new JScrollPane();
        gridbag.setConstraints(sScroll, c);
        TitledBorder sTitle = BorderFactory.createTitledBorder(this.etched, "Bonus Info");
        sTitle.setTitleJustification(2);
        sScroll.setBorder(sTitle);
        this.infoLabel.setBackground(this.topPane.getBackground());
        sScroll.setViewportView(this.infoLabel);
        bHeadPane.add(sScroll);
        Utility.buildConstraints(c, 0, 0, 1, 1, 1.0, 1.0);
        c.fill = 2;
        c.anchor = 11;
        JPanel rPanel = new JPanel();
        gridbag.setConstraints(rPanel, c);
        JPanel iPanel = new JPanel();
        iPanel.setLayout(new BorderLayout(8, 0));
        this.removeBonusButton = new JButton("Remove");
        this.removeBonusButton.setEnabled(false);
        iPanel.add((Component)this.removeBonusButton, "Center");
        rPanel.add(iPanel);
        Utility.buildConstraints(c, 0, 1, 1, 1, 10.0, 10.0);
        c.fill = 1;
        c.anchor = 10;
        JScrollPane tbPane = new JScrollPane(this.appliedTable);
        gridbag.setConstraints(tbPane, c);
        bTailPane.add(rPanel);
        bTailPane.add(tbPane);
        this.centerHorzSplit = new FlippingSplitPane(0, this.topPane, this.botPane);
        this.centerHorzSplit.setOneTouchExpandable(true);
        this.centerHorzSplit.setDividerSize(10);
        this.setLayout(new BorderLayout());
        this.add((Component)this.centerHorzSplit, "Center");
        this.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent evt) {
                InfoTempMod.this.refresh();
            }
        });
        this.bonusSort = new JTreeTableSorter(this.bonusTable, (PObjectNode)this.bonusModel.getRoot(), this.bonusModel);
        this.targetSort = new JTreeTableSorter(this.targetTable, (PObjectNode)this.targetModel.getRoot(), this.targetModel);
    }

    private void refreshButton() {
        this.forceRefresh();
    }

    private void removeBonusButton() {
        if (this.appliedTable.getTree().isSelectionEmpty()) {
            ShowMessageDelegate.showMessageDialog("First select a bonus to remove", "PCGen", MessageType.ERROR);
            return;
        }
        TreePath bonusPath = this.appliedTable.getTree().getSelectionPath();
        TempWrap tbWrap = null;
        Object aCreator = null;
        Object aTarget = null;
        Object endComp = bonusPath.getLastPathComponent();
        MyPONode fNode = (MyPONode)endComp;
        if (fNode == null || fNode.getItem() == null) {
            Logging.errorPrint("fNode == null");
            return;
        }
        if (fNode.getItem() instanceof TempWrap) {
            tbWrap = (TempWrap)fNode.getItem();
        } else if (fNode.getItem() instanceof String) {
            Iterator tb = this.tbwList.iterator();
            while (tb.hasNext()) {
                TempWrap tw = (TempWrap)tb.next();
                if (!tw.getName().equals(fNode.getItem())) continue;
                tbWrap = tw;
            }
        } else {
            Logging.errorPrint("Unknown bonus type");
            return;
        }
        if (tbWrap != null) {
            aCreator = tbWrap.getCreator();
            aTarget = tbWrap.getTarget();
        }
        if (aTarget == null || aCreator == null) {
            Logging.errorPrint("Target or Creator == null");
            return;
        }
        Equipment aEq = null;
        PlayerCharacter bPC = null;
        if (aTarget instanceof Equipment) {
            aEq = (Equipment)aTarget;
        } else if (aTarget instanceof PlayerCharacter) {
            bPC = (PlayerCharacter)aTarget;
        }
        LinkedList tbList = new LinkedList(this.pc.getTempBonusList());
        Iterator e = tbList.iterator();
        while (e.hasNext()) {
            BonusObj aBonus = (BonusObj)e.next();
            Object aC = aBonus.getCreatorObject();
            Object aT = aBonus.getTargetObject();
            if (aT instanceof Equipment && aEq != null) {
                if (!aEq.equals(aT) || aCreator != aC) continue;
                this.pc.removeTempBonus(aBonus);
                this.pc.removeTempBonusItemList((Equipment)aT);
                continue;
            }
            if (!(aT instanceof PlayerCharacter) || bPC == null || (PlayerCharacter)aT != bPC || aCreator != aC) continue;
            this.pc.removeTempBonus(aBonus);
        }
        this.updateAppliedModel();
        this.pc.setDirty(true);
        this.pc.calcActiveBonuses();
        CharacterInfo pane = PCGen_Frame1.getCharacterPane();
        pane.setPaneForUpdate(pane.infoAbilities());
        pane.setPaneForUpdate(pane.infoClasses());
        pane.setPaneForUpdate(pane.infoFeats());
        pane.setPaneForUpdate(pane.infoSkills());
        pane.setPaneForUpdate(pane.infoSpells());
        pane.setPaneForUpdate(pane.infoSummary());
        pane.refresh();
    }

    private void updateAppliedModel() {
        List pathList = this.appliedTable.getExpandedPaths();
        this.createAppliedModel();
        this.appliedTable.updateUI();
        this.appliedTable.expandPathList(pathList);
    }

    private void updateBonusModel() {
        List pathList = this.bonusTable.getExpandedPaths();
        this.createBonusModel();
        this.bonusTable.updateUI();
        this.bonusTable.expandPathList(pathList);
    }

    private void updateTargetModel() {
        List pathList = this.targetTable.getExpandedPaths();
        this.createTargetModel();
        this.targetTable.updateUI();
        this.targetTable.expandPathList(pathList);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class MyPONode
    extends PObjectNode {
        private MyPONode() {
        }

        private MyPONode(Object anItem) {
            super(anItem);
        }

        public String toString() {
            Object item = super.getItem();
            if (item == null) {
                return "";
            }
            if (item instanceof String) {
                return (String)item;
            }
            if (item instanceof TempWrap) {
                return "--";
            }
            return super.toString();
        }
    }

    private class BonusPopupMenu
    extends JPopupMenu {
        BonusPopupMenu(JTreeTable treeTable) {
            if (treeTable == InfoTempMod.this.bonusTable) {
                this.add(this.createAddMenuItem("Apply Bonus", "shortcut EQUALS"));
                this.addSeparator();
                this.add(this.createRefreshMenuItem("Redraw/recalc Panel"));
            } else if (treeTable == InfoTempMod.this.targetTable) {
                this.add(this.createRefreshMenuItem("Redraw/recalc Panel"));
            } else if (treeTable == InfoTempMod.this.appliedTable) {
                this.add(this.createRemoveMenuItem("Remove Bonus", "shortcut MINUS"));
            }
        }

        private JMenuItem createAddMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new AddBonusActionListener(), "Apply bonus", '\u0000', accelerator, "Apply this Bonus", "Add16.gif", true);
        }

        private JMenuItem createRefreshMenuItem(String label) {
            return Utility.createMenuItem(label, new RefreshActionListener(), "Redraw/Recalc Panel", '\u0000', null, "Redraw/Recalc this panels info", "", true);
        }

        private JMenuItem createRemoveMenuItem(String label, String accelerator) {
            return Utility.createMenuItem(label, new RemoveActionListener(), "Remove Bonus", '\u0000', accelerator, "Remove this bonus", "", true);
        }

        private class RemoveActionListener
        extends BonusActionListener {
            private RemoveActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoTempMod.this.removeBonusButton();
            }
        }

        private class RefreshActionListener
        extends BonusActionListener {
            private RefreshActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoTempMod.this.refreshButton();
            }
        }

        private class BonusActionListener
        implements ActionListener {
            private BonusActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
            }
        }

        private class AddBonusActionListener
        extends BonusActionListener {
            private AddBonusActionListener() {
            }

            public void actionPerformed(ActionEvent evt) {
                InfoTempMod.this.applyBonusButton();
            }
        }
    }

    private class BonusPopupListener
    extends MouseAdapter {
        private BonusPopupMenu menu;
        private JTree tree;
        private JTreeTable aTreeTable;

        BonusPopupListener(JTreeTable treeTable, BonusPopupMenu aMenu) {
            this.aTreeTable = treeTable;
            this.tree = treeTable.getTree();
            this.menu = aMenu;
            KeyListener myKeyListener = new KeyListener(this){
                private final /* synthetic */ BonusPopupListener this$1;
                {
                    this.this$1 = this$1;
                }

                public void keyTyped(KeyEvent e) {
                    BonusPopupListener.access$2100(this.this$1).dispatchEvent(e);
                }

                public void keyPressed(KeyEvent e) {
                    int keyCode = e.getKeyCode();
                    if (keyCode != 0) {
                        KeyStroke keyStroke = KeyStroke.getKeyStrokeForEvent(e);
                        for (int i = 0; i < BonusPopupListener.access$2200(this.this$1).getComponentCount(); ++i) {
                            KeyStroke ks;
                            Component menuComponent = BonusPopupListener.access$2200(this.this$1).getComponent(i);
                            if (!(menuComponent instanceof JMenuItem) || (ks = ((JMenuItem)menuComponent).getAccelerator()) == null || !keyStroke.equals(ks)) continue;
                            ((JMenuItem)menuComponent).doClick(2);
                            return;
                        }
                    }
                    BonusPopupListener.access$2100(this.this$1).dispatchEvent(e);
                }

                public void keyReleased(KeyEvent e) {
                    BonusPopupListener.access$2100(this.this$1).dispatchEvent(e);
                }
            };
            treeTable.addKeyListener(myKeyListener);
        }

        public void mousePressed(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        public void mouseReleased(MouseEvent evt) {
            this.maybeShowPopup(evt);
        }

        private void maybeShowPopup(MouseEvent evt) {
            if (evt.isPopupTrigger()) {
                TreePath selPath = this.tree.getClosestPathForLocation(evt.getX(), evt.getY());
                if (selPath == null) {
                    return;
                }
                this.tree.setSelectionPath(selPath);
                this.menu.show(evt.getComponent(), evt.getX(), evt.getY());
            }
        }

        static /* synthetic */ InfoTempMod access$2100(BonusPopupListener x0) {
            return x0.InfoTempMod.this;
        }

        static /* synthetic */ BonusPopupMenu access$2200(BonusPopupListener x0) {
            return x0.menu;
        }
    }

    private final class BonusModel
    extends AbstractTreeTableModel {
        private PObjectNode avaRoot;
        private PObjectNode selRoot;
        private String[] avaNameList = new String[]{""};
        private String[] selNameList = new String[]{""};
        private int modelType = 0;

        private BonusModel(int iModel) {
            super(null);
            this.avaNameList = new String[]{"Name", "Source", "File"};
            this.selNameList = new String[]{"Name", "Target", "File"};
            this.modelType = iModel;
            this.resetModel(iModel);
        }

        public boolean isCellEditable(Object node, int column) {
            return column == 0;
        }

        public Class getColumnClass(int column) {
            switch (column) {
                case 0: {
                    return class$pcgen$gui$utils$TreeTableModel == null ? (class$pcgen$gui$utils$TreeTableModel = InfoTempMod.class$("pcgen.gui.utils.TreeTableModel")) : class$pcgen$gui$utils$TreeTableModel;
                }
                case 1: 
                case 2: {
                    break;
                }
                default: {
                    Logging.errorPrint("In InfoTempMod.getColumnClass the column " + column + " is not supported.");
                }
            }
            return class$java$lang$String == null ? (class$java$lang$String = InfoTempMod.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            return this.modelType == 0 ? this.avaNameList.length : this.selNameList.length;
        }

        public String getColumnName(int column) {
            return this.modelType == 0 ? this.avaNameList[column] : this.selNameList[column];
        }

        public Object getRoot() {
            return (PObjectNode)super.getRoot();
        }

        public Object getValueAt(Object node, int column) {
            PObjectNode fn = (PObjectNode)node;
            Feat aFeat = null;
            Spell aSpell = null;
            Equipment eqI = null;
            PObject aClass = null;
            PObject aTemp = null;
            PObject aSkill = null;
            PlayerCharacter bPC = null;
            if (fn == null) {
                Logging.errorPrint("Somehow we have no active node when doing getValueAt in InfoTempMod.");
                return null;
            }
            if (fn.getItem() instanceof Equipment) {
                eqI = (Equipment)fn.getItem();
            } else if (fn.getItem() instanceof Feat) {
                aFeat = (Feat)fn.getItem();
            } else if (fn.getItem() instanceof Spell) {
                aSpell = (Spell)fn.getItem();
            } else if (fn.getItem() instanceof ClassWrap) {
                ClassWrap tempObj = (ClassWrap)fn.getItem();
                aClass = tempObj.getMyClass();
            } else if (fn.getItem() instanceof PCTemplate) {
                aTemp = (PCTemplate)fn.getItem();
            } else if (fn.getItem() instanceof Skill) {
                aSkill = (Skill)fn.getItem();
            } else if (fn.getItem() instanceof PlayerCharacter) {
                bPC = (PlayerCharacter)fn.getItem();
            }
            switch (column) {
                case 0: {
                    if (bPC != null) {
                        return bPC.getName();
                    }
                    return fn != null ? fn.toString() : null;
                }
                case 1: {
                    if (eqI != null) {
                        return eqI.getType();
                    }
                    if (aSpell != null) {
                        return "Spell";
                    }
                    if (aFeat != null) {
                        return "Feat";
                    }
                    if (aClass != null) {
                        return "Class";
                    }
                    if (aTemp != null) {
                        return "Template";
                    }
                    if (aSkill != null) {
                        return "Skill";
                    }
                    if (bPC != null) {
                        return "Character (You)";
                    }
                    return null;
                }
                case 2: {
                    if (eqI != null) {
                        return eqI.getSource();
                    }
                    if (aSpell != null) {
                        return aSpell.getSource();
                    }
                    if (aFeat != null) {
                        return aFeat.getSource();
                    }
                    if (aClass != null) {
                        return aClass.getSource();
                    }
                    if (aTemp != null) {
                        return aTemp.getSource();
                    }
                    if (aSkill != null) {
                        return aSkill.getSource();
                    }
                    return null;
                }
            }
            if (fn != null) {
                return fn.toString();
            }
            Logging.errorPrint("Somehow we have no active node when doing getValueAt in InfoEquip.");
            return null;
        }

        private void setRoot(PObjectNode aNode) {
            super.setRoot(aNode);
        }

        private void resetModel(int argModelType) {
            Equipment aEq;
            Iterator e;
            Iterator<Object> fI;
            LinkedList<String> eqTypeList = new LinkedList<String>();
            LinkedList<String> typeList = new LinkedList<String>();
            eqTypeList.add("CUSTOM");
            Iterator iSet = InfoTempMod.this.pc.getEquipmentList().iterator();
            while (iSet.hasNext()) {
                Equipment bEq = (Equipment)iSet.next();
                StringTokenizer aTok = new StringTokenizer(bEq.getType(), ".", false);
                while (aTok.hasMoreTokens()) {
                    String aString = aTok.nextToken();
                    if (eqTypeList.contains(aString)) continue;
                    eqTypeList.add(aString);
                }
            }
            Collections.sort(eqTypeList);
            typeList.add("Feats");
            typeList.add("Items");
            typeList.add("Spells");
            typeList.add("Classes");
            typeList.add("Templates");
            typeList.add("Skills");
            if (argModelType == 0) {
                PCTemplate aTemp;
                PObjectNode aFN;
                PObjectNode aFN2;
                BonusObj aBonus;
                Feat aFeat;
                this.avaRoot = new PObjectNode();
                this.setRoot(this.avaRoot);
                PObjectNode[] pNode = new PObjectNode[]{new PObjectNode("Feat"), new PObjectNode("Spell"), new PObjectNode("Item"), new PObjectNode("Class"), new PObjectNode("Templates"), new PObjectNode("Skills")};
                fI = InfoTempMod.this.pc.aggregateFeatList().iterator();
                while (fI.hasNext()) {
                    aFeat = (Feat)fI.next();
                    e = aFeat.getBonusList().iterator();
                    while (e.hasNext()) {
                        aBonus = (BonusObj)e.next();
                        if (!aBonus.hasPreReqs() || !aBonus.isPreReqKind("APPLY")) continue;
                        aFN2 = new PObjectNode(aFeat);
                        aFN2.setParent(pNode[0]);
                        pNode[0].addChild(aFN2, true);
                        pNode[0].setParent(this.avaRoot);
                    }
                }
                fI = Globals.getFeatList().iterator();
                while (fI.hasNext()) {
                    aFeat = (Feat)fI.next();
                    e = aFeat.getBonusList().iterator();
                    while (e.hasNext()) {
                        aBonus = (BonusObj)e.next();
                        if (!aBonus.hasPreReqs() || !aBonus.isPreReqKind("APPLY") || !aBonus.isPreReqTarget("ANYPC")) continue;
                        aFN2 = new PObjectNode(aFeat);
                        aFN2.setParent(pNode[0]);
                        pNode[0].addChild(aFN2, true);
                        pNode[0].setParent(this.avaRoot);
                    }
                }
                fI = InfoTempMod.this.pc.aggregateSpellList("Any", "", "", "", 0, 9).iterator();
                while (fI.hasNext()) {
                    Spell aSpell = (Spell)fI.next();
                    if (aSpell == null) continue;
                    e = aSpell.getBonusList().iterator();
                    while (e.hasNext()) {
                        aBonus = (BonusObj)e.next();
                        if (!aBonus.hasPreReqs() || !aBonus.isPreReqKind("APPLY")) continue;
                        aFN2 = new PObjectNode(aSpell);
                        aFN2.setParent(pNode[1]);
                        pNode[1].addChild(aFN2, true);
                        pNode[1].setParent(this.avaRoot);
                    }
                }
                fI = Globals.getSpellMap().values().iterator();
                while (fI.hasNext()) {
                    Object obj = fI.next();
                    Spell aSpell = null;
                    if (obj instanceof Spell) {
                        aSpell = (Spell)obj;
                    } else if (obj instanceof ArrayList) continue;
                    if (aSpell == null) continue;
                    Iterator e2 = aSpell.getBonusList().iterator();
                    while (e2.hasNext()) {
                        BonusObj aBonus2 = (BonusObj)e2.next();
                        String aString = aBonus2.getPrereqString();
                        if (!aBonus2.hasPreReqs() || !aBonus2.isPreReqKind("APPLY") || aBonus2.isPreReqTarget("PC")) continue;
                        aFN = new PObjectNode(aSpell);
                        aFN.setParent(pNode[1]);
                        pNode[1].addChild(aFN, true);
                        pNode[1].setParent(this.avaRoot);
                    }
                }
                if (!pNode[1].isLeaf()) {
                    pNode[1].setParent(this.avaRoot);
                }
                fI = InfoTempMod.this.pc.getEquipmentList().iterator();
                while (fI.hasNext()) {
                    aEq = (Equipment)fI.next();
                    e = aEq.getBonusList().iterator();
                    while (e.hasNext()) {
                        aBonus = (BonusObj)e.next();
                        if (!aBonus.hasPreReqs() || !aBonus.isPreReqKind("APPLY")) continue;
                        aFN2 = new PObjectNode(aEq);
                        aFN2.setParent(pNode[2]);
                        pNode[2].addChild(aFN2, true);
                        pNode[2].setParent(this.avaRoot);
                    }
                }
                if (!pNode[2].isLeaf()) {
                    pNode[2].setParent(this.avaRoot);
                }
                fI = InfoTempMod.this.pc.getClassList().iterator();
                while (fI.hasNext()) {
                    PCClass aClass = (PCClass)fI.next();
                    e = aClass.getBonusList().iterator();
                    while (e.hasNext()) {
                        aBonus = (BonusObj)e.next();
                        int myLevel = aClass.getLevel();
                        int level = aBonus.getPCLevel();
                        if (!aBonus.hasPreReqs() || !aBonus.isPreReqKind("APPLY") || myLevel < level) continue;
                        aFN = new PObjectNode(new ClassWrap(aClass, level));
                        aFN.setParent(pNode[3]);
                        pNode[3].addChild(aFN, true);
                        pNode[3].setParent(this.avaRoot);
                    }
                }
                if (!pNode[3].isLeaf()) {
                    pNode[3].setParent(this.avaRoot);
                }
                fI = InfoTempMod.this.pc.getTemplateList().iterator();
                while (fI.hasNext()) {
                    aTemp = (PCTemplate)fI.next();
                    e = aTemp.getBonusList().iterator();
                    while (e.hasNext()) {
                        aBonus = (BonusObj)e.next();
                        if (!aBonus.hasPreReqs() || !aBonus.isPreReqKind("APPLY")) continue;
                        PObjectNode aFN3 = new PObjectNode(aTemp);
                        aFN3.setParent(pNode[4]);
                        pNode[4].addChild(aFN3, true);
                        pNode[4].setParent(this.avaRoot);
                    }
                }
                fI = Globals.getTemplateList().iterator();
                while (fI.hasNext()) {
                    aTemp = (PCTemplate)fI.next();
                    e = aTemp.getBonusList().iterator();
                    while (e.hasNext()) {
                        aBonus = (BonusObj)e.next();
                        if (!aBonus.hasPreReqs() || !aBonus.isPreReqKind("APPLY") || !aBonus.isPreReqTarget("ANYPC")) continue;
                        PObjectNode aFN4 = new PObjectNode(aTemp);
                        aFN4.setParent(pNode[4]);
                        pNode[4].addChild(aFN4, true);
                        pNode[4].setParent(this.avaRoot);
                    }
                }
                if (!pNode[4].isLeaf()) {
                    pNode[4].setParent(this.avaRoot);
                }
                fI = InfoTempMod.this.pc.getSkillList().iterator();
                while (fI.hasNext()) {
                    Skill aSkill = (Skill)fI.next();
                    e = aSkill.getBonusList().iterator();
                    while (e.hasNext()) {
                        aBonus = (BonusObj)e.next();
                        if (!aBonus.hasPreReqs() || !aBonus.isPreReqKind("APPLY")) continue;
                        PObjectNode aFN5 = new PObjectNode(aSkill);
                        aFN5.setParent(pNode[5]);
                        pNode[5].addChild(aFN5, true);
                        pNode[5].setParent(this.avaRoot);
                    }
                }
                if (!pNode[5].isLeaf()) {
                    pNode[5].setParent(this.avaRoot);
                }
                this.avaRoot.setChildren(pNode);
            } else {
                this.selRoot = new PObjectNode();
                this.setRoot(this.selRoot);
                if (InfoTempMod.this.lastAvaObject == null) {
                    return;
                }
                boolean found = false;
                Iterator e3 = InfoTempMod.this.lastAvaObject.getBonusList().iterator();
                while (e3.hasNext()) {
                    BonusObj aBonus = (BonusObj)e3.next();
                    if (aBonus == null || !aBonus.hasPreReqs() || !aBonus.isPreReqKind("APPLY") || !aBonus.isPreReqTarget("ANYPC") && !aBonus.isPreReqTarget("PC") || found) continue;
                    PObjectNode aFN = new PObjectNode(InfoTempMod.this.pc);
                    aFN.setParent(this.selRoot);
                    this.selRoot.addChild(aFN, true);
                    found = true;
                }
                fI = InfoTempMod.this.pc.getEquipmentList().iterator();
                while (fI.hasNext()) {
                    aEq = (Equipment)fI.next();
                    found = false;
                    e = InfoTempMod.this.lastAvaObject.getBonusList().iterator();
                    while (e.hasNext() && !found) {
                        BonusObj aBonus = (BonusObj)e.next();
                        if (aBonus == null || !aBonus.hasPreReqs() || !aBonus.isPreReqKind("APPLY")) continue;
                        boolean passesApply = true;
                        Iterator iter = aBonus.getPrereqList().iterator();
                        while (iter.hasNext() && passesApply) {
                            Prerequisite element = (Prerequisite)iter.next();
                            if (!element.getKind().equalsIgnoreCase("APPLY") || PrereqHandler.passes(element, aEq)) continue;
                            passesApply = false;
                        }
                        if (!passesApply || found) continue;
                        PObjectNode aFN = new PObjectNode(aEq);
                        aFN.setParent(this.selRoot);
                        this.selRoot.addChild(aFN, true);
                        found = true;
                    }
                }
                this.setRoot(this.selRoot);
            }
            PObjectNode rootAsPObjectNode = (PObjectNode)super.getRoot();
            if (rootAsPObjectNode != null && rootAsPObjectNode.getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }
    }

    private final class AppliedModel
    extends AbstractTreeTableModel {
        private String[] colNameList = new String[]{"Name [Target]", "Bonus Type", "Bonus To", "Bonus Value"};
        private MyPONode bonusRoot;

        private AppliedModel() {
            super(null);
            this.resetModel();
        }

        public boolean isCellEditable(Object node, int column) {
            return column == 0;
        }

        public Class getColumnClass(int column) {
            if (column == 0) {
                return class$pcgen$gui$utils$TreeTableModel == null ? (class$pcgen$gui$utils$TreeTableModel = InfoTempMod.class$("pcgen.gui.utils.TreeTableModel")) : class$pcgen$gui$utils$TreeTableModel;
            }
            return class$java$lang$String == null ? (class$java$lang$String = InfoTempMod.class$("java.lang.String")) : class$java$lang$String;
        }

        public int getColumnCount() {
            return this.colNameList.length;
        }

        public String getColumnName(int column) {
            return this.colNameList[column];
        }

        public Object getRoot() {
            return (MyPONode)super.getRoot();
        }

        public Object getValueAt(Object node, int column) {
            MyPONode fn = (MyPONode)node;
            TempWrap tbWrap = null;
            PObject aTarget = null;
            PlayerCharacter bPC = null;
            String nameString = "";
            String aType = "";
            String aTo = "";
            String aVal = "";
            if (fn == null) {
                Logging.errorPrint("Somehow we have no active node when doing getValueAt in AppliedModel");
                return null;
            }
            if (fn.getItem() instanceof TempWrap) {
                tbWrap = (TempWrap)fn.getItem();
                BonusObj aBonus = tbWrap.getBonus();
                Object anObj = tbWrap.getTarget();
                aType = aBonus.getTypeOfBonus();
                aTo = aBonus.getBonusInfo();
                aVal = InfoTempMod.this.pc.getVariableValue(aBonus.getValue(), "").toString();
                if (anObj instanceof Equipment) {
                    aTarget = (PObject)anObj;
                } else if (anObj instanceof PlayerCharacter) {
                    bPC = (PlayerCharacter)anObj;
                }
            } else if (fn.getItem() instanceof String) {
                nameString = fn.toString();
            }
            switch (column) {
                case 0: {
                    if (tbWrap != null) {
                        return tbWrap;
                    }
                    if (nameString.length() > 0) {
                        return nameString;
                    }
                    return null;
                }
                case 1: {
                    return aType;
                }
                case 2: {
                    return aTo;
                }
                case 3: {
                    return aVal;
                }
            }
            if (fn != null) {
                return fn.toString();
            }
            Logging.errorPrint("Somehow we have no active node when doing getValueAt in AppliedModel");
            return null;
        }

        private void setRoot(MyPONode aNode) {
            super.setRoot(aNode);
        }

        private void resetModel() {
            TempWrap tw;
            this.bonusRoot = new MyPONode();
            LinkedList<String> sList = new LinkedList<String>();
            InfoTempMod.this.tbwList = new LinkedList();
            Iterator fI = InfoTempMod.this.pc.getTempBonusList().iterator();
            while (fI.hasNext()) {
                BonusObj aBonus = (BonusObj)fI.next();
                Object aC = aBonus.getCreatorObject();
                Object aT = aBonus.getTargetObject();
                tw = new TempWrap(aC, aT, aBonus);
                InfoTempMod.this.tbwList.add(tw);
                String sString = tw.getName();
                if (sList.contains(sString)) continue;
                sList.add(sString);
            }
            PObjectNode[] cc = new MyPONode[sList.size()];
            for (int i = 0; i < sList.size(); ++i) {
                String hString = (String)sList.get(i);
                cc[i] = new MyPONode();
                cc[i].setItem(hString);
                for (int j = 0; j < InfoTempMod.this.tbwList.size(); ++j) {
                    tw = (TempWrap)InfoTempMod.this.tbwList.get(j);
                    String aString = tw.getName();
                    if (!hString.equals(aString)) continue;
                    MyPONode aFN = new MyPONode(tw);
                    aFN.setParent(cc[i]);
                    cc[i].addChild(aFN);
                }
                if (cc[i].isLeaf()) continue;
                cc[i].setParent(this.bonusRoot);
            }
            this.bonusRoot.setChildren(cc);
            this.setRoot(this.bonusRoot);
            MyPONode rootAsPObjectNode = (MyPONode)super.getRoot();
            if (rootAsPObjectNode != null && rootAsPObjectNode.getChildCount() > 0) {
                this.fireTreeNodesChanged(super.getRoot(), new TreePath(super.getRoot()));
            }
        }
    }

    public static final class TempWrap {
        private BonusObj _bonus = null;
        private Object _creator = null;
        private Object _target = null;

        public TempWrap(Object aMod, Object aTarget, BonusObj aBonus) {
            this._creator = aMod;
            this._target = aTarget;
            this._bonus = aBonus;
        }

        public BonusObj getBonus() {
            return this._bonus;
        }

        public Object getCreator() {
            return this._creator;
        }

        public String getName() {
            StringBuffer b = new StringBuffer();
            if (this._creator instanceof PlayerCharacter) {
                b.append(((PlayerCharacter)this._creator).getName());
            } else if (this._creator instanceof PObject) {
                b.append(this._creator.toString());
            }
            b.append(" [");
            if (this._target instanceof PlayerCharacter) {
                b.append("Player");
            } else if (this._target instanceof Equipment) {
                b.append(((Equipment)this._target).getName());
            }
            b.append("]");
            return b.toString();
        }

        public Object getTarget() {
            return this._target;
        }
    }

    public static final class ClassWrap {
        private PCClass _class = null;
        private int _level = 0;

        public ClassWrap(PCClass aClass, int aLevel) {
            this._class = aClass;
            this._level = aLevel;
        }

        public int getLevel() {
            return this._level;
        }

        public PCClass getMyClass() {
            return this._class;
        }

        public String toString() {
            StringBuffer b = new StringBuffer();
            b.append(this._class.getName());
            b.append(" (").append(this._level).append(")");
            return b.toString();
        }
    }
}

