/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Component;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import pcgen.gui.utils.JComboBoxEx;

public class JComboBoxEditor
extends JComboBoxEx
implements TableCellEditor {
    private final transient List d_listeners = new ArrayList();
    private transient int d_originalValue = 0;

    public JComboBoxEditor(Object[] objects) {
        super(objects);
    }

    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    public Object getCellEditorValue() {
        return new Integer(this.getSelectedIndex());
    }

    public Component getTableCellEditorComponent(JTable jTable, Object value, boolean isSelected, int row, int column) {
        int i = -1;
        if (value == null) {
            return null;
        }
        this.d_originalValue = this.getSelectedIndex();
        if (value instanceof String) {
            i = Integer.parseInt((String)value);
        } else if (value instanceof Integer) {
            i = (Integer)value;
        }
        if (i < 0 || i >= this.getItemCount()) {
            i = 0;
        }
        this.setSelectedIndex(i);
        jTable.setRowSelectionInterval(row, row);
        jTable.setColumnSelectionInterval(column, column);
        return this;
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        this.d_listeners.add(cellEditorListener);
    }

    public void cancelCellEditing() {
        this.fireEditingCanceled();
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        this.d_listeners.remove(cellEditorListener);
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    public boolean stopCellEditing() {
        this.fireEditingStopped();
        return true;
    }

    private void fireEditingCanceled() {
        this.setSelectedIndex(this.d_originalValue);
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
            ((CellEditorListener)this.d_listeners.get(i)).editingCanceled(ce);
        }
    }

    private void fireEditingStopped() {
        ChangeEvent ce = new ChangeEvent(this);
        for (int i = this.d_listeners.size() - 1; i >= 0; --i) {
            ((CellEditorListener)this.d_listeners.get(i)).editingStopped(ce);
        }
    }
}

