/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public class JOpenRecentMenu
extends JMenu {
    static final long serialVersionUID = -1385714650728604115L;
    private FixedArrayList entries = null;
    private OpenRecentCallback cb = null;

    public JOpenRecentMenu(OpenRecentCallback aCb) {
        this.standardMenuFeatures();
        this.setEnabled(false);
        this.cb = aCb;
        this.entries = new FixedArrayList();
    }

    public final void setEntriesAsStrings(String[] strings) {
        for (int i = 0; i < strings.length; i += 2) {
            try {
                this.add(strings[i], new File(strings[i + 1]));
                continue;
            }
            catch (Exception e) {
                Logging.errorPrint("Error setting old character " + strings[i] + ".", e);
            }
        }
    }

    public final String[] getEntriesAsStrings() {
        ArrayList<String> strings = new ArrayList<String>();
        if (this.entries != null) {
            for (int i = this.entries.size() - 1; i >= 0; --i) {
                OpenRecentEntry entry = (OpenRecentEntry)this.entries.get(i);
                strings.add(entry.displayAs);
                strings.add(entry.file.getAbsolutePath());
            }
        }
        return strings.toArray(new String[0]);
    }

    public final void add(String displayAs, File file) {
        this.doAddUpdateEntry(new OpenRecentEntry(displayAs, file));
    }

    private void doAddEntry(OpenRecentEntry entry) {
        this.doRemoveEntry(entry);
        this.entries.add(entry);
    }

    private void doAddUpdateEntry(OpenRecentEntry entry) {
        this.doAddEntry(entry);
        this.updateMenu();
    }

    private void doRemoveEntry(OpenRecentEntry entry) {
        for (int i = 0; i < this.entries.size(); ++i) {
            if (!this.entries.get(i).equals(entry)) continue;
            this.entries.remove(i);
            break;
        }
    }

    private void doRemoveUpdateEntry(OpenRecentEntry entry) {
        this.doRemoveEntry(entry);
        this.updateMenu();
    }

    private void standardMenuFeatures() {
        this.setText(PropertyFactory.getString("in_mnuOpenRecent"));
        this.setMnemonic(PropertyFactory.getMnemonic("in_mn_mnuOpenRecent"));
        Utility.setDescription(this, PropertyFactory.getString("in_mnuOpenRecentTip"));
    }

    private final void updateMenu() {
        this.setEnabled(false);
        this.removeAll();
        int x = this.entries.size();
        for (int i = 0; i < x; ++i) {
            this.add(this.createMenuItem((OpenRecentEntry)this.entries.get(i)));
        }
        if (x != 0) {
            this.setEnabled(true);
        }
    }

    private JMenuItem createMenuItem(OpenRecentEntry entry) {
        return Utility.createMenuItem(entry.displayAs, new OpenRecentActionListener(this, entry, this.cb), null, '\u0000', null, entry.file.getAbsolutePath(), null, true);
    }

    private static final class OpenRecentEntry {
        private File file;
        private String displayAs;

        OpenRecentEntry(String displayAs, File file) {
            this.displayAs = displayAs;
            this.file = file;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof OpenRecentEntry)) {
                return false;
            }
            OpenRecentEntry entry = (OpenRecentEntry)obj;
            return this.file.equals(entry.file);
        }

        public int hashCode() {
            return super.hashCode();
        }
    }

    private static final class OpenRecentActionListener
    implements ActionListener {
        private JOpenRecentMenu menu = null;
        private OpenRecentCallback cb = null;
        private OpenRecentEntry entry = null;

        OpenRecentActionListener(JOpenRecentMenu aMenu, OpenRecentEntry anEntry, OpenRecentCallback aCb) {
            this.menu = aMenu;
            this.entry = anEntry;
            this.cb = aCb;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.entry.file.exists()) {
                this.menu.doAddUpdateEntry(this.entry);
                this.cb.openRecentPerformed(e, this.entry.file);
            } else {
                this.menu.doRemoveUpdateEntry(this.entry);
            }
        }
    }

    private static final class FixedArrayList
    extends ArrayList {
        private int max = 0;

        FixedArrayList() {
            this(5);
        }

        FixedArrayList(int max) {
            super(max);
            this.max = max;
        }

        public boolean add(Object element) {
            super.add(0, element);
            int size = this.size();
            while (size > this.max) {
                this.remove(--size);
            }
            return true;
        }
    }

    public static interface OpenRecentCallback {
        public void openRecentPerformed(ActionEvent var1, File var2);
    }
}

