/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import pcgen.core.Constants;
import pcgen.core.SettingsHandler;
import pcgen.util.Logging;

public class JTableEx
extends JTable {
    static final long serialVersionUID = 514835142307946415L;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Integer;

    public JTableEx() {
        this(null, null, null);
    }

    public JTableEx(TableModel tm) {
        this(tm, null, null);
    }

    public JTableEx(TableModel tm, TableColumnModel tcm) {
        this(tm, tcm, null);
    }

    private JTableEx(TableModel tm, TableColumnModel tcm, ListSelectionModel lsm) {
        super(tm, tcm, lsm);
        this.setDefaultRenderer(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = JTableEx.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, new AlignCellRenderer(4));
        this.setDefaultRenderer(class$java$lang$Float == null ? (class$java$lang$Float = JTableEx.class$("java.lang.Float")) : class$java$lang$Float, new AlignCellRenderer(4));
        this.setDefaultRenderer(class$java$lang$Integer == null ? (class$java$lang$Integer = JTableEx.class$("java.lang.Integer")) : class$java$lang$Integer, new AlignCellRenderer(4));
    }

    public final void setOptimalColumnWidths(int[] columns) {
        JTableHeader header = this.getTableHeader();
        TableCellRenderer defaultHeaderRenderer = header != null ? header.getDefaultRenderer() : null;
        TableColumnModel aColumnModel = this.getColumnModel();
        if (aColumnModel == null) {
            return;
        }
        int columncount = aColumnModel.getColumnCount();
        if (columns.length <= 0 || columncount < columns.length || columncount < columns[columns.length - 1]) {
            Logging.errorPrint("Bad parameters passed to setOptimalColumnWidth.");
            return;
        }
        TableModel data = this.getModel();
        int rowCount = data.getRowCount();
        int totalWidth = 0;
        for (int i = 0; i < columns.length; ++i) {
            try {
                TableCellRenderer r;
                Component c;
                Object value;
                TableColumn column = aColumnModel.getColumn(columns[i]);
                if (column == null) continue;
                int columnIndex = column.getModelIndex();
                int width = -1;
                TableCellRenderer h = column.getHeaderRenderer();
                if (h == null) {
                    h = defaultHeaderRenderer;
                }
                if (h != null && (value = column.getHeaderValue()) != null && (c = h.getTableCellRendererComponent(this, value, false, false, -1, i)) != null) {
                    width = c.getPreferredSize().width;
                }
                if ((r = column.getCellRenderer()) == null) {
                    r = this.getDefaultRenderer(data.getColumnClass(columnIndex));
                }
                if (r != null) {
                    for (int row = rowCount - 1; row >= 0; --row) {
                        Component c2;
                        Object value2 = data.getValueAt(row, columnIndex);
                        if (value2 == null || (c2 = r.getTableCellRendererComponent(this, value2, false, false, row, columnIndex)) == null) continue;
                        width = Math.max(width, c2.getPreferredSize().width);
                    }
                }
                if (width >= 0) {
                    column.setPreferredWidth(width + 5);
                }
                totalWidth += column.getPreferredWidth();
                continue;
            }
            catch (Exception e) {
                Logging.errorPrint("Exception JTableEx.setOptimalColumnWidths:" + i + ":" + columns.length + ":" + columncount + Constants.s_LINE_SEP + "Exception type:" + e.getClass().getName() + Constants.s_LINE_SEP + "Message:" + e.getMessage());
            }
        }
        Dimension size = this.getPreferredScrollableViewportSize();
        size.width = totalWidth += columncount * aColumnModel.getColumnMargin();
        this.setPreferredScrollableViewportSize(size);
        this.sizeColumnsToFit(-1);
        if (header != null) {
            header.repaint();
        }
    }

    public final String getToolTipText(MouseEvent event) {
        if (SettingsHandler.isToolTipTextShown()) {
            int row = this.rowAtPoint(event.getPoint());
            int col = this.columnAtPoint(event.getPoint());
            if (row < 0 || col < 0) {
                return null;
            }
            Object o = this.getValueAt(row, col);
            if (o == null || "".equals(o.toString())) {
                return null;
            }
            return JTableEx.wrap(o.toString());
        }
        return null;
    }

    public void setColAlign(int col, int alignment) {
        this.getColumnModel().getColumn(col).setCellRenderer(new AlignCellRenderer(alignment));
    }

    public void updateUI() {
        super.updateUI();
        this.getTableHeader().updateUI();
    }

    private static String wrap(String argText) {
        String text = argText.substring(argText.lastIndexOf("|") + 1);
        int textLength = text.length();
        StringBuffer wrapped = new StringBuffer(textLength);
        int length = 70;
        while (textLength > 70 && text.indexOf(92) < 0) {
            int lastBreak = -1;
            boolean bInHtmlTag = false;
            int displayedCount = 0;
            block6: for (int pos = 0; pos < textLength && displayedCount < 70; ++pos) {
                switch (text.charAt(pos)) {
                    case ' ': {
                        if (bInHtmlTag) continue block6;
                        lastBreak = pos;
                        ++displayedCount;
                        continue block6;
                    }
                    case '<': {
                        bInHtmlTag = true;
                        continue block6;
                    }
                    case '>': {
                        bInHtmlTag = false;
                        continue block6;
                    }
                    default: {
                        if (bInHtmlTag) continue block6;
                        ++displayedCount;
                    }
                }
            }
            if (displayedCount < 70) {
                lastBreak = textLength;
            }
            if (lastBreak == -1) {
                lastBreak = 70;
            }
            if (wrapped.length() != 0) {
                wrapped.append("<br>");
            }
            wrapped.append(text.substring(0, lastBreak));
            text = text.substring(lastBreak).trim();
            textLength = text.length();
        }
        if (text.length() != 0) {
            if (wrapped.length() != 0) {
                wrapped.append("<br>");
            }
            wrapped.append(text);
        }
        if (!wrapped.toString().startsWith("<html>")) {
            wrapped.insert(0, "<html>");
            wrapped.append("</html>");
        }
        return wrapped.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public final class AlignCellRenderer
    extends DefaultTableCellRenderer {
        private int align = 2;

        public AlignCellRenderer(int anInt) {
            this.align = anInt;
            this.setHorizontalAlignment(this.align);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            this.setEnabled(table == null || table.isEnabled());
            this.setHorizontalAlignment(this.align);
            return this;
        }
    }
}

