/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventObject;
import java.util.Iterator;
import java.util.List;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.ListSelectionModel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeSelectionModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import pcgen.core.PObject;
import pcgen.core.SettingsHandler;
import pcgen.core.character.SpellInfo;
import pcgen.gui.utils.AbstractCellEditor;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.PObjectNode;
import pcgen.gui.utils.TreeTableModel;
import pcgen.gui.utils.TreeTableModelAdapter;

public final class JTreeTable
extends JTableEx
implements KeyListener {
    static final long serialVersionUID = -3571248405124682593L;
    private TimedKeyBuffer keyBuffer = new TimedKeyBuffer(3000);
    private TreeTableCellRenderer tree;
    static /* synthetic */ Class class$pcgen$gui$utils$TreeTableModel;

    public JTreeTable(TreeTableModel treeTableModel) {
        UIManager.put("TreeTableUI", "javax.swing.plaf.metal.MetalTreeUI");
        UIManager.put("Tree.leftChildIndent", new Integer(3));
        UIManager.put("Tree.rightChildIndent", new Integer(8));
        this.tree = new TreeTableCellRenderer(treeTableModel);
        this.addKeyListener(this);
        super.setModel(new TreeTableModelAdapter(treeTableModel, this.tree));
        ListToTreeSelectionModelWrapper selectionWrapper = new ListToTreeSelectionModelWrapper();
        this.tree.setSelectionModel(selectionWrapper);
        this.setSelectionModel(selectionWrapper.getListSelectionModel());
        this.setDefaultRenderer(class$pcgen$gui$utils$TreeTableModel == null ? (class$pcgen$gui$utils$TreeTableModel = JTreeTable.class$("pcgen.gui.utils.TreeTableModel")) : class$pcgen$gui$utils$TreeTableModel, this.tree);
        this.setDefaultEditor(class$pcgen$gui$utils$TreeTableModel == null ? (class$pcgen$gui$utils$TreeTableModel = JTreeTable.class$("pcgen.gui.utils.TreeTableModel")) : class$pcgen$gui$utils$TreeTableModel, new TreeTableCellEditor());
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        if (this.tree.getRowHeight() < 1) {
            this.setRowHeight(18);
        } else {
            this.setRowHeight(this.tree.getRowHeight());
        }
    }

    public int getEditingRow() {
        return this.getColumnClass(this.editingColumn) == (class$pcgen$gui$utils$TreeTableModel == null ? (class$pcgen$gui$utils$TreeTableModel = JTreeTable.class$("pcgen.gui.utils.TreeTableModel")) : class$pcgen$gui$utils$TreeTableModel) ? -1 : this.editingRow;
    }

    public List getExpandedPaths() {
        int count = 0;
        if (this.tree == null) {
            return null;
        }
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            if (!this.tree.isExpanded(i)) continue;
            ++count;
        }
        String[] anArray = new String[count];
        count = 0;
        for (int i = 0; i < this.tree.getRowCount(); ++i) {
            if (!this.tree.isExpanded(i)) continue;
            anArray[count++] = this.tree.getPathForRow(i).toString();
        }
        List<String> list = Arrays.asList(anArray);
        Collections.sort(list, Collections.reverseOrder());
        return list;
    }

    public void setRowHeight(int rowHeight) {
        super.setRowHeight(rowHeight);
        if (this.tree != null && this.tree.getRowHeight() != rowHeight) {
            this.tree.setRowHeight(this.getRowHeight());
        }
    }

    public JTree getTree() {
        return this.tree;
    }

    public void expandByPObjectName(String name) {
        this.expandByPObjectName((PObjectNode)this.getTree().getModel().getRoot(), name);
    }

    public void expandPathList(List aList) {
        if (aList == null) {
            return;
        }
        Iterator ap = aList.iterator();
        while (ap.hasNext()) {
            String path = (String)ap.next();
            for (int iRow = 0; iRow < this.getRowCount(); ++iRow) {
                TreePath iPath = this.tree.getPathForRow(iRow);
                if (iPath == null || !iPath.toString().equals(path)) continue;
                this.tree.makeVisible(iPath);
                this.tree.expandPath(iPath);
            }
        }
    }

    public void keyPressed(KeyEvent ke) {
        if (ke.getKeyCode() == 27) {
            this.keyBuffer.clearBuffer();
        }
    }

    public void keyReleased(KeyEvent ke) {
    }

    public void keyTyped(KeyEvent ke) {
        if (ke.getModifiers() != 0 && ke.getModifiers() != 1) {
            return;
        }
        char keyChar = ke.getKeyChar();
        if (!Character.isLetterOrDigit(keyChar) && !Character.isWhitespace(keyChar) && keyChar != '-' && keyChar != '+' && keyChar != '(' && keyChar != ')' && keyChar != '.' && keyChar != ',' && keyChar != ':' && keyChar != ';') {
            return;
        }
        if (this.getSelectedRow() >= 0 && this.getSelectedColumn() >= 0 && this.isCellEditable(this.getSelectedRow(), this.getSelectedColumn()) && this.getColumnClass(this.getSelectedColumn()) != (class$pcgen$gui$utils$TreeTableModel == null ? (class$pcgen$gui$utils$TreeTableModel = JTreeTable.class$("pcgen.gui.utils.TreeTableModel")) : class$pcgen$gui$utils$TreeTableModel)) {
            return;
        }
        this.keyBuffer.addChar(ke.getKeyChar());
        String buffer = this.keyBuffer.getString().toLowerCase();
        TreePath treePath = this.tree.getSelectionPath();
        PObjectNode current = (PObjectNode)treePath.getLastPathComponent();
        PObjectNode parent = current.getParent();
        if (!(buffer.length() != 1 || current.isLeaf() || keyChar != '+' && keyChar != '-' && keyChar != ' ')) {
            this.keyBuffer.clearBuffer();
            switch (keyChar) {
                case '+': {
                    this.tree.expandPath(treePath);
                    this.tree.setSelectionPath(treePath);
                    return;
                }
                case '-': {
                    this.tree.collapsePath(treePath);
                    this.tree.setSelectionPath(treePath);
                    return;
                }
                case ' ': {
                    if (this.tree.isCollapsed(treePath)) {
                        this.tree.expandPath(treePath);
                    } else {
                        this.tree.collapsePath(treePath);
                    }
                    this.tree.setSelectionPath(treePath);
                    return;
                }
            }
        }
        if (current.getNodeName() == null || !current.getNodeName().toLowerCase().startsWith(buffer)) {
            this.searchSingleLevel(parent, buffer, true);
        }
    }

    public void scrollRectToVisible(Rectangle aRect) {
        Container parent;
        int dx = this.getX();
        int dy = this.getY();
        for (parent = this.getParent(); parent != null && !(parent instanceof JComponent) && !(parent instanceof CellRendererPane); parent = parent.getParent()) {
            Rectangle bounds = parent.getBounds();
            dx += bounds.x;
            dy += bounds.y;
        }
        if (parent != null && !(parent instanceof CellRendererPane)) {
            aRect.x += dx;
            aRect.y += dy;
            ((JComponent)parent).scrollRectToVisible(aRect);
            aRect.x -= dx;
            aRect.y -= dy;
        }
    }

    public TreePath search(String name, boolean expand) {
        PObjectNode rootNode = (PObjectNode)this.tree.getModel().getRoot();
        return this.search(rootNode, name.toLowerCase(), expand);
    }

    public void updateUI() {
        super.updateUI();
        if (this.tree != null) {
            this.tree.updateUI();
        }
        LookAndFeel.installColorsAndFont(this, "Tree.background", "Tree.foreground", "Tree.font");
    }

    private void expandByPObjectName(PObjectNode root, String name) {
        ArrayList p1 = root.getChildren();
        if (p1 == null) {
            return;
        }
        for (int counter = 0; counter < p1.size(); ++counter) {
            PObjectNode pon;
            ArrayList<PObjectNode> path;
            PObjectNode node = (PObjectNode)p1.get(counter);
            if (!node.isLeaf()) {
                this.expandByPObjectName(node, name);
                continue;
            }
            Object theObj = node.getItem();
            if (theObj instanceof PObject) {
                if (!((PObject)theObj).getName().equals(name)) continue;
                path = new ArrayList<PObjectNode>();
                pon = node;
                while (pon.getParent() != null) {
                    path.add(0, pon.getParent());
                    pon = pon.getParent();
                }
                this.getTree().expandPath(new TreePath(path.toArray()));
                continue;
            }
            if (!(theObj instanceof SpellInfo) || !theObj.toString().equals(name)) continue;
            path = new ArrayList();
            pon = node;
            while (pon.getParent() != null) {
                path.add(0, pon.getParent());
                pon = pon.getParent();
            }
            this.getTree().expandPath(new TreePath(path.toArray()));
        }
    }

    private void scrollPathToVisible(TreePath path) {
        if (path != null) {
            this.tree.makeVisible(path);
            Rectangle bounds = this.tree.getPathBounds(path);
            if (bounds != null) {
                this.scrollRectToVisible(bounds);
            }
        }
    }

    private TreePath search(PObjectNode root, String name, boolean expand) {
        ArrayList p1 = root.getChildren();
        if (p1 != null) {
            for (int counter = 0; counter < p1.size(); ++counter) {
                String aString;
                PObjectNode node = (PObjectNode)p1.get(counter);
                if (!node.isLeaf()) {
                    TreePath tp = this.search(node, name, expand);
                    if (tp == null) continue;
                    return tp;
                }
                Object theObj = node.getItem();
                if (!(theObj instanceof PObject) || !(aString = SettingsHandler.guiUsesOutputName() ? ((PObject)theObj).getOutputName() : ((PObject)theObj).getName()).toLowerCase().startsWith(name)) continue;
                ArrayList<PObjectNode> path = new ArrayList<PObjectNode>();
                PObjectNode pon = node;
                while (pon.getParent() != null) {
                    path.add(0, pon.getParent());
                    pon = pon.getParent();
                }
                TreePath tpath = new TreePath(path.toArray());
                if (expand) {
                    this.tree.expandPath(tpath);
                }
                path.add(node);
                tpath = new TreePath(path.toArray());
                if (expand) {
                    this.scrollPathToVisible(tpath);
                    this.tree.setSelectionPath(tpath);
                }
                return tpath;
            }
        }
        return null;
    }

    private TreePath searchSingleLevel(PObjectNode root, String name, boolean select) {
        String lowerName = name.toLowerCase();
        ArrayList p1 = root.getChildren();
        if (p1 != null) {
            for (int counter = 0; counter < p1.size(); ++counter) {
                PObjectNode node = (PObjectNode)p1.get(counter);
                String aString = node.getNodeName();
                if (!aString.toLowerCase().startsWith(lowerName)) continue;
                ArrayList<PObjectNode> path = new ArrayList<PObjectNode>();
                PObjectNode pon = node;
                while (pon.getParent() != null) {
                    path.add(0, pon.getParent());
                    pon = pon.getParent();
                }
                path.add(node);
                TreePath tpath = new TreePath(path.toArray());
                if (select) {
                    this.scrollPathToVisible(tpath);
                    this.tree.setSelectionPath(tpath);
                }
                return tpath;
            }
        }
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private final class TreeTableCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private TreeTableCellEditor() {
        }

        public boolean isCellEditable(EventObject e) {
            if (e instanceof MouseEvent) {
                for (int counter = JTreeTable.this.getColumnCount() - 1; counter >= 0; --counter) {
                    if (JTreeTable.this.getColumnClass(counter) != (class$pcgen$gui$utils$TreeTableModel == null ? JTreeTable.class$("pcgen.gui.utils.TreeTableModel") : class$pcgen$gui$utils$TreeTableModel)) continue;
                    MouseEvent me = (MouseEvent)e;
                    MouseEvent newME = new MouseEvent(JTreeTable.this.tree, me.getID(), me.getWhen(), me.getModifiers(), me.getX(), me.getY(), me.getClickCount(), me.isPopupTrigger());
                    JTreeTable.this.tree.dispatchEvent(newME);
                    break;
                }
            }
            return false;
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int r, int c) {
            return JTreeTable.this.tree;
        }
    }

    private static final class TimedKeyBuffer {
        private String keyBuffer;
        private int timeToWait;
        private long lastMSecs;

        public TimedKeyBuffer(int msecs) {
            this.timeToWait = msecs;
            this.lastMSecs = 0L;
        }

        public String getString() {
            if (System.currentTimeMillis() > this.lastMSecs + (long)this.timeToWait) {
                return "";
            }
            return this.keyBuffer;
        }

        public void addChar(char character) {
            if (System.currentTimeMillis() > this.lastMSecs + (long)this.timeToWait) {
                this.keyBuffer = "";
            }
            this.keyBuffer = this.keyBuffer + String.valueOf(Character.toLowerCase(character));
            this.lastMSecs = System.currentTimeMillis();
        }

        public void clearBuffer() {
            this.keyBuffer = "";
        }
    }

    private final class ListToTreeSelectionModelWrapper
    extends DefaultTreeSelectionModel {
        static final long serialVersionUID = -3571248405124682593L;
        private boolean updatingListSelectionModel;

        private ListToTreeSelectionModelWrapper() {
            this.getListSelectionModel().addListSelectionListener(this.createListSelectionListener());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void resetRowSelection() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    super.resetRowSelection();
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        private ListSelectionModel getListSelectionModel() {
            return this.listSelectionModel;
        }

        private ListSelectionListener createListSelectionListener() {
            return new ListSelectionHandler();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateSelectedPathsFromSelectedRows() {
            if (!this.updatingListSelectionModel) {
                this.updatingListSelectionModel = true;
                try {
                    int[] sRows = JTreeTable.this.getSelectedRows();
                    if (sRows == null || sRows.length == 0) {
                        return;
                    }
                    int count = 0;
                    for (int i = 0; i < sRows.length; ++i) {
                        if (JTreeTable.this.tree.getPathForRow(sRows[i]) == null) continue;
                        ++count;
                    }
                    if (count == 0) {
                        return;
                    }
                    TreePath[] tps = new TreePath[count];
                    count = 0;
                    for (int i = 0; i < sRows.length; ++i) {
                        TreePath tp = JTreeTable.this.tree.getPathForRow(sRows[i]);
                        if (tp == null) continue;
                        tps[count++] = tp;
                    }
                    this.setSelectionPaths(tps);
                }
                finally {
                    this.updatingListSelectionModel = false;
                }
            }
        }

        final class ListSelectionHandler
        implements ListSelectionListener {
            ListSelectionHandler() {
            }

            public void valueChanged(ListSelectionEvent e) {
                ListToTreeSelectionModelWrapper.this.updateSelectedPathsFromSelectedRows();
            }
        }
    }

    final class TreeTableCellRenderer
    extends JTree
    implements TableCellRenderer {
        private int visibleRow;

        TreeTableCellRenderer(TreeModel model) {
            super(model);
        }

        public void setBounds(int x, int y, int w, int h) {
            super.setBounds(x, 0, w, JTreeTable.this.getHeight());
        }

        public void setRowHeight(int rowHeight) {
            if (rowHeight > 0) {
                super.setRowHeight(rowHeight);
                if (JTreeTable.this != null && JTreeTable.this.getRowHeight() != rowHeight) {
                    JTreeTable.this.setRowHeight(JTreeTable.this.getRowHeight());
                }
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            this.visibleRow = row;
            return this;
        }

        public String getUIClassID() {
            return "TreeTableUI";
        }

        public void paint(Graphics g) {
            g.translate(0, -this.visibleRow * JTreeTable.this.getRowHeight());
            super.paint(g);
        }

        public void updateUI() {
            super.updateUI();
            TreeCellRenderer tcr = this.getCellRenderer();
            if (tcr instanceof DefaultTreeCellRenderer) {
                DefaultTreeCellRenderer dtcr = (DefaultTreeCellRenderer)tcr;
                dtcr.setTextSelectionColor(UIManager.getColor("Table.selectionForeground"));
                dtcr.setBackgroundSelectionColor(UIManager.getColor("Table.selectionBackground"));
            }
        }
    }
}

