/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import pcgen.gui.utils.AbstractTreeTableModel;
import pcgen.gui.utils.JTreeTable;
import pcgen.gui.utils.PObjectNode;
import pcgen.util.Logging;

public final class JTreeTableSorter {
    private AbstractTreeTableModel tableModel;
    private JTreeTable tableView;
    private PObjectNode root;
    private boolean isAscending;
    private int mode = 0;
    private int prevAscending = 0;
    private int prevCol = 0;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Float;

    public JTreeTableSorter(JTreeTable table, PObjectNode obj, AbstractTreeTableModel model) {
        this.tableModel = model;
        final AbstractTreeTableModel tmodel = model;
        this.root = obj;
        this.tableView = table;
        table.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = JTreeTableSorter.this.tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = JTreeTableSorter.this.tableView.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column > -1) {
                    if (tmodel.getColumnClass(column).isAssignableFrom(class$java$lang$Integer == null ? (class$java$lang$Integer = JTreeTableSorter.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                        JTreeTableSorter.this.mode = 1;
                    } else if (tmodel.getColumnClass(column).isAssignableFrom(class$java$lang$Float == null ? (class$java$lang$Float = JTreeTableSorter.class$("java.lang.Float")) : class$java$lang$Float)) {
                        JTreeTableSorter.this.mode = 2;
                    } else {
                        JTreeTableSorter.this.mode = 0;
                    }
                    JTreeTableSorter.this.sortNodeOnColumn(JTreeTableSorter.this.root, column, e.getModifiers() & 1);
                    JTreeTableSorter.this.prevCol = column;
                    JTreeTableSorter.this.prevAscending = e.getModifiers() & 1;
                    JTreeTableSorter.this.updateSortModel();
                }
            }
        };
        JTableHeader th = table.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    public void setRoot(PObjectNode obj) {
        this.root = obj;
    }

    public PObjectNode sortNodeOnColumn() {
        return this.sortNodeOnColumn(this.root, this.prevCol, this.prevAscending);
    }

    private PObjectNode sortNodeOnColumn(PObjectNode node, int col, int ascending) {
        int i;
        ArrayList master = node.getChildren();
        if (master == null) {
            return node;
        }
        ArrayList itemsToSort = new ArrayList(master.size());
        for (i = 0; i < master.size(); ++i) {
            PObjectNode pi = (PObjectNode)master.get(i);
            ArrayList<Object> sortItem = new ArrayList<Object>(2);
            sortItem.add(pi);
            Object pir = null;
            try {
                pir = this.tableModel.getValueAt(pi, col);
            }
            catch (Exception exc) {
                Logging.errorPrint("", exc);
            }
            if (pir == null) continue;
            if (pir instanceof String) {
                pir = pir.toString().substring(pir.toString().lastIndexOf("|") + 1);
            }
            sortItem.add(pir);
            itemsToSort.add(sortItem);
        }
        this.isAscending = ascending == 0;
        Collections.sort(itemsToSort, new Comparator(){

            public int compare(Object obj1, Object obj2) {
                Object o1 = ((ArrayList)obj1).get(1);
                Object o2 = ((ArrayList)obj2).get(1);
                int iRet = -1;
                if (o1 instanceof Integer) {
                    iRet = ((Integer)o1).compareTo((Integer)o2);
                } else if (o1 instanceof String) {
                    String s1 = this.stripHTML((String)o1);
                    String s2 = this.stripHTML((String)o2);
                    iRet = s1.compareToIgnoreCase(s2);
                } else if (o1 instanceof Float) {
                    iRet = ((Float)o1).compareTo((Float)o2);
                } else if (o1 instanceof BigDecimal) {
                    iRet = ((BigDecimal)o1).compareTo((BigDecimal)o2);
                } else {
                    Logging.errorPrint("JTreeTableSorter: unknown compare class: " + o1.getClass().getName());
                }
                if (!JTreeTableSorter.this.isAscending) {
                    iRet *= -1;
                }
                return iRet;
            }

            private String stripHTML(String string) {
                int index = string.indexOf(60);
                int endIndex = string.indexOf(62);
                while (index != -1 && endIndex != -1) {
                    string = string.substring(0, index) + string.substring(endIndex + 1);
                    index = string.indexOf(60);
                    endIndex = string.indexOf(62);
                }
                return string;
            }
        });
        for (i = 0; i < itemsToSort.size(); ++i) {
            ArrayList sortItem = (ArrayList)itemsToSort.get(i);
            master.set(i, sortItem.get(0));
        }
        for (i = 0; i < master.size(); ++i) {
            PObjectNode nodule = (PObjectNode)master.get(i);
            if (nodule.isLeaf()) continue;
            this.sortNodeOnColumn(nodule, col, ascending);
        }
        return node;
    }

    private void updateSortModel() {
        List pathList = this.tableView.getExpandedPaths();
        this.tableModel.updateTree();
        this.tableView.updateUI();
        this.tableView.expandPathList(pathList);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

