/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.tree.TreeCellRenderer;
import pcgen.util.Logging;

public final class LabelTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    protected static final Color SelectedBackgroundColor = Color.white;
    private static Map fontMap = new HashMap();
    private Color myColor = Color.white;
    private boolean selected;

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean argSelected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        Font newFont;
        String stringValue;
        Font aFont = this.getFont();
        String fontName = aFont.getName();
        int iSize = aFont.getSize();
        try {
            stringValue = tree.convertValueToText(value, argSelected, expanded, leaf, row, hasFocus);
        }
        catch (Exception exc) {
            stringValue = "";
            Logging.errorPrint("problem converting in treecellrenderer", exc);
        }
        if (stringValue.length() > 1 && stringValue.charAt(1) == '|') {
            if (stringValue.charAt(0) == 'B') {
                stringValue = stringValue.substring(2, stringValue.length());
                newFont = LabelTreeCellRenderer.getFontFromMap(fontName, 1, iSize);
                this.setFont(newFont);
            } else if (stringValue.charAt(0) == 'I') {
                stringValue = stringValue.substring(2, stringValue.length());
                newFont = LabelTreeCellRenderer.getFontFromMap(fontName, 2, iSize);
                this.setFont(newFont);
            }
        } else {
            newFont = LabelTreeCellRenderer.getFontFromMap(fontName, 0, iSize);
            this.setFont(newFont);
        }
        int bi = stringValue.indexOf("|");
        int ei = stringValue.lastIndexOf("|");
        if (bi > -1 && bi != ei) {
            String aString = stringValue.substring(bi + 1, ei);
            this.myColor = new Color(Integer.parseInt(aString));
            stringValue = stringValue.substring(0, bi) + stringValue.substring(ei + 1);
            if (argSelected) {
                this.setBackground(this.myColor);
                this.setForeground(Color.white);
            } else {
                this.setForeground(this.myColor);
                this.setBackground(Color.white);
            }
        } else if (argSelected) {
            this.setForeground(Color.white);
            this.setBackground(Color.blue);
        } else {
            this.setForeground(Color.black);
            this.setBackground(Color.white);
        }
        this.setText(stringValue);
        this.selected = argSelected;
        return this;
    }

    private static Font getFontFromMap(String name, int type, int size) {
        String key = LabelTreeCellRenderer.getFontKey(name, type, size);
        Font theFont = (Font)fontMap.get(key);
        if (theFont == null) {
            theFont = new Font(name, type, size);
            fontMap.put(key, theFont);
        }
        return theFont;
    }

    private static String getFontKey(String name, int type, int size) {
        return name + "." + type + "." + size;
    }
}

