/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import pcgen.gui.utils.Hyperactive;
import pcgen.gui.utils.JLabelPane;
import pcgen.util.PropertyFactory;

public final class LinkableHtmlMessage
extends JDialog
implements ActionListener {
    static final long serialVersionUID = -3678273627369325170L;
    private static final String HTML_START = "<html><body style=\"margin-left: 5px;margin-right: 5px;margin-top: 5px\">";
    private static final String HTML_END = "</body></html>";
    private JButton btnClose;
    private JLabelPane msgText;

    public LinkableHtmlMessage(Frame owner, String msg, String title) {
        super(owner, title, true);
        this.commonInit(msg);
        this.setLocationRelativeTo(owner);
    }

    public LinkableHtmlMessage(Dialog owner, String msg, String title) {
        super(owner, title, true);
        this.commonInit(msg);
        this.setLocationRelativeTo(owner);
    }

    public void actionPerformed(ActionEvent e) {
        this.quit();
    }

    public void setVisible(boolean b) {
        if (b) {
            this.btnClose.grabFocus();
        }
        super.setVisible(b);
    }

    private void commonInit(String msg) {
        this.initUI();
        String newMsg = msg;
        int idx = 0;
        while ((idx = newMsg.indexOf(10, idx)) >= 0) {
            newMsg = newMsg.substring(0, idx) + "<br>" + newMsg.substring(idx + 1);
        }
        this.msgText.setBackground(this.btnClose.getBackground());
        this.msgText.setText(HTML_START + newMsg + HTML_END);
        this.repaint();
        this.pack();
    }

    private void initUI() {
        Container cont = this.getContentPane();
        GridBagLayout gl = new GridBagLayout();
        cont.setLayout(gl);
        Icon icon = UIManager.getIcon("OptionPane.warningIcon");
        GridBagConstraints gc = new GridBagConstraints();
        gc.anchor = 18;
        cont.add((Component)new JLabel(icon), gc);
        this.msgText = new JLabelPane();
        this.msgText.setBorder(null);
        this.msgText.addHyperlinkListener(new Hyperactive());
        gc = new GridBagConstraints();
        gc.fill = 2;
        gc.weightx = 1.0;
        gc.weighty = 1.0;
        cont.add(this.msgText);
        this.btnClose = new JButton(PropertyFactory.getString("in_ok"));
        this.btnClose.setMnemonic(PropertyFactory.getMnemonic("in_mn_ok"));
        this.btnClose.addActionListener(this);
        JPanel buttons = new JPanel();
        buttons.add(this.btnClose);
        gc = new GridBagConstraints();
        gc.gridy = 1;
        gc.gridwidth = 2;
        gc.weightx = 1.0;
        gc.insets = new Insets(5, 0, 5, 0);
        gc.anchor = 10;
        cont.add((Component)buttons, gc);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                LinkableHtmlMessage.this.quit();
            }
        });
        this.btnClose.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 27 || e.getKeyCode() == 10) {
                    LinkableHtmlMessage.this.quit();
                }
            }
        });
    }

    private void quit() {
        this.setVisible(false);
        this.dispose();
    }
}

