/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import pcgen.core.Domain;
import pcgen.core.Equipment;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.SettingsHandler;
import pcgen.core.character.CharacterSpell;
import pcgen.core.character.SpellInfo;
import pcgen.core.prereq.PrereqHandler;
import pcgen.gui.CharacterInfo;
import pcgen.gui.PCGen_Frame1;
import pcgen.util.Logging;
import pcgen.util.ResetableListIterator;

public class PObjectNode
implements Cloneable,
ResetableListIterator {
    private static PlayerCharacter aPC = null;
    public static final int NOT_A_FEAT = 0;
    public static final int CAN_GAIN_FEAT = 1;
    public static final int CAN_USE_FEAT = 2;
    private ArrayList children = null;
    private Object item = null;
    private PObjectNode parent = null;
    private boolean isValid = true;
    private int checkFeatState = 0;
    private int mark = 0;

    public PObjectNode() {
    }

    public PObjectNode(Object item) {
        this.setItem(item);
    }

    public void setCheckFeatState(int state) {
        this.checkFeatState = state;
        if (state != 0 && aPC == null) {
            aPC = Globals.getCurrentPC();
        }
    }

    public static PObjectNode getChild(Object parent, int i) {
        PObjectNode parentAsPObjectNode = (PObjectNode)parent;
        return parentAsPObjectNode.getChild(i);
    }

    public PObjectNode getChild(int i) {
        return (PObjectNode)this.children.get(i);
    }

    public static int getChildCount(Object parent) {
        PObjectNode parentAsPObjectNode = (PObjectNode)parent;
        return parentAsPObjectNode.getChildCount();
    }

    public int getChildCount() {
        return this.children == null ? 0 : this.children.size();
    }

    public void setChildren(ArrayList newChildren) {
        if (newChildren == null) {
            this.children = null;
            this.reset();
            return;
        }
        this.children = newChildren;
        Iterator it = this.children.iterator();
        while (it.hasNext()) {
            ((PObjectNode)it.next()).setParent(this);
        }
        this.reset();
    }

    public void setChildren(PObjectNode[] newChildren) {
        if (newChildren == null) {
            this.children = null;
            this.reset();
            return;
        }
        if (this.children == null) {
            this.children = new ArrayList(newChildren.length);
        } else {
            this.children.clear();
            this.children.ensureCapacity(newChildren.length);
        }
        for (int i = 0; i < newChildren.length; ++i) {
            newChildren[i].setParent(this);
            this.children.add(newChildren[i]);
        }
        this.reset();
    }

    public ArrayList getChildren() {
        return this.children;
    }

    public void pruneEmpty() {
        if (this.getChildCount() == 0) {
            return;
        }
        ListIterator it = this.children.listIterator();
        while (it.hasNext()) {
            PObjectNode node = (PObjectNode)it.next();
            if (node.isLeaf()) {
                if (node.getItem().toString().equals("")) continue;
                it.remove();
                continue;
            }
            if (node.getChildCount() <= 0) continue;
            node.pruneEmpty();
        }
    }

    public String getChoices() {
        Feat aFeat;
        StringBuffer aString = new StringBuffer();
        if (this.item != null && this.item instanceof Feat && (aFeat = (Feat)this.item).isMultiples()) {
            boolean addComma = false;
            for (int i = 0; i < aFeat.getAssociatedCount(true); ++i) {
                if (addComma) {
                    aString.append(',');
                } else {
                    addComma = true;
                }
                aString.append(aFeat.getAssociated(i, true));
            }
        }
        return aString.toString();
    }

    public void setIsValid(boolean aBool) {
        this.isValid = aBool;
    }

    public void setItem(Object anItem) {
        this.item = anItem;
    }

    public Object getItem() {
        return this.item;
    }

    public boolean isLeaf() {
        if (this.children == null) {
            return true;
        }
        return this.children.size() == 0;
    }

    public String getNodeName() {
        String name = null;
        if (this.item instanceof PObject) {
            name = SettingsHandler.guiUsesOutputName() ? ((PObject)this.item).getOutputName() : ((PObject)this.item).getName();
        } else if (this.item != null) {
            name = this.item.toString();
        }
        return name;
    }

    public void setParent(PObjectNode aNode) {
        this.parent = aNode;
    }

    public PObjectNode getParent() {
        return this.parent;
    }

    public String getSource() {
        if (this.item instanceof PObject) {
            return ((PObject)this.item).getSource();
        }
        return "";
    }

    public void add(Object obj) {
        throw new UnsupportedOperationException();
    }

    public void addChild(PObjectNode aChild) {
        aChild.setParent(this);
        if (this.children == null) {
            this.children = new ArrayList();
        }
        this.children.add(aChild);
    }

    public boolean addChild(PObjectNode aChild, boolean sort) {
        boolean added = true;
        if (!sort || this.children == null || aChild.item == null) {
            this.addChild(aChild);
        } else {
            int x;
            String itemName = aChild.item.toString();
            for (x = 0; x < this.children.size(); ++x) {
                Object childItem = ((PObjectNode)this.children.get(x)).getItem();
                int comp = 1;
                if (childItem != null) {
                    comp = itemName.compareToIgnoreCase(childItem.toString());
                }
                if (comp == 0) {
                    added = false;
                    break;
                }
                if (comp >= 0) continue;
                this.addChild(aChild, x);
                break;
            }
            if (x >= this.children.size()) {
                this.addChild(aChild);
            }
        }
        return added;
    }

    public boolean hasNext() {
        return this.mark < this.getChildCount();
    }

    public boolean hasPrevious() {
        return this.mark > 0;
    }

    public Object next() {
        return this.getChild(this.mark++);
    }

    public int nextIndex() {
        return this.mark;
    }

    public Object previous() {
        return this.getChild(--this.mark);
    }

    public int previousIndex() {
        return this.mark - 1;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public void removeItemFromNodes(Object e) {
        if (this.isChildless() && this.getItem().equals(e)) {
            this.getParent().removeChild(this);
        } else {
            this.reset();
            while (this.hasNext()) {
                ((PObjectNode)this.next()).removeItemFromNodes(e);
            }
        }
    }

    public void reset() {
        this.mark = 0;
    }

    public static void resetPC() {
        aPC = Globals.getCurrentPC();
    }

    public Object clone() {
        PObjectNode retVal = null;
        try {
            retVal = (PObjectNode)super.clone();
            ArrayList<PObjectNode> d = null;
            if (this.children != null) {
                d = new ArrayList<PObjectNode>(this.children.size());
                Iterator it = this.children.iterator();
                while (it.hasNext()) {
                    PObjectNode node = (PObjectNode)((PObjectNode)it.next()).clone();
                    d.add(node);
                }
            }
            retVal.setChildren(d);
        }
        catch (CloneNotSupportedException exc) {
            Logging.errorPrint("ERROR:", exc);
        }
        return retVal;
    }

    public void set(Object obj) {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        if (this.item == null) {
            return "";
        }
        if (this.item instanceof PObject) {
            CharacterInfo cp;
            String itemName = ((PObject)this.item).piString();
            if (this.checkFeatState != 0) {
                Feat aFeat = (Feat)this.item;
                switch (aFeat.getFeatType()) {
                    case 0: {
                        return this.handleCheckFeatState(aFeat, itemName);
                    }
                    case 1: {
                        return "|" + SettingsHandler.getFeatAutoColor() + "|" + itemName;
                    }
                    case 2: {
                        return "|" + SettingsHandler.getFeatVirtualColor() + "|" + itemName;
                    }
                }
                Logging.errorPrint("Default getFeatType:" + aFeat.getName());
                return "|" + SettingsHandler.getPrereqFailColor() + "|" + itemName;
            }
            if (this.item instanceof Equipment) {
                Equipment e = (Equipment)this.item;
                if (e.isAutomatic()) {
                    return "|" + SettingsHandler.getFeatAutoColor() + "|" + itemName;
                }
                if ((e.isShield() || e.isWeapon() || e.isArmor()) && (aPC == null || !aPC.isProficientWith(e))) {
                    Color aColor = Color.red;
                    if (SettingsHandler.getPrereqFailColor() != 0) {
                        aColor = new Color(SettingsHandler.getPrereqFailColor());
                    }
                    return "|" + aColor.getRGB() + "|" + itemName;
                }
                return itemName;
            }
            if (this.item instanceof Race && (cp = PCGen_Frame1.getCharacterPane()) != null && cp.getSelectedIndex() == cp.indexOfTab("Resources")) {
                return itemName;
            }
            if (this.item instanceof PCClass) {
                String subClass = ((PCClass)this.item).getDisplayClassName();
                if (!((PCClass)this.item).getName().equals(subClass)) {
                    itemName = itemName + "/" + subClass;
                }
            }
            if (!PrereqHandler.passesAll(((PObject)this.item).getPreReqList(), Globals.getCurrentPC(), (PObject)this.item)) {
                Color aColor = Color.red;
                if (SettingsHandler.getPrereqFailColor() != 0) {
                    aColor = new Color(SettingsHandler.getPrereqFailColor());
                }
                return "|" + aColor.getRGB() + "|" + itemName;
            }
            return itemName;
        }
        if (this.item instanceof SpellInfo) {
            CharacterSpell spellA = ((SpellInfo)this.item).getOwner();
            boolean isSpecial = spellA.isSpecialtySpell();
            int times = ((SpellInfo)this.item).getTimes();
            StringBuffer val = new StringBuffer(80);
            val.append(spellA.getSpell().piSubString());
            val.append(this.item.toString());
            if (isSpecial && spellA.getOwner() instanceof Domain) {
                val.append(" [").append(spellA.getOwner().getName()).append(']');
            }
            if (times > 1) {
                val.append(" (").append(((SpellInfo)this.item).getTimes()).append(')');
            }
            if (val.toString().indexOf(60) >= 0) {
                val.insert(0, "<html>");
                val.append("</html>");
            }
            return val.toString();
        }
        if (this.item instanceof PlayerCharacter) {
            PlayerCharacter bPC = (PlayerCharacter)this.item;
            return bPC.getName();
        }
        return this.item.toString();
    }

    private boolean isChildless() {
        return this.getChildCount() == 0;
    }

    private void addChild(PObjectNode aChild, int index) {
        aChild.setParent(this);
        if (this.children == null) {
            this.children = new ArrayList();
            this.children.add(aChild);
        } else {
            this.children.add(index, aChild);
        }
    }

    private String handleCheckFeatState(Feat aFeat, String itemName) {
        switch (this.checkFeatState) {
            case 1: {
                if (PrereqHandler.passesAll(aFeat.getPreReqList(), Globals.getCurrentPC(), aFeat)) {
                    return "|" + SettingsHandler.getPrereqQualifyColor() + "|" + itemName;
                }
                return "|" + SettingsHandler.getPrereqFailColor() + "|" + itemName;
            }
            case 2: {
                if (PrereqHandler.passesAll(aFeat.getPreReqList(), Globals.getCurrentPC(), aFeat)) {
                    return "|" + SettingsHandler.getPrereqQualifyColor() + "|" + itemName;
                }
                return "|" + SettingsHandler.getPrereqFailColor() + "|" + itemName;
            }
        }
        Logging.errorPrint("Bad feat state: " + this.checkFeatState + ".  Please report this as a bug.");
        return itemName;
    }

    private boolean removeChild(PObjectNode aChild) {
        if (this.children == null || this.children.indexOf(aChild) == -1) {
            return false;
        }
        ListIterator it = this.children.listIterator();
        while (it.hasNext()) {
            if (it.next() != aChild) continue;
            it.remove();
        }
        return true;
    }
}

