/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.table.TableColumn;
import pcgen.core.Globals;
import pcgen.gui.utils.JTableEx;

public final class ResizeColumnListener
implements PropertyChangeListener {
    private JTableEx table;
    private String colFrom;
    private boolean colChange = false;
    private boolean mouseIsDown = true;
    private int colIndex;

    public ResizeColumnListener(JTableEx fromTable, String fromString, int fromIndex) {
        this.table = fromTable;
        this.colFrom = fromString;
        this.colIndex = fromIndex;
        this.mouseIsDown = false;
        this.colChange = false;
        this.table.getTableHeader().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                ResizeColumnListener.this.mouseIsDown = true;
            }

            public void mouseReleased(MouseEvent evt) {
                ResizeColumnListener.this.mouseIsDown = false;
                if (ResizeColumnListener.this.colChange) {
                    TableColumn col = ResizeColumnListener.this.table.getColumnModel().getColumn(ResizeColumnListener.this.colIndex);
                    int colWidth = col.getWidth();
                    Globals.setCustColumnWidth(ResizeColumnListener.this.colFrom, ResizeColumnListener.this.colIndex, colWidth);
                    ResizeColumnListener.this.colChange = false;
                }
            }
        });
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("width") && this.mouseIsDown) {
            this.colChange = true;
        }
    }
}

