/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.JTableEx;
import pcgen.gui.utils.TableSorter;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;
import pcgen.util.chooser.ChooserInterface;

public final class SwingChooser
extends JDialog
implements ChooserInterface {
    static final long serialVersionUID = -2148735105737308335L;
    private static String in_available;
    private static String in_selected;
    private static String in_completeMess;
    private static String in_chooser;
    private static String in_selRemain;
    private static String in_validItem;
    private static String in_deselectOne;
    private static String in_noRemain;
    private static String in_addOne;
    private static String in_selectPartA;
    private static String in_selectPartB;
    private static String in_alreadySelected;
    private static String in_closeChooserTip;
    private static String in_pressToAdd;
    private static String in_pressToRemove;
    private static String in_removeOne;
    private static final List AVAILABLE_COLUMN_NAMES;
    private static final List SELECTED_COLUMN_NAMES;
    private static final String[] STRING_ARRAY;
    private ChooserTableModel mAvailableModel = new ChooserTableModel();
    private ChooserTableModel mSelectedModel = new ChooserTableModel();
    private JButton mAddButton;
    private JButton mCloseButton;
    private JButton mRemoveButton;
    private JLabel mPoolText;
    private JLabelPane mMessageText;
    private JTableEx mAvailableTable;
    private JTableEx mSelectedTable;
    private List mAvailableColumnNames;
    private List mAvailableList = new ArrayList();
    private List mSelectedColumnNames;
    private List mSelectedList = new ArrayList();
    private List mUniqueList = new ArrayList();
    private String mSelectedTerminator = "";
    private Object[][] mAvailableData;
    private Object[][] mSelectedData;
    private boolean canGoNegative = false;
    private boolean mAllowDuplicates = false;
    private boolean mPoolFlag = true;
    private int mCostColumnNumber = -1;
    private int mPool;

    public SwingChooser() {
        super(Globals.getCurrentFrame());
        this.initComponents();
    }

    public void setAllowsDups(boolean aBool) {
        this.mAllowDuplicates = aBool;
    }

    public void setAvailableList(List availableList) {
        String line;
        List<String> columnList = null;
        if (availableList != null && availableList.size() >= 2 && (line = availableList.get(1).toString()).length() == 0) {
            availableList = new ArrayList(availableList);
            availableList.remove(1);
            line = (String)availableList.remove(0);
            columnList = Arrays.asList(SwingChooser.parseString(line));
        }
        this.setAvailableList(availableList, columnList);
    }

    public void setCostColumnNumber(int costColumnNumber) {
        this.mCostColumnNumber = costColumnNumber;
    }

    public void setMessageText(String argMessageText) {
        String messageText = argMessageText == null || argMessageText.trim().length() == 0 ? "<html>&nbsp;</html>" : argMessageText;
        this.mMessageText.setText(messageText);
    }

    public void setNegativeAllowed(boolean argFlag) {
        this.canGoNegative = argFlag;
    }

    public void setPool(int anInt) {
        this.mPool = anInt;
        this.mPoolText.setText(Integer.toString(this.mPool));
    }

    public int getPool() {
        return this.mPool;
    }

    public void setPoolFlag(boolean poolFlag) {
        this.mPoolFlag = poolFlag;
    }

    public void setSelectedList(List selectedList) {
        this.setSelectedList(selectedList, null);
    }

    public ArrayList getSelectedList() {
        return new ArrayList(this.mSelectedList);
    }

    public void setSelectedListTerminator(String aString) {
        this.mSelectedTerminator = aString;
    }

    public void setUniqueList(List uniqueList) {
        this.mUniqueList = uniqueList;
    }

    public void setVisible(boolean b) {
        int method;
        this.updateAvailableTable();
        this.updateSelectedTable();
        this.updateButtonStates();
        if (this.mAvailableData != null && this.mAvailableData.length == 1 && (method = SettingsHandler.getSingleChoicePreference()) != 0) {
            this.mAvailableTable.changeSelection(0, 0, false, false);
            this.updateButtonStates();
            if (this.mAddButton.isEnabled()) {
                this.selectAvailable();
                if (method == 2 && this.close()) {
                    return;
                }
            }
        }
        Window owner = this.getOwner();
        Rectangle ownerBounds = owner.getBounds();
        Rectangle bounds = this.getBounds();
        int width = (int)bounds.getWidth();
        int height = (int)bounds.getHeight();
        this.setBounds((int)((double)owner.getX() + (ownerBounds.getWidth() - (double)width) / 2.0), (int)((double)owner.getY() + (ownerBounds.getHeight() - (double)height) / 2.0), width, height);
        super.setVisible(b);
    }

    private int getAdjustment(JTableEx tbl) {
        TableModel tableModel = tbl.getModel();
        int selectedRow = tbl.getSelectedRow();
        int adjustment = 1;
        if (this.mCostColumnNumber >= 0 && this.mCostColumnNumber < tbl.getColumnCount()) {
            try {
                adjustment = Integer.parseInt(tableModel.getValueAt(selectedRow, this.mCostColumnNumber).toString());
            }
            catch (NumberFormatException exc) {
                // empty catch block
            }
        }
        return adjustment;
    }

    private void setAvailableColumnNames(List availableColumnNames) {
        this.mAvailableColumnNames = availableColumnNames;
        this.mAvailableModel.setColumnsNames(availableColumnNames == null ? SwingChooser.STRING_ARRAY : availableColumnNames.toArray(SwingChooser.STRING_ARRAY));
    }

    private void setAvailableList(List availableList, List columnNames) {
        this.mAvailableList = availableList;
        if (columnNames != null) {
            if (this.mAvailableColumnNames != null && columnNames.size() == this.mAvailableColumnNames.size()) {
                int length = columnNames.size();
                for (int i = 0; i < length; ++i) {
                    if (columnNames.get(i).equals(this.mAvailableColumnNames.get(i))) continue;
                    this.setAvailableColumnNames(columnNames);
                    break;
                }
            } else {
                this.setAvailableColumnNames(columnNames);
            }
        } else if (this.mAvailableColumnNames != AVAILABLE_COLUMN_NAMES) {
            this.setAvailableColumnNames(columnNames);
        }
    }

    private void setSelectedColumnNames(List selectedColumnNames) {
        this.mSelectedColumnNames = selectedColumnNames;
        this.mSelectedModel.setColumnsNames(selectedColumnNames == null ? SwingChooser.STRING_ARRAY : selectedColumnNames.toArray(SwingChooser.STRING_ARRAY));
    }

    private void setSelectedList(List selectedList, List columnNames) {
        this.mSelectedList = selectedList;
        if (columnNames != null) {
            if (this.mSelectedColumnNames != null && columnNames.size() == this.mSelectedColumnNames.size()) {
                int length = columnNames.size();
                for (int i = 0; i < length; ++i) {
                    if (columnNames.get(i).equals(this.mSelectedColumnNames.get(i))) continue;
                    this.setSelectedColumnNames(columnNames);
                    break;
                }
            } else {
                this.setSelectedColumnNames(columnNames);
            }
        } else if (this.mSelectedColumnNames != SELECTED_COLUMN_NAMES) {
            this.setSelectedColumnNames(columnNames);
        }
    }

    private boolean close() {
        if (this.mPool <= 0 || !this.mPoolFlag) {
            this.setVisible(false);
            return true;
        }
        this.setMessageText(in_completeMess);
        return false;
    }

    private void initComponents() {
        this.setModal(true);
        this.setSize(new Dimension(640, 400));
        this.setTitle(in_chooser);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        this.mAvailableModel = new ChooserTableModel();
        TableSorter sorter = new TableSorter(this.mAvailableModel);
        this.mAvailableTable = new JTableEx(sorter);
        JScrollPane availableScrollPane = new JScrollPane(this.mAvailableTable);
        availableScrollPane.setVerticalScrollBarPolicy(20);
        availableScrollPane.setHorizontalScrollBarPolicy(30);
        sorter.addMouseListenerToHeaderInTable(this.mAvailableTable);
        this.mSelectedModel = new ChooserTableModel();
        sorter = new TableSorter(this.mSelectedModel);
        this.mSelectedTable = new JTableEx(sorter);
        JScrollPane selectedScrollPane = new JScrollPane(this.mSelectedTable);
        selectedScrollPane.setVerticalScrollBarPolicy(20);
        selectedScrollPane.setHorizontalScrollBarPolicy(30);
        sorter.addMouseListenerToHeaderInTable(this.mSelectedTable);
        ListSelectionModel availableSelectionModel = this.mAvailableTable.getSelectionModel();
        ListSelectionModel selectedSelectionModel = this.mSelectedTable.getSelectionModel();
        availableSelectionModel.setSelectionMode(0);
        selectedSelectionModel.setSelectionMode(0);
        ListSelectionListener listSelectionListener = new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                if (!evt.getValueIsAdjusting()) {
                    SwingChooser.this.updateButtonStates();
                }
            }
        };
        availableSelectionModel.addListSelectionListener(listSelectionListener);
        selectedSelectionModel.addListSelectionListener(listSelectionListener);
        this.mAvailableTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    SwingChooser.this.selectAvailable();
                }
            }
        });
        this.mSelectedTable.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() == 2) {
                    SwingChooser.this.removeSelected();
                }
            }
        });
        JLabel selectionRemainingLabel = new JLabel(in_selRemain + ": ");
        this.mMessageText = new JLabelPane();
        this.mMessageText.setBackground(contentPane.getBackground());
        this.setMessageText(null);
        this.mPoolText = new JLabel(" ");
        this.mAddButton = new JButton(PropertyFactory.getString("in_add"));
        this.mAddButton.setMnemonic(PropertyFactory.getMnemonic("in_mn_add"));
        this.mCloseButton = new JButton(PropertyFactory.getString("in_close"));
        this.mCloseButton.setMnemonic(PropertyFactory.getMnemonic("in_mn_close"));
        this.mRemoveButton = new JButton(PropertyFactory.getString("in_remove"));
        this.mRemoveButton.setMnemonic(PropertyFactory.getMnemonic("in_mn_remove"));
        ActionListener eventListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == SwingChooser.this.mAddButton) {
                    SwingChooser.this.selectAvailable();
                } else if (evt.getSource() == SwingChooser.this.mRemoveButton) {
                    SwingChooser.this.removeSelected();
                } else if (evt.getSource() == SwingChooser.this.mCloseButton) {
                    SwingChooser.this.close();
                }
            }
        };
        this.mAddButton.addActionListener(eventListener);
        this.mRemoveButton.addActionListener(eventListener);
        this.mCloseButton.addActionListener(eventListener);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 0;
        constraints.gridwidth = 3;
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(4, 4, 4, 4);
        contentPane.add((Component)availableScrollPane, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 3;
        constraints.weighty = 0.01;
        constraints.insets = new Insets(0, 4, 4, 4);
        contentPane.add((Component)this.mAddButton, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.gridwidth = 3;
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.weighty = 1.0;
        constraints.insets = new Insets(0, 4, 4, 4);
        contentPane.add((Component)selectedScrollPane, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 3;
        constraints.weighty = 0.01;
        constraints.insets = new Insets(0, 4, 4, 4);
        contentPane.add((Component)this.mRemoveButton, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 2;
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.weighty = 0.01;
        constraints.insets = new Insets(0, 4, 4, 4);
        contentPane.add((Component)this.mMessageText, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 5;
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.weighty = 0.01;
        constraints.insets = new Insets(0, 4, 4, 0);
        contentPane.add((Component)selectionRemainingLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 1;
        constraints.gridy = 5;
        constraints.fill = 1;
        constraints.anchor = 17;
        constraints.weightx = 1.0;
        constraints.weighty = 0.01;
        constraints.insets = new Insets(0, 4, 4, 0);
        contentPane.add((Component)this.mPoolText, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 2;
        constraints.gridy = 5;
        constraints.anchor = 13;
        constraints.weighty = 0.01;
        constraints.insets = new Insets(0, 4, 4, 4);
        contentPane.add((Component)this.mCloseButton, constraints);
    }

    private static String[] parseString(String string) {
        StringTokenizer tokenizer = new StringTokenizer(string, "\t");
        String[] results = new String[tokenizer.countTokens()];
        int s = 0;
        while (tokenizer.hasMoreTokens()) {
            results[s] = tokenizer.nextToken();
            ++s;
        }
        return results;
    }

    private void removeSelected() {
        this.setMessageText(null);
        if (this.mSelectedTable.getSelectedRowCount() == 0) {
            this.setMessageText(in_validItem);
            return;
        }
        if (this.mSelectedTable.getSelectedRowCount() > 1) {
            this.setMessageText(in_deselectOne);
            return;
        }
        int selectedRow = this.mSelectedTable.getSelectedRow();
        this.setPool(this.getPool() + this.getAdjustment(this.mSelectedTable));
        this.mSelectedList.remove(selectedRow);
        this.updateSelectedTable();
        this.updateButtonStates();
    }

    private void selectAvailable() {
        this.setMessageText(null);
        if (this.getPool() <= 0) {
            this.setMessageText(in_noRemain);
            return;
        }
        int selectedRow = this.mAvailableTable.getSelectedRow();
        if (selectedRow < 0) {
            this.setMessageText(in_validItem);
            return;
        }
        if (this.mAvailableTable.getSelectedRowCount() > 1) {
            this.setMessageText(in_addOne);
            return;
        }
        TableModel availableModel = this.mAvailableTable.getModel();
        String addString = availableModel.getValueAt(selectedRow, 0).toString();
        if (this.mUniqueList.contains(addString)) {
            this.setMessageText(in_selectPartA + " " + addString + " " + in_selectPartB);
            return;
        }
        TableModel selectedModel = this.mSelectedTable.getModel();
        int count = selectedModel.getRowCount();
        for (int i = 0; i < count; ++i) {
            String aString = selectedModel.getValueAt(i, 0).toString();
            if (!addString.equals(aString) || this.mAllowDuplicates) continue;
            this.setMessageText(addString + " " + in_alreadySelected);
            return;
        }
        int adjustment = this.getAdjustment(this.mAvailableTable);
        if (this.getPool() - adjustment < 0 && !this.canGoNegative) {
            this.setMessageText(in_noRemain);
            return;
        }
        StringBuffer buffer = new StringBuffer();
        int selectedColumns = selectedModel.getColumnCount();
        if (selectedColumns > 0) {
            buffer.append(availableModel.getValueAt(selectedRow, 0));
            for (int i = 1; i < selectedColumns; ++i) {
                buffer.append('\t');
                buffer.append(availableModel.getValueAt(selectedRow, i));
            }
        }
        this.mSelectedList.add(buffer.toString());
        this.updateSelectedTable();
        this.setPool(this.getPool() - adjustment);
        this.updateButtonStates();
    }

    private void updateAvailableTable() {
        int selected;
        if (this.mAvailableColumnNames == null) {
            this.setAvailableColumnNames(AVAILABLE_COLUMN_NAMES);
        }
        String selectedValue = null;
        if (this.mAvailableData != null && this.mAvailableData.length > 0 && (selected = this.mAvailableTable.getSelectedRow()) >= 0) {
            selectedValue = this.mAvailableData[selected][0].toString();
        }
        ListSelectionModel listSelectionModel = this.mAvailableTable.getSelectionModel();
        listSelectionModel.clearSelection();
        this.mAvailableData = new Object[this.mAvailableList.size()][];
        int row = 0;
        Iterator it = this.mAvailableList.iterator();
        while (it.hasNext()) {
            this.mAvailableData[row++] = SwingChooser.parseString(it.next().toString());
        }
        this.mAvailableModel.setData(this.mAvailableData);
        if (selectedValue != null) {
            int length = this.mAvailableModel.getRowCount();
            for (int i = 0; i < length; ++i) {
                String string = this.mAvailableModel.getValueAt(i, 0).toString();
                if (!selectedValue.equals(string)) continue;
                listSelectionModel.setSelectionInterval(i, i);
                break;
            }
        }
    }

    private void updateButtonStates() {
        String removeToolTip;
        String addToolTip;
        int count;
        String closeToolTip;
        boolean addEnabled = false;
        boolean removeEnabled = false;
        boolean closeEnabled = false;
        if (this.mPool > 0) {
            if (!this.mPoolFlag) {
                closeEnabled = true;
                closeToolTip = in_closeChooserTip;
            } else {
                closeToolTip = in_completeMess;
            }
            count = this.mAvailableTable.getSelectedRowCount();
            if (count == 1) {
                int availableRow = this.mAvailableTable.getSelectedRow();
                if (availableRow >= 0 && availableRow < this.mAvailableTable.getRowCount()) {
                    TableModel tableModel = this.mAvailableTable.getModel();
                    String addString = tableModel.getValueAt(availableRow, 0).toString();
                    if (!this.mUniqueList.contains(addString)) {
                        addEnabled = true;
                        addToolTip = in_pressToAdd + " " + addString;
                        int length = this.mSelectedTable.getRowCount();
                        for (int i = 0; i < length; ++i) {
                            String string = this.mSelectedModel.getValueAt(i, 0).toString();
                            if (!addString.equals(string) || this.mAllowDuplicates) continue;
                            addEnabled = false;
                            addToolTip = addString + " " + in_alreadySelected;
                        }
                    } else {
                        addToolTip = in_selectPartA + " " + addString + " " + in_selectPartB;
                    }
                } else {
                    addToolTip = in_validItem;
                }
            } else {
                addToolTip = count == 0 ? in_validItem : in_addOne;
            }
        } else {
            addToolTip = in_noRemain;
            closeToolTip = in_closeChooserTip;
            closeEnabled = true;
        }
        count = this.mSelectedTable.getSelectedRowCount();
        if (count == 1) {
            int selectedRow = this.mSelectedTable.getSelectedRow();
            if (selectedRow >= 0 && selectedRow < this.mSelectedTable.getRowCount()) {
                removeEnabled = true;
                removeToolTip = in_pressToRemove + " " + this.mSelectedTable.getModel().getValueAt(selectedRow, 0) + ".";
            } else {
                removeToolTip = in_validItem;
            }
        } else {
            removeToolTip = count == 0 ? in_validItem : in_removeOne;
        }
        this.mAddButton.setEnabled(addEnabled);
        this.mCloseButton.setEnabled(closeEnabled);
        this.mRemoveButton.setEnabled(removeEnabled);
        Utility.setDescription(this.mAddButton, addToolTip);
        Utility.setDescription(this.mCloseButton, closeToolTip);
        Utility.setDescription(this.mRemoveButton, removeToolTip);
    }

    private void updateSelectedTable() {
        int selected;
        String selectedValue = null;
        if (this.mSelectedData != null && this.mSelectedData.length > 0 && (selected = this.mSelectedTable.getSelectedRow()) >= 0) {
            selectedValue = this.mSelectedData[selected][0].toString();
        }
        ListSelectionModel listSelectionModel = this.mSelectedTable.getSelectionModel();
        listSelectionModel.clearSelection();
        if (this.mSelectedColumnNames == null) {
            this.setSelectedColumnNames(this.mAvailableColumnNames == AVAILABLE_COLUMN_NAMES ? SELECTED_COLUMN_NAMES : this.mAvailableColumnNames);
        }
        this.mSelectedData = new Object[this.mSelectedList.size()][];
        int row = 0;
        Iterator it = this.mSelectedList.iterator();
        while (it.hasNext()) {
            this.mSelectedData[row++] = SwingChooser.parseString(it.next().toString());
        }
        this.mSelectedModel.setData(this.mSelectedData, this.mSelectedTerminator);
        if (selectedValue != null) {
            int length = this.mSelectedModel.getRowCount();
            for (int i = 0; i < length; ++i) {
                String string = this.mSelectedModel.getValueAt(i, 0).toString();
                if (!selectedValue.equals(string)) continue;
                listSelectionModel.setSelectionInterval(i, i);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Locale currentLocale = new Locale(Globals.getLanguage(), Globals.getCountry());
        try {
            ResourceBundle chooserProperties = ResourceBundle.getBundle("pcgen/gui/prop/LanguageBundle", currentLocale);
            in_available = chooserProperties.getString("in_available");
            in_selected = chooserProperties.getString("in_selected");
            in_completeMess = chooserProperties.getString("in_completeMess");
            in_chooser = chooserProperties.getString("in_chooser");
            in_selRemain = chooserProperties.getString("in_selRemain");
            in_validItem = chooserProperties.getString("in_validItem");
            in_deselectOne = chooserProperties.getString("in_deselectOne");
            in_noRemain = chooserProperties.getString("in_noRemain");
            in_addOne = chooserProperties.getString("in_addOne");
            in_selectPartA = chooserProperties.getString("in_selectPartA");
            in_selectPartB = chooserProperties.getString("in_selectPartB");
            in_alreadySelected = chooserProperties.getString("in_alreadySelected");
            in_closeChooserTip = chooserProperties.getString("in_closeChooserTip");
            in_pressToAdd = chooserProperties.getString("in_pressToAdd");
            in_pressToRemove = chooserProperties.getString("in_pressToRemove");
            in_removeOne = chooserProperties.getString("in_removeOne");
        }
        catch (MissingResourceException mrex) {
            Logging.errorPrint("Exception in SwingChooser constructor", mrex);
        }
        finally {
            Object chooserProperties = null;
        }
        AVAILABLE_COLUMN_NAMES = Arrays.asList(in_available);
        SELECTED_COLUMN_NAMES = Arrays.asList(in_selected);
        STRING_ARRAY = new String[0];
    }

    private static class ChooserTableModel
    extends AbstractTableModel {
        static final long serialVersionUID = -2148735105737308335L;
        String lineTerminator = "";
        Class[] mColumnClasses;
        String[] mColumnNames;
        Object[][] mData;
        int mColumns;
        int mRows;

        private ChooserTableModel() {
        }

        public boolean isCellEditable(int row, int col) {
            return false;
        }

        public Class getColumnClass(int column) {
            return this.mColumnClasses[column];
        }

        public int getColumnCount() {
            return this.mColumns;
        }

        public String getColumnName(int column) {
            return this.mColumnNames[column];
        }

        public int getRowCount() {
            return this.mRows;
        }

        public void setValueAt(Object value, int row, int column) {
            this.mData[row][column] = value;
        }

        public Object getValueAt(int row, int col) {
            int idx;
            Object obj = this.mData[row][col];
            if (obj instanceof String && this.lineTerminator.length() != 0 && (idx = ((String)obj).indexOf(this.lineTerminator)) > -1) {
                obj = ((String)obj).substring(0, idx);
            }
            return obj;
        }

        private void setColumnsNames(String[] names) {
            this.mColumnNames = names;
            this.mColumns = this.mColumnNames.length;
            this.fireTableStructureChanged();
        }

        private void setData(Object[][] data) {
            this.setData(data, "");
        }

        private void setData(Object[][] data, String lineTerminator) {
            this.mData = data;
            this.mRows = 0;
            this.mColumnClasses = new Class[this.mColumns];
            this.lineTerminator = lineTerminator;
            if (this.mData != null) {
                this.mRows = this.mData.length;
                if (this.mRows > 0) {
                    Object[] row = data[0];
                    for (int c = 0; c < this.mColumns; ++c) {
                        this.mColumnClasses[c] = row[c].getClass();
                    }
                }
            }
            this.fireTableChanged(new TableModelEvent(this, 0, this.mRows - 1, -1, 1));
        }
    }
}

