/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import pcgen.core.Globals;
import pcgen.gui.utils.JComboBoxEx;
import pcgen.gui.utils.JLabelPane;
import pcgen.gui.utils.Utility;
import pcgen.util.Logging;
import pcgen.util.chooser.ChooserRadio;

public final class SwingChooserRadio
extends JDialog
implements ChooserRadio {
    static final long serialVersionUID = -2156072283857697398L;
    private static String in_available;
    private static String in_ok;
    private static String in_cancel;
    private ButtonGroup avaGroup = null;
    private JComboBoxEx cmbCombo;
    private final JPanel avaPane = new JPanel();
    private JButton cancelButton;
    private JButton okButton;
    private JLabelPane mMessageText;
    private JRadioButton lblCombo;
    private List mAvailableList = new ArrayList();
    private List mSelectedList = new ArrayList();
    private JRadioButton[] avaRadioButton = null;

    public SwingChooserRadio() {
        super(Globals.getRootFrame());
        this.initComponents();
    }

    public void setAvailableList(List availableList) {
        this.mAvailableList = availableList;
    }

    public void setComboData(String cmbLabelText, List cmbData) {
        this.cmbCombo = new JComboBoxEx(cmbData.toArray());
        ((DefaultComboBoxModel)this.cmbCombo.getModel()).insertElementAt("(None)", 0);
        this.cmbCombo.setSelectedIndex(0);
        this.cmbCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1 && SwingChooserRadio.this.cmbCombo.getSelectedIndex() > 0) {
                    SwingChooserRadio.this.lblCombo.setSelected(true);
                }
            }
        });
        this.lblCombo = new JRadioButton(cmbLabelText);
        this.lblCombo.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (!SwingChooserRadio.this.lblCombo.isSelected()) {
                    SwingChooserRadio.this.cmbCombo.setSelectedIndex(0);
                } else if (SwingChooserRadio.this.cmbCombo.getSelectedIndex() == 0) {
                    SwingChooserRadio.this.cmbCombo.setSelectedIndex(1);
                }
            }
        });
    }

    public void setMessageText(String messageText) {
        if (messageText == null || messageText.trim().length() == 0) {
            messageText = "<html>&nbsp;</html>";
        }
        this.mMessageText.setText(messageText);
    }

    public ArrayList getSelectedList() {
        return new ArrayList(this.mSelectedList);
    }

    public void setVisible(boolean b) {
        if (b) {
            this.updateAvailableTable();
            this.setLocationRelativeTo(this.getOwner());
            super.pack();
            this.pack();
            if (this.getWidth() < 120) {
                this.setSize(120, this.getHeight());
            }
        }
        super.setVisible(b);
    }

    private void setData(List data) {
        int mRows = 0;
        this.avaRadioButton = new JRadioButton[data.size()];
        this.avaGroup = new ButtonGroup();
        Iterator aV = data.iterator();
        while (aV.hasNext()) {
            String aString = (String)aV.next();
            if (aString.length() <= 0) continue;
            this.avaRadioButton[mRows] = new JRadioButton(aString, false);
            this.avaGroup.add(this.avaRadioButton[mRows]);
            ++mRows;
        }
        if (mRows > 0) {
            this.avaRadioButton[0].setSelected(true);
        }
        if (this.lblCombo != null) {
            this.avaGroup.add(this.lblCombo);
        }
    }

    private void close() {
        this.setVisible(false);
    }

    private void initComponents() {
        this.setModal(true);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        TitledBorder title = BorderFactory.createTitledBorder(null, "Select One");
        this.avaPane.setBorder(title);
        this.mMessageText = new JLabelPane();
        this.mMessageText.setBackground(contentPane.getBackground());
        this.setMessageText(null);
        this.okButton = new JButton(in_ok);
        this.cancelButton = new JButton(in_cancel);
        ActionListener eventListener = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == SwingChooserRadio.this.okButton) {
                    SwingChooserRadio.this.selectedOK();
                } else if (evt.getSource() == SwingChooserRadio.this.cancelButton) {
                    SwingChooserRadio.this.close();
                }
            }
        };
        this.okButton.addActionListener(eventListener);
        this.cancelButton.addActionListener(eventListener);
        GridBagConstraints c = new GridBagConstraints();
        Utility.buildConstraints(c, 0, 0, 3, 1, 0.0, 0.0);
        c.fill = 2;
        c.anchor = 17;
        c.insets = new Insets(0, 4, 4, 4);
        contentPane.add((Component)this.mMessageText, c);
        c = new GridBagConstraints();
        Utility.buildConstraints(c, 0, 1, 3, 1, 1.0, 1.0);
        c.fill = 1;
        c.anchor = 17;
        c.insets = new Insets(4, 4, 4, 4);
        contentPane.add((Component)this.avaPane, c);
        c = new GridBagConstraints();
        Utility.buildConstraints(c, 0, 2, 3, 1, 0.0, 0.0);
        c.anchor = 17;
        c.insets = new Insets(0, 4, 4, 4);
        contentPane.add((Component)this.okButton, c);
        c = new GridBagConstraints();
        Utility.buildConstraints(c, 1, 2, 3, 1, 0.0, 0.0);
        c.anchor = 13;
        c.insets = new Insets(0, 4, 4, 4);
        contentPane.add((Component)this.cancelButton, c);
        this.okButton.setEnabled(true);
        this.cancelButton.setEnabled(true);
    }

    private void selectedOK() {
        Object selectedItem = null;
        for (int i = 0; i < this.avaRadioButton.length; ++i) {
            if (!this.avaRadioButton[i].isSelected()) continue;
            selectedItem = this.avaRadioButton[i].getText();
            break;
        }
        if (this.lblCombo != null && this.lblCombo.isSelected()) {
            selectedItem = this.cmbCombo.getSelectedItem();
        }
        this.mSelectedList.clear();
        if (selectedItem != null) {
            this.mSelectedList.add(selectedItem);
        }
        this.setVisible(false);
    }

    private void updateAvailableTable() {
        ArrayList<String> mAvailableData = new ArrayList<String>();
        Iterator it = this.mAvailableList.iterator();
        while (it.hasNext()) {
            mAvailableData.add(it.next().toString());
        }
        this.setData(mAvailableData);
        int row = this.avaRadioButton.length;
        GridBagLayout gridbag = new GridBagLayout();
        this.avaPane.removeAll();
        this.avaPane.setLayout(gridbag);
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        for (int i = 0; i < row; ++i) {
            int cr = i;
            c.anchor = 17;
            Utility.buildConstraints(c, 0, cr, 2, 1, 1.0, 0.0);
            gridbag.setConstraints(this.avaRadioButton[i], c);
            this.avaPane.add(this.avaRadioButton[i]);
            if (row <= 11 || i >= row - 1) continue;
            c.anchor = 13;
            Utility.buildConstraints(c, 3, cr, 2, 1, 1.0, 0.0);
            gridbag.setConstraints(this.avaRadioButton[++i], c);
            this.avaPane.add(this.avaRadioButton[i]);
        }
        if (this.lblCombo != null) {
            Utility.buildConstraints(c, 0, row, 3, 1, 0.0, 0.0);
            gridbag.setConstraints(this.lblCombo, c);
            this.avaPane.add(this.lblCombo);
            Utility.buildConstraints(c, 0, row + 1, 3, 1, 0.0, 0.0);
            gridbag.setConstraints(this.cmbCombo, c);
            this.avaPane.add(this.cmbCombo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Locale currentLocale = new Locale(Globals.getLanguage(), Globals.getCountry());
        try {
            ResourceBundle chooserProperties = ResourceBundle.getBundle("pcgen/gui/prop/LanguageBundle", currentLocale);
            in_available = chooserProperties.getString("in_available");
            in_ok = chooserProperties.getString("in_ok");
            in_cancel = chooserProperties.getString("in_cancel");
        }
        catch (MissingResourceException mrex) {
            Logging.errorPrint("Exception in SwingChooser constructor", mrex);
        }
        finally {
            Object chooserProperties = null;
        }
    }
}

