/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Date;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import pcgen.gui.utils.TableMap;
import pcgen.util.Logging;

public final class TableSorter
extends TableMap {
    static final long serialVersionUID = 3442230718911502935L;
    private int[] indexes = null;
    private boolean ascending = true;
    private boolean hasBeenWarned = false;
    private int sortingColumn = -1;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Number;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Boolean;

    public TableSorter() {
        this.indexes = new int[0];
    }

    public TableSorter(TableModel model) {
        this.setModel(model);
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        this.reallocateIndexes();
    }

    public int getRowTranslated(int row) {
        if (row >= 0 && row < this.indexes.length) {
            return this.indexes[row];
        }
        return -1;
    }

    public void setValueAt(Object aValue, int aRow, int aColumn) {
        this.checkModel();
        this.model.setValueAt(aValue, this.indexes[aRow], aColumn);
    }

    public Object getValueAt(int aRow, int aColumn) {
        this.checkModel();
        if (aRow < 0 || aRow >= this.indexes.length) {
            Logging.errorPrint("Row " + aRow + " illegal.");
            return null;
        }
        return this.model.getValueAt(this.indexes[aRow], aColumn);
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final TableSorter sorter = this;
        final JTable tableView = table;
        tableView.setColumnSelectionAllowed(false);
        MouseAdapter listMouseListener = new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                TableColumnModel columnModel = tableView.getColumnModel();
                int viewColumn = columnModel.getColumnIndexAtX(e.getX());
                int column = tableView.convertColumnIndexToModel(viewColumn);
                if (e.getClickCount() == 1 && column != -1) {
                    int shiftPressed = e.getModifiers() & 1;
                    if (shiftPressed == 0) {
                        if (column == TableSorter.this.sortingColumn) {
                            sorter.sortByColumn(column, !TableSorter.this.ascending);
                        } else {
                            sorter.sortByColumn(column, true);
                        }
                    } else {
                        sorter.sortByColumn(column, false);
                    }
                }
            }
        };
        JTableHeader th = tableView.getTableHeader();
        th.addMouseListener(listMouseListener);
    }

    public void tableChanged(TableModelEvent e) {
        this.reallocateIndexes();
        if (this.sortingColumn >= 0) {
            this.sortByColumn(this.sortingColumn, this.ascending);
        }
        super.tableChanged(e);
    }

    public int translateRow(int row) {
        for (int i = 0; i < this.indexes.length; ++i) {
            if (this.indexes[i] != row) continue;
            return i;
        }
        return -1;
    }

    private void checkModel() {
        if (this.indexes.length != this.model.getRowCount() && !this.hasBeenWarned) {
            Logging.errorPrint("Sorter not informed of a change in model.");
            Logging.errorPrint("Fixing.  Please report this as a bug.");
            this.reallocateIndexes();
            this.hasBeenWarned = true;
        }
    }

    private int compare(int row1, int row2) {
        Object o2;
        Class<?> type = this.model.getColumnClass(this.sortingColumn);
        int lessThan = this.ascending ? -1 : 1;
        int greaterThan = this.ascending ? 1 : -1;
        Object o1 = this.getValueAt(row1, this.sortingColumn);
        if (o1 == (o2 = this.getValueAt(row2, this.sortingColumn))) {
            return 0;
        }
        if (o1 == null) {
            return lessThan;
        }
        if (o2 == null) {
            return greaterThan;
        }
        if (type == (class$java$lang$Integer == null ? (class$java$lang$Integer = TableSorter.class$("java.lang.Integer")) : class$java$lang$Integer)) {
            int i2;
            int i1 = (Integer)o1;
            if (i1 < (i2 = ((Integer)o2).intValue())) {
                return lessThan;
            }
            if (i1 > i2) {
                return greaterThan;
            }
            return 0;
        }
        if (type.getSuperclass() == (class$java$lang$Number == null ? (class$java$lang$Number = TableSorter.class$("java.lang.Number")) : class$java$lang$Number)) {
            double d2;
            double d1 = ((Number)o1).doubleValue();
            if (d1 < (d2 = ((Number)o2).doubleValue())) {
                return lessThan;
            }
            if (d1 > d2) {
                return greaterThan;
            }
            return 0;
        }
        if (type == (class$java$util$Date == null ? (class$java$util$Date = TableSorter.class$("java.util.Date")) : class$java$util$Date)) {
            long n2;
            long n1 = ((Date)o1).getTime();
            if (n1 < (n2 = ((Date)o2).getTime())) {
                return lessThan;
            }
            if (n1 > n2) {
                return greaterThan;
            }
            return 0;
        }
        if (type == (class$java$lang$String == null ? (class$java$lang$String = TableSorter.class$("java.lang.String")) : class$java$lang$String)) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            if (this.ascending) {
                return s1.compareToIgnoreCase(s2);
            }
            return s2.compareToIgnoreCase(s1);
        }
        if (type == (class$java$lang$Boolean == null ? (class$java$lang$Boolean = TableSorter.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
            boolean b2;
            boolean b1 = (Boolean)o1;
            if (b1 == (b2 = ((Boolean)o2).booleanValue())) {
                return 0;
            }
            if (b1) {
                return greaterThan;
            }
            return lessThan;
        }
        String s1 = o1.toString();
        String s2 = o2.toString();
        if (this.ascending) {
            return s1.compareToIgnoreCase(s2);
        }
        return s2.compareToIgnoreCase(s1);
    }

    private void mergeSort(int[] indices, int[] workspace, int start, int end) {
        int numElem = end - start;
        if (numElem > 1) {
            int mid = (start + end) / 2;
            this.mergeSort(indices, workspace, start, mid);
            this.mergeSort(indices, workspace, mid, end);
            int i = start;
            int j = start;
            int k = mid;
            while (j < mid && k < end) {
                if (this.compare(j, k) <= 0) {
                    workspace[i++] = indices[j++];
                    continue;
                }
                workspace[i++] = indices[k++];
            }
            if (j < mid) {
                int numLeft = mid - j;
                System.arraycopy(indices, j, indices, end - numLeft, numLeft);
                System.arraycopy(workspace, start, indices, start, numElem - numLeft);
            } else {
                int numLeft = end - k;
                System.arraycopy(workspace, start, indices, start, numElem - numLeft);
            }
        }
    }

    private void reallocateIndexes() {
        int rowCount = this.model.getRowCount();
        if (this.indexes == null || rowCount != this.indexes.length) {
            this.indexes = new int[rowCount];
            for (int row = 0; row < rowCount; ++row) {
                this.indexes[row] = row;
            }
        }
    }

    private void sort() {
        this.checkModel();
        int[] workspace = new int[this.indexes.length];
        this.mergeSort(this.indexes, workspace, 0, this.indexes.length);
    }

    private void sortByColumn(int column, boolean argAscending) {
        this.ascending = argAscending;
        this.sortingColumn = column;
        this.sort();
        super.tableChanged(new TableModelEvent(this));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

