/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import javax.swing.JTree;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.tree.TreePath;
import pcgen.gui.utils.TreeTableModel;

final class TreeTableModelAdapter
extends AbstractTableModel {
    private JTree tree;
    private TreeTableModel treeTableModel;

    public TreeTableModelAdapter(TreeTableModel treeTableModel, JTree tree) {
        this.tree = tree;
        this.treeTableModel = treeTableModel;
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeExpanded(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            public void treeCollapsed(TreeExpansionEvent event) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }
        });
        treeTableModel.addTreeModelListener(new TreeModelListener(){

            public void treeNodesChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            public void treeNodesInserted(TreeModelEvent e) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            public void treeNodesRemoved(TreeModelEvent e) {
                TreeTableModelAdapter.this.fireTableDataChanged();
            }

            public void treeStructureChanged(TreeModelEvent e) {
                TreeTableModelAdapter.this.fireTableStructureChanged();
            }
        });
    }

    public boolean isCellEditable(int row, int column) {
        return this.treeTableModel.isCellEditable(this.nodeForRow(row), column);
    }

    public Class getColumnClass(int column) {
        return this.treeTableModel.getColumnClass(column);
    }

    public int getColumnCount() {
        return this.treeTableModel.getColumnCount();
    }

    public String getColumnName(int column) {
        return this.treeTableModel.getColumnName(column);
    }

    public int getRowCount() {
        return this.tree.getRowCount();
    }

    public void setValueAt(Object value, int row, int column) {
        this.treeTableModel.setValueAt(value, this.nodeForRow(row), column);
    }

    public Object getValueAt(int row, int column) {
        return this.treeTableModel.getValueAt(this.nodeForRow(row), column);
    }

    private Object nodeForRow(int row) {
        TreePath treePath = this.tree.getPathForRow(row);
        if (treePath != null) {
            return treePath.getLastPathComponent();
        }
        return "";
    }
}

