/*
 * Decompiled with CFR 0.152.
 */
package pcgen.gui.utils;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.KeyStroke;
import javax.swing.ToolTipManager;
import pcgen.core.Globals;
import pcgen.core.SettingsHandler;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.gui.utils.BrowserLauncher;
import pcgen.gui.utils.IconUtilitities;
import pcgen.io.ExportHandler;
import pcgen.util.Logging;
import pcgen.util.PropertyFactory;

public final class Utility {
    private static ResourceBundle properties = null;

    public static void setDescription(JComponent component, String description) {
        component.setToolTipText(description);
    }

    public static void setGuiTextInfo(Object obj, String in_String) {
        String text;
        if (properties == null) {
            Locale currentLocale = new Locale(Globals.getLanguage(), Globals.getCountry());
            try {
                properties = ResourceBundle.getBundle("pcgen/gui/prop/LanguageBundle", currentLocale);
            }
            catch (MissingResourceException mrex) {
                Logging.errorPrint("Exception in CoreUtility::setGuiTextInfo", mrex);
            }
        }
        if (properties == null) {
            text = in_String;
        } else {
            try {
                text = properties.getString(in_String);
            }
            catch (Exception exc) {
                text = in_String;
            }
        }
        Utility.setTextAndMnemonic(obj, text);
        String tooltip = "";
        if (properties != null) {
            String tooltipKey = in_String + "_tip";
            try {
                tooltip = properties.getString(tooltipKey);
            }
            catch (Exception exc) {
                tooltip = "";
            }
        }
        if (tooltip.length() > 0 && obj instanceof JComponent) {
            Utility.setDescription((JComponent)obj, tooltip);
        }
    }

    public static Container getParentNamed(Container aObj, String parentName) {
        while (aObj != null && !aObj.getClass().getName().equals(parentName)) {
            aObj = aObj.getParent();
        }
        return aObj;
    }

    public static File getTempPreviewFile() {
        String template = SettingsHandler.getSelectedCharacterHTMLOutputSheet(Globals.getCurrentPC());
        if (template == null || template.trim().length() == 0) {
            ShowMessageDelegate.showMessageDialog("No HTML template specified in preferences.", "PCGen", MessageType.ERROR);
            return null;
        }
        String extension = template.substring(template.lastIndexOf(46));
        File tempFile = null;
        try {
            tempFile = File.createTempFile("currentPC", extension, SettingsHandler.getTempPath());
        }
        catch (IOException ioe) {
            ShowMessageDelegate.showMessageDialog("Could not create temporary preview file.", "PCGen", MessageType.ERROR);
            Logging.errorPrint("Could not create temporary preview file.", ioe);
        }
        return tempFile;
    }

    public static void setTextAndMnemonic(Object obj, String text) {
        if (obj instanceof JLabel) {
            ((JLabel)obj).setText(text);
            return;
        }
        int textLength = text.length();
        int idx = 0;
        char mnemonic = '\u0000';
        while ((idx = text.indexOf(38, idx)) >= 0) {
            if (idx >= textLength - 1) continue;
            if (text.charAt(idx + 1) == '&') {
                ++idx;
            } else {
                mnemonic = text.charAt(idx + 1);
            }
            text = text.substring(0, idx) + text.substring(idx + 1);
            --textLength;
        }
        if (obj instanceof JButton) {
            ((JButton)obj).setText(text);
            if (mnemonic != '\u0000') {
                ((JButton)obj).setMnemonic(mnemonic);
            }
        } else if (obj instanceof JMenuItem) {
            ((JMenuItem)obj).setText(text);
            if (mnemonic != '\u0000') {
                ((JMenuItem)obj).setMnemonic(mnemonic);
            }
        }
    }

    public static void buildConstraints(GridBagConstraints gbc, int gx, int gy, int gw, int gh, double wx, double wy) {
        gbc.gridx = gx;
        gbc.gridy = gy;
        gbc.gridwidth = gw;
        gbc.gridheight = gh;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public static void centerDialog(JDialog dialog) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension dialogSize = dialog.getSize();
        if (dialogSize.height > screenSize.height) {
            dialogSize.height = screenSize.height;
        }
        if (dialogSize.width > screenSize.width) {
            dialogSize.width = screenSize.width;
        }
        dialog.setLocation((screenSize.width - dialogSize.width) / 2, (screenSize.height - dialogSize.height) / 2);
    }

    public static void centerFrame(JFrame frame, boolean isPopup) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        if (isPopup) {
            frame.setSize(screenSize.width / 2, screenSize.height / 2);
        }
        Dimension frameSize = frame.getSize();
        if (frameSize.height > screenSize.height) {
            frameSize.height = screenSize.height;
        }
        if (frameSize.width > screenSize.width) {
            frameSize.width = screenSize.width;
        }
        frame.setLocation((screenSize.width - frameSize.width) / 2, (screenSize.height - frameSize.height) / 2);
    }

    public static JButton createButton(ActionListener listener, String command, String description, String iconName, boolean enable) {
        JButton button = new JButton();
        button.setMargin(new Insets(0, 0, 0, 0));
        if (listener != null) {
            button.addActionListener(listener);
        }
        if (command != null) {
            button.setActionCommand(command);
        }
        if (SettingsHandler.isToolTipTextShown()) {
            Utility.setDescription(button, description);
        }
        IconUtilitities.maybeSetIcon(button, iconName);
        button.setEnabled(enable);
        return button;
    }

    public static JMenu createMenu(String prop, String iconName, boolean enable) {
        String label = PropertyFactory.getString("in_" + prop);
        char mnemonic = PropertyFactory.getMnemonic("in_mn_" + prop);
        String description = PropertyFactory.getString("in_" + prop + "Tip");
        return Utility.createMenu(label, mnemonic, description, iconName, enable);
    }

    public static JMenu createMenu(String label, char mnemonic, String description, String iconName, boolean enable) {
        JMenu menu = new JMenu(label);
        if (mnemonic != '\u0000') {
            menu.setMnemonic(mnemonic);
        }
        if (SettingsHandler.isToolTipTextShown()) {
            Utility.setDescription(menu, description);
        }
        IconUtilitities.maybeSetIcon(menu, iconName);
        menu.setEnabled(enable);
        return menu;
    }

    public static JMenuItem createMenuItem(String prop, ActionListener listener, String command, String accelerator, String iconName, boolean enable) {
        String label = PropertyFactory.getString("in_" + prop);
        char mnemonic = PropertyFactory.getMnemonic("in_mn_" + prop);
        String description = PropertyFactory.getString("in_" + prop + "Tip");
        return Utility.createMenuItem(label, listener, command, mnemonic, accelerator, description, iconName, enable);
    }

    public static JMenuItem createMenuItem(String label, ActionListener listener, String command, char mnemonic, String accelerator, String description, String iconName, boolean enable) {
        JMenuItem item = new JMenuItem(label);
        if (listener != null) {
            item.addActionListener(listener);
        }
        if (command != null) {
            item.setActionCommand(command);
        }
        if (mnemonic != '\u0000') {
            item.setMnemonic(mnemonic);
        }
        if (accelerator != null) {
            KeyStroke aKey;
            int iShortCut = 2;
            StringTokenizer aTok = new StringTokenizer(accelerator);
            String aString = aTok.nextToken();
            if (aString.equalsIgnoreCase("shortcut")) {
                iShortCut = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
            } else if (aString.equalsIgnoreCase("alt")) {
                iShortCut = System.getProperty("mrj.version") != null ? Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 8 : 8;
            } else if (aString.equalsIgnoreCase("shift-shortcut")) {
                iShortCut = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask() | 1;
            }
            if (aTok.hasMoreTokens()) {
                aString = aTok.nextToken();
            }
            if ((aKey = KeyStroke.getKeyStroke(aString)) != null) {
                int iKeyCode = aKey.getKeyCode();
                item.setAccelerator(KeyStroke.getKeyStroke(iKeyCode, iShortCut));
            }
        }
        if (SettingsHandler.isToolTipTextShown()) {
            Utility.setDescription(item, description);
        }
        IconUtilitities.maybeSetIcon(item, iconName);
        item.setEnabled(enable);
        return item;
    }

    public static JRadioButtonMenuItem createRadioButtonMenuItem(ButtonGroup group, String label, ActionListener listener, String command, char mnemonic, String accelerator, String description, String iconName, boolean enable) {
        JRadioButtonMenuItem button = new JRadioButtonMenuItem(label);
        if (group != null) {
            group.add(button);
        }
        if (listener != null) {
            button.addActionListener(listener);
        }
        if (command != null) {
            button.setActionCommand(command);
        }
        if (mnemonic != '\u0000') {
            button.setMnemonic(mnemonic);
        }
        if (accelerator != null) {
            button.setAccelerator(KeyStroke.getKeyStroke(accelerator));
        }
        if (SettingsHandler.isToolTipTextShown()) {
            Utility.setDescription(button, description);
        }
        IconUtilitities.maybeSetIcon(button, iconName);
        button.setEnabled(enable);
        return button;
    }

    public static void handleToolTipShownStateChange() {
        ToolTipManager.sharedInstance().setEnabled(SettingsHandler.isToolTipTextShown());
    }

    public static void previewInBrowser() {
        File template = new File(SettingsHandler.getSelectedCharacterHTMLOutputSheet(Globals.getCurrentPC()));
        String fileName = template.getAbsolutePath();
        Utility.previewInBrowser(fileName);
    }

    public static void previewInBrowser(String fileName) {
        File outFile = Utility.getTempPreviewFile();
        if (outFile == null) {
            return;
        }
        try {
            OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(outFile), "UTF-8");
            Utility.printToWriter(w, fileName);
            w.close();
            URL url = outFile.toURL();
            Utility.viewInBrowser(url.toString());
        }
        catch (Exception ex) {
            ShowMessageDelegate.showMessageDialog("Could not preview file in external browser. Sorry...", "PCGen", MessageType.ERROR);
            Logging.errorPrint("Could not preview file in external browser. Sorry...", ex);
        }
    }

    public static void printToWriter(Writer w, String aFile) throws IOException {
        File template = new File(aFile);
        if (!template.exists()) {
            throw new IOException(aFile + " does not exist!");
        }
        String fileName = template.getName().toLowerCase();
        BufferedWriter bw = new BufferedWriter(w);
        if (fileName.startsWith("csheet") || fileName.startsWith("eqsheet")) {
            new ExportHandler(template).write(Globals.getCurrentPC(), bw);
        } else if (fileName.startsWith("psheet")) {
            new ExportHandler(template).write(Globals.getPCList(), bw);
        } else {
            throw new IOException(fileName + " is not a valid template file name.");
        }
        bw.close();
    }

    public static void selectDefaultBrowser(Component parent) {
        JFileChooser fc = new JFileChooser();
        fc.setDialogTitle("Find and select your preferred html browser.");
        if (System.getProperty("os.name").startsWith("Mac OS")) {
            fc.putClientProperty("JFileChooser.appBundleIsTraversable", "never");
        }
        if (SettingsHandler.getBrowserPath() != null) {
            fc.setCurrentDirectory(new File(SettingsHandler.getBrowserPath()));
        }
        int returnVal = fc.showOpenDialog(parent);
        if (returnVal == 0) {
            File file = fc.getSelectedFile();
            SettingsHandler.setBrowserPath(file.getAbsolutePath());
        }
    }

    public static String stripHTML(String htmlIn) {
        String stringOut = htmlIn;
        while (stringOut.indexOf(60) >= 0) {
            stringOut = stringOut.substring(0, stringOut.indexOf(60)) + stringOut.substring(stringOut.indexOf(62) + 1, stringOut.length());
        }
        return stringOut;
    }

    public static void viewInBrowser(String url) {
        try {
            String osName = System.getProperty("os.name");
            if (osName.startsWith("Windows ") && SettingsHandler.getBrowserPath() == null) {
                Utility.selectDefaultBrowser(null);
            }
            if (osName.startsWith("Mac OS")) {
                BrowserLauncher.openURL(url);
            } else {
                BrowserLauncher.openURL(url);
            }
        }
        catch (Exception ex) {
            ShowMessageDelegate.showMessageDialog("Could not preview file in external browser. Sorry...", "PCGen", MessageType.ERROR);
            Logging.errorPrint("Could not preview file in external browser. Sorry...", ex);
        }
    }
}

