/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import pcgen.core.Constants;
import pcgen.core.Equipment;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PObject;
import pcgen.core.PlayerCharacter;
import pcgen.core.SettingsHandler;
import pcgen.core.Skill;
import pcgen.core.SubClass;
import pcgen.core.WeaponProf;
import pcgen.core.character.Follower;
import pcgen.core.utils.CoreUtility;
import pcgen.io.FORNode;
import pcgen.io.FileAccess;
import pcgen.io.IIFNode;
import pcgen.io.exporttoken.ACCheckToken;
import pcgen.io.exporttoken.ACToken;
import pcgen.io.exporttoken.AgeToken;
import pcgen.io.exporttoken.AlignmentToken;
import pcgen.io.exporttoken.AltHPToken;
import pcgen.io.exporttoken.AttackToken;
import pcgen.io.exporttoken.BaseMovementToken;
import pcgen.io.exporttoken.BioToken;
import pcgen.io.exporttoken.BirthplaceToken;
import pcgen.io.exporttoken.BonusListToken;
import pcgen.io.exporttoken.BonusToken;
import pcgen.io.exporttoken.CRToken;
import pcgen.io.exporttoken.CasterLevelToken;
import pcgen.io.exporttoken.CatchPhraseToken;
import pcgen.io.exporttoken.CheckToken;
import pcgen.io.exporttoken.ClassAbbToken;
import pcgen.io.exporttoken.ClassListToken;
import pcgen.io.exporttoken.ClassToken;
import pcgen.io.exporttoken.ColorToken;
import pcgen.io.exporttoken.DRToken;
import pcgen.io.exporttoken.DamageToken;
import pcgen.io.exporttoken.DefenseToken;
import pcgen.io.exporttoken.DeityToken;
import pcgen.io.exporttoken.DescToken;
import pcgen.io.exporttoken.DirToken;
import pcgen.io.exporttoken.DomainToken;
import pcgen.io.exporttoken.EQSetToken;
import pcgen.io.exporttoken.EclToken;
import pcgen.io.exporttoken.EqContainerToken;
import pcgen.io.exporttoken.EqContainersToken;
import pcgen.io.exporttoken.EqContainerwToken;
import pcgen.io.exporttoken.EqToken;
import pcgen.io.exporttoken.EqTypeToken;
import pcgen.io.exporttoken.ExpToken;
import pcgen.io.exporttoken.ExportToken;
import pcgen.io.exporttoken.FaceToken;
import pcgen.io.exporttoken.FavoredListToken;
import pcgen.io.exporttoken.FeatPointsToken;
import pcgen.io.exporttoken.FollowerOfToken;
import pcgen.io.exporttoken.GameModeToken;
import pcgen.io.exporttoken.GenderToken;
import pcgen.io.exporttoken.GoldToken;
import pcgen.io.exporttoken.HPRollToken;
import pcgen.io.exporttoken.HPToken;
import pcgen.io.exporttoken.HandedToken;
import pcgen.io.exporttoken.HeightToken;
import pcgen.io.exporttoken.HitDiceToken;
import pcgen.io.exporttoken.InitiativeBonusToken;
import pcgen.io.exporttoken.InitiativeMiscToken;
import pcgen.io.exporttoken.InitiativeModToken;
import pcgen.io.exporttoken.InterestsToken;
import pcgen.io.exporttoken.LanguagesToken;
import pcgen.io.exporttoken.LengthToken;
import pcgen.io.exporttoken.LevelToken;
import pcgen.io.exporttoken.LocationToken;
import pcgen.io.exporttoken.MaxCCSkillLevelToken;
import pcgen.io.exporttoken.MaxDexToken;
import pcgen.io.exporttoken.MaxSkillLevelToken;
import pcgen.io.exporttoken.MoveToken;
import pcgen.io.exporttoken.MovementToken;
import pcgen.io.exporttoken.NameToken;
import pcgen.io.exporttoken.NoteToken;
import pcgen.io.exporttoken.PaperInfoToken;
import pcgen.io.exporttoken.Personality1Token;
import pcgen.io.exporttoken.Personality2Token;
import pcgen.io.exporttoken.PhobiasToken;
import pcgen.io.exporttoken.PipeToken;
import pcgen.io.exporttoken.PlayerNameToken;
import pcgen.io.exporttoken.PoolToken;
import pcgen.io.exporttoken.PortraitToken;
import pcgen.io.exporttoken.ProhibitedListToken;
import pcgen.io.exporttoken.RaceToken;
import pcgen.io.exporttoken.ReachToken;
import pcgen.io.exporttoken.RegionToken;
import pcgen.io.exporttoken.ResidenceToken;
import pcgen.io.exporttoken.SRToken;
import pcgen.io.exporttoken.SizeLongToken;
import pcgen.io.exporttoken.SizeModToken;
import pcgen.io.exporttoken.SizeToken;
import pcgen.io.exporttoken.SkillLevelToken;
import pcgen.io.exporttoken.SkillSubsetToken;
import pcgen.io.exporttoken.SkillToken;
import pcgen.io.exporttoken.SkillTypeToken;
import pcgen.io.exporttoken.SkillpointsToken;
import pcgen.io.exporttoken.SpecialAbilityToken;
import pcgen.io.exporttoken.SpeechTendancyToken;
import pcgen.io.exporttoken.SpellFailureToken;
import pcgen.io.exporttoken.SpellListBookToken;
import pcgen.io.exporttoken.SpellListCastToken;
import pcgen.io.exporttoken.SpellListClassToken;
import pcgen.io.exporttoken.SpellListDcStatToken;
import pcgen.io.exporttoken.SpellListDcToken;
import pcgen.io.exporttoken.SpellListKnownToken;
import pcgen.io.exporttoken.SpellListTypeToken;
import pcgen.io.exporttoken.SpellMemToken;
import pcgen.io.exporttoken.SpellPointsToken;
import pcgen.io.exporttoken.StatToken;
import pcgen.io.exporttoken.SubRegionToken;
import pcgen.io.exporttoken.TabNameToken;
import pcgen.io.exporttoken.TempBonusToken;
import pcgen.io.exporttoken.TemplateListToken;
import pcgen.io.exporttoken.TemplateToken;
import pcgen.io.exporttoken.Token;
import pcgen.io.exporttoken.TotalLevelsToken;
import pcgen.io.exporttoken.TotalToken;
import pcgen.io.exporttoken.TypeToken;
import pcgen.io.exporttoken.VarToken;
import pcgen.io.exporttoken.VisionToken;
import pcgen.io.exporttoken.WeaponProfsToken;
import pcgen.io.exporttoken.WeaponToken;
import pcgen.io.exporttoken.WeaponhToken;
import pcgen.io.exporttoken.WeaponoToken;
import pcgen.io.exporttoken.WeaponpToken;
import pcgen.io.exporttoken.WeightToken;
import pcgen.util.BigDecimalHelper;
import pcgen.util.Delta;
import pcgen.util.Logging;

public final class ExportHandler {
    private static boolean existsOnly = false;
    private static boolean noMoreItems = false;
    private static boolean skipMath = false;
    private static final boolean doMathMode = true;
    private static HashMap tokenMap = new HashMap();
    private File templateFile;
    private final Map loopVariables = new HashMap();
    private String csheetTag2 = "\\";
    private String meleeAttackString = null;
    private String rangedAttackString = null;
    private String unarmedAttackString = null;
    private boolean canWrite = true;
    private boolean checkBefore = false;
    private boolean inLabel = false;
    private static final int WPTYPEBONUS_EQ = 1;
    private static final int WPTYPEBONUS_FEAT = 2;
    private static final int WPTYPEBONUS_PC = 0;
    private static final int WPTYPEBONUS_TEMPLATE = 3;

    public ExportHandler(File templateFile) {
        this.populateTokenMap();
        this.setTemplateFile(templateFile);
    }

    public void replaceTokenSkipMath(PlayerCharacter aPC, String aString, BufferedWriter output) {
        boolean oldSkipMath = skipMath;
        skipMath = true;
        this.replaceToken(aString, output, aPC);
        skipMath = oldSkipMath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void write(PlayerCharacter aPC, BufferedWriter out) {
        block26: {
            IOException e322;
            BufferedReader br;
            block24: {
                String aString;
                aPC.setCalcEquipmentList(aPC.getUseTempMods());
                aPC.getSpellList();
                FileAccess.setCurrentOutputFilter(this.templateFile.getName());
                aPC.getAllSkillList(true);
                int includeSkills = SettingsHandler.getIncludeSkills();
                if (includeSkills == 3) {
                    includeSkills = SettingsHandler.getSkillsTab_IncludeSkills();
                }
                aPC.populateSkills(includeSkills, 2);
                Iterator e2 = aPC.getClassList().iterator();
                while (e2.hasNext()) {
                    PCClass aClass = (PCClass)e2.next();
                    aClass.sortCharacterSpellList();
                }
                aPC.determinePrimaryOffWeapon();
                aPC.modFromArmorOnWeaponRolls();
                aPC.adjustMoveRates();
                aPC.calcActiveBonuses();
                br = null;
                br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.templateFile), "UTF-8"));
                StringBuffer inputLine = new StringBuffer();
                while ((aString = br.readLine()) != null) {
                    if (aString.length() == 0) {
                        inputLine.append(' ').append(Constants.s_LINE_SEP);
                        continue;
                    }
                    if (aString.indexOf("||") < 0) {
                        inputLine.append(aString).append(Constants.s_LINE_SEP);
                        continue;
                    }
                    int dblBarPos = aString.indexOf("||");
                    while (dblBarPos >= 0) {
                        inputLine.append(aString.substring(0, dblBarPos)).append("| |");
                        aString = aString.substring(dblBarPos + 2);
                        dblBarPos = aString.indexOf("||");
                    }
                    if (aString.length() > 0) {
                        inputLine.append(aString);
                    }
                    inputLine.append(Constants.s_LINE_SEP);
                }
                aString = inputLine.toString();
                StringTokenizer aTok = new StringTokenizer(aString, "\r\n", false);
                FileAccess fa = new FileAccess();
                FORNode root = this.parseFORs(aTok);
                this.loopVariables.put(null, "0");
                existsOnly = false;
                noMoreItems = false;
                this.loopFOR(root, 0, 0, 1, out, fa, aPC);
                this.loopVariables.clear();
                Object var11_12 = null;
                if (br == null) break block24;
                try {
                    br.close();
                }
                catch (IOException e322) {
                    // empty catch block
                }
            }
            if (out != null) {
                try {
                    out.flush();
                }
                catch (IOException e322) {}
            }
            break block26;
            {
                catch (IOException exc) {
                    IOException e322;
                    Logging.errorPrint("Error in ExportHandler::write", exc);
                    Object var11_13 = null;
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException e322) {
                            // empty catch block
                        }
                    }
                    if (out != null) {
                        try {
                            out.flush();
                        }
                        catch (IOException e322) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException e322;
                Object var11_14 = null;
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (IOException e322) {
                        // empty catch block
                    }
                }
                if (out != null) {
                    try {
                        out.flush();
                    }
                    catch (IOException e322) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        this.csheetTag2 = "\\";
        aPC.setCalcEquipmentList(false);
        aPC.populateSkills(SettingsHandler.getSkillsTab_IncludeSkills(), 1);
    }

    public void write(Collection PCs, BufferedWriter out) {
        this.write(PCs.toArray(new PlayerCharacter[PCs.size()]), out);
    }

    private static boolean isAttackRoutine(String aString) {
        String signs = "+-";
        String delimiter = "/";
        int typeBefore = 0;
        for (int i = 0; i < aString.length(); ++i) {
            if ("+-".indexOf(aString.charAt(i)) > -1) {
                if (typeBefore != 0) {
                    return false;
                }
                typeBefore = 1;
                continue;
            }
            if ("/".indexOf(aString.charAt(i)) > -1) {
                if (typeBefore != 2) {
                    return false;
                }
                typeBefore = 0;
                continue;
            }
            if (aString.charAt(i) >= '0' && aString.charAt(i) <= '9') {
                if (typeBefore != 1 && typeBefore != 2) {
                    return false;
                }
                typeBefore = 2;
                continue;
            }
            return false;
        }
        return true;
    }

    public static String getItemDescription(String sType, String sKey, String sAlt, PlayerCharacter aPC) {
        if (SettingsHandler.isROG()) {
            if ("EMPTY".equals(aPC.getDescriptionLst())) {
                aPC.loadDescriptionFilesInDirectory("descriptions");
            }
            String aDescription = sAlt;
            String aSearch = sType.toUpperCase() + ":" + sKey + Constants.s_LINE_SEP;
            int pos = aPC.getDescriptionLst().indexOf(aSearch);
            if (pos >= 0) {
                aDescription = aPC.getDescriptionLst().substring(pos + aSearch.length());
                aDescription = aDescription.substring(0, aDescription.indexOf("####") - 1).trim();
            }
            return aDescription;
        }
        return sAlt;
    }

    private List getLineForMiscList(int index, PlayerCharacter aPC) {
        ArrayList<String> aArrayList = new ArrayList<String>();
        StringTokenizer aTok = new StringTokenizer((String)aPC.getMiscList().get(index), "\r\n", false);
        while (aTok.hasMoreTokens()) {
            aArrayList.add(aTok.nextToken());
        }
        return aArrayList;
    }

    private void setTemplateFile(File templateFile) {
        this.templateFile = templateFile;
    }

    private int getVarValue(String var, PlayerCharacter aPC) {
        String aString;
        int i;
        int idx = -1;
        while ((idx = var.indexOf("COUNT[EQ", idx + 1)) >= 0) {
            EqToken token;
            char chC = var.charAt(idx + 8);
            if (chC != '.' && (chC < '0' || chC > '9') || (i = var.indexOf(93, idx + 8)) < 0) continue;
            aString = var.substring(idx + 6, i);
            if (aString.indexOf("EQTYPE") > -1) {
                token = new EqTypeToken();
                aString = ((EqTypeToken)token).getToken(aString, aPC);
            } else {
                token = new EqToken();
                aString = token.getToken(aString, aPC);
            }
            var = var.substring(0, idx) + aString + var.substring(i + 1);
        }
        idx = -1;
        while ((idx = var.indexOf("STRLEN[", idx + 1)) >= 0) {
            i = var.indexOf(93, idx + 7);
            if (i < 0) continue;
            aString = var.substring(idx + 7, i);
            StringWriter sWriter = new StringWriter();
            BufferedWriter aWriter = new BufferedWriter(sWriter);
            this.replaceToken(aString, aWriter, aPC);
            sWriter.flush();
            try {
                aWriter.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            aString = sWriter.toString();
            var = var.substring(0, idx) + aString.length() + var.substring(i + 1);
        }
        return aPC.getVariableValue(var, "").intValue();
    }

    private int _replaceTokenArmor(int armor, String property, int equipped, int len, BufferedWriter output, int merge, PlayerCharacter aPC) {
        List aArrayList = aPC.getEquipmentOfTypeInOutputOrder("Armor", equipped, merge);
        List bArrayList = aPC.getEquipmentOfTypeInOutputOrder("Shield", equipped, merge);
        Iterator e = bArrayList.iterator();
        while (e.hasNext()) {
            aArrayList.remove(e.next());
        }
        if (armor >= aArrayList.size() - 1 && existsOnly) {
            len = 0;
            noMoreItems = true;
        }
        if (armor < aArrayList.size()) {
            Equipment eq = (Equipment)aArrayList.get(armor);
            this._writeArmorProperty(eq, property, output, aPC);
        }
        return len;
    }

    private int _replaceTokenArmorItem(int item, String subtype, String property, int equipped, int len, BufferedWriter output, int merge, PlayerCharacter aPC) {
        ArrayList<Equipment> aArrayList = new ArrayList<Equipment>();
        Iterator e = aPC.getEquipmentListInOutputOrder(merge).iterator();
        while (e.hasNext()) {
            Equipment eq = (Equipment)e.next();
            if (!"".equals(subtype) && !eq.isType(subtype) || equipped != 3 && (equipped != 2 || eq.isEquipped()) && (equipped != 1 || !eq.isEquipped()) || !eq.getBonusListString("AC") || eq.isArmor() || eq.isShield()) continue;
            aArrayList.add(eq);
        }
        if (item >= aArrayList.size()) {
            len = 0;
            noMoreItems = true;
        }
        if (item < aArrayList.size()) {
            Equipment eq = (Equipment)aArrayList.get(item);
            this._writeArmorProperty(eq, property, output, aPC);
        }
        return len;
    }

    private int _replaceTokenArmorShield(int shield, String subtype, String property, int equipped, int len, BufferedWriter output, int merge, PlayerCharacter aPC) {
        List aArrayList = aPC.getEquipmentOfTypeInOutputOrder("Shield", subtype, equipped, merge);
        if (shield >= aArrayList.size() - 1 && existsOnly) {
            len = 0;
            noMoreItems = true;
        }
        if (shield < aArrayList.size()) {
            Equipment eq = (Equipment)aArrayList.get(shield);
            this._writeArmorProperty(eq, property, output, aPC);
        }
        return len;
    }

    private int _replaceTokenArmorShirt(int shirt, String subtype, String property, int equipped, int len, BufferedWriter output, int merge, PlayerCharacter aPC) {
        List aArrayList = aPC.getEquipmentOfTypeInOutputOrder("Shirt", subtype, equipped, merge);
        if (shirt >= aArrayList.size() - 1 && existsOnly) {
            len = 0;
            noMoreItems = true;
        }
        if (shirt < aArrayList.size()) {
            Equipment eq = (Equipment)aArrayList.get(shirt);
            this._writeArmorProperty(eq, property, output, aPC);
        }
        return len;
    }

    private int _replaceTokenArmorSuit(int suit, String subtype, String property, int equipped, int len, BufferedWriter output, int merge, PlayerCharacter aPC) {
        List aArrayList = aPC.getEquipmentOfTypeInOutputOrder("Suit", subtype, equipped, merge);
        if (suit >= aArrayList.size() - 1 && existsOnly) {
            len = 0;
            noMoreItems = true;
        }
        if (suit < aArrayList.size()) {
            Equipment eq = (Equipment)aArrayList.get(suit);
            this._writeArmorProperty(eq, property, output, aPC);
        }
        return len;
    }

    private int _replaceTokenArmorVarious(int index, String type, String subtype, String property, int equipped, int len, BufferedWriter output, int merge, PlayerCharacter aPC) {
        Equipment eq;
        ArrayList<Equipment> aArrayList = new ArrayList<Equipment>();
        Iterator mapIter = aPC.getEquipmentOfTypeInOutputOrder(type, subtype, equipped, merge).iterator();
        while (mapIter.hasNext()) {
            eq = (Equipment)mapIter.next();
            if (eq.getACMod(aPC) > 0) {
                aArrayList.add(eq);
                continue;
            }
            if (!eq.getBonusListString("AC")) continue;
            aArrayList.add(eq);
        }
        if (index >= aArrayList.size() - 1 && existsOnly) {
            len = 0;
            noMoreItems = true;
        }
        if (index < aArrayList.size()) {
            eq = (Equipment)aArrayList.get(index);
            this._writeArmorProperty(eq, property, output, aPC);
        }
        return len;
    }

    private void _writeArmorProperty(Equipment eq, String property, BufferedWriter output, PlayerCharacter aPC) {
        if (property.startsWith("NAME")) {
            if (eq.isEquipped()) {
                FileAccess.write(output, "*");
            }
            FileAccess.encodeWrite(output, eq.parseOutputName(eq.getOutputName(), aPC));
            FileAccess.encodeWrite(output, eq.getAppliedName());
        } else if (property.startsWith("OUTPUTNAME")) {
            if (eq.isEquipped()) {
                FileAccess.write(output, "*");
            }
            FileAccess.encodeWrite(output, eq.parseOutputName(eq.getOutputName(), aPC));
            FileAccess.encodeWrite(output, eq.getAppliedName());
        } else if (property.startsWith("TOTALAC")) {
            FileAccess.write(output, Delta.toString((int)eq.bonusTo(aPC, "COMBAT", "AC", true)));
        } else if (property.startsWith("BASEAC")) {
            FileAccess.write(output, Delta.toString((int)eq.bonusTo("COMBAT", "AC", aPC, aPC)));
        } else if (property.startsWith("ACBONUS")) {
            FileAccess.write(output, Delta.toString((int)eq.bonusTo(aPC, "COMBAT", "AC", true)));
        } else if (property.startsWith("MAXDEX")) {
            int iMax = eq.getMaxDex(aPC);
            if (iMax != 100) {
                FileAccess.write(output, Delta.toString(iMax));
            }
        } else if (property.startsWith("ACCHECK")) {
            FileAccess.write(output, Delta.toString(eq.acCheck(aPC)));
        } else if (property.startsWith("EDR")) {
            FileAccess.write(output, Delta.toString(eq.eDR(aPC)));
        } else if (property.startsWith("ISTYPE")) {
            FileAccess.write(output, eq.isType(property.substring(property.indexOf(".") + 1)) ? "TRUE" : "FALSE");
        } else if (property.startsWith("SPELLFAIL")) {
            FileAccess.write(output, eq.spellFailure(aPC).toString());
        } else if (property.startsWith("MOVE")) {
            StringTokenizer aTok = new StringTokenizer(eq.moveString(), ",", false);
            String tempString = "";
            if (("M".equals(aPC.getSize()) || "S".equals(aPC.getSize())) && aTok.countTokens() > 0) {
                tempString = aTok.nextToken();
                if ("S".equals(aPC.getSize()) && aTok.countTokens() > 1) {
                    tempString = aTok.nextToken();
                }
            }
            FileAccess.write(output, tempString);
        } else if (property.startsWith("SPROP")) {
            FileAccess.encodeWrite(output, eq.getSpecialProperties(aPC));
        } else if (property.startsWith("TYPE")) {
            String typeString = "";
            if (eq.isLight()) {
                typeString = "Light";
            } else if (eq.isMedium()) {
                typeString = "Medium";
            } else if (eq.isHeavy()) {
                typeString = "Heavy";
            } else if (eq.isShield()) {
                typeString = "Shield";
            } else if (eq.isExtra()) {
                typeString = "Extra";
            }
            FileAccess.write(output, typeString);
        } else if (property.startsWith("WT")) {
            FileAccess.write(output, BigDecimalHelper.trimZeros(eq.getWeight(aPC).toString()));
        }
    }

    private void addToTokenMap(Token newToken) {
        Token test = tokenMap.put(newToken.getTokenName(), newToken);
        if (test != null) {
            Logging.errorPrint("More then one Output Token has the same Token Name: '" + newToken.getTokenName() + "'");
        }
    }

    private static int doOffhandMod(PlayerCharacter aPC, int myMod) {
        if (myMod <= 0) {
            return myMod;
        }
        int div = aPC.getTwoHandDamageDivisor();
        int secDamage = (int)aPC.getTotalBonusTo("COMBAT", "DAMAGE-SECONDARY");
        secDamage += (int)aPC.getTotalBonusTo("COMBAT", "SECONDARYDAMAGE");
        if (myMod % div == 0) {
            return myMod / div + secDamage;
        }
        if (secDamage == 0) {
            return myMod / div;
        }
        return myMod / div + secDamage + 1;
    }

    private boolean evaluateExpression(String expr, PlayerCharacter aPC) {
        String equals;
        String token;
        StringTokenizer aTok;
        if (expr.indexOf(".AND.") > 0) {
            String part1 = expr.substring(0, expr.indexOf(".AND."));
            String part2 = expr.substring(expr.indexOf(".AND.") + 5);
            return this.evaluateExpression(part1, aPC) && this.evaluateExpression(part2, aPC);
        }
        if (expr.indexOf(".OR.") > 0) {
            String part1 = expr.substring(0, expr.indexOf(".OR."));
            String part2 = expr.substring(expr.indexOf(".OR.") + 4);
            return this.evaluateExpression(part1, aPC) || this.evaluateExpression(part2, aPC);
        }
        Iterator ivar = this.loopVariables.keySet().iterator();
        while (ivar.hasNext()) {
            Object anObject = ivar.next();
            if (anObject == null) continue;
            String fString = anObject.toString();
            String rString = this.loopVariables.get(fString).toString();
            expr = CoreUtility.replaceAll(expr, fString, rString);
        }
        if (expr.startsWith("HASVAR:")) {
            return aPC.getVariableValue(expr = expr.substring(7).trim(), "").intValue() > 0;
        }
        if (expr.startsWith("HASFEAT:")) {
            return aPC.getFeatNamed(expr = expr.substring(8).trim()) != null;
        }
        if (expr.startsWith("HASSA:")) {
            expr = expr.substring(6).trim();
            return aPC.hasSpecialAbility(expr);
        }
        if (expr.startsWith("HASEQUIP:")) {
            return aPC.getEquipmentNamed(expr = expr.substring(9).trim()) != null;
        }
        if (expr.startsWith("SPELLCASTER:")) {
            String fString = expr.substring(12).trim();
            if (fString.indexOf(61) >= 0) {
                StringTokenizer aTok2 = new StringTokenizer(fString, "=", false);
                int i = Integer.parseInt(aTok2.nextToken());
                String cs = aTok2.nextToken();
                ArrayList cList = aPC.getClassList();
                if (i >= cList.size()) {
                    return false;
                }
                PCClass aClass = (PCClass)cList.get(i);
                if (cs.equalsIgnoreCase(aClass.getSpellType())) {
                    return true;
                }
                if (cs.equalsIgnoreCase(aClass.getName())) {
                    return true;
                }
                if (cs.equalsIgnoreCase(aClass.getCastAs())) {
                    return true;
                }
                if ("!Prepare".equalsIgnoreCase(cs) && aClass.getMemorizeSpells()) {
                    return true;
                }
                if ("Prepare".equalsIgnoreCase(cs) && !aClass.getMemorizeSpells()) {
                    return true;
                }
            } else {
                Iterator e = aPC.getClassList().iterator();
                while (e.hasNext()) {
                    PCClass aClass = (PCClass)e.next();
                    if (fString.equalsIgnoreCase(aClass.getSpellType())) {
                        return true;
                    }
                    if (fString.equalsIgnoreCase(aClass.getName())) {
                        return true;
                    }
                    if (fString.equalsIgnoreCase(aClass.getCastAs())) {
                        return true;
                    }
                    if ("!Prepare".equalsIgnoreCase(fString) && aClass.getMemorizeSpells()) {
                        return true;
                    }
                    if (!"Prepare".equalsIgnoreCase(fString) || aClass.getMemorizeSpells()) continue;
                    return true;
                }
            }
        }
        if (expr.startsWith("EVEN:")) {
            int i = 0;
            try {
                i = Integer.parseInt(expr.substring(5).trim());
            }
            catch (NumberFormatException exc) {
                Logging.errorPrint("EVEN:" + i);
                return true;
            }
            return i % 2 == 0;
        }
        if (expr.endsWith("UNTRAINED")) {
            ArrayList pcSkills;
            int i;
            aTok = new StringTokenizer(expr, ".");
            String fString = aTok.nextToken();
            Skill aSkill = null;
            if (fString.length() > 5 && (i = Integer.parseInt(fString.substring(5))) <= (pcSkills = aPC.getSkillListInOutputOrder()).size() - 1) {
                aSkill = (Skill)pcSkills.get(i);
            }
            if (aSkill == null) {
                return false;
            }
            return aSkill.getUntrained().length() > 0 && aSkill.getUntrained().charAt(0) == 'Y';
        }
        aTok = new StringTokenizer(expr, ":");
        if (aTok.countTokens() == 1) {
            token = expr;
            equals = "TRUE";
        } else {
            if (aTok.countTokens() != 2) {
                Logging.errorPrint("evaluateExpression: Incorrect syntax (missing parameter)");
                return false;
            }
            token = aTok.nextToken();
            equals = aTok.nextToken().toUpperCase();
        }
        StringWriter sWriter = new StringWriter();
        BufferedWriter aWriter = new BufferedWriter(sWriter);
        this.replaceToken(token, aWriter, aPC);
        sWriter.flush();
        try {
            aWriter.flush();
        }
        catch (IOException ignore) {
            // empty catch block
        }
        try {
            int i = Integer.parseInt(sWriter.toString());
            return i == Integer.parseInt(equals);
        }
        catch (NumberFormatException e) {
            return sWriter.toString().toUpperCase().indexOf(equals) >= 0;
        }
    }

    private void evaluateIIF(IIFNode node, BufferedWriter output, FileAccess fa, PlayerCharacter aPC) {
        if (this.evaluateExpression(node.expr(), aPC)) {
            this.evaluateIIFChildren(node.trueChildren(), output, fa, aPC);
        } else {
            this.evaluateIIFChildren(node.falseChildren(), output, fa, aPC);
        }
    }

    private void evaluateIIFChildren(List children, BufferedWriter output, FileAccess fa, PlayerCharacter aPC) {
        for (int y = 0; y < children.size(); ++y) {
            if (children.get(y) instanceof FORNode) {
                FORNode nextFor = (FORNode)children.get(y);
                this.loopVariables.put(nextFor.var(), new Integer(0));
                existsOnly = nextFor.exists();
                String minString = nextFor.min();
                String maxString = nextFor.max();
                String stepString = nextFor.step();
                Iterator ivar = this.loopVariables.keySet().iterator();
                while (ivar.hasNext()) {
                    Object anObject = ivar.next();
                    if (anObject == null) continue;
                    String fString = anObject.toString();
                    String rString = this.loopVariables.get(fString).toString();
                    minString = CoreUtility.replaceAll(minString, fString, rString);
                    maxString = CoreUtility.replaceAll(maxString, fString, rString);
                    stepString = CoreUtility.replaceAll(stepString, fString, rString);
                }
                this.loopFOR(nextFor, this.getVarValue(minString, aPC), this.getVarValue(maxString, aPC), this.getVarValue(stepString, aPC), output, fa, aPC);
                existsOnly = nextFor.exists();
                this.loopVariables.remove(nextFor.var());
                continue;
            }
            if (children.get(y) instanceof IIFNode) {
                this.evaluateIIF((IIFNode)children.get(y), output, fa, aPC);
                continue;
            }
            String lineString = (String)children.get(y);
            Iterator ivar = this.loopVariables.keySet().iterator();
            while (ivar.hasNext()) {
                Object anObject = ivar.next();
                if (anObject == null) continue;
                String fString = anObject.toString();
                String rString = this.loopVariables.get(fString).toString();
                lineString = CoreUtility.replaceAll(lineString, fString, rString);
            }
            this.replaceLine(lineString, output, aPC);
            if (!this.canWrite) continue;
            FileAccess.newLine(output);
        }
    }

    private void loopFOR(FORNode node, int min, int max, int step, BufferedWriter output, FileAccess fa, PlayerCharacter aPC) {
        for (int x = min; x <= max; x += step) {
            this.loopVariables.put(node.var(), new Integer(x));
            for (int y = 0; y < node.children().size(); ++y) {
                if (node.children().get(y) instanceof FORNode) {
                    FORNode nextFor = (FORNode)node.children().get(y);
                    this.loopVariables.put(nextFor.var(), new Integer(0));
                    existsOnly = nextFor.exists();
                    String minString = nextFor.min();
                    String maxString = nextFor.max();
                    String stepString = nextFor.step();
                    Iterator ivar = this.loopVariables.keySet().iterator();
                    while (ivar.hasNext()) {
                        Object anObject = ivar.next();
                        if (anObject == null) continue;
                        String fString = anObject.toString();
                        String rString = this.loopVariables.get(fString).toString();
                        minString = CoreUtility.replaceAll(minString, fString, rString);
                        maxString = CoreUtility.replaceAll(maxString, fString, rString);
                        stepString = CoreUtility.replaceAll(stepString, fString, rString);
                    }
                    int varMin = this.getVarValue(minString, aPC);
                    int varMax = this.getVarValue(maxString, aPC);
                    int varStep = this.getVarValue(stepString, aPC);
                    this.loopFOR(nextFor, varMin, varMax, varStep, output, fa, aPC);
                    existsOnly = node.exists();
                    this.loopVariables.remove(nextFor.var());
                    continue;
                }
                if (node.children().get(y) instanceof IIFNode) {
                    this.evaluateIIF((IIFNode)node.children().get(y), output, fa, aPC);
                    continue;
                }
                String lineString = (String)node.children().get(y);
                Iterator ivar = this.loopVariables.keySet().iterator();
                while (ivar.hasNext()) {
                    Object anObject = ivar.next();
                    if (anObject == null) continue;
                    String fString = anObject.toString();
                    String rString = this.loopVariables.get(fString).toString();
                    lineString = CoreUtility.replaceAll(lineString, fString, rString);
                }
                noMoreItems = false;
                this.replaceLine(lineString, output, aPC);
                if (this.canWrite) {
                    FileAccess.newLine(output);
                }
                if (!existsOnly || !noMoreItems) continue;
                x = max + 1;
            }
        }
    }

    private String mathMode(String aString, PlayerCharacter aPC) {
        Float total = new Float(0.0);
        while (aString.lastIndexOf(40) >= 0) {
            int x = CoreUtility.innerMostStringStart(aString);
            int y = CoreUtility.innerMostStringEnd(aString);
            if (y < x) break;
            String bString = aString.substring(x + 1, y);
            if (x > 0 && aString.charAt(x - 1) == ' ' && (aString.charAt(y + 1) == '.' || y == aString.length() - 1)) {
                aString = aString.substring(0, x) + "[" + bString + "]" + aString.substring(y + 1);
                continue;
            }
            aString = aString.substring(0, x) + this.mathMode(bString, aPC) + aString.substring(y + 1);
        }
        aString = CoreUtility.replaceAll(aString, "[", "(");
        aString = CoreUtility.replaceAll(aString, "]", ")");
        String delimiter = "+-/*";
        String valString = "";
        boolean ADDITION_MODE = false;
        boolean SUBTRACTION_MODE = true;
        int MULTIPLICATION_MODE = 2;
        int DIVISION_MODE = 3;
        int mode = 0;
        int nextMode = 0;
        boolean REGULAR_MODE = false;
        boolean INTVAL_MODE = true;
        int SIGN_MODE = 2;
        int NO_ZERO_MODE = 3;
        int endMode = 0;
        boolean attackRoutine = false;
        String attackData = "";
        for (int i = 0; i < aString.length(); ++i) {
            String bString;
            valString = valString + aString.substring(i, i + 1);
            if (i != aString.length() - 1 && ("+-/*".lastIndexOf(aString.charAt(i)) <= -1 || i <= 0 || aString.charAt(i - 1) == '.')) continue;
            if ("+-/*".lastIndexOf(aString.charAt(i)) > -1) {
                valString = valString.substring(0, valString.length() - 1);
            }
            if (i < aString.length()) {
                if (valString.endsWith(".TRUNC")) {
                    if (attackRoutine) {
                        Logging.errorPrint("Math Mode Error: Using .TRUNC in Attack Mode.");
                    } else {
                        valString = String.valueOf(Float.valueOf(this.mathMode(valString.substring(0, valString.length() - 6), aPC)).intValue());
                    }
                }
                if (valString.endsWith(".INTVAL")) {
                    if (attackRoutine) {
                        Logging.errorPrint("Math Mode Error: Using .INTVAL in Attack Mode.");
                    } else {
                        valString = this.mathMode(valString.substring(0, valString.length() - 7), aPC);
                    }
                    endMode = 1;
                }
                if (valString.endsWith(".SIGN")) {
                    valString = this.mathMode(valString.substring(0, valString.length() - 5), aPC);
                    endMode = 2;
                }
                if (valString.endsWith(".NOZERO")) {
                    valString = this.mathMode(valString.substring(0, valString.length() - 7), aPC);
                    endMode = 3;
                }
                if (aString.length() > 0 && aString.charAt(i) == '+') {
                    nextMode = 0;
                } else if (aString.length() > 0 && aString.charAt(i) == '-') {
                    nextMode = 1;
                } else if (aString.length() > 0 && aString.charAt(i) == '*') {
                    nextMode = 2;
                } else if (aString.length() > 0 && aString.charAt(i) == '/') {
                    nextMode = 3;
                }
                StringWriter sWriter = new StringWriter();
                BufferedWriter aWriter = new BufferedWriter(sWriter);
                this.replaceTokenSkipMath(aPC, valString, aWriter);
                sWriter.flush();
                try {
                    aWriter.flush();
                }
                catch (IOException e) {
                    // empty catch block
                }
                bString = sWriter.toString();
                try {
                    valString = String.valueOf(Float.parseFloat(bString));
                }
                catch (NumberFormatException e) {
                    valString = bString;
                }
                if (!attackRoutine && ExportHandler.isAttackRoutine(valString)) {
                    attackRoutine = true;
                    attackData = valString;
                    valString = "";
                }
            }
            try {
                if (valString.length() > 0) {
                    if (attackRoutine) {
                        StringTokenizer bTok = new StringTokenizer(attackData, "/");
                        String newAttackData = "";
                        if (bTok.countTokens() > 0) {
                            block22: while (bTok.hasMoreTokens()) {
                                bString = bTok.nextToken();
                                switch (mode) {
                                    case 0: {
                                        newAttackData = newAttackData + "/+" + Integer.toString(new Float(Float.parseFloat(bString) + Float.parseFloat(valString)).intValue());
                                        continue block22;
                                    }
                                    case 1: {
                                        newAttackData = newAttackData + "/+" + Integer.toString(new Float(Float.parseFloat(bString) - Float.parseFloat(valString)).intValue());
                                        continue block22;
                                    }
                                    case 2: {
                                        newAttackData = newAttackData + "/+" + Integer.toString(new Float(Float.parseFloat(bString) * Float.parseFloat(valString)).intValue());
                                        continue block22;
                                    }
                                    case 3: {
                                        newAttackData = newAttackData + "/+" + Integer.toString(new Float(Float.parseFloat(bString) / Float.parseFloat(valString)).intValue());
                                        continue block22;
                                    }
                                }
                                Logging.errorPrint("In mathMode the mode " + mode + " is unsupported.");
                            }
                            attackData = CoreUtility.replaceAll(newAttackData.substring(1), "+-", "-");
                        }
                    } else {
                        switch (mode) {
                            case 0: {
                                total = new Float(total.doubleValue() + Double.parseDouble(valString));
                                break;
                            }
                            case 1: {
                                total = new Float(total.doubleValue() - Double.parseDouble(valString));
                                break;
                            }
                            case 2: {
                                total = new Float(total.doubleValue() * Double.parseDouble(valString));
                                break;
                            }
                            case 3: {
                                total = new Float(total.doubleValue() / Double.parseDouble(valString));
                                break;
                            }
                            default: {
                                Logging.errorPrint("In mathMode the mode " + mode + " is unsupported.");
                            }
                        }
                    }
                }
            }
            catch (NumberFormatException exc) {
                StringWriter sWriter = new StringWriter();
                BufferedWriter aWriter = new BufferedWriter(sWriter);
                this.replaceTokenSkipMath(aPC, aString, aWriter);
                sWriter.flush();
                try {
                    aWriter.flush();
                }
                catch (IOException e) {
                    // empty catch block
                }
                return sWriter.toString();
            }
            mode = nextMode;
            nextMode = 0;
            valString = "";
        }
        if (attackRoutine) {
            return attackData;
        }
        if (endMode == 1) {
            return Integer.toString(total.intValue());
        }
        if (endMode == 2) {
            Integer valInt = new Integer(total.intValue());
            return Delta.toString(valInt);
        }
        if (endMode == 3) {
            Integer valInt = new Integer(total.intValue());
            if (valInt == 0) {
                return "";
            }
            return Delta.toString(valInt);
        }
        return total.toString();
    }

    private void outputNonToken(String aString, BufferedWriter output) {
        if (!this.canWrite) {
            return;
        }
        if (aString.length() > 0) {
            FileAccess.write(output, aString);
        }
    }

    private FORNode parseFORs(StringTokenizer tokens) {
        FORNode root = new FORNode(null, "0", "0", "1", true);
        while (tokens.hasMoreTokens()) {
            String line = tokens.nextToken();
            if (line.startsWith("|FOR")) {
                StringTokenizer newFor = new StringTokenizer(line, ",");
                if (newFor.countTokens() > 1) {
                    newFor.nextToken();
                    if (newFor.nextToken().startsWith("%")) {
                        root.addChild(this.parseFORs(line, tokens));
                        continue;
                    }
                    root.addChild(line);
                    continue;
                }
                root.addChild(line);
                continue;
            }
            if (line.startsWith("|IIF(") && line.lastIndexOf(44) < 0) {
                String expr = line.substring(5, line.lastIndexOf(41));
                root.addChild(this.parseIIFs(expr, tokens));
                continue;
            }
            root.addChild(line);
        }
        return root;
    }

    private FORNode parseFORs(String forLine, StringTokenizer tokens) {
        StringTokenizer forVars = new StringTokenizer(forLine, ",");
        forVars.nextToken();
        String var = forVars.nextToken();
        String min = forVars.nextToken();
        String max = forVars.nextToken();
        String step = forVars.nextToken();
        String eTest = forVars.nextToken();
        boolean exists = false;
        if (eTest.length() > 0 && eTest.charAt(0) == '1' || eTest.length() > 0 && eTest.charAt(0) == '2') {
            exists = true;
        }
        FORNode node = new FORNode(var, min, max, step, exists);
        while (tokens.hasMoreTokens()) {
            String line = tokens.nextToken();
            if (line.startsWith("|FOR")) {
                StringTokenizer newFor = new StringTokenizer(line, ",");
                newFor.nextToken();
                if (newFor.nextToken().startsWith("%")) {
                    node.addChild(this.parseFORs(line, tokens));
                    continue;
                }
                node.addChild(line);
                continue;
            }
            if (line.startsWith("|IIF(") && line.lastIndexOf(44) < 0) {
                String expr = line.substring(5, line.lastIndexOf(41));
                node.addChild(this.parseIIFs(expr, tokens));
                continue;
            }
            if (line.startsWith("|ENDFOR|")) {
                return node;
            }
            node.addChild(line);
        }
        return node;
    }

    private IIFNode parseIIFs(String expr, StringTokenizer tokens) {
        IIFNode node = new IIFNode(expr);
        boolean childrenType = true;
        while (tokens.hasMoreTokens()) {
            String line = tokens.nextToken();
            if (line.startsWith("|FOR")) {
                StringTokenizer newFor = new StringTokenizer(line, ",");
                newFor.nextToken();
                if (newFor.nextToken().startsWith("%")) {
                    if (childrenType) {
                        node.addTrueChild(this.parseFORs(line, tokens));
                        continue;
                    }
                    node.addFalseChild(this.parseFORs(line, tokens));
                    continue;
                }
                if (childrenType) {
                    node.addTrueChild(line);
                    continue;
                }
                node.addFalseChild(line);
                continue;
            }
            if (line.startsWith("|IIF(") && line.lastIndexOf(44) < 0) {
                String newExpr = line.substring(5, line.lastIndexOf(41));
                if (childrenType) {
                    node.addTrueChild(this.parseIIFs(newExpr, tokens));
                    continue;
                }
                node.addFalseChild(this.parseIIFs(newExpr, tokens));
                continue;
            }
            if (line.startsWith("|ELSE|")) {
                childrenType = false;
                continue;
            }
            if (line.startsWith("|ENDIF|")) {
                return node;
            }
            if (childrenType) {
                node.addTrueChild(line);
                continue;
            }
            node.addFalseChild(line);
        }
        return node;
    }

    private void populateTokenMap() {
        if (tokenMap.isEmpty()) {
            this.addToTokenMap(new ACToken());
            this.addToTokenMap(new ACCheckToken());
            this.addToTokenMap(new AgeToken());
            this.addToTokenMap(new AlignmentToken());
            this.addToTokenMap(new AltHPToken());
            this.addToTokenMap(new AttackToken());
            this.addToTokenMap(new BaseMovementToken());
            this.addToTokenMap(new BioToken());
            this.addToTokenMap(new BirthplaceToken());
            this.addToTokenMap(new BonusListToken());
            this.addToTokenMap(new BonusToken());
            this.addToTokenMap(new CasterLevelToken());
            this.addToTokenMap(new CatchPhraseToken());
            this.addToTokenMap(new CheckToken());
            this.addToTokenMap(new ClassAbbToken());
            this.addToTokenMap(new ClassListToken());
            this.addToTokenMap(new ClassToken());
            this.addToTokenMap(new ColorToken());
            this.addToTokenMap(new CRToken());
            this.addToTokenMap(new DamageToken());
            this.addToTokenMap(new DefenseToken());
            this.addToTokenMap(new DeityToken());
            this.addToTokenMap(new DescToken());
            this.addToTokenMap(new DirToken());
            this.addToTokenMap(new DomainToken());
            this.addToTokenMap(new DRToken());
            this.addToTokenMap(new EclToken());
            this.addToTokenMap(new EqToken());
            this.addToTokenMap(new EqContainerToken());
            this.addToTokenMap(new EqContainersToken());
            this.addToTokenMap(new EqContainerwToken());
            this.addToTokenMap(new EqTypeToken());
            this.addToTokenMap(new EQSetToken());
            this.addToTokenMap(new ExpToken());
            this.addToTokenMap(new ExportToken());
            this.addToTokenMap(new FaceToken());
            this.addToTokenMap(new FavoredListToken());
            this.addToTokenMap(new FeatPointsToken());
            this.addToTokenMap(new FollowerOfToken());
            this.addToTokenMap(new GameModeToken());
            this.addToTokenMap(new GenderToken());
            this.addToTokenMap(new GoldToken());
            this.addToTokenMap(new HandedToken());
            this.addToTokenMap(new HeightToken());
            this.addToTokenMap(new HitDiceToken());
            this.addToTokenMap(new HPToken());
            this.addToTokenMap(new HPRollToken());
            this.addToTokenMap(new InitiativeModToken());
            this.addToTokenMap(new InitiativeMiscToken());
            this.addToTokenMap(new InitiativeBonusToken());
            this.addToTokenMap(new InterestsToken());
            this.addToTokenMap(new LanguagesToken());
            this.addToTokenMap(new LengthToken());
            this.addToTokenMap(new LevelToken());
            this.addToTokenMap(new LocationToken());
            this.addToTokenMap(new MaxCCSkillLevelToken());
            this.addToTokenMap(new MaxDexToken());
            this.addToTokenMap(new MaxSkillLevelToken());
            this.addToTokenMap(new MoveToken());
            this.addToTokenMap(new MovementToken());
            this.addToTokenMap(new NameToken());
            this.addToTokenMap(new NoteToken());
            this.addToTokenMap(new PaperInfoToken());
            this.addToTokenMap(new Personality1Token());
            this.addToTokenMap(new Personality2Token());
            this.addToTokenMap(new PhobiasToken());
            this.addToTokenMap(new PipeToken());
            this.addToTokenMap(new PlayerNameToken());
            this.addToTokenMap(new PortraitToken());
            this.addToTokenMap(new PoolToken());
            this.addToTokenMap(new ProhibitedListToken());
            this.addToTokenMap(new RaceToken());
            this.addToTokenMap(new ReachToken());
            this.addToTokenMap(new RegionToken());
            this.addToTokenMap(new ResidenceToken());
            this.addToTokenMap(new SizeToken());
            this.addToTokenMap(new SizeLongToken());
            this.addToTokenMap(new SizeModToken());
            this.addToTokenMap(new SkillLevelToken());
            this.addToTokenMap(new SkillpointsToken());
            this.addToTokenMap(new SkillToken());
            this.addToTokenMap(new SkillSubsetToken());
            this.addToTokenMap(new SkillTypeToken());
            this.addToTokenMap(new SpecialAbilityToken());
            this.addToTokenMap(new SpeechTendancyToken());
            this.addToTokenMap(new SpellFailureToken());
            this.addToTokenMap(new SpellListBookToken());
            this.addToTokenMap(new SpellListCastToken());
            this.addToTokenMap(new SpellListClassToken());
            this.addToTokenMap(new SpellListDcToken());
            this.addToTokenMap(new SpellListDcStatToken());
            this.addToTokenMap(new SpellListKnownToken());
            this.addToTokenMap(new SpellListTypeToken());
            this.addToTokenMap(new SpellMemToken());
            this.addToTokenMap(new SpellPointsToken());
            this.addToTokenMap(new SRToken());
            this.addToTokenMap(new StatToken());
            this.addToTokenMap(new SubRegionToken());
            this.addToTokenMap(new TabNameToken());
            this.addToTokenMap(new TempBonusToken());
            this.addToTokenMap(new TemplateListToken());
            this.addToTokenMap(new TemplateToken());
            this.addToTokenMap(new TotalToken());
            this.addToTokenMap(new TotalLevelsToken());
            this.addToTokenMap(new TypeToken());
            this.addToTokenMap(new VarToken());
            this.addToTokenMap(new VisionToken());
            this.addToTokenMap(new WeaponProfsToken());
            this.addToTokenMap(new WeaponToken());
            this.addToTokenMap(new WeaponhToken());
            this.addToTokenMap(new WeaponoToken());
            this.addToTokenMap(new WeaponpToken());
            this.addToTokenMap(new WeightToken());
        }
    }

    private static void printFeat(int numberPos, String aString, List anArrayList, BufferedWriter output) {
        Feat aFeat;
        boolean FEAT_DEFAULT = false;
        boolean FEAT_VISIBLE = true;
        int FEAT_HIDDEN = 2;
        int FEAT_ALL = 3;
        String typeStr = "";
        int visibility = 0;
        String featType = null;
        int i = -1;
        StringTokenizer aTok = new StringTokenizer(aString, ".");
        String fString = aTok.nextToken();
        if (fString.equals("FEATALL")) {
            visibility = 3;
        }
        if ("FEAT".equals(fString) || "VFEAT".equals(fString) || "FEATALL".equals(fString) || "FEATAUTO".equals(fString)) {
            while (aTok.hasMoreTokens()) {
                String bString = aTok.nextToken();
                try {
                    i = Integer.parseInt(bString);
                    break;
                }
                catch (NumberFormatException exc) {
                    if (bString.equals("VISIBLE")) {
                        visibility = 1;
                        continue;
                    }
                    if (bString.equals("HIDDEN")) {
                        visibility = 2;
                        continue;
                    }
                    if (bString.equals("ALL")) {
                        visibility = 3;
                        continue;
                    }
                    featType = bString;
                }
            }
            if (aTok.hasMoreTokens() && !(typeStr = aTok.nextToken()).startsWith("TYPE") && !typeStr.startsWith("!TYPE")) {
                typeStr = "";
            }
        }
        ArrayList<Feat> aList = new ArrayList<Feat>();
        Globals.sortPObjectList(anArrayList);
        Iterator e = anArrayList.iterator();
        while (e.hasNext()) {
            aFeat = (Feat)e.next();
            boolean matchTypeDef = false;
            boolean matchVisibilityDef = false;
            if (featType != null) {
                if (aFeat.isType(featType)) {
                    matchTypeDef = true;
                }
            } else {
                matchTypeDef = true;
            }
            if (aString.indexOf(".!TYPE") >= 0 && typeStr.length() > 6) {
                matchTypeDef = !aFeat.isType(typeStr.substring(6));
            } else if (aString.indexOf(".TYPE") >= 0 && typeStr.length() > 5) {
                matchTypeDef = aFeat.isType(typeStr.substring(5));
            }
            if (aFeat.isVisible() == 0 || aFeat.isVisible() == 3) {
                if (visibility == 2) {
                    matchVisibilityDef = true;
                }
            } else if (visibility == 3) {
                matchVisibilityDef = true;
            } else if (!(aFeat.isVisible() != 1 && aFeat.isVisible() != 2 || visibility != 0 && visibility != 1)) {
                matchVisibilityDef = true;
            }
            if (!matchTypeDef || !matchVisibilityDef) continue;
            aList.add(aFeat);
        }
        if (i < aList.size()) {
            aFeat = (Feat)aList.get(i);
            if (aString.endsWith(".DESC")) {
                FileAccess.encodeWrite(output, aFeat.getDescription());
            } else if (aString.endsWith(".TYPE")) {
                FileAccess.encodeWrite(output, aFeat.getType());
            } else if (aString.endsWith(".ASSOCIATED")) {
                StringBuffer buf = new StringBuffer();
                for (int j = 0; j < aFeat.getAssociatedCount(); ++j) {
                    if (j != 0) {
                        buf.append(",");
                    }
                    buf.append(aFeat.getAssociated(j));
                }
                FileAccess.encodeWrite(output, buf.toString());
            } else if (aString.endsWith(".ASSOCIATEDCOUNT")) {
                FileAccess.encodeWrite(output, Integer.toString(aFeat.getAssociatedCount()));
            } else {
                FileAccess.encodeWrite(output, aFeat.qualifiedName());
            }
        } else if (existsOnly) {
            noMoreItems = true;
        }
    }

    private static void printFeatList(String delim, List aArrayList, BufferedWriter output) {
        if (delim == null || "".equals(delim)) {
            delim = ", ";
        }
        String aString = "";
        if (delim.lastIndexOf(46) >= 0) {
            try {
                aString = delim.substring(delim.lastIndexOf(46));
            }
            catch (StringIndexOutOfBoundsException e) {
                return;
            }
        }
        delim = ", ";
        int i = 0;
        int dotpos = aString.indexOf(46);
        String typeStr = "";
        if (aString.indexOf("TYPE") > 0) {
            typeStr = aString.substring(dotpos);
        }
        Globals.sortPObjectList(aArrayList);
        Iterator e = aArrayList.iterator();
        while (e.hasNext()) {
            Feat aFeat = (Feat)e.next();
            StringTokenizer st = null;
            int clusive = 0;
            boolean match = false;
            if (aString.indexOf(".TYPE=") >= 0) {
                clusive = 1;
                st = new StringTokenizer(typeStr.substring(5), "=");
            } else if (aString.indexOf(".!TYPE=") >= 0) {
                clusive = 2;
                st = new StringTokenizer(typeStr.substring(6), "=");
            }
            if (clusive == 1 || clusive == 2) {
                while (st.hasMoreTokens()) {
                    String test = st.nextToken();
                    if (!aFeat.isType(test)) continue;
                    match = true;
                }
            }
            boolean doIprint = true;
            if (clusive == 1 && !match || clusive == 2 && match) {
                doIprint = false;
            }
            if (!doIprint || aFeat.isVisible() != 1 && aFeat.isVisible() != 2) continue;
            if (i > 0) {
                FileAccess.write(output, delim);
            }
            FileAccess.encodeWrite(output, aFeat.qualifiedName());
            ++i;
        }
    }

    private void replaceLine(String aLine, BufferedWriter output, PlayerCharacter aPC) {
        boolean inPipe = false;
        StringBuffer tokString = new StringBuffer("");
        if (!inPipe && aLine.lastIndexOf(124) < 0) {
            if (aLine.length() > 0) {
                this.outputNonToken(aLine, output);
            }
        } else if (inPipe && aLine.lastIndexOf(124) < 0 || !inPipe && aLine.lastIndexOf(124) == 0) {
            tokString.append(aLine.substring(aLine.lastIndexOf(124) + 1));
            inPipe = true;
        } else {
            StringTokenizer bTok;
            boolean flag;
            if (!inPipe && aLine.charAt(0) == '|') {
                inPipe = true;
            }
            boolean bl = flag = (bTok = new StringTokenizer(aLine, "|", false)).countTokens() == 1;
            while (bTok.hasMoreTokens()) {
                String bString = bTok.nextToken();
                if (!inPipe) {
                    this.outputNonToken(bString, output);
                } else if (bTok.hasMoreTokens() || flag || inPipe && !bTok.hasMoreTokens() && aLine.charAt(aLine.length() - 1) == '|') {
                    this.replaceToken(tokString.toString() + bString, output, aPC);
                    tokString = new StringBuffer("");
                } else {
                    tokString.append(bString);
                }
                if (!bTok.hasMoreTokens() && !flag) continue;
                inPipe = !inPipe;
            }
            if (inPipe && aLine.charAt(aLine.length() - 1) == '|') {
                inPipe = false;
            }
        }
    }

    private int replaceToken(String aString, BufferedWriter output, PlayerCharacter aPC) {
        try {
            int len = 1;
            if (!this.canWrite && aString.length() > 0 && aString.charAt(0) != '%') {
                return 0;
            }
            if ("%".equals(aString)) {
                this.inLabel = false;
                this.canWrite = true;
                return 0;
            }
            FileAccess.maxLength(-1);
            if (aString.length() > 0 && aString.charAt(0) == '%' && aString.length() > 1 && aString.lastIndexOf(60) < 0 && aString.lastIndexOf(62) < 0) {
                StringTokenizer aTok;
                boolean found = false;
                this.canWrite = true;
                int merge = 0;
                if (aString.indexOf("MERGENONE") > 0) {
                    merge = 1;
                }
                if (aString.indexOf("MERGELOC") > 0) {
                    merge = 2;
                }
                if (aString.substring(1).startsWith("GAMEMODE:")) {
                    if (aString.substring(10).endsWith(GameModeToken.getGameModeToken())) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("REGION".equals(aString.substring(1))) {
                    if (aPC.getRegion().equals("None")) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("NOTES".equals(aString.substring(1))) {
                    if (aPC.getNotesList().size() <= 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("SKILLPOINTS".equals(aString.substring(1))) {
                    if (SkillpointsToken.getUnusedSkillPoints(aPC) == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if (aString.substring(1).startsWith("TEMPLATE")) {
                    int index;
                    StringTokenizer aTok2 = new StringTokenizer(aString.substring(1), ".");
                    ArrayList tList = aPC.getTemplateList();
                    String fString = aTok2.nextToken();
                    if (aTok2.hasMoreTokens()) {
                        index = Integer.parseInt(aTok2.nextToken());
                    } else {
                        if ("TEMPLATE".equals(fString)) {
                            if (tList.isEmpty()) {
                                this.canWrite = false;
                            }
                            return 0;
                        }
                        Logging.errorPrint("Old syntax %TEMPLATEx will be replaced for %TEMPLATE.x");
                        index = Integer.parseInt(aString.substring(9));
                    }
                    if (index >= tList.size()) {
                        this.canWrite = false;
                        return 0;
                    }
                    if (((PCTemplate)tList.get(index)).isVisible() != 1 && ((PCTemplate)tList.get(index)).isVisible() != 2) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("FOLLOWER".equals(aString.substring(1))) {
                    if (aPC.getFollowerList().isEmpty()) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("FOLLOWEROF".equals(aString.substring(1))) {
                    if (aPC.getMasterPC() == null) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if (aString.substring(1).startsWith("FOLLOWERTYPE.")) {
                    ArrayList<Follower> aList = new ArrayList<Follower>();
                    Iterator iter = aPC.getFollowerList().iterator();
                    while (iter.hasNext()) {
                        Follower aFollower = (Follower)iter.next();
                        Iterator p = Globals.getPCList().iterator();
                        while (p.hasNext()) {
                            PlayerCharacter lPC = (PlayerCharacter)p.next();
                            if (!lPC.getFileName().equals(aFollower.getFileName())) continue;
                            aList.add(aFollower);
                        }
                    }
                    StringTokenizer aTok3 = new StringTokenizer(aString, ".");
                    aTok3.nextToken();
                    String typeString = aTok3.nextToken();
                    for (int i = aList.size() - 1; i >= 0; --i) {
                        Follower fol = (Follower)aList.get(i);
                        if (fol.getType().equalsIgnoreCase(typeString)) continue;
                        aList.remove(i);
                    }
                    if (aList.isEmpty()) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("PROHIBITEDLIST".equals(aString.substring(1))) {
                    Iterator iter = aPC.getClassList().iterator();
                    while (iter.hasNext()) {
                        PCClass aClass = (PCClass)iter.next();
                        if (aClass.getLevel() <= 0 || aClass.getProhibitedString().equals("None")) continue;
                        return 0;
                    }
                    this.canWrite = false;
                    return 0;
                }
                if ("CATCHPHRASE".equals(aString.substring(1))) {
                    if (aPC.getCatchPhrase().equals("None")) {
                        this.canWrite = false;
                    } else if (aPC.getCatchPhrase().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("LOCATION".equals(aString.substring(1))) {
                    if (aPC.getLocation().equals("None")) {
                        this.canWrite = false;
                    } else if (aPC.getLocation().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("RESIDENCE".equals(aString.substring(1))) {
                    if (aPC.getResidence().equals("None")) {
                        this.canWrite = false;
                    } else if (aPC.getResidence().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("PHOBIAS".equals(aString.substring(1))) {
                    if (aPC.getPhobias().equals("None")) {
                        this.canWrite = false;
                    } else if (aPC.getPhobias().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("INTERESTS".equals(aString.substring(1))) {
                    if (aPC.getInterests().equals("None")) {
                        this.canWrite = false;
                    } else if (aPC.getInterests().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("SPEECHTENDENCY".equals(aString.substring(1))) {
                    if (aPC.getSpeechTendency().equals("None")) {
                        this.canWrite = false;
                    } else if (aPC.getSpeechTendency().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("PERSONALITY1".equals(aString.substring(1))) {
                    if (aPC.getTrait1().equals("None")) {
                        this.canWrite = false;
                    } else if (aPC.getTrait1().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("PERSONALITY2".equals(aString.substring(1))) {
                    if (aPC.getTrait2().equals("None")) {
                        this.canWrite = false;
                    } else if (aPC.getTrait2().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("MISC.FUNDS".equals(aString.substring(1))) {
                    if (aPC.getMiscList().get(0).equals("None")) {
                        this.canWrite = false;
                    } else if (((String)aPC.getMiscList().get(0)).trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("COMPANIONS".equals(aString.substring(1)) || "MISC.COMPANIONS".equals(aString.substring(1))) {
                    if (aPC.getMiscList().get(1).equals("None")) {
                        this.canWrite = false;
                    } else if (((String)aPC.getMiscList().get(1)).trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("MISC.MAGIC".equals(aString.substring(1))) {
                    if (aPC.getMiscList().get(2).equals("None")) {
                        this.canWrite = false;
                    } else if (((String)aPC.getMiscList().get(2)).trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("DESC".equals(aString.substring(1))) {
                    if (aPC.getDescription().equals("None")) {
                        this.canWrite = false;
                    } else if (aPC.getDescription().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("BIO".equals(aString.substring(1))) {
                    if (aPC.getBio().equals("None")) {
                        this.canWrite = false;
                    } else if (aPC.getBio().trim().length() == 0) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("SUBREGION".equals(aString.substring(1))) {
                    if (aPC.getSubRegion().equals("None")) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if (aString.substring(1).startsWith("TEMPBONUS.")) {
                    aTok = new StringTokenizer(aString.substring(1), ".");
                    int index = -1;
                    aTok.nextToken();
                    if (aTok.hasMoreTokens()) {
                        index = Integer.parseInt(aTok.nextToken());
                    }
                    if (index > aPC.getNamedTempBonusList().size()) {
                        this.canWrite = false;
                        return 0;
                    }
                    if (aPC.getUseTempMods()) {
                        this.canWrite = true;
                        return 1;
                    }
                }
                if (aString.substring(1).startsWith("ARMOR.ITEM")) {
                    int count;
                    aTok = new StringTokenizer(aString.substring(1), ".");
                    aTok.nextToken();
                    String fString = aTok.nextToken();
                    ArrayList<Equipment> aArrayList = new ArrayList<Equipment>();
                    Iterator e = aPC.getEquipmentListInOutputOrder().iterator();
                    while (e.hasNext()) {
                        Equipment eq = (Equipment)e.next();
                        if (!eq.getBonusListString("AC") || eq.isArmor() || eq.isShield()) continue;
                        aArrayList.add(eq);
                    }
                    if (aTok.hasMoreTokens()) {
                        count = Integer.parseInt(aTok.nextToken());
                    } else {
                        Logging.errorPrint("Old syntax %ARMOR.ITEMx will be replaced for %ARMOR.ITEM.x");
                        count = Integer.parseInt(fString.substring(fString.length() - 1));
                    }
                    if (count > aArrayList.size()) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if (aString.substring(1).startsWith("ARMOR.SHIELD")) {
                    int count;
                    aTok = new StringTokenizer(aString.substring(1), ".");
                    aTok.nextToken();
                    String fString = aTok.nextToken();
                    List aArrayList = aPC.getEquipmentOfTypeInOutputOrder("SHIELD", 3);
                    if (aTok.hasMoreTokens()) {
                        count = Integer.parseInt(aTok.nextToken());
                    } else {
                        Logging.errorPrint("Old syntax %ARMOR.SHIELDx will be replaced for %ARMOR.SHIELD.x");
                        count = Integer.parseInt(fString.substring(fString.length() - 1));
                    }
                    if (count > aArrayList.size()) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if (aString.substring(1).startsWith("ARMOR")) {
                    int count;
                    aTok = new StringTokenizer(aString.substring(1), ".");
                    String fString = aTok.nextToken();
                    List aArrayList = aPC.getEquipmentOfTypeInOutputOrder("ARMOR", 3);
                    List shieldList = aPC.getEquipmentOfTypeInOutputOrder("SHIELD", 3);
                    for (int z = 0; z < shieldList.size(); ++z) {
                        aArrayList.remove(shieldList.get(z));
                    }
                    if (aTok.hasMoreTokens()) {
                        count = Integer.parseInt(aTok.nextToken());
                    } else {
                        Logging.errorPrint("Old syntax %ARMORx will be replaced for %ARMOR.x");
                        count = Integer.parseInt(fString.substring(fString.length() - 1));
                    }
                    if (count > aArrayList.size()) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if ("WEAPONPROF".equals(aString.substring(1))) {
                    if (!SettingsHandler.getWeaponProfPrintout()) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if (aString.substring(1).startsWith("WEAPON")) {
                    aTok = new StringTokenizer(aString.substring(1), ".");
                    String fString = aTok.nextToken();
                    int count = 0;
                    List aArrayList = aPC.getExpandedWeapons(merge);
                    if (aTok.hasMoreTokens()) {
                        count = Integer.parseInt(aTok.nextToken());
                    } else {
                        Logging.errorPrint("Old syntax %WEAPONx will be replaced for %WEAPON.x");
                        count = Integer.parseInt(fString.substring(fString.length() - 1));
                    }
                    if (count >= aArrayList.size()) {
                        this.canWrite = false;
                    }
                    return 0;
                }
                if (aString.substring(1).startsWith("DOMAIN")) {
                    int index;
                    aTok = new StringTokenizer(aString.substring(1), ".");
                    String fString = aTok.nextToken();
                    if (aTok.hasMoreTokens()) {
                        index = Integer.parseInt(aTok.nextToken());
                    } else {
                        Logging.errorPrint("Old syntax %DOMAINx will be replaced for %DOMAIN.x");
                        index = Integer.parseInt(fString.substring(6));
                    }
                    this.canWrite = index <= aPC.getCharacterDomainList().size();
                    return 0;
                }
                if (aString.substring(1).startsWith("SPELLLISTBOOK")) {
                    if (SettingsHandler.getPrintSpellsWithPC()) {
                        aString = aString.charAt(14) == '.' ? aString.substring(15) : aString.substring(14);
                        return this.replaceTokenSpellListBook(aString, aPC);
                    }
                    this.canWrite = false;
                    return 0;
                }
                if (aString.substring(1).startsWith("VAR.")) {
                    this.replaceTokenVar(aString, aPC);
                    return 0;
                }
                if (aString.substring(1).startsWith("COUNT[")) {
                    if (this.getVarValue(aString.substring(1), aPC) > 0) {
                        this.canWrite = true;
                        return 1;
                    }
                    this.canWrite = false;
                    return 0;
                }
                aTok = new StringTokenizer(aString.substring(1), ",", false);
                while (aTok.hasMoreTokens()) {
                    String cString = aTok.nextToken();
                    StringTokenizer bTok = new StringTokenizer(cString, "=", false);
                    String bString = bTok.nextToken();
                    int i = 0;
                    if (bTok.hasMoreTokens()) {
                        i = Integer.parseInt(bTok.nextToken());
                    }
                    PCClass aClass = aPC.getClassNamed(bString);
                    PCClass bClass = Globals.getClassNamed(bString);
                    boolean bl = found = bClass != null;
                    if (bClass != null && aClass != null) {
                        this.canWrite = aClass.getLevel() >= i;
                        continue;
                    }
                    if (bClass != null && aClass == null) {
                        this.canWrite = false;
                        continue;
                    }
                    if (!bString.startsWith("SPELLLISTCLASS")) continue;
                    bString = bString.charAt(14) == '.' ? bString.substring(15) : bString.substring(14);
                    found = true;
                    PObject aObject = aPC.getSpellClassAtIndex(Integer.parseInt(bString));
                    this.canWrite = aObject != null;
                }
                if (found) {
                    this.inLabel = true;
                    return 0;
                }
                this.canWrite = false;
                this.inLabel = true;
                return 0;
            }
            if (aString.indexOf("SUB") == 0 && aString.indexOf(".") > 3) {
                int iEnd = aString.indexOf(".");
                int maxLength = -1;
                try {
                    maxLength = Integer.parseInt(aString.substring(3, iEnd));
                }
                catch (NumberFormatException ex) {
                    Logging.errorPrint("Number format error: " + aString);
                    maxLength = -1;
                }
                if (maxLength > 0) {
                    aString = aString.substring(iEnd + 1);
                    FileAccess.maxLength(maxLength);
                }
            }
            if (tokenMap.isEmpty()) {
                this.populateTokenMap();
            }
            aString = this.correctOldFormatTag(aString);
            StringTokenizer tok = new StringTokenizer(aString, ".,", false);
            String firstToken = tok.nextToken();
            String testString = aString;
            if (testString.indexOf(44) > -1) {
                testString = testString.substring(0, testString.indexOf(44));
            }
            if (testString.indexOf(126) > -1) {
                testString = testString.substring(0, testString.indexOf(126));
            }
            if (aString.startsWith("FOR.") || aString.startsWith("DFOR.")) {
                FileAccess.maxLength(-1);
                existsOnly = false;
                noMoreItems = false;
                this.checkBefore = false;
                this.replaceTokenForDfor(aString, output, aPC);
                existsOnly = false;
                noMoreItems = false;
                return 0;
            }
            if (aString.startsWith("OIF(")) {
                this.replaceTokenIIF(aString, output, aPC);
            } else {
                if (!(testString.indexOf(40) < 0 && testString.indexOf(43) < 0 && testString.indexOf(45) < 0 && testString.indexOf(".INTVAL") < 0 && testString.indexOf(".SIGN") < 0 && testString.indexOf(".NOZERO") < 0 && testString.indexOf(".TRUNC") < 0 && testString.indexOf(42) < 0 && testString.indexOf(47) < 0 || skipMath)) {
                    FileAccess.maxLength(-1);
                    FileAccess.write(output, this.mathMode(aString, aPC));
                    return 0;
                }
                if (aString.startsWith("CSHEETTAG2.")) {
                    this.csheetTag2 = aString.substring(11, 12);
                    FileAccess.maxLength(-1);
                    return 0;
                }
                if (tokenMap.get(firstToken) != null) {
                    Token token = (Token)tokenMap.get(firstToken);
                    if (token.getTokenName().equals("NOTE") || token.getTokenName().startsWith("EQ")) {
                        FileAccess.write(output, token.getToken(aString, aPC));
                    } else {
                        FileAccess.encodeWrite(output, token.getToken(aString, aPC, this));
                    }
                } else if (aString.startsWith("FOLLOWER")) {
                    this.replaceTokenFollowers(aString, output, aPC);
                } else if (aString.startsWith("FEATALLLIST")) {
                    ExportHandler.printFeatList(aString.substring(11), aPC.aggregateVisibleFeatList(), output);
                } else if (aString.startsWith("FEATAUTOLIST")) {
                    ExportHandler.printFeatList(aString.substring(12), aPC.featAutoList(), output);
                } else if (aString.startsWith("FEATLIST")) {
                    ExportHandler.printFeatList(aString.substring(8), aPC.getFeatList(), output);
                } else if (aString.startsWith("VFEATLIST")) {
                    ExportHandler.printFeatList(aString.substring(9), aPC.getVirtualFeatList(), output);
                } else if (aString.startsWith("FEATALL")) {
                    ExportHandler.printFeat(7, aString, aPC.aggregateFeatList(), output);
                } else if (aString.startsWith("FEATAUTO")) {
                    ExportHandler.printFeat(8, aString, aPC.featAutoList(), output);
                } else if (aString.startsWith("FEAT")) {
                    ExportHandler.printFeat(4, aString, aPC.getFeatList(), output);
                } else if (aString.startsWith("VFEAT")) {
                    ExportHandler.printFeat(5, aString, aPC.getVirtualFeatList(), output);
                } else if (aString.startsWith("MISC.")) {
                    int i = -1;
                    if (aString.substring(5).startsWith("FUNDS")) {
                        i = 0;
                    } else if (aString.substring(5).startsWith("COMPANIONS")) {
                        i = 1;
                    } else if (aString.substring(5).startsWith("MAGIC")) {
                        i = 2;
                    }
                    int k = aString.lastIndexOf(44);
                    aString = k >= 0 ? aString.substring(k + 1) : "";
                    if (i >= 0) {
                        List stringList = this.getLineForMiscList(i, aPC);
                        for (i = 0; i < stringList.size(); ++i) {
                            FileAccess.encodeWrite(output, (String)stringList.get(i));
                            FileAccess.write(output, aString);
                        }
                    }
                } else if ("SKILLLISTMODS".equals(aString)) {
                    this.replaceTokenSkillListMods(output, aPC);
                } else if (aString.startsWith("SPECIALLIST")) {
                    len = this.replaceTokenSpecialList(aString, output, aPC);
                } else if (aString.startsWith("SPELLBOOKNAME")) {
                    int bookNum;
                    StringTokenizer aTok = new StringTokenizer(aString, ".");
                    String bString = aTok.nextToken();
                    if ("SPELLBOOKNAME".equals(bString)) {
                        bookNum = Integer.parseInt(aTok.nextToken());
                    } else {
                        Logging.errorPrint("Old syntax SPELLBOOKNAMEx will be replaced for SPELLBOOKNAME.x");
                        bookNum = Integer.parseInt(aString.substring(13));
                    }
                    FileAccess.write(output, (String)aPC.getSpellBooks().get(bookNum));
                } else if (aString.startsWith("ARMOR")) {
                    len = this.replaceTokenArmor(aString, len, output, aPC);
                } else {
                    len = aString.trim().length();
                    if (aString.length() > 0) {
                        FileAccess.write(output, aString);
                    }
                }
            }
            FileAccess.maxLength(-1);
            return len;
        }
        catch (Exception exc) {
            Logging.errorPrint("Error replacing " + aString, exc);
            return 0;
        }
    }

    private String correctOldFormatTag(String aString) {
        StringBuffer converted = new StringBuffer();
        if (aString.startsWith("SPELLIST")) {
            StringTokenizer aTok = new StringTokenizer(aString, ".");
            String fString = aTok.nextToken();
            if (fString.charAt(fString.length() - 1) >= '0' && fString.charAt(fString.length() - 1) <= '9') {
                if (aString.regionMatches(9, "TYPE", 0, 4) || aString.regionMatches(9, "BOOK", 0, 4) || aString.regionMatches(9, "CAST", 0, 4)) {
                    converted.append(aString.substring(0, 14));
                    converted.append('.');
                    converted.append(aString.substring(14));
                } else if (aString.regionMatches(9, "KNOWN", 0, 5) || aString.regionMatches(9, "CLASS", 0, 5)) {
                    converted.append(aString.substring(0, 15));
                    converted.append('.');
                    converted.append(aString.substring(15));
                } else if (aString.regionMatches(9, "DCSTAT", 0, 6)) {
                    converted.append(aString.substring(0, 16));
                    converted.append('.');
                    converted.append(aString.substring(16));
                } else if (aString.regionMatches(9, "DC", 0, 2)) {
                    converted.append(aString.substring(0, 12));
                    converted.append('.');
                    converted.append(aString.substring(12));
                }
            }
        } else if (aString.startsWith("SPELLMEM")) {
            if (aString.length() > 8 && aString.charAt(8) != '.') {
                converted.append(aString.substring(0, 8));
                converted.append('.');
                converted.append(aString.substring(8));
            }
        } else if (aString.startsWith("SKILLSUBSET")) {
            if (aString.length() > 11 && aString.charAt(11) != '.') {
                converted.append(aString.substring(0, 11));
                converted.append('.');
                converted.append(aString.substring(11));
            }
        } else if (aString.startsWith("SKILLTYPE")) {
            if (aString.length() > 9 && aString.charAt(9) != '.') {
                converted.append(aString.substring(0, 9));
                converted.append('.');
                converted.append(aString.substring(9));
            }
        } else if (!(!aString.startsWith("SKILL") || aString.startsWith("SKILLLEVEL") || aString.startsWith("SKILLLISTMODS") || aString.startsWith("SKILLPOINTS") || aString.startsWith("SKILLSUBSET") || aString.startsWith("SKILLTYPE") || aString.length() <= 5 || aString.charAt(5) == '.')) {
            converted.append(aString.substring(0, 5));
            converted.append('.');
            converted.append(aString.substring(5));
        }
        if (converted.length() > 0) {
            Logging.errorPrint("Old syntax '" + aString + "' replaced with '" + converted.toString() + "'.");
            return converted.toString();
        }
        return aString;
    }

    private int replaceTokenArmor(String aString, int len, BufferedWriter output, PlayerCharacter aPC) {
        StringTokenizer aTok = new StringTokenizer(aString, ".");
        String[] tokens = new String[aTok.countTokens()];
        int i = 0;
        while (aTok.hasMoreTokens()) {
            tokens[i] = aTok.nextToken();
            ++i;
        }
        String property = "";
        if (tokens.length > 0) {
            property = tokens[tokens.length - 1];
        }
        int equipped = 3;
        int index = 0;
        String type = "";
        String subtype = "";
        int merge = 0;
        for (int i2 = 0; i2 < tokens.length; ++i2) {
            if ("ARMOR".equals(tokens[i2])) continue;
            if (tokens[i2].startsWith("ARMOR")) {
                Logging.errorPrint("Old syntax ARMORx will be replaced for ARMOR.x");
                index = Integer.parseInt(tokens[i2].substring(5));
                continue;
            }
            if ("ALL".equals(tokens[i2])) {
                equipped = 3;
                continue;
            }
            if (tokens[i2].startsWith("ALL")) {
                Logging.errorPrint("Old syntax ALLx will be replaced for ALL.x");
                index = Integer.parseInt(tokens[i2].substring(3));
                equipped = 3;
                continue;
            }
            if ("EQUIPPED".equals(tokens[i2])) {
                equipped = 1;
                continue;
            }
            if (tokens[i2].startsWith("EQUIPPED")) {
                Logging.errorPrint("Old syntax EQUIPPEDx will be replaced for EQUIPPED.x");
                index = Integer.parseInt(tokens[i2].substring(8));
                equipped = 1;
                continue;
            }
            if ("NOT_EQUIPPED".equals(tokens[i2])) {
                equipped = 2;
                continue;
            }
            if (tokens[i2].startsWith("NOT_EQUIPPED")) {
                Logging.errorPrint("Old syntax NOT_EQUIPPEDx will be replaced for NOT_EQUIPPED.x");
                index = Integer.parseInt(tokens[i2].substring(12));
                equipped = 2;
                continue;
            }
            if (tokens[i2].equals("MERGENONE")) {
                merge = 1;
                continue;
            }
            if (tokens[i2].equals("MERGELOC")) {
                merge = 2;
                continue;
            }
            if (tokens[i2].equals("MERGEALL")) {
                merge = 0;
                continue;
            }
            if (tokens[i2].equals("ISTYPE")) {
                property = tokens[i2] + "." + tokens[i2 + 1];
                break;
            }
            if (i2 < tokens.length - 1) {
                try {
                    index = Integer.parseInt(tokens[i2]);
                }
                catch (NumberFormatException exc) {
                    if ("".equals(type)) {
                        type = tokens[i2];
                        continue;
                    }
                    subtype = tokens[i2];
                }
                continue;
            }
            property = tokens[i2];
        }
        if ("".equals(type)) {
            return this._replaceTokenArmor(index, property, equipped, len, output, merge, aPC);
        }
        if ("SUIT".equals(type)) {
            return this._replaceTokenArmorSuit(index, subtype, property, equipped, len, output, merge, aPC);
        }
        if ("SHIRT".equals(type)) {
            return this._replaceTokenArmorShirt(index, subtype, property, equipped, len, output, merge, aPC);
        }
        if ("SHIELD".equals(type)) {
            return this._replaceTokenArmorShield(index, subtype, property, equipped, len, output, merge, aPC);
        }
        if ("ITEM".equals(type) || "ACITEM".equals(type)) {
            return this._replaceTokenArmorItem(index, subtype, property, equipped, len, output, merge, aPC);
        }
        return this._replaceTokenArmorVarious(index, type, subtype, property, equipped, len, output, merge, aPC);
    }

    private void replaceTokenClass(String aString, BufferedWriter output, PlayerCharacter aPC) {
        int classSize;
        boolean TOKEN_CLASS = false;
        boolean TOKEN_CLASSLIST = true;
        int TOKEN_CLASSABB = 2;
        int TOKEN_CLASSLEVEL = 3;
        int TOKEN_CLASSSALIST = 4;
        int i = 0;
        int y = 0;
        int cmp = 0;
        StringTokenizer aTok = new StringTokenizer(aString, ".");
        String fString = aTok.nextToken();
        if ("CLASSLIST".equals(fString) || "CLASSABB".equals(fString) || "CLASS".equals(fString)) {
            if ("CLASSLIST".equals(fString)) {
                cmp = 1;
            } else if ("CLASSABB".equals(fString)) {
                cmp = 2;
            }
            if (aTok.hasMoreTokens()) {
                i = Integer.parseInt(aTok.nextToken());
            }
            if (aTok.hasMoreTokens()) {
                String bString = aTok.nextToken();
                if ("LEVEL".equals(bString)) {
                    cmp = 3;
                } else if ("SALIST".equals(bString)) {
                    cmp = 4;
                }
            }
        } else {
            Logging.errorPrint("Old syntax CLASSx will be replaced for CLASS.x");
            if ("CLASSLIST".equals(aString)) {
                cmp = 1;
            } else if (aString.lastIndexOf("ABB") >= 0) {
                i = Integer.parseInt(fString.substring(8));
                cmp = 2;
            } else {
                i = fString.charAt(5) - 48;
            }
            if (aString.endsWith("LEVEL")) {
                cmp = 3;
            }
            if (aString.endsWith("SALIST")) {
                cmp = 4;
            }
        }
        if (i >= (classSize = aPC.getClassList().size()) && existsOnly) {
            noMoreItems = true;
            return;
        }
        Iterator e = aPC.getClassList().iterator();
        while (e.hasNext()) {
            PCClass aClass = (PCClass)e.next();
            if (SettingsHandler.hideMonsterClasses() && aClass.isMonster()) continue;
            if (cmp == 1 && y++ > 0) {
                FileAccess.write(output, " ");
            }
            if (aClass.getLevel() > 0) {
                --i;
            }
            if (i != -1 && cmp != 1) continue;
            if (cmp < 2) {
                if ("None".equals(aClass.getSubClassName()) || "".equals(aClass.getSubClassName())) {
                    FileAccess.encodeWrite(output, aClass.getOutputName());
                } else {
                    FileAccess.encodeWrite(output, aClass.getSubClassName());
                }
            }
            if (cmp == 1 || cmp == 3) {
                FileAccess.write(output, Integer.toString(aClass.getLevel()));
                continue;
            }
            if (cmp == 2) {
                SubClass subClass;
                String subClassName = aClass.getDisplayClassName();
                if (!aClass.getName().equals(subClassName) && (subClass = aClass.getSubClassNamed(subClassName)) != null) {
                    aClass = subClass;
                }
                FileAccess.encodeWrite(output, aClass.getAbbrev());
                continue;
            }
            if (cmp == 4) {
                List saList = aClass.getClassSpecialAbilityList(aPC);
                int x = 0;
                Iterator e1 = saList.iterator();
                while (e1.hasNext()) {
                    if (x++ > 0) {
                        FileAccess.write(output, ", ");
                    }
                    FileAccess.write(output, e1.next().toString());
                }
                continue;
            }
            if (cmp == 1) continue;
            break;
        }
    }

    private void replaceTokenFollowers(String aString, BufferedWriter output, PlayerCharacter aPC) {
        block18: {
            int i;
            List followers;
            block20: {
                block19: {
                    followers = aPC.getFollowerList();
                    if (followers.isEmpty()) break block18;
                    if (!"FOLLOWERLIST".equals(aString)) break block19;
                    boolean lastflag = false;
                    for (int i2 = 0; i2 < followers.size(); ++i2) {
                        if (!(followers.get(i2) instanceof Follower)) continue;
                        Follower aF = (Follower)followers.get(i2);
                        Iterator p = Globals.getPCList().iterator();
                        while (p.hasNext()) {
                            PlayerCharacter nPC = (PlayerCharacter)p.next();
                            if (!aF.getFileName().equals(nPC.getFileName())) continue;
                            if (lastflag) {
                                FileAccess.write(output, ", ");
                            }
                            FileAccess.encodeWrite(output, nPC.getName());
                            lastflag = true;
                        }
                    }
                    break block18;
                }
                if (!aString.startsWith("FOLLOWERTYPE.")) break block20;
                StringTokenizer aTok = new StringTokenizer(aString, ".");
                aTok.nextToken();
                String typeString = aTok.nextToken();
                String restString = "";
                int followerIndex = -1;
                if (aTok.hasMoreTokens()) {
                    block17: {
                        restString = aTok.nextToken();
                        try {
                            followerIndex = Integer.parseInt(restString);
                            restString = "";
                        }
                        catch (NumberFormatException exc) {
                            Logging.errorPrint("Old syntax FOLLOWERTYPEx will be replaced for FOLLOWERTYPE.x");
                            int numCharToRemove = 0;
                            for (int i3 = typeString.length() - 1; i3 > 0; --i3) {
                                if (typeString.charAt(i3) >= '0' && typeString.charAt(i3) <= '9') {
                                    followerIndex = Integer.parseInt(typeString.substring(i3));
                                    ++numCharToRemove;
                                    continue;
                                }
                                i3 = 0;
                            }
                            if (numCharToRemove <= 0) break block17;
                            typeString = typeString.substring(0, typeString.length() - numCharToRemove);
                        }
                    }
                    while (aTok.hasMoreTokens()) {
                        restString = restString + "." + aTok.nextToken();
                    }
                    if (restString.indexOf(".") == 0) {
                        restString = restString.substring(1);
                    }
                }
                ArrayList<Follower> aList = new ArrayList<Follower>();
                for (int i4 = followers.size() - 1; i4 >= 0; --i4) {
                    Follower fol = (Follower)followers.get(i4);
                    if (!fol.getType().equalsIgnoreCase(typeString)) continue;
                    aList.add(fol);
                }
                if (followerIndex >= aList.size() || !(aList.get(followerIndex) instanceof Follower)) break block18;
                Follower aF = (Follower)aList.get(followerIndex);
                Iterator p = Globals.getPCList().iterator();
                while (p.hasNext()) {
                    PlayerCharacter nPC = (PlayerCharacter)p.next();
                    if (!aF.getFileName().equals(nPC.getFileName())) continue;
                    PlayerCharacter newPC = nPC;
                    if (restString.equals("")) {
                        restString = "NAME";
                    }
                    nPC = aPC;
                    aPC = newPC;
                    Globals.setCurrentPC(aPC);
                    this.replaceToken(restString, output, aPC);
                    aPC = nPC;
                    Globals.setCurrentPC(aPC);
                }
                break block18;
            }
            StringTokenizer aTok = new StringTokenizer(aString, ".");
            String fString = aTok.nextToken();
            if ("FOLLOWER".equals(fString)) {
                i = Integer.parseInt(aTok.nextToken());
            } else {
                Logging.errorPrint("Old syntax FOLLOWERx will be replaced for FOLLOWER.x");
                i = Integer.parseInt(aString.substring(8, aString.indexOf(46)));
            }
            if (i < followers.size() && followers.get(i) instanceof Follower) {
                Follower aF = (Follower)followers.get(i);
                Iterator p = Globals.getPCList().iterator();
                while (p.hasNext()) {
                    PlayerCharacter nPC = (PlayerCharacter)p.next();
                    if (!aF.getFileName().equals(nPC.getFileName())) continue;
                    PlayerCharacter newPC = nPC;
                    String aLabel = aTok.hasMoreTokens() ? aTok.nextToken() : "NAME";
                    nPC = aPC;
                    aPC = newPC;
                    Globals.setCurrentPC(aPC);
                    this.replaceToken(aLabel, output, aPC);
                    aPC = nPC;
                    Globals.setCurrentPC(aPC);
                }
            }
        }
    }

    private void replaceTokenForDfor(String aString, BufferedWriter output, PlayerCharacter aPC) {
        int x = 0;
        int i = 0;
        StringTokenizer aTok = aString.startsWith("DFOR.") ? new StringTokenizer(aString.substring(5), ",", false) : new StringTokenizer(aString.substring(4), ",", false);
        int cMin = 0;
        int cMax = 100;
        int cStep = 1;
        int cStepLine = 1;
        int cStepLineMax = 0;
        String cString = "";
        String cStartLineString = "";
        String cEndLineString = "";
        boolean isDFor = false;
        block9: while (aTok.hasMoreTokens()) {
            String bString = aTok.nextToken();
            switch (i++) {
                case 0: {
                    cMin = this.getVarValue(bString, aPC);
                    continue block9;
                }
                case 1: {
                    cMax = this.getVarValue(bString, aPC);
                    continue block9;
                }
                case 2: {
                    cStep = this.getVarValue(bString, aPC);
                    if (!aString.startsWith("DFOR.")) continue block9;
                    isDFor = true;
                    bString = aTok.nextToken();
                    cStepLineMax = this.getVarValue(bString, aPC);
                    bString = aTok.nextToken();
                    cStepLine = this.getVarValue(bString, aPC);
                    continue block9;
                }
                case 3: {
                    cString = bString;
                    continue block9;
                }
                case 4: {
                    cStartLineString = bString;
                    continue block9;
                }
                case 5: {
                    cEndLineString = bString;
                    continue block9;
                }
                case 6: {
                    boolean bl = existsOnly = !"0".equals(bString);
                    if (!"2".equals(bString)) continue block9;
                    this.checkBefore = true;
                    continue block9;
                }
            }
            Logging.errorPrint("ExportHandler.replaceTokenForDfor can't handle token number " + i);
        }
        if ("COMMA".equals(cStartLineString)) {
            cStartLineString = ",";
        }
        if ("COMMA".equals(cEndLineString)) {
            cEndLineString = ",";
        }
        if ("NONE".equals(cStartLineString)) {
            cStartLineString = "";
        }
        if ("NONE".equals(cEndLineString)) {
            cEndLineString = "";
        }
        if ("CRLF".equals(cStartLineString)) {
            cStartLineString = Constants.s_LINE_SEP;
        }
        if ("CRLF".equals(cEndLineString)) {
            cEndLineString = Constants.s_LINE_SEP;
        }
        for (int iStart = cMin; iStart < cMax; iStart += cStep) {
            if (x++ == 0) {
                FileAccess.write(output, cStartLineString);
            }
            int iNow = iStart;
            if (!isDFor) {
                cStepLineMax = iNow + cStep;
            }
            if (cStepLineMax > cMax && !isDFor) {
                cStepLineMax = cMax;
            }
            while (iNow < cStepLineMax || isDFor && iNow < cMax) {
                boolean insideToken = false;
                if (cString.startsWith(this.csheetTag2)) {
                    insideToken = true;
                }
                aTok = new StringTokenizer(cString, this.csheetTag2, false);
                int j = 0;
                while (aTok.hasMoreTokens()) {
                    String eString = aTok.nextToken();
                    String gString = "";
                    String hString = eString;
                    int index = 0;
                    while (hString.indexOf(37, index) > 0 && (index = hString.indexOf(37, index)) != -1) {
                        if (index < hString.length() - 1 && hString.charAt(index + 1) != '.') {
                            ++index;
                            continue;
                        }
                        String fString = hString.substring(0, index);
                        if (index + 1 < eString.length()) {
                            gString = hString.substring(index + 1);
                        }
                        hString = fString + Integer.toString(iNow) + gString;
                    }
                    if ("%0".equals(eString) || "%1".equals(eString)) {
                        int cInt = iNow + Integer.parseInt(eString.substring(1));
                        FileAccess.write(output, Integer.toString(cInt));
                    } else if (insideToken) {
                        this.replaceToken(hString, output, aPC);
                    } else {
                        boolean oldSkipMath = skipMath;
                        skipMath = true;
                        this.replaceToken(hString, output, aPC);
                        skipMath = oldSkipMath;
                    }
                    if (this.checkBefore && noMoreItems) {
                        iNow = cMax;
                        iStart = cMax;
                        if (j != 0) break;
                        existsOnly = false;
                        break;
                    }
                    ++j;
                    insideToken = !insideToken;
                }
                iNow += cStepLine;
                if (cStepLine != 0) continue;
                break;
            }
            if (cStepLine <= 0 && (cStepLine != 0 || x != cStep) && existsOnly != noMoreItems) continue;
            FileAccess.write(output, cEndLineString);
            x = 0;
            if (!existsOnly || !noMoreItems) continue;
            return;
        }
    }

    private void replaceTokenIIF(String aString, BufferedWriter output, PlayerCharacter aPC) {
        int iStart;
        int iParenCount = 0;
        String[] aT = new String[3];
        int iParamCount = 0;
        block5: for (int i = iStart = 4; i < aString.length() && iParamCount != 3; ++i) {
            switch (aString.charAt(i)) {
                case '(': {
                    ++iParenCount;
                    continue block5;
                }
                case ')': {
                    if (--iParenCount != -1) continue block5;
                    if (iParamCount == 2) {
                        aT[iParamCount++] = aString.substring(iStart, i).trim();
                        iStart = i + 1;
                        continue block5;
                    }
                    Logging.errorPrint("IIF: not enough parameters");
                    continue block5;
                }
                case ',': {
                    if (iParenCount != 0) continue block5;
                    if (iParamCount < 2) {
                        aT[iParamCount] = aString.substring(iStart, i).trim();
                        iStart = i + 1;
                    } else {
                        Logging.errorPrint("IIF: too many parameters");
                    }
                    ++iParamCount;
                    continue block5;
                }
            }
        }
        if (iParamCount != 3) {
            Logging.errorPrint("IIF: invalid parameter count: " + iParamCount);
        } else {
            aString = aString.substring(iStart);
            iStart = 2;
            if (this.evaluateExpression(aT[0], aPC)) {
                iStart = 1;
            }
            FileAccess.write(output, aT[iStart]);
        }
        if (aString.length() > 0) {
            Logging.errorPrint("IIF: extra characters on line: " + aString);
            FileAccess.write(output, aString);
        }
    }

    private int replaceTokenSpellListBook(String aString, PlayerCharacter aPC) {
        int sbookNum = 0;
        StringTokenizer aTok = new StringTokenizer(aString, ".");
        int classNum = Integer.parseInt(aTok.nextToken());
        int levelNum = Integer.parseInt(aTok.nextToken());
        if (aTok.hasMoreTokens()) {
            sbookNum = Integer.parseInt(aTok.nextToken());
        }
        String bookName = Globals.getDefaultSpellBook();
        if (sbookNum > 0) {
            bookName = (String)aPC.getSpellBooks().get(sbookNum);
        }
        this.canWrite = false;
        PObject aObject = aPC.getSpellClassAtIndex(classNum);
        if (aObject != null) {
            List aList = aObject.getCharacterSpell(null, bookName, levelNum);
            this.canWrite = !aList.isEmpty();
        }
        return 0;
    }

    private void replaceTokenVar(String aString, PlayerCharacter aPC) {
        StringTokenizer aTok = new StringTokenizer(aString.substring(5), ".", false);
        String varName = aTok.nextToken();
        String bString = "EQ";
        if (aTok.hasMoreTokens()) {
            bString = aTok.nextToken();
        }
        String value = "0";
        if (aTok.hasMoreTokens()) {
            value = aTok.nextToken();
        }
        Float varval = aPC.getVariable(varName, true, true, "", "");
        Float valval = aPC.getVariableValue(value, "");
        this.canWrite = "GTEQ".equals(bString) ? varval.doubleValue() >= valval.doubleValue() : ("GT".equals(bString) ? varval.doubleValue() > valval.doubleValue() : ("LTEQ".equals(bString) ? varval.doubleValue() <= valval.doubleValue() : ("LT".equals(bString) ? varval.doubleValue() < valval.doubleValue() : ("NEQ".equals(bString) ? !CoreUtility.doublesEqual(varval.doubleValue(), valval.doubleValue()) : !CoreUtility.doublesEqual(varval.doubleValue(), valval.doubleValue())))));
    }

    private static int returnMergeType(String aType) {
        int merge = 0;
        if ("MERGENONE".equals(aType)) {
            merge = 1;
        } else if ("MERGELOC".equals(aType)) {
            merge = 2;
        } else if ("MERGEALL".equals(aType)) {
            merge = 0;
        }
        return merge;
    }

    private void replaceTokenSkillListMods(BufferedWriter output, PlayerCharacter aPC) {
        int i = 0;
        Iterator e = aPC.getSkillListInOutputOrder().iterator();
        while (e.hasNext()) {
            Skill aSkill = (Skill)e.next();
            int modSkill = -1;
            if (aSkill.getKeyStat().compareToIgnoreCase("None") != 0) {
                modSkill = aSkill.modifier(aPC) - aPC.getStatList().getStatModFor(aSkill.getKeyStat());
            }
            if (aSkill.getTotalRank(aPC).intValue() <= 0 && modSkill <= 0) continue;
            int temp = aSkill.modifier(aPC) + aSkill.getTotalRank(aPC).intValue();
            if (i > 0) {
                FileAccess.write(output, ", ");
            }
            FileAccess.encodeWrite(output, aSkill.getOutputName() + " +" + Integer.toString(temp));
            ++i;
        }
    }

    private int replaceTokenSpecialAbility(String aString, BufferedWriter output, PlayerCharacter aPC) {
        int specialability = -1;
        String sDelim = "\r\n";
        StringTokenizer aTok = new StringTokenizer(aString, ".");
        String fString = aTok.nextToken();
        String subToken = "";
        if ("SPECIALABILITY".equals(fString)) {
            while (aTok.hasMoreTokens()) {
                if (specialability == -1) {
                    specialability = Integer.parseInt(aTok.nextToken());
                    continue;
                }
                if ("".equals(subToken)) {
                    subToken = aTok.nextToken();
                    continue;
                }
                sDelim = aTok.nextToken();
            }
        } else {
            Logging.errorPrint("Old syntax SPECIALABILITYx will be replaced for SPECIALABILITY.x");
            if (aString.indexOf(".DESCRIPTION.") >= 0) {
                sDelim = aString.substring(aString.indexOf(".DESCRIPTION.") + 13);
            }
            if (aString.indexOf(".DESCRIPTION") >= 0) {
                subToken = "DESCRIPTION";
                specialability = Integer.parseInt(aString.substring(14, aString.indexOf(".DESCRIPTION")));
            } else {
                specialability = Integer.parseInt(aString.substring(14, aString.length()));
            }
        }
        if (specialability < aPC.getSpecialAbilityTimesList().size() || existsOnly) {
            // empty if block
        }
        int len = aPC.getSpecialAbilityTimesList().size();
        if (specialability >= 0 && specialability < len) {
            if ("DESCRIPTION".equals(subToken)) {
                ExportHandler.replaceWithDelimiter(output, ExportHandler.getItemDescription("SA", aPC.getSpecialAbilityTimesList().get(specialability).toString(), "", aPC), sDelim);
            } else {
                FileAccess.encodeWrite(output, aPC.getSpecialAbilityTimesList().get(specialability).toString());
            }
        }
        return len;
    }

    private int replaceTokenSpecialList(String aString, BufferedWriter output, PlayerCharacter aPC) {
        String delim = aString.substring(11);
        if ("".equals(delim)) {
            delim = ", ";
        }
        int i = 0;
        int len = aPC.getSpecialAbilityTimesList().size();
        Iterator e = aPC.getSpecialAbilityTimesList().iterator();
        while (e.hasNext()) {
            if (i++ > 0) {
                FileAccess.write(output, delim);
            }
            FileAccess.write(output, (String)e.next());
        }
        return len;
    }

    private static void replaceWithDelimiter(BufferedWriter output, String sString, String sDelim) {
        StringTokenizer bTok = new StringTokenizer(sString, "\r\n", false);
        while (bTok.hasMoreTokens()) {
            FileAccess.encodeWrite(output, bTok.nextToken());
            if (!bTok.hasMoreTokens()) continue;
            FileAccess.write(output, sDelim);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void write(PlayerCharacter[] PCs, BufferedWriter out) {
        block49: {
            FileAccess.setCurrentOutputFilter(this.templateFile.getName());
            holdPC = Globals.getCurrentPC();
            br = null;
            try {
                try {
                    br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.templateFile), "UTF-8"));
                    inPipe = false;
                    tokString = new StringBuffer();
                    while ((aLine = br.readLine()) != null) {
                        if (!inPipe && aLine.lastIndexOf(124) < 0) {
                            FileAccess.write(out, aLine);
                            FileAccess.newLine(out);
                        } else if (inPipe && aLine.lastIndexOf(124) < 0 || !inPipe && aLine.lastIndexOf(124) == 0) {
                            tokString.append(aLine.substring(aLine.lastIndexOf(124) + 1));
                            inPipe = true;
                        } else {
                            if (!inPipe && aLine.charAt(0) == '|') {
                                inPipe = true;
                            }
                            v0 = flag = (bTok = new StringTokenizer(aLine, "|", false)).countTokens() == 1;
                            while (bTok.hasMoreTokens()) {
                                bString = bTok.nextToken();
                                if (!inPipe) {
                                    FileAccess.write(out, bString);
                                } else if (bTok.hasMoreTokens() || flag) {
                                    aString = tokString.toString() + bString;
                                    if (aString.startsWith("FOR.")) {
                                        x = 0;
                                        j = 0;
                                        pTok = new PStringTokenizer(aString.substring(4), ",", "\\\\", "\\\\");
                                        cMin = new Integer(0);
                                        cMax = new Integer(100);
                                        cStep = new Integer(1);
                                        cString = "";
                                        cStartLineString = "";
                                        cEndLineString = "";
                                        bString = null;
                                        _existsOnly = false;
                                        _noMoreItems = false;
                                        block19: while (pTok.hasMoreTokens()) {
                                            bString = pTok.nextToken();
                                            switch (j++) {
                                                case 0: {
                                                    cMin = Delta.decode(bString);
                                                    continue block19;
                                                }
                                                case 1: {
                                                    cMax = Delta.decode(bString);
                                                    continue block19;
                                                }
                                                case 2: {
                                                    cStep = Delta.decode(bString);
                                                    continue block19;
                                                }
                                                case 3: {
                                                    cString = bString;
                                                    continue block19;
                                                }
                                                case 4: {
                                                    cStartLineString = bString;
                                                    continue block19;
                                                }
                                                case 5: {
                                                    cEndLineString = bString;
                                                    continue block19;
                                                }
                                                case 6: {
                                                    _existsOnly = "0".equals(bString) == false;
                                                    continue block19;
                                                }
                                            }
                                            Logging.errorPrint("In Party.print there is an unhandled case in a switch (the value is " + j + ".");
                                        }
                                        if (cMax >= PCs.length && _existsOnly) {
                                            cMax = new Integer(PCs.length);
                                        }
                                        for (k = cMin.intValue(); k < cMax; ++k) {
                                            if (x++ == 0) {
                                                FileAccess.write(out, cStartLineString);
                                            }
                                            dString = cString;
                                            while (dString.length() > 0) {
                                                eString = "";
                                                for (l = 0; l < dString.length() - 1; ++l) {
                                                    if (dString.charAt(l) != '\\' || dString.charAt(l + 1) != '\\') continue;
                                                    eString = dString.substring(0, l);
                                                    dString = dString.substring(l + 2);
                                                    break;
                                                }
                                                if ("".equals(eString)) {
                                                    eString = dString;
                                                    dString = "";
                                                }
                                                if (eString.startsWith("%.")) {
                                                    charNum = k;
                                                    if (charNum >= 0 && charNum < PCs.length) {
                                                        currPC = PCs[charNum];
                                                        Globals.setCurrentPC(currPC);
                                                        if (currPC != null) {
                                                            this.replaceToken(eString.substring(2), out, currPC);
                                                            continue;
                                                        }
                                                        _noMoreItems = true;
                                                        continue;
                                                    }
                                                    _noMoreItems = true;
                                                    continue;
                                                }
                                                FileAccess.write(out, eString);
                                            }
                                            if (x != cStep && _existsOnly != _noMoreItems) continue;
                                            FileAccess.write(out, cEndLineString);
                                            FileAccess.newLine(out);
                                            x = 0;
                                            if (_existsOnly != _noMoreItems) {
                                                continue;
                                            }
                                            break;
                                        }
                                    } else {
                                        charNum = -1;
                                        for (i = 0; i < aString.length() && aString.charAt(i) >= '0' && aString.charAt(i) <= '9'; ++i) {
                                        }
                                        if (i > 0) {
                                            charNum = Delta.parseInt(aString.substring(0, i));
                                        }
                                        if (charNum >= 0 && charNum < Globals.getPCList().size()) {
                                            currPC = PCs[charNum];
                                            Globals.setCurrentPC(currPC);
                                            this.replaceToken(aString, out, currPC);
                                        } else if (aString.startsWith("EXPORT")) {
                                            this.replaceToken(aString, out, null);
                                        }
                                    }
                                    tokString = new StringBuffer("");
                                } else {
                                    tokString.append(bString);
                                }
                                if (!bTok.hasMoreTokens() && !flag) continue;
                                inPipe = inPipe == false;
                            }
                            if (inPipe && aLine.charAt(aLine.length() - 1) == '|') {
                                inPipe = false;
                            }
                        }
                        if (inPipe) continue;
                        FileAccess.newLine(out);
                    }
                    var30_32 = null;
                    if (br == null) break block49;
                }
                catch (IOException exc) {
                    var30_33 = null;
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException ignore) {}
                    }
                    break block49;
                }
            }
            catch (Throwable var29_38) {
                var30_34 = null;
                if (br == null) throw var29_38;
                ** try [egrp 2[TRYBLOCK] [4 : 1064->1072)] { 
lbl151:
                // 1 sources

                br.close();
                throw var29_38;
lbl153:
                // 1 sources

                catch (IOException ignore) {
                    // empty catch block
                }
                throw var29_38;
            }
            try {}
            catch (IOException ignore) {}
            br.close();
        }
        Globals.setCurrentPC(holdPC);
    }

    private static void writeToken(int value, BufferedWriter output) {
        FileAccess.write(output, Delta.toString(value));
    }

    private int getWeaponProfTypeBonuses(Equipment eq, String bonusType, int index, PlayerCharacter aPC) {
        int bonus = 0;
        boolean hasBoth = eq.isRanged() && eq.isMelee();
        String profName = eq.profName(aPC);
        WeaponProf wp = Globals.getWeaponProfNamed(profName);
        if (wp == null) {
            return 0;
        }
        StringTokenizer aTok = new StringTokenizer(wp.getType(), ".");
        block6: while (aTok.hasMoreTokens()) {
            String tString = aTok.nextToken();
            if (hasBoth && "RANGED".equalsIgnoreCase(tString)) continue;
            switch (index) {
                case 0: {
                    bonus += (int)aPC.getTotalBonusTo("WEAPONPROF=TYPE." + tString, bonusType);
                    continue block6;
                }
                case 1: {
                    bonus += (int)eq.bonusTo("WEAPONPROF=TYPE." + tString, bonusType, aPC, aPC);
                    continue block6;
                }
                case 2: {
                    bonus += (int)aPC.getFeatBonusTo("WEAPONPROF=TYPE." + tString, bonusType, true);
                    continue block6;
                }
                case 3: {
                    bonus += (int)aPC.getTemplateBonusTo("WEAPONPROF=TYPE." + tString, bonusType, true);
                    continue block6;
                }
            }
            Logging.errorPrint("In getWeaponProfTypeBonuses there is an unhandled case in a switch (the value is " + index + ".");
        }
        return bonus;
    }

    public final boolean getCanWrite() {
        return this.canWrite;
    }

    public final void setCanWrite(boolean canWrite) {
        this.canWrite = canWrite;
    }

    public final boolean getCheckBefore() {
        return this.checkBefore;
    }

    public final boolean getInLabel() {
        return this.inLabel;
    }

    public static final boolean getExistsOnly() {
        return existsOnly;
    }

    public static final void setExistsOnly(boolean existsOnly) {
        ExportHandler.existsOnly = existsOnly;
    }

    public static final boolean getNoMoreItems() {
        return noMoreItems;
    }

    public static final void setNoMoreItems(boolean noMoreItems) {
        ExportHandler.noMoreItems = noMoreItems;
    }

    private static final class PStringTokenizer {
        private String _andThat = "";
        private String _delimiter = "";
        private String _forThisString = "";
        private String _ignoreBetweenThis = "";

        PStringTokenizer(String forThisString, String delimiter, String ignoreBetweenThis, String andThat) {
            this._forThisString = forThisString;
            this._delimiter = delimiter;
            this._ignoreBetweenThis = ignoreBetweenThis;
            this._andThat = andThat;
        }

        public boolean hasMoreTokens() {
            return this._forThisString.length() > 0;
        }

        public String nextToken() {
            String aString;
            boolean ignores = false;
            if (this._forThisString.lastIndexOf(this._delimiter) == -1) {
                aString = this._forThisString;
                this._forThisString = "";
            } else {
                int i;
                StringBuffer b = new StringBuffer();
                for (i = 0; i < this._forThisString.length() && (!this._forThisString.substring(i).startsWith(this._delimiter) || ignores); ++i) {
                    if (this._forThisString.substring(i).startsWith(this._ignoreBetweenThis) && !ignores) {
                        ignores = true;
                    } else if (this._forThisString.substring(i).startsWith(this._andThat)) {
                        ignores = false;
                    }
                    b.append(this._forThisString.substring(i, i + 1));
                }
                aString = b.toString();
                this._forThisString = this._forThisString.substring(i + 1);
            }
            return aString;
        }
    }
}

