/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pcgen.core.Globals;
import pcgen.core.utils.CoreUtility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.util.Delta;
import pcgen.util.Logging;

public final class FileAccess {
    private static String outputFilterName = "";
    private static Map outputFilter = null;
    private static int maxLength = -1;

    public static void setCurrentOutputFilter(String filterName) {
        int idx = filterName.lastIndexOf(46);
        if (idx >= 0) {
            filterName = filterName.substring(idx + 1);
        }
        if ((filterName = filterName.toLowerCase()).equals(outputFilterName)) {
            return;
        }
        outputFilter = null;
        filterName = Globals.getDefaultPath() + File.separator + "system" + File.separator + "outputFilters" + File.separator + filterName + ".lst";
        File filterFile = new File(filterName);
        try {
            BufferedReader br;
            if (filterFile.canRead() && filterFile.isFile() && (br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filterFile), "UTF-8"))) != null) {
                String aLine;
                outputFilterName = filterName;
                outputFilter = new HashMap();
                while ((aLine = br.readLine()) != null) {
                    List filterEntry = CoreUtility.split(aLine, '\t');
                    if (filterEntry.size() < 2) continue;
                    try {
                        Integer key = Delta.decode((String)filterEntry.get(0));
                        outputFilter.put(key, filterEntry.get(1).toString());
                    }
                    catch (NullPointerException e) {
                        Logging.errorPrint("Exception in setCurrentOutputFilter", e);
                    }
                    catch (NumberFormatException e) {
                        Logging.errorPrint("Exception in setCurrentOutputFilter", e);
                    }
                }
                br.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void encodeWrite(Writer output, String aString) {
        if (outputFilter != null && outputFilter.size() != 0) {
            StringBuffer xlatedString = new StringBuffer(aString.length());
            for (int i = 0; i < aString.length(); ++i) {
                char c = aString.charAt(i);
                String xlation = (String)outputFilter.get(new Integer(c));
                if (xlation != null) {
                    xlatedString.append(xlation);
                    continue;
                }
                xlatedString.append(c);
            }
            aString = xlatedString.toString();
        }
        FileAccess.write(output, aString);
    }

    public static void maxLength(int anInt) {
        maxLength = anInt;
    }

    public static void newLine(BufferedWriter output) {
        try {
            output.newLine();
        }
        catch (IOException exception) {
            ShowMessageDelegate.showMessageDialog(exception.getMessage(), "PCGen", MessageType.ERROR);
        }
    }

    public static void write(Writer output, String aString) {
        if (maxLength > 0 && aString.length() > maxLength) {
            aString = aString.substring(0, maxLength);
        }
        try {
            output.write(aString);
        }
        catch (IOException exception) {
            ShowMessageDelegate.showMessageDialog(exception.getMessage(), "PCGen", MessageType.ERROR);
        }
    }
}

