/*
 * Decompiled with CFR 0.152.
 */
package pcgen.io;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import pcgen.core.Constants;
import pcgen.core.Feat;
import pcgen.core.Globals;
import pcgen.core.PCClass;
import pcgen.core.PCTemplate;
import pcgen.core.PlayerCharacter;
import pcgen.core.Race;
import pcgen.core.RollingMethods;
import pcgen.core.SpecialAbility;
import pcgen.core.utils.MessageType;
import pcgen.core.utils.ShowMessageDelegate;
import pcgen.io.IOHandler;
import pcgen.io.PCGParseException;
import pcgen.io.PCGParser;
import pcgen.io.PCGVer0Parser;
import pcgen.io.PCGVer2Creator;
import pcgen.io.PCGVer2Parser;
import pcgen.util.InputFactory;
import pcgen.util.InputInterface;
import pcgen.util.Logging;

public final class PCGIOHandler
extends IOHandler {
    private final List errors = new ArrayList();
    private final List warnings = new ArrayList();
    private PlayerCharacter aPC;

    public List getErrors() {
        return this.errors;
    }

    public List getMessages() {
        ArrayList<String> messages = new ArrayList<String>();
        Iterator it = this.errors.iterator();
        while (it.hasNext()) {
            messages.add("Error: " + it.next());
        }
        it = this.warnings.iterator();
        while (it.hasNext()) {
            messages.add("Warning: " + it.next());
        }
        return messages;
    }

    public List getWarnings() {
        return this.warnings;
    }

    public static void buildSALIST(String aChoice, List aAvailable, List aBonus) {
        String aString;
        String aPost = "";
        int iOffs = aChoice.indexOf(124, 7);
        if (iOffs < 0) {
            aString = aChoice;
        } else {
            aString = aChoice.substring(7, iOffs);
            aPost = aChoice.substring(iOffs + 1);
        }
        ArrayList<String> saNames = new ArrayList<String>();
        StringTokenizer aTok = new StringTokenizer(aString, ",");
        while (aTok.hasMoreTokens()) {
            saNames.add(aTok.nextToken());
        }
        PlayerCharacter currPC = Globals.getCurrentPC();
        List aSAList = currPC.getSpecialAbilityList();
        ArrayList aTemplateList = currPC.getTemplateList();
        Iterator e1 = aTemplateList.iterator();
        while (e1.hasNext()) {
            PCTemplate aTempl = (PCTemplate)e1.next();
            List SAs = aTempl.getSpecialAbilityList(currPC.getTotalLevels(), currPC.totalHitDice());
            if (SAs == null || SAs.isEmpty()) continue;
            Iterator e2 = SAs.iterator();
            while (e2.hasNext()) {
                String aSA = (String)e2.next();
                if (aSAList.contains(aSA)) continue;
                aSAList.add(aSA);
            }
        }
        Iterator e2 = saNames.iterator();
        while (e2.hasNext()) {
            aString = (String)e2.next();
            Iterator e12 = aSAList.iterator();
            while (e12.hasNext()) {
                String aSA = ((SpecialAbility)e12.next()).getName();
                if (!aSA.startsWith(aString)) continue;
                String aVar = "";
                iOffs = aSA.indexOf(124);
                if (iOffs >= 0) {
                    aVar = aSA.substring(iOffs + 1);
                    iOffs = aSA.indexOf(37);
                    if (iOffs >= 0) {
                        aSA = aSA.substring(0, iOffs).trim();
                    }
                }
                if (aAvailable.contains(aSA)) continue;
                aAvailable.add(aSA);
                iOffs = aPost.indexOf(37);
                if (iOffs >= 0) {
                    aVar = aPost.substring(0, iOffs) + aVar + aPost.substring(iOffs + 1);
                }
                aBonus.add(aSA + "|" + aVar);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void read(PlayerCharacter pcToBeRead, InputStream in) {
        this.aPC = pcToBeRead;
        this.warnings.clear();
        ArrayList<String> lines = new ArrayList<String>();
        boolean isPCGVersion2 = false;
        BufferedReader br = null;
        try {
            String aLine;
            br = new BufferedReader(new InputStreamReader(in, "UTF-8"));
            while ((aLine = br.readLine()) != null) {
                lines.add(aLine);
                isPCGVersion2 |= aLine.startsWith("PCGVERSION");
            }
        }
        catch (IOException ioe) {
            Logging.errorPrint("Exception in PCGIOHandler::read", ioe);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException e) {
                Logging.errorPrint("Couldn't close file in PCGIOHandler.read", e);
            }
        }
        pcToBeRead.setImporting(true);
        String[] pcgLines = new String[lines.size()];
        for (int i = 0; i < lines.size(); ++i) {
            pcgLines[i] = (String)lines.get(i);
        }
        PCGParser parser = isPCGVersion2 ? new PCGVer2Parser(pcToBeRead) : new PCGVer0Parser(pcToBeRead);
        try {
            parser.parsePCG(pcgLines);
        }
        catch (PCGParseException pcgex) {
            this.errors.add(pcgex.getMessage() + Constants.s_LINE_SEP + "Method: " + pcgex.getMethod() + '\n' + "Line: " + pcgex.getLine());
        }
        this.warnings.addAll(parser.getWarnings());
        pcToBeRead.setImporting(false);
        try {
            this.sanityChecks();
        }
        catch (NumberFormatException ex) {
            this.errors.add(ex.getMessage() + Constants.s_LINE_SEP + "Method: sanityChecks");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(PlayerCharacter pcToBeWritten, OutputStream out) {
        this.aPC = pcToBeWritten;
        String pcgString = new PCGVer2Creator(pcToBeWritten).createPCGString();
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(new OutputStreamWriter(out, "UTF-8"));
            bw.write(pcgString);
            bw.flush();
            pcToBeWritten.setDirty(false);
        }
        catch (IOException ioe) {
            Logging.errorPrint("Exception in PCGIOHandler::write", ioe);
        }
        finally {
            try {
                bw.close();
            }
            catch (IOException e) {
                Logging.errorPrint("Couldn't close file in PCGIOHandler.write", e);
            }
        }
    }

    private void sanityChecks() {
        PCClass aClass;
        Iterator it;
        int i;
        int iRoll;
        int iSides;
        boolean bFixMade = false;
        this.aPC.setCalcEquipmentList();
        this.aPC.setCalcFollowerBonus(Globals.getCurrentPC());
        this.aPC.calcActiveBonuses();
        int oldHp = this.aPC.hitPoints();
        Race aRace = this.aPC.getRace();
        if (aRace.hitDice(this.aPC) != 0) {
            int i2;
            iSides = aRace.getHitDiceSize(this.aPC);
            if (aRace.getHitPointMapSize() < 1) {
                for (i2 = 0; i2 <= aRace.hitDice(this.aPC); ++i2) {
                    int roll = RollingMethods.roll(iSides);
                    aRace.setHitPoint(i2, new Integer(roll));
                }
                this.warnings.add("Character was saved with \"Use Default Monsters\" off. Random hit points added for race hit dice.");
                bFixMade = true;
            }
            for (i2 = 0; i2 <= aRace.hitDice(this.aPC); ++i2) {
                iRoll = aRace.getHitPoint(i2);
                if (iRoll <= iSides) continue;
                aRace.setHitPoint(i2, new Integer(iSides));
                bFixMade = true;
            }
        }
        Iterator it2 = this.aPC.getFeatList().iterator();
        while (it2.hasNext()) {
            Feat aFeat = (Feat)it2.next();
            if (aFeat.getChoiceString().startsWith("SALIST|")) {
                ArrayList aAvailable = new ArrayList();
                ArrayList aBonus = new ArrayList();
                PCGIOHandler.buildSALIST(aFeat.getChoiceString(), aAvailable, aBonus);
                block3: for (i = 0; i < aFeat.getAssociatedCount(); ++i) {
                    String aString = aFeat.getAssociated(i);
                    String prefix = aString + "|";
                    boolean bLoop = true;
                    while (true) {
                        int x;
                        for (x = 0; x < aBonus.size(); ++x) {
                            String bString = (String)aBonus.get(x);
                            if (!bString.startsWith(prefix)) continue;
                            String tmp = bString.substring(bString.indexOf(124) + 1);
                            aFeat.addBonusList(tmp, aFeat);
                            break;
                        }
                        if (x < aBonus.size() || !bLoop) continue block3;
                        bLoop = false;
                        if (aBonus.size() == 1) {
                            aString = (String)aBonus.get(0);
                            aString = aString.substring(0, aString.indexOf(124));
                        } else {
                            while (true) {
                                String message = aFeat.getName() + " has been modified and PCGen is unable to " + "determine your previous selection(s)." + Constants.s_LINE_SEP + Constants.s_LINE_SEP + "This box will pop up once for each time you " + "have taken the feat.";
                                InputInterface ii = InputFactory.getInputInstance();
                                Object selectedValue = ii.showInputDialog(null, message, "PCGen", MessageType.INFORMATION, aAvailable.toArray(), aAvailable.get(0));
                                if (selectedValue != null) {
                                    aString = (String)selectedValue;
                                    break;
                                }
                                ShowMessageDelegate.showMessageDialog("You MUST make a selection", "PCGen", MessageType.INFORMATION);
                            }
                        }
                        aFeat.setAssociated(i, aString);
                    }
                }
            } else if (aFeat.getChoiceString().startsWith("NONCLASSSKILLLIST|")) {
                for (int it3 = 0; it3 < aFeat.getAssociatedCount(); ++it3) {
                    String skillString = aFeat.getAssociated(it3);
                    aFeat.setCSkillList(skillString);
                }
            }
            if (!aFeat.isMultiples() || aFeat.getAssociatedCount() != 0) continue;
            aFeat.addAssociated("PLEASE MAKE APPROPRIATE SELECTION");
            this.warnings.add("Multiple selection feat found with no selections (" + aFeat.getName() + "). Correct on Feat tab.");
        }
        if (this.aPC.getClassList() != null) {
            it = this.aPC.getClassList().iterator();
            while (it.hasNext()) {
                aClass = (PCClass)it.next();
                if (aClass.getLevel() < 1) continue;
                for (i = 0; i <= aClass.getLevel(); ++i) {
                    int baseSides = aClass.getLevelHitDie(Globals.getCurrentPC(), i + 1);
                    iRoll = aClass.getHitPoint(i);
                    if (iRoll <= (iSides = baseSides + (int)aClass.getBonusTo("HD", "MAX", i + 1, this.aPC))) continue;
                    aClass.setHitPoint(i, new Integer(iSides));
                    bFixMade = true;
                }
            }
        }
        if (bFixMade) {
            String message = "Fixed illegal value in hit points. Current character hit points: " + this.aPC.hitPoints() + " not " + oldHp;
            this.warnings.add(message);
        }
        it = this.aPC.getClassList().iterator();
        while (it.hasNext()) {
            aClass = (PCClass)it.next();
            aClass.setLevel(aClass.getLevel(), Globals.getCurrentPC());
        }
        this.aPC.adjustMoveRates();
        this.aPC.calcActiveBonuses();
        this.aPC.setDirty(false);
    }
}

